##! /bin/bash
# this file was developed by Fedora packagers
# modified by Luca Vercelli 2016 for Debian
# contains utility functions that build (small) maven projects without using maven

# expected variables:
# $REPO is a writeable, temporary, maven repository

function minibuild () {
#usage: minibuild srcfolder dependencies ext_dependencies
#we expect to find there: build.properties META-INF/MANIFEST.MF pom.xml

echo "minibuild: $1======================="

basedir=$1

src=`cat "${basedir}/build.properties" | grep 'source..' | cut -d'=' -f2 | tr ' ' '\0'`
output=`cat "${basedir}/build.properties" | grep 'output..' | cut -d'=' -f2 | tr ' ' '\0'`
bName=`cat "${basedir}/META-INF/MANIFEST.MF" | grep 'Bundle-SymbolicName:' | sed 's/Bundle-SymbolicName: \([a-zA-Z0-9_.-]*\)\(;\)\?.*/\1/'`
artifactId=`cat "${basedir}/pom.xml" | sed '/<parent>/,/<\/parent>/ d' | grep "<artifactId>" | sed 's/.*<artifactId>\(.*\)<\/artifactId>.*/\1/'`
#debian: added head -n1
version=`cat "${basedir}/pom.xml" | grep "<version>" | sed 's/.*<version>\(.*\)<\/version>.*/\1/' | head -n1`

echo "loading libraries..."

# External (System) dependencies
if [ $# -eq 3 ]; then
  mkdir -p "${basedir}/target/externalDeps"
  copyBundles $3 "${basedir}/target/externalDeps"
else
  mkdir -p "${basedir}/target"
fi

mkdir -p "${basedir}/${output}"

# Compile
cp=
if [ $# -gt 1 ]; then
  cp='-classpath '$2':'"${basedir}"'/target/externalDeps/*'
fi

echo "compiling..."

javac -Xmaxerrs 10 -d "${basedir}/${output}" \
  $(for file in `find "${basedir}/${src}" -name "*.java"`; \
    do echo -n "${file} "; \
  done;) \
  ${cp}

echo "jar..."

# Package
pushd ${basedir}
pushd ${output}
classfiles=`for file in $(find . -name "*.class"); do echo -n ' -C '${output} ${file} ; done;`
popd
packagefiles="${classfiles}"
[ -e about.html ] && packagefiles="about.html $packagefiles"
[ -e plugin.properties ] && packagefiles="plugin.properties $packagefiles"
[ -e plugin.xml ] && packagefiles="plugin.xml $packagefiles"
[ -e OSGI-INF ] && packagefiles="OSGI-INF $packagefiles"
jar -cfmv "target/${bName}-${version}.jar" 'META-INF/MANIFEST.MF' ${packagefiles}
popd

echo "install..."

# Install
loc="$REPO/org/eclipse/tycho/${artifactId}/${version}"
mkdir -p ${loc}
cp "${basedir}/target/${bName}-${version}.jar" ${loc}
cp "${basedir}/pom.xml" "${loc}/${bName}-${version}.pom"

}


function copyBundles () {
#usage: copyBundles bundlesList destDir
# scls='scl1 scl2 scl3'

echo "copyBundles to $2..."

baseLocations=( '/usr/share/java' '/usr/lib/java' '/usr/lib*/eclipse' )
osgiLocations=(${baseLocations[@]} ${osgiLocations[@]} )
for scl in ${scls} ; do
  osgiLocations=( ${baseLocations[@]/#//opt/rh/${scl}/root} ${osgiLocations[@]} )
done

#debian: this won't work because we don't have /bootstrap..

if [ ${eclipse_bootstrap} -eq 1 ]; then
	prefix="$(pwd)/bootstrap"
osgiLocations=( ${osgiLocations[@]/#/${prefix}} )
osgiLocations+=( ${osgiLocations[@]/${prefix}/} )
osgiLocations=( ${prefix}/extras ${osgiLocations[@]} )
fi

wantedBundles=`echo $1 | tr ',' ' '`
destDir=$2

#debian:
#sl4j is just used by FedoraProject-p2. FIXME
cp $REPO/org/eclipse/eclipse-bootstrap/${eclipseV}/eclipse-bootstrap-${eclipseV}.jar ${destDir}
cp $REPO/org/slf4j/slf4j-api/debian/slf4j-api-debian.jar ${destDir}
return


for loc in ${osgiLocations[@]} ; do
  for jar in `find ${loc} -name "*.jar" 2>/dev/null`; do
    bsn=`readBSN ${jar}`
    if [ -n "${bsn}" ]; then
      if echo ${wantedBundles} | grep "${bsn}" ; then
        #debian: lines moved
        versionline=`unzip -p ${jar} 'META-INF/MANIFEST.MF' | grep 'Bundle-Version:'` 2>/dev/null
        vers=`echo "${versionline}" | sed 's/Bundle-Version: \([a-zA-Z0-9_.-]*\).*/\1/'`
        cp ${jar} "${destDir}/${bsn}_${vers}.jar"
        wantedBundles=`removeFromList "${wantedBundles}" "${bsn}"`
      fi
    fi
  done
done

}

function symlinkBundles () {

# Bootstrap Built Tycho provides some Eclipse bundles
# Prevent non-bootstrap build's de-bundling from symlinking to them
# SCL priority is from right to left.
# scls='scl1 scl2 scl3'
baseLocations=( '/usr/share/java/eclipse' '/usr/share/java' '/usr/lib/java' )
osgiLocations=(${baseLocations[@]} ${osgiLocations[@]} )
for scl in ${scls} ; do
  osgiLocations=( ${baseLocations[@]/#//opt/rh/${scl}/root} ${osgiLocations[@]} )
done

echo "symlinkBundles $1..."

wantedBundles=`echo $1 | tr ',' ' '`

for loc in ${osgiLocations[@]} ; do
  for jar in `find ${loc} -name "*.jar" 2>/dev/null`; do
    bsn=`readBSN ${jar}`
    if [ -n "${bsn}" ]; then
      echo ${wantedBundles} | grep -q "${bsn}"
      if [ $? -eq 0 ]; then
        ln -s ${jar} "${bsn}.jar"
        wantedBundles=`removeFromList "${wantedBundles}" "${bsn}"`
      fi
    fi
  done
done
}

function removeFromList () {
arr=( ${1} )
for (( i=0; i < ${#arr[@]}; i++ )); do
  if [ "${arr[${i}]}" = "$2" ]; then
    arr[${i}]=
  fi
done
echo ${arr[@]}
}

function isolateProject () {
#usage: isolateProject srcfolder

echo "isolateProject $1======================="

cp $1/pom.xml $1/pom.xml.bak

sed -i '/<parent>/,/<\/parent>/ d' "$1/pom.xml"
if [ $# -eq 2 ]; then
  sed -i "/<modelVersion>/ a <groupId>org.eclipse.tycho<\/groupId><version>$2<\/version>" "$1/pom.xml"
else
  sed -i "/<modelVersion>/ a <groupId>org.eclipse.tycho<\/groupId><version>${v}<\/version>" "$1/pom.xml"
fi


}

function unifyProject () {
#usage: unifyProject srcfolder

echo "unifyProject $1========================="

cp $1/pom.xml.bak $1/pom.xml
#sed -i "/<version>${osgiV}<\/version>/ d" "$1/pom.xml"

}

function readBSN () {
#read Bundle-SymbolicName from bundle's MANIFEST.MF
#usage: readBSN fullfilename.jar

bsn=
manEntryPat="^[a-zA-Z-]*:"
foundBSNLine=0

while read line; do
if [ ${foundBSNLine} -eq 1 ]; then
  echo ${line} | grep -qE ${manEntryPat}
  if [ $? -eq 0 ]; then
    break
  else
    bsn=${bsn}"`echo ${line} | sed 's/\([a-zA-Z0-9_.-]*\)\(;\)\?.*/\1/'`"
  fi
fi

echo ${line} | grep -q "Bundle-SymbolicName:"
if [ $? -eq 0 ]; then
  bsn=`echo ${line} | grep 'Bundle-SymbolicName:' | sed 's/Bundle-SymbolicName: \([a-zA-Z0-9_.-]*\)\(;\)\?.*/\1/'`
  echo ${line} | grep "Bundle-SymbolicName:" | grep -q ";"
  if [ $? -eq 0 ]; then
    break
  fi
  foundBSNLine=1
fi
done < <(unzip -p $1 'META-INF/MANIFEST.MF')

echo ${bsn}

}
