## TFSA-2021-083: Division by zero in TFLite's implementation of `EmbeddingLookup`

### CVE Number
CVE-2021-29596

### Impact
The implementation of the `EmbeddingLookup` TFLite operator is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/e4b29809543b250bc9b19678ec4776299dd569ba/tensorflow/lite/kernels/embedding_lookup.cc#L73-L74):

```cc
const int row_size = SizeOfDimension(value, 0);
const int row_bytes = value->bytes / row_size;
```

An attacker can craft a model such that the first dimension of the `value` input
is 0.

### Patches
We have patched the issue in GitHub commit
[f61c57bd425878be108ec787f4d96390579fb83e](https://github.com/tensorflow/tensorflow/commit/f61c57bd425878be108ec787f4d96390579fb83e).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
