/*###############################################################################
# Linux Management Providers (LMP), PCI provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PCIDEVICECONNECTIONACCESS_H_
#define OPENDRIM_PCIDEVICECONNECTIONACCESS_H_

#include "PCI_Common.h"

#include "OpenDRIM_PCIDeviceConnection.h"
#include "assocOpenDRIM_PCIDeviceConnection.h"

int PCI_OpenDRIM_PCIDeviceConnection_load(const CMPIBroker* broker, string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_unload(string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PCIDeviceConnection>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIDeviceConnection_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PCIDeviceConnection& instance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIDeviceConnection& newInstance, const OpenDRIM_PCIDeviceConnection& oldInstance, const char** properties, string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIDeviceConnection& instance, string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PCIDeviceConnection& instance, string& errorMessage);

int PCI_OpenDRIM_PCIDeviceConnection_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIDeviceConnection_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIDeviceConnection_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_PCIDeviceConnection>& OpenDRIM_PCIDeviceConnection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIDeviceConnection_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_PCIDeviceConnection>& OpenDRIM_PCIDeviceConnection_instances, const char** properties, string& errorMessage, const string& discriminant);

int PCI_OpenDRIM_PCIDeviceConnection_populate(OpenDRIM_PCIDeviceConnection& instance, string& errorMessage);

#endif /*OPENDRIM_PCIDEVICECONNECTIONACCESS_H_*/
