/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.jaxp13;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Validator {
    private final String schemaLanguage;
    private final SchemaFactory factory;
    private final ArrayList sources = new ArrayList();

    public Validator() {
        this("http://www.w3.org/2001/XMLSchema", null);
    }

    public Validator(String schemaLanguage) {
        this(schemaLanguage, null);
    }

    public Validator(SchemaFactory factory) {
        this(null, factory);
    }

    protected Validator(String schemaLanguage, SchemaFactory factory) {
        this.schemaLanguage = schemaLanguage;
        this.factory = factory;
    }

    public void addSchemaSource(Source s) {
        this.sources.add(s);
    }

    public boolean isSchemaValid() {
        return this.getSchemaErrors().size() == 0;
    }

    public List getSchemaErrors() {
        ArrayList<SAXException> l;
        block2: {
            l = new ArrayList<SAXException>();
            try {
                this.parseSchema(new CollectingErrorHandler(l));
            }
            catch (SAXException e) {
                if (l.size() != 0) break block2;
                l.add(e);
            }
        }
        return l;
    }

    public boolean isInstanceValid(Source instance) throws XMLUnitRuntimeException {
        return this.getInstanceErrors(instance).size() == 0;
    }

    public List getInstanceErrors(Source instance) throws XMLUnitRuntimeException {
        Schema schema = null;
        try {
            schema = this.parseSchema(null);
        }
        catch (SAXException e) {
            throw new XMLUnitRuntimeException("Schema is invalid", e);
        }
        ArrayList<SAXException> l = new ArrayList<SAXException>();
        javax.xml.validation.Validator v = schema.newValidator();
        v.setErrorHandler(new CollectingErrorHandler(l));
        try {
            v.validate(instance);
        }
        catch (SAXException e) {
            if (l.size() == 0) {
                l.add(e);
            }
        }
        catch (IOException i) {
            throw new XMLUnitRuntimeException("Error reading instance source", i);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema parseSchema(ErrorHandler h) throws SAXException {
        SchemaFactory fac = this.factory != null ? this.factory : SchemaFactory.newInstance(this.schemaLanguage);
        fac.setErrorHandler(h);
        try {
            Schema schema = fac.newSchema(this.sources.toArray(new Source[this.sources.size()]));
            return schema;
        }
        finally {
            fac.setErrorHandler(null);
        }
    }

    private static final class CollectingErrorHandler
    implements ErrorHandler {
        private final List l;

        CollectingErrorHandler(List l) {
            this.l = l;
        }

        public void error(SAXParseException e) {
            this.l.add(e);
        }

        public void fatalError(SAXParseException e) {
            this.l.add(e);
        }

        public void warning(SAXParseException e) {
            this.l.add(e);
        }
    }
}

