/* $Id: glue-png.h,v 1.7 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_PNG_H_INCLUDED
#define __GLUE_PNG_H_INCLUDED

#include <stdbool.h>
#include <inttypes.h>

/** transparent alpha value */
#define ALPHA_TRANSPARENT	0x00
/** opaque alpha value */
#define ALPHA_OPAQUE		0xFF

/** determine the alpha value of a pixel */
#define GET_ALPHA(pixel) (pixel >> 24)
/** determine the blue value of a pixel */
#define GET_BLUE(pixel) ((pixel >> 16) & 0xFF)
/** determine the green value of a pixel */
#define GET_GREEN(pixel) ((pixel >> 8) & 0xFF)
/** determinne the red value of a pixel */
#define GET_RED(pixel) (pixel & 0xFF)

/** Read the png file filename into dest, setting w (width) and h (height) 
 *  accordingly.
 *  Each pixel (uint32_t) is in the form ARGB, 8 Bit depth.
 *  @param dest pointer to the destination of the image. *dest will get
 *         malloc'ed during loading, caller should free it.
 *  @param w return value of the width of the image (in pixel).
 *  @param h return value of the height of the image (in pixel).
 *  @return true, if loading succeeded, false otherwise.
 */
extern bool
png_read(
	uint32_t **dest, 
	unsigned int *w,
	unsigned int *h,
	const char* filename
);

/** Write an area from a pixel buffer into the file called filename.
 *  Source has to be an array of raw pixels (in ARGB form, 4 bytes/pixel) with
 *  the dimensions (w/h). The rectangle area with the top left corner (x/y) and
 *  the bottom right cornern (x+dw, y+dh) will get written into the png 
 *  file.
 *  @param source soure buffer filled with ARGB pixels.
 *  @param w pixel width of the source buffer.
 *  @param h pixel height of the source buffer.
 *  @param x x offset of the area to write.
 *  @param y y offset of the area to write.
 *  @param dw width of the area to write.
 *  @param dh height of the area to write.
 */
extern void
png_write(
	const uint32_t *source,
	unsigned int w,
	unsigned int h,
	unsigned int x, 
	unsigned int y,
	unsigned int dw,
	unsigned int dh,
	const char *filename
);

#endif /* __GLUE_PNG_H_INCLUDED */
