-- $Id$ 

-- test for array types

-- Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

package t is 
	-- shouldn't result in a type
	type word is array(integer range <>) of bit;
	-- shouldn't result in a type
	type memory is array(integer range <>) of word(31 downto 0);
	-- should result in a type
	type dram8k is array(0 to (8192 / 4) - 1) of word(31 downto 0);
	-- should result in a type
	type membanks is array(1 to 4) of memory(0 to (8192 / 4) - 1);
end package t;

entity test_bench is
end entity test_bench;

use t.all;
architecture test_bench_impl of test_bench is
begin
	x : process
		variable ram : dram8k;
		variable ram2 : memory(0 to (256 / 4) - 1);
	begin
		for i in 1 to 10 loop
			ram2(i)(1) := '1';
		end loop;
		for i in 1 to 10 loop
			assert ram2(i)(1) = '1' 
				report "array assign fail"
				severity failure;
		end loop;
		assert false report "simulation finished" severity note;
		wait;
	end process;
end test_bench_impl;
