/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.driver.JListCellCenterQuery;
import org.fest.swing.driver.JListItemIndexValidator;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.Pair;
import org.fest.swing.util.TextMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JListScrollToItemTask {
    static final Pair<Integer, Point> ITEM_NOT_FOUND = new Pair<Integer, Object>(-1, null);

    @RunsInEDT
    static Point scrollToItem(final JList list, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(list);
                JListItemIndexValidator.validateIndex(list, index);
                return JListScrollToItemTask.scrollToItemWithIndex(list, index);
            }
        });
    }

    @RunsInEDT
    static Pair<Integer, Point> scrollToItem(final JList list, final TextMatcher matcher, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return new Pair<Integer, Point>(index, JListScrollToItemTask.scrollToItemWithIndex(list, index));
            }
        });
    }

    @RunsInEDT
    static Pair<Integer, Point> scrollToItemIfNotSelectedYet(final JList list, final TextMatcher matcher, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Integer, Point>>(){

            @Override
            protected Pair<Integer, Point> executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(list);
                int index = JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
                if (index < 0) {
                    return ITEM_NOT_FOUND;
                }
                return new Pair<Integer, Point>(index, JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index));
            }
        });
    }

    @RunsInEDT
    static Point scrollToItemIfNotSelectedYet(final JList list, final int index) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(list);
                JListItemIndexValidator.validateIndex(list, index);
                return JListScrollToItemTask.scrollToItemWithIndexIfNotSelectedYet(list, index);
            }
        });
    }

    @RunsInCurrentThread
    private static Point scrollToItemWithIndexIfNotSelectedYet(JList list, int index) {
        if (list.getSelectedIndex() == index) {
            return null;
        }
        return JListScrollToItemTask.scrollToItemWithIndex(list, index);
    }

    @RunsInCurrentThread
    private static Point scrollToItemWithIndex(JList list, int index) {
        Rectangle cellBounds = JListCellBoundsQuery.cellBounds(list, index);
        list.scrollRectToVisible(cellBounds);
        return JListCellCenterQuery.cellCenter(list, cellBounds);
    }

    private JListScrollToItemTask() {
    }
}

