/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

public class SequenceComplexity {
    public static boolean[] findBasesInShortUnitRepeats(byte[] bases, int maxRepeatUnitLength, int minRepeatLengthInUnits) {
        int i;
        boolean[] result = new boolean[bases.length];
        int[] repeatAbsoluteLengthCount = new int[maxRepeatUnitLength];
        for (i = 0; i < maxRepeatUnitLength; ++i) {
            repeatAbsoluteLengthCount[i] = i + 1;
        }
        for (i = 0; i < bases.length; ++i) {
            for (int j = 1; j <= maxRepeatUnitLength; ++j) {
                int prevI = i - j;
                if (prevI < 0) continue;
                if (bases[prevI] == bases[i]) {
                    int n = j - 1;
                    repeatAbsoluteLengthCount[n] = repeatAbsoluteLengthCount[n] + 1;
                    continue;
                }
                if (minRepeatLengthInUnits <= repeatAbsoluteLengthCount[j - 1] / j) {
                    for (int k = i - repeatAbsoluteLengthCount[j - 1]; k < i; ++k) {
                        result[k] = true;
                    }
                    repeatAbsoluteLengthCount[j - 1] = j;
                    continue;
                }
                repeatAbsoluteLengthCount[j - 1] = j;
            }
        }
        for (int j = 1; j <= maxRepeatUnitLength; ++j) {
            if (minRepeatLengthInUnits > repeatAbsoluteLengthCount[j - 1] / j) continue;
            for (int k = bases.length - repeatAbsoluteLengthCount[j - 1]; k < bases.length; ++k) {
                result[k] = true;
            }
        }
        return result;
    }
}

