/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.annotation.TypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypePathInfo;
import proguard.classfile.attribute.annotation.target.CatchTargetInfo;
import proguard.classfile.attribute.annotation.target.EmptyTargetInfo;
import proguard.classfile.attribute.annotation.target.FormalParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetElement;
import proguard.classfile.attribute.annotation.target.LocalVariableTargetInfo;
import proguard.classfile.attribute.annotation.target.OffsetTargetInfo;
import proguard.classfile.attribute.annotation.target.SuperTypeTargetInfo;
import proguard.classfile.attribute.annotation.target.ThrowsTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeArgumentTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterBoundTargetInfo;
import proguard.classfile.attribute.annotation.target.TypeParameterTargetInfo;
import proguard.classfile.attribute.annotation.target.visitor.LocalVariableTargetElementVisitor;
import proguard.classfile.attribute.annotation.target.visitor.TargetInfoVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.annotation.visitor.TypeAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.TypePathInfoVisitor;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.PrimitiveArrayConstantElementVisitor;
import proguard.classfile.io.RuntimeDataOutput;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ProgramClassWriter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor {
    private RuntimeDataOutput dataOutput;
    private final ConstantBodyWriter constantBodyWriter = new ConstantBodyWriter();
    private final AttributeBodyWriter attributeBodyWriter = new AttributeBodyWriter();
    private final StackMapFrameBodyWriter stackMapFrameBodyWriter = new StackMapFrameBodyWriter();
    private final VerificationTypeBodyWriter verificationTypeBodyWriter = new VerificationTypeBodyWriter();
    private final ElementValueBodyWriter elementValueBodyWriter = new ElementValueBodyWriter();

    public ProgramClassWriter(DataOutput dataOutput) {
        this.dataOutput = new RuntimeDataOutput(dataOutput);
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.dataOutput.writeInt(-889275714);
        this.dataOutput.writeShort(ClassUtil.internalMinorClassVersion(programClass.u4version));
        this.dataOutput.writeShort(ClassUtil.internalMajorClassVersion(programClass.u4version));
        this.dataOutput.writeUnsignedShort(programClass.u2constantPoolCount);
        programClass.constantPoolEntriesAccept(this);
        this.dataOutput.writeUnsignedShort(programClass.u2accessFlags & 0xFFFF);
        this.dataOutput.writeUnsignedShort(programClass.u2thisClass);
        this.dataOutput.writeUnsignedShort(programClass.u2superClass);
        this.dataOutput.writeUnsignedShort(programClass.u2interfacesCount);
        for (int i = 0; i < programClass.u2interfacesCount; ++i) {
            this.dataOutput.writeUnsignedShort(programClass.u2interfaces[i]);
        }
        this.dataOutput.writeUnsignedShort(programClass.u2fieldsCount);
        programClass.fieldsAccept(this);
        this.dataOutput.writeUnsignedShort(programClass.u2methodsCount);
        programClass.methodsAccept(this);
        this.dataOutput.writeUnsignedShort(programClass.u2attributesCount);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.dataOutput.writeUnsignedShort(programField.u2accessFlags & 0xFFFF);
        this.dataOutput.writeUnsignedShort(programField.u2nameIndex);
        this.dataOutput.writeUnsignedShort(programField.u2descriptorIndex);
        this.dataOutput.writeUnsignedShort(programField.u2attributesCount);
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.dataOutput.writeUnsignedShort(programMethod.u2accessFlags & 0xFFFF);
        this.dataOutput.writeUnsignedShort(programMethod.u2nameIndex);
        this.dataOutput.writeUnsignedShort(programMethod.u2descriptorIndex);
        this.dataOutput.writeUnsignedShort(programMethod.u2attributesCount);
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.dataOutput.writeByte(constant.getTag());
        constant.accept(clazz, this.constantBodyWriter);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.dataOutput.writeUnsignedShort(attribute.u2attributeNameIndex);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RuntimeDataOutput runtimeDataOutput = this.dataOutput;
        this.dataOutput = new RuntimeDataOutput(new DataOutputStream(byteArrayOutputStream));
        attribute.accept(clazz, null, null, this.attributeBodyWriter);
        this.dataOutput = runtimeDataOutput;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.dataOutput.writeInt(byArray.length);
        this.dataOutput.write(byArray);
    }

    private class ElementValueBodyWriter
    extends SimplifiedVisitor
    implements ElementValueVisitor {
        private ElementValueBodyWriter() {
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(constantElementValue.u2constantValueIndex);
        }

        @Override
        public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(enumConstantElementValue.u2typeNameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(enumConstantElementValue.u2constantNameIndex);
        }

        @Override
        public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(classElementValue.u2classInfoIndex);
        }

        @Override
        public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
            ProgramClassWriter.this.attributeBodyWriter.visitAnnotation(clazz, annotationElementValue.annotationValue);
        }

        @Override
        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(arrayElementValue.u2elementValuesCount);
            arrayElementValue.elementValuesAccept(clazz, annotation, ProgramClassWriter.this.attributeBodyWriter);
        }
    }

    private class VerificationTypeBodyWriter
    extends SimplifiedVisitor
    implements VerificationTypeVisitor {
        private VerificationTypeBodyWriter() {
        }

        @Override
        public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
        }

        @Override
        public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ObjectType objectType) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(objectType.u2classIndex);
        }

        @Override
        public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, UninitializedType uninitializedType) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(uninitializedType.u2newInstructionOffset);
        }
    }

    private class StackMapFrameBodyWriter
    extends SimplifiedVisitor
    implements StackMapFrameVisitor,
    VerificationTypeVisitor {
        private StackMapFrameBodyWriter() {
        }

        @Override
        public void visitSameZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameZeroFrame sameZeroFrame) {
            if (sameZeroFrame.getTag() == 251) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(sameZeroFrame.u2offsetDelta);
            }
        }

        @Override
        public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SameOneFrame sameOneFrame) {
            if (sameOneFrame.getTag() == 247) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(sameOneFrame.u2offsetDelta);
            }
            sameOneFrame.stackItemAccept(clazz, method, codeAttribute, n, this);
        }

        @Override
        public void visitLessZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LessZeroFrame lessZeroFrame) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(lessZeroFrame.u2offsetDelta);
        }

        @Override
        public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, MoreZeroFrame moreZeroFrame) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moreZeroFrame.u2offsetDelta);
            moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, n, this);
        }

        @Override
        public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, FullFrame fullFrame) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(fullFrame.u2offsetDelta);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(fullFrame.variablesCount);
            fullFrame.variablesAccept(clazz, method, codeAttribute, n, this);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(fullFrame.stackCount);
            fullFrame.stackAccept(clazz, method, codeAttribute, n, this);
        }

        @Override
        public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VerificationType verificationType) {
            ProgramClassWriter.this.dataOutput.writeByte(verificationType.getTag());
            verificationType.accept(clazz, method, codeAttribute, n, ProgramClassWriter.this.verificationTypeBodyWriter);
        }
    }

    private class AttributeBodyWriter
    extends SimplifiedVisitor
    implements AttributeVisitor,
    BootstrapMethodInfoVisitor,
    InnerClassesInfoVisitor,
    ExceptionInfoVisitor,
    StackMapFrameVisitor,
    VerificationTypeVisitor,
    LineNumberInfoVisitor,
    ParameterInfoVisitor,
    LocalVariableInfoVisitor,
    LocalVariableTypeInfoVisitor,
    RequiresInfoVisitor,
    ExportsInfoVisitor,
    OpensInfoVisitor,
    ProvidesInfoVisitor,
    AnnotationVisitor,
    TypeAnnotationVisitor,
    TargetInfoVisitor,
    TypePathInfoVisitor,
    LocalVariableTargetElementVisitor,
    ElementValueVisitor {
        private AttributeBodyWriter() {
        }

        @Override
        public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
            ProgramClassWriter.this.dataOutput.write(unknownAttribute.info);
        }

        @Override
        public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(bootstrapMethodsAttribute.u2bootstrapMethodsCount);
            bootstrapMethodsAttribute.bootstrapMethodEntriesAccept(clazz, this);
        }

        @Override
        public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(sourceFileAttribute.u2sourceFileIndex);
        }

        @Override
        public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(sourceDirAttribute.u2sourceDirIndex);
        }

        @Override
        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(innerClassesAttribute.u2classesCount);
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        }

        @Override
        public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(enclosingMethodAttribute.u2classIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(enclosingMethodAttribute.u2nameAndTypeIndex);
        }

        @Override
        public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2moduleNameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2moduleFlags);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2moduleVersionIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2requiresCount);
            moduleAttribute.requiresAccept(clazz, this);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2exportsCount);
            moduleAttribute.exportsAccept(clazz, this);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2opensCount);
            moduleAttribute.opensAccept(clazz, this);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2usesCount);
            for (int i = 0; i < moduleAttribute.u2usesCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2uses[i]);
            }
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleAttribute.u2providesCount);
            moduleAttribute.providesAccept(clazz, this);
        }

        @Override
        public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleMainClassAttribute.u2mainClass);
        }

        @Override
        public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(modulePackagesAttribute.u2packagesCount);
            for (int i = 0; i < modulePackagesAttribute.u2packagesCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(modulePackagesAttribute.u2packages[i]);
            }
        }

        @Override
        public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        }

        @Override
        public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        }

        @Override
        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(signatureAttribute.u2signatureIndex);
        }

        @Override
        public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(constantValueAttribute.u2constantValueIndex);
        }

        @Override
        public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
            ProgramClassWriter.this.dataOutput.writeByte(methodParametersAttribute.u1parametersCount);
            methodParametersAttribute.parametersAccept(clazz, method, this);
        }

        @Override
        public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionsAttribute.u2exceptionIndexTableLength);
            for (int i = 0; i < exceptionsAttribute.u2exceptionIndexTableLength; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionsAttribute.u2exceptionIndexTable[i]);
            }
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(codeAttribute.u2maxStack);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(codeAttribute.u2maxLocals);
            ProgramClassWriter.this.dataOutput.writeInt(codeAttribute.u4codeLength);
            ProgramClassWriter.this.dataOutput.write(codeAttribute.code, 0, codeAttribute.u4codeLength);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(codeAttribute.u2exceptionTableLength);
            codeAttribute.exceptionsAccept(clazz, method, this);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(codeAttribute.u2attributesCount);
            codeAttribute.attributesAccept(clazz, method, ProgramClassWriter.this);
        }

        @Override
        public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(stackMapAttribute.u2stackMapFramesCount);
            stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, ProgramClassWriter.this.stackMapFrameBodyWriter);
        }

        @Override
        public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(stackMapTableAttribute.u2stackMapFramesCount);
            stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(lineNumberTableAttribute.u2lineNumberTableLength);
            lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTableAttribute.u2localVariableTableLength);
            localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeTableAttribute.u2localVariableTypeTableLength);
            localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(requiresInfo.u2requiresIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(requiresInfo.u2requiresFlags);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(requiresInfo.u2requiresVersionIndex);
        }

        @Override
        public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exportsInfo.u2exportsIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exportsInfo.u2exportsFlags);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exportsInfo.u2exportsToCount);
            for (int i = 0; i < exportsInfo.u2exportsToCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(exportsInfo.u2exportsToIndex[i]);
            }
        }

        @Override
        public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(opensInfo.u2opensIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(opensInfo.u2opensFlags);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(opensInfo.u2opensToCount);
            for (int i = 0; i < opensInfo.u2opensToCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(opensInfo.u2opensToIndex[i]);
            }
        }

        @Override
        public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(providesInfo.u2providesIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(providesInfo.u2providesWithCount);
            for (int i = 0; i < providesInfo.u2providesWithCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(providesInfo.u2providesWithIndex[i]);
            }
        }

        @Override
        public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(annotationsAttribute.u2annotationsCount);
            annotationsAttribute.annotationsAccept(clazz, this);
        }

        @Override
        public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
            ProgramClassWriter.this.dataOutput.writeByte(parameterAnnotationsAttribute.u1parametersCount);
            for (int i = 0; i < parameterAnnotationsAttribute.u1parametersCount; ++i) {
                int n = parameterAnnotationsAttribute.u2parameterAnnotationsCount[i];
                Annotation[] annotationArray = parameterAnnotationsAttribute.parameterAnnotations[i];
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(n);
                for (int j = 0; j < n; ++j) {
                    this.visitAnnotation(clazz, annotationArray[j]);
                }
            }
        }

        @Override
        public void visitAnyTypeAnnotationsAttribute(Clazz clazz, TypeAnnotationsAttribute typeAnnotationsAttribute) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(typeAnnotationsAttribute.u2annotationsCount);
            typeAnnotationsAttribute.typeAnnotationsAccept(clazz, this);
        }

        @Override
        public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
            annotationDefaultAttribute.defaultValue.accept(clazz, null, this);
        }

        @Override
        public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(bootstrapMethodInfo.u2methodHandleIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(bootstrapMethodInfo.u2methodArgumentCount);
            for (int i = 0; i < bootstrapMethodInfo.u2methodArgumentCount; ++i) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(bootstrapMethodInfo.u2methodArguments[i]);
            }
        }

        @Override
        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(innerClassesInfo.u2innerClassIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(innerClassesInfo.u2outerClassIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(innerClassesInfo.u2innerNameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(innerClassesInfo.u2innerClassAccessFlags);
        }

        @Override
        public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionInfo.u2endPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionInfo.u2handlerPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(exceptionInfo.u2catchType);
        }

        @Override
        public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, StackMapFrame stackMapFrame) {
            ProgramClassWriter.this.dataOutput.writeByte(stackMapFrame.getTag());
            stackMapFrame.accept(clazz, method, codeAttribute, n, ProgramClassWriter.this.stackMapFrameBodyWriter);
        }

        @Override
        public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(lineNumberInfo.u2startPC > 65535 ? 0 : lineNumberInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(lineNumberInfo.u2lineNumber > 65535 ? 0 : lineNumberInfo.u2lineNumber);
        }

        @Override
        public void visitParameterInfo(Clazz clazz, Method method, int n, ParameterInfo parameterInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(parameterInfo.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(parameterInfo.u2accessFlags);
        }

        @Override
        public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableInfo.u2length);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableInfo.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableInfo.u2descriptorIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableInfo.u2index);
        }

        @Override
        public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeInfo.u2startPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeInfo.u2length);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeInfo.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeInfo.u2signatureIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTypeInfo.u2index);
        }

        @Override
        public void visitAnnotation(Clazz clazz, Annotation annotation) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(annotation.u2typeIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(annotation.u2elementValuesCount);
            annotation.elementValuesAccept(clazz, this);
        }

        @Override
        public void visitTypeAnnotation(Clazz clazz, TypeAnnotation typeAnnotation) {
            ProgramClassWriter.this.dataOutput.writeByte(typeAnnotation.targetInfo.u1targetType);
            typeAnnotation.targetInfoAccept(clazz, this);
            ProgramClassWriter.this.dataOutput.writeByte(typeAnnotation.typePath.length);
            typeAnnotation.typePathInfosAccept(clazz, this);
            this.visitAnnotation(clazz, typeAnnotation);
        }

        @Override
        public void visitTypeParameterTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterTargetInfo typeParameterTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeByte(typeParameterTargetInfo.u1typeParameterIndex);
        }

        @Override
        public void visitSuperTypeTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, SuperTypeTargetInfo superTypeTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(superTypeTargetInfo.u2superTypeIndex);
        }

        @Override
        public void visitTypeParameterBoundTargetInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypeParameterBoundTargetInfo typeParameterBoundTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeByte(typeParameterBoundTargetInfo.u1typeParameterIndex);
            ProgramClassWriter.this.dataOutput.writeByte(typeParameterBoundTargetInfo.u1boundIndex);
        }

        @Override
        public void visitEmptyTargetInfo(Clazz clazz, Member member, TypeAnnotation typeAnnotation, EmptyTargetInfo emptyTargetInfo) {
        }

        @Override
        public void visitFormalParameterTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, FormalParameterTargetInfo formalParameterTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeByte(formalParameterTargetInfo.u1formalParameterIndex);
        }

        @Override
        public void visitThrowsTargetInfo(Clazz clazz, Method method, TypeAnnotation typeAnnotation, ThrowsTargetInfo throwsTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(throwsTargetInfo.u2throwsTypeIndex);
        }

        @Override
        public void visitLocalVariableTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTargetInfo.u2tableLength);
            localVariableTargetInfo.targetElementsAccept(clazz, method, codeAttribute, typeAnnotation, this);
        }

        @Override
        public void visitCatchTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, CatchTargetInfo catchTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(catchTargetInfo.u2exceptionTableIndex);
        }

        @Override
        public void visitOffsetTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, OffsetTargetInfo offsetTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(offsetTargetInfo.u2offset);
        }

        @Override
        public void visitTypeArgumentTargetInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, TypeArgumentTargetInfo typeArgumentTargetInfo) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(typeArgumentTargetInfo.u2offset);
            ProgramClassWriter.this.dataOutput.writeByte(typeArgumentTargetInfo.u1typeArgumentIndex);
        }

        @Override
        public void visitTypePathInfo(Clazz clazz, TypeAnnotation typeAnnotation, TypePathInfo typePathInfo) {
            ProgramClassWriter.this.dataOutput.writeByte(typePathInfo.u1typePathKind);
            ProgramClassWriter.this.dataOutput.writeByte(typePathInfo.u1typeArgumentIndex);
        }

        @Override
        public void visitLocalVariableTargetElement(Clazz clazz, Method method, CodeAttribute codeAttribute, TypeAnnotation typeAnnotation, LocalVariableTargetInfo localVariableTargetInfo, LocalVariableTargetElement localVariableTargetElement) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTargetElement.u2startPC);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTargetElement.u2length);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(localVariableTargetElement.u2index);
        }

        @Override
        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
            int n = elementValue.u2elementNameIndex;
            if (n != 0) {
                ProgramClassWriter.this.dataOutput.writeUnsignedShort(n);
            }
            ProgramClassWriter.this.dataOutput.writeByte(elementValue.getTag());
            elementValue.accept(clazz, annotation, ProgramClassWriter.this.elementValueBodyWriter);
        }
    }

    private class ConstantBodyWriter
    extends SimplifiedVisitor
    implements ConstantVisitor,
    PrimitiveArrayConstantElementVisitor {
        private ConstantBodyWriter() {
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            ProgramClassWriter.this.dataOutput.writeInt(integerConstant.u4value);
        }

        @Override
        public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
            ProgramClassWriter.this.dataOutput.writeLong(longConstant.u8value);
        }

        @Override
        public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
            ProgramClassWriter.this.dataOutput.writeFloat(floatConstant.f4value);
        }

        @Override
        public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
            ProgramClassWriter.this.dataOutput.writeDouble(doubleConstant.f8value);
        }

        @Override
        public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
            char c = primitiveArrayConstant.getPrimitiveType();
            int n = primitiveArrayConstant.getLength();
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(c);
            ProgramClassWriter.this.dataOutput.writeInt(n);
            primitiveArrayConstant.primitiveArrayElementsAccept(clazz, this);
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(stringConstant.u2stringIndex);
        }

        @Override
        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            byte[] byArray = utf8Constant.getBytes();
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(byArray.length);
            ProgramClassWriter.this.dataOutput.write(byArray);
        }

        @Override
        public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(invokeDynamicConstant.u2bootstrapMethodAttributeIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(invokeDynamicConstant.u2nameAndTypeIndex);
        }

        @Override
        public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
            ProgramClassWriter.this.dataOutput.writeByte(methodHandleConstant.u1referenceKind);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(methodHandleConstant.u2referenceIndex);
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(refConstant.u2classIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(refConstant.u2nameAndTypeIndex);
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(classConstant.u2nameIndex);
        }

        @Override
        public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(methodTypeConstant.u2descriptorIndex);
        }

        @Override
        public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(nameAndTypeConstant.u2nameIndex);
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(nameAndTypeConstant.u2descriptorIndex);
        }

        @Override
        public void visitBooleanArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, boolean bl) {
            ProgramClassWriter.this.dataOutput.writeBoolean(bl);
        }

        @Override
        public void visitByteArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, byte by) {
            ProgramClassWriter.this.dataOutput.writeByte(by);
        }

        @Override
        public void visitCharArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, char c) {
            ProgramClassWriter.this.dataOutput.writeChar(c);
        }

        @Override
        public void visitShortArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, short s) {
            ProgramClassWriter.this.dataOutput.writeShort(s);
        }

        @Override
        public void visitIntArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, int n2) {
            ProgramClassWriter.this.dataOutput.writeInt(n2);
        }

        @Override
        public void visitFloatArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, float f) {
            ProgramClassWriter.this.dataOutput.writeFloat(f);
        }

        @Override
        public void visitLongArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, long l) {
            ProgramClassWriter.this.dataOutput.writeLong(l);
        }

        @Override
        public void visitDoubleArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int n, double d) {
            ProgramClassWriter.this.dataOutput.writeDouble(d);
        }

        @Override
        public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(moduleConstant.u2nameIndex);
        }

        @Override
        public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
            ProgramClassWriter.this.dataOutput.writeUnsignedShort(packageConstant.u2nameIndex);
        }
    }
}

