/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;

final class JListCellCenterQuery {
    @RunsInCurrentThread
    static Point cellCenter(JList list, Rectangle cellBounds) {
        Point cellCenter = AWT.centerOf(cellBounds);
        Point translatedCellCenter = AWT.translate(list, cellCenter.x, cellCenter.y);
        int listVisibleWidth = list.getVisibleRect().width;
        if (translatedCellCenter.x < listVisibleWidth) {
            return cellCenter;
        }
        Point listCenter = AWT.centerOfVisibleRect(list);
        return new Point(listCenter.x, cellCenter.y);
    }

    private JListCellCenterQuery() {
    }
}

