function getMostRecentWindow () {
    var mediator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
	.getService(Components.interfaces.nsIWindowMediator);
    return mediator.getMostRecentWindow("navigator:browser");
}

function createCanvasElement (width, height) {
    var recentWindow = getMostRecentWindow();
    var canvas = recentWindow.document.createElementNS("http://www.w3.org/1999/xhtml",
						       "canvas");
    
    canvas.width = width;
    canvas.height = height;
    
    return canvas;
}

UnityPreviewUtils = {
    getPreviewForWindow: function (window) {
	while (window.parent != window) {
	    window = window.parent;
	}

	var width = window.innerWidth;
	var height = window.innerHeight;

	var canvas = createCanvasElement (width, height);
	var ctx = canvas.getContext('2d');
	
	ctx.drawWindow (window, 0, 0, width, height, "rgb(255,255,255)");
	
	return canvas.toDataURL();
    }
}

var EXPORTED_SYMBOLS = [ "UnityPreviewUtils" ]
