#ifndef MY_REGEX_INCLUDED
#define MY_REGEX_INCLUDED

/* ========= begin header generated by ./mkh ========= */

#include "m_ctype.h"

#ifdef __cplusplus
extern "C" {
#endif

/* === regex2.h === */
#ifdef _WIN64
typedef __int64 my_regoff_t;
#else
typedef off_t my_regoff_t;
#endif
struct re_guts;			/* none of your business :-) */
typedef struct {
	int re_magic;
	size_t re_nsub;		/* number of parenthesized subexpressions */
	const char *re_endp;	/* end pointer for MY_REG_PEND */
	struct re_guts *re_g;	/* none of your business :-) */
	const CHARSET_INFO *charset;	/* For ctype things */
} my_regex_t;
typedef struct {
	my_regoff_t rm_so;		/* start of match */
	my_regoff_t rm_eo;		/* end of match */
} my_regmatch_t;


/* === regcomp.c === */
typedef int (*my_regex_stack_check_t)(int);
extern int my_regcomp(my_regex_t *, const char *, int,
                      const CHARSET_INFO *charset);
#define	MY_REG_BASIC	0000
#define	MY_REG_EXTENDED	0001
#define	MY_REG_ICASE	0002
#define	MY_REG_NOSUB	0004
#define	MY_REG_NEWLINE	0010
#define	MY_REG_NOSPEC	0020
#define	MY_REG_PEND	0040
#define	MY_REG_DUMP	0200


/* === regerror.c === */
#define	MY_REG_NOMATCH	 1
#define	MY_REG_BADPAT	 2
#define	MY_REG_ECOLLATE	 3
#define	MY_REG_ECTYPE	 4
#define	MY_REG_EESCAPE	 5
#define	MY_REG_ESUBREG	 6
#define	MY_REG_EBRACK	 7
#define	MY_REG_EPAREN	 8
#define	MY_REG_EBRACE	 9
#define	MY_REG_BADBR	10
#define	MY_REG_ERANGE	11
#define	MY_REG_ESPACE	12
#define	MY_REG_BADRPT	13
#define	MY_REG_EMPTY	14
#define	MY_REG_ASSERT	15
#define	MY_REG_INVARG	16
#define	MY_REG_ATOI	255	/* convert name to number (!) */
#define	MY_REG_ITOA	0400	/* convert number to name (!) */
extern size_t my_regerror(int, const my_regex_t *, char *, size_t);


/* === regexec.c === */
extern int my_regexec(const my_regex_t *, const char *, size_t, my_regmatch_t [], int);
#define	MY_REG_NOTBOL	00001
#define	MY_REG_NOTEOL	00002
#define	MY_REG_STARTEND	00004
#define	MY_REG_TRACE	00400	/* tracing of execution */
#define	MY_REG_LARGE	01000	/* force large representation */
#define	MY_REG_BACKR	02000	/* force use of backref code */


/* === regfree.c === */
extern void my_regfree(my_regex_t *);

/* === reginit.c === */

/* Should be called for multithread progs */
extern void my_regex_init(const CHARSET_INFO *cs,
                          my_regex_stack_check_t func);
extern void my_regex_end(void);	/* If one wants a clean end */

#ifdef __cplusplus
}
#endif
/* ========= end header generated by ./mkh ========= */

#endif  // MY_REGEX_INCLUDED
