/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <algorithm>

#include <libwpd-stream/libwpd-stream.h>

#include "EBOOKMemoryStream.h"

#include "EBOOKMemoryStreamTest.h"

using libebook::EBOOKMemoryStream;

namespace test
{

void EBOOKMemoryStreamTest::setUp()
{
}

void EBOOKMemoryStreamTest::tearDown()
{
}

void EBOOKMemoryStreamTest::testRead()
{
  const unsigned char data[] = "abc dee fgh";
  EBOOKMemoryStream strm(data, sizeof(data));

  CPPUNIT_ASSERT_MESSAGE("stream is already exhausted before starting to read", !strm.atEOS());

  for (int i = 0; sizeof(data) != i; ++i)
  {
    unsigned long readBytes = 0;
    const unsigned char *s = strm.read(1, readBytes);

    CPPUNIT_ASSERT(1 == readBytes);
    CPPUNIT_ASSERT_EQUAL(data[i], s[0]);
    CPPUNIT_ASSERT(((sizeof(data) - 1) == i) || !strm.atEOS());
  }

  CPPUNIT_ASSERT_MESSAGE("reading did not exhaust the stream", strm.atEOS());

  strm.seek(0, WPX_SEEK_SET);

  unsigned long readBytes = 0;
  const unsigned char *s = strm.read(sizeof(data), readBytes);
  CPPUNIT_ASSERT(sizeof(data) == readBytes);
  CPPUNIT_ASSERT(std::equal(data, data + sizeof(data), s));
}

void EBOOKMemoryStreamTest::testSeek()
{
  const unsigned char data[] = "abc dee fgh";
  EBOOKMemoryStream strm(data, sizeof(data));

  strm.seek(0, WPX_SEEK_SET);
  CPPUNIT_ASSERT(0 == strm.tell());
  strm.seek(2, WPX_SEEK_SET);
  CPPUNIT_ASSERT(2 == strm.tell());

  strm.seek(1, WPX_SEEK_CUR);
  CPPUNIT_ASSERT(3 == strm.tell());
  strm.seek(-2, WPX_SEEK_CUR);
  CPPUNIT_ASSERT(1 == strm.tell());

  CPPUNIT_ASSERT(!strm.atEOS());
  CPPUNIT_ASSERT(0 == strm.seek(0, WPX_SEEK_END));
  CPPUNIT_ASSERT(strm.atEOS());
  CPPUNIT_ASSERT(sizeof(data) == strm.tell());
  CPPUNIT_ASSERT(0 != strm.seek(1, WPX_SEEK_END)); // cannot seek after the end
  CPPUNIT_ASSERT(strm.atEOS());
  CPPUNIT_ASSERT(0 == strm.seek(-1, WPX_SEEK_END)); // but can seek before it
  CPPUNIT_ASSERT(!strm.atEOS());
  CPPUNIT_ASSERT((sizeof(data) - 1) == strm.tell());
}

CPPUNIT_TEST_SUITE_REGISTRATION(EBOOKMemoryStreamTest);

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
