/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.file.ConstantPool;
import alt.jiapi.reflect.BranchInstruction;
import alt.jiapi.reflect.Instruction;
import alt.jiapi.reflect.SwitchInstruction;
import alt.jiapi.reflect.TargetInstruction;
import alt.jiapi.reflect.instruction.CPInstruction;
import alt.jiapi.reflect.instruction.FieldAccess;
import alt.jiapi.reflect.instruction.Invocation;
import java.util.LinkedList;
import java.util.List;

class InstructionParser {
    InstructionParser() {
    }

    List createInstructionList(byte[] byteCode, ConstantPool cp) {
        int i;
        LinkedList<Instruction> list = new LinkedList<Instruction>();
        boolean branchesFound = false;
        for (i = 0; i < byteCode.length; ++i) {
            byte opcode = byteCode[i];
            Instruction ins = null;
            int iMod = 0;
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case 16: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1]});
                    iMod = 1;
                    break;
                }
                case 17: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]});
                    iMod = 2;
                    break;
                }
                case 18: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1]}, cp);
                    iMod = 1;
                    break;
                }
                case 19: 
                case 20: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1]});
                    iMod = 1;
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1]});
                    iMod = 1;
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -124: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]});
                    iMod = 2;
                    break;
                }
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: {
                    branchesFound = true;
                    ins = new BranchInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]});
                    iMod = 2;
                    break;
                }
                case -87: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1]});
                    iMod = 1;
                    break;
                }
                case -86: {
                    branchesFound = true;
                    int tspCount = 3 - i % 4;
                    byte l1 = byteCode[i + tspCount + 5];
                    byte l2 = byteCode[i + tspCount + 6];
                    byte l3 = byteCode[i + tspCount + 7];
                    byte l4 = byteCode[i + tspCount + 8];
                    int low = l1 << 24 | l2 << 16 | l3 << 8 | l4;
                    byte h1 = byteCode[i + tspCount + 9];
                    byte h2 = byteCode[i + tspCount + 10];
                    byte h3 = byteCode[i + tspCount + 11];
                    byte h4 = byteCode[i + tspCount + 12];
                    int high = h1 << 24 | h2 << 16 | h3 << 8 | h4;
                    int size = high - low + 1;
                    int bSize = size * 4;
                    byte[] tsBytes = new byte[13 + tspCount + bSize];
                    for (int k = 0; k < tsBytes.length; ++k) {
                        tsBytes[k] = byteCode[i + k];
                    }
                    iMod = tsBytes.length - 1;
                    ins = new SwitchInstruction(tsBytes, tspCount, size);
                    break;
                }
                case -85: {
                    branchesFound = true;
                    int pCount = 3 - i % 4;
                    byte np1 = byteCode[i + pCount + 5];
                    byte np2 = byteCode[i + pCount + 6];
                    byte np3 = byteCode[i + pCount + 7];
                    byte np4 = byteCode[i + pCount + 8];
                    int nPairs = np1 << 24 & 0xFF000000 | np2 << 16 & 0xFF0000 | np3 << 8 & 0xFF00 | np4 & 0xFF;
                    int lbSize = nPairs * 4 * 2;
                    byte[] lsBytes = new byte[9 + pCount + lbSize];
                    for (int k = 0; k < lsBytes.length; ++k) {
                        lsBytes[k] = byteCode[i + k];
                    }
                    iMod = lsBytes.length - 1;
                    ins = new SwitchInstruction(lsBytes, pCount, nPairs);
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -78: 
                case -77: 
                case -76: 
                case -75: {
                    ins = new FieldAccess(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -74: 
                case -73: 
                case -72: {
                    ins = new Invocation(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -71: {
                    byte count = byteCode[i + 3];
                    ins = new Invocation(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], count, byteCode[i + 4]}, cp);
                    iMod = 4;
                    break;
                }
                case -70: {
                    new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -69: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -68: {
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1]});
                    iMod = 1;
                    break;
                }
                case -67: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -66: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -65: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -64: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -63: {
                    ins = new CPInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]}, cp);
                    iMod = 2;
                    break;
                }
                case -62: 
                case -61: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                    break;
                }
                case -60: {
                    if (byteCode[i + 1] == -124) {
                        ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4], byteCode[i + 5]});
                        iMod = 5;
                        break;
                    }
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3]});
                    iMod = 3;
                    break;
                }
                case -59: {
                    byte dim = byteCode[i + 4];
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], dim});
                    iMod = 4;
                    break;
                }
                case -58: 
                case -57: {
                    branchesFound = true;
                    ins = new BranchInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2]});
                    iMod = 2;
                    break;
                }
                case -56: {
                    branchesFound = true;
                    ins = new BranchInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4]});
                    iMod = 4;
                    break;
                }
                case -55: {
                    branchesFound = true;
                    ins = new BranchInstruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4]});
                    iMod = 4;
                    break;
                }
                case -54: 
                case -2: 
                case -1: {
                    ins = new Instruction(new byte[]{byteCode[i]});
                }
            }
            ins.setOffset((short)i);
            i += iMod;
            list.add(ins);
        }
        if (branchesFound) {
            for (i = 0; i < list.size(); ++i) {
                Instruction target;
                Instruction ins = (Instruction)list.get(i);
                if (ins instanceof BranchInstruction) {
                    BranchInstruction bi = (BranchInstruction)ins;
                    int offset = bi.getTargetOffset();
                    target = null;
                    target = this.findTarget(list, bi.getOffset() + offset);
                    if (target != null) {
                        bi.setTarget(target);
                        continue;
                    }
                    System.out.println("Error locating branch target for instruction at " + i + ": " + bi);
                    continue;
                }
                if (!(ins instanceof SwitchInstruction)) continue;
                SwitchInstruction si = (SwitchInstruction)ins;
                int dOffset = si.getDefaultOffset();
                target = null;
                target = this.findTarget(list, i, dOffset);
                si.setDefault(target);
                int[] tOffsets = si.getTargetOffsets();
                Instruction[] targets = new Instruction[tOffsets.length];
                for (int j = 0; j < targets.length; ++j) {
                    targets[j] = this.findTarget(list, i, tOffsets[j]);
                }
                si.setTargets(targets);
            }
        }
        return list;
    }

    private Instruction findTarget(List list, int offset) {
        int idx = 0;
        int currentOffset = 0;
        while (currentOffset != offset) {
            if (idx == list.size()) {
                return null;
            }
            Instruction ins = (Instruction)list.get(idx);
            currentOffset += ins.length();
            ++idx;
        }
        return (Instruction)list.get(idx);
    }

    private Instruction findTarget(List list, int idx, int offset) {
        int offs = offset;
        int dir = 1;
        if (offset < 0) {
            offs = -offset;
            dir = -1;
        }
        int i = 0;
        while (i < offs) {
            Instruction ins = (Instruction)list.get(idx);
            i += ins.length();
            idx += dir;
        }
        Instruction target = (Instruction)list.get(idx);
        TargetInstruction ti = new TargetInstruction(target);
        list.set(idx, ti);
        return ti;
    }
}

