/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class SecondsDurationValue
extends DurationValue {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    private SecondsDurationValue() {
    }

    public SecondsDurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.trimWhitespace(charSequence).toString(), "-+.PDTHMS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!string.equals("P")) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (string.equals("T")) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'D': {
                        if (n > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n2;
                        n = 3;
                        break;
                    }
                    case 'H': {
                        if (n != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n2;
                        n = 5;
                        break;
                    }
                    case 'M': {
                        if (n < 4 || n > 5) {
                            this.badDuration("M is out of sequence", charSequence);
                        }
                        this.minutes = n2;
                        n = 6;
                        break;
                    }
                    case '.': {
                        if (n > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n2;
                        n = 7;
                        break;
                    }
                    case 'S': {
                        if (n > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n == 7) {
                            while (string.length() < 3) {
                                string = string + "0";
                            }
                            if (string.length() > 3) {
                                string = string.substring(0, 3);
                            }
                            this.milliseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n2;
                        }
                        n = 8;
                        break;
                    }
                    default: {
                        this.badDuration("misplaced " + c, charSequence);
                    }
                }
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    public String getStringValue() {
        double d = this.getLengthInSeconds();
        if (d < 0.0) {
            d = -d;
        }
        int n = (int)Math.floor(d);
        int n2 = (int)(d % 1.0 * 1000.0);
        int n3 = n % 60;
        int n4 = n / 60;
        int n5 = n4 / 60;
        n4 %= 60;
        int n6 = n5 / 24;
        n5 %= 24;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n6 != 0) {
            stringBuffer.append(n6);
            stringBuffer.append('D');
        }
        if (n6 == 0 || n5 != 0 || n4 != 0 || n3 != 0 || n2 != 0) {
            stringBuffer.append('T');
        }
        if (n5 != 0) {
            stringBuffer.append(n5);
            stringBuffer.append('H');
        }
        if (n4 != 0) {
            stringBuffer.append(n4);
            stringBuffer.append('M');
        }
        if (n3 != 0 || n2 != 0 || n6 == 0 && n4 == 0 && n5 == 0) {
            stringBuffer.append(n3);
            if (this.milliseconds != 0) {
                stringBuffer.append('.');
                DateTimeValue.appendString(stringBuffer, n2, 3);
            }
            stringBuffer.append('S');
        }
        return stringBuffer.toString();
    }

    public void normalize() {
        if (this.milliseconds >= 1000) {
            this.seconds += this.milliseconds / 1000;
            this.milliseconds %= 1000;
        }
        if (this.seconds >= 60) {
            this.minutes += this.seconds / 60;
            this.seconds %= 60;
        }
        if (this.minutes >= 60) {
            this.hours += this.minutes / 60;
            this.minutes %= 60;
        }
        if (this.hours >= 24) {
            this.days += this.hours / 24;
            this.hours %= 24;
        }
    }

    public double getLengthInSeconds() {
        double d = this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.milliseconds / 1000.0);
    }

    public static SecondsDurationValue fromSeconds(double d) {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = d < 0.0;
        secondsDurationValue.seconds = (int)(d < 0.0 ? -d : d);
        secondsDurationValue.milliseconds = (int)(d % 1.0 * 1000.0);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public DurationValue multiply(double d) {
        return SecondsDurationValue.fromSeconds(this.getLengthInSeconds() * d);
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromSeconds(this.getLengthInSeconds() + durationValue.getLengthInSeconds());
        }
        throw new XPathException.Dynamic("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromSeconds(this.getLengthInSeconds() - durationValue.getLengthInSeconds());
        }
        throw new XPathException.Dynamic("Cannot add two durations of different type");
    }

    public ItemType getItemType() {
        return Type.DAY_TIME_DURATION_TYPE;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of dayTimeDuration to " + clazz.getName() + " is not supported");
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "dayTimeDuration (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

