use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

plan tests => 6, need 'LWP', { "PHP not installed", \&need_php };

use HTTP::Message;

my $url = Apache::TestRequest::resolve_url("/security/CAN-2004-0959.php");

sub multipart
{
    my $name = shift;
    my $filename = shift;
    my $ctype = shift;
    my $extra = shift;
    my $req = HTTP::Request->new(POST => $url);
    
    $req->header(Content_Type => 'multipart/form-data; boundary=XXXX');
    
    $req->content("--XXXX\n".
                  "Content-Disposition: form-data; name=\"MAX_FILE_SIZE\"\n\n".
                  "30000\n".
                  "--XXXX\n".
                  "Content-Disposition: form-data; name=\"".$name."\"; filename=\"".$filename."\"\n".
                  "Content-Type: ".$ctype."\n\n".
                  "fish\n");

    $req->add_content($extra) if $extra;

    $req->add_content("--XXXX--\n");

    Apache::TestRequest::user_agent->request($req);
}

my $resp = multipart("user_file", "fish.php", "text/plain");
ok t_cmp($resp->code, 200, "POST request success");
ok t_cmp($resp->content, "fish.php", "filename parsed safely");

$resp = multipart("user_file", "../../fish.php", "text/plain");
ok t_cmp($resp->code, 200, "POST request success");
ok t_cmp($resp->content, "fish.php", "filename parsed safely");

$resp = multipart
    ("user[file[name]123", "good.php", "/tmp/passt.php",
     "--XXXX\n".
     "Content-Disposition: form-data; name=\"user[file[type]123\"; filename=\"vg\"\n".
     "Content-Type: text/plain\n\n".
     "fishfood\n");

ok t_cmp($resp->code, 200, "POST request success");
ok t_cmp($resp->content, "FAILED", "filename parsed safely");

