package ONVIF::Analytics::Types::EFlipOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Mode
        Extension

    ) ],
    {
        'Mode' => \%Mode_of,
        'Extension' => \%Extension_of,
    },
    {
        'Mode' => 'ONVIF::Analytics::Types::EFlipMode',
        'Extension' => 'ONVIF::Analytics::Types::EFlipOptionsExtension',
    },
    {

        'Mode' => 'Mode',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::EFlipOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
EFlipOptions from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::EFlipOptions
   Mode => $some_value, # EFlipMode
   Extension =>  { # ONVIF::Analytics::Types::EFlipOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

