/*
    libzint - the open source barcode library
    Copyright (C) 2021-2025 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#include "testcommon.h"
#include "../iso4217.h"

static void test_numeric(const testCtx *const p_ctx) {

    struct item {
        int data;
        int ret;
    };
    /* s/\/\*[ 0-9]*\*\//\=printf("\/\*%3d*\/", line(".") - line("'<")): */
    struct item data[] = {
        /*  0*/ { -1, 0 },
        /*  1*/ { 0, 0 },
        /*  2*/ { 1, 0 },
        /*  3*/ { 2, 0 },
        /*  4*/ { 3, 0 },
        /*  5*/ { 4, 0 },
        /*  6*/ { 5, 0 },
        /*  7*/ { 6, 0 },
        /*  8*/ { 7, 0 },
        /*  9*/ { 8, 1 },
        /* 10*/ { 9, 0 },
        /* 11*/ { 10, 0 },
        /* 12*/ { 11, 0 },
        /* 13*/ { 12, 1 },
        /* 14*/ { 13, 0 },
        /* 15*/ { 14, 0 },
        /* 16*/ { 15, 0 },
        /* 17*/ { 16, 0 },
        /* 18*/ { 17, 0 },
        /* 19*/ { 18, 0 },
        /* 20*/ { 19, 0 },
        /* 21*/ { 20, 0 },
        /* 22*/ { 21, 0 },
        /* 23*/ { 22, 0 },
        /* 24*/ { 23, 0 },
        /* 25*/ { 24, 0 },
        /* 26*/ { 25, 0 },
        /* 27*/ { 26, 0 },
        /* 28*/ { 27, 0 },
        /* 29*/ { 28, 0 },
        /* 30*/ { 29, 0 },
        /* 31*/ { 30, 0 },
        /* 32*/ { 31, 0 },
        /* 33*/ { 32, 1 },
        /* 34*/ { 33, 0 },
        /* 35*/ { 34, 0 },
        /* 36*/ { 35, 0 },
        /* 37*/ { 36, 1 },
        /* 38*/ { 37, 0 },
        /* 39*/ { 38, 0 },
        /* 40*/ { 39, 0 },
        /* 41*/ { 40, 0 },
        /* 42*/ { 41, 0 },
        /* 43*/ { 42, 0 },
        /* 44*/ { 43, 0 },
        /* 45*/ { 44, 1 },
        /* 46*/ { 45, 0 },
        /* 47*/ { 46, 0 },
        /* 48*/ { 47, 0 },
        /* 49*/ { 48, 1 },
        /* 50*/ { 49, 0 },
        /* 51*/ { 50, 1 },
        /* 52*/ { 51, 1 },
        /* 53*/ { 52, 1 },
        /* 54*/ { 53, 0 },
        /* 55*/ { 54, 0 },
        /* 56*/ { 55, 0 },
        /* 57*/ { 56, 0 },
        /* 58*/ { 57, 0 },
        /* 59*/ { 58, 0 },
        /* 60*/ { 59, 0 },
        /* 61*/ { 60, 1 },
        /* 62*/ { 61, 0 },
        /* 63*/ { 62, 0 },
        /* 64*/ { 63, 0 },
        /* 65*/ { 64, 1 },
        /* 66*/ { 65, 0 },
        /* 67*/ { 66, 0 },
        /* 68*/ { 67, 0 },
        /* 69*/ { 68, 1 },
        /* 70*/ { 69, 0 },
        /* 71*/ { 70, 0 },
        /* 72*/ { 71, 0 },
        /* 73*/ { 72, 1 },
        /* 74*/ { 73, 0 },
        /* 75*/ { 74, 0 },
        /* 76*/ { 75, 0 },
        /* 77*/ { 76, 0 },
        /* 78*/ { 77, 0 },
        /* 79*/ { 78, 0 },
        /* 80*/ { 79, 0 },
        /* 81*/ { 80, 0 },
        /* 82*/ { 81, 0 },
        /* 83*/ { 82, 0 },
        /* 84*/ { 83, 0 },
        /* 85*/ { 84, 1 },
        /* 86*/ { 85, 0 },
        /* 87*/ { 86, 0 },
        /* 88*/ { 87, 0 },
        /* 89*/ { 88, 0 },
        /* 90*/ { 89, 0 },
        /* 91*/ { 90, 1 },
        /* 92*/ { 91, 0 },
        /* 93*/ { 92, 0 },
        /* 94*/ { 93, 0 },
        /* 95*/ { 94, 0 },
        /* 96*/ { 95, 0 },
        /* 97*/ { 96, 1 },
        /* 98*/ { 97, 0 },
        /* 99*/ { 98, 0 },
        /*100*/ { 99, 0 },
        /*101*/ { 100, 0 },
        /*102*/ { 101, 0 },
        /*103*/ { 102, 0 },
        /*104*/ { 103, 0 },
        /*105*/ { 104, 1 },
        /*106*/ { 105, 0 },
        /*107*/ { 106, 0 },
        /*108*/ { 107, 0 },
        /*109*/ { 108, 1 },
        /*110*/ { 109, 0 },
        /*111*/ { 110, 0 },
        /*112*/ { 111, 0 },
        /*113*/ { 112, 0 },
        /*114*/ { 113, 0 },
        /*115*/ { 114, 0 },
        /*116*/ { 115, 0 },
        /*117*/ { 116, 1 },
        /*118*/ { 117, 0 },
        /*119*/ { 118, 0 },
        /*120*/ { 119, 0 },
        /*121*/ { 120, 0 },
        /*122*/ { 121, 0 },
        /*123*/ { 122, 0 },
        /*124*/ { 123, 0 },
        /*125*/ { 124, 1 },
        /*126*/ { 125, 0 },
        /*127*/ { 126, 0 },
        /*128*/ { 127, 0 },
        /*129*/ { 128, 0 },
        /*130*/ { 129, 0 },
        /*131*/ { 130, 0 },
        /*132*/ { 131, 0 },
        /*133*/ { 132, 1 },
        /*134*/ { 133, 0 },
        /*135*/ { 134, 0 },
        /*136*/ { 135, 0 },
        /*137*/ { 136, 1 },
        /*138*/ { 137, 0 },
        /*139*/ { 138, 0 },
        /*140*/ { 139, 0 },
        /*141*/ { 140, 0 },
        /*142*/ { 141, 0 },
        /*143*/ { 142, 0 },
        /*144*/ { 143, 0 },
        /*145*/ { 144, 1 },
        /*146*/ { 145, 0 },
        /*147*/ { 146, 0 },
        /*148*/ { 147, 0 },
        /*149*/ { 148, 0 },
        /*150*/ { 149, 0 },
        /*151*/ { 150, 0 },
        /*152*/ { 151, 0 },
        /*153*/ { 152, 1 },
        /*154*/ { 153, 0 },
        /*155*/ { 154, 0 },
        /*156*/ { 155, 0 },
        /*157*/ { 156, 1 },
        /*158*/ { 157, 0 },
        /*159*/ { 158, 0 },
        /*160*/ { 159, 0 },
        /*161*/ { 160, 0 },
        /*162*/ { 161, 0 },
        /*163*/ { 162, 0 },
        /*164*/ { 163, 0 },
        /*165*/ { 164, 0 },
        /*166*/ { 165, 0 },
        /*167*/ { 166, 0 },
        /*168*/ { 167, 0 },
        /*169*/ { 168, 0 },
        /*170*/ { 169, 0 },
        /*171*/ { 170, 1 },
        /*172*/ { 171, 0 },
        /*173*/ { 172, 0 },
        /*174*/ { 173, 0 },
        /*175*/ { 174, 1 },
        /*176*/ { 175, 0 },
        /*177*/ { 176, 0 },
        /*178*/ { 177, 0 },
        /*179*/ { 178, 0 },
        /*180*/ { 179, 0 },
        /*181*/ { 180, 0 },
        /*182*/ { 181, 0 },
        /*183*/ { 182, 0 },
        /*184*/ { 183, 0 },
        /*185*/ { 184, 0 },
        /*186*/ { 185, 0 },
        /*187*/ { 186, 0 },
        /*188*/ { 187, 0 },
        /*189*/ { 188, 1 },
        /*190*/ { 189, 0 },
        /*191*/ { 190, 0 },
        /*192*/ { 191, 0 },
        /*193*/ { 192, 1 },
        /*194*/ { 193, 0 },
        /*195*/ { 194, 0 },
        /*196*/ { 195, 0 },
        /*197*/ { 196, 0 },
        /*198*/ { 197, 0 },
        /*199*/ { 198, 0 },
        /*200*/ { 199, 0 },
        /*201*/ { 200, 0 },
        /*202*/ { 201, 0 },
        /*203*/ { 202, 0 },
        /*204*/ { 203, 1 },
        /*205*/ { 204, 0 },
        /*206*/ { 205, 0 },
        /*207*/ { 206, 0 },
        /*208*/ { 207, 0 },
        /*209*/ { 208, 1 },
        /*210*/ { 209, 0 },
        /*211*/ { 210, 0 },
        /*212*/ { 211, 0 },
        /*213*/ { 212, 0 },
        /*214*/ { 213, 0 },
        /*215*/ { 214, 1 },
        /*216*/ { 215, 0 },
        /*217*/ { 216, 0 },
        /*218*/ { 217, 0 },
        /*219*/ { 218, 0 },
        /*220*/ { 219, 0 },
        /*221*/ { 220, 0 },
        /*222*/ { 221, 0 },
        /*223*/ { 222, 1 },
        /*224*/ { 223, 0 },
        /*225*/ { 224, 0 },
        /*226*/ { 225, 0 },
        /*227*/ { 226, 0 },
        /*228*/ { 227, 0 },
        /*229*/ { 228, 0 },
        /*230*/ { 229, 0 },
        /*231*/ { 230, 1 },
        /*232*/ { 231, 0 },
        /*233*/ { 232, 1 },
        /*234*/ { 233, 0 },
        /*235*/ { 234, 0 },
        /*236*/ { 235, 0 },
        /*237*/ { 236, 0 },
        /*238*/ { 237, 0 },
        /*239*/ { 238, 1 },
        /*240*/ { 239, 0 },
        /*241*/ { 240, 0 },
        /*242*/ { 241, 0 },
        /*243*/ { 242, 1 },
        /*244*/ { 243, 0 },
        /*245*/ { 244, 0 },
        /*246*/ { 245, 0 },
        /*247*/ { 246, 0 },
        /*248*/ { 247, 0 },
        /*249*/ { 248, 0 },
        /*250*/ { 249, 0 },
        /*251*/ { 250, 0 },
        /*252*/ { 251, 0 },
        /*253*/ { 252, 0 },
        /*254*/ { 253, 0 },
        /*255*/ { 254, 0 },
        /*256*/ { 255, 0 },
        /*257*/ { 256, 0 },
        /*258*/ { 257, 0 },
        /*259*/ { 258, 0 },
        /*260*/ { 259, 0 },
        /*261*/ { 260, 0 },
        /*262*/ { 261, 0 },
        /*263*/ { 262, 1 },
        /*264*/ { 263, 0 },
        /*265*/ { 264, 0 },
        /*266*/ { 265, 0 },
        /*267*/ { 266, 0 },
        /*268*/ { 267, 0 },
        /*269*/ { 268, 0 },
        /*270*/ { 269, 0 },
        /*271*/ { 270, 1 },
        /*272*/ { 271, 0 },
        /*273*/ { 272, 0 },
        /*274*/ { 273, 0 },
        /*275*/ { 274, 0 },
        /*276*/ { 275, 0 },
        /*277*/ { 276, 0 },
        /*278*/ { 277, 0 },
        /*279*/ { 278, 0 },
        /*280*/ { 279, 0 },
        /*281*/ { 280, 0 },
        /*282*/ { 281, 0 },
        /*283*/ { 282, 0 },
        /*284*/ { 283, 0 },
        /*285*/ { 284, 0 },
        /*286*/ { 285, 0 },
        /*287*/ { 286, 0 },
        /*288*/ { 287, 0 },
        /*289*/ { 288, 0 },
        /*290*/ { 289, 0 },
        /*291*/ { 290, 0 },
        /*292*/ { 291, 0 },
        /*293*/ { 292, 1 },
        /*294*/ { 293, 0 },
        /*295*/ { 294, 0 },
        /*296*/ { 295, 0 },
        /*297*/ { 296, 0 },
        /*298*/ { 297, 0 },
        /*299*/ { 298, 0 },
        /*300*/ { 299, 0 },
        /*301*/ { 300, 0 },
        /*302*/ { 301, 0 },
        /*303*/ { 302, 0 },
        /*304*/ { 303, 0 },
        /*305*/ { 304, 0 },
        /*306*/ { 305, 0 },
        /*307*/ { 306, 0 },
        /*308*/ { 307, 0 },
        /*309*/ { 308, 0 },
        /*310*/ { 309, 0 },
        /*311*/ { 310, 0 },
        /*312*/ { 311, 0 },
        /*313*/ { 312, 0 },
        /*314*/ { 313, 0 },
        /*315*/ { 314, 0 },
        /*316*/ { 315, 0 },
        /*317*/ { 316, 0 },
        /*318*/ { 317, 0 },
        /*319*/ { 318, 0 },
        /*320*/ { 319, 0 },
        /*321*/ { 320, 1 },
        /*322*/ { 321, 0 },
        /*323*/ { 322, 0 },
        /*324*/ { 323, 0 },
        /*325*/ { 324, 1 },
        /*326*/ { 325, 0 },
        /*327*/ { 326, 0 },
        /*328*/ { 327, 0 },
        /*329*/ { 328, 1 },
        /*330*/ { 329, 0 },
        /*331*/ { 330, 0 },
        /*332*/ { 331, 0 },
        /*333*/ { 332, 1 },
        /*334*/ { 333, 0 },
        /*335*/ { 334, 0 },
        /*336*/ { 335, 0 },
        /*337*/ { 336, 0 },
        /*338*/ { 337, 0 },
        /*339*/ { 338, 0 },
        /*340*/ { 339, 0 },
        /*341*/ { 340, 1 },
        /*342*/ { 341, 0 },
        /*343*/ { 342, 0 },
        /*344*/ { 343, 0 },
        /*345*/ { 344, 1 },
        /*346*/ { 345, 0 },
        /*347*/ { 346, 0 },
        /*348*/ { 347, 0 },
        /*349*/ { 348, 1 },
        /*350*/ { 349, 0 },
        /*351*/ { 350, 0 },
        /*352*/ { 351, 0 },
        /*353*/ { 352, 1 },
        /*354*/ { 353, 0 },
        /*355*/ { 354, 0 },
        /*356*/ { 355, 0 },
        /*357*/ { 356, 1 },
        /*358*/ { 357, 0 },
        /*359*/ { 358, 0 },
        /*360*/ { 359, 0 },
        /*361*/ { 360, 1 },
        /*362*/ { 361, 0 },
        /*363*/ { 362, 0 },
        /*364*/ { 363, 0 },
        /*365*/ { 364, 1 },
        /*366*/ { 365, 0 },
        /*367*/ { 366, 0 },
        /*368*/ { 367, 0 },
        /*369*/ { 368, 1 },
        /*370*/ { 369, 0 },
        /*371*/ { 370, 0 },
        /*372*/ { 371, 0 },
        /*373*/ { 372, 0 },
        /*374*/ { 373, 0 },
        /*375*/ { 374, 0 },
        /*376*/ { 375, 0 },
        /*377*/ { 376, 1 },
        /*378*/ { 377, 0 },
        /*379*/ { 378, 0 },
        /*380*/ { 379, 0 },
        /*381*/ { 380, 0 },
        /*382*/ { 381, 0 },
        /*383*/ { 382, 0 },
        /*384*/ { 383, 0 },
        /*385*/ { 384, 0 },
        /*386*/ { 385, 0 },
        /*387*/ { 386, 0 },
        /*388*/ { 387, 0 },
        /*389*/ { 388, 1 },
        /*390*/ { 389, 0 },
        /*391*/ { 390, 0 },
        /*392*/ { 391, 0 },
        /*393*/ { 392, 1 },
        /*394*/ { 393, 0 },
        /*395*/ { 394, 0 },
        /*396*/ { 395, 0 },
        /*397*/ { 396, 0 },
        /*398*/ { 397, 0 },
        /*399*/ { 398, 1 },
        /*400*/ { 399, 0 },
        /*401*/ { 400, 1 },
        /*402*/ { 401, 0 },
        /*403*/ { 402, 0 },
        /*404*/ { 403, 0 },
        /*405*/ { 404, 1 },
        /*406*/ { 405, 0 },
        /*407*/ { 406, 0 },
        /*408*/ { 407, 0 },
        /*409*/ { 408, 1 },
        /*410*/ { 409, 0 },
        /*411*/ { 410, 1 },
        /*412*/ { 411, 0 },
        /*413*/ { 412, 0 },
        /*414*/ { 413, 0 },
        /*415*/ { 414, 1 },
        /*416*/ { 415, 0 },
        /*417*/ { 416, 0 },
        /*418*/ { 417, 1 },
        /*419*/ { 418, 1 },
        /*420*/ { 419, 0 },
        /*421*/ { 420, 0 },
        /*422*/ { 421, 0 },
        /*423*/ { 422, 1 },
        /*424*/ { 423, 0 },
        /*425*/ { 424, 0 },
        /*426*/ { 425, 0 },
        /*427*/ { 426, 1 },
        /*428*/ { 427, 0 },
        /*429*/ { 428, 0 },
        /*430*/ { 429, 0 },
        /*431*/ { 430, 1 },
        /*432*/ { 431, 0 },
        /*433*/ { 432, 0 },
        /*434*/ { 433, 0 },
        /*435*/ { 434, 1 },
        /*436*/ { 435, 0 },
        /*437*/ { 436, 0 },
        /*438*/ { 437, 0 },
        /*439*/ { 438, 0 },
        /*440*/ { 439, 0 },
        /*441*/ { 440, 0 },
        /*442*/ { 441, 0 },
        /*443*/ { 442, 0 },
        /*444*/ { 443, 0 },
        /*445*/ { 444, 0 },
        /*446*/ { 445, 0 },
        /*447*/ { 446, 1 },
        /*448*/ { 447, 0 },
        /*449*/ { 448, 0 },
        /*450*/ { 449, 0 },
        /*451*/ { 450, 0 },
        /*452*/ { 451, 0 },
        /*453*/ { 452, 0 },
        /*454*/ { 453, 0 },
        /*455*/ { 454, 1 },
        /*456*/ { 455, 0 },
        /*457*/ { 456, 0 },
        /*458*/ { 457, 0 },
        /*459*/ { 458, 1 },
        /*460*/ { 459, 0 },
        /*461*/ { 460, 0 },
        /*462*/ { 461, 0 },
        /*463*/ { 462, 1 },
        /*464*/ { 463, 0 },
        /*465*/ { 464, 0 },
        /*466*/ { 465, 0 },
        /*467*/ { 466, 0 },
        /*468*/ { 467, 0 },
        /*469*/ { 468, 0 },
        /*470*/ { 469, 0 },
        /*471*/ { 470, 0 },
        /*472*/ { 471, 0 },
        /*473*/ { 472, 0 },
        /*474*/ { 473, 0 },
        /*475*/ { 474, 0 },
        /*476*/ { 475, 0 },
        /*477*/ { 476, 0 },
        /*478*/ { 477, 0 },
        /*479*/ { 478, 0 },
        /*480*/ { 479, 0 },
        /*481*/ { 480, 1 },
        /*482*/ { 481, 0 },
        /*483*/ { 482, 0 },
        /*484*/ { 483, 0 },
        /*485*/ { 484, 1 },
        /*486*/ { 485, 0 },
        /*487*/ { 486, 0 },
        /*488*/ { 487, 0 },
        /*489*/ { 488, 0 },
        /*490*/ { 489, 0 },
        /*491*/ { 490, 0 },
        /*492*/ { 491, 0 },
        /*493*/ { 492, 0 },
        /*494*/ { 493, 0 },
        /*495*/ { 494, 0 },
        /*496*/ { 495, 0 },
        /*497*/ { 496, 1 },
        /*498*/ { 497, 0 },
        /*499*/ { 498, 1 },
        /*500*/ { 499, 0 },
        /*501*/ { 500, 0 },
        /*502*/ { 501, 0 },
        /*503*/ { 502, 0 },
        /*504*/ { 503, 0 },
        /*505*/ { 504, 1 },
        /*506*/ { 505, 0 },
        /*507*/ { 506, 0 },
        /*508*/ { 507, 0 },
        /*509*/ { 508, 0 },
        /*510*/ { 509, 0 },
        /*511*/ { 510, 0 },
        /*512*/ { 511, 0 },
        /*513*/ { 512, 1 },
        /*514*/ { 513, 0 },
        /*515*/ { 514, 0 },
        /*516*/ { 515, 0 },
        /*517*/ { 516, 1 },
        /*518*/ { 517, 0 },
        /*519*/ { 518, 0 },
        /*520*/ { 519, 0 },
        /*521*/ { 520, 0 },
        /*522*/ { 521, 0 },
        /*523*/ { 522, 0 },
        /*524*/ { 523, 0 },
        /*525*/ { 524, 1 },
        /*526*/ { 525, 0 },
        /*527*/ { 526, 0 },
        /*528*/ { 527, 0 },
        /*529*/ { 528, 0 },
        /*530*/ { 529, 0 },
        /*531*/ { 530, 0 },
        /*532*/ { 531, 0 },
        /*533*/ { 532, 1 },
        /*534*/ { 533, 1 },
        /*535*/ { 534, 0 },
        /*536*/ { 535, 0 },
        /*537*/ { 536, 0 },
        /*538*/ { 537, 0 },
        /*539*/ { 538, 0 },
        /*540*/ { 539, 0 },
        /*541*/ { 540, 0 },
        /*542*/ { 541, 0 },
        /*543*/ { 542, 0 },
        /*544*/ { 543, 0 },
        /*545*/ { 544, 0 },
        /*546*/ { 545, 0 },
        /*547*/ { 546, 0 },
        /*548*/ { 547, 0 },
        /*549*/ { 548, 1 },
        /*550*/ { 549, 0 },
        /*551*/ { 550, 0 },
        /*552*/ { 551, 0 },
        /*553*/ { 552, 0 },
        /*554*/ { 553, 0 },
        /*555*/ { 554, 1 },
        /*556*/ { 555, 0 },
        /*557*/ { 556, 0 },
        /*558*/ { 557, 0 },
        /*559*/ { 558, 1 },
        /*560*/ { 559, 0 },
        /*561*/ { 560, 0 },
        /*562*/ { 561, 0 },
        /*563*/ { 562, 0 },
        /*564*/ { 563, 0 },
        /*565*/ { 564, 0 },
        /*566*/ { 565, 0 },
        /*567*/ { 566, 1 },
        /*568*/ { 567, 0 },
        /*569*/ { 568, 0 },
        /*570*/ { 569, 0 },
        /*571*/ { 570, 0 },
        /*572*/ { 571, 0 },
        /*573*/ { 572, 0 },
        /*574*/ { 573, 0 },
        /*575*/ { 574, 0 },
        /*576*/ { 575, 0 },
        /*577*/ { 576, 0 },
        /*578*/ { 577, 0 },
        /*579*/ { 578, 1 },
        /*580*/ { 579, 0 },
        /*581*/ { 580, 0 },
        /*582*/ { 581, 0 },
        /*583*/ { 582, 0 },
        /*584*/ { 583, 0 },
        /*585*/ { 584, 0 },
        /*586*/ { 585, 0 },
        /*587*/ { 586, 1 },
        /*588*/ { 587, 0 },
        /*589*/ { 588, 0 },
        /*590*/ { 589, 0 },
        /*591*/ { 590, 1 },
        /*592*/ { 591, 0 },
        /*593*/ { 592, 0 },
        /*594*/ { 593, 0 },
        /*595*/ { 594, 0 },
        /*596*/ { 595, 0 },
        /*597*/ { 596, 0 },
        /*598*/ { 597, 0 },
        /*599*/ { 598, 1 },
        /*600*/ { 599, 0 },
        /*601*/ { 600, 1 },
        /*602*/ { 601, 0 },
        /*603*/ { 602, 0 },
        /*604*/ { 603, 0 },
        /*605*/ { 604, 1 },
        /*606*/ { 605, 0 },
        /*607*/ { 606, 0 },
        /*608*/ { 607, 0 },
        /*609*/ { 608, 1 },
        /*610*/ { 609, 0 },
        /*611*/ { 610, 0 },
        /*612*/ { 611, 0 },
        /*613*/ { 612, 0 },
        /*614*/ { 613, 0 },
        /*615*/ { 614, 0 },
        /*616*/ { 615, 0 },
        /*617*/ { 616, 0 },
        /*618*/ { 617, 0 },
        /*619*/ { 618, 0 },
        /*620*/ { 619, 0 },
        /*621*/ { 620, 0 },
        /*622*/ { 621, 0 },
        /*623*/ { 622, 0 },
        /*624*/ { 623, 0 },
        /*625*/ { 624, 0 },
        /*626*/ { 625, 0 },
        /*627*/ { 626, 0 },
        /*628*/ { 627, 0 },
        /*629*/ { 628, 0 },
        /*630*/ { 629, 0 },
        /*631*/ { 630, 0 },
        /*632*/ { 631, 0 },
        /*633*/ { 632, 0 },
        /*634*/ { 633, 0 },
        /*635*/ { 634, 1 },
        /*636*/ { 635, 0 },
        /*637*/ { 636, 0 },
        /*638*/ { 637, 0 },
        /*639*/ { 638, 0 },
        /*640*/ { 639, 0 },
        /*641*/ { 640, 0 },
        /*642*/ { 641, 0 },
        /*643*/ { 642, 0 },
        /*644*/ { 643, 1 },
        /*645*/ { 644, 0 },
        /*646*/ { 645, 0 },
        /*647*/ { 646, 1 },
        /*648*/ { 647, 0 },
        /*649*/ { 648, 0 },
        /*650*/ { 649, 0 },
        /*651*/ { 650, 0 },
        /*652*/ { 651, 0 },
        /*653*/ { 652, 0 },
        /*654*/ { 653, 0 },
        /*655*/ { 654, 1 },
        /*656*/ { 655, 0 },
        /*657*/ { 656, 0 },
        /*658*/ { 657, 0 },
        /*659*/ { 658, 0 },
        /*660*/ { 659, 0 },
        /*661*/ { 660, 0 },
        /*662*/ { 661, 0 },
        /*663*/ { 662, 0 },
        /*664*/ { 663, 0 },
        /*665*/ { 664, 0 },
        /*666*/ { 665, 0 },
        /*667*/ { 666, 0 },
        /*668*/ { 667, 0 },
        /*669*/ { 668, 0 },
        /*670*/ { 669, 0 },
        /*671*/ { 670, 0 },
        /*672*/ { 671, 0 },
        /*673*/ { 672, 0 },
        /*674*/ { 673, 0 },
        /*675*/ { 674, 0 },
        /*676*/ { 675, 0 },
        /*677*/ { 676, 0 },
        /*678*/ { 677, 0 },
        /*679*/ { 678, 0 },
        /*680*/ { 679, 0 },
        /*681*/ { 680, 0 },
        /*682*/ { 681, 0 },
        /*683*/ { 682, 1 },
        /*684*/ { 683, 0 },
        /*685*/ { 684, 0 },
        /*686*/ { 685, 0 },
        /*687*/ { 686, 0 },
        /*688*/ { 687, 0 },
        /*689*/ { 688, 0 },
        /*690*/ { 689, 0 },
        /*691*/ { 690, 1 },
        /*692*/ { 691, 0 },
        /*693*/ { 692, 0 },
        /*694*/ { 693, 0 },
        /*695*/ { 694, 0 },
        /*696*/ { 695, 0 },
        /*697*/ { 696, 0 },
        /*698*/ { 697, 0 },
        /*699*/ { 698, 0 },
        /*700*/ { 699, 0 },
        /*701*/ { 700, 0 },
        /*702*/ { 701, 0 },
        /*703*/ { 702, 1 },
        /*704*/ { 703, 0 },
        /*705*/ { 704, 1 },
        /*706*/ { 705, 0 },
        /*707*/ { 706, 1 },
        /*708*/ { 707, 0 },
        /*709*/ { 708, 0 },
        /*710*/ { 709, 0 },
        /*711*/ { 710, 1 },
        /*712*/ { 711, 0 },
        /*713*/ { 712, 0 },
        /*714*/ { 713, 0 },
        /*715*/ { 714, 0 },
        /*716*/ { 715, 0 },
        /*717*/ { 716, 0 },
        /*718*/ { 717, 0 },
        /*719*/ { 718, 0 },
        /*720*/ { 719, 0 },
        /*721*/ { 720, 0 },
        /*722*/ { 721, 0 },
        /*723*/ { 722, 0 },
        /*724*/ { 723, 0 },
        /*725*/ { 724, 0 },
        /*726*/ { 725, 0 },
        /*727*/ { 726, 0 },
        /*728*/ { 727, 0 },
        /*729*/ { 728, 1 },
        /*730*/ { 729, 0 },
        /*731*/ { 730, 0 },
        /*732*/ { 731, 0 },
        /*733*/ { 732, 0 },
        /*734*/ { 733, 0 },
        /*735*/ { 734, 0 },
        /*736*/ { 735, 0 },
        /*737*/ { 736, 0 },
        /*738*/ { 737, 0 },
        /*739*/ { 738, 0 },
        /*740*/ { 739, 0 },
        /*741*/ { 740, 0 },
        /*742*/ { 741, 0 },
        /*743*/ { 742, 0 },
        /*744*/ { 743, 0 },
        /*745*/ { 744, 0 },
        /*746*/ { 745, 0 },
        /*747*/ { 746, 0 },
        /*748*/ { 747, 0 },
        /*749*/ { 748, 1 },
        /*750*/ { 749, 0 },
        /*751*/ { 750, 0 },
        /*752*/ { 751, 0 },
        /*753*/ { 752, 1 },
        /*754*/ { 753, 0 },
        /*755*/ { 754, 0 },
        /*756*/ { 755, 0 },
        /*757*/ { 756, 1 },
        /*758*/ { 757, 0 },
        /*759*/ { 758, 0 },
        /*760*/ { 759, 0 },
        /*761*/ { 760, 1 },
        /*762*/ { 761, 0 },
        /*763*/ { 762, 0 },
        /*764*/ { 763, 0 },
        /*765*/ { 764, 1 },
        /*766*/ { 765, 0 },
        /*767*/ { 766, 0 },
        /*768*/ { 767, 0 },
        /*769*/ { 768, 0 },
        /*770*/ { 769, 0 },
        /*771*/ { 770, 0 },
        /*772*/ { 771, 0 },
        /*773*/ { 772, 0 },
        /*774*/ { 773, 0 },
        /*775*/ { 774, 0 },
        /*776*/ { 775, 0 },
        /*777*/ { 776, 1 },
        /*778*/ { 777, 0 },
        /*779*/ { 778, 0 },
        /*780*/ { 779, 0 },
        /*781*/ { 780, 1 },
        /*782*/ { 781, 0 },
        /*783*/ { 782, 0 },
        /*784*/ { 783, 0 },
        /*785*/ { 784, 1 },
        /*786*/ { 785, 0 },
        /*787*/ { 786, 0 },
        /*788*/ { 787, 0 },
        /*789*/ { 788, 1 },
        /*790*/ { 789, 0 },
        /*791*/ { 790, 0 },
        /*792*/ { 791, 0 },
        /*793*/ { 792, 0 },
        /*794*/ { 793, 0 },
        /*795*/ { 794, 0 },
        /*796*/ { 795, 0 },
        /*797*/ { 796, 0 },
        /*798*/ { 797, 0 },
        /*799*/ { 798, 0 },
        /*800*/ { 799, 0 },
        /*801*/ { 800, 1 },
        /*802*/ { 801, 0 },
        /*803*/ { 802, 0 },
        /*804*/ { 803, 0 },
        /*805*/ { 804, 0 },
        /*806*/ { 805, 0 },
        /*807*/ { 806, 0 },
        /*808*/ { 807, 1 },
        /*809*/ { 808, 0 },
        /*810*/ { 809, 0 },
        /*811*/ { 810, 0 },
        /*812*/ { 811, 0 },
        /*813*/ { 812, 0 },
        /*814*/ { 813, 0 },
        /*815*/ { 814, 0 },
        /*816*/ { 815, 0 },
        /*817*/ { 816, 0 },
        /*818*/ { 817, 0 },
        /*819*/ { 818, 1 },
        /*820*/ { 819, 0 },
        /*821*/ { 820, 0 },
        /*822*/ { 821, 0 },
        /*823*/ { 822, 0 },
        /*824*/ { 823, 0 },
        /*825*/ { 824, 0 },
        /*826*/ { 825, 0 },
        /*827*/ { 826, 1 },
        /*828*/ { 827, 0 },
        /*829*/ { 828, 0 },
        /*830*/ { 829, 0 },
        /*831*/ { 830, 0 },
        /*832*/ { 831, 0 },
        /*833*/ { 832, 0 },
        /*834*/ { 833, 0 },
        /*835*/ { 834, 1 },
        /*836*/ { 835, 0 },
        /*837*/ { 836, 0 },
        /*838*/ { 837, 0 },
        /*839*/ { 838, 0 },
        /*840*/ { 839, 0 },
        /*841*/ { 840, 1 },
        /*842*/ { 841, 0 },
        /*843*/ { 842, 0 },
        /*844*/ { 843, 0 },
        /*845*/ { 844, 0 },
        /*846*/ { 845, 0 },
        /*847*/ { 846, 0 },
        /*848*/ { 847, 0 },
        /*849*/ { 848, 0 },
        /*850*/ { 849, 0 },
        /*851*/ { 850, 0 },
        /*852*/ { 851, 0 },
        /*853*/ { 852, 0 },
        /*854*/ { 853, 0 },
        /*855*/ { 854, 0 },
        /*856*/ { 855, 0 },
        /*857*/ { 856, 0 },
        /*858*/ { 857, 0 },
        /*859*/ { 858, 1 },
        /*860*/ { 859, 0 },
        /*861*/ { 860, 1 },
        /*862*/ { 861, 0 },
        /*863*/ { 862, 0 },
        /*864*/ { 863, 0 },
        /*865*/ { 864, 0 },
        /*866*/ { 865, 0 },
        /*867*/ { 866, 0 },
        /*868*/ { 867, 0 },
        /*869*/ { 868, 0 },
        /*870*/ { 869, 0 },
        /*871*/ { 870, 0 },
        /*872*/ { 871, 0 },
        /*873*/ { 872, 0 },
        /*874*/ { 873, 0 },
        /*875*/ { 874, 0 },
        /*876*/ { 875, 0 },
        /*877*/ { 876, 0 },
        /*878*/ { 877, 0 },
        /*879*/ { 878, 0 },
        /*880*/ { 879, 0 },
        /*881*/ { 880, 0 },
        /*882*/ { 881, 0 },
        /*883*/ { 882, 1 },
        /*884*/ { 883, 0 },
        /*885*/ { 884, 0 },
        /*886*/ { 885, 0 },
        /*887*/ { 886, 1 },
        /*888*/ { 887, 0 },
        /*889*/ { 888, 0 },
        /*890*/ { 889, 0 },
        /*891*/ { 890, 0 },
        /*892*/ { 891, 0 },
        /*893*/ { 892, 0 },
        /*894*/ { 893, 0 },
        /*895*/ { 894, 0 },
        /*896*/ { 895, 0 },
        /*897*/ { 896, 0 },
        /*898*/ { 897, 0 },
        /*899*/ { 898, 0 },
        /*900*/ { 899, 0 },
        /*901*/ { 900, 0 },
        /*902*/ { 901, 1 },
        /*903*/ { 902, 0 },
        /*904*/ { 903, 0 },
        /*905*/ { 904, 0 },
        /*906*/ { 905, 0 },
        /*907*/ { 906, 0 },
        /*908*/ { 907, 0 },
        /*909*/ { 908, 0 },
        /*910*/ { 909, 0 },
        /*911*/ { 910, 0 },
        /*912*/ { 911, 0 },
        /*913*/ { 912, 0 },
        /*914*/ { 913, 0 },
        /*915*/ { 914, 0 },
        /*916*/ { 915, 0 },
        /*917*/ { 916, 0 },
        /*918*/ { 917, 0 },
        /*919*/ { 918, 0 },
        /*920*/ { 919, 0 },
        /*921*/ { 920, 0 },
        /*922*/ { 921, 0 },
        /*923*/ { 922, 0 },
        /*924*/ { 923, 0 },
        /*925*/ { 924, 1 },
        /*926*/ { 925, 1 },
        /*927*/ { 926, 1 },
        /*928*/ { 927, 1 },
        /*929*/ { 928, 1 },
        /*930*/ { 929, 1 },
        /*931*/ { 930, 1 },
        /*932*/ { 931, 0 },
        /*933*/ { 932, 0 },
        /*934*/ { 933, 1 },
        /*935*/ { 934, 1 },
        /*936*/ { 935, 0 },
        /*937*/ { 936, 1 },
        /*938*/ { 937, 0 },
        /*939*/ { 938, 1 },
        /*940*/ { 939, 0 },
        /*941*/ { 940, 1 },
        /*942*/ { 941, 1 },
        /*943*/ { 942, 0 },
        /*944*/ { 943, 1 },
        /*945*/ { 944, 1 },
        /*946*/ { 945, 0 },
        /*947*/ { 946, 1 },
        /*948*/ { 947, 1 },
        /*949*/ { 948, 1 },
        /*950*/ { 949, 1 },
        /*951*/ { 950, 1 },
        /*952*/ { 951, 1 },
        /*953*/ { 952, 1 },
        /*954*/ { 953, 1 },
        /*955*/ { 954, 0 },
        /*956*/ { 955, 1 },
        /*957*/ { 956, 1 },
        /*958*/ { 957, 1 },
        /*959*/ { 958, 1 },
        /*960*/ { 959, 1 },
        /*961*/ { 960, 1 },
        /*962*/ { 961, 1 },
        /*963*/ { 962, 1 },
        /*964*/ { 963, 1 },
        /*965*/ { 964, 1 },
        /*966*/ { 965, 1 },
        /*967*/ { 966, 0 },
        /*968*/ { 967, 1 },
        /*969*/ { 968, 1 },
        /*970*/ { 969, 1 },
        /*971*/ { 970, 1 },
        /*972*/ { 971, 1 },
        /*973*/ { 972, 1 },
        /*974*/ { 973, 1 },
        /*975*/ { 974, 0 },
        /*976*/ { 975, 1 },
        /*977*/ { 976, 1 },
        /*978*/ { 977, 1 },
        /*979*/ { 978, 1 },
        /*980*/ { 979, 1 },
        /*981*/ { 980, 1 },
        /*982*/ { 981, 1 },
        /*983*/ { 982, 0 },
        /*984*/ { 983, 0 },
        /*985*/ { 984, 1 },
        /*986*/ { 985, 1 },
        /*987*/ { 986, 1 },
        /*988*/ { 987, 0 },
        /*989*/ { 988, 0 },
        /*990*/ { 989, 0 },
        /*991*/ { 990, 1 },
        /*992*/ { 991, 0 },
        /*993*/ { 992, 0 },
        /*994*/ { 993, 0 },
        /*995*/ { 994, 1 },
        /*996*/ { 995, 0 },
        /*997*/ { 996, 0 },
        /*998*/ { 997, 1 },
        /*999*/ { 998, 0 },
        /*1000*/ { 999, 1 },
        /*1001*/ { 1000, 0 },
        /*1002*/ { 2000, 0 },
    };
    int data_size = ARRAY_SIZE(data);
    int i, ret;

    testStart("test_numeric");

    for (i = 0; i < data_size; i++) {

        if (testContinue(p_ctx, i)) continue;

        ret = iso4217_numeric(data[i].data);
        assert_equal(ret, data[i].ret, "i:%d ret %d != %d\n", i, ret, data[i].ret);
    }

    testFinish();
}

/* Binary chop version: Whether ISO 4217 numeric */
static int bc_iso4217_numeric(int cc) {
    static const short codes[178] = {
        /*ALL*/   8, /*DZD*/  12, /*ARS*/  32, /*AUD*/  36, /*BSD*/  44, /*BHD*/  48, /*BDT*/  50, /*AMD*/  51, /*BBD*/  52, /*BMD*/  60,
        /*BTN*/  64, /*BOB*/  68, /*BWP*/  72, /*BZD*/  84, /*SBD*/  90, /*BND*/  96, /*MMK*/ 104, /*BIF*/ 108, /*KHR*/ 116, /*CAD*/ 124,
        /*CVE*/ 132, /*KYD*/ 136, /*LKR*/ 144, /*CLP*/ 152, /*CNY*/ 156, /*COP*/ 170, /*KMF*/ 174, /*CRC*/ 188, /*CUP*/ 192, /*CZK*/ 203,
        /*DKK*/ 208, /*DOP*/ 214, /*SVC*/ 222, /*ETB*/ 230, /*ERN*/ 232, /*FKP*/ 238, /*FJD*/ 242, /*DJF*/ 262, /*GMD*/ 270, /*GIP*/ 292,
        /*GTQ*/ 320, /*GNF*/ 324, /*GYD*/ 328, /*HTG*/ 332, /*HNL*/ 340, /*HKD*/ 344, /*HUF*/ 348, /*ISK*/ 352, /*INR*/ 356, /*IDR*/ 360,
        /*IRR*/ 364, /*IQD*/ 368, /*ILS*/ 376, /*JMD*/ 388, /*JPY*/ 392, /*KZT*/ 398, /*JOD*/ 400, /*KES*/ 404, /*KPW*/ 408, /*KRW*/ 410,
        /*KWD*/ 414, /*KGS*/ 417, /*LAK*/ 418, /*LBP*/ 422, /*LSL*/ 426, /*LRD*/ 430, /*LYD*/ 434, /*MOP*/ 446, /*MWK*/ 454, /*MYR*/ 458,
        /*MVR*/ 462, /*MUR*/ 480, /*MXN*/ 484, /*MNT*/ 496, /*MDL*/ 498, /*MAD*/ 504, /*OMR*/ 512, /*NAD*/ 516, /*NPR*/ 524, /*ANG*/ 532,
        /*AWG*/ 533, /*VUV*/ 548, /*NZD*/ 554, /*NIO*/ 558, /*NGN*/ 566, /*NOK*/ 578, /*PKR*/ 586, /*PAB*/ 590, /*PGK*/ 598, /*PYG*/ 600,
        /*PEN*/ 604, /*PHP*/ 608, /*QAR*/ 634, /*RUB*/ 643, /*RWF*/ 646, /*SHP*/ 654, /*SAR*/ 682, /*SCR*/ 690, /*SGD*/ 702, /*VND*/ 704,
        /*SOS*/ 706, /*ZAR*/ 710, /*SSP*/ 728, /*SZL*/ 748, /*SEK*/ 752, /*CHF*/ 756, /*SYP*/ 760, /*THB*/ 764, /*TOP*/ 776, /*TTD*/ 780,
        /*AED*/ 784, /*TND*/ 788, /*UGX*/ 800, /*MKD*/ 807, /*EGP*/ 818, /*GBP*/ 826, /*TZS*/ 834, /*USD*/ 840, /*UYU*/ 858, /*UZS*/ 860,
        /*WST*/ 882, /*YER*/ 886, /*TWD*/ 901, /*ZWG*/ 924, /*SLE*/ 925, /*VED*/ 926, /*UYW*/ 927, /*VES*/ 928, /*MRU*/ 929, /*STN*/ 930,
        /*BYN*/ 933, /*TMT*/ 934, /*GHS*/ 936, /*SDG*/ 938, /*UYI*/ 940, /*RSD*/ 941, /*MZN*/ 943, /*AZN*/ 944, /*RON*/ 946, /*CHE*/ 947,
        /*CHW*/ 948, /*TRY*/ 949, /*XAF*/ 950, /*XCD*/ 951, /*XOF*/ 952, /*XPF*/ 953, /*XBA*/ 955, /*XBB*/ 956, /*XBC*/ 957, /*XBD*/ 958,
        /*XAU*/ 959, /*XDR*/ 960, /*XAG*/ 961, /*XPT*/ 962, /*XTS*/ 963, /*XPD*/ 964, /*XUA*/ 965, /*ZMW*/ 967, /*SRD*/ 968, /*MGA*/ 969,
        /*COU*/ 970, /*AFN*/ 971, /*TJS*/ 972, /*AOA*/ 973, /*BGN*/ 975, /*CDF*/ 976, /*BAM*/ 977, /*EUR*/ 978, /*MXV*/ 979, /*UAH*/ 980,
        /*GEL*/ 981, /*BOV*/ 984, /*PLN*/ 985, /*BRL*/ 986, /*CLF*/ 990, /*XSU*/ 994, /*USN*/ 997, /*XXX*/ 999,
    };

    int s = 0, e = ARRAY_SIZE(codes) - 1;

    while (s <= e) {
        int m = (s + e) / 2;
        if (codes[m] < cc) {
            s = m + 1;
        } else if (codes[m] > cc) {
            e = m - 1;
        } else {
            return 1;
        }
    }

    return 0;
}

static void test_numeric_bc(const testCtx *const p_ctx) {

    int i, ret, bc_ret;

    testStart("test_numeric_bc");

    for (i = 0; i < 1001; i++) {
        if (testContinue(p_ctx, i)) continue;
        ret = iso4217_numeric(i);
        bc_ret = bc_iso4217_numeric(i);
        assert_equal(ret, bc_ret, "i:%d ret %d != bc_ret %d\n", i, ret, bc_ret);
    }

    testFinish();
}

int main(int argc, char *argv[]) {

    testFunction funcs[] = { /* name, func */
        { "test_numeric", test_numeric },
        { "test_numeric_bc", test_numeric_bc },
    };

    testRun(argc, argv, funcs, ARRAY_SIZE(funcs));

    testReport();

    return 0;
}

/* vim: set ts=4 sw=4 et : */
