/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     float.h
 * Abstract:        include file for "floating" word set
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __FLOAT_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __FLOAT_H__
#define __FLOAT_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(to_float,						">float",				0)
code(d_to_f,						"d>f",					0)
code(f_store,						"f!",					0)
code(f_star,						"f*",					0)
code(f_plus,						"f+",					0)
code(f_minus,						"f-",					0)
code(f_slash,						"f/",					0)
code(f_zero_less,					"f0<",					0)
code(f_zero_equals,					"f0=",					0)
code(f_less_than,					"f<",					0)
code(f_to_d,						"f>d",					0)
code(f_fetch,						"f@",					0)
code(align,							"falign",				0)
code(aligned,						"faligned",				0)
code(f_constant,					"fconstant",			0)
code(f_depth,						"fdepth",				0)
code(f_drop,						"fdrop",				0)
code(f_dupe,						"fdup",					0)
code(f_literal,						"fliteral",				COMP_ONLY | IMMEDIATE)
code(float_plus,					"float+",				0)
code(floats,						"floats",				0)
code(floor,							"floor",				0)
code(f_max,							"fmax",					0)
code(f_min,							"fmin",					0)
code(f_negate,						"fnegate",				0)
code(f_over,						"fover",				0)
code(f_rote,                        "frot",					0)
code(f_round,						"fround",				0)
code(f_swap,						"fswap",				0)
code(f_variable,					"fvariable",			0)
code(represent,                     "represent",            0)

#ifdef PROTOTYPES

#endif

#endif

