/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.BaseEmitter;
import org.j3d.geom.particle.Particle;
import org.j3d.util.interpolator.PositionInterpolator;

public class PolylineEmitter
extends BaseEmitter {
    private static final int DELTA_LIMIT = 5;
    private float particlesPerMs;
    private float[] origin;
    private float[] direction;
    private float[] initialVelocity;
    private boolean usePointSource;
    private PositionInterpolator interpolator;
    private float[] lengthTmp;
    private int zeroDeltaCounter;
    private int elapsedZeroParticleTime;

    public PolylineEmitter() {
        this.initialVelocity = new float[3];
        this.direction = new float[3];
        this.direction[1] = 1.0f;
        this.interpolator = new PositionInterpolator(2);
        this.lengthTmp = new float[2];
        this.usePointSource = true;
        this.elapsedZeroParticleTime = 0;
    }

    public PolylineEmitter(int n, int n2, float[] fArray, float[] fArray2, float[] fArray3, float f, float f2) {
        this(n, n2, fArray, fArray.length / 3, fArray2, fArray3, f, f2);
    }

    public PolylineEmitter(int n, int n2, float[] fArray, int n3, float[] fArray2, float[] fArray3, float f, float f2) {
        super(n, n2, fArray2, f, f2);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
        this.elapsedZeroParticleTime = 0;
        this.initialVelocity = new float[3];
        this.initialVelocity[0] = fArray3[0] * f;
        this.initialVelocity[1] = fArray3[1] * f;
        this.initialVelocity[2] = fArray3[2] * f;
        this.direction = new float[3];
        float f3 = fArray3[0] * fArray3[0] + fArray3[1] * fArray3[1] + fArray3[2] * fArray3[2];
        if (f3 != 0.0f) {
            f3 = 1.0f / f3;
            this.direction[0] = f3 * fArray3[0];
            this.direction[1] = f3 * fArray3[1];
            this.direction[2] = f3 * fArray3[2];
        }
        this.zeroDeltaCounter = 0;
        this.interpolator = new PositionInterpolator(n3);
        this.lengthTmp = new float[n3];
        this.updateEmitterLine(fArray, n3);
    }

    public void setMaxParticleCount(int n) {
        super.setMaxParticleCount(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public void setParticleLifetime(int n) throws IllegalArgumentException {
        super.setParticleLifetime(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = (int)(this.particlesPerMs * (float)n);
                if (n2 != 0) break;
                this.elapsedZeroParticleTime += n;
                n2 = (int)(this.particlesPerMs * (float)this.elapsedZeroParticleTime);
                if (n2 == 0) break;
                this.elapsedZeroParticleTime = 0;
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        float f;
        particle.resultantForce.set(0.0f, 0.0f, 0.0f);
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        float f2 = 1.0f - this.randomiser.nextFloat() * this.lifetimeVariation;
        particle.setCycleTime((int)(f2 * (float)this.lifetime));
        if (this.usePointSource) {
            particle.setPosition(0.0f, 0.0f, 0.0f);
        } else {
            f = this.randomiser.nextFloat();
            float[] fArray = this.interpolator.floatValue(f);
            particle.setPosition(fArray[0], fArray[1], fArray[2]);
        }
        particle.setMass(this.initialMass);
        particle.setSurfaceArea(this.surfaceArea);
        f2 = 1.0f - this.randomiser.nextFloat() * this.variation;
        f = this.initialVelocity[0] * f2;
        float f3 = this.initialVelocity[1] * f2;
        float f4 = this.initialVelocity[2] * f2;
        particle.velocity.set(f, f3, f4);
        return true;
    }

    public void setSpeed(float f) {
        super.setSpeed(f);
        this.initialVelocity[0] = this.direction[0] * f;
        this.initialVelocity[1] = this.direction[1] * f;
        this.initialVelocity[2] = this.direction[2] * f;
    }

    public void setDirection(float f, float f2, float f3) {
        float f4 = f * f + f2 * f2 + f3 * f3;
        if (f4 != 0.0f) {
            f4 = 1.0f / f4;
            f *= f4;
            f2 *= f4;
            f3 *= f4;
        }
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
        this.initialVelocity[0] = f * this.speed;
        this.initialVelocity[1] = f2 * this.speed;
        this.initialVelocity[2] = f3 * this.speed;
    }

    public void setEmitterLine(float[] fArray) {
        this.updateEmitterLine(fArray, fArray.length / 3);
    }

    public void setEmitterLine(float[] fArray, int n) {
        this.updateEmitterLine(fArray, n);
    }

    private void updateEmitterLine(float[] fArray, int n) {
        float f;
        if (n == 0) {
            this.usePointSource = true;
            return;
        }
        this.usePointSource = false;
        this.interpolator.clear();
        if (this.lengthTmp.length < n) {
            this.lengthTmp = new float[n];
        }
        int n2 = 0;
        float f2 = 0.0f;
        for (int i = 0; i < n - 1; ++i) {
            float f3 = fArray[n2] - fArray[n2 + 3];
            f = fArray[n2 + 1] - fArray[n2 + 4];
            float f4 = fArray[n2 + 2] - fArray[n2 + 5];
            this.lengthTmp[i] = f3 * f3 + f * f + f4 * f4;
            f2 += this.lengthTmp[i];
            n2 += 3;
        }
        this.interpolator.addKeyFrame(0.0f, fArray[0], fArray[1], fArray[2]);
        n2 = 3;
        float f5 = 0.0f;
        for (int i = 0; i < n - 1; ++i) {
            f = (f5 += this.lengthTmp[i]) / f2;
            this.interpolator.addKeyFrame(f, fArray[n2++], fArray[n2++], fArray[n2++]);
        }
    }
}

