// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(ldr)                       \
  M(ldrb)                      \
  M(str)                       \
  M(strb)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Sign sign;
  int32_t offset;
  AddrMode addr_mode;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{pl, r13, r0, plus, 0, Offset},
                            false,
                            al,
                            "pl r13 r0 plus 0 Offset",
                            "pl_r13_r0_plus_0_Offset"},
                           {{ge, r5, r3, plus, 0, Offset},
                            false,
                            al,
                            "ge r5 r3 plus 0 Offset",
                            "ge_r5_r3_plus_0_Offset"},
                           {{cc, r0, r4, plus, 0, Offset},
                            false,
                            al,
                            "cc r0 r4 plus 0 Offset",
                            "cc_r0_r4_plus_0_Offset"},
                           {{ge, r0, r0, plus, 0, Offset},
                            false,
                            al,
                            "ge r0 r0 plus 0 Offset",
                            "ge_r0_r0_plus_0_Offset"},
                           {{eq, r12, r3, plus, 0, Offset},
                            false,
                            al,
                            "eq r12 r3 plus 0 Offset",
                            "eq_r12_r3_plus_0_Offset"},
                           {{al, r4, r13, plus, 0, Offset},
                            false,
                            al,
                            "al r4 r13 plus 0 Offset",
                            "al_r4_r13_plus_0_Offset"},
                           {{mi, r8, r2, plus, 0, Offset},
                            false,
                            al,
                            "mi r8 r2 plus 0 Offset",
                            "mi_r8_r2_plus_0_Offset"},
                           {{mi, r6, r9, plus, 0, Offset},
                            false,
                            al,
                            "mi r6 r9 plus 0 Offset",
                            "mi_r6_r9_plus_0_Offset"},
                           {{gt, r13, r11, plus, 0, Offset},
                            false,
                            al,
                            "gt r13 r11 plus 0 Offset",
                            "gt_r13_r11_plus_0_Offset"},
                           {{cs, r0, r7, plus, 0, Offset},
                            false,
                            al,
                            "cs r0 r7 plus 0 Offset",
                            "cs_r0_r7_plus_0_Offset"},
                           {{ge, r7, r11, plus, 0, Offset},
                            false,
                            al,
                            "ge r7 r11 plus 0 Offset",
                            "ge_r7_r11_plus_0_Offset"},
                           {{pl, r11, r12, plus, 0, Offset},
                            false,
                            al,
                            "pl r11 r12 plus 0 Offset",
                            "pl_r11_r12_plus_0_Offset"},
                           {{cs, r2, r12, plus, 0, Offset},
                            false,
                            al,
                            "cs r2 r12 plus 0 Offset",
                            "cs_r2_r12_plus_0_Offset"},
                           {{vc, r2, r14, plus, 0, Offset},
                            false,
                            al,
                            "vc r2 r14 plus 0 Offset",
                            "vc_r2_r14_plus_0_Offset"},
                           {{le, r13, r6, plus, 0, Offset},
                            false,
                            al,
                            "le r13 r6 plus 0 Offset",
                            "le_r13_r6_plus_0_Offset"},
                           {{ls, r1, r2, plus, 0, Offset},
                            false,
                            al,
                            "ls r1 r2 plus 0 Offset",
                            "ls_r1_r2_plus_0_Offset"},
                           {{cc, r1, r6, plus, 0, Offset},
                            false,
                            al,
                            "cc r1 r6 plus 0 Offset",
                            "cc_r1_r6_plus_0_Offset"},
                           {{al, r10, r3, plus, 0, Offset},
                            false,
                            al,
                            "al r10 r3 plus 0 Offset",
                            "al_r10_r3_plus_0_Offset"},
                           {{al, r7, r9, plus, 0, Offset},
                            false,
                            al,
                            "al r7 r9 plus 0 Offset",
                            "al_r7_r9_plus_0_Offset"},
                           {{vs, r5, r3, plus, 0, Offset},
                            false,
                            al,
                            "vs r5 r3 plus 0 Offset",
                            "vs_r5_r3_plus_0_Offset"},
                           {{pl, r4, r4, plus, 0, Offset},
                            false,
                            al,
                            "pl r4 r4 plus 0 Offset",
                            "pl_r4_r4_plus_0_Offset"},
                           {{ne, r11, r9, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r9 plus 0 Offset",
                            "ne_r11_r9_plus_0_Offset"},
                           {{cc, r7, r14, plus, 0, Offset},
                            false,
                            al,
                            "cc r7 r14 plus 0 Offset",
                            "cc_r7_r14_plus_0_Offset"},
                           {{ne, r9, r3, plus, 0, Offset},
                            false,
                            al,
                            "ne r9 r3 plus 0 Offset",
                            "ne_r9_r3_plus_0_Offset"},
                           {{cc, r6, r14, plus, 0, Offset},
                            false,
                            al,
                            "cc r6 r14 plus 0 Offset",
                            "cc_r6_r14_plus_0_Offset"},
                           {{ne, r14, r14, plus, 0, Offset},
                            false,
                            al,
                            "ne r14 r14 plus 0 Offset",
                            "ne_r14_r14_plus_0_Offset"},
                           {{al, r13, r14, plus, 0, Offset},
                            false,
                            al,
                            "al r13 r14 plus 0 Offset",
                            "al_r13_r14_plus_0_Offset"},
                           {{cc, r3, r1, plus, 0, Offset},
                            false,
                            al,
                            "cc r3 r1 plus 0 Offset",
                            "cc_r3_r1_plus_0_Offset"},
                           {{ge, r1, r2, plus, 0, Offset},
                            false,
                            al,
                            "ge r1 r2 plus 0 Offset",
                            "ge_r1_r2_plus_0_Offset"},
                           {{eq, r3, r4, plus, 0, Offset},
                            false,
                            al,
                            "eq r3 r4 plus 0 Offset",
                            "eq_r3_r4_plus_0_Offset"},
                           {{al, r5, r10, plus, 0, Offset},
                            false,
                            al,
                            "al r5 r10 plus 0 Offset",
                            "al_r5_r10_plus_0_Offset"},
                           {{mi, r1, r3, plus, 0, Offset},
                            false,
                            al,
                            "mi r1 r3 plus 0 Offset",
                            "mi_r1_r3_plus_0_Offset"},
                           {{gt, r1, r4, plus, 0, Offset},
                            false,
                            al,
                            "gt r1 r4 plus 0 Offset",
                            "gt_r1_r4_plus_0_Offset"},
                           {{al, r7, r12, plus, 0, Offset},
                            false,
                            al,
                            "al r7 r12 plus 0 Offset",
                            "al_r7_r12_plus_0_Offset"},
                           {{ge, r14, r2, plus, 0, Offset},
                            false,
                            al,
                            "ge r14 r2 plus 0 Offset",
                            "ge_r14_r2_plus_0_Offset"},
                           {{le, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "le r9 r7 plus 0 Offset",
                            "le_r9_r7_plus_0_Offset"},
                           {{al, r9, r14, plus, 0, Offset},
                            false,
                            al,
                            "al r9 r14 plus 0 Offset",
                            "al_r9_r14_plus_0_Offset"},
                           {{hi, r10, r12, plus, 0, Offset},
                            false,
                            al,
                            "hi r10 r12 plus 0 Offset",
                            "hi_r10_r12_plus_0_Offset"},
                           {{le, r6, r5, plus, 0, Offset},
                            false,
                            al,
                            "le r6 r5 plus 0 Offset",
                            "le_r6_r5_plus_0_Offset"},
                           {{cs, r14, r12, plus, 0, Offset},
                            false,
                            al,
                            "cs r14 r12 plus 0 Offset",
                            "cs_r14_r12_plus_0_Offset"},
                           {{vc, r6, r9, plus, 0, Offset},
                            false,
                            al,
                            "vc r6 r9 plus 0 Offset",
                            "vc_r6_r9_plus_0_Offset"},
                           {{ne, r3, r9, plus, 0, Offset},
                            false,
                            al,
                            "ne r3 r9 plus 0 Offset",
                            "ne_r3_r9_plus_0_Offset"},
                           {{lt, r2, r9, plus, 0, Offset},
                            false,
                            al,
                            "lt r2 r9 plus 0 Offset",
                            "lt_r2_r9_plus_0_Offset"},
                           {{vc, r5, r11, plus, 0, Offset},
                            false,
                            al,
                            "vc r5 r11 plus 0 Offset",
                            "vc_r5_r11_plus_0_Offset"},
                           {{gt, r5, r1, plus, 0, Offset},
                            false,
                            al,
                            "gt r5 r1 plus 0 Offset",
                            "gt_r5_r1_plus_0_Offset"},
                           {{al, r12, r4, plus, 0, Offset},
                            false,
                            al,
                            "al r12 r4 plus 0 Offset",
                            "al_r12_r4_plus_0_Offset"},
                           {{ls, r11, r10, plus, 0, Offset},
                            false,
                            al,
                            "ls r11 r10 plus 0 Offset",
                            "ls_r11_r10_plus_0_Offset"},
                           {{eq, r14, r7, plus, 0, Offset},
                            false,
                            al,
                            "eq r14 r7 plus 0 Offset",
                            "eq_r14_r7_plus_0_Offset"},
                           {{vc, r7, r0, plus, 0, Offset},
                            false,
                            al,
                            "vc r7 r0 plus 0 Offset",
                            "vc_r7_r0_plus_0_Offset"},
                           {{le, r2, r6, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r6 plus 0 Offset",
                            "le_r2_r6_plus_0_Offset"},
                           {{gt, r2, r6, plus, 0, Offset},
                            false,
                            al,
                            "gt r2 r6 plus 0 Offset",
                            "gt_r2_r6_plus_0_Offset"},
                           {{al, r6, r6, plus, 0, Offset},
                            false,
                            al,
                            "al r6 r6 plus 0 Offset",
                            "al_r6_r6_plus_0_Offset"},
                           {{ls, r10, r8, plus, 0, Offset},
                            false,
                            al,
                            "ls r10 r8 plus 0 Offset",
                            "ls_r10_r8_plus_0_Offset"},
                           {{lt, r5, r8, plus, 0, Offset},
                            false,
                            al,
                            "lt r5 r8 plus 0 Offset",
                            "lt_r5_r8_plus_0_Offset"},
                           {{vs, r13, r14, plus, 0, Offset},
                            false,
                            al,
                            "vs r13 r14 plus 0 Offset",
                            "vs_r13_r14_plus_0_Offset"},
                           {{gt, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "gt r9 r7 plus 0 Offset",
                            "gt_r9_r7_plus_0_Offset"},
                           {{cc, r8, r9, plus, 0, Offset},
                            false,
                            al,
                            "cc r8 r9 plus 0 Offset",
                            "cc_r8_r9_plus_0_Offset"},
                           {{le, r2, r7, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r7 plus 0 Offset",
                            "le_r2_r7_plus_0_Offset"},
                           {{ge, r0, r1, plus, 0, Offset},
                            false,
                            al,
                            "ge r0 r1 plus 0 Offset",
                            "ge_r0_r1_plus_0_Offset"},
                           {{eq, r10, r14, plus, 0, Offset},
                            false,
                            al,
                            "eq r10 r14 plus 0 Offset",
                            "eq_r10_r14_plus_0_Offset"},
                           {{ls, r3, r3, plus, 0, Offset},
                            false,
                            al,
                            "ls r3 r3 plus 0 Offset",
                            "ls_r3_r3_plus_0_Offset"},
                           {{mi, r11, r6, plus, 0, Offset},
                            false,
                            al,
                            "mi r11 r6 plus 0 Offset",
                            "mi_r11_r6_plus_0_Offset"},
                           {{ne, r14, r12, plus, 0, Offset},
                            false,
                            al,
                            "ne r14 r12 plus 0 Offset",
                            "ne_r14_r12_plus_0_Offset"},
                           {{vs, r1, r12, plus, 0, Offset},
                            false,
                            al,
                            "vs r1 r12 plus 0 Offset",
                            "vs_r1_r12_plus_0_Offset"},
                           {{ls, r0, r0, plus, 0, Offset},
                            false,
                            al,
                            "ls r0 r0 plus 0 Offset",
                            "ls_r0_r0_plus_0_Offset"},
                           {{lt, r12, r14, plus, 0, Offset},
                            false,
                            al,
                            "lt r12 r14 plus 0 Offset",
                            "lt_r12_r14_plus_0_Offset"},
                           {{lt, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "lt r13 r9 plus 0 Offset",
                            "lt_r13_r9_plus_0_Offset"},
                           {{ge, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "ge r13 r9 plus 0 Offset",
                            "ge_r13_r9_plus_0_Offset"},
                           {{cs, r11, r0, plus, 0, Offset},
                            false,
                            al,
                            "cs r11 r0 plus 0 Offset",
                            "cs_r11_r0_plus_0_Offset"},
                           {{hi, r13, r11, plus, 0, Offset},
                            false,
                            al,
                            "hi r13 r11 plus 0 Offset",
                            "hi_r13_r11_plus_0_Offset"},
                           {{cs, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "cs r13 r9 plus 0 Offset",
                            "cs_r13_r9_plus_0_Offset"},
                           {{ne, r10, r10, plus, 0, Offset},
                            false,
                            al,
                            "ne r10 r10 plus 0 Offset",
                            "ne_r10_r10_plus_0_Offset"},
                           {{vc, r13, r9, plus, 0, Offset},
                            false,
                            al,
                            "vc r13 r9 plus 0 Offset",
                            "vc_r13_r9_plus_0_Offset"},
                           {{vc, r9, r3, plus, 0, Offset},
                            false,
                            al,
                            "vc r9 r3 plus 0 Offset",
                            "vc_r9_r3_plus_0_Offset"},
                           {{cc, r10, r4, plus, 0, Offset},
                            false,
                            al,
                            "cc r10 r4 plus 0 Offset",
                            "cc_r10_r4_plus_0_Offset"},
                           {{hi, r6, r6, plus, 0, Offset},
                            false,
                            al,
                            "hi r6 r6 plus 0 Offset",
                            "hi_r6_r6_plus_0_Offset"},
                           {{le, r11, r1, plus, 0, Offset},
                            false,
                            al,
                            "le r11 r1 plus 0 Offset",
                            "le_r11_r1_plus_0_Offset"},
                           {{gt, r3, r5, plus, 0, Offset},
                            false,
                            al,
                            "gt r3 r5 plus 0 Offset",
                            "gt_r3_r5_plus_0_Offset"},
                           {{lt, r0, r10, plus, 0, Offset},
                            false,
                            al,
                            "lt r0 r10 plus 0 Offset",
                            "lt_r0_r10_plus_0_Offset"},
                           {{vs, r6, r0, plus, 0, Offset},
                            false,
                            al,
                            "vs r6 r0 plus 0 Offset",
                            "vs_r6_r0_plus_0_Offset"},
                           {{vs, r8, r9, plus, 0, Offset},
                            false,
                            al,
                            "vs r8 r9 plus 0 Offset",
                            "vs_r8_r9_plus_0_Offset"},
                           {{mi, r9, r7, plus, 0, Offset},
                            false,
                            al,
                            "mi r9 r7 plus 0 Offset",
                            "mi_r9_r7_plus_0_Offset"},
                           {{vs, r12, r11, plus, 0, Offset},
                            false,
                            al,
                            "vs r12 r11 plus 0 Offset",
                            "vs_r12_r11_plus_0_Offset"},
                           {{vc, r11, r7, plus, 0, Offset},
                            false,
                            al,
                            "vc r11 r7 plus 0 Offset",
                            "vc_r11_r7_plus_0_Offset"},
                           {{hi, r11, r5, plus, 0, Offset},
                            false,
                            al,
                            "hi r11 r5 plus 0 Offset",
                            "hi_r11_r5_plus_0_Offset"},
                           {{lt, r0, r11, plus, 0, Offset},
                            false,
                            al,
                            "lt r0 r11 plus 0 Offset",
                            "lt_r0_r11_plus_0_Offset"},
                           {{ne, r11, r1, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r1 plus 0 Offset",
                            "ne_r11_r1_plus_0_Offset"},
                           {{ls, r5, r13, plus, 0, Offset},
                            false,
                            al,
                            "ls r5 r13 plus 0 Offset",
                            "ls_r5_r13_plus_0_Offset"},
                           {{gt, r13, r3, plus, 0, Offset},
                            false,
                            al,
                            "gt r13 r3 plus 0 Offset",
                            "gt_r13_r3_plus_0_Offset"},
                           {{vs, r12, r12, plus, 0, Offset},
                            false,
                            al,
                            "vs r12 r12 plus 0 Offset",
                            "vs_r12_r12_plus_0_Offset"},
                           {{mi, r12, r7, plus, 0, Offset},
                            false,
                            al,
                            "mi r12 r7 plus 0 Offset",
                            "mi_r12_r7_plus_0_Offset"},
                           {{le, r3, r4, plus, 0, Offset},
                            false,
                            al,
                            "le r3 r4 plus 0 Offset",
                            "le_r3_r4_plus_0_Offset"},
                           {{ne, r11, r10, plus, 0, Offset},
                            false,
                            al,
                            "ne r11 r10 plus 0 Offset",
                            "ne_r11_r10_plus_0_Offset"},
                           {{gt, r6, r13, plus, 0, Offset},
                            false,
                            al,
                            "gt r6 r13 plus 0 Offset",
                            "gt_r6_r13_plus_0_Offset"},
                           {{hi, r4, r8, plus, 0, Offset},
                            false,
                            al,
                            "hi r4 r8 plus 0 Offset",
                            "hi_r4_r8_plus_0_Offset"},
                           {{ge, r14, r5, plus, 0, Offset},
                            false,
                            al,
                            "ge r14 r5 plus 0 Offset",
                            "ge_r14_r5_plus_0_Offset"},
                           {{vc, r9, r6, plus, 0, Offset},
                            false,
                            al,
                            "vc r9 r6 plus 0 Offset",
                            "vc_r9_r6_plus_0_Offset"},
                           {{le, r2, r9, plus, 0, Offset},
                            false,
                            al,
                            "le r2 r9 plus 0 Offset",
                            "le_r2_r9_plus_0_Offset"},
                           {{ne, r10, r4, plus, 0, Offset},
                            false,
                            al,
                            "ne r10 r4 plus 0 Offset",
                            "ne_r10_r4_plus_0_Offset"},
                           {{vs, r10, r14, plus, 0, Offset},
                            false,
                            al,
                            "vs r10 r14 plus 0 Offset",
                            "vs_r10_r14_plus_0_Offset"},
                           {{al, r0, r11, minus, 2628, Offset},
                            false,
                            al,
                            "al r0 r11 minus 2628 Offset",
                            "al_r0_r11_minus_2628_Offset"},
                           {{al, r0, r9, minus, 136, Offset},
                            false,
                            al,
                            "al r0 r9 minus 136 Offset",
                            "al_r0_r9_minus_136_Offset"},
                           {{al, r0, r9, plus, 2323, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2323 Offset",
                            "al_r0_r9_plus_2323_Offset"},
                           {{al, r0, r12, plus, 138, Offset},
                            false,
                            al,
                            "al r0 r12 plus 138 Offset",
                            "al_r0_r12_plus_138_Offset"},
                           {{al, r0, r13, plus, 3266, Offset},
                            false,
                            al,
                            "al r0 r13 plus 3266 Offset",
                            "al_r0_r13_plus_3266_Offset"},
                           {{al, r0, r8, minus, 2052, Offset},
                            false,
                            al,
                            "al r0 r8 minus 2052 Offset",
                            "al_r0_r8_minus_2052_Offset"},
                           {{al, r0, r9, minus, 1922, Offset},
                            false,
                            al,
                            "al r0 r9 minus 1922 Offset",
                            "al_r0_r9_minus_1922_Offset"},
                           {{al, r0, r13, minus, 3659, Offset},
                            false,
                            al,
                            "al r0 r13 minus 3659 Offset",
                            "al_r0_r13_minus_3659_Offset"},
                           {{al, r0, r14, minus, 1043, Offset},
                            false,
                            al,
                            "al r0 r14 minus 1043 Offset",
                            "al_r0_r14_minus_1043_Offset"},
                           {{al, r0, r5, minus, 3772, Offset},
                            false,
                            al,
                            "al r0 r5 minus 3772 Offset",
                            "al_r0_r5_minus_3772_Offset"},
                           {{al, r0, r0, plus, 188, Offset},
                            false,
                            al,
                            "al r0 r0 plus 188 Offset",
                            "al_r0_r0_plus_188_Offset"},
                           {{al, r0, r0, plus, 1407, Offset},
                            false,
                            al,
                            "al r0 r0 plus 1407 Offset",
                            "al_r0_r0_plus_1407_Offset"},
                           {{al, r0, r7, plus, 872, Offset},
                            false,
                            al,
                            "al r0 r7 plus 872 Offset",
                            "al_r0_r7_plus_872_Offset"},
                           {{al, r0, r4, minus, 3109, Offset},
                            false,
                            al,
                            "al r0 r4 minus 3109 Offset",
                            "al_r0_r4_minus_3109_Offset"},
                           {{al, r0, r13, plus, 1665, Offset},
                            false,
                            al,
                            "al r0 r13 plus 1665 Offset",
                            "al_r0_r13_plus_1665_Offset"},
                           {{al, r0, r1, plus, 3636, Offset},
                            false,
                            al,
                            "al r0 r1 plus 3636 Offset",
                            "al_r0_r1_plus_3636_Offset"},
                           {{al, r0, r6, minus, 770, Offset},
                            false,
                            al,
                            "al r0 r6 minus 770 Offset",
                            "al_r0_r6_minus_770_Offset"},
                           {{al, r0, r11, minus, 2703, Offset},
                            false,
                            al,
                            "al r0 r11 minus 2703 Offset",
                            "al_r0_r11_minus_2703_Offset"},
                           {{al, r0, r9, minus, 3504, Offset},
                            false,
                            al,
                            "al r0 r9 minus 3504 Offset",
                            "al_r0_r9_minus_3504_Offset"},
                           {{al, r0, r5, minus, 3425, Offset},
                            false,
                            al,
                            "al r0 r5 minus 3425 Offset",
                            "al_r0_r5_minus_3425_Offset"},
                           {{al, r0, r2, minus, 138, Offset},
                            false,
                            al,
                            "al r0 r2 minus 138 Offset",
                            "al_r0_r2_minus_138_Offset"},
                           {{al, r0, r0, minus, 470, Offset},
                            false,
                            al,
                            "al r0 r0 minus 470 Offset",
                            "al_r0_r0_minus_470_Offset"},
                           {{al, r0, r14, plus, 1472, Offset},
                            false,
                            al,
                            "al r0 r14 plus 1472 Offset",
                            "al_r0_r14_plus_1472_Offset"},
                           {{al, r0, r14, plus, 4058, Offset},
                            false,
                            al,
                            "al r0 r14 plus 4058 Offset",
                            "al_r0_r14_plus_4058_Offset"},
                           {{al, r0, r5, plus, 513, Offset},
                            false,
                            al,
                            "al r0 r5 plus 513 Offset",
                            "al_r0_r5_plus_513_Offset"},
                           {{al, r0, r11, minus, 791, Offset},
                            false,
                            al,
                            "al r0 r11 minus 791 Offset",
                            "al_r0_r11_minus_791_Offset"},
                           {{al, r0, r5, minus, 441, Offset},
                            false,
                            al,
                            "al r0 r5 minus 441 Offset",
                            "al_r0_r5_minus_441_Offset"},
                           {{al, r0, r11, plus, 1266, Offset},
                            false,
                            al,
                            "al r0 r11 plus 1266 Offset",
                            "al_r0_r11_plus_1266_Offset"},
                           {{al, r0, r4, plus, 2901, Offset},
                            false,
                            al,
                            "al r0 r4 plus 2901 Offset",
                            "al_r0_r4_plus_2901_Offset"},
                           {{al, r0, r12, minus, 1394, Offset},
                            false,
                            al,
                            "al r0 r12 minus 1394 Offset",
                            "al_r0_r12_minus_1394_Offset"},
                           {{al, r0, r7, plus, 1651, Offset},
                            false,
                            al,
                            "al r0 r7 plus 1651 Offset",
                            "al_r0_r7_plus_1651_Offset"},
                           {{al, r0, r9, plus, 2710, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2710 Offset",
                            "al_r0_r9_plus_2710_Offset"},
                           {{al, r0, r12, plus, 1845, Offset},
                            false,
                            al,
                            "al r0 r12 plus 1845 Offset",
                            "al_r0_r12_plus_1845_Offset"},
                           {{al, r0, r5, minus, 2247, Offset},
                            false,
                            al,
                            "al r0 r5 minus 2247 Offset",
                            "al_r0_r5_minus_2247_Offset"},
                           {{al, r0, r7, plus, 3739, Offset},
                            false,
                            al,
                            "al r0 r7 plus 3739 Offset",
                            "al_r0_r7_plus_3739_Offset"},
                           {{al, r0, r0, plus, 3117, Offset},
                            false,
                            al,
                            "al r0 r0 plus 3117 Offset",
                            "al_r0_r0_plus_3117_Offset"},
                           {{al, r0, r2, minus, 3078, Offset},
                            false,
                            al,
                            "al r0 r2 minus 3078 Offset",
                            "al_r0_r2_minus_3078_Offset"},
                           {{al, r0, r4, plus, 2427, Offset},
                            false,
                            al,
                            "al r0 r4 plus 2427 Offset",
                            "al_r0_r4_plus_2427_Offset"},
                           {{al, r0, r3, minus, 2137, Offset},
                            false,
                            al,
                            "al r0 r3 minus 2137 Offset",
                            "al_r0_r3_minus_2137_Offset"},
                           {{al, r0, r14, plus, 3425, Offset},
                            false,
                            al,
                            "al r0 r14 plus 3425 Offset",
                            "al_r0_r14_plus_3425_Offset"},
                           {{al, r0, r2, plus, 3728, Offset},
                            false,
                            al,
                            "al r0 r2 plus 3728 Offset",
                            "al_r0_r2_plus_3728_Offset"},
                           {{al, r0, r14, plus, 1835, Offset},
                            false,
                            al,
                            "al r0 r14 plus 1835 Offset",
                            "al_r0_r14_plus_1835_Offset"},
                           {{al, r0, r9, minus, 3438, Offset},
                            false,
                            al,
                            "al r0 r9 minus 3438 Offset",
                            "al_r0_r9_minus_3438_Offset"},
                           {{al, r0, r4, minus, 2381, Offset},
                            false,
                            al,
                            "al r0 r4 minus 2381 Offset",
                            "al_r0_r4_minus_2381_Offset"},
                           {{al, r0, r3, plus, 1740, Offset},
                            false,
                            al,
                            "al r0 r3 plus 1740 Offset",
                            "al_r0_r3_plus_1740_Offset"},
                           {{al, r0, r5, minus, 4056, Offset},
                            false,
                            al,
                            "al r0 r5 minus 4056 Offset",
                            "al_r0_r5_minus_4056_Offset"},
                           {{al, r0, r7, minus, 1479, Offset},
                            false,
                            al,
                            "al r0 r7 minus 1479 Offset",
                            "al_r0_r7_minus_1479_Offset"},
                           {{al, r0, r10, plus, 1899, Offset},
                            false,
                            al,
                            "al r0 r10 plus 1899 Offset",
                            "al_r0_r10_plus_1899_Offset"},
                           {{al, r0, r5, plus, 2183, Offset},
                            false,
                            al,
                            "al r0 r5 plus 2183 Offset",
                            "al_r0_r5_plus_2183_Offset"},
                           {{al, r0, r2, minus, 371, Offset},
                            false,
                            al,
                            "al r0 r2 minus 371 Offset",
                            "al_r0_r2_minus_371_Offset"},
                           {{al, r0, r12, minus, 348, Offset},
                            false,
                            al,
                            "al r0 r12 minus 348 Offset",
                            "al_r0_r12_minus_348_Offset"},
                           {{al, r0, r13, minus, 3397, Offset},
                            false,
                            al,
                            "al r0 r13 minus 3397 Offset",
                            "al_r0_r13_minus_3397_Offset"},
                           {{al, r0, r5, minus, 1168, Offset},
                            false,
                            al,
                            "al r0 r5 minus 1168 Offset",
                            "al_r0_r5_minus_1168_Offset"},
                           {{al, r0, r0, minus, 2040, Offset},
                            false,
                            al,
                            "al r0 r0 minus 2040 Offset",
                            "al_r0_r0_minus_2040_Offset"},
                           {{al, r0, r6, plus, 663, Offset},
                            false,
                            al,
                            "al r0 r6 plus 663 Offset",
                            "al_r0_r6_plus_663_Offset"},
                           {{al, r0, r10, minus, 1050, Offset},
                            false,
                            al,
                            "al r0 r10 minus 1050 Offset",
                            "al_r0_r10_minus_1050_Offset"},
                           {{al, r0, r4, plus, 2726, Offset},
                            false,
                            al,
                            "al r0 r4 plus 2726 Offset",
                            "al_r0_r4_plus_2726_Offset"},
                           {{al, r0, r12, plus, 3963, Offset},
                            false,
                            al,
                            "al r0 r12 plus 3963 Offset",
                            "al_r0_r12_plus_3963_Offset"},
                           {{al, r0, r3, plus, 2069, Offset},
                            false,
                            al,
                            "al r0 r3 plus 2069 Offset",
                            "al_r0_r3_plus_2069_Offset"},
                           {{al, r0, r5, minus, 669, Offset},
                            false,
                            al,
                            "al r0 r5 minus 669 Offset",
                            "al_r0_r5_minus_669_Offset"},
                           {{al, r0, r13, minus, 3117, Offset},
                            false,
                            al,
                            "al r0 r13 minus 3117 Offset",
                            "al_r0_r13_minus_3117_Offset"},
                           {{al, r0, r4, minus, 783, Offset},
                            false,
                            al,
                            "al r0 r4 minus 783 Offset",
                            "al_r0_r4_minus_783_Offset"},
                           {{al, r0, r6, plus, 4093, Offset},
                            false,
                            al,
                            "al r0 r6 plus 4093 Offset",
                            "al_r0_r6_plus_4093_Offset"},
                           {{al, r0, r10, minus, 1438, Offset},
                            false,
                            al,
                            "al r0 r10 minus 1438 Offset",
                            "al_r0_r10_minus_1438_Offset"},
                           {{al, r0, r1, plus, 3975, Offset},
                            false,
                            al,
                            "al r0 r1 plus 3975 Offset",
                            "al_r0_r1_plus_3975_Offset"},
                           {{al, r0, r14, minus, 1732, Offset},
                            false,
                            al,
                            "al r0 r14 minus 1732 Offset",
                            "al_r0_r14_minus_1732_Offset"},
                           {{al, r0, r3, plus, 3907, Offset},
                            false,
                            al,
                            "al r0 r3 plus 3907 Offset",
                            "al_r0_r3_plus_3907_Offset"},
                           {{al, r0, r0, plus, 3626, Offset},
                            false,
                            al,
                            "al r0 r0 plus 3626 Offset",
                            "al_r0_r0_plus_3626_Offset"},
                           {{al, r0, r2, minus, 1769, Offset},
                            false,
                            al,
                            "al r0 r2 minus 1769 Offset",
                            "al_r0_r2_minus_1769_Offset"},
                           {{al, r0, r10, plus, 3975, Offset},
                            false,
                            al,
                            "al r0 r10 plus 3975 Offset",
                            "al_r0_r10_plus_3975_Offset"},
                           {{al, r0, r7, plus, 1475, Offset},
                            false,
                            al,
                            "al r0 r7 plus 1475 Offset",
                            "al_r0_r7_plus_1475_Offset"},
                           {{al, r0, r13, minus, 2768, Offset},
                            false,
                            al,
                            "al r0 r13 minus 2768 Offset",
                            "al_r0_r13_minus_2768_Offset"},
                           {{al, r0, r13, minus, 766, Offset},
                            false,
                            al,
                            "al r0 r13 minus 766 Offset",
                            "al_r0_r13_minus_766_Offset"},
                           {{al, r0, r13, plus, 2026, Offset},
                            false,
                            al,
                            "al r0 r13 plus 2026 Offset",
                            "al_r0_r13_plus_2026_Offset"},
                           {{al, r0, r9, plus, 582, Offset},
                            false,
                            al,
                            "al r0 r9 plus 582 Offset",
                            "al_r0_r9_plus_582_Offset"},
                           {{al, r0, r9, minus, 2208, Offset},
                            false,
                            al,
                            "al r0 r9 minus 2208 Offset",
                            "al_r0_r9_minus_2208_Offset"},
                           {{al, r0, r5, plus, 3772, Offset},
                            false,
                            al,
                            "al r0 r5 plus 3772 Offset",
                            "al_r0_r5_plus_3772_Offset"},
                           {{al, r0, r13, minus, 3405, Offset},
                            false,
                            al,
                            "al r0 r13 minus 3405 Offset",
                            "al_r0_r13_minus_3405_Offset"},
                           {{al, r0, r4, plus, 470, Offset},
                            false,
                            al,
                            "al r0 r4 plus 470 Offset",
                            "al_r0_r4_plus_470_Offset"},
                           {{al, r0, r4, plus, 2933, Offset},
                            false,
                            al,
                            "al r0 r4 plus 2933 Offset",
                            "al_r0_r4_plus_2933_Offset"},
                           {{al, r0, r6, minus, 3608, Offset},
                            false,
                            al,
                            "al r0 r6 minus 3608 Offset",
                            "al_r0_r6_minus_3608_Offset"},
                           {{al, r0, r2, plus, 2098, Offset},
                            false,
                            al,
                            "al r0 r2 plus 2098 Offset",
                            "al_r0_r2_plus_2098_Offset"},
                           {{al, r0, r9, plus, 2026, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2026 Offset",
                            "al_r0_r9_plus_2026_Offset"},
                           {{al, r0, r1, minus, 3899, Offset},
                            false,
                            al,
                            "al r0 r1 minus 3899 Offset",
                            "al_r0_r1_minus_3899_Offset"},
                           {{al, r0, r10, minus, 4056, Offset},
                            false,
                            al,
                            "al r0 r10 minus 4056 Offset",
                            "al_r0_r10_minus_4056_Offset"},
                           {{al, r0, r4, plus, 932, Offset},
                            false,
                            al,
                            "al r0 r4 plus 932 Offset",
                            "al_r0_r4_plus_932_Offset"},
                           {{al, r0, r2, plus, 2976, Offset},
                            false,
                            al,
                            "al r0 r2 plus 2976 Offset",
                            "al_r0_r2_plus_2976_Offset"},
                           {{al, r0, r10, minus, 3702, Offset},
                            false,
                            al,
                            "al r0 r10 minus 3702 Offset",
                            "al_r0_r10_minus_3702_Offset"},
                           {{al, r0, r2, minus, 1394, Offset},
                            false,
                            al,
                            "al r0 r2 minus 1394 Offset",
                            "al_r0_r2_minus_1394_Offset"},
                           {{al, r0, r2, plus, 831, Offset},
                            false,
                            al,
                            "al r0 r2 plus 831 Offset",
                            "al_r0_r2_plus_831_Offset"},
                           {{al, r0, r0, minus, 3685, Offset},
                            false,
                            al,
                            "al r0 r0 minus 3685 Offset",
                            "al_r0_r0_minus_3685_Offset"},
                           {{al, r0, r12, plus, 2619, Offset},
                            false,
                            al,
                            "al r0 r12 plus 2619 Offset",
                            "al_r0_r12_plus_2619_Offset"},
                           {{al, r0, r4, plus, 3063, Offset},
                            false,
                            al,
                            "al r0 r4 plus 3063 Offset",
                            "al_r0_r4_plus_3063_Offset"},
                           {{al, r0, r0, plus, 1479, Offset},
                            false,
                            al,
                            "al r0 r0 plus 1479 Offset",
                            "al_r0_r0_plus_1479_Offset"},
                           {{al, r0, r6, plus, 2091, Offset},
                            false,
                            al,
                            "al r0 r6 plus 2091 Offset",
                            "al_r0_r6_plus_2091_Offset"},
                           {{al, r0, r9, plus, 2721, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2721 Offset",
                            "al_r0_r9_plus_2721_Offset"},
                           {{al, r0, r10, minus, 3343, Offset},
                            false,
                            al,
                            "al r0 r10 minus 3343 Offset",
                            "al_r0_r10_minus_3343_Offset"},
                           {{al, r0, r2, plus, 3413, Offset},
                            false,
                            al,
                            "al r0 r2 plus 3413 Offset",
                            "al_r0_r2_plus_3413_Offset"},
                           {{al, r0, r9, plus, 1740, Offset},
                            false,
                            al,
                            "al r0 r9 plus 1740 Offset",
                            "al_r0_r9_plus_1740_Offset"},
                           {{al, r0, r7, plus, 831, Offset},
                            false,
                            al,
                            "al r0 r7 plus 831 Offset",
                            "al_r0_r7_plus_831_Offset"},
                           {{al, r0, r13, plus, 3384, Offset},
                            false,
                            al,
                            "al r0 r13 plus 3384 Offset",
                            "al_r0_r13_plus_3384_Offset"},
                           {{al, r0, r13, plus, 3978, Offset},
                            false,
                            al,
                            "al r0 r13 plus 3978 Offset",
                            "al_r0_r13_plus_3978_Offset"},
                           {{al, r0, r0, minus, 1860, Offset},
                            false,
                            al,
                            "al r0 r0 minus 1860 Offset",
                            "al_r0_r0_minus_1860_Offset"},
                           {{al, r0, r9, plus, 2047, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2047 Offset",
                            "al_r0_r9_plus_2047_Offset"},
                           {{al, r0, r9, plus, 2519, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2519 Offset",
                            "al_r0_r9_plus_2519_Offset"},
                           {{al, r0, r5, minus, 1666, Offset},
                            false,
                            al,
                            "al r0 r5 minus 1666 Offset",
                            "al_r0_r5_minus_1666_Offset"},
                           {{al, r0, r8, minus, 496, Offset},
                            false,
                            al,
                            "al r0 r8 minus 496 Offset",
                            "al_r0_r8_minus_496_Offset"},
                           {{al, r0, r7, minus, 484, Offset},
                            false,
                            al,
                            "al r0 r7 minus 484 Offset",
                            "al_r0_r7_minus_484_Offset"},
                           {{al, r0, r2, minus, 1527, Offset},
                            false,
                            al,
                            "al r0 r2 minus 1527 Offset",
                            "al_r0_r2_minus_1527_Offset"},
                           {{al, r0, r7, minus, 2454, Offset},
                            false,
                            al,
                            "al r0 r7 minus 2454 Offset",
                            "al_r0_r7_minus_2454_Offset"},
                           {{al, r0, r8, plus, 1712, Offset},
                            false,
                            al,
                            "al r0 r8 plus 1712 Offset",
                            "al_r0_r8_plus_1712_Offset"},
                           {{al, r0, r6, plus, 3079, Offset},
                            false,
                            al,
                            "al r0 r6 plus 3079 Offset",
                            "al_r0_r6_plus_3079_Offset"},
                           {{al, r0, r8, minus, 510, Offset},
                            false,
                            al,
                            "al r0 r8 minus 510 Offset",
                            "al_r0_r8_minus_510_Offset"},
                           {{al, r0, r1, plus, 3194, Offset},
                            false,
                            al,
                            "al r0 r1 plus 3194 Offset",
                            "al_r0_r1_plus_3194_Offset"},
                           {{al, r0, r12, plus, 1027, Offset},
                            false,
                            al,
                            "al r0 r12 plus 1027 Offset",
                            "al_r0_r12_plus_1027_Offset"},
                           {{al, r0, r3, minus, 3438, Offset},
                            false,
                            al,
                            "al r0 r3 minus 3438 Offset",
                            "al_r0_r3_minus_3438_Offset"},
                           {{al, r0, r14, minus, 612, Offset},
                            false,
                            al,
                            "al r0 r14 minus 612 Offset",
                            "al_r0_r14_minus_612_Offset"},
                           {{al, r0, r4, minus, 251, Offset},
                            false,
                            al,
                            "al r0 r4 minus 251 Offset",
                            "al_r0_r4_minus_251_Offset"},
                           {{al, r0, r9, plus, 2728, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2728 Offset",
                            "al_r0_r9_plus_2728_Offset"},
                           {{al, r0, r14, plus, 1017, Offset},
                            false,
                            al,
                            "al r0 r14 plus 1017 Offset",
                            "al_r0_r14_plus_1017_Offset"},
                           {{al, r0, r14, plus, 1050, Offset},
                            false,
                            al,
                            "al r0 r14 plus 1050 Offset",
                            "al_r0_r14_plus_1050_Offset"},
                           {{al, r0, r7, minus, 2464, Offset},
                            false,
                            al,
                            "al r0 r7 minus 2464 Offset",
                            "al_r0_r7_minus_2464_Offset"},
                           {{al, r0, r0, plus, 2247, Offset},
                            false,
                            al,
                            "al r0 r0 plus 2247 Offset",
                            "al_r0_r0_plus_2247_Offset"},
                           {{al, r0, r3, plus, 1357, Offset},
                            false,
                            al,
                            "al r0 r3 plus 1357 Offset",
                            "al_r0_r3_plus_1357_Offset"},
                           {{al, r0, r1, plus, 2701, Offset},
                            false,
                            al,
                            "al r0 r1 plus 2701 Offset",
                            "al_r0_r1_plus_2701_Offset"},
                           {{al, r0, r5, minus, 22, Offset},
                            false,
                            al,
                            "al r0 r5 minus 22 Offset",
                            "al_r0_r5_minus_22_Offset"},
                           {{al, r0, r7, minus, 3015, Offset},
                            false,
                            al,
                            "al r0 r7 minus 3015 Offset",
                            "al_r0_r7_minus_3015_Offset"},
                           {{al, r0, r3, plus, 3517, Offset},
                            false,
                            al,
                            "al r0 r3 plus 3517 Offset",
                            "al_r0_r3_plus_3517_Offset"},
                           {{al, r0, r2, minus, 1309, Offset},
                            false,
                            al,
                            "al r0 r2 minus 1309 Offset",
                            "al_r0_r2_minus_1309_Offset"},
                           {{al, r0, r9, plus, 2381, Offset},
                            false,
                            al,
                            "al r0 r9 plus 2381 Offset",
                            "al_r0_r9_plus_2381_Offset"},
                           {{al, r0, r5, minus, 663, Offset},
                            false,
                            al,
                            "al r0 r5 minus 663 Offset",
                            "al_r0_r5_minus_663_Offset"},
                           {{al, r0, r10, minus, 3867, Offset},
                            false,
                            al,
                            "al r0 r10 minus 3867 Offset",
                            "al_r0_r10_minus_3867_Offset"},
                           {{al, r0, r0, plus, 1655, Offset},
                            false,
                            al,
                            "al r0 r0 plus 1655 Offset",
                            "al_r0_r0_plus_1655_Offset"},
                           {{al, r0, r6, plus, 513, Offset},
                            false,
                            al,
                            "al r0 r6 plus 513 Offset",
                            "al_r0_r6_plus_513_Offset"},
                           {{al, r0, r9, plus, 233, Offset},
                            false,
                            al,
                            "al r0 r9 plus 233 Offset",
                            "al_r0_r9_plus_233_Offset"},
                           {{al, r0, r8, minus, 22, Offset},
                            false,
                            al,
                            "al r0 r8 minus 22 Offset",
                            "al_r0_r8_minus_22_Offset"},
                           {{al, r0, r12, plus, 470, Offset},
                            false,
                            al,
                            "al r0 r12 plus 470 Offset",
                            "al_r0_r12_plus_470_Offset"},
                           {{al, r0, r11, plus, 2945, Offset},
                            false,
                            al,
                            "al r0 r11 plus 2945 Offset",
                            "al_r0_r11_plus_2945_Offset"},
                           {{al, r0, r8, plus, 2245, Offset},
                            false,
                            al,
                            "al r0 r8 plus 2245 Offset",
                            "al_r0_r8_plus_2245_Offset"},
                           {{al, r0, r14, minus, 1916, Offset},
                            false,
                            al,
                            "al r0 r14 minus 1916 Offset",
                            "al_r0_r14_minus_1916_Offset"},
                           {{al, r0, r3, minus, 3487, Offset},
                            false,
                            al,
                            "al r0 r3 minus 3487 Offset",
                            "al_r0_r3_minus_3487_Offset"},
                           {{al, r0, r5, minus, 960, Offset},
                            false,
                            al,
                            "al r0 r5 minus 960 Offset",
                            "al_r0_r5_minus_960_Offset"},
                           {{al, r0, r8, minus, 3660, Offset},
                            false,
                            al,
                            "al r0 r8 minus 3660 Offset",
                            "al_r0_r8_minus_3660_Offset"},
                           {{al, r0, r0, plus, 2627, Offset},
                            false,
                            al,
                            "al r0 r0 plus 2627 Offset",
                            "al_r0_r0_plus_2627_Offset"},
                           {{al, r0, r5, minus, 1892, Offset},
                            false,
                            al,
                            "al r0 r5 minus 1892 Offset",
                            "al_r0_r5_minus_1892_Offset"},
                           {{al, r0, r7, plus, 1712, Offset},
                            false,
                            al,
                            "al r0 r7 plus 1712 Offset",
                            "al_r0_r7_plus_1712_Offset"},
                           {{al, r0, r3, minus, 3880, Offset},
                            false,
                            al,
                            "al r0 r3 minus 3880 Offset",
                            "al_r0_r3_minus_3880_Offset"},
                           {{al, r0, r13, plus, 188, Offset},
                            false,
                            al,
                            "al r0 r13 plus 188 Offset",
                            "al_r0_r13_plus_188_Offset"},
                           {{al, r0, r0, minus, 2314, Offset},
                            false,
                            al,
                            "al r0 r0 minus 2314 Offset",
                            "al_r0_r0_minus_2314_Offset"},
                           {{al, r0, r3, plus, 999, Offset},
                            false,
                            al,
                            "al r0 r3 plus 999 Offset",
                            "al_r0_r3_plus_999_Offset"},
                           {{al, r0, r1, minus, 2559, Offset},
                            false,
                            al,
                            "al r0 r1 minus 2559 Offset",
                            "al_r0_r1_minus_2559_Offset"},
                           {{al, r0, r4, plus, 3570, Offset},
                            false,
                            al,
                            "al r0 r4 plus 3570 Offset",
                            "al_r0_r4_plus_3570_Offset"},
                           {{al, r0, r2, plus, 2710, Offset},
                            false,
                            al,
                            "al r0 r2 plus 2710 Offset",
                            "al_r0_r2_plus_2710_Offset"},
                           {{al, r0, r4, minus, 3952, Offset},
                            false,
                            al,
                            "al r0 r4 minus 3952 Offset",
                            "al_r0_r4_minus_3952_Offset"},
                           {{al, r0, r9, minus, 2546, Offset},
                            false,
                            al,
                            "al r0 r9 minus 2546 Offset",
                            "al_r0_r9_minus_2546_Offset"},
                           {{al, r0, r11, plus, 3449, Offset},
                            false,
                            al,
                            "al r0 r11 plus 3449 Offset",
                            "al_r0_r11_plus_3449_Offset"},
                           {{al, r0, r12, minus, 670, Offset},
                            false,
                            al,
                            "al r0 r12 minus 670 Offset",
                            "al_r0_r12_minus_670_Offset"},
                           {{al, r0, r7, plus, 2703, Offset},
                            false,
                            al,
                            "al r0 r7 plus 2703 Offset",
                            "al_r0_r7_plus_2703_Offset"},
                           {{al, r0, r10, plus, 3139, Offset},
                            false,
                            al,
                            "al r0 r10 plus 3139 Offset",
                            "al_r0_r10_plus_3139_Offset"},
                           {{al, r0, r4, minus, 2052, Offset},
                            false,
                            al,
                            "al r0 r4 minus 2052 Offset",
                            "al_r0_r4_minus_2052_Offset"},
                           {{al, r0, r2, plus, 481, Offset},
                            false,
                            al,
                            "al r0 r2 plus 481 Offset",
                            "al_r0_r2_plus_481_Offset"},
                           {{al, r0, r13, minus, 2796, Offset},
                            false,
                            al,
                            "al r0 r13 minus 2796 Offset",
                            "al_r0_r13_minus_2796_Offset"},
                           {{al, r0, r14, minus, 322, Offset},
                            false,
                            al,
                            "al r0 r14 minus 322 Offset",
                            "al_r0_r14_minus_322_Offset"},
                           {{al, r0, r14, plus, 1455, Offset},
                            false,
                            al,
                            "al r0 r14 plus 1455 Offset",
                            "al_r0_r14_plus_1455_Offset"},
                           {{al, r0, r5, plus, 1458, Offset},
                            false,
                            al,
                            "al r0 r5 plus 1458 Offset",
                            "al_r0_r5_plus_1458_Offset"},
                           {{al, r0, r0, minus, 371, Offset},
                            false,
                            al,
                            "al r0 r0 minus 371 Offset",
                            "al_r0_r0_minus_371_Offset"},
                           {{al, r0, r12, minus, 2366, Offset},
                            false,
                            al,
                            "al r0 r12 minus 2366 Offset",
                            "al_r0_r12_minus_2366_Offset"},
                           {{al, r0, r2, plus, 2796, Offset},
                            false,
                            al,
                            "al r0 r2 plus 2796 Offset",
                            "al_r0_r2_plus_2796_Offset"},
                           {{al, r0, r1, plus, 3041, Offset},
                            false,
                            al,
                            "al r0 r1 plus 3041 Offset",
                            "al_r0_r1_plus_3041_Offset"},
                           {{al, r0, r2, plus, 688, Offset},
                            false,
                            al,
                            "al r0 r2 plus 688 Offset",
                            "al_r0_r2_plus_688_Offset"},
                           {{al, r0, r7, minus, 371, Offset},
                            false,
                            al,
                            "al r0 r7 minus 371 Offset",
                            "al_r0_r7_minus_371_Offset"},
                           {{al, r0, r5, plus, 1498, Offset},
                            false,
                            al,
                            "al r0 r5 plus 1498 Offset",
                            "al_r0_r5_plus_1498_Offset"},
                           {{al, r0, r7, plus, 4091, Offset},
                            false,
                            al,
                            "al r0 r7 plus 4091 Offset",
                            "al_r0_r7_plus_4091_Offset"},
                           {{al, r0, r4, minus, 2208, Offset},
                            false,
                            al,
                            "al r0 r4 minus 2208 Offset",
                            "al_r0_r4_minus_2208_Offset"},
                           {{al, r0, r3, plus, 1823, Offset},
                            false,
                            al,
                            "al r0 r3 plus 1823 Offset",
                            "al_r0_r3_plus_1823_Offset"},
                           {{al, r0, r0, minus, 2175, Offset},
                            false,
                            al,
                            "al r0 r0 minus 2175 Offset",
                            "al_r0_r0_minus_2175_Offset"},
                           {{al, r0, r14, plus, 2532, Offset},
                            false,
                            al,
                            "al r0 r14 plus 2532 Offset",
                            "al_r0_r14_plus_2532_Offset"},
                           {{al, r0, r7, plus, 2768, Offset},
                            false,
                            al,
                            "al r0 r7 plus 2768 Offset",
                            "al_r0_r7_plus_2768_Offset"},
                           {{al, r0, r8, minus, 778, Offset},
                            false,
                            al,
                            "al r0 r8 minus 778 Offset",
                            "al_r0_r8_minus_778_Offset"},
                           {{al, r0, r0, minus, 1804, Offset},
                            false,
                            al,
                            "al r0 r0 minus 1804 Offset",
                            "al_r0_r0_minus_1804_Offset"},
                           {{al, r0, r4, minus, 4076, Offset},
                            false,
                            al,
                            "al r0 r4 minus 4076 Offset",
                            "al_r0_r4_minus_4076_Offset"},
                           {{al, r0, r14, minus, 2906, Offset},
                            false,
                            al,
                            "al r0 r14 minus 2906 Offset",
                            "al_r0_r14_minus_2906_Offset"},
                           {{al, r0, r14, minus, 1097, Offset},
                            false,
                            al,
                            "al r0 r14 minus 1097 Offset",
                            "al_r0_r14_minus_1097_Offset"},
                           {{al, r0, r12, plus, 210, Offset},
                            false,
                            al,
                            "al r0 r12 plus 210 Offset",
                            "al_r0_r12_plus_210_Offset"},
                           {{al, r0, r3, minus, 3918, Offset},
                            false,
                            al,
                            "al r0 r3 minus 3918 Offset",
                            "al_r0_r3_minus_3918_Offset"},
                           {{al, r0, r8, minus, 3566, Offset},
                            false,
                            al,
                            "al r0 r8 minus 3566 Offset",
                            "al_r0_r8_minus_3566_Offset"},
                           {{al, r0, r0, plus, 2119, Offset},
                            false,
                            al,
                            "al r0 r0 plus 2119 Offset",
                            "al_r0_r0_plus_2119_Offset"},
                           {{al, r0, r5, plus, 806, Offset},
                            false,
                            al,
                            "al r0 r5 plus 806 Offset",
                            "al_r0_r5_plus_806_Offset"},
                           {{al, r0, r12, plus, 1922, Offset},
                            false,
                            al,
                            "al r0 r12 plus 1922 Offset",
                            "al_r0_r12_plus_1922_Offset"},
                           {{al, r0, r1, plus, 132, Offset},
                            false,
                            al,
                            "al r0 r1 plus 132 Offset",
                            "al_r0_r1_plus_132_Offset"},
                           {{al, r0, r3, minus, 2183, Offset},
                            false,
                            al,
                            "al r0 r3 minus 2183 Offset",
                            "al_r0_r3_minus_2183_Offset"},
                           {{al, r0, r2, minus, 2721, Offset},
                            false,
                            al,
                            "al r0 r2 minus 2721 Offset",
                            "al_r0_r2_minus_2721_Offset"},
                           {{al, r0, r6, plus, 2224, Offset},
                            false,
                            al,
                            "al r0 r6 plus 2224 Offset",
                            "al_r0_r6_plus_2224_Offset"},
                           {{al, r0, r9, plus, 4037, Offset},
                            false,
                            al,
                            "al r0 r9 plus 4037 Offset",
                            "al_r0_r9_plus_4037_Offset"},
                           {{al, r0, r7, minus, 3078, Offset},
                            false,
                            al,
                            "al r0 r7 minus 3078 Offset",
                            "al_r0_r7_minus_3078_Offset"},
                           {{al, r0, r5, plus, 3069, Offset},
                            false,
                            al,
                            "al r0 r5 plus 3069 Offset",
                            "al_r0_r5_plus_3069_Offset"},
                           {{al, r0, r1, plus, 791, Offset},
                            false,
                            al,
                            "al r0 r1 plus 791 Offset",
                            "al_r0_r1_plus_791_Offset"},
                           {{al, r0, r8, plus, 3028, Offset},
                            false,
                            al,
                            "al r0 r8 plus 3028 Offset",
                            "al_r0_r8_plus_3028_Offset"},
                           {{al, r0, r12, minus, 1175, Offset},
                            false,
                            al,
                            "al r0 r12 minus 1175 Offset",
                            "al_r0_r12_minus_1175_Offset"},
                           {{al, r0, r6, minus, 3417, Offset},
                            false,
                            al,
                            "al r0 r6 minus 3417 Offset",
                            "al_r0_r6_minus_3417_Offset"},
                           {{al, r0, r2, minus, 3194, PreIndex},
                            false,
                            al,
                            "al r0 r2 minus 3194 PreIndex",
                            "al_r0_r2_minus_3194_PreIndex"},
                           {{al, r7, r12, plus, 1804, PostIndex},
                            false,
                            al,
                            "al r7 r12 plus 1804 PostIndex",
                            "al_r7_r12_plus_1804_PostIndex"},
                           {{al, r5, r6, plus, 1437, PreIndex},
                            false,
                            al,
                            "al r5 r6 plus 1437 PreIndex",
                            "al_r5_r6_plus_1437_PreIndex"},
                           {{al, r0, r8, minus, 4, PostIndex},
                            false,
                            al,
                            "al r0 r8 minus 4 PostIndex",
                            "al_r0_r8_minus_4_PostIndex"},
                           {{al, r14, r2, plus, 1635, PostIndex},
                            false,
                            al,
                            "al r14 r2 plus 1635 PostIndex",
                            "al_r14_r2_plus_1635_PostIndex"},
                           {{al, r5, r0, plus, 1066, PreIndex},
                            false,
                            al,
                            "al r5 r0 plus 1066 PreIndex",
                            "al_r5_r0_plus_1066_PreIndex"},
                           {{al, r11, r6, minus, 3069, PreIndex},
                            false,
                            al,
                            "al r11 r6 minus 3069 PreIndex",
                            "al_r11_r6_minus_3069_PreIndex"},
                           {{al, r12, r3, plus, 595, PreIndex},
                            false,
                            al,
                            "al r12 r3 plus 595 PreIndex",
                            "al_r12_r3_plus_595_PreIndex"},
                           {{al, r7, r2, minus, 4093, PreIndex},
                            false,
                            al,
                            "al r7 r2 minus 4093 PreIndex",
                            "al_r7_r2_minus_4093_PreIndex"},
                           {{al, r8, r7, plus, 1872, PreIndex},
                            false,
                            al,
                            "al r8 r7 plus 1872 PreIndex",
                            "al_r8_r7_plus_1872_PreIndex"},
                           {{al, r0, r4, plus, 2792, PreIndex},
                            false,
                            al,
                            "al r0 r4 plus 2792 PreIndex",
                            "al_r0_r4_plus_2792_PreIndex"},
                           {{al, r11, r6, minus, 2948, PreIndex},
                            false,
                            al,
                            "al r11 r6 minus 2948 PreIndex",
                            "al_r11_r6_minus_2948_PreIndex"},
                           {{al, r13, r10, plus, 1459, PostIndex},
                            false,
                            al,
                            "al r13 r10 plus 1459 PostIndex",
                            "al_r13_r10_plus_1459_PostIndex"},
                           {{al, r11, r12, plus, 2490, PostIndex},
                            false,
                            al,
                            "al r11 r12 plus 2490 PostIndex",
                            "al_r11_r12_plus_2490_PostIndex"},
                           {{al, r7, r9, plus, 2026, PostIndex},
                            false,
                            al,
                            "al r7 r9 plus 2026 PostIndex",
                            "al_r7_r9_plus_2026_PostIndex"},
                           {{al, r0, r13, minus, 3397, PreIndex},
                            false,
                            al,
                            "al r0 r13 minus 3397 PreIndex",
                            "al_r0_r13_minus_3397_PreIndex"},
                           {{al, r2, r3, plus, 2800, PreIndex},
                            false,
                            al,
                            "al r2 r3 plus 2800 PreIndex",
                            "al_r2_r3_plus_2800_PreIndex"},
                           {{al, r5, r11, minus, 2183, PreIndex},
                            false,
                            al,
                            "al r5 r11 minus 2183 PreIndex",
                            "al_r5_r11_minus_2183_PreIndex"},
                           {{al, r5, r7, plus, 2217, PreIndex},
                            false,
                            al,
                            "al r5 r7 plus 2217 PreIndex",
                            "al_r5_r7_plus_2217_PreIndex"},
                           {{al, r11, r0, plus, 1455, PreIndex},
                            false,
                            al,
                            "al r11 r0 plus 1455 PreIndex",
                            "al_r11_r0_plus_1455_PreIndex"},
                           {{al, r0, r2, plus, 1159, PreIndex},
                            false,
                            al,
                            "al r0 r2 plus 1159 PreIndex",
                            "al_r0_r2_plus_1159_PreIndex"},
                           {{al, r2, r0, minus, 1526, PostIndex},
                            false,
                            al,
                            "al r2 r0 minus 1526 PostIndex",
                            "al_r2_r0_minus_1526_PostIndex"},
                           {{al, r10, r8, plus, 3139, PreIndex},
                            false,
                            al,
                            "al r10 r8 plus 3139 PreIndex",
                            "al_r10_r8_plus_3139_PreIndex"},
                           {{al, r11, r12, minus, 3963, PreIndex},
                            false,
                            al,
                            "al r11 r12 minus 3963 PreIndex",
                            "al_r11_r12_minus_3963_PreIndex"},
                           {{al, r5, r7, plus, 2628, PreIndex},
                            false,
                            al,
                            "al r5 r7 plus 2628 PreIndex",
                            "al_r5_r7_plus_2628_PreIndex"},
                           {{al, r7, r1, plus, 1665, PreIndex},
                            false,
                            al,
                            "al r7 r1 plus 1665 PreIndex",
                            "al_r7_r1_plus_1665_PreIndex"},
                           {{al, r0, r9, minus, 53, PreIndex},
                            false,
                            al,
                            "al r0 r9 minus 53 PreIndex",
                            "al_r0_r9_minus_53_PreIndex"},
                           {{al, r6, r11, minus, 4095, PostIndex},
                            false,
                            al,
                            "al r6 r11 minus 4095 PostIndex",
                            "al_r6_r11_minus_4095_PostIndex"},
                           {{al, r0, r2, plus, 459, PostIndex},
                            false,
                            al,
                            "al r0 r2 plus 459 PostIndex",
                            "al_r0_r2_plus_459_PostIndex"},
                           {{al, r9, r7, plus, 2994, PreIndex},
                            false,
                            al,
                            "al r9 r7 plus 2994 PreIndex",
                            "al_r9_r7_plus_2994_PreIndex"},
                           {{al, r11, r3, minus, 3585, PreIndex},
                            false,
                            al,
                            "al r11 r3 minus 3585 PreIndex",
                            "al_r11_r3_minus_3585_PreIndex"},
                           {{al, r2, r12, plus, 3811, PreIndex},
                            false,
                            al,
                            "al r2 r12 plus 3811 PreIndex",
                            "al_r2_r12_plus_3811_PreIndex"},
                           {{al, r3, r13, plus, 342, PostIndex},
                            false,
                            al,
                            "al r3 r13 plus 342 PostIndex",
                            "al_r3_r13_plus_342_PostIndex"},
                           {{al, r1, r4, minus, 3529, PreIndex},
                            false,
                            al,
                            "al r1 r4 minus 3529 PreIndex",
                            "al_r1_r4_minus_3529_PreIndex"},
                           {{al, r13, r3, plus, 322, PreIndex},
                            false,
                            al,
                            "al r13 r3 plus 322 PreIndex",
                            "al_r13_r3_plus_322_PreIndex"},
                           {{al, r13, r9, plus, 2628, PreIndex},
                            false,
                            al,
                            "al r13 r9 plus 2628 PreIndex",
                            "al_r13_r9_plus_2628_PreIndex"},
                           {{al, r9, r13, plus, 3105, PostIndex},
                            false,
                            al,
                            "al r9 r13 plus 3105 PostIndex",
                            "al_r9_r13_plus_3105_PostIndex"},
                           {{al, r1, r14, minus, 2311, PostIndex},
                            false,
                            al,
                            "al r1 r14 minus 2311 PostIndex",
                            "al_r1_r14_minus_2311_PostIndex"},
                           {{al, r0, r13, minus, 1050, PreIndex},
                            false,
                            al,
                            "al r0 r13 minus 1050 PreIndex",
                            "al_r0_r13_minus_1050_PreIndex"},
                           {{al, r14, r3, minus, 1892, PostIndex},
                            false,
                            al,
                            "al r14 r3 minus 1892 PostIndex",
                            "al_r14_r3_minus_1892_PostIndex"},
                           {{al, r2, r4, minus, 915, PostIndex},
                            false,
                            al,
                            "al r2 r4 minus 915 PostIndex",
                            "al_r2_r4_minus_915_PostIndex"},
                           {{al, r2, r3, minus, 3918, PostIndex},
                            false,
                            al,
                            "al r2 r3 minus 3918 PostIndex",
                            "al_r2_r3_minus_3918_PostIndex"},
                           {{al, r0, r13, minus, 2901, PreIndex},
                            false,
                            al,
                            "al r0 r13 minus 2901 PreIndex",
                            "al_r0_r13_minus_2901_PreIndex"},
                           {{al, r14, r8, minus, 960, PreIndex},
                            false,
                            al,
                            "al r14 r8 minus 960 PreIndex",
                            "al_r14_r8_minus_960_PreIndex"},
                           {{al, r10, r2, minus, 3425, PostIndex},
                            false,
                            al,
                            "al r10 r2 minus 3425 PostIndex",
                            "al_r10_r2_minus_3425_PostIndex"},
                           {{al, r2, r0, minus, 210, PostIndex},
                            false,
                            al,
                            "al r2 r0 minus 210 PostIndex",
                            "al_r2_r0_minus_210_PostIndex"},
                           {{al, r4, r5, minus, 2052, PreIndex},
                            false,
                            al,
                            "al r4 r5 minus 2052 PreIndex",
                            "al_r4_r5_minus_2052_PreIndex"},
                           {{al, r5, r0, minus, 1922, PostIndex},
                            false,
                            al,
                            "al r5 r0 minus 1922 PostIndex",
                            "al_r5_r0_minus_1922_PostIndex"},
                           {{al, r7, r8, minus, 3256, PostIndex},
                            false,
                            al,
                            "al r7 r8 minus 3256 PostIndex",
                            "al_r7_r8_minus_3256_PostIndex"},
                           {{al, r5, r13, plus, 1695, PostIndex},
                            false,
                            al,
                            "al r5 r13 plus 1695 PostIndex",
                            "al_r5_r13_plus_1695_PostIndex"},
                           {{al, r3, r14, plus, 844, PreIndex},
                            false,
                            al,
                            "al r3 r14 plus 844 PreIndex",
                            "al_r3_r14_plus_844_PreIndex"},
                           {{al, r3, r7, minus, 3914, PreIndex},
                            false,
                            al,
                            "al r3 r7 minus 3914 PreIndex",
                            "al_r3_r7_minus_3914_PreIndex"},
                           {{al, r4, r6, minus, 3256, PostIndex},
                            false,
                            al,
                            "al r4 r6 minus 3256 PostIndex",
                            "al_r4_r6_minus_3256_PostIndex"},
                           {{al, r11, r12, minus, 2338, PreIndex},
                            false,
                            al,
                            "al r11 r12 minus 2338 PreIndex",
                            "al_r11_r12_minus_2338_PreIndex"},
                           {{al, r2, r10, minus, 3117, PostIndex},
                            false,
                            al,
                            "al r2 r10 minus 3117 PostIndex",
                            "al_r2_r10_minus_3117_PostIndex"},
                           {{al, r0, r12, minus, 2046, PreIndex},
                            false,
                            al,
                            "al r0 r12 minus 2046 PreIndex",
                            "al_r0_r12_minus_2046_PreIndex"},
                           {{al, r14, r8, plus, 3660, PostIndex},
                            false,
                            al,
                            "al r14 r8 plus 3660 PostIndex",
                            "al_r14_r8_plus_3660_PostIndex"},
                           {{al, r6, r10, minus, 3739, PostIndex},
                            false,
                            al,
                            "al r6 r10 minus 3739 PostIndex",
                            "al_r6_r10_minus_3739_PostIndex"},
                           {{al, r7, r1, minus, 3633, PreIndex},
                            false,
                            al,
                            "al r7 r1 minus 3633 PreIndex",
                            "al_r7_r1_minus_3633_PreIndex"},
                           {{al, r10, r6, plus, 2358, PreIndex},
                            false,
                            al,
                            "al r10 r6 plus 2358 PreIndex",
                            "al_r10_r6_plus_2358_PreIndex"},
                           {{al, r4, r6, plus, 3139, PreIndex},
                            false,
                            al,
                            "al r4 r6 plus 3139 PreIndex",
                            "al_r4_r6_plus_3139_PreIndex"},
                           {{al, r14, r2, plus, 398, PreIndex},
                            false,
                            al,
                            "al r14 r2 plus 398 PreIndex",
                            "al_r14_r2_plus_398_PreIndex"},
                           {{al, r1, r9, plus, 1438, PostIndex},
                            false,
                            al,
                            "al r1 r9 plus 1438 PostIndex",
                            "al_r1_r9_plus_1438_PostIndex"},
                           {{al, r13, r7, plus, 1867, PostIndex},
                            false,
                            al,
                            "al r13 r7 plus 1867 PostIndex",
                            "al_r13_r7_plus_1867_PostIndex"},
                           {{al, r6, r7, plus, 831, PostIndex},
                            false,
                            al,
                            "al r6 r7 plus 831 PostIndex",
                            "al_r6_r7_plus_831_PostIndex"},
                           {{al, r10, r6, plus, 4, PreIndex},
                            false,
                            al,
                            "al r10 r6 plus 4 PreIndex",
                            "al_r10_r6_plus_4_PreIndex"},
                           {{al, r9, r0, plus, 1835, PreIndex},
                            false,
                            al,
                            "al r9 r0 plus 1835 PreIndex",
                            "al_r9_r0_plus_1835_PreIndex"},
                           {{al, r0, r2, minus, 1438, PreIndex},
                            false,
                            al,
                            "al r0 r2 minus 1438 PreIndex",
                            "al_r0_r2_minus_1438_PreIndex"},
                           {{al, r6, r2, plus, 3522, PreIndex},
                            false,
                            al,
                            "al r6 r2 plus 3522 PreIndex",
                            "al_r6_r2_plus_3522_PreIndex"},
                           {{al, r1, r4, minus, 3069, PreIndex},
                            false,
                            al,
                            "al r1 r4 minus 3069 PreIndex",
                            "al_r1_r4_minus_3069_PreIndex"},
                           {{al, r0, r5, plus, 1348, PreIndex},
                            false,
                            al,
                            "al r0 r5 plus 1348 PreIndex",
                            "al_r0_r5_plus_1348_PreIndex"},
                           {{al, r11, r5, plus, 2224, PreIndex},
                            false,
                            al,
                            "al r11 r5 plus 2224 PreIndex",
                            "al_r11_r5_plus_2224_PreIndex"},
                           {{al, r4, r14, minus, 1537, PostIndex},
                            false,
                            al,
                            "al r4 r14 minus 1537 PostIndex",
                            "al_r4_r14_minus_1537_PostIndex"},
                           {{al, r9, r7, plus, 213, PostIndex},
                            false,
                            al,
                            "al r9 r7 plus 213 PostIndex",
                            "al_r9_r7_plus_213_PostIndex"},
                           {{al, r2, r3, minus, 2402, PreIndex},
                            false,
                            al,
                            "al r2 r3 minus 2402 PreIndex",
                            "al_r2_r3_minus_2402_PreIndex"},
                           {{al, r4, r1, plus, 3771, PreIndex},
                            false,
                            al,
                            "al r4 r1 plus 3771 PreIndex",
                            "al_r4_r1_plus_3771_PreIndex"},
                           {{al, r0, r4, minus, 2139, PostIndex},
                            false,
                            al,
                            "al r0 r4 minus 2139 PostIndex",
                            "al_r0_r4_minus_2139_PostIndex"},
                           {{al, r1, r4, minus, 2016, PreIndex},
                            false,
                            al,
                            "al r1 r4 minus 2016 PreIndex",
                            "al_r1_r4_minus_2016_PreIndex"},
                           {{al, r4, r12, minus, 1241, PreIndex},
                            false,
                            al,
                            "al r4 r12 minus 1241 PreIndex",
                            "al_r4_r12_minus_1241_PreIndex"},
                           {{al, r10, r5, minus, 3391, PreIndex},
                            false,
                            al,
                            "al r10 r5 minus 3391 PreIndex",
                            "al_r10_r5_minus_3391_PreIndex"},
                           {{al, r0, r4, plus, 2689, PreIndex},
                            false,
                            al,
                            "al r0 r4 plus 2689 PreIndex",
                            "al_r0_r4_plus_2689_PreIndex"},
                           {{al, r14, r12, plus, 2588, PostIndex},
                            false,
                            al,
                            "al r14 r12 plus 2588 PostIndex",
                            "al_r14_r12_plus_2588_PostIndex"},
                           {{al, r11, r14, minus, 1234, PostIndex},
                            false,
                            al,
                            "al r11 r14 minus 1234 PostIndex",
                            "al_r11_r14_minus_1234_PostIndex"},
                           {{al, r2, r0, minus, 1699, PostIndex},
                            false,
                            al,
                            "al r2 r0 minus 1699 PostIndex",
                            "al_r2_r0_minus_1699_PostIndex"},
                           {{al, r9, r10, minus, 3399, PreIndex},
                            false,
                            al,
                            "al r9 r10 minus 3399 PreIndex",
                            "al_r9_r10_minus_3399_PreIndex"},
                           {{al, r10, r8, minus, 132, PreIndex},
                            false,
                            al,
                            "al r10 r8 minus 132 PreIndex",
                            "al_r10_r8_minus_132_PreIndex"},
                           {{al, r13, r6, plus, 496, PreIndex},
                            false,
                            al,
                            "al r13 r6 plus 496 PreIndex",
                            "al_r13_r6_plus_496_PreIndex"},
                           {{al, r12, r9, minus, 188, PreIndex},
                            false,
                            al,
                            "al r12 r9 minus 188 PreIndex",
                            "al_r12_r9_minus_188_PreIndex"},
                           {{al, r9, r2, minus, 612, PostIndex},
                            false,
                            al,
                            "al r9 r2 minus 612 PostIndex",
                            "al_r9_r2_minus_612_PostIndex"},
                           {{al, r8, r13, minus, 2929, PreIndex},
                            false,
                            al,
                            "al r8 r13 minus 2929 PreIndex",
                            "al_r8_r13_minus_2929_PreIndex"},
                           {{al, r6, r12, plus, 1372, PreIndex},
                            false,
                            al,
                            "al r6 r12 plus 1372 PreIndex",
                            "al_r6_r12_plus_1372_PreIndex"},
                           {{al, r3, r10, plus, 1967, PreIndex},
                            false,
                            al,
                            "al r3 r10 plus 1967 PreIndex",
                            "al_r3_r10_plus_1967_PreIndex"},
                           {{al, r3, r0, plus, 3728, PostIndex},
                            false,
                            al,
                            "al r3 r0 plus 3728 PostIndex",
                            "al_r3_r0_plus_3728_PostIndex"},
                           {{al, r12, r13, minus, 2726, PreIndex},
                            false,
                            al,
                            "al r12 r13 minus 2726 PreIndex",
                            "al_r12_r13_minus_2726_PreIndex"},
                           {{al, r2, r12, plus, 542, PreIndex},
                            false,
                            al,
                            "al r2 r12 plus 542 PreIndex",
                            "al_r2_r12_plus_542_PreIndex"},
                           {{al, r4, r12, minus, 3989, PreIndex},
                            false,
                            al,
                            "al r4 r12 minus 3989 PreIndex",
                            "al_r4_r12_minus_3989_PreIndex"},
                           {{al, r8, r14, plus, 2311, PostIndex},
                            false,
                            al,
                            "al r8 r14 plus 2311 PostIndex",
                            "al_r8_r14_plus_2311_PostIndex"},
                           {{al, r8, r11, minus, 1479, PostIndex},
                            false,
                            al,
                            "al r8 r11 minus 1479 PostIndex",
                            "al_r8_r11_minus_1479_PostIndex"},
                           {{al, r4, r3, plus, 988, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus 988 PostIndex",
                            "al_r4_r3_plus_988_PostIndex"},
                           {{al, r9, r6, minus, 1017, PostIndex},
                            false,
                            al,
                            "al r9 r6 minus 1017 PostIndex",
                            "al_r9_r6_minus_1017_PostIndex"},
                           {{al, r13, r10, plus, 2038, PreIndex},
                            false,
                            al,
                            "al r13 r10 plus 2038 PreIndex",
                            "al_r13_r10_plus_2038_PreIndex"},
                           {{al, r10, r0, plus, 999, PreIndex},
                            false,
                            al,
                            "al r10 r0 plus 999 PreIndex",
                            "al_r10_r0_plus_999_PreIndex"},
                           {{al, r2, r1, minus, 1870, PostIndex},
                            false,
                            al,
                            "al r2 r1 minus 1870 PostIndex",
                            "al_r2_r1_minus_1870_PostIndex"},
                           {{al, r1, r3, plus, 188, PreIndex},
                            false,
                            al,
                            "al r1 r3 plus 188 PreIndex",
                            "al_r1_r3_plus_188_PreIndex"},
                           {{al, r3, r10, minus, 459, PreIndex},
                            false,
                            al,
                            "al r3 r10 minus 459 PreIndex",
                            "al_r3_r10_minus_459_PreIndex"},
                           {{al, r13, r6, minus, 2245, PostIndex},
                            false,
                            al,
                            "al r13 r6 minus 2245 PostIndex",
                            "al_r13_r6_minus_2245_PostIndex"},
                           {{al, r2, r11, minus, 3397, PostIndex},
                            false,
                            al,
                            "al r2 r11 minus 3397 PostIndex",
                            "al_r2_r11_minus_3397_PostIndex"},
                           {{al, r5, r6, plus, 2025, PreIndex},
                            false,
                            al,
                            "al r5 r6 plus 2025 PreIndex",
                            "al_r5_r6_plus_2025_PreIndex"},
                           {{al, r13, r2, minus, 479, PreIndex},
                            false,
                            al,
                            "al r13 r2 minus 479 PreIndex",
                            "al_r13_r2_minus_479_PreIndex"},
                           {{al, r9, r7, minus, 3069, PreIndex},
                            false,
                            al,
                            "al r9 r7 minus 3069 PreIndex",
                            "al_r9_r7_minus_3069_PreIndex"},
                           {{al, r2, r6, plus, 462, PostIndex},
                            false,
                            al,
                            "al r2 r6 plus 462 PostIndex",
                            "al_r2_r6_plus_462_PostIndex"},
                           {{al, r4, r7, minus, 2026, PostIndex},
                            false,
                            al,
                            "al r4 r7 minus 2026 PostIndex",
                            "al_r4_r7_minus_2026_PostIndex"},
                           {{al, r1, r5, minus, 969, PostIndex},
                            false,
                            al,
                            "al r1 r5 minus 969 PostIndex",
                            "al_r1_r5_minus_969_PostIndex"},
                           {{al, r2, r4, minus, 3752, PostIndex},
                            false,
                            al,
                            "al r2 r4 minus 3752 PostIndex",
                            "al_r2_r4_minus_3752_PostIndex"},
                           {{al, r6, r2, plus, 3583, PreIndex},
                            false,
                            al,
                            "al r6 r2 plus 3583 PreIndex",
                            "al_r6_r2_plus_3583_PreIndex"},
                           {{al, r12, r10, plus, 2906, PreIndex},
                            false,
                            al,
                            "al r12 r10 plus 2906 PreIndex",
                            "al_r12_r10_plus_2906_PreIndex"},
                           {{al, r6, r1, minus, 3752, PostIndex},
                            false,
                            al,
                            "al r6 r1 minus 3752 PostIndex",
                            "al_r6_r1_minus_3752_PostIndex"},
                           {{al, r4, r14, minus, 2490, PreIndex},
                            false,
                            al,
                            "al r4 r14 minus 2490 PreIndex",
                            "al_r4_r14_minus_2490_PreIndex"},
                           {{al, r13, r3, minus, 4093, PostIndex},
                            false,
                            al,
                            "al r13 r3 minus 4093 PostIndex",
                            "al_r13_r3_minus_4093_PostIndex"},
                           {{al, r14, r4, plus, 932, PostIndex},
                            false,
                            al,
                            "al r14 r4 plus 932 PostIndex",
                            "al_r14_r4_plus_932_PostIndex"},
                           {{al, r5, r4, plus, 774, PreIndex},
                            false,
                            al,
                            "al r5 r4 plus 774 PreIndex",
                            "al_r5_r4_plus_774_PreIndex"},
                           {{al, r3, r12, plus, 2175, PostIndex},
                            false,
                            al,
                            "al r3 r12 plus 2175 PostIndex",
                            "al_r3_r12_plus_2175_PostIndex"},
                           {{al, r2, r5, minus, 1567, PostIndex},
                            false,
                            al,
                            "al r2 r5 minus 1567 PostIndex",
                            "al_r2_r5_minus_1567_PostIndex"},
                           {{al, r13, r9, plus, 3963, PreIndex},
                            false,
                            al,
                            "al r13 r9 plus 3963 PreIndex",
                            "al_r13_r9_plus_3963_PreIndex"},
                           {{al, r14, r9, minus, 2381, PostIndex},
                            false,
                            al,
                            "al r14 r9 minus 2381 PostIndex",
                            "al_r14_r9_minus_2381_PostIndex"},
                           {{al, r10, r14, minus, 3663, PreIndex},
                            false,
                            al,
                            "al r10 r14 minus 3663 PreIndex",
                            "al_r10_r14_minus_3663_PreIndex"},
                           {{al, r3, r7, plus, 2453, PreIndex},
                            false,
                            al,
                            "al r3 r7 plus 2453 PreIndex",
                            "al_r3_r7_plus_2453_PreIndex"},
                           {{al, r0, r11, minus, 1922, PreIndex},
                            false,
                            al,
                            "al r0 r11 minus 1922 PreIndex",
                            "al_r0_r11_minus_1922_PreIndex"},
                           {{al, r7, r3, plus, 2651, PreIndex},
                            false,
                            al,
                            "al r7 r3 plus 2651 PreIndex",
                            "al_r7_r3_plus_2651_PreIndex"},
                           {{al, r12, r10, minus, 1740, PreIndex},
                            false,
                            al,
                            "al r12 r10 minus 1740 PreIndex",
                            "al_r12_r10_minus_1740_PreIndex"},
                           {{al, r8, r14, plus, 1399, PreIndex},
                            false,
                            al,
                            "al r8 r14 plus 1399 PreIndex",
                            "al_r8_r14_plus_1399_PreIndex"},
                           {{al, r8, r2, minus, 3541, PreIndex},
                            false,
                            al,
                            "al r8 r2 minus 3541 PreIndex",
                            "al_r8_r2_minus_3541_PreIndex"},
                           {{al, r9, r6, plus, 3138, PostIndex},
                            false,
                            al,
                            "al r9 r6 plus 3138 PostIndex",
                            "al_r9_r6_plus_3138_PostIndex"},
                           {{al, r10, r0, minus, 1804, PreIndex},
                            false,
                            al,
                            "al r10 r0 minus 1804 PreIndex",
                            "al_r10_r0_minus_1804_PreIndex"},
                           {{al, r5, r4, plus, 1652, PostIndex},
                            false,
                            al,
                            "al r5 r4 plus 1652 PostIndex",
                            "al_r5_r4_plus_1652_PostIndex"},
                           {{al, r2, r10, plus, 1860, PostIndex},
                            false,
                            al,
                            "al r2 r10 plus 1860 PostIndex",
                            "al_r2_r10_plus_1860_PostIndex"},
                           {{al, r3, r0, minus, 828, PreIndex},
                            false,
                            al,
                            "al r3 r0 minus 828 PreIndex",
                            "al_r3_r0_minus_828_PreIndex"},
                           {{al, r11, r0, plus, 429, PreIndex},
                            false,
                            al,
                            "al r11 r0 plus 429 PreIndex",
                            "al_r11_r0_plus_429_PreIndex"},
                           {{al, r7, r12, plus, 3028, PostIndex},
                            false,
                            al,
                            "al r7 r12 plus 3028 PostIndex",
                            "al_r7_r12_plus_3028_PostIndex"},
                           {{al, r11, r12, minus, 2775, PostIndex},
                            false,
                            al,
                            "al r11 r12 minus 2775 PostIndex",
                            "al_r11_r12_minus_2775_PostIndex"},
                           {{al, r4, r10, minus, 2689, PreIndex},
                            false,
                            al,
                            "al r4 r10 minus 2689 PreIndex",
                            "al_r4_r10_minus_2689_PreIndex"},
                           {{al, r8, r12, plus, 462, PostIndex},
                            false,
                            al,
                            "al r8 r12 plus 462 PostIndex",
                            "al_r8_r12_plus_462_PostIndex"},
                           {{al, r13, r14, plus, 2792, PreIndex},
                            false,
                            al,
                            "al r13 r14 plus 2792 PreIndex",
                            "al_r13_r14_plus_2792_PreIndex"},
                           {{al, r7, r9, plus, 2338, PostIndex},
                            false,
                            al,
                            "al r7 r9 plus 2338 PostIndex",
                            "al_r7_r9_plus_2338_PostIndex"},
                           {{al, r13, r5, minus, 766, PostIndex},
                            false,
                            al,
                            "al r13 r5 minus 766 PostIndex",
                            "al_r13_r5_minus_766_PostIndex"},
                           {{al, r5, r1, minus, 2794, PreIndex},
                            false,
                            al,
                            "al r5 r1 minus 2794 PreIndex",
                            "al_r5_r1_minus_2794_PreIndex"},
                           {{al, r9, r4, plus, 2800, PreIndex},
                            false,
                            al,
                            "al r9 r4 plus 2800 PreIndex",
                            "al_r9_r4_plus_2800_PreIndex"},
                           {{al, r0, r8, minus, 523, PostIndex},
                            false,
                            al,
                            "al r0 r8 minus 523 PostIndex",
                            "al_r0_r8_minus_523_PostIndex"},
                           {{al, r9, r8, minus, 2507, PostIndex},
                            false,
                            al,
                            "al r9 r8 minus 2507 PostIndex",
                            "al_r9_r8_minus_2507_PostIndex"},
                           {{al, r0, r1, minus, 3696, PostIndex},
                            false,
                            al,
                            "al r0 r1 minus 3696 PostIndex",
                            "al_r0_r1_minus_3696_PostIndex"},
                           {{al, r3, r2, plus, 2617, PreIndex},
                            false,
                            al,
                            "al r3 r2 plus 2617 PreIndex",
                            "al_r3_r2_plus_2617_PreIndex"},
                           {{al, r5, r4, plus, 4095, PostIndex},
                            false,
                            al,
                            "al r5 r4 plus 4095 PostIndex",
                            "al_r5_r4_plus_4095_PostIndex"},
                           {{al, r7, r8, minus, 955, PreIndex},
                            false,
                            al,
                            "al r7 r8 minus 955 PreIndex",
                            "al_r7_r8_minus_955_PreIndex"},
                           {{al, r4, r9, minus, 3079, PreIndex},
                            false,
                            al,
                            "al r4 r9 minus 3079 PreIndex",
                            "al_r4_r9_minus_3079_PreIndex"},
                           {{al, r7, r1, minus, 1017, PostIndex},
                            false,
                            al,
                            "al r7 r1 minus 1017 PostIndex",
                            "al_r7_r1_minus_1017_PostIndex"},
                           {{al, r3, r1, minus, 1437, PostIndex},
                            false,
                            al,
                            "al r3 r1 minus 1437 PostIndex",
                            "al_r3_r1_minus_1437_PostIndex"},
                           {{al, r10, r12, plus, 3529, PostIndex},
                            false,
                            al,
                            "al r10 r12 plus 3529 PostIndex",
                            "al_r10_r12_plus_3529_PostIndex"},
                           {{al, r4, r6, minus, 565, PreIndex},
                            false,
                            al,
                            "al r4 r6 minus 565 PreIndex",
                            "al_r4_r6_minus_565_PreIndex"},
                           {{al, r5, r6, plus, 264, PostIndex},
                            false,
                            al,
                            "al r5 r6 plus 264 PostIndex",
                            "al_r5_r6_plus_264_PostIndex"},
                           {{al, r11, r3, minus, 2810, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus 2810 PostIndex",
                            "al_r11_r3_minus_2810_PostIndex"},
                           {{al, r2, r10, minus, 669, PreIndex},
                            false,
                            al,
                            "al r2 r10 minus 669 PreIndex",
                            "al_r2_r10_minus_669_PreIndex"},
                           {{al, r2, r13, minus, 3867, PreIndex},
                            false,
                            al,
                            "al r2 r13 minus 3867 PreIndex",
                            "al_r2_r13_minus_3867_PreIndex"},
                           {{al, r8, r10, plus, 3610, PreIndex},
                            false,
                            al,
                            "al r8 r10 plus 3610 PreIndex",
                            "al_r8_r10_plus_3610_PreIndex"},
                           {{al, r3, r2, minus, 969, PreIndex},
                            false,
                            al,
                            "al r3 r2 minus 969 PreIndex",
                            "al_r3_r2_minus_969_PreIndex"},
                           {{al, r12, r4, plus, 1585, PreIndex},
                            false,
                            al,
                            "al r12 r4 plus 1585 PreIndex",
                            "al_r12_r4_plus_1585_PreIndex"},
                           {{al, r9, r14, plus, 3256, PreIndex},
                            false,
                            al,
                            "al r9 r14 plus 3256 PreIndex",
                            "al_r9_r14_plus_3256_PreIndex"},
                           {{al, r12, r2, plus, 844, PreIndex},
                            false,
                            al,
                            "al r12 r2 plus 844 PreIndex",
                            "al_r12_r2_plus_844_PreIndex"},
                           {{al, r6, r14, plus, 3142, PreIndex},
                            false,
                            al,
                            "al r6 r14 plus 3142 PreIndex",
                            "al_r6_r14_plus_3142_PreIndex"},
                           {{al, r4, r2, plus, 1999, PreIndex},
                            false,
                            al,
                            "al r4 r2 plus 1999 PreIndex",
                            "al_r4_r2_plus_1999_PreIndex"},
                           {{al, r5, r3, minus, 3170, PreIndex},
                            false,
                            al,
                            "al r5 r3 minus 3170 PreIndex",
                            "al_r5_r3_minus_3170_PreIndex"},
                           {{al, r7, r0, minus, 2703, PostIndex},
                            false,
                            al,
                            "al r7 r0 minus 2703 PostIndex",
                            "al_r7_r0_minus_2703_PostIndex"},
                           {{al, r10, r3, plus, 1445, PreIndex},
                            false,
                            al,
                            "al r10 r3 plus 1445 PreIndex",
                            "al_r10_r3_plus_1445_PreIndex"},
                           {{al, r12, r13, minus, 565, PreIndex},
                            false,
                            al,
                            "al r12 r13 minus 565 PreIndex",
                            "al_r12_r13_minus_565_PreIndex"},
                           {{al, r3, r7, minus, 2665, PreIndex},
                            false,
                            al,
                            "al r3 r7 minus 2665 PreIndex",
                            "al_r3_r7_minus_2665_PreIndex"},
                           {{al, r13, r0, plus, 4, PreIndex},
                            false,
                            al,
                            "al r13 r0 plus 4 PreIndex",
                            "al_r13_r0_plus_4_PreIndex"},
                           {{al, r5, r6, plus, 2703, PostIndex},
                            false,
                            al,
                            "al r5 r6 plus 2703 PostIndex",
                            "al_r5_r6_plus_2703_PostIndex"},
                           {{al, r12, r13, minus, 2281, PreIndex},
                            false,
                            al,
                            "al r12 r13 minus 2281 PreIndex",
                            "al_r12_r13_minus_2281_PreIndex"},
                           {{al, r9, r12, minus, 3899, PostIndex},
                            false,
                            al,
                            "al r9 r12 minus 3899 PostIndex",
                            "al_r9_r12_minus_3899_PostIndex"},
                           {{al, r1, r3, plus, 871, PostIndex},
                            false,
                            al,
                            "al r1 r3 plus 871 PostIndex",
                            "al_r1_r3_plus_871_PostIndex"},
                           {{al, r7, r3, plus, 3195, PostIndex},
                            false,
                            al,
                            "al r7 r3 plus 3195 PostIndex",
                            "al_r7_r3_plus_3195_PostIndex"},
                           {{al, r5, r14, plus, 227, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus 227 PostIndex",
                            "al_r5_r14_plus_227_PostIndex"},
                           {{al, r1, r8, plus, 3566, PreIndex},
                            false,
                            al,
                            "al r1 r8 plus 3566 PreIndex",
                            "al_r1_r8_plus_3566_PreIndex"},
                           {{al, r9, r10, plus, 2948, PreIndex},
                            false,
                            al,
                            "al r9 r10 plus 2948 PreIndex",
                            "al_r9_r10_plus_2948_PreIndex"},
                           {{al, r1, r10, plus, 582, PreIndex},
                            false,
                            al,
                            "al r1 r10 plus 582 PreIndex",
                            "al_r1_r10_plus_582_PreIndex"},
                           {{al, r6, r13, plus, 3472, PreIndex},
                            false,
                            al,
                            "al r6 r13 plus 3472 PreIndex",
                            "al_r6_r13_plus_3472_PreIndex"},
                           {{al, r2, r7, minus, 1872, PostIndex},
                            false,
                            al,
                            "al r2 r7 minus 1872 PostIndex",
                            "al_r2_r7_minus_1872_PostIndex"},
                           {{al, r12, r9, plus, 3425, PostIndex},
                            false,
                            al,
                            "al r12 r9 plus 3425 PostIndex",
                            "al_r12_r9_plus_3425_PostIndex"},
                           {{al, r8, r7, minus, 3771, PreIndex},
                            false,
                            al,
                            "al r8 r7 minus 3771 PreIndex",
                            "al_r8_r7_minus_3771_PreIndex"},
                           {{al, r9, r12, plus, 3548, PostIndex},
                            false,
                            al,
                            "al r9 r12 plus 3548 PostIndex",
                            "al_r9_r12_plus_3548_PostIndex"},
                           {{al, r9, r3, minus, 270, PostIndex},
                            false,
                            al,
                            "al r9 r3 minus 270 PostIndex",
                            "al_r9_r3_minus_270_PostIndex"},
                           {{al, r6, r4, plus, 1505, PreIndex},
                            false,
                            al,
                            "al r6 r4 plus 1505 PreIndex",
                            "al_r6_r4_plus_1505_PreIndex"},
                           {{al, r11, r3, minus, 4, PreIndex},
                            false,
                            al,
                            "al r11 r3 minus 4 PreIndex",
                            "al_r11_r3_minus_4_PreIndex"},
                           {{al, r8, r12, minus, 1428, PostIndex},
                            false,
                            al,
                            "al r8 r12 minus 1428 PostIndex",
                            "al_r8_r12_minus_1428_PostIndex"},
                           {{al, r1, r4, minus, 969, PostIndex},
                            false,
                            al,
                            "al r1 r4 minus 969 PostIndex",
                            "al_r1_r4_minus_969_PostIndex"},
                           {{al, r10, r13, minus, 932, PostIndex},
                            false,
                            al,
                            "al r10 r13 minus 932 PostIndex",
                            "al_r10_r13_minus_932_PostIndex"},
                           {{al, r9, r6, plus, 2012, PostIndex},
                            false,
                            al,
                            "al r9 r6 plus 2012 PostIndex",
                            "al_r9_r6_plus_2012_PostIndex"},
                           {{al, r10, r1, minus, 2453, PreIndex},
                            false,
                            al,
                            "al r10 r1 minus 2453 PreIndex",
                            "al_r10_r1_minus_2453_PreIndex"},
                           {{al, r4, r0, plus, 1999, PostIndex},
                            false,
                            al,
                            "al r4 r0 plus 1999 PostIndex",
                            "al_r4_r0_plus_1999_PostIndex"},
                           {{al, r3, r1, plus, 3522, PreIndex},
                            false,
                            al,
                            "al r3 r1 plus 3522 PreIndex",
                            "al_r3_r1_plus_3522_PreIndex"},
                           {{al, r8, r3, minus, 2523, PreIndex},
                            false,
                            al,
                            "al r8 r3 minus 2523 PreIndex",
                            "al_r8_r3_minus_2523_PreIndex"},
                           {{al, r7, r12, plus, 2775, PostIndex},
                            false,
                            al,
                            "al r7 r12 plus 2775 PostIndex",
                            "al_r7_r12_plus_2775_PostIndex"},
                           {{al, r14, r0, minus, 2590, PreIndex},
                            false,
                            al,
                            "al r14 r0 minus 2590 PreIndex",
                            "al_r14_r0_minus_2590_PreIndex"},
                           {{al, r3, r14, minus, 3472, PreIndex},
                            false,
                            al,
                            "al r3 r14 minus 3472 PreIndex",
                            "al_r3_r14_minus_3472_PreIndex"},
                           {{al, r14, r1, plus, 2462, PostIndex},
                            false,
                            al,
                            "al r14 r1 plus 2462 PostIndex",
                            "al_r14_r1_plus_2462_PostIndex"},
                           {{al, r2, r5, plus, 1472, PreIndex},
                            false,
                            al,
                            "al r2 r5 plus 1472 PreIndex",
                            "al_r2_r5_plus_1472_PreIndex"},
                           {{al, r1, r3, minus, 1652, PreIndex},
                            false,
                            al,
                            "al r1 r3 minus 1652 PreIndex",
                            "al_r1_r3_minus_1652_PreIndex"},
                           {{al, r0, r1, plus, 1999, PostIndex},
                            false,
                            al,
                            "al r0 r1 plus 1999 PostIndex",
                            "al_r0_r1_plus_1999_PostIndex"},
                           {{al, r2, r0, minus, 3254, PreIndex},
                            false,
                            al,
                            "al r2 r0 minus 3254 PreIndex",
                            "al_r2_r0_minus_3254_PreIndex"},
                           {{al, r11, r8, plus, 3405, PreIndex},
                            false,
                            al,
                            "al r11 r8 plus 3405 PreIndex",
                            "al_r11_r8_plus_3405_PreIndex"},
                           {{al, r5, r14, plus, 2963, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus 2963 PostIndex",
                            "al_r5_r14_plus_2963_PostIndex"},
                           {{al, r12, r14, minus, 2545, PreIndex},
                            false,
                            al,
                            "al r12 r14 minus 2545 PreIndex",
                            "al_r12_r14_minus_2545_PreIndex"},
                           {{al, r8, r14, plus, 1660, PostIndex},
                            false,
                            al,
                            "al r8 r14 plus 1660 PostIndex",
                            "al_r8_r14_plus_1660_PostIndex"},
                           {{al, r13, r14, plus, 2403, PreIndex},
                            false,
                            al,
                            "al r13 r14 plus 2403 PreIndex",
                            "al_r13_r14_plus_2403_PreIndex"},
                           {{al, r3, r2, plus, 19, PreIndex},
                            false,
                            al,
                            "al r3 r2 plus 19 PreIndex",
                            "al_r3_r2_plus_19_PreIndex"},
                           {{al, r8, r11, plus, 2821, PostIndex},
                            false,
                            al,
                            "al r8 r11 plus 2821 PostIndex",
                            "al_r8_r11_plus_2821_PostIndex"},
                           {{al, r8, r3, minus, 1999, PreIndex},
                            false,
                            al,
                            "al r8 r3 minus 1999 PreIndex",
                            "al_r8_r3_minus_1999_PreIndex"},
                           {{al, r2, r5, plus, 1991, PreIndex},
                            false,
                            al,
                            "al r2 r5 plus 1991 PreIndex",
                            "al_r2_r5_plus_1991_PreIndex"},
                           {{al, r13, r14, minus, 188, PreIndex},
                            false,
                            al,
                            "al r13 r14 minus 188 PreIndex",
                            "al_r13_r14_minus_188_PreIndex"},
                           {{al, r4, r8, plus, 4095, PreIndex},
                            false,
                            al,
                            "al r4 r8 plus 4095 PreIndex",
                            "al_r4_r8_plus_4095_PreIndex"},
                           {{al, r11, r3, minus, 3057, PreIndex},
                            false,
                            al,
                            "al r11 r3 minus 3057 PreIndex",
                            "al_r11_r3_minus_3057_PreIndex"},
                           {{al, r6, r5, plus, 1699, PreIndex},
                            false,
                            al,
                            "al r6 r5 plus 1699 PreIndex",
                            "al_r6_r5_plus_1699_PreIndex"},
                           {{al, r14, r6, plus, 1537, PreIndex},
                            false,
                            al,
                            "al r14 r6 plus 1537 PreIndex",
                            "al_r14_r6_plus_1537_PreIndex"},
                           {{al, r5, r7, minus, 3625, PreIndex},
                            false,
                            al,
                            "al r5 r7 minus 3625 PreIndex",
                            "al_r5_r7_minus_3625_PreIndex"},
                           {{al, r7, r4, minus, 3142, PreIndex},
                            false,
                            al,
                            "al r7 r4 minus 3142 PreIndex",
                            "al_r7_r4_minus_3142_PreIndex"},
                           {{al, r14, r12, minus, 525, PreIndex},
                            false,
                            al,
                            "al r14 r12 minus 525 PreIndex",
                            "al_r14_r12_minus_525_PreIndex"},
                           {{al, r8, r14, plus, 53, PreIndex},
                            false,
                            al,
                            "al r8 r14 plus 53 PreIndex",
                            "al_r8_r14_plus_53_PreIndex"},
                           {{al, r13, r1, plus, 3109, PreIndex},
                            false,
                            al,
                            "al r13 r1 plus 3109 PreIndex",
                            "al_r13_r1_plus_3109_PreIndex"},
                           {{al, r4, r1, minus, 2086, PreIndex},
                            false,
                            al,
                            "al r4 r1 minus 2086 PreIndex",
                            "al_r4_r1_minus_2086_PreIndex"},
                           {{al, r3, r13, plus, 3072, PreIndex},
                            false,
                            al,
                            "al r3 r13 plus 3072 PreIndex",
                            "al_r3_r13_plus_3072_PreIndex"},
                           {{al, r6, r14, plus, 2669, PreIndex},
                            false,
                            al,
                            "al r6 r14 plus 2669 PreIndex",
                            "al_r6_r14_plus_2669_PreIndex"},
                           {{al, r6, r12, plus, 1999, PostIndex},
                            false,
                            al,
                            "al r6 r12 plus 1999 PostIndex",
                            "al_r6_r12_plus_1999_PostIndex"},
                           {{al, r2, r7, plus, 1035, PostIndex},
                            false,
                            al,
                            "al r2 r7 plus 1035 PostIndex",
                            "al_r2_r7_plus_1035_PostIndex"},
                           {{al, r10, r14, minus, 2281, PreIndex},
                            false,
                            al,
                            "al r10 r14 minus 2281 PreIndex",
                            "al_r10_r14_minus_2281_PreIndex"},
                           {{al, r11, r10, plus, 1536, PostIndex},
                            false,
                            al,
                            "al r11 r10 plus 1536 PostIndex",
                            "al_r11_r10_plus_1536_PostIndex"},
                           {{al, r1, r11, plus, 2483, PreIndex},
                            false,
                            al,
                            "al r1 r11 plus 2483 PreIndex",
                            "al_r1_r11_plus_2483_PreIndex"},
                           {{al, r8, r5, minus, 2224, PostIndex},
                            false,
                            al,
                            "al r8 r5 minus 2224 PostIndex",
                            "al_r8_r5_minus_2224_PostIndex"},
                           {{al, r5, r13, minus, 4090, PreIndex},
                            false,
                            al,
                            "al r5 r13 minus 4090 PreIndex",
                            "al_r5_r13_minus_4090_PreIndex"},
                           {{al, r11, r6, minus, 1455, PostIndex},
                            false,
                            al,
                            "al r11 r6 minus 1455 PostIndex",
                            "al_r11_r6_minus_1455_PostIndex"},
                           {{al, r3, r6, plus, 2546, PreIndex},
                            false,
                            al,
                            "al r3 r6 plus 2546 PreIndex",
                            "al_r3_r6_plus_2546_PreIndex"},
                           {{al, r1, r5, minus, 53, PreIndex},
                            false,
                            al,
                            "al r1 r5 minus 53 PreIndex",
                            "al_r1_r5_minus_53_PreIndex"},
                           {{al, r1, r7, plus, 3450, PreIndex},
                            false,
                            al,
                            "al r1 r7 plus 3450 PreIndex",
                            "al_r1_r7_plus_3450_PreIndex"},
                           {{al, r1, r14, minus, 2047, PreIndex},
                            false,
                            al,
                            "al r1 r14 minus 2047 PreIndex",
                            "al_r1_r14_minus_2047_PreIndex"},
                           {{al, r4, r6, minus, 1759, PostIndex},
                            false,
                            al,
                            "al r4 r6 minus 1759 PostIndex",
                            "al_r4_r6_minus_1759_PostIndex"},
                           {{al, r7, r5, plus, 3662, PreIndex},
                            false,
                            al,
                            "al r7 r5 plus 3662 PreIndex",
                            "al_r7_r5_plus_3662_PreIndex"},
                           {{al, r6, r9, minus, 2290, PostIndex},
                            false,
                            al,
                            "al r6 r9 minus 2290 PostIndex",
                            "al_r6_r9_minus_2290_PostIndex"},
                           {{al, r7, r9, plus, 2208, PreIndex},
                            false,
                            al,
                            "al r7 r9 plus 2208 PreIndex",
                            "al_r7_r9_plus_2208_PreIndex"},
                           {{al, r6, r0, minus, 1601, PostIndex},
                            false,
                            al,
                            "al r6 r0 minus 1601 PostIndex",
                            "al_r6_r0_minus_1601_PostIndex"},
                           {{al, r4, r3, plus, 2202, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus 2202 PostIndex",
                            "al_r4_r3_plus_2202_PostIndex"},
                           {{al, r12, r10, minus, 3688, PostIndex},
                            false,
                            al,
                            "al r12 r10 minus 3688 PostIndex",
                            "al_r12_r10_minus_3688_PostIndex"},
                           {{al, r11, r12, minus, 1455, PreIndex},
                            false,
                            al,
                            "al r11 r12 minus 1455 PreIndex",
                            "al_r11_r12_minus_1455_PreIndex"},
                           {{al, r1, r11, plus, 2929, PreIndex},
                            false,
                            al,
                            "al r1 r11 plus 2929 PreIndex",
                            "al_r1_r11_plus_2929_PreIndex"},
                           {{al, r5, r0, plus, 582, PostIndex},
                            false,
                            al,
                            "al r5 r0 plus 582 PostIndex",
                            "al_r5_r0_plus_582_PostIndex"},
                           {{al, r4, r13, minus, 3603, PreIndex},
                            false,
                            al,
                            "al r4 r13 minus 3603 PreIndex",
                            "al_r4_r13_minus_3603_PreIndex"},
                           {{al, r8, r5, plus, 525, PostIndex},
                            false,
                            al,
                            "al r8 r5 plus 525 PostIndex",
                            "al_r8_r5_plus_525_PostIndex"},
                           {{al, r5, r4, minus, 2810, PostIndex},
                            false,
                            al,
                            "al r5 r4 minus 2810 PostIndex",
                            "al_r5_r4_minus_2810_PostIndex"},
                           {{al, r7, r3, plus, 3344, PreIndex},
                            false,
                            al,
                            "al r7 r3 plus 3344 PreIndex",
                            "al_r7_r3_plus_3344_PreIndex"},
                           {{al, r7, r0, minus, 797, PostIndex},
                            false,
                            al,
                            "al r7 r0 minus 797 PostIndex",
                            "al_r7_r0_minus_797_PostIndex"},
                           {{al, r11, r12, minus, 2669, PreIndex},
                            false,
                            al,
                            "al r11 r12 minus 2669 PreIndex",
                            "al_r11_r12_minus_2669_PreIndex"},
                           {{al, r1, r7, plus, 2098, PostIndex},
                            false,
                            al,
                            "al r1 r7 plus 2098 PostIndex",
                            "al_r1_r7_plus_2098_PostIndex"},
                           {{al, r6, r7, plus, 670, PreIndex},
                            false,
                            al,
                            "al r6 r7 plus 670 PreIndex",
                            "al_r6_r7_plus_670_PreIndex"},
                           {{al, r14, r7, minus, 1171, PreIndex},
                            false,
                            al,
                            "al r14 r7 minus 1171 PreIndex",
                            "al_r14_r7_minus_1171_PreIndex"},
                           {{al, r6, r7, minus, 2810, PostIndex},
                            false,
                            al,
                            "al r6 r7 minus 2810 PostIndex",
                            "al_r6_r7_minus_2810_PostIndex"},
                           {{al, r13, r11, minus, 3105, PreIndex},
                            false,
                            al,
                            "al r13 r11 minus 3105 PreIndex",
                            "al_r13_r11_minus_3105_PreIndex"},
                           {{al, r13, r3, minus, 2703, PreIndex},
                            false,
                            al,
                            "al r13 r3 minus 2703 PreIndex",
                            "al_r13_r3_minus_2703_PreIndex"},
                           {{al, r13, r7, minus, 1665, PreIndex},
                            false,
                            al,
                            "al r13 r7 minus 1665 PreIndex",
                            "al_r13_r7_minus_1665_PreIndex"},
                           {{al, r7, r6, minus, 2800, PostIndex},
                            false,
                            al,
                            "al r7 r6 minus 2800 PostIndex",
                            "al_r7_r6_minus_2800_PostIndex"},
                           {{al, r13, r5, plus, 1175, PreIndex},
                            false,
                            al,
                            "al r13 r5 plus 1175 PreIndex",
                            "al_r13_r5_plus_1175_PreIndex"},
                           {{al, r13, r5, plus, 2523, PreIndex},
                            false,
                            al,
                            "al r13 r5 plus 2523 PreIndex",
                            "al_r13_r5_plus_2523_PreIndex"},
                           {{al, r2, r0, plus, 198, PostIndex},
                            false,
                            al,
                            "al r2 r0 plus 198 PostIndex",
                            "al_r2_r0_plus_198_PostIndex"},
                           {{al, r7, r4, minus, 1635, PostIndex},
                            false,
                            al,
                            "al r7 r4 minus 1635 PostIndex",
                            "al_r7_r4_minus_1635_PostIndex"},
                           {{al, r7, r5, plus, 3449, PostIndex},
                            false,
                            al,
                            "al r7 r5 plus 3449 PostIndex",
                            "al_r7_r5_plus_3449_PostIndex"},
                           {{al, r5, r14, plus, 1556, PostIndex},
                            false,
                            al,
                            "al r5 r14 plus 1556 PostIndex",
                            "al_r5_r14_plus_1556_PostIndex"},
                           {{al, r14, r8, plus, 2403, PostIndex},
                            false,
                            al,
                            "al r14 r8 plus 2403 PostIndex",
                            "al_r14_r8_plus_2403_PostIndex"},
                           {{al, r2, r8, minus, 2546, PostIndex},
                            false,
                            al,
                            "al r2 r8 minus 2546 PostIndex",
                            "al_r2_r8_minus_2546_PostIndex"},
                           {{al, r11, r5, plus, 2948, PostIndex},
                            false,
                            al,
                            "al r11 r5 plus 2948 PostIndex",
                            "al_r11_r5_plus_2948_PostIndex"},
                           {{al, r3, r9, plus, 1999, PreIndex},
                            false,
                            al,
                            "al r3 r9 plus 1999 PreIndex",
                            "al_r3_r9_plus_1999_PreIndex"},
                           {{al, r10, r7, plus, 198, PostIndex},
                            false,
                            al,
                            "al r10 r7 plus 198 PostIndex",
                            "al_r10_r7_plus_198_PostIndex"},
                           {{al, r13, r10, plus, 2021, PreIndex},
                            false,
                            al,
                            "al r13 r10 plus 2021 PreIndex",
                            "al_r13_r10_plus_2021_PreIndex"},
                           {{al, r1, r3, minus, 3570, PreIndex},
                            false,
                            al,
                            "al r1 r3 minus 3570 PreIndex",
                            "al_r1_r3_minus_3570_PreIndex"},
                           {{al, r11, r5, plus, 1892, PostIndex},
                            false,
                            al,
                            "al r11 r5 plus 1892 PostIndex",
                            "al_r11_r5_plus_1892_PostIndex"},
                           {{al, r10, r6, plus, 3438, PostIndex},
                            false,
                            al,
                            "al r10 r6 plus 3438 PostIndex",
                            "al_r10_r6_plus_3438_PostIndex"},
                           {{al, r6, r13, minus, 2982, PostIndex},
                            false,
                            al,
                            "al r6 r13 minus 2982 PostIndex",
                            "al_r6_r13_minus_2982_PostIndex"},
                           {{al, r10, r11, plus, 1732, PreIndex},
                            false,
                            al,
                            "al r10 r11 plus 1732 PreIndex",
                            "al_r10_r11_plus_1732_PreIndex"},
                           {{al, r2, r10, minus, 490, PreIndex},
                            false,
                            al,
                            "al r2 r10 minus 490 PreIndex",
                            "al_r2_r10_minus_490_PreIndex"},
                           {{al, r13, r14, plus, 2545, PostIndex},
                            false,
                            al,
                            "al r13 r14 plus 2545 PostIndex",
                            "al_r13_r14_plus_2545_PostIndex"},
                           {{al, r13, r10, minus, 48, PostIndex},
                            false,
                            al,
                            "al r13 r10 minus 48 PostIndex",
                            "al_r13_r10_minus_48_PostIndex"},
                           {{al, r11, r3, plus, 2233, PreIndex},
                            false,
                            al,
                            "al r11 r3 plus 2233 PreIndex",
                            "al_r11_r3_plus_2233_PreIndex"},
                           {{al, r6, r9, plus, 3366, PostIndex},
                            false,
                            al,
                            "al r6 r9 plus 3366 PostIndex",
                            "al_r6_r9_plus_3366_PostIndex"},
                           {{al, r13, r0, plus, 875, PostIndex},
                            false,
                            al,
                            "al r13 r0 plus 875 PostIndex",
                            "al_r13_r0_plus_875_PostIndex"},
                           {{al, r9, r7, minus, 2651, PreIndex},
                            false,
                            al,
                            "al r9 r7 minus 2651 PreIndex",
                            "al_r9_r7_minus_2651_PreIndex"},
                           {{al, r2, r7, plus, 3438, PreIndex},
                            false,
                            al,
                            "al r2 r7 plus 3438 PreIndex",
                            "al_r2_r7_plus_3438_PreIndex"},
                           {{al, r14, r1, minus, 1948, PreIndex},
                            false,
                            al,
                            "al r14 r1 minus 1948 PreIndex",
                            "al_r14_r1_minus_1948_PreIndex"},
                           {{al, r0, r14, minus, 83, PostIndex},
                            false,
                            al,
                            "al r0 r14 minus 83 PostIndex",
                            "al_r0_r14_minus_83_PostIndex"},
                           {{al, r8, r10, plus, 580, PostIndex},
                            false,
                            al,
                            "al r8 r10 plus 580 PostIndex",
                            "al_r8_r10_plus_580_PostIndex"},
                           {{al, r6, r4, plus, 3717, PostIndex},
                            false,
                            al,
                            "al r6 r4 plus 3717 PostIndex",
                            "al_r6_r4_plus_3717_PostIndex"},
                           {{al, r3, r5, minus, 3597, PostIndex},
                            false,
                            al,
                            "al r3 r5 minus 3597 PostIndex",
                            "al_r3_r5_minus_3597_PostIndex"},
                           {{al, r11, r14, plus, 1860, PreIndex},
                            false,
                            al,
                            "al r11 r14 plus 1860 PreIndex",
                            "al_r11_r14_plus_1860_PreIndex"},
                           {{al, r9, r3, minus, 3071, PostIndex},
                            false,
                            al,
                            "al r9 r3 minus 3071 PostIndex",
                            "al_r9_r3_minus_3071_PostIndex"},
                           {{al, r11, r3, minus, 2454, PostIndex},
                            false,
                            al,
                            "al r11 r3 minus 2454 PostIndex",
                            "al_r11_r3_minus_2454_PostIndex"},
                           {{al, r7, r6, plus, 3391, PreIndex},
                            false,
                            al,
                            "al r7 r6 plus 3391 PreIndex",
                            "al_r7_r6_plus_3391_PreIndex"},
                           {{al, r8, r7, minus, 732, PostIndex},
                            false,
                            al,
                            "al r8 r7 minus 732 PostIndex",
                            "al_r8_r7_minus_732_PostIndex"},
                           {{al, r6, r7, minus, 3978, PostIndex},
                            false,
                            al,
                            "al r6 r7 minus 3978 PostIndex",
                            "al_r6_r7_minus_3978_PostIndex"},
                           {{al, r4, r3, plus, 2016, PostIndex},
                            false,
                            al,
                            "al r4 r3 plus 2016 PostIndex",
                            "al_r4_r3_plus_2016_PostIndex"},
                           {{al, r13, r1, minus, 3425, PreIndex},
                            false,
                            al,
                            "al r13 r1 minus 3425 PreIndex",
                            "al_r13_r1_minus_3425_PreIndex"},
                           {{al, r11, r6, minus, 496, PreIndex},
                            false,
                            al,
                            "al r11 r6 minus 496 PreIndex",
                            "al_r11_r6_minus_496_PreIndex"},
                           {{al, r4, r0, minus, 3308, PostIndex},
                            false,
                            al,
                            "al r4 r0 minus 3308 PostIndex",
                            "al_r4_r0_minus_3308_PostIndex"},
                           {{al, r14, r3, plus, 524, PreIndex},
                            false,
                            al,
                            "al r14 r3 plus 524 PreIndex",
                            "al_r14_r3_plus_524_PreIndex"},
                           {{al, r5, r12, plus, 3325, PostIndex},
                            false,
                            al,
                            "al r5 r12 plus 3325 PostIndex",
                            "al_r5_r12_plus_3325_PostIndex"},
                           {{al, r6, r14, plus, 2792, PostIndex},
                            false,
                            al,
                            "al r6 r14 plus 2792 PostIndex",
                            "al_r6_r14_plus_2792_PostIndex"},
                           {{al, r10, r0, plus, 2119, PreIndex},
                            false,
                            al,
                            "al r10 r0 plus 2119 PreIndex",
                            "al_r10_r0_plus_2119_PreIndex"},
                           {{al, r12, r1, minus, 4090, PreIndex},
                            false,
                            al,
                            "al r12 r1 minus 4090 PreIndex",
                            "al_r12_r1_minus_4090_PreIndex"},
                           {{al, r11, r5, minus, 2532, PostIndex},
                            false,
                            al,
                            "al r11 r5 minus 2532 PostIndex",
                            "al_r11_r5_minus_2532_PostIndex"},
                           {{al, r2, r14, plus, 510, PreIndex},
                            false,
                            al,
                            "al r2 r14 plus 510 PreIndex",
                            "al_r2_r14_plus_510_PreIndex"},
                           {{al, r6, r12, minus, 3585, PreIndex},
                            false,
                            al,
                            "al r6 r12 minus 3585 PreIndex",
                            "al_r6_r12_minus_3585_PreIndex"},
                           {{al, r13, r2, minus, 3752, PreIndex},
                            false,
                            al,
                            "al r13 r2 minus 3752 PreIndex",
                            "al_r13_r2_minus_3752_PreIndex"},
                           {{al, r0, r9, plus, 1537, PostIndex},
                            false,
                            al,
                            "al r0 r9 plus 1537 PostIndex",
                            "al_r0_r9_plus_1537_PostIndex"},
                           {{al, r9, r10, minus, 3449, PreIndex},
                            false,
                            al,
                            "al r9 r10 minus 3449 PreIndex",
                            "al_r9_r10_minus_3449_PreIndex"},
                           {{al, r11, r7, minus, 1428, PostIndex},
                            false,
                            al,
                            "al r11 r7 minus 1428 PostIndex",
                            "al_r11_r7_minus_1428_PostIndex"},
                           {{al, r5, r7, plus, 580, PostIndex},
                            false,
                            al,
                            "al r5 r7 plus 580 PostIndex",
                            "al_r5_r7_plus_580_PostIndex"},
                           {{al, r5, r0, plus, 3607, PreIndex},
                            false,
                            al,
                            "al r5 r0 plus 3607 PreIndex",
                            "al_r5_r0_plus_3607_PreIndex"},
                           {{al, r12, r5, minus, 1168, PreIndex},
                            false,
                            al,
                            "al r12 r5 minus 1168 PreIndex",
                            "al_r12_r5_minus_1168_PreIndex"},
                           {{al, r8, r4, plus, 679, PostIndex},
                            false,
                            al,
                            "al r8 r4 plus 679 PostIndex",
                            "al_r8_r4_plus_679_PostIndex"},
                           {{al, r12, r6, minus, 1835, PostIndex},
                            false,
                            al,
                            "al r12 r6 minus 1835 PostIndex",
                            "al_r12_r6_minus_1835_PostIndex"},
                           {{al, r12, r0, plus, 2650, PostIndex},
                            false,
                            al,
                            "al r12 r0 plus 2650 PostIndex",
                            "al_r12_r0_plus_2650_PostIndex"},
                           {{al, r12, r13, minus, 1536, PostIndex},
                            false,
                            al,
                            "al r12 r13 minus 1536 PostIndex",
                            "al_r12_r13_minus_1536_PostIndex"},
                           {{al, r0, r9, minus, 2792, PreIndex},
                            false,
                            al,
                            "al r0 r9 minus 2792 PreIndex",
                            "al_r0_r9_minus_2792_PreIndex"},
                           {{al, r12, r6, plus, 2254, PreIndex},
                            false,
                            al,
                            "al r12 r6 plus 2254 PreIndex",
                            "al_r12_r6_plus_2254_PreIndex"},
                           {{al, r5, r4, plus, 1526, PostIndex},
                            false,
                            al,
                            "al r5 r4 plus 1526 PostIndex",
                            "al_r5_r4_plus_1526_PostIndex"},
                           {{al, r8, r10, minus, 282, PreIndex},
                            false,
                            al,
                            "al r8 r10 minus 282 PreIndex",
                            "al_r8_r10_minus_282_PreIndex"},
                           {{al, r7, r10, minus, 2839, PreIndex},
                            false,
                            al,
                            "al r7 r10 minus 2839 PreIndex",
                            "al_r7_r10_minus_2839_PreIndex"},
                           {{al, r8, r0, plus, 3138, PostIndex},
                            false,
                            al,
                            "al r8 r0 plus 3138 PostIndex",
                            "al_r8_r0_plus_3138_PostIndex"},
                           {{al, r6, r4, plus, 1892, PreIndex},
                            false,
                            al,
                            "al r6 r4 plus 1892 PreIndex",
                            "al_r6_r4_plus_1892_PreIndex"},
                           {{al, r7, r12, plus, 2290, PostIndex},
                            false,
                            al,
                            "al r7 r12 plus 2290 PostIndex",
                            "al_r7_r12_plus_2290_PostIndex"},
                           {{al, r0, r9, minus, 199, PreIndex},
                            false,
                            al,
                            "al r0 r9 minus 199 PreIndex",
                            "al_r0_r9_minus_199_PreIndex"},
                           {{al, r9, r1, minus, 2523, PreIndex},
                            false,
                            al,
                            "al r9 r1 minus 2523 PreIndex",
                            "al_r9_r1_minus_2523_PreIndex"},
                           {{al, r7, r13, plus, 2464, PreIndex},
                            false,
                            al,
                            "al r7 r13 plus 2464 PreIndex",
                            "al_r7_r13_plus_2464_PreIndex"},
                           {{al, r0, r4, minus, 496, PostIndex},
                            false,
                            al,
                            "al r0 r4 minus 496 PostIndex",
                            "al_r0_r4_minus_496_PostIndex"},
                           {{al, r7, r4, plus, 1009, PostIndex},
                            false,
                            al,
                            "al r7 r4 plus 1009 PostIndex",
                            "al_r7_r4_plus_1009_PostIndex"},
                           {{al, r4, r11, minus, 2119, PostIndex},
                            false,
                            al,
                            "al r4 r11 minus 2119 PostIndex",
                            "al_r4_r11_minus_2119_PostIndex"},
                           {{al, r5, r2, plus, 783, PreIndex},
                            false,
                            al,
                            "al r5 r2 plus 783 PreIndex",
                            "al_r5_r2_plus_783_PreIndex"},
                           {{al, r10, r6, minus, 998, PostIndex},
                            false,
                            al,
                            "al r10 r6 minus 998 PostIndex",
                            "al_r10_r6_minus_998_PostIndex"},
                           {{al, r10, r2, plus, 1348, PreIndex},
                            false,
                            al,
                            "al r10 r2 plus 1348 PreIndex",
                            "al_r10_r2_plus_1348_PreIndex"},
                           {{al, r3, r2, minus, 794, PreIndex},
                            false,
                            al,
                            "al r3 r2 minus 794 PreIndex",
                            "al_r3_r2_minus_794_PreIndex"},
                           {{al, r6, r5, minus, 4092, PostIndex},
                            false,
                            al,
                            "al r6 r5 minus 4092 PostIndex",
                            "al_r6_r5_minus_4092_PostIndex"},
                           {{al, r12, r10, plus, 484, PreIndex},
                            false,
                            al,
                            "al r12 r10 plus 484 PreIndex",
                            "al_r12_r10_plus_484_PreIndex"},
                           {{al, r3, r12, minus, 2792, PostIndex},
                            false,
                            al,
                            "al r3 r12 minus 2792 PostIndex",
                            "al_r3_r12_minus_2792_PostIndex"},
                           {{al, r0, r12, plus, 1234, PostIndex},
                            false,
                            al,
                            "al r0 r12 plus 1234 PostIndex",
                            "al_r0_r12_plus_1234_PostIndex"},
                           {{al, r9, r8, plus, 3529, PostIndex},
                            false,
                            al,
                            "al r9 r8 plus 3529 PostIndex",
                            "al_r9_r8_plus_3529_PostIndex"},
                           {{al, r12, r4, minus, 3907, PreIndex},
                            false,
                            al,
                            "al r12 r4 minus 3907 PreIndex",
                            "al_r12_r4_minus_3907_PreIndex"},
                           {{al, r9, r10, plus, 547, PreIndex},
                            false,
                            al,
                            "al r9 r10 plus 547 PreIndex",
                            "al_r9_r10_plus_547_PreIndex"},
                           {{al, r11, r9, minus, 2281, PreIndex},
                            false,
                            al,
                            "al r11 r9 minus 2281 PreIndex",
                            "al_r11_r9_minus_2281_PreIndex"},
                           {{al, r10, r11, plus, 2011, PostIndex},
                            false,
                            al,
                            "al r10 r11 plus 2011 PostIndex",
                            "al_r10_r11_plus_2011_PostIndex"},
                           {{al, r8, r9, plus, 1740, PreIndex},
                            false,
                            al,
                            "al r8 r9 plus 1740 PreIndex",
                            "al_r8_r9_plus_1740_PreIndex"},
                           {{al, r0, r11, minus, 1485, PostIndex},
                            false,
                            al,
                            "al r0 r11 minus 1485 PostIndex",
                            "al_r0_r11_minus_1485_PostIndex"},
                           {{al, r3, r4, plus, 774, PreIndex},
                            false,
                            al,
                            "al r3 r4 plus 774 PreIndex",
                            "al_r3_r4_plus_774_PreIndex"},
                           {{al, r7, r1, plus, 2906, PostIndex},
                            false,
                            al,
                            "al r7 r1 plus 2906 PostIndex",
                            "al_r7_r1_plus_2906_PostIndex"},
                           {{al, r11, r6, minus, 3564, PostIndex},
                            false,
                            al,
                            "al r11 r6 minus 3564 PostIndex",
                            "al_r11_r6_minus_3564_PostIndex"},
                           {{al, r7, r11, minus, 3413, PreIndex},
                            false,
                            al,
                            "al r7 r11 minus 3413 PreIndex",
                            "al_r7_r11_minus_3413_PreIndex"},
                           {{al, r5, r4, plus, 22, PreIndex},
                            false,
                            al,
                            "al r5 r4 plus 22 PreIndex",
                            "al_r5_r4_plus_22_PreIndex"},
                           {{al, r6, r8, plus, 2175, PreIndex},
                            false,
                            al,
                            "al r6 r8 plus 2175 PreIndex",
                            "al_r6_r8_plus_2175_PreIndex"},
                           {{al, r11, r1, minus, 3880, PostIndex},
                            false,
                            al,
                            "al r11 r1 minus 3880 PostIndex",
                            "al_r11_r1_minus_3880_PostIndex"},
                           {{al, r8, r14, plus, 2453, PostIndex},
                            false,
                            al,
                            "al r8 r14 plus 2453 PostIndex",
                            "al_r8_r14_plus_2453_PostIndex"},
                           {{al, r10, r6, plus, 3660, PreIndex},
                            false,
                            al,
                            "al r10 r6 plus 3660 PreIndex",
                            "al_r10_r6_plus_3660_PreIndex"},
                           {{al, r1, r4, plus, 2519, PostIndex},
                            false,
                            al,
                            "al r1 r4 plus 2519 PostIndex",
                            "al_r1_r4_plus_2519_PostIndex"},
                           {{al, r6, r9, minus, 2183, PostIndex},
                            false,
                            al,
                            "al r6 r9 minus 2183 PostIndex",
                            "al_r6_r9_minus_2183_PostIndex"},
                           {{al, r12, r3, minus, 1750, PostIndex},
                            false,
                            al,
                            "al r12 r3 minus 1750 PostIndex",
                            "al_r12_r3_minus_1750_PostIndex"},
                           {{al, r6, r12, plus, 998, PreIndex},
                            false,
                            al,
                            "al r6 r12 plus 998 PreIndex",
                            "al_r6_r12_plus_998_PreIndex"},
                           {{al, r2, r11, minus, 1740, PreIndex},
                            false,
                            al,
                            "al r2 r11 minus 1740 PreIndex",
                            "al_r2_r11_minus_1740_PreIndex"},
                           {{al, r12, r14, plus, 3138, PreIndex},
                            false,
                            al,
                            "al r12 r14 plus 3138 PreIndex",
                            "al_r12_r14_plus_3138_PreIndex"},
                           {{al, r6, r5, plus, 3771, PreIndex},
                            false,
                            al,
                            "al r6 r5 plus 3771 PreIndex",
                            "al_r6_r5_plus_3771_PreIndex"},
                           {{al, r1, r6, minus, 3663, PreIndex},
                            false,
                            al,
                            "al r1 r6 minus 3663 PreIndex",
                            "al_r1_r6_minus_3663_PreIndex"},
                           {{al, r2, r9, minus, 2662, PostIndex},
                            false,
                            al,
                            "al r2 r9 minus 2662 PostIndex",
                            "al_r2_r9_minus_2662_PostIndex"},
                           {{al, r14, r1, minus, 3076, PostIndex},
                            false,
                            al,
                            "al r14 r1 minus 3076 PostIndex",
                            "al_r14_r1_minus_3076_PostIndex"},
                           {{al, r2, r9, plus, 1542, PostIndex},
                            false,
                            al,
                            "al r2 r9 plus 1542 PostIndex",
                            "al_r2_r9_plus_1542_PostIndex"},
                           {{al, r14, r7, plus, 2016, PreIndex},
                            false,
                            al,
                            "al r14 r7 plus 2016 PreIndex",
                            "al_r14_r7_plus_2016_PreIndex"},
                           {{al, r3, r5, minus, 1981, PreIndex},
                            false,
                            al,
                            "al r3 r5 minus 1981 PreIndex",
                            "al_r3_r5_minus_1981_PreIndex"},
                           {{al, r7, r3, plus, 2233, PostIndex},
                            false,
                            al,
                            "al r7 r3 plus 2233 PostIndex",
                            "al_r7_r3_plus_2233_PostIndex"},
                           {{al, r8, r5, minus, 4095, PostIndex},
                            false,
                            al,
                            "al r8 r5 minus 4095 PostIndex",
                            "al_r8_r5_minus_4095_PostIndex"},
                           {{al, r0, r8, minus, 662, PostIndex},
                            false,
                            al,
                            "al r0 r8 minus 662 PostIndex",
                            "al_r0_r8_minus_662_PostIndex"},
                           {{al, r9, r5, minus, 4046, PostIndex},
                            false,
                            al,
                            "al r9 r5 minus 4046 PostIndex",
                            "al_r9_r5_minus_4046_PostIndex"},
                           {{al, r10, r4, plus, 2245, PreIndex},
                            false,
                            al,
                            "al r10 r4 plus 2245 PreIndex",
                            "al_r10_r4_plus_2245_PreIndex"},
                           {{al, r2, r1, plus, 2036, PostIndex},
                            false,
                            al,
                            "al r2 r1 plus 2036 PostIndex",
                            "al_r2_r1_plus_2036_PostIndex"},
                           {{al, r0, r1, minus, 1159, PreIndex},
                            false,
                            al,
                            "al r0 r1 minus 1159 PreIndex",
                            "al_r0_r1_minus_1159_PreIndex"},
                           {{al, r7, r9, minus, 3109, PostIndex},
                            false,
                            al,
                            "al r7 r9 minus 3109 PostIndex",
                            "al_r7_r9_minus_3109_PostIndex"},
                           {{al, r5, r6, plus, 1655, PreIndex},
                            false,
                            al,
                            "al r5 r6 plus 1655 PreIndex",
                            "al_r5_r6_plus_1655_PreIndex"},
                           {{al, r10, r12, minus, 3094, PreIndex},
                            false,
                            al,
                            "al r10 r12 minus 3094 PreIndex",
                            "al_r10_r12_minus_3094_PreIndex"},
                           {{al, r7, r6, plus, 1241, PreIndex},
                            false,
                            al,
                            "al r7 r6 plus 1241 PreIndex",
                            "al_r7_r6_plus_1241_PreIndex"},
                           {{al, r13, r3, plus, 1824, PreIndex},
                            false,
                            al,
                            "al r13 r3 plus 1824 PreIndex",
                            "al_r13_r3_plus_1824_PreIndex"},
                           {{al, r10, r12, minus, 1159, PreIndex},
                            false,
                            al,
                            "al r10 r12 minus 1159 PreIndex",
                            "al_r10_r12_minus_1159_PreIndex"},
                           {{al, r6, r10, minus, 2948, PreIndex},
                            false,
                            al,
                            "al r6 r10 minus 2948 PreIndex",
                            "al_r6_r10_minus_2948_PreIndex"},
                           {{al, r9, r6, plus, 496, PreIndex},
                            false,
                            al,
                            "al r9 r6 plus 496 PreIndex",
                            "al_r9_r6_plus_496_PreIndex"},
                           {{al, r10, r9, plus, 213, PreIndex},
                            false,
                            al,
                            "al r10 r9 plus 213 PreIndex",
                            "al_r10_r9_plus_213_PreIndex"},
                           {{al, r14, r1, minus, 2642, PreIndex},
                            false,
                            al,
                            "al r14 r1 minus 2642 PreIndex",
                            "al_r14_r1_minus_2642_PreIndex"},
                           {{al, r6, r12, plus, 3529, PostIndex},
                            false,
                            al,
                            "al r6 r12 plus 3529 PostIndex",
                            "al_r6_r12_plus_3529_PostIndex"},
                           {{al, r4, r9, minus, 3625, PreIndex},
                            false,
                            al,
                            "al r4 r9 minus 3625 PreIndex",
                            "al_r4_r9_minus_3625_PreIndex"},
                           {{al, r8, r0, minus, 2046, PreIndex},
                            false,
                            al,
                            "al r8 r0 minus 2046 PreIndex",
                            "al_r8_r0_minus_2046_PreIndex"},
                           {{al, r5, r4, minus, 365, PostIndex},
                            false,
                            al,
                            "al r5 r4 minus 365 PostIndex",
                            "al_r5_r4_minus_365_PostIndex"},
                           {{al, r11, r13, minus, 1389, PreIndex},
                            false,
                            al,
                            "al r11 r13 minus 1389 PreIndex",
                            "al_r11_r13_minus_1389_PreIndex"},
                           {{al, r1, r3, minus, 251, PostIndex},
                            false,
                            al,
                            "al r1 r3 minus 251 PostIndex",
                            "al_r1_r3_minus_251_PostIndex"},
                           {{al, r6, r0, plus, 2617, PreIndex},
                            false,
                            al,
                            "al r6 r0 plus 2617 PreIndex",
                            "al_r6_r0_plus_2617_PreIndex"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-memop-immediate-8192-ldr-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-8192-ldrb-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-8192-str-a32.h"
#include "aarch32/traces/assembler-cond-rd-memop-immediate-8192-strb-a32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const MemOperand& memop);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseA32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Sign sign = kTests[i].operands.sign;
    int32_t offset = kTests[i].operands.offset;
    AddrMode addr_mode = kTests[i].operands.addr_mode;
    MemOperand memop(rn, sign, offset, addr_mode);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, memop);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_MEMOP_IMMEDIATE_8192_" #mnemonic "_A32",   \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
