// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_ADDP_2D_TRACE_AARCH64_H_
#define VIXL_SIM_ADDP_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_addp_2D[] = {
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007d, 0x0000000000000003,
  0x000000000000007d, 0x0000000000000042,
  0x000000000000007d, 0x00000000000000bd,
  0x000000000000007d, 0x00000000000000fb,
  0x000000000000007d, 0x00000000000000fd,
  0x000000000000007d, 0x000000000000807c,
  0x000000000000007d, 0x000000000000fffb,
  0x000000000000007d, 0x000000000000fffd,
  0x000000000000007d, 0x0000000080007ffc,
  0x000000000000007d, 0x00000000fffffffb,
  0x000000000000007d, 0x00000000fffffffd,
  0x000000000000007d, 0x33333333b3333332,
  0x000000000000007d, 0x8888888888888888,
  0x000000000000007d, 0xd555555555555552,
  0x000000000000007d, 0xfffffffffffffffb,
  0x000000000000007d, 0xfffffffffffffffd,
  0x000000000000007d, 0xffffffffffffffff,
  0x000000000000007d, 0x0000000000000001,
  0x000000000000007d, 0x0000000000000003,
  0x000000000000007d, 0x0000000000000005,
  0x000000000000007d, 0x2aaaaaaaaaaaaaad,
  0x000000000000007d, 0x7777777777777776,
  0x000000000000007d, 0xcccccccc4ccccccc,
  0x000000000000007d, 0xffffffff00000001,
  0x000000000000007d, 0xffffffff00000003,
  0x000000000000007d, 0xffffffff00000005,
  0x000000000000007d, 0xffffffff7fff8003,
  0x000000000000007d, 0xffffffffffff0001,
  0x000000000000007d, 0xffffffffffff0003,
  0x000000000000007d, 0xffffffffffff0005,
  0x000000000000007d, 0xffffffffffff7f83,
  0x000000000000007d, 0xffffffffffffff01,
  0x000000000000007d, 0xffffffffffffff03,
  0x000000000000007d, 0xffffffffffffff05,
  0x000000000000007d, 0xffffffffffffff43,
  0x000000000000007d, 0xffffffffffffffbd,
  0x000000000000007d, 0xfffffffffffffffb,
  0x000000000000007d, 0xfffffffffffffffd,
  0x0000000000000001, 0xffffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000042,
  0x0000000000000001, 0x00000000000000bd,
  0x0000000000000001, 0x00000000000000fb,
  0x0000000000000001, 0x00000000000000fd,
  0x0000000000000001, 0x000000000000807c,
  0x0000000000000001, 0x000000000000fffb,
  0x0000000000000001, 0x000000000000fffd,
  0x0000000000000001, 0x0000000080007ffc,
  0x0000000000000001, 0x00000000fffffffb,
  0x0000000000000001, 0x00000000fffffffd,
  0x0000000000000001, 0x33333333b3333332,
  0x0000000000000001, 0x8888888888888888,
  0x0000000000000001, 0xd555555555555552,
  0x0000000000000001, 0xfffffffffffffffb,
  0x0000000000000001, 0xfffffffffffffffd,
  0x0000000000000001, 0xffffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000005,
  0x0000000000000001, 0x2aaaaaaaaaaaaaad,
  0x0000000000000001, 0x7777777777777776,
  0x0000000000000001, 0xcccccccc4ccccccc,
  0x0000000000000001, 0xffffffff00000001,
  0x0000000000000001, 0xffffffff00000003,
  0x0000000000000001, 0xffffffff00000005,
  0x0000000000000001, 0xffffffff7fff8003,
  0x0000000000000001, 0xffffffffffff0001,
  0x0000000000000001, 0xffffffffffff0003,
  0x0000000000000001, 0xffffffffffff0005,
  0x0000000000000001, 0xffffffffffff7f83,
  0x0000000000000001, 0xffffffffffffff01,
  0x0000000000000001, 0xffffffffffffff03,
  0x0000000000000001, 0xffffffffffffff05,
  0x0000000000000001, 0xffffffffffffff43,
  0x0000000000000001, 0xffffffffffffffbd,
  0x0000000000000001, 0xfffffffffffffffb,
  0x0000000000000001, 0xfffffffffffffffd,
  0x0000000000000003, 0xffffffffffffffff,
  0x0000000000000003, 0x0000000000000001,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000003, 0x00000000000000bd,
  0x0000000000000003, 0x00000000000000fb,
  0x0000000000000003, 0x00000000000000fd,
  0x0000000000000003, 0x000000000000807c,
  0x0000000000000003, 0x000000000000fffb,
  0x0000000000000003, 0x000000000000fffd,
  0x0000000000000003, 0x0000000080007ffc,
  0x0000000000000003, 0x00000000fffffffb,
  0x0000000000000003, 0x00000000fffffffd,
  0x0000000000000003, 0x33333333b3333332,
  0x0000000000000003, 0x8888888888888888,
  0x0000000000000003, 0xd555555555555552,
  0x0000000000000003, 0xfffffffffffffffb,
  0x0000000000000003, 0xfffffffffffffffd,
  0x0000000000000003, 0xffffffffffffffff,
  0x0000000000000003, 0x0000000000000001,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000005,
  0x0000000000000003, 0x2aaaaaaaaaaaaaad,
  0x0000000000000003, 0x7777777777777776,
  0x0000000000000003, 0xcccccccc4ccccccc,
  0x0000000000000003, 0xffffffff00000001,
  0x0000000000000003, 0xffffffff00000003,
  0x0000000000000003, 0xffffffff00000005,
  0x0000000000000003, 0xffffffff7fff8003,
  0x0000000000000003, 0xffffffffffff0001,
  0x0000000000000003, 0xffffffffffff0003,
  0x0000000000000003, 0xffffffffffff0005,
  0x0000000000000003, 0xffffffffffff7f83,
  0x0000000000000003, 0xffffffffffffff01,
  0x0000000000000003, 0xffffffffffffff03,
  0x0000000000000003, 0xffffffffffffff05,
  0x0000000000000003, 0xffffffffffffff43,
  0x0000000000000003, 0xffffffffffffffbd,
  0x0000000000000003, 0xfffffffffffffffb,
  0x0000000000000003, 0xfffffffffffffffd,
  0x0000000000000042, 0xffffffffffffffff,
  0x0000000000000042, 0x0000000000000001,
  0x0000000000000042, 0x0000000000000003,
  0x0000000000000042, 0x0000000000000042,
  0x0000000000000042, 0x00000000000000bd,
  0x0000000000000042, 0x00000000000000fb,
  0x0000000000000042, 0x00000000000000fd,
  0x0000000000000042, 0x000000000000807c,
  0x0000000000000042, 0x000000000000fffb,
  0x0000000000000042, 0x000000000000fffd,
  0x0000000000000042, 0x0000000080007ffc,
  0x0000000000000042, 0x00000000fffffffb,
  0x0000000000000042, 0x00000000fffffffd,
  0x0000000000000042, 0x33333333b3333332,
  0x0000000000000042, 0x8888888888888888,
  0x0000000000000042, 0xd555555555555552,
  0x0000000000000042, 0xfffffffffffffffb,
  0x0000000000000042, 0xfffffffffffffffd,
  0x0000000000000042, 0xffffffffffffffff,
  0x0000000000000042, 0x0000000000000001,
  0x0000000000000042, 0x0000000000000003,
  0x0000000000000042, 0x0000000000000005,
  0x0000000000000042, 0x2aaaaaaaaaaaaaad,
  0x0000000000000042, 0x7777777777777776,
  0x0000000000000042, 0xcccccccc4ccccccc,
  0x0000000000000042, 0xffffffff00000001,
  0x0000000000000042, 0xffffffff00000003,
  0x0000000000000042, 0xffffffff00000005,
  0x0000000000000042, 0xffffffff7fff8003,
  0x0000000000000042, 0xffffffffffff0001,
  0x0000000000000042, 0xffffffffffff0003,
  0x0000000000000042, 0xffffffffffff0005,
  0x0000000000000042, 0xffffffffffff7f83,
  0x0000000000000042, 0xffffffffffffff01,
  0x0000000000000042, 0xffffffffffffff03,
  0x0000000000000042, 0xffffffffffffff05,
  0x0000000000000042, 0xffffffffffffff43,
  0x0000000000000042, 0xffffffffffffffbd,
  0x0000000000000042, 0xfffffffffffffffb,
  0x0000000000000042, 0xfffffffffffffffd,
  0x00000000000000bd, 0xffffffffffffffff,
  0x00000000000000bd, 0x0000000000000001,
  0x00000000000000bd, 0x0000000000000003,
  0x00000000000000bd, 0x0000000000000042,
  0x00000000000000bd, 0x00000000000000bd,
  0x00000000000000bd, 0x00000000000000fb,
  0x00000000000000bd, 0x00000000000000fd,
  0x00000000000000bd, 0x000000000000807c,
  0x00000000000000bd, 0x000000000000fffb,
  0x00000000000000bd, 0x000000000000fffd,
  0x00000000000000bd, 0x0000000080007ffc,
  0x00000000000000bd, 0x00000000fffffffb,
  0x00000000000000bd, 0x00000000fffffffd,
  0x00000000000000bd, 0x33333333b3333332,
  0x00000000000000bd, 0x8888888888888888,
  0x00000000000000bd, 0xd555555555555552,
  0x00000000000000bd, 0xfffffffffffffffb,
  0x00000000000000bd, 0xfffffffffffffffd,
  0x00000000000000bd, 0xffffffffffffffff,
  0x00000000000000bd, 0x0000000000000001,
  0x00000000000000bd, 0x0000000000000003,
  0x00000000000000bd, 0x0000000000000005,
  0x00000000000000bd, 0x2aaaaaaaaaaaaaad,
  0x00000000000000bd, 0x7777777777777776,
  0x00000000000000bd, 0xcccccccc4ccccccc,
  0x00000000000000bd, 0xffffffff00000001,
  0x00000000000000bd, 0xffffffff00000003,
  0x00000000000000bd, 0xffffffff00000005,
  0x00000000000000bd, 0xffffffff7fff8003,
  0x00000000000000bd, 0xffffffffffff0001,
  0x00000000000000bd, 0xffffffffffff0003,
  0x00000000000000bd, 0xffffffffffff0005,
  0x00000000000000bd, 0xffffffffffff7f83,
  0x00000000000000bd, 0xffffffffffffff01,
  0x00000000000000bd, 0xffffffffffffff03,
  0x00000000000000bd, 0xffffffffffffff05,
  0x00000000000000bd, 0xffffffffffffff43,
  0x00000000000000bd, 0xffffffffffffffbd,
  0x00000000000000bd, 0xfffffffffffffffb,
  0x00000000000000bd, 0xfffffffffffffffd,
  0x00000000000000fb, 0xffffffffffffffff,
  0x00000000000000fb, 0x0000000000000001,
  0x00000000000000fb, 0x0000000000000003,
  0x00000000000000fb, 0x0000000000000042,
  0x00000000000000fb, 0x00000000000000bd,
  0x00000000000000fb, 0x00000000000000fb,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fb, 0x000000000000807c,
  0x00000000000000fb, 0x000000000000fffb,
  0x00000000000000fb, 0x000000000000fffd,
  0x00000000000000fb, 0x0000000080007ffc,
  0x00000000000000fb, 0x00000000fffffffb,
  0x00000000000000fb, 0x00000000fffffffd,
  0x00000000000000fb, 0x33333333b3333332,
  0x00000000000000fb, 0x8888888888888888,
  0x00000000000000fb, 0xd555555555555552,
  0x00000000000000fb, 0xfffffffffffffffb,
  0x00000000000000fb, 0xfffffffffffffffd,
  0x00000000000000fb, 0xffffffffffffffff,
  0x00000000000000fb, 0x0000000000000001,
  0x00000000000000fb, 0x0000000000000003,
  0x00000000000000fb, 0x0000000000000005,
  0x00000000000000fb, 0x2aaaaaaaaaaaaaad,
  0x00000000000000fb, 0x7777777777777776,
  0x00000000000000fb, 0xcccccccc4ccccccc,
  0x00000000000000fb, 0xffffffff00000001,
  0x00000000000000fb, 0xffffffff00000003,
  0x00000000000000fb, 0xffffffff00000005,
  0x00000000000000fb, 0xffffffff7fff8003,
  0x00000000000000fb, 0xffffffffffff0001,
  0x00000000000000fb, 0xffffffffffff0003,
  0x00000000000000fb, 0xffffffffffff0005,
  0x00000000000000fb, 0xffffffffffff7f83,
  0x00000000000000fb, 0xffffffffffffff01,
  0x00000000000000fb, 0xffffffffffffff03,
  0x00000000000000fb, 0xffffffffffffff05,
  0x00000000000000fb, 0xffffffffffffff43,
  0x00000000000000fb, 0xffffffffffffffbd,
  0x00000000000000fb, 0xfffffffffffffffb,
  0x00000000000000fb, 0xfffffffffffffffd,
  0x00000000000000fd, 0xffffffffffffffff,
  0x00000000000000fd, 0x0000000000000001,
  0x00000000000000fd, 0x0000000000000003,
  0x00000000000000fd, 0x0000000000000042,
  0x00000000000000fd, 0x00000000000000bd,
  0x00000000000000fd, 0x00000000000000fb,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fd, 0x000000000000fffb,
  0x00000000000000fd, 0x000000000000fffd,
  0x00000000000000fd, 0x0000000080007ffc,
  0x00000000000000fd, 0x00000000fffffffb,
  0x00000000000000fd, 0x00000000fffffffd,
  0x00000000000000fd, 0x33333333b3333332,
  0x00000000000000fd, 0x8888888888888888,
  0x00000000000000fd, 0xd555555555555552,
  0x00000000000000fd, 0xfffffffffffffffb,
  0x00000000000000fd, 0xfffffffffffffffd,
  0x00000000000000fd, 0xffffffffffffffff,
  0x00000000000000fd, 0x0000000000000001,
  0x00000000000000fd, 0x0000000000000003,
  0x00000000000000fd, 0x0000000000000005,
  0x00000000000000fd, 0x2aaaaaaaaaaaaaad,
  0x00000000000000fd, 0x7777777777777776,
  0x00000000000000fd, 0xcccccccc4ccccccc,
  0x00000000000000fd, 0xffffffff00000001,
  0x00000000000000fd, 0xffffffff00000003,
  0x00000000000000fd, 0xffffffff00000005,
  0x00000000000000fd, 0xffffffff7fff8003,
  0x00000000000000fd, 0xffffffffffff0001,
  0x00000000000000fd, 0xffffffffffff0003,
  0x00000000000000fd, 0xffffffffffff0005,
  0x00000000000000fd, 0xffffffffffff7f83,
  0x00000000000000fd, 0xffffffffffffff01,
  0x00000000000000fd, 0xffffffffffffff03,
  0x00000000000000fd, 0xffffffffffffff05,
  0x00000000000000fd, 0xffffffffffffff43,
  0x00000000000000fd, 0xffffffffffffffbd,
  0x00000000000000fd, 0xfffffffffffffffb,
  0x00000000000000fd, 0xfffffffffffffffd,
  0x000000000000807c, 0xffffffffffffffff,
  0x000000000000807c, 0x0000000000000001,
  0x000000000000807c, 0x0000000000000003,
  0x000000000000807c, 0x0000000000000042,
  0x000000000000807c, 0x00000000000000bd,
  0x000000000000807c, 0x00000000000000fb,
  0x000000000000807c, 0x00000000000000fd,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807c, 0x000000000000fffd,
  0x000000000000807c, 0x0000000080007ffc,
  0x000000000000807c, 0x00000000fffffffb,
  0x000000000000807c, 0x00000000fffffffd,
  0x000000000000807c, 0x33333333b3333332,
  0x000000000000807c, 0x8888888888888888,
  0x000000000000807c, 0xd555555555555552,
  0x000000000000807c, 0xfffffffffffffffb,
  0x000000000000807c, 0xfffffffffffffffd,
  0x000000000000807c, 0xffffffffffffffff,
  0x000000000000807c, 0x0000000000000001,
  0x000000000000807c, 0x0000000000000003,
  0x000000000000807c, 0x0000000000000005,
  0x000000000000807c, 0x2aaaaaaaaaaaaaad,
  0x000000000000807c, 0x7777777777777776,
  0x000000000000807c, 0xcccccccc4ccccccc,
  0x000000000000807c, 0xffffffff00000001,
  0x000000000000807c, 0xffffffff00000003,
  0x000000000000807c, 0xffffffff00000005,
  0x000000000000807c, 0xffffffff7fff8003,
  0x000000000000807c, 0xffffffffffff0001,
  0x000000000000807c, 0xffffffffffff0003,
  0x000000000000807c, 0xffffffffffff0005,
  0x000000000000807c, 0xffffffffffff7f83,
  0x000000000000807c, 0xffffffffffffff01,
  0x000000000000807c, 0xffffffffffffff03,
  0x000000000000807c, 0xffffffffffffff05,
  0x000000000000807c, 0xffffffffffffff43,
  0x000000000000807c, 0xffffffffffffffbd,
  0x000000000000807c, 0xfffffffffffffffb,
  0x000000000000807c, 0xfffffffffffffffd,
  0x000000000000fffb, 0xffffffffffffffff,
  0x000000000000fffb, 0x0000000000000001,
  0x000000000000fffb, 0x0000000000000003,
  0x000000000000fffb, 0x0000000000000042,
  0x000000000000fffb, 0x00000000000000bd,
  0x000000000000fffb, 0x00000000000000fb,
  0x000000000000fffb, 0x00000000000000fd,
  0x000000000000fffb, 0x000000000000807c,
  0x000000000000fffb, 0x000000000000fffb,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffb, 0x0000000080007ffc,
  0x000000000000fffb, 0x00000000fffffffb,
  0x000000000000fffb, 0x00000000fffffffd,
  0x000000000000fffb, 0x33333333b3333332,
  0x000000000000fffb, 0x8888888888888888,
  0x000000000000fffb, 0xd555555555555552,
  0x000000000000fffb, 0xfffffffffffffffb,
  0x000000000000fffb, 0xfffffffffffffffd,
  0x000000000000fffb, 0xffffffffffffffff,
  0x000000000000fffb, 0x0000000000000001,
  0x000000000000fffb, 0x0000000000000003,
  0x000000000000fffb, 0x0000000000000005,
  0x000000000000fffb, 0x2aaaaaaaaaaaaaad,
  0x000000000000fffb, 0x7777777777777776,
  0x000000000000fffb, 0xcccccccc4ccccccc,
  0x000000000000fffb, 0xffffffff00000001,
  0x000000000000fffb, 0xffffffff00000003,
  0x000000000000fffb, 0xffffffff00000005,
  0x000000000000fffb, 0xffffffff7fff8003,
  0x000000000000fffb, 0xffffffffffff0001,
  0x000000000000fffb, 0xffffffffffff0003,
  0x000000000000fffb, 0xffffffffffff0005,
  0x000000000000fffb, 0xffffffffffff7f83,
  0x000000000000fffb, 0xffffffffffffff01,
  0x000000000000fffb, 0xffffffffffffff03,
  0x000000000000fffb, 0xffffffffffffff05,
  0x000000000000fffb, 0xffffffffffffff43,
  0x000000000000fffb, 0xffffffffffffffbd,
  0x000000000000fffb, 0xfffffffffffffffb,
  0x000000000000fffb, 0xfffffffffffffffd,
  0x000000000000fffd, 0xffffffffffffffff,
  0x000000000000fffd, 0x0000000000000001,
  0x000000000000fffd, 0x0000000000000003,
  0x000000000000fffd, 0x0000000000000042,
  0x000000000000fffd, 0x00000000000000bd,
  0x000000000000fffd, 0x00000000000000fb,
  0x000000000000fffd, 0x00000000000000fd,
  0x000000000000fffd, 0x000000000000807c,
  0x000000000000fffd, 0x000000000000fffb,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffd, 0x0000000080007ffc,
  0x000000000000fffd, 0x00000000fffffffb,
  0x000000000000fffd, 0x00000000fffffffd,
  0x000000000000fffd, 0x33333333b3333332,
  0x000000000000fffd, 0x8888888888888888,
  0x000000000000fffd, 0xd555555555555552,
  0x000000000000fffd, 0xfffffffffffffffb,
  0x000000000000fffd, 0xfffffffffffffffd,
  0x000000000000fffd, 0xffffffffffffffff,
  0x000000000000fffd, 0x0000000000000001,
  0x000000000000fffd, 0x0000000000000003,
  0x000000000000fffd, 0x0000000000000005,
  0x000000000000fffd, 0x2aaaaaaaaaaaaaad,
  0x000000000000fffd, 0x7777777777777776,
  0x000000000000fffd, 0xcccccccc4ccccccc,
  0x000000000000fffd, 0xffffffff00000001,
  0x000000000000fffd, 0xffffffff00000003,
  0x000000000000fffd, 0xffffffff00000005,
  0x000000000000fffd, 0xffffffff7fff8003,
  0x000000000000fffd, 0xffffffffffff0001,
  0x000000000000fffd, 0xffffffffffff0003,
  0x000000000000fffd, 0xffffffffffff0005,
  0x000000000000fffd, 0xffffffffffff7f83,
  0x000000000000fffd, 0xffffffffffffff01,
  0x000000000000fffd, 0xffffffffffffff03,
  0x000000000000fffd, 0xffffffffffffff05,
  0x000000000000fffd, 0xffffffffffffff43,
  0x000000000000fffd, 0xffffffffffffffbd,
  0x000000000000fffd, 0xfffffffffffffffb,
  0x000000000000fffd, 0xfffffffffffffffd,
  0x0000000080007ffc, 0xffffffffffffffff,
  0x0000000080007ffc, 0x0000000000000001,
  0x0000000080007ffc, 0x0000000000000003,
  0x0000000080007ffc, 0x0000000000000042,
  0x0000000080007ffc, 0x00000000000000bd,
  0x0000000080007ffc, 0x00000000000000fb,
  0x0000000080007ffc, 0x00000000000000fd,
  0x0000000080007ffc, 0x000000000000807c,
  0x0000000080007ffc, 0x000000000000fffb,
  0x0000000080007ffc, 0x000000000000fffd,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffc, 0x00000000fffffffb,
  0x0000000080007ffc, 0x00000000fffffffd,
  0x0000000080007ffc, 0x33333333b3333332,
  0x0000000080007ffc, 0x8888888888888888,
  0x0000000080007ffc, 0xd555555555555552,
  0x0000000080007ffc, 0xfffffffffffffffb,
  0x0000000080007ffc, 0xfffffffffffffffd,
  0x0000000080007ffc, 0xffffffffffffffff,
  0x0000000080007ffc, 0x0000000000000001,
  0x0000000080007ffc, 0x0000000000000003,
  0x0000000080007ffc, 0x0000000000000005,
  0x0000000080007ffc, 0x2aaaaaaaaaaaaaad,
  0x0000000080007ffc, 0x7777777777777776,
  0x0000000080007ffc, 0xcccccccc4ccccccc,
  0x0000000080007ffc, 0xffffffff00000001,
  0x0000000080007ffc, 0xffffffff00000003,
  0x0000000080007ffc, 0xffffffff00000005,
  0x0000000080007ffc, 0xffffffff7fff8003,
  0x0000000080007ffc, 0xffffffffffff0001,
  0x0000000080007ffc, 0xffffffffffff0003,
  0x0000000080007ffc, 0xffffffffffff0005,
  0x0000000080007ffc, 0xffffffffffff7f83,
  0x0000000080007ffc, 0xffffffffffffff01,
  0x0000000080007ffc, 0xffffffffffffff03,
  0x0000000080007ffc, 0xffffffffffffff05,
  0x0000000080007ffc, 0xffffffffffffff43,
  0x0000000080007ffc, 0xffffffffffffffbd,
  0x0000000080007ffc, 0xfffffffffffffffb,
  0x0000000080007ffc, 0xfffffffffffffffd,
  0x00000000fffffffb, 0xffffffffffffffff,
  0x00000000fffffffb, 0x0000000000000001,
  0x00000000fffffffb, 0x0000000000000003,
  0x00000000fffffffb, 0x0000000000000042,
  0x00000000fffffffb, 0x00000000000000bd,
  0x00000000fffffffb, 0x00000000000000fb,
  0x00000000fffffffb, 0x00000000000000fd,
  0x00000000fffffffb, 0x000000000000807c,
  0x00000000fffffffb, 0x000000000000fffb,
  0x00000000fffffffb, 0x000000000000fffd,
  0x00000000fffffffb, 0x0000000080007ffc,
  0x00000000fffffffb, 0x00000000fffffffb,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffb, 0x33333333b3333332,
  0x00000000fffffffb, 0x8888888888888888,
  0x00000000fffffffb, 0xd555555555555552,
  0x00000000fffffffb, 0xfffffffffffffffb,
  0x00000000fffffffb, 0xfffffffffffffffd,
  0x00000000fffffffb, 0xffffffffffffffff,
  0x00000000fffffffb, 0x0000000000000001,
  0x00000000fffffffb, 0x0000000000000003,
  0x00000000fffffffb, 0x0000000000000005,
  0x00000000fffffffb, 0x2aaaaaaaaaaaaaad,
  0x00000000fffffffb, 0x7777777777777776,
  0x00000000fffffffb, 0xcccccccc4ccccccc,
  0x00000000fffffffb, 0xffffffff00000001,
  0x00000000fffffffb, 0xffffffff00000003,
  0x00000000fffffffb, 0xffffffff00000005,
  0x00000000fffffffb, 0xffffffff7fff8003,
  0x00000000fffffffb, 0xffffffffffff0001,
  0x00000000fffffffb, 0xffffffffffff0003,
  0x00000000fffffffb, 0xffffffffffff0005,
  0x00000000fffffffb, 0xffffffffffff7f83,
  0x00000000fffffffb, 0xffffffffffffff01,
  0x00000000fffffffb, 0xffffffffffffff03,
  0x00000000fffffffb, 0xffffffffffffff05,
  0x00000000fffffffb, 0xffffffffffffff43,
  0x00000000fffffffb, 0xffffffffffffffbd,
  0x00000000fffffffb, 0xfffffffffffffffb,
  0x00000000fffffffb, 0xfffffffffffffffd,
  0x00000000fffffffd, 0xffffffffffffffff,
  0x00000000fffffffd, 0x0000000000000001,
  0x00000000fffffffd, 0x0000000000000003,
  0x00000000fffffffd, 0x0000000000000042,
  0x00000000fffffffd, 0x00000000000000bd,
  0x00000000fffffffd, 0x00000000000000fb,
  0x00000000fffffffd, 0x00000000000000fd,
  0x00000000fffffffd, 0x000000000000807c,
  0x00000000fffffffd, 0x000000000000fffb,
  0x00000000fffffffd, 0x000000000000fffd,
  0x00000000fffffffd, 0x0000000080007ffc,
  0x00000000fffffffd, 0x00000000fffffffb,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffd, 0x33333333b3333332,
  0x00000000fffffffd, 0x8888888888888888,
  0x00000000fffffffd, 0xd555555555555552,
  0x00000000fffffffd, 0xfffffffffffffffb,
  0x00000000fffffffd, 0xfffffffffffffffd,
  0x00000000fffffffd, 0xffffffffffffffff,
  0x00000000fffffffd, 0x0000000000000001,
  0x00000000fffffffd, 0x0000000000000003,
  0x00000000fffffffd, 0x0000000000000005,
  0x00000000fffffffd, 0x2aaaaaaaaaaaaaad,
  0x00000000fffffffd, 0x7777777777777776,
  0x00000000fffffffd, 0xcccccccc4ccccccc,
  0x00000000fffffffd, 0xffffffff00000001,
  0x00000000fffffffd, 0xffffffff00000003,
  0x00000000fffffffd, 0xffffffff00000005,
  0x00000000fffffffd, 0xffffffff7fff8003,
  0x00000000fffffffd, 0xffffffffffff0001,
  0x00000000fffffffd, 0xffffffffffff0003,
  0x00000000fffffffd, 0xffffffffffff0005,
  0x00000000fffffffd, 0xffffffffffff7f83,
  0x00000000fffffffd, 0xffffffffffffff01,
  0x00000000fffffffd, 0xffffffffffffff03,
  0x00000000fffffffd, 0xffffffffffffff05,
  0x00000000fffffffd, 0xffffffffffffff43,
  0x00000000fffffffd, 0xffffffffffffffbd,
  0x00000000fffffffd, 0xfffffffffffffffb,
  0x00000000fffffffd, 0xfffffffffffffffd,
  0x33333333b3333332, 0xffffffffffffffff,
  0x33333333b3333332, 0x0000000000000001,
  0x33333333b3333332, 0x0000000000000003,
  0x33333333b3333332, 0x0000000000000042,
  0x33333333b3333332, 0x00000000000000bd,
  0x33333333b3333332, 0x00000000000000fb,
  0x33333333b3333332, 0x00000000000000fd,
  0x33333333b3333332, 0x000000000000807c,
  0x33333333b3333332, 0x000000000000fffb,
  0x33333333b3333332, 0x000000000000fffd,
  0x33333333b3333332, 0x0000000080007ffc,
  0x33333333b3333332, 0x00000000fffffffb,
  0x33333333b3333332, 0x00000000fffffffd,
  0x33333333b3333332, 0x33333333b3333332,
  0x33333333b3333332, 0x8888888888888888,
  0x33333333b3333332, 0xd555555555555552,
  0x33333333b3333332, 0xfffffffffffffffb,
  0x33333333b3333332, 0xfffffffffffffffd,
  0x33333333b3333332, 0xffffffffffffffff,
  0x33333333b3333332, 0x0000000000000001,
  0x33333333b3333332, 0x0000000000000003,
  0x33333333b3333332, 0x0000000000000005,
  0x33333333b3333332, 0x2aaaaaaaaaaaaaad,
  0x33333333b3333332, 0x7777777777777776,
  0x33333333b3333332, 0xcccccccc4ccccccc,
  0x33333333b3333332, 0xffffffff00000001,
  0x33333333b3333332, 0xffffffff00000003,
  0x33333333b3333332, 0xffffffff00000005,
  0x33333333b3333332, 0xffffffff7fff8003,
  0x33333333b3333332, 0xffffffffffff0001,
  0x33333333b3333332, 0xffffffffffff0003,
  0x33333333b3333332, 0xffffffffffff0005,
  0x33333333b3333332, 0xffffffffffff7f83,
  0x33333333b3333332, 0xffffffffffffff01,
  0x33333333b3333332, 0xffffffffffffff03,
  0x33333333b3333332, 0xffffffffffffff05,
  0x33333333b3333332, 0xffffffffffffff43,
  0x33333333b3333332, 0xffffffffffffffbd,
  0x33333333b3333332, 0xfffffffffffffffb,
  0x33333333b3333332, 0xfffffffffffffffd,
  0x8888888888888888, 0xffffffffffffffff,
  0x8888888888888888, 0x0000000000000001,
  0x8888888888888888, 0x0000000000000003,
  0x8888888888888888, 0x0000000000000042,
  0x8888888888888888, 0x00000000000000bd,
  0x8888888888888888, 0x00000000000000fb,
  0x8888888888888888, 0x00000000000000fd,
  0x8888888888888888, 0x000000000000807c,
  0x8888888888888888, 0x000000000000fffb,
  0x8888888888888888, 0x000000000000fffd,
  0x8888888888888888, 0x0000000080007ffc,
  0x8888888888888888, 0x00000000fffffffb,
  0x8888888888888888, 0x00000000fffffffd,
  0x8888888888888888, 0x33333333b3333332,
  0x8888888888888888, 0x8888888888888888,
  0x8888888888888888, 0xd555555555555552,
  0x8888888888888888, 0xfffffffffffffffb,
  0x8888888888888888, 0xfffffffffffffffd,
  0x8888888888888888, 0xffffffffffffffff,
  0x8888888888888888, 0x0000000000000001,
  0x8888888888888888, 0x0000000000000003,
  0x8888888888888888, 0x0000000000000005,
  0x8888888888888888, 0x2aaaaaaaaaaaaaad,
  0x8888888888888888, 0x7777777777777776,
  0x8888888888888888, 0xcccccccc4ccccccc,
  0x8888888888888888, 0xffffffff00000001,
  0x8888888888888888, 0xffffffff00000003,
  0x8888888888888888, 0xffffffff00000005,
  0x8888888888888888, 0xffffffff7fff8003,
  0x8888888888888888, 0xffffffffffff0001,
  0x8888888888888888, 0xffffffffffff0003,
  0x8888888888888888, 0xffffffffffff0005,
  0x8888888888888888, 0xffffffffffff7f83,
  0x8888888888888888, 0xffffffffffffff01,
  0x8888888888888888, 0xffffffffffffff03,
  0x8888888888888888, 0xffffffffffffff05,
  0x8888888888888888, 0xffffffffffffff43,
  0x8888888888888888, 0xffffffffffffffbd,
  0x8888888888888888, 0xfffffffffffffffb,
  0x8888888888888888, 0xfffffffffffffffd,
  0xd555555555555552, 0xffffffffffffffff,
  0xd555555555555552, 0x0000000000000001,
  0xd555555555555552, 0x0000000000000003,
  0xd555555555555552, 0x0000000000000042,
  0xd555555555555552, 0x00000000000000bd,
  0xd555555555555552, 0x00000000000000fb,
  0xd555555555555552, 0x00000000000000fd,
  0xd555555555555552, 0x000000000000807c,
  0xd555555555555552, 0x000000000000fffb,
  0xd555555555555552, 0x000000000000fffd,
  0xd555555555555552, 0x0000000080007ffc,
  0xd555555555555552, 0x00000000fffffffb,
  0xd555555555555552, 0x00000000fffffffd,
  0xd555555555555552, 0x33333333b3333332,
  0xd555555555555552, 0x8888888888888888,
  0xd555555555555552, 0xd555555555555552,
  0xd555555555555552, 0xfffffffffffffffb,
  0xd555555555555552, 0xfffffffffffffffd,
  0xd555555555555552, 0xffffffffffffffff,
  0xd555555555555552, 0x0000000000000001,
  0xd555555555555552, 0x0000000000000003,
  0xd555555555555552, 0x0000000000000005,
  0xd555555555555552, 0x2aaaaaaaaaaaaaad,
  0xd555555555555552, 0x7777777777777776,
  0xd555555555555552, 0xcccccccc4ccccccc,
  0xd555555555555552, 0xffffffff00000001,
  0xd555555555555552, 0xffffffff00000003,
  0xd555555555555552, 0xffffffff00000005,
  0xd555555555555552, 0xffffffff7fff8003,
  0xd555555555555552, 0xffffffffffff0001,
  0xd555555555555552, 0xffffffffffff0003,
  0xd555555555555552, 0xffffffffffff0005,
  0xd555555555555552, 0xffffffffffff7f83,
  0xd555555555555552, 0xffffffffffffff01,
  0xd555555555555552, 0xffffffffffffff03,
  0xd555555555555552, 0xffffffffffffff05,
  0xd555555555555552, 0xffffffffffffff43,
  0xd555555555555552, 0xffffffffffffffbd,
  0xd555555555555552, 0xfffffffffffffffb,
  0xd555555555555552, 0xfffffffffffffffd,
  0xfffffffffffffffb, 0xffffffffffffffff,
  0xfffffffffffffffb, 0x0000000000000001,
  0xfffffffffffffffb, 0x0000000000000003,
  0xfffffffffffffffb, 0x0000000000000042,
  0xfffffffffffffffb, 0x00000000000000bd,
  0xfffffffffffffffb, 0x00000000000000fb,
  0xfffffffffffffffb, 0x00000000000000fd,
  0xfffffffffffffffb, 0x000000000000807c,
  0xfffffffffffffffb, 0x000000000000fffb,
  0xfffffffffffffffb, 0x000000000000fffd,
  0xfffffffffffffffb, 0x0000000080007ffc,
  0xfffffffffffffffb, 0x00000000fffffffb,
  0xfffffffffffffffb, 0x00000000fffffffd,
  0xfffffffffffffffb, 0x33333333b3333332,
  0xfffffffffffffffb, 0x8888888888888888,
  0xfffffffffffffffb, 0xd555555555555552,
  0xfffffffffffffffb, 0xfffffffffffffffb,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffb, 0xffffffffffffffff,
  0xfffffffffffffffb, 0x0000000000000001,
  0xfffffffffffffffb, 0x0000000000000003,
  0xfffffffffffffffb, 0x0000000000000005,
  0xfffffffffffffffb, 0x2aaaaaaaaaaaaaad,
  0xfffffffffffffffb, 0x7777777777777776,
  0xfffffffffffffffb, 0xcccccccc4ccccccc,
  0xfffffffffffffffb, 0xffffffff00000001,
  0xfffffffffffffffb, 0xffffffff00000003,
  0xfffffffffffffffb, 0xffffffff00000005,
  0xfffffffffffffffb, 0xffffffff7fff8003,
  0xfffffffffffffffb, 0xffffffffffff0001,
  0xfffffffffffffffb, 0xffffffffffff0003,
  0xfffffffffffffffb, 0xffffffffffff0005,
  0xfffffffffffffffb, 0xffffffffffff7f83,
  0xfffffffffffffffb, 0xffffffffffffff01,
  0xfffffffffffffffb, 0xffffffffffffff03,
  0xfffffffffffffffb, 0xffffffffffffff05,
  0xfffffffffffffffb, 0xffffffffffffff43,
  0xfffffffffffffffb, 0xffffffffffffffbd,
  0xfffffffffffffffb, 0xfffffffffffffffb,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffd, 0x0000000000000001,
  0xfffffffffffffffd, 0x0000000000000003,
  0xfffffffffffffffd, 0x0000000000000042,
  0xfffffffffffffffd, 0x00000000000000bd,
  0xfffffffffffffffd, 0x00000000000000fb,
  0xfffffffffffffffd, 0x00000000000000fd,
  0xfffffffffffffffd, 0x000000000000807c,
  0xfffffffffffffffd, 0x000000000000fffb,
  0xfffffffffffffffd, 0x000000000000fffd,
  0xfffffffffffffffd, 0x0000000080007ffc,
  0xfffffffffffffffd, 0x00000000fffffffb,
  0xfffffffffffffffd, 0x00000000fffffffd,
  0xfffffffffffffffd, 0x33333333b3333332,
  0xfffffffffffffffd, 0x8888888888888888,
  0xfffffffffffffffd, 0xd555555555555552,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffd, 0x0000000000000001,
  0xfffffffffffffffd, 0x0000000000000003,
  0xfffffffffffffffd, 0x0000000000000005,
  0xfffffffffffffffd, 0x2aaaaaaaaaaaaaad,
  0xfffffffffffffffd, 0x7777777777777776,
  0xfffffffffffffffd, 0xcccccccc4ccccccc,
  0xfffffffffffffffd, 0xffffffff00000001,
  0xfffffffffffffffd, 0xffffffff00000003,
  0xfffffffffffffffd, 0xffffffff00000005,
  0xfffffffffffffffd, 0xffffffff7fff8003,
  0xfffffffffffffffd, 0xffffffffffff0001,
  0xfffffffffffffffd, 0xffffffffffff0003,
  0xfffffffffffffffd, 0xffffffffffff0005,
  0xfffffffffffffffd, 0xffffffffffff7f83,
  0xfffffffffffffffd, 0xffffffffffffff01,
  0xfffffffffffffffd, 0xffffffffffffff03,
  0xfffffffffffffffd, 0xffffffffffffff05,
  0xfffffffffffffffd, 0xffffffffffffff43,
  0xfffffffffffffffd, 0xffffffffffffffbd,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0x0000000000000001,
  0xffffffffffffffff, 0x0000000000000003,
  0xffffffffffffffff, 0x0000000000000042,
  0xffffffffffffffff, 0x00000000000000bd,
  0xffffffffffffffff, 0x00000000000000fb,
  0xffffffffffffffff, 0x00000000000000fd,
  0xffffffffffffffff, 0x000000000000807c,
  0xffffffffffffffff, 0x000000000000fffb,
  0xffffffffffffffff, 0x000000000000fffd,
  0xffffffffffffffff, 0x0000000080007ffc,
  0xffffffffffffffff, 0x00000000fffffffb,
  0xffffffffffffffff, 0x00000000fffffffd,
  0xffffffffffffffff, 0x33333333b3333332,
  0xffffffffffffffff, 0x8888888888888888,
  0xffffffffffffffff, 0xd555555555555552,
  0xffffffffffffffff, 0xfffffffffffffffb,
  0xffffffffffffffff, 0xfffffffffffffffd,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0x0000000000000001,
  0xffffffffffffffff, 0x0000000000000003,
  0xffffffffffffffff, 0x0000000000000005,
  0xffffffffffffffff, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffffff, 0x7777777777777776,
  0xffffffffffffffff, 0xcccccccc4ccccccc,
  0xffffffffffffffff, 0xffffffff00000001,
  0xffffffffffffffff, 0xffffffff00000003,
  0xffffffffffffffff, 0xffffffff00000005,
  0xffffffffffffffff, 0xffffffff7fff8003,
  0xffffffffffffffff, 0xffffffffffff0001,
  0xffffffffffffffff, 0xffffffffffff0003,
  0xffffffffffffffff, 0xffffffffffff0005,
  0xffffffffffffffff, 0xffffffffffff7f83,
  0xffffffffffffffff, 0xffffffffffffff01,
  0xffffffffffffffff, 0xffffffffffffff03,
  0xffffffffffffffff, 0xffffffffffffff05,
  0xffffffffffffffff, 0xffffffffffffff43,
  0xffffffffffffffff, 0xffffffffffffffbd,
  0xffffffffffffffff, 0xfffffffffffffffb,
  0xffffffffffffffff, 0xfffffffffffffffd,
  0x0000000000000001, 0xffffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000042,
  0x0000000000000001, 0x00000000000000bd,
  0x0000000000000001, 0x00000000000000fb,
  0x0000000000000001, 0x00000000000000fd,
  0x0000000000000001, 0x000000000000807c,
  0x0000000000000001, 0x000000000000fffb,
  0x0000000000000001, 0x000000000000fffd,
  0x0000000000000001, 0x0000000080007ffc,
  0x0000000000000001, 0x00000000fffffffb,
  0x0000000000000001, 0x00000000fffffffd,
  0x0000000000000001, 0x33333333b3333332,
  0x0000000000000001, 0x8888888888888888,
  0x0000000000000001, 0xd555555555555552,
  0x0000000000000001, 0xfffffffffffffffb,
  0x0000000000000001, 0xfffffffffffffffd,
  0x0000000000000001, 0xffffffffffffffff,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000001, 0x0000000000000005,
  0x0000000000000001, 0x2aaaaaaaaaaaaaad,
  0x0000000000000001, 0x7777777777777776,
  0x0000000000000001, 0xcccccccc4ccccccc,
  0x0000000000000001, 0xffffffff00000001,
  0x0000000000000001, 0xffffffff00000003,
  0x0000000000000001, 0xffffffff00000005,
  0x0000000000000001, 0xffffffff7fff8003,
  0x0000000000000001, 0xffffffffffff0001,
  0x0000000000000001, 0xffffffffffff0003,
  0x0000000000000001, 0xffffffffffff0005,
  0x0000000000000001, 0xffffffffffff7f83,
  0x0000000000000001, 0xffffffffffffff01,
  0x0000000000000001, 0xffffffffffffff03,
  0x0000000000000001, 0xffffffffffffff05,
  0x0000000000000001, 0xffffffffffffff43,
  0x0000000000000001, 0xffffffffffffffbd,
  0x0000000000000001, 0xfffffffffffffffb,
  0x0000000000000001, 0xfffffffffffffffd,
  0x0000000000000003, 0xffffffffffffffff,
  0x0000000000000003, 0x0000000000000001,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000042,
  0x0000000000000003, 0x00000000000000bd,
  0x0000000000000003, 0x00000000000000fb,
  0x0000000000000003, 0x00000000000000fd,
  0x0000000000000003, 0x000000000000807c,
  0x0000000000000003, 0x000000000000fffb,
  0x0000000000000003, 0x000000000000fffd,
  0x0000000000000003, 0x0000000080007ffc,
  0x0000000000000003, 0x00000000fffffffb,
  0x0000000000000003, 0x00000000fffffffd,
  0x0000000000000003, 0x33333333b3333332,
  0x0000000000000003, 0x8888888888888888,
  0x0000000000000003, 0xd555555555555552,
  0x0000000000000003, 0xfffffffffffffffb,
  0x0000000000000003, 0xfffffffffffffffd,
  0x0000000000000003, 0xffffffffffffffff,
  0x0000000000000003, 0x0000000000000001,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000005,
  0x0000000000000003, 0x2aaaaaaaaaaaaaad,
  0x0000000000000003, 0x7777777777777776,
  0x0000000000000003, 0xcccccccc4ccccccc,
  0x0000000000000003, 0xffffffff00000001,
  0x0000000000000003, 0xffffffff00000003,
  0x0000000000000003, 0xffffffff00000005,
  0x0000000000000003, 0xffffffff7fff8003,
  0x0000000000000003, 0xffffffffffff0001,
  0x0000000000000003, 0xffffffffffff0003,
  0x0000000000000003, 0xffffffffffff0005,
  0x0000000000000003, 0xffffffffffff7f83,
  0x0000000000000003, 0xffffffffffffff01,
  0x0000000000000003, 0xffffffffffffff03,
  0x0000000000000003, 0xffffffffffffff05,
  0x0000000000000003, 0xffffffffffffff43,
  0x0000000000000003, 0xffffffffffffffbd,
  0x0000000000000003, 0xfffffffffffffffb,
  0x0000000000000003, 0xfffffffffffffffd,
  0x0000000000000005, 0xffffffffffffffff,
  0x0000000000000005, 0x0000000000000001,
  0x0000000000000005, 0x0000000000000003,
  0x0000000000000005, 0x0000000000000042,
  0x0000000000000005, 0x00000000000000bd,
  0x0000000000000005, 0x00000000000000fb,
  0x0000000000000005, 0x00000000000000fd,
  0x0000000000000005, 0x000000000000807c,
  0x0000000000000005, 0x000000000000fffb,
  0x0000000000000005, 0x000000000000fffd,
  0x0000000000000005, 0x0000000080007ffc,
  0x0000000000000005, 0x00000000fffffffb,
  0x0000000000000005, 0x00000000fffffffd,
  0x0000000000000005, 0x33333333b3333332,
  0x0000000000000005, 0x8888888888888888,
  0x0000000000000005, 0xd555555555555552,
  0x0000000000000005, 0xfffffffffffffffb,
  0x0000000000000005, 0xfffffffffffffffd,
  0x0000000000000005, 0xffffffffffffffff,
  0x0000000000000005, 0x0000000000000001,
  0x0000000000000005, 0x0000000000000003,
  0x0000000000000005, 0x0000000000000005,
  0x0000000000000005, 0x2aaaaaaaaaaaaaad,
  0x0000000000000005, 0x7777777777777776,
  0x0000000000000005, 0xcccccccc4ccccccc,
  0x0000000000000005, 0xffffffff00000001,
  0x0000000000000005, 0xffffffff00000003,
  0x0000000000000005, 0xffffffff00000005,
  0x0000000000000005, 0xffffffff7fff8003,
  0x0000000000000005, 0xffffffffffff0001,
  0x0000000000000005, 0xffffffffffff0003,
  0x0000000000000005, 0xffffffffffff0005,
  0x0000000000000005, 0xffffffffffff7f83,
  0x0000000000000005, 0xffffffffffffff01,
  0x0000000000000005, 0xffffffffffffff03,
  0x0000000000000005, 0xffffffffffffff05,
  0x0000000000000005, 0xffffffffffffff43,
  0x0000000000000005, 0xffffffffffffffbd,
  0x0000000000000005, 0xfffffffffffffffb,
  0x0000000000000005, 0xfffffffffffffffd,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffffff,
  0x2aaaaaaaaaaaaaad, 0x0000000000000001,
  0x2aaaaaaaaaaaaaad, 0x0000000000000003,
  0x2aaaaaaaaaaaaaad, 0x0000000000000042,
  0x2aaaaaaaaaaaaaad, 0x00000000000000bd,
  0x2aaaaaaaaaaaaaad, 0x00000000000000fb,
  0x2aaaaaaaaaaaaaad, 0x00000000000000fd,
  0x2aaaaaaaaaaaaaad, 0x000000000000807c,
  0x2aaaaaaaaaaaaaad, 0x000000000000fffb,
  0x2aaaaaaaaaaaaaad, 0x000000000000fffd,
  0x2aaaaaaaaaaaaaad, 0x0000000080007ffc,
  0x2aaaaaaaaaaaaaad, 0x00000000fffffffb,
  0x2aaaaaaaaaaaaaad, 0x00000000fffffffd,
  0x2aaaaaaaaaaaaaad, 0x33333333b3333332,
  0x2aaaaaaaaaaaaaad, 0x8888888888888888,
  0x2aaaaaaaaaaaaaad, 0xd555555555555552,
  0x2aaaaaaaaaaaaaad, 0xfffffffffffffffb,
  0x2aaaaaaaaaaaaaad, 0xfffffffffffffffd,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffffff,
  0x2aaaaaaaaaaaaaad, 0x0000000000000001,
  0x2aaaaaaaaaaaaaad, 0x0000000000000003,
  0x2aaaaaaaaaaaaaad, 0x0000000000000005,
  0x2aaaaaaaaaaaaaad, 0x2aaaaaaaaaaaaaad,
  0x2aaaaaaaaaaaaaad, 0x7777777777777776,
  0x2aaaaaaaaaaaaaad, 0xcccccccc4ccccccc,
  0x2aaaaaaaaaaaaaad, 0xffffffff00000001,
  0x2aaaaaaaaaaaaaad, 0xffffffff00000003,
  0x2aaaaaaaaaaaaaad, 0xffffffff00000005,
  0x2aaaaaaaaaaaaaad, 0xffffffff7fff8003,
  0x2aaaaaaaaaaaaaad, 0xffffffffffff0001,
  0x2aaaaaaaaaaaaaad, 0xffffffffffff0003,
  0x2aaaaaaaaaaaaaad, 0xffffffffffff0005,
  0x2aaaaaaaaaaaaaad, 0xffffffffffff7f83,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffff01,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffff03,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffff05,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffff43,
  0x2aaaaaaaaaaaaaad, 0xffffffffffffffbd,
  0x2aaaaaaaaaaaaaad, 0xfffffffffffffffb,
  0x2aaaaaaaaaaaaaad, 0xfffffffffffffffd,
  0x7777777777777776, 0xffffffffffffffff,
  0x7777777777777776, 0x0000000000000001,
  0x7777777777777776, 0x0000000000000003,
  0x7777777777777776, 0x0000000000000042,
  0x7777777777777776, 0x00000000000000bd,
  0x7777777777777776, 0x00000000000000fb,
  0x7777777777777776, 0x00000000000000fd,
  0x7777777777777776, 0x000000000000807c,
  0x7777777777777776, 0x000000000000fffb,
  0x7777777777777776, 0x000000000000fffd,
  0x7777777777777776, 0x0000000080007ffc,
  0x7777777777777776, 0x00000000fffffffb,
  0x7777777777777776, 0x00000000fffffffd,
  0x7777777777777776, 0x33333333b3333332,
  0x7777777777777776, 0x8888888888888888,
  0x7777777777777776, 0xd555555555555552,
  0x7777777777777776, 0xfffffffffffffffb,
  0x7777777777777776, 0xfffffffffffffffd,
  0x7777777777777776, 0xffffffffffffffff,
  0x7777777777777776, 0x0000000000000001,
  0x7777777777777776, 0x0000000000000003,
  0x7777777777777776, 0x0000000000000005,
  0x7777777777777776, 0x2aaaaaaaaaaaaaad,
  0x7777777777777776, 0x7777777777777776,
  0x7777777777777776, 0xcccccccc4ccccccc,
  0x7777777777777776, 0xffffffff00000001,
  0x7777777777777776, 0xffffffff00000003,
  0x7777777777777776, 0xffffffff00000005,
  0x7777777777777776, 0xffffffff7fff8003,
  0x7777777777777776, 0xffffffffffff0001,
  0x7777777777777776, 0xffffffffffff0003,
  0x7777777777777776, 0xffffffffffff0005,
  0x7777777777777776, 0xffffffffffff7f83,
  0x7777777777777776, 0xffffffffffffff01,
  0x7777777777777776, 0xffffffffffffff03,
  0x7777777777777776, 0xffffffffffffff05,
  0x7777777777777776, 0xffffffffffffff43,
  0x7777777777777776, 0xffffffffffffffbd,
  0x7777777777777776, 0xfffffffffffffffb,
  0x7777777777777776, 0xfffffffffffffffd,
  0xcccccccc4ccccccc, 0xffffffffffffffff,
  0xcccccccc4ccccccc, 0x0000000000000001,
  0xcccccccc4ccccccc, 0x0000000000000003,
  0xcccccccc4ccccccc, 0x0000000000000042,
  0xcccccccc4ccccccc, 0x00000000000000bd,
  0xcccccccc4ccccccc, 0x00000000000000fb,
  0xcccccccc4ccccccc, 0x00000000000000fd,
  0xcccccccc4ccccccc, 0x000000000000807c,
  0xcccccccc4ccccccc, 0x000000000000fffb,
  0xcccccccc4ccccccc, 0x000000000000fffd,
  0xcccccccc4ccccccc, 0x0000000080007ffc,
  0xcccccccc4ccccccc, 0x00000000fffffffb,
  0xcccccccc4ccccccc, 0x00000000fffffffd,
  0xcccccccc4ccccccc, 0x33333333b3333332,
  0xcccccccc4ccccccc, 0x8888888888888888,
  0xcccccccc4ccccccc, 0xd555555555555552,
  0xcccccccc4ccccccc, 0xfffffffffffffffb,
  0xcccccccc4ccccccc, 0xfffffffffffffffd,
  0xcccccccc4ccccccc, 0xffffffffffffffff,
  0xcccccccc4ccccccc, 0x0000000000000001,
  0xcccccccc4ccccccc, 0x0000000000000003,
  0xcccccccc4ccccccc, 0x0000000000000005,
  0xcccccccc4ccccccc, 0x2aaaaaaaaaaaaaad,
  0xcccccccc4ccccccc, 0x7777777777777776,
  0xcccccccc4ccccccc, 0xcccccccc4ccccccc,
  0xcccccccc4ccccccc, 0xffffffff00000001,
  0xcccccccc4ccccccc, 0xffffffff00000003,
  0xcccccccc4ccccccc, 0xffffffff00000005,
  0xcccccccc4ccccccc, 0xffffffff7fff8003,
  0xcccccccc4ccccccc, 0xffffffffffff0001,
  0xcccccccc4ccccccc, 0xffffffffffff0003,
  0xcccccccc4ccccccc, 0xffffffffffff0005,
  0xcccccccc4ccccccc, 0xffffffffffff7f83,
  0xcccccccc4ccccccc, 0xffffffffffffff01,
  0xcccccccc4ccccccc, 0xffffffffffffff03,
  0xcccccccc4ccccccc, 0xffffffffffffff05,
  0xcccccccc4ccccccc, 0xffffffffffffff43,
  0xcccccccc4ccccccc, 0xffffffffffffffbd,
  0xcccccccc4ccccccc, 0xfffffffffffffffb,
  0xcccccccc4ccccccc, 0xfffffffffffffffd,
  0xffffffff00000001, 0xffffffffffffffff,
  0xffffffff00000001, 0x0000000000000001,
  0xffffffff00000001, 0x0000000000000003,
  0xffffffff00000001, 0x0000000000000042,
  0xffffffff00000001, 0x00000000000000bd,
  0xffffffff00000001, 0x00000000000000fb,
  0xffffffff00000001, 0x00000000000000fd,
  0xffffffff00000001, 0x000000000000807c,
  0xffffffff00000001, 0x000000000000fffb,
  0xffffffff00000001, 0x000000000000fffd,
  0xffffffff00000001, 0x0000000080007ffc,
  0xffffffff00000001, 0x00000000fffffffb,
  0xffffffff00000001, 0x00000000fffffffd,
  0xffffffff00000001, 0x33333333b3333332,
  0xffffffff00000001, 0x8888888888888888,
  0xffffffff00000001, 0xd555555555555552,
  0xffffffff00000001, 0xfffffffffffffffb,
  0xffffffff00000001, 0xfffffffffffffffd,
  0xffffffff00000001, 0xffffffffffffffff,
  0xffffffff00000001, 0x0000000000000001,
  0xffffffff00000001, 0x0000000000000003,
  0xffffffff00000001, 0x0000000000000005,
  0xffffffff00000001, 0x2aaaaaaaaaaaaaad,
  0xffffffff00000001, 0x7777777777777776,
  0xffffffff00000001, 0xcccccccc4ccccccc,
  0xffffffff00000001, 0xffffffff00000001,
  0xffffffff00000001, 0xffffffff00000003,
  0xffffffff00000001, 0xffffffff00000005,
  0xffffffff00000001, 0xffffffff7fff8003,
  0xffffffff00000001, 0xffffffffffff0001,
  0xffffffff00000001, 0xffffffffffff0003,
  0xffffffff00000001, 0xffffffffffff0005,
  0xffffffff00000001, 0xffffffffffff7f83,
  0xffffffff00000001, 0xffffffffffffff01,
  0xffffffff00000001, 0xffffffffffffff03,
  0xffffffff00000001, 0xffffffffffffff05,
  0xffffffff00000001, 0xffffffffffffff43,
  0xffffffff00000001, 0xffffffffffffffbd,
  0xffffffff00000001, 0xfffffffffffffffb,
  0xffffffff00000001, 0xfffffffffffffffd,
  0xffffffff00000003, 0xffffffffffffffff,
  0xffffffff00000003, 0x0000000000000001,
  0xffffffff00000003, 0x0000000000000003,
  0xffffffff00000003, 0x0000000000000042,
  0xffffffff00000003, 0x00000000000000bd,
  0xffffffff00000003, 0x00000000000000fb,
  0xffffffff00000003, 0x00000000000000fd,
  0xffffffff00000003, 0x000000000000807c,
  0xffffffff00000003, 0x000000000000fffb,
  0xffffffff00000003, 0x000000000000fffd,
  0xffffffff00000003, 0x0000000080007ffc,
  0xffffffff00000003, 0x00000000fffffffb,
  0xffffffff00000003, 0x00000000fffffffd,
  0xffffffff00000003, 0x33333333b3333332,
  0xffffffff00000003, 0x8888888888888888,
  0xffffffff00000003, 0xd555555555555552,
  0xffffffff00000003, 0xfffffffffffffffb,
  0xffffffff00000003, 0xfffffffffffffffd,
  0xffffffff00000003, 0xffffffffffffffff,
  0xffffffff00000003, 0x0000000000000001,
  0xffffffff00000003, 0x0000000000000003,
  0xffffffff00000003, 0x0000000000000005,
  0xffffffff00000003, 0x2aaaaaaaaaaaaaad,
  0xffffffff00000003, 0x7777777777777776,
  0xffffffff00000003, 0xcccccccc4ccccccc,
  0xffffffff00000003, 0xffffffff00000001,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000003, 0xffffffff00000005,
  0xffffffff00000003, 0xffffffff7fff8003,
  0xffffffff00000003, 0xffffffffffff0001,
  0xffffffff00000003, 0xffffffffffff0003,
  0xffffffff00000003, 0xffffffffffff0005,
  0xffffffff00000003, 0xffffffffffff7f83,
  0xffffffff00000003, 0xffffffffffffff01,
  0xffffffff00000003, 0xffffffffffffff03,
  0xffffffff00000003, 0xffffffffffffff05,
  0xffffffff00000003, 0xffffffffffffff43,
  0xffffffff00000003, 0xffffffffffffffbd,
  0xffffffff00000003, 0xfffffffffffffffb,
  0xffffffff00000003, 0xfffffffffffffffd,
  0xffffffff00000005, 0xffffffffffffffff,
  0xffffffff00000005, 0x0000000000000001,
  0xffffffff00000005, 0x0000000000000003,
  0xffffffff00000005, 0x0000000000000042,
  0xffffffff00000005, 0x00000000000000bd,
  0xffffffff00000005, 0x00000000000000fb,
  0xffffffff00000005, 0x00000000000000fd,
  0xffffffff00000005, 0x000000000000807c,
  0xffffffff00000005, 0x000000000000fffb,
  0xffffffff00000005, 0x000000000000fffd,
  0xffffffff00000005, 0x0000000080007ffc,
  0xffffffff00000005, 0x00000000fffffffb,
  0xffffffff00000005, 0x00000000fffffffd,
  0xffffffff00000005, 0x33333333b3333332,
  0xffffffff00000005, 0x8888888888888888,
  0xffffffff00000005, 0xd555555555555552,
  0xffffffff00000005, 0xfffffffffffffffb,
  0xffffffff00000005, 0xfffffffffffffffd,
  0xffffffff00000005, 0xffffffffffffffff,
  0xffffffff00000005, 0x0000000000000001,
  0xffffffff00000005, 0x0000000000000003,
  0xffffffff00000005, 0x0000000000000005,
  0xffffffff00000005, 0x2aaaaaaaaaaaaaad,
  0xffffffff00000005, 0x7777777777777776,
  0xffffffff00000005, 0xcccccccc4ccccccc,
  0xffffffff00000005, 0xffffffff00000001,
  0xffffffff00000005, 0xffffffff00000003,
  0xffffffff00000005, 0xffffffff00000005,
  0xffffffff00000005, 0xffffffff7fff8003,
  0xffffffff00000005, 0xffffffffffff0001,
  0xffffffff00000005, 0xffffffffffff0003,
  0xffffffff00000005, 0xffffffffffff0005,
  0xffffffff00000005, 0xffffffffffff7f83,
  0xffffffff00000005, 0xffffffffffffff01,
  0xffffffff00000005, 0xffffffffffffff03,
  0xffffffff00000005, 0xffffffffffffff05,
  0xffffffff00000005, 0xffffffffffffff43,
  0xffffffff00000005, 0xffffffffffffffbd,
  0xffffffff00000005, 0xfffffffffffffffb,
  0xffffffff00000005, 0xfffffffffffffffd,
  0xffffffff7fff8003, 0xffffffffffffffff,
  0xffffffff7fff8003, 0x0000000000000001,
  0xffffffff7fff8003, 0x0000000000000003,
  0xffffffff7fff8003, 0x0000000000000042,
  0xffffffff7fff8003, 0x00000000000000bd,
  0xffffffff7fff8003, 0x00000000000000fb,
  0xffffffff7fff8003, 0x00000000000000fd,
  0xffffffff7fff8003, 0x000000000000807c,
  0xffffffff7fff8003, 0x000000000000fffb,
  0xffffffff7fff8003, 0x000000000000fffd,
  0xffffffff7fff8003, 0x0000000080007ffc,
  0xffffffff7fff8003, 0x00000000fffffffb,
  0xffffffff7fff8003, 0x00000000fffffffd,
  0xffffffff7fff8003, 0x33333333b3333332,
  0xffffffff7fff8003, 0x8888888888888888,
  0xffffffff7fff8003, 0xd555555555555552,
  0xffffffff7fff8003, 0xfffffffffffffffb,
  0xffffffff7fff8003, 0xfffffffffffffffd,
  0xffffffff7fff8003, 0xffffffffffffffff,
  0xffffffff7fff8003, 0x0000000000000001,
  0xffffffff7fff8003, 0x0000000000000003,
  0xffffffff7fff8003, 0x0000000000000005,
  0xffffffff7fff8003, 0x2aaaaaaaaaaaaaad,
  0xffffffff7fff8003, 0x7777777777777776,
  0xffffffff7fff8003, 0xcccccccc4ccccccc,
  0xffffffff7fff8003, 0xffffffff00000001,
  0xffffffff7fff8003, 0xffffffff00000003,
  0xffffffff7fff8003, 0xffffffff00000005,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8003, 0xffffffffffff0001,
  0xffffffff7fff8003, 0xffffffffffff0003,
  0xffffffff7fff8003, 0xffffffffffff0005,
  0xffffffff7fff8003, 0xffffffffffff7f83,
  0xffffffff7fff8003, 0xffffffffffffff01,
  0xffffffff7fff8003, 0xffffffffffffff03,
  0xffffffff7fff8003, 0xffffffffffffff05,
  0xffffffff7fff8003, 0xffffffffffffff43,
  0xffffffff7fff8003, 0xffffffffffffffbd,
  0xffffffff7fff8003, 0xfffffffffffffffb,
  0xffffffff7fff8003, 0xfffffffffffffffd,
  0xffffffffffff0001, 0xffffffffffffffff,
  0xffffffffffff0001, 0x0000000000000001,
  0xffffffffffff0001, 0x0000000000000003,
  0xffffffffffff0001, 0x0000000000000042,
  0xffffffffffff0001, 0x00000000000000bd,
  0xffffffffffff0001, 0x00000000000000fb,
  0xffffffffffff0001, 0x00000000000000fd,
  0xffffffffffff0001, 0x000000000000807c,
  0xffffffffffff0001, 0x000000000000fffb,
  0xffffffffffff0001, 0x000000000000fffd,
  0xffffffffffff0001, 0x0000000080007ffc,
  0xffffffffffff0001, 0x00000000fffffffb,
  0xffffffffffff0001, 0x00000000fffffffd,
  0xffffffffffff0001, 0x33333333b3333332,
  0xffffffffffff0001, 0x8888888888888888,
  0xffffffffffff0001, 0xd555555555555552,
  0xffffffffffff0001, 0xfffffffffffffffb,
  0xffffffffffff0001, 0xfffffffffffffffd,
  0xffffffffffff0001, 0xffffffffffffffff,
  0xffffffffffff0001, 0x0000000000000001,
  0xffffffffffff0001, 0x0000000000000003,
  0xffffffffffff0001, 0x0000000000000005,
  0xffffffffffff0001, 0x2aaaaaaaaaaaaaad,
  0xffffffffffff0001, 0x7777777777777776,
  0xffffffffffff0001, 0xcccccccc4ccccccc,
  0xffffffffffff0001, 0xffffffff00000001,
  0xffffffffffff0001, 0xffffffff00000003,
  0xffffffffffff0001, 0xffffffff00000005,
  0xffffffffffff0001, 0xffffffff7fff8003,
  0xffffffffffff0001, 0xffffffffffff0001,
  0xffffffffffff0001, 0xffffffffffff0003,
  0xffffffffffff0001, 0xffffffffffff0005,
  0xffffffffffff0001, 0xffffffffffff7f83,
  0xffffffffffff0001, 0xffffffffffffff01,
  0xffffffffffff0001, 0xffffffffffffff03,
  0xffffffffffff0001, 0xffffffffffffff05,
  0xffffffffffff0001, 0xffffffffffffff43,
  0xffffffffffff0001, 0xffffffffffffffbd,
  0xffffffffffff0001, 0xfffffffffffffffb,
  0xffffffffffff0001, 0xfffffffffffffffd,
  0xffffffffffff0003, 0xffffffffffffffff,
  0xffffffffffff0003, 0x0000000000000001,
  0xffffffffffff0003, 0x0000000000000003,
  0xffffffffffff0003, 0x0000000000000042,
  0xffffffffffff0003, 0x00000000000000bd,
  0xffffffffffff0003, 0x00000000000000fb,
  0xffffffffffff0003, 0x00000000000000fd,
  0xffffffffffff0003, 0x000000000000807c,
  0xffffffffffff0003, 0x000000000000fffb,
  0xffffffffffff0003, 0x000000000000fffd,
  0xffffffffffff0003, 0x0000000080007ffc,
  0xffffffffffff0003, 0x00000000fffffffb,
  0xffffffffffff0003, 0x00000000fffffffd,
  0xffffffffffff0003, 0x33333333b3333332,
  0xffffffffffff0003, 0x8888888888888888,
  0xffffffffffff0003, 0xd555555555555552,
  0xffffffffffff0003, 0xfffffffffffffffb,
  0xffffffffffff0003, 0xfffffffffffffffd,
  0xffffffffffff0003, 0xffffffffffffffff,
  0xffffffffffff0003, 0x0000000000000001,
  0xffffffffffff0003, 0x0000000000000003,
  0xffffffffffff0003, 0x0000000000000005,
  0xffffffffffff0003, 0x2aaaaaaaaaaaaaad,
  0xffffffffffff0003, 0x7777777777777776,
  0xffffffffffff0003, 0xcccccccc4ccccccc,
  0xffffffffffff0003, 0xffffffff00000001,
  0xffffffffffff0003, 0xffffffff00000003,
  0xffffffffffff0003, 0xffffffff00000005,
  0xffffffffffff0003, 0xffffffff7fff8003,
  0xffffffffffff0003, 0xffffffffffff0001,
  0xffffffffffff0003, 0xffffffffffff0003,
  0xffffffffffff0003, 0xffffffffffff0005,
  0xffffffffffff0003, 0xffffffffffff7f83,
  0xffffffffffff0003, 0xffffffffffffff01,
  0xffffffffffff0003, 0xffffffffffffff03,
  0xffffffffffff0003, 0xffffffffffffff05,
  0xffffffffffff0003, 0xffffffffffffff43,
  0xffffffffffff0003, 0xffffffffffffffbd,
  0xffffffffffff0003, 0xfffffffffffffffb,
  0xffffffffffff0003, 0xfffffffffffffffd,
  0xffffffffffff0005, 0xffffffffffffffff,
  0xffffffffffff0005, 0x0000000000000001,
  0xffffffffffff0005, 0x0000000000000003,
  0xffffffffffff0005, 0x0000000000000042,
  0xffffffffffff0005, 0x00000000000000bd,
  0xffffffffffff0005, 0x00000000000000fb,
  0xffffffffffff0005, 0x00000000000000fd,
  0xffffffffffff0005, 0x000000000000807c,
  0xffffffffffff0005, 0x000000000000fffb,
  0xffffffffffff0005, 0x000000000000fffd,
  0xffffffffffff0005, 0x0000000080007ffc,
  0xffffffffffff0005, 0x00000000fffffffb,
  0xffffffffffff0005, 0x00000000fffffffd,
  0xffffffffffff0005, 0x33333333b3333332,
  0xffffffffffff0005, 0x8888888888888888,
  0xffffffffffff0005, 0xd555555555555552,
  0xffffffffffff0005, 0xfffffffffffffffb,
  0xffffffffffff0005, 0xfffffffffffffffd,
  0xffffffffffff0005, 0xffffffffffffffff,
  0xffffffffffff0005, 0x0000000000000001,
  0xffffffffffff0005, 0x0000000000000003,
  0xffffffffffff0005, 0x0000000000000005,
  0xffffffffffff0005, 0x2aaaaaaaaaaaaaad,
  0xffffffffffff0005, 0x7777777777777776,
  0xffffffffffff0005, 0xcccccccc4ccccccc,
  0xffffffffffff0005, 0xffffffff00000001,
  0xffffffffffff0005, 0xffffffff00000003,
  0xffffffffffff0005, 0xffffffff00000005,
  0xffffffffffff0005, 0xffffffff7fff8003,
  0xffffffffffff0005, 0xffffffffffff0001,
  0xffffffffffff0005, 0xffffffffffff0003,
  0xffffffffffff0005, 0xffffffffffff0005,
  0xffffffffffff0005, 0xffffffffffff7f83,
  0xffffffffffff0005, 0xffffffffffffff01,
  0xffffffffffff0005, 0xffffffffffffff03,
  0xffffffffffff0005, 0xffffffffffffff05,
  0xffffffffffff0005, 0xffffffffffffff43,
  0xffffffffffff0005, 0xffffffffffffffbd,
  0xffffffffffff0005, 0xfffffffffffffffb,
  0xffffffffffff0005, 0xfffffffffffffffd,
  0xffffffffffff7f83, 0xffffffffffffffff,
  0xffffffffffff7f83, 0x0000000000000001,
  0xffffffffffff7f83, 0x0000000000000003,
  0xffffffffffff7f83, 0x0000000000000042,
  0xffffffffffff7f83, 0x00000000000000bd,
  0xffffffffffff7f83, 0x00000000000000fb,
  0xffffffffffff7f83, 0x00000000000000fd,
  0xffffffffffff7f83, 0x000000000000807c,
  0xffffffffffff7f83, 0x000000000000fffb,
  0xffffffffffff7f83, 0x000000000000fffd,
  0xffffffffffff7f83, 0x0000000080007ffc,
  0xffffffffffff7f83, 0x00000000fffffffb,
  0xffffffffffff7f83, 0x00000000fffffffd,
  0xffffffffffff7f83, 0x33333333b3333332,
  0xffffffffffff7f83, 0x8888888888888888,
  0xffffffffffff7f83, 0xd555555555555552,
  0xffffffffffff7f83, 0xfffffffffffffffb,
  0xffffffffffff7f83, 0xfffffffffffffffd,
  0xffffffffffff7f83, 0xffffffffffffffff,
  0xffffffffffff7f83, 0x0000000000000001,
  0xffffffffffff7f83, 0x0000000000000003,
  0xffffffffffff7f83, 0x0000000000000005,
  0xffffffffffff7f83, 0x2aaaaaaaaaaaaaad,
  0xffffffffffff7f83, 0x7777777777777776,
  0xffffffffffff7f83, 0xcccccccc4ccccccc,
  0xffffffffffff7f83, 0xffffffff00000001,
  0xffffffffffff7f83, 0xffffffff00000003,
  0xffffffffffff7f83, 0xffffffff00000005,
  0xffffffffffff7f83, 0xffffffff7fff8003,
  0xffffffffffff7f83, 0xffffffffffff0001,
  0xffffffffffff7f83, 0xffffffffffff0003,
  0xffffffffffff7f83, 0xffffffffffff0005,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f83, 0xffffffffffffff01,
  0xffffffffffff7f83, 0xffffffffffffff03,
  0xffffffffffff7f83, 0xffffffffffffff05,
  0xffffffffffff7f83, 0xffffffffffffff43,
  0xffffffffffff7f83, 0xffffffffffffffbd,
  0xffffffffffff7f83, 0xfffffffffffffffb,
  0xffffffffffff7f83, 0xfffffffffffffffd,
  0xffffffffffffff01, 0xffffffffffffffff,
  0xffffffffffffff01, 0x0000000000000001,
  0xffffffffffffff01, 0x0000000000000003,
  0xffffffffffffff01, 0x0000000000000042,
  0xffffffffffffff01, 0x00000000000000bd,
  0xffffffffffffff01, 0x00000000000000fb,
  0xffffffffffffff01, 0x00000000000000fd,
  0xffffffffffffff01, 0x000000000000807c,
  0xffffffffffffff01, 0x000000000000fffb,
  0xffffffffffffff01, 0x000000000000fffd,
  0xffffffffffffff01, 0x0000000080007ffc,
  0xffffffffffffff01, 0x00000000fffffffb,
  0xffffffffffffff01, 0x00000000fffffffd,
  0xffffffffffffff01, 0x33333333b3333332,
  0xffffffffffffff01, 0x8888888888888888,
  0xffffffffffffff01, 0xd555555555555552,
  0xffffffffffffff01, 0xfffffffffffffffb,
  0xffffffffffffff01, 0xfffffffffffffffd,
  0xffffffffffffff01, 0xffffffffffffffff,
  0xffffffffffffff01, 0x0000000000000001,
  0xffffffffffffff01, 0x0000000000000003,
  0xffffffffffffff01, 0x0000000000000005,
  0xffffffffffffff01, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffff01, 0x7777777777777776,
  0xffffffffffffff01, 0xcccccccc4ccccccc,
  0xffffffffffffff01, 0xffffffff00000001,
  0xffffffffffffff01, 0xffffffff00000003,
  0xffffffffffffff01, 0xffffffff00000005,
  0xffffffffffffff01, 0xffffffff7fff8003,
  0xffffffffffffff01, 0xffffffffffff0001,
  0xffffffffffffff01, 0xffffffffffff0003,
  0xffffffffffffff01, 0xffffffffffff0005,
  0xffffffffffffff01, 0xffffffffffff7f83,
  0xffffffffffffff01, 0xffffffffffffff01,
  0xffffffffffffff01, 0xffffffffffffff03,
  0xffffffffffffff01, 0xffffffffffffff05,
  0xffffffffffffff01, 0xffffffffffffff43,
  0xffffffffffffff01, 0xffffffffffffffbd,
  0xffffffffffffff01, 0xfffffffffffffffb,
  0xffffffffffffff01, 0xfffffffffffffffd,
  0xffffffffffffff03, 0xffffffffffffffff,
  0xffffffffffffff03, 0x0000000000000001,
  0xffffffffffffff03, 0x0000000000000003,
  0xffffffffffffff03, 0x0000000000000042,
  0xffffffffffffff03, 0x00000000000000bd,
  0xffffffffffffff03, 0x00000000000000fb,
  0xffffffffffffff03, 0x00000000000000fd,
  0xffffffffffffff03, 0x000000000000807c,
  0xffffffffffffff03, 0x000000000000fffb,
  0xffffffffffffff03, 0x000000000000fffd,
  0xffffffffffffff03, 0x0000000080007ffc,
  0xffffffffffffff03, 0x00000000fffffffb,
  0xffffffffffffff03, 0x00000000fffffffd,
  0xffffffffffffff03, 0x33333333b3333332,
  0xffffffffffffff03, 0x8888888888888888,
  0xffffffffffffff03, 0xd555555555555552,
  0xffffffffffffff03, 0xfffffffffffffffb,
  0xffffffffffffff03, 0xfffffffffffffffd,
  0xffffffffffffff03, 0xffffffffffffffff,
  0xffffffffffffff03, 0x0000000000000001,
  0xffffffffffffff03, 0x0000000000000003,
  0xffffffffffffff03, 0x0000000000000005,
  0xffffffffffffff03, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffff03, 0x7777777777777776,
  0xffffffffffffff03, 0xcccccccc4ccccccc,
  0xffffffffffffff03, 0xffffffff00000001,
  0xffffffffffffff03, 0xffffffff00000003,
  0xffffffffffffff03, 0xffffffff00000005,
  0xffffffffffffff03, 0xffffffff7fff8003,
  0xffffffffffffff03, 0xffffffffffff0001,
  0xffffffffffffff03, 0xffffffffffff0003,
  0xffffffffffffff03, 0xffffffffffff0005,
  0xffffffffffffff03, 0xffffffffffff7f83,
  0xffffffffffffff03, 0xffffffffffffff01,
  0xffffffffffffff03, 0xffffffffffffff03,
  0xffffffffffffff03, 0xffffffffffffff05,
  0xffffffffffffff03, 0xffffffffffffff43,
  0xffffffffffffff03, 0xffffffffffffffbd,
  0xffffffffffffff03, 0xfffffffffffffffb,
  0xffffffffffffff03, 0xfffffffffffffffd,
  0xffffffffffffff05, 0xffffffffffffffff,
  0xffffffffffffff05, 0x0000000000000001,
  0xffffffffffffff05, 0x0000000000000003,
  0xffffffffffffff05, 0x0000000000000042,
  0xffffffffffffff05, 0x00000000000000bd,
  0xffffffffffffff05, 0x00000000000000fb,
  0xffffffffffffff05, 0x00000000000000fd,
  0xffffffffffffff05, 0x000000000000807c,
  0xffffffffffffff05, 0x000000000000fffb,
  0xffffffffffffff05, 0x000000000000fffd,
  0xffffffffffffff05, 0x0000000080007ffc,
  0xffffffffffffff05, 0x00000000fffffffb,
  0xffffffffffffff05, 0x00000000fffffffd,
  0xffffffffffffff05, 0x33333333b3333332,
  0xffffffffffffff05, 0x8888888888888888,
  0xffffffffffffff05, 0xd555555555555552,
  0xffffffffffffff05, 0xfffffffffffffffb,
  0xffffffffffffff05, 0xfffffffffffffffd,
  0xffffffffffffff05, 0xffffffffffffffff,
  0xffffffffffffff05, 0x0000000000000001,
  0xffffffffffffff05, 0x0000000000000003,
  0xffffffffffffff05, 0x0000000000000005,
  0xffffffffffffff05, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffff05, 0x7777777777777776,
  0xffffffffffffff05, 0xcccccccc4ccccccc,
  0xffffffffffffff05, 0xffffffff00000001,
  0xffffffffffffff05, 0xffffffff00000003,
  0xffffffffffffff05, 0xffffffff00000005,
  0xffffffffffffff05, 0xffffffff7fff8003,
  0xffffffffffffff05, 0xffffffffffff0001,
  0xffffffffffffff05, 0xffffffffffff0003,
  0xffffffffffffff05, 0xffffffffffff0005,
  0xffffffffffffff05, 0xffffffffffff7f83,
  0xffffffffffffff05, 0xffffffffffffff01,
  0xffffffffffffff05, 0xffffffffffffff03,
  0xffffffffffffff05, 0xffffffffffffff05,
  0xffffffffffffff05, 0xffffffffffffff43,
  0xffffffffffffff05, 0xffffffffffffffbd,
  0xffffffffffffff05, 0xfffffffffffffffb,
  0xffffffffffffff05, 0xfffffffffffffffd,
  0xffffffffffffff43, 0xffffffffffffffff,
  0xffffffffffffff43, 0x0000000000000001,
  0xffffffffffffff43, 0x0000000000000003,
  0xffffffffffffff43, 0x0000000000000042,
  0xffffffffffffff43, 0x00000000000000bd,
  0xffffffffffffff43, 0x00000000000000fb,
  0xffffffffffffff43, 0x00000000000000fd,
  0xffffffffffffff43, 0x000000000000807c,
  0xffffffffffffff43, 0x000000000000fffb,
  0xffffffffffffff43, 0x000000000000fffd,
  0xffffffffffffff43, 0x0000000080007ffc,
  0xffffffffffffff43, 0x00000000fffffffb,
  0xffffffffffffff43, 0x00000000fffffffd,
  0xffffffffffffff43, 0x33333333b3333332,
  0xffffffffffffff43, 0x8888888888888888,
  0xffffffffffffff43, 0xd555555555555552,
  0xffffffffffffff43, 0xfffffffffffffffb,
  0xffffffffffffff43, 0xfffffffffffffffd,
  0xffffffffffffff43, 0xffffffffffffffff,
  0xffffffffffffff43, 0x0000000000000001,
  0xffffffffffffff43, 0x0000000000000003,
  0xffffffffffffff43, 0x0000000000000005,
  0xffffffffffffff43, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffff43, 0x7777777777777776,
  0xffffffffffffff43, 0xcccccccc4ccccccc,
  0xffffffffffffff43, 0xffffffff00000001,
  0xffffffffffffff43, 0xffffffff00000003,
  0xffffffffffffff43, 0xffffffff00000005,
  0xffffffffffffff43, 0xffffffff7fff8003,
  0xffffffffffffff43, 0xffffffffffff0001,
  0xffffffffffffff43, 0xffffffffffff0003,
  0xffffffffffffff43, 0xffffffffffff0005,
  0xffffffffffffff43, 0xffffffffffff7f83,
  0xffffffffffffff43, 0xffffffffffffff01,
  0xffffffffffffff43, 0xffffffffffffff03,
  0xffffffffffffff43, 0xffffffffffffff05,
  0xffffffffffffff43, 0xffffffffffffff43,
  0xffffffffffffff43, 0xffffffffffffffbd,
  0xffffffffffffff43, 0xfffffffffffffffb,
  0xffffffffffffff43, 0xfffffffffffffffd,
  0xffffffffffffffbd, 0xffffffffffffffff,
  0xffffffffffffffbd, 0x0000000000000001,
  0xffffffffffffffbd, 0x0000000000000003,
  0xffffffffffffffbd, 0x0000000000000042,
  0xffffffffffffffbd, 0x00000000000000bd,
  0xffffffffffffffbd, 0x00000000000000fb,
  0xffffffffffffffbd, 0x00000000000000fd,
  0xffffffffffffffbd, 0x000000000000807c,
  0xffffffffffffffbd, 0x000000000000fffb,
  0xffffffffffffffbd, 0x000000000000fffd,
  0xffffffffffffffbd, 0x0000000080007ffc,
  0xffffffffffffffbd, 0x00000000fffffffb,
  0xffffffffffffffbd, 0x00000000fffffffd,
  0xffffffffffffffbd, 0x33333333b3333332,
  0xffffffffffffffbd, 0x8888888888888888,
  0xffffffffffffffbd, 0xd555555555555552,
  0xffffffffffffffbd, 0xfffffffffffffffb,
  0xffffffffffffffbd, 0xfffffffffffffffd,
  0xffffffffffffffbd, 0xffffffffffffffff,
  0xffffffffffffffbd, 0x0000000000000001,
  0xffffffffffffffbd, 0x0000000000000003,
  0xffffffffffffffbd, 0x0000000000000005,
  0xffffffffffffffbd, 0x2aaaaaaaaaaaaaad,
  0xffffffffffffffbd, 0x7777777777777776,
  0xffffffffffffffbd, 0xcccccccc4ccccccc,
  0xffffffffffffffbd, 0xffffffff00000001,
  0xffffffffffffffbd, 0xffffffff00000003,
  0xffffffffffffffbd, 0xffffffff00000005,
  0xffffffffffffffbd, 0xffffffff7fff8003,
  0xffffffffffffffbd, 0xffffffffffff0001,
  0xffffffffffffffbd, 0xffffffffffff0003,
  0xffffffffffffffbd, 0xffffffffffff0005,
  0xffffffffffffffbd, 0xffffffffffff7f83,
  0xffffffffffffffbd, 0xffffffffffffff01,
  0xffffffffffffffbd, 0xffffffffffffff03,
  0xffffffffffffffbd, 0xffffffffffffff05,
  0xffffffffffffffbd, 0xffffffffffffff43,
  0xffffffffffffffbd, 0xffffffffffffffbd,
  0xffffffffffffffbd, 0xfffffffffffffffb,
  0xffffffffffffffbd, 0xfffffffffffffffd,
  0xfffffffffffffffb, 0xffffffffffffffff,
  0xfffffffffffffffb, 0x0000000000000001,
  0xfffffffffffffffb, 0x0000000000000003,
  0xfffffffffffffffb, 0x0000000000000042,
  0xfffffffffffffffb, 0x00000000000000bd,
  0xfffffffffffffffb, 0x00000000000000fb,
  0xfffffffffffffffb, 0x00000000000000fd,
  0xfffffffffffffffb, 0x000000000000807c,
  0xfffffffffffffffb, 0x000000000000fffb,
  0xfffffffffffffffb, 0x000000000000fffd,
  0xfffffffffffffffb, 0x0000000080007ffc,
  0xfffffffffffffffb, 0x00000000fffffffb,
  0xfffffffffffffffb, 0x00000000fffffffd,
  0xfffffffffffffffb, 0x33333333b3333332,
  0xfffffffffffffffb, 0x8888888888888888,
  0xfffffffffffffffb, 0xd555555555555552,
  0xfffffffffffffffb, 0xfffffffffffffffb,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffb, 0xffffffffffffffff,
  0xfffffffffffffffb, 0x0000000000000001,
  0xfffffffffffffffb, 0x0000000000000003,
  0xfffffffffffffffb, 0x0000000000000005,
  0xfffffffffffffffb, 0x2aaaaaaaaaaaaaad,
  0xfffffffffffffffb, 0x7777777777777776,
  0xfffffffffffffffb, 0xcccccccc4ccccccc,
  0xfffffffffffffffb, 0xffffffff00000001,
  0xfffffffffffffffb, 0xffffffff00000003,
  0xfffffffffffffffb, 0xffffffff00000005,
  0xfffffffffffffffb, 0xffffffff7fff8003,
  0xfffffffffffffffb, 0xffffffffffff0001,
  0xfffffffffffffffb, 0xffffffffffff0003,
  0xfffffffffffffffb, 0xffffffffffff0005,
  0xfffffffffffffffb, 0xffffffffffff7f83,
  0xfffffffffffffffb, 0xffffffffffffff01,
  0xfffffffffffffffb, 0xffffffffffffff03,
  0xfffffffffffffffb, 0xffffffffffffff05,
  0xfffffffffffffffb, 0xffffffffffffff43,
  0xfffffffffffffffb, 0xffffffffffffffbd,
  0xfffffffffffffffb, 0xfffffffffffffffb,
  0xfffffffffffffffb, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffd, 0x0000000000000001,
  0xfffffffffffffffd, 0x0000000000000003,
  0xfffffffffffffffd, 0x0000000000000042,
  0xfffffffffffffffd, 0x00000000000000bd,
  0xfffffffffffffffd, 0x00000000000000fb,
  0xfffffffffffffffd, 0x00000000000000fd,
  0xfffffffffffffffd, 0x000000000000807c,
  0xfffffffffffffffd, 0x000000000000fffb,
  0xfffffffffffffffd, 0x000000000000fffd,
  0xfffffffffffffffd, 0x0000000080007ffc,
  0xfffffffffffffffd, 0x00000000fffffffb,
  0xfffffffffffffffd, 0x00000000fffffffd,
  0xfffffffffffffffd, 0x33333333b3333332,
  0xfffffffffffffffd, 0x8888888888888888,
  0xfffffffffffffffd, 0xd555555555555552,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffd, 0xffffffffffffffff,
  0xfffffffffffffffd, 0x0000000000000001,
  0xfffffffffffffffd, 0x0000000000000003,
  0xfffffffffffffffd, 0x0000000000000005,
  0xfffffffffffffffd, 0x2aaaaaaaaaaaaaad,
  0xfffffffffffffffd, 0x7777777777777776,
  0xfffffffffffffffd, 0xcccccccc4ccccccc,
  0xfffffffffffffffd, 0xffffffff00000001,
  0xfffffffffffffffd, 0xffffffff00000003,
  0xfffffffffffffffd, 0xffffffff00000005,
  0xfffffffffffffffd, 0xffffffff7fff8003,
  0xfffffffffffffffd, 0xffffffffffff0001,
  0xfffffffffffffffd, 0xffffffffffff0003,
  0xfffffffffffffffd, 0xffffffffffff0005,
  0xfffffffffffffffd, 0xffffffffffff7f83,
  0xfffffffffffffffd, 0xffffffffffffff01,
  0xfffffffffffffffd, 0xffffffffffffff03,
  0xfffffffffffffffd, 0xffffffffffffff05,
  0xfffffffffffffffd, 0xffffffffffffff43,
  0xfffffffffffffffd, 0xffffffffffffffbd,
  0xfffffffffffffffd, 0xfffffffffffffffb,
  0xfffffffffffffffd, 0xfffffffffffffffd,
};
const unsigned kExpectedCount_NEON_addp_2D = 1600;

#endif  // VIXL_SIM_ADDP_2D_TRACE_AARCH64_H_
