/*
 * Copyright 2019 Xilinx Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <xir/graph/subgraph.hpp>
#include <xir/tensor/tensor.hpp>

#include "rnn_model_parser.hpp"

namespace vart {
namespace xrnn {

/// Model Parser implementation for RNN xmodels generated by XRNN compiler-v2
class RnnXmodelParser : public RNNModelParser {
 public:
  explicit RnnXmodelParser(const xir::Subgraph* subgraph);

  int get_model_input_seq_dim(bool aligned = true) const override;
  int get_model_output_seq_dim(bool aligned = true) const override;
  int get_num_layers() const override;
  int get_batch_size() const override;
  const std::string& get_target_device() const override;
  const std::vector<char>& get_weights() const override;

  /// If reg is for DDR commn, output = [dir, aligned_size, original_size]
  /// If reg is for IP mem, output = [addr_batch1, ...., addr_batchN]
  std::vector<uint32_t> get_ddr_reg_config(
      int layer_idx, const std::string& reg_name) const override;

  std::vector<char> get_end_instructions() const override;
  std::vector<char> get_first_instructions(int layer_idx) const override;
  std::vector<char> get_loop_instructions(int layer_idx) const override;

 protected:
  const xir::Subgraph* subgraph_ = nullptr;
  std::string target_ = "";
  std::vector<char> weights_;
  std::vector<const xir::Subgraph*> subgraphs_;

 private:
  void init();
};

}  // namespace xrnn
}  // namespace vart
