SET(CMAKE_SYSTEM_NAME Windows)

IF (DEFINED ENV{MINGW_GCC_DIR})
  SET(MINGW_GCC_ROOT "$ENV{MINGW_GCC_DIR}")
ELSE ()
  # Assume mingw cross compiler is installed in your system
  SET(MINGW_GCC_ROOT "/usr")
ENDIF()

# win32 may fail to compile with C++11 threads.

SET(CMAKE_C_COMPILER ${MINGW_GCC_ROOT}/bin/x86_64-w64-mingw32-gcc-posix)
SET(CMAKE_CXX_COMPILER ${MINGW_GCC_ROOT}/bin/x86_64-w64-mingw32-g++-posix)
SET(CMAKE_RC_COMPILER ${MINGW_GCC_ROOT}/bin/x86_64-w64-mingw32-windres)

SET(CMAKE_FIND_ROOT_PATH ${MINGW_GCC_ROOT}/x86_64-w64-mingw32)

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
