# taocpp/json Documentation

*Work-in-Progress - will be finished for 1.0 release*

* [Project](https://github.com/taocpp/json)
* [Overview](Overview.md)
* [Getting Started](Getting-Started.md)
* Installing and Using - TODO: Similar to PEGTL; merge with Getting Started?
* [Common Use Cases](Common-Use-Cases.md)
  * [Include the right header](Common-Use-Cases.md#include-the-right-header)
  * [Read any JSON file](Common-Use-Cases.md#read-any-json-file)
  * [Parse any JSON string](Common-Use-Cases.md#parse-any-json-string)
  * [Serialise a JSON Value to a string](Common-Use-Cases.md#serialise-a-json-value-to-a-string)
  * [Serialise with base64 strings for binary data](Common-Use-Cases.md#serialise-with-base64-strings-for-binary-data)
  * [Serialise a JSON Value to an ostream](Common-Use-Cases.md#serialise-a-json-value-to-an-ostream)
  * [Create a Value with a JSON object](Common-Use-Cases.md#create-a-value-with-a-json-object)
* [Value Class](Value-Class.md)
  * [Overview](Value-Class.md#overview)
  * [Value and Data Types](Value-Class.md#value-and-data-types)
  * [Creating Values](Value-Class.md#creating-values)
  * [Accessing Values](Value-Class.md#accessing-values)
  * [Manipulating Values](Value-Class.md#manipulating-values)
  * [Container Functions](Value-Class.md#container-functions)
  * [Comparing Values](Value-Class.md#comparing-values)
* [Type Traits](Type-Traits.md)
  * [Overview](Type-Traits.md#overview)
  * [Create JSON Value from (custom) type](Type-Traits.md#create-value-from-type)
  * [Convert JSON Value into (custom) type](Type-Traits.md#convert-value-into-type)
  * [Compare JSON Value to (custom) type](Type-Traits.md#compare-value-with-type)
  * [Produce JSON Events from (custom) type](Type-Traits.md#produce-events-from-type)
  * [Consume a (custom) type from a parser](Type-Traits.md#consume-type-from-parser)
  * [Default Key for Objects](Type-Traits.md#default-key-for-objects)
  * [Batteries Included](Type-Traits.md#batteries-included)
* [Binding Traits](Binding-Traits.md)
  * [Types as Arrays](Binding-Traits.md#types-as-arrays)
  * [Types as Objects](Binding-Traits.md#types-as-objects)
  * [Polymorphic Factory](Binding-Traits.md#polymorphic-factory)
  * [Multiple Versions](Binding-Traits.md#multiple-versions)
* [Events Interface](Events-Interface.md)
  * [Overview](Events-Interface.md#overview)
  * [Consumer Interface](Events-Interface.md#consumer-interface)
  * [Arrays and Objects](Events-Interface.md#arrays-and-objects)
  * [Reduced Interface](Events-Interface.md#reduced-interface)
  * [Batteries Included](Events-Interface.md#batteries-included)
* [Batteries Included](Batteries-Included.md)
  * [Default Traits](Batteries-Included.md#default-traits)
  * [Additional Traits](Batteries-Included.md#additional-traits)
  * [Binding Traits](Binding-Traits.md)
  * [Events Producers](Batteries-Included.md#events-producers)
  * [Events Consumers](Batteries-Included.md#events-consumers)
  * [Events Transformers](Batteries-Included.md#events-transformers)
  * [Convenience Functions](Batteries-Included.md#convenience-functions)
  * [Conversion Utilities](Batteries-Included.md#conversion-utilities)
* [Advanced Use Cases](Advanced-Use-Cases.md)
  * [Custom Base Class for Values](Advanced-Use-Cases.md#custom-base-class-for-values)
  * [Annotate with filename and line number](Advanced-Use-Cases.md#annotate-with-filename-and-line-number)
* [Instance Sharing](Instance-Sharing.md)
  * [String Views](Instance-Sharing.md#string-views)
  * [Binary Views](Instance-Sharing.md#binary-views)
  * [Value Pointers](Instance-Sharing.md#value-pointers)
  * [Opaque Pointers](Instance-Sharing.md#opaque-pointers)
  * [Self Contained](Instance-Sharing.md#self-contained)
  * [Unsafe Functions](Instance-Sharing.md#unsafe-functions)
* [Interoperability](Interoperability.md)
  * [General Notes](Interoperability.md#general-notes)
  * [Specific Notes](Interoperability.md#specific-notes)
    * [JSON](Interoperability.md#json)
    * [JAXN](Interoperability.md#jaxn)
    * [CBOR](Interoperability.md#cbor)
    * [MsgPack](Interoperability.md#msgpack)
    * [UBJSON](Interoperability.md#ubjson)
  * [Unsupported Formats](Interoperability.md#unsupported-formats)
* [Parser Interface](Parser-Interface.md)
* [Design Decisions](Design-Decisions.md)
* [Scratchpad](Scratchpad.md)
* [Changelog](Changelog.md)

Copyright (c) 2018-2020 Dr. Colin Hirsch and Daniel Frey
