/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import uk.ac.bristol.star.cdf.CdfFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NumericEncoding {
    NETWORK(Boolean.TRUE),
    SUN(Boolean.TRUE),
    NeXT(Boolean.TRUE),
    MAC(Boolean.TRUE),
    HP(Boolean.TRUE),
    SGi(Boolean.TRUE),
    IBMRS(Boolean.TRUE),
    DECSTATION(Boolean.FALSE),
    IBMPC(Boolean.FALSE),
    ALPHAOSF1(Boolean.FALSE),
    ALPHAVMSi(Boolean.FALSE),
    VAX(null),
    ALPHAVMSd(null),
    ALPHAVMSg(null);

    private final Boolean isBigendian_;

    private NumericEncoding(Boolean bl) {
        this.isBigendian_ = bl;
    }

    public Boolean isBigendian() {
        return this.isBigendian_;
    }

    public static NumericEncoding getEncoding(int n) throws CdfFormatException {
        switch (n) {
            case 1: {
                return NETWORK;
            }
            case 2: {
                return SUN;
            }
            case 3: {
                return VAX;
            }
            case 4: {
                return DECSTATION;
            }
            case 5: {
                return SGi;
            }
            case 6: {
                return IBMPC;
            }
            case 7: {
                return IBMRS;
            }
            case 9: {
                return MAC;
            }
            case 11: {
                return HP;
            }
            case 12: {
                return NeXT;
            }
            case 13: {
                return ALPHAOSF1;
            }
            case 14: {
                return ALPHAVMSd;
            }
            case 15: {
                return ALPHAVMSg;
            }
            case 16: {
                return ALPHAVMSi;
            }
        }
        throw new CdfFormatException("Unknown numeric encoding " + n);
    }
}

