'From OLPC1.0 of 17 August 2006 [latest update: #1108] on 3 November 2006 at 3:30:07 pm'!
"Change Set:		Video4Squeak-dgd
Date:			3 November 2006
Author:			Diego Gomez Deck <DiegoGomezDeck@consultar.com>

"!

SymbolListType subclass: #ImageResolutionType
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Morphic'!

!ImageResolutionType commentStamp: 'dgd 8/1/2004 21:04' prior: 0!
New type for VideoDevices' eToy vocabulary!

Object subclass: #ParameterDescription
	instanceVariableNames: 'name type label target getSelector options help keepRatio value originalValue'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!
UpdatingStringMorph subclass: #UpdatingNumericStringMorph
	instanceVariableNames: 'min max'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Morphic'!

!UpdatingNumericStringMorph commentStamp: '<historical>' prior: 0!
Similar to UpdatingStringMorph, but adds some new features for handling numbers.!

ProtoObject subclass: #V4LPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!

!V4LPlugin commentStamp: 'dgd 8/1/2004 21:04' prior: 0!
Plugin to access Video4Linux devices.
!

Object subclass: #VideoDevice
	instanceVariableNames: 'isSleeping isExecutor brightness contrast implementation lastErrorTimestamp'
	classVariableNames: 'Registry'
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!

!VideoDevice commentStamp: 'dgd 8/1/2004 21:06' prior: 0!
VideoDevice is the access point for Video4Squeak framework.

How to use:
	VideoDevice default.

!

Object subclass: #VideoDeviceImplementor
	instanceVariableNames: 'description'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!

!VideoDeviceImplementor commentStamp: 'dgd 7/28/2004 17:31' prior: 0!
This class is the superclass for the Implementor hierarchy for the Bridge composed with VideoDevice.

VideoDevice holds an implementor and it can be changed on the fly.

It allows, for instance, to switch the implementor base on the operative system where Squeak is being started.
!

VideoDeviceImplementor subclass: #TestDeviceImplementor
	instanceVariableNames: 'opened extent type isShowingTime'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!
VideoDeviceImplementor subclass: #V4LDeviceImplementor
	instanceVariableNames: 'deviceHandle buffer deviceID desiredExtent desiredPalette'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!
Object subclass: #VideoDeviceImplementorDescription
	instanceVariableNames: 'type id name'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Core'!
RectangleMorph subclass: #VideoMorph
	instanceVariableNames: 'videoSource form resolution autoExtent configurationDialog'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Morphic'!
AlignmentMorph subclass: #VideoMorphConfiguration
	instanceVariableNames: 'target parameters'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Morphic'!
ObjectPropertiesMorph subclass: #VideoPropertiesMorph
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VideoForSqueak-Morphic'!

!ImageResolutionType methodsFor: 'initialization' stamp: 'dgd 7/1/2004 13:30'!
initialize
	"initialize the receiver's"
	super initialize.
	""
	self vocabularyName: #ImageResolution.
	self symbols: VideoMorph resolutions! !

!ImageResolutionType methodsFor: 'tiles' stamp: 'dgd 8/20/2006 11:30'!
representsAType
	^ true! !


!ImageResolutionType class methodsFor: 'class initialization' stamp: 'dgd 8/20/2006 11:44'!
initialize
	Vocabulary initialize! !


!ParameterDescription methodsFor: 'creation' stamp: 'dgd 8/10/2004 14:17'!
asBooleanMorph
	| cb lab |
	cb := EtoyUpdatingThreePhaseButtonMorph checkBox.
	cb
		target: self;
		actionSelector: #switchValue;
		getSelector: #value.
	help isEmpty ifFalse: [cb setBalloonText: help].
	""
	lab := StringMorph contents: ' ' , label.
	lab setBalloonText: help.
	help isEmpty ifFalse: [lab setBalloonText: help].
	""
	^self inARow: { 
				cb.
				lab}! !

!ParameterDescription methodsFor: 'creation' stamp: 'dgd 8/10/2004 12:36'!
asExtentMorph
	| lab x y kr |
	lab := StringMorph contents: label , ': '.
	help isEmpty
		ifFalse: [lab setBalloonText: help].
	""
	x := UpdatingNumericStringMorph on: self selector: #getPointX.
	x putSelector: #setPointX:.
	x min: 16.
	x max: 640.
	x setBalloonText: 'width in pixels' translated.
	""
	y := UpdatingNumericStringMorph on: self selector: #getPointY.
	y putSelector: #setPointY:.
	y min: 12.
	y max: 480.
	y setBalloonText: 'height in pixels' translated.
	""
	kr := EtoyUpdatingThreePhaseButtonMorph checkBox.
	kr target: self;
		 actionSelector: #switchKeepRatio;
		 getSelector: #keepRatio.
	kr setBalloonText: 'keep ratio' translated.
	""
	^ self inARow: {lab. StringMorph contents: ' width=' translated. self inABox: x. StringMorph contents: ' height=' translated. self inABox: y. StringMorph contents: '  '. kr}! !

!ParameterDescription methodsFor: 'creation' stamp: 'dgd 8/10/2004 12:06'!
asMorph
	type == #boolean
		ifTrue: [^ self asBooleanMorph].
	type == #extent
		ifTrue: [^ self asExtentMorph].
	type == #option
		ifTrue: [^ self asOptionMorph].
	""
	^ StringMorph contents: 'unknown type: ' , type asString! !

!ParameterDescription methodsFor: 'creation' stamp: 'dgd 8/10/2004 12:33'!
asOptionMorph
	| lab button |
	lab := StringMorph contents: label , ': '.
	help isEmpty
		ifFalse: [lab setBalloonText: help].
	""
	button := UpdatingSimpleButtonMorph newWithLabel: '-'.
	button target: self;
		 wordingSelector: #wordingForOption;
		 actionSelector: #showOptions;

		 color: Color white;
		 borderWidth: 1;
		 borderColor: Color black;
		 cornerStyle: #square.
help isEmpty
		ifFalse: [button setBalloonText: help].
	""
	^ self inARow: {lab. button}! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:17'!
getPointX
	^(self value) x! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:17'!
getPointY
	^(self value) y! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/9/2004 19:10'!
inABox: aMorph 
	"private - answer a row with the given morphs"
	| box |
	box := AlignmentMorph newRow.
	box color: Color white.
	box borderWidth: 1.
	box borderColor: Color black.
	""
	box addMorphBack: aMorph.
	""
	^ box! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/9/2004 17:38'!
inARow: aCollection 
	"private - answer a row with the given morphs"
	| row |
	row := AlignmentMorph newRow.
	row color: Color transparent.
	""
	aCollection
		do: [:each | row addMorphBack: each].
	""
	^ row! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:17'!
setPointX: aNumber 
	| newX currentX newY |
	newX := aNumber asInteger min: 640 max: 16.
	currentX := self getPointX.
	newX = currentX ifTrue: [^self].
	newY := keepRatio 
				ifTrue: [(newX / currentX * self getPointY) rounded]
				ifFalse: [self getPointY].
	""
	self value: newX @ newY! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:17'!
setPointY: aNumber 
	| newY currentY newX |
	newY := aNumber asInteger min: 480 max: 12.
	currentY := self getPointY.
	newY = currentY ifTrue: [^self].
	newX := keepRatio 
				ifTrue: [(newY / currentY * self getPointX) rounded]
				ifFalse: [self getPointX].
	""
	self value: newX @ newY! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:17'!
showOptions
	| menu |
	menu := MenuMorph new.
	menu color: Color white.
	menu borderWidth: 1.
	menu borderColor: Color black.
	menu cornerStyle: #square.
	options do: 
			[:pair | 
			""

			menu 
				add: pair first
				target: self
				selector: #value:
				argumentList: { 
						pair second}].
	menu popUpInWorld! !

!ParameterDescription methodsFor: 'private' stamp: 'dgd 8/10/2004 14:18'!
wordingForOption
	| option wording |
	option := self value.
	wording := options detect: [:pair | pair second = option]
				ifNone: [^'<unknown option>' translated].
	^wording first! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/10/2004 20:14'!
hasChanged
	^ value ~= originalValue! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/9/2004 20:23'!
keepRatio
	^keepRatio! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/10/2004 20:09'!
name
	"answer the receiver's name"
	^ name! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/9/2004 20:24'!
switchKeepRatio
	keepRatio := keepRatio not! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/10/2004 14:18'!
switchValue
	value := value not ! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/10/2004 14:13'!
value
^value! !

!ParameterDescription methodsFor: 'accessing' stamp: 'dgd 8/10/2004 14:13'!
value: anObject
	value _anObject! !

!ParameterDescription methodsFor: 'initialization' stamp: 'dgd 8/9/2004 20:23'!
initialize
	"initialize the receiver"


	keepRatio := true! !

!ParameterDescription methodsFor: 'initialization' stamp: 'dgd 8/10/2004 20:09'!
initializeName: nameSymbol type: typeSymbol label: labelString value: anObject options: aCollection help: helpString 
	"initialize the receiver"
	name := nameSymbol.
	type := typeSymbol.
	label := labelString.
	value := originalValue := anObject.
	options := aCollection.
	help := helpString! !


!ParameterDescription class methodsFor: 'instance creation' stamp: 'dgd 8/10/2004 20:10'!
booleanParameterNamed: nameSymbol label: labelString value: anObject help: helpString 
	^ self new
		initializeName: nameSymbol 
		type: #boolean
		label: labelString
		value: anObject
		options: nil
		help: helpString! !

!ParameterDescription class methodsFor: 'instance creation' stamp: 'dgd 8/10/2004 20:11'!
extentParameterNamed: nameSymbol label: labelString value: anObject help: helpString 
	^ self new
		initializeName: nameSymbol
		type: #extent
		label: labelString
		value: anObject
		options: nil
		help: helpString! !

!ParameterDescription class methodsFor: 'instance creation' stamp: 'dgd 8/9/2004 20:13'!
new
	"answer a new instance of the receiver"
	^ super new initialize! !

!ParameterDescription class methodsFor: 'instance creation' stamp: 'dgd 8/10/2004 20:12'!
optionParameterNamed: nameSymbol label: labelString value: anObject options: aCollection help: helpString 
	^ self new
		initializeName: nameSymbol
		type: #option
		label: labelString
		value: anObject
		options: aCollection
		help: helpString! !


!Player methodsFor: '*VideoForSqueak-playing commands' stamp: 'dgd 8/9/2004 20:56'!
configureVideoDevice
	self sendMessageToCostume: #configureVideoDevice! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 8/6/2004 19:54'!
getAutoExtent
	"answer whateve the receiver is in auto extent mode"
	^ costume renderedMorph getAutoExtent! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 6/30/2004 23:21'!
getBrightness
	"Answer the numeric value contained in my costume"
	^ costume renderedMorph getBrightness! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 6/30/2004 23:21'!
getContrast
	"Answer the numeric value contained in my costume"
	^ costume renderedMorph getContrast! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 7/1/2004 18:24'!
getLastFrame
	"Answer the lastFrame in my costume"
	^ costume renderedMorph getLastFrame assuredPlayer! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 7/1/2004 13:23'!
getResolution
	"Answer the numeric value contained in my costume"
	^ costume renderedMorph getResolution! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 8/6/2004 19:55'!
setAutoExtent: aBoolean 
	"Set the receiver's boolean value. This is passed on to the costume"
	costume renderedMorph setAutoExtent: aBoolean! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 6/30/2004 23:22'!
setBrightness: amt 
	"Set the receiver's numeric value to the amount. This is passed 
	on to the costume"
	costume renderedMorph setBrightness: amt! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 6/30/2004 23:22'!
setContrast: amt 
	"Set the receiver's numeric value to the amount. This is passed 
	on to the costume"
	costume renderedMorph setContrast: amt! !

!Player methodsFor: '*VideoForSqueak-slot getters/setters' stamp: 'dgd 7/1/2004 13:22'!
setResolution: aSymbol 
	"Set the receiver's value. This is passed on to the costume"
	costume renderedMorph setResolution: aSymbol! !


!UpdatingNumericStringMorph methodsFor: 'target access' stamp: 'sw 9/13/2002 17:54'!
acceptValueFromTarget: v
	"Accept a value from my target"

	^ super acceptValueFromTarget: ((self format == #default and: [v isNumber])
		ifTrue: 
			[| t | 
			t _ v.
			min ifNotNil: [t _ t max: min].
			max ifNotNil: [t _ t min: max]]
		ifFalse:
			[v])! !

!UpdatingNumericStringMorph methodsFor: 'accessing' stamp: 'NS 6/24/2000 16:31'!
max
	^ max! !

!UpdatingNumericStringMorph methodsFor: 'accessing' stamp: 'NS 6/24/2000 16:31'!
max: aNumber
	max _ aNumber! !

!UpdatingNumericStringMorph methodsFor: 'accessing' stamp: 'NS 6/24/2000 16:32'!
min
	^ min! !

!UpdatingNumericStringMorph methodsFor: 'accessing' stamp: 'NS 6/24/2000 16:31'!
min: aNumber
	min _ aNumber! !


!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 8/1/2004 20:41'!
primitiveDeviceClose
	| device |
	self export: true. 
	self var: #device type: 'Device'.
	device := self
				cCoerce: (interpreterProxy stackIntegerValue: 0)
				to: 'Device'.
	self closeDevice: device.
	""
	interpreterProxy pop: 1! !

!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 8/5/2004 22:27'!
primitiveDeviceCreate
	| palette height width devicePointer deviceID |
	self export: true.
	""
	palette := interpreterProxy stackIntegerValue: 0.
	height := interpreterProxy stackIntegerValue: 1.
	width := interpreterProxy stackIntegerValue: 2.
	deviceID := interpreterProxy stackIntegerValue: 3.
	""
	devicePointer := self cCode: '(int) createDevice(deviceID, width, height, palette)'.
	devicePointer <= 0
		ifTrue: [^ interpreterProxy primitiveFail].
	""
	interpreterProxy
		pop: 5
		thenPush: (interpreterProxy integerObjectOf: devicePointer) ! !

!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 7/29/2004 17:49'!
primitiveDeviceDescribe
	| deviceID deviceName deviceNamePointer deviceNameSize |
	self export: true.
	self var: #deviceNamePointer type: 'void*'.
	""
	deviceName := interpreterProxy stackValue: 0.
	(interpreterProxy isBytes: deviceName)
		ifFalse: [^ interpreterProxy primitiveFail].
	deviceNamePointer := interpreterProxy firstIndexableField: deviceName.
	deviceNameSize := interpreterProxy byteSizeOf: deviceName.
	deviceNameSize = 32
		ifFalse: [^ interpreterProxy primitiveFail].
	""
	deviceID := interpreterProxy stackIntegerValue: 1.
	""
	self cCode: 'describeDevice(deviceID, deviceNamePointer)'.
	"" 
	interpreterProxy pop: 2! !

!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 7/21/2004 17:43'!
primitiveDeviceGetHeight
	| device result |
	self export: true.
	self var: #device type: 'Device'.
	device := self
				cCoerce: (interpreterProxy stackIntegerValue: 0)
				to: 'Device'.
	result := self cCode: 'device->vwindow.height'.
	interpreterProxy
		pop: 2
		thenPush: (interpreterProxy integerObjectOf: result)! !

!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 7/21/2004 17:48'!
primitiveDeviceGetWidth
	| device result |
	self export: true.
	self var: #device type: 'Device'.
	device := self
				cCoerce: (interpreterProxy stackIntegerValue: 0)
				to: 'Device'.
	result := self cCode: 'device->vwindow.width'.
	interpreterProxy
		pop: 2
		thenPush: (interpreterProxy integerObjectOf: result)! !

!V4LPlugin methodsFor: 'primitives' stamp: 'dgd 8/6/2004 14:32'!
primitiveDeviceNextFrameIntoBrightnessAndContrast
	"set the capture extent and pixel format to use"
	| contrast brightness bitsArrayPointer bitsArraySize device result dest src imageSize final |
	self export: true.
	self var: #device type: 'Device'.
	self var: #dest type: 'unsigned char*'.
	self var: #src type: 'unsigned char*'.
	self var: #final type: 'unsigned char*'.
	self var: #brightness type: 'double'.
	self var: #contrast type: 'double'.
	""
	contrast := interpreterProxy stackFloatValue: 0.
	brightness := interpreterProxy stackFloatValue: 1.
	brightness := brightness min: 1.0.
	brightness := brightness max: -1.0.
	contrast := contrast min: 1.0.
	contrast := contrast max: -1.0. 
	""
	bitsArrayPointer := interpreterProxy stackValue: 2.
	interpreterProxy success: (interpreterProxy isPointers: bitsArrayPointer) not.
	interpreterProxy failed
		ifTrue: [^ nil].
	bitsArraySize := interpreterProxy byteSizeOf: bitsArrayPointer.
	""
	device := self
				cCoerce: (interpreterProxy stackIntegerValue: 3)
				to: 'Device'.
	""
	result := self nextFrameFromDevice: device.
	result
		ifFalse: [^ interpreterProxy primitiveFail].
	""
	dest := self
				cCoerce: (interpreterProxy firstIndexableField: bitsArrayPointer)
				to: 'unsigned char*'.
	src := self cCode: 'device->buffer24'.
	""
	imageSize := device width * device height * 4.
	final := dest
				+ (imageSize min: bitsArraySize).
	""
	[dest < final]
		whileTrue: [| blue green red | 
			"blue"
			blue := self
						pixel: (src at: 2)
						brightness: brightness
						contrast: contrast.
			dest at: 0 put: blue.
			"green"
			green := self
						pixel: (src at: 1)
						brightness: brightness
						contrast: contrast.
			dest at: 1 put: green.
			"red"
			red := self
						pixel: (src at: 0)
						brightness: brightness
						contrast: contrast.
			dest at: 2 put: red.
			"alpha"
			dest at: 3 put: 255.
			""
			dest := dest + 4.
			src := src + 3].
	""
	interpreterProxy pop: 4! !

!V4LPlugin methodsFor: 'helper functions' stamp: 'dgd 8/5/2004 22:51'!
height: device 
	self inline: true.
	self var: #device type: 'Device'.
	^ self cCode: 'device->vwindow.height'! !

!V4LPlugin methodsFor: 'helper functions' stamp: 'dgd 8/20/2006 10:45'!
pixel: pixel brightness: brightness contrast: contrast 
	| result c |
	self inline: true.
	self var: #brightness type: 'double'.
	self var: #contrast type: 'double'.
	self var: #c type: 'double'.
	"contrast"
	c := 1.0 + contrast.
	c := c * c.
	result := pixel - 0.5 * c + 0.5.
	"brightness"
	result := result + (brightness * 256) asInteger.
	"bound checking"
	result < 0
		ifTrue: [result := 0].
	result > 255
		ifTrue: [result := 255].
	^ result asInteger! !

!V4LPlugin methodsFor: 'helper functions' stamp: 'dgd 7/21/2004 21:02'!
width: device 
	self inline: true.
	self var: #device type: 'Device'.
	^ self
		cCode: 'device->vwindow.width'
	! !


!V4LPlugin class methodsFor: 'translation' stamp: 'dgd 6/26/2004 18:12'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with 
	the plugin, here is where you want to flag"
	^ true! !

!V4LPlugin class methodsFor: 'translation' stamp: 'dgd 8/5/2004 22:50'!
translate
	" 
	V4LPlugin translate.
	"
	| directory |
	directory := FileDirectory forFileName: '/home/dgd/squeak-vm37/src/plugins/V4LPlugin/'.
	directory assureExistence.
	self translateInDirectory: directory doInlining: true! !


!VideoDevice methodsFor: 'private' stamp: 'dgd 7/11/2004 20:50'!
benchmark
	"capture and display 100 frames from the device"
	| iterations time statistics |
	iterations := 100.
	time := Time
				millisecondsToRun: [""
					iterations
						timesRepeat: [self next display]].
	""
	Display restore.
	""
	statistics := String new writeStream.
	statistics nextPutAll: '------------------------------------------------------------'.
	statistics cr.
	statistics nextPutAll: 'Frame Extent: ' , self extent asString.
	statistics cr.
	statistics nextPutAll: 'Iterations: ' , iterations asString.
	statistics cr.
	statistics nextPutAll: 'Ellapsed time:' , time asString , 'ms (each ' , (time / iterations) asFloat rounded asString , 'ms)'.
	statistics cr.
	statistics nextPutAll: 'Frames per second:' , (1000.0 / (time / iterations) roundTo: 0.01) asString.
	statistics cr.
	statistics nextPutAll: '------------------------------------------------------------'.
	statistics cr.
	""
	statistics contents openInWorkspaceWithTitle: 'benchmark'! !

!VideoDevice methodsFor: 'private' stamp: 'dgd 8/9/2004 19:44'!
changedExtent
self triggerEvent:#extent! !

!VideoDevice methodsFor: 'private' stamp: 'dgd 8/1/2004 13:08'!
closedFrame
	"private"
	^ self frameColor: Color blue twiceDarker withMessage: 'closed' translated! !

!VideoDevice methodsFor: 'private' stamp: 'dgd 8/1/2004 12:49'!
frameColor: aColor withMessage: aString 
	"private - create a frame of the given color with aString as the message"
	| result |
	result := Form extent: self extent depth: 32.
	result fillColor: aColor.
	result getCanvas
		drawString: aString
		at: 5 @ 2
		font: Preferences windowTitleFont
		color: Color lightGreen.
	^ result! !

!VideoDevice methodsFor: 'private' stamp: 'dgd 8/1/2004 20:47'!
poisonedFrame
	"private"
	^ self
		frameColor: Color red muchDarker
		withMessage: ('no connected video device id: {1}' translated format: {self deviceID})! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/11/2004 20:55'!
brightness
	"answer the receiver's brightness"
	^ brightness! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/28/2004 17:08'!
brightness: aNumber 
	"change the receiver's brightness"
	
	brightness := aNumber asFloat min: 1.0 max: -1.0! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/11/2004 20:55'!
contrast
	"answer the receiver's contrast"
	^ contrast! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/28/2004 17:08'!
contrast: aNumber 
	"change the receiver's contrast"
	
	contrast := aNumber asFloat min: 1.0 max: -1.0! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:20'!
deviceID
	"answer the receiver's deviceID"
	^ implementation deviceID! !

!VideoDevice methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:19'!
extent
	"answer the receiver's extent"
	^implementation extent! !

!VideoDevice methodsFor: 'dying / reviving' stamp: 'dgd 8/1/2004 20:16'!
bePoisoned
	"change the receiver to be poisoned"
	lastErrorTimestamp := Time millisecondClockValue.
	[self closeIfCorresponds]
		on: Error
		do: [:exception | ]! !

!VideoDevice methodsFor: 'dying / reviving' stamp: 'dgd 8/1/2004 19:59'!
isPoisoned
	"answer whatever the receiver is poisoned"
	^ lastErrorTimestamp notNil! !

!VideoDevice methodsFor: 'dying / reviving' stamp: 'dgd 8/1/2004 20:51'!
isTimeToRevive
	"answer if it's time to try to revive the receiver"
	| elapsed |
	self isPoisoned
		ifFalse: [^ false].
	elapsed := Time millisecondsSince: lastErrorTimestamp.
	^ elapsed > 5000! !

!VideoDevice methodsFor: 'dying / reviving' stamp: 'dgd 8/1/2004 20:51'!
tryToRevive
	"private - trying to revive the receiver"
	self flag: #todo.
	"try to connect to another device if the current deviceID is  
	unavailable."
	""
	lastErrorTimestamp := nil.
	self open! !

!VideoDevice methodsFor: 'dying / reviving' stamp: 'dgd 8/1/2004 20:12'!
tryToReviveIfCorresponds
	"private - try to revive if it's time to"
	self isTimeToRevive
		ifTrue:[
	self tryToRevive]! !

!VideoDevice methodsFor: 'opening / closing' stamp: 'dgd 8/1/2004 13:11'!
close
	"close the receiver"
	isSleeping
		ifTrue: [""
			isSleeping := false.
			^ self].
	""
	self isOpened
		ifFalse: [^ self error: 'device not opened'].
	""
	[implementation close]
		on: Error
		do: [:exception | exception].
	self class unregister: self! !

!VideoDevice methodsFor: 'opening / closing' stamp: 'dgd 7/11/2004 20:48'!
closeIfCorresponds
	"close the receiver if it's opened, otherwise do nothing"
	self isOpened
		ifTrue: [self close]! !

!VideoDevice methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 20:19'!
isOpened
	"answer whatever the receiver is opened"
	^ implementation isOpened! !

!VideoDevice methodsFor: 'opening / closing' stamp: 'dgd 8/10/2004 21:27'!
open
	"open the device represented by the receiver"
	self isOpened
		ifTrue: [^ self error: 'device already opened'].
	""
	[implementation open.
	self class register: self.
self triggerEvent: #extent.
	isSleeping := false]
		on: Error
		do: [:exception | self bePoisoned]! !

!VideoDevice methodsFor: 'opening / closing' stamp: 'dgd 7/11/2004 20:48'!
openIfCorresponds
	"open the receiver if it isn't opened, otherwise do nothing"
	self isOpened
		ifFalse: [self open]! !

!VideoDevice methodsFor: 'configuration' stamp: 'dgd 8/10/2004 21:27'!
applyParameters: aCollection 
	"apply the (possible changed) collection of parameters"
	self isPoisoned
		ifFalse: [self close].
	implementation applyParameters: aCollection.
	self isPoisoned
		ifFalse: [self open].
! !

!VideoDevice methodsFor: 'configuration' stamp: 'dgd 8/10/2004 14:59'!
parameters
	"answer a collection of parameters to configure the receiver"
	^ implementation parameters! !

!VideoDevice methodsFor: 'sleeping' stamp: 'dgd 8/1/2004 20:14'!
awake
	"if the receiver is sleeping, awake it"
	isExecutor
		ifTrue: [^ self].
	""
	isSleeping
		ifFalse: [^ self].
	""
	self open.
	isSleeping := false! !

!VideoDevice methodsFor: 'sleeping' stamp: 'dgd 8/1/2004 13:11'!
sleep
	"if the receiver is opened, put it to sleep"
	isExecutor
		ifTrue: [^ self].
	""
	self isOpened
		ifFalse: [^ self].
	""
	self close.
	isSleeping := true! !

!VideoDevice methodsFor: 'initialization' stamp: 'dgd 8/1/2004 17:58'!
initialize
	"initialize the receiver"

	isSleeping := false.

	isExecutor := false.
	""
	brightness := 0.0.
	contrast := 0.0! !

!VideoDevice methodsFor: 'initialization' stamp: 'dgd 8/9/2004 19:43'!
initializeImplementation: anImplementor 
	"initialize the receiver's description"
	implementation := anImplementor.
implementation when: #extent
		send: #changedExtent
		to: self! !

!VideoDevice methodsFor: 'capturing' stamp: 'dgd 8/1/2004 20:47'!
next
	"answer the next frame from the device represented by the  
	receiver"
	self tryToReviveIfCorresponds.
	""	self isPoisoned
		ifTrue: [^ self poisonedFrame].
	self isOpened
		ifFalse: [^ self closedFrame].

	""
	[^ implementation nextWithBrightness: self brightness contrast: self contrast]
		on: Error
		do: [:exception | 
			self bePoisoned.
			^ self poisonedFrame]! !

!VideoDevice methodsFor: 'finalization' stamp: 'dgd 8/1/2004 21:07'!
actAsExecutor
	"prepare the receiver to act as executor for any resources associated with it"
	super actAsExecutor.
	"an executor will not to go sleep becouse the original instance 
	will close the device for its own"
	isExecutor := true! !

!VideoDevice methodsFor: 'finalization' stamp: 'dgd 7/11/2004 20:49'!
finalize
	"the receiver is going to die, let's clean up"
	
	self closeIfCorresponds! !


!VideoDevice class methodsFor: 'system startup' stamp: 'dgd 7/11/2004 20:46'!
shutDown: quitting 
	quitting ifFalse:[^self].
""

			self allSubInstances
				do: [:each | each sleep]! !

!VideoDevice class methodsFor: 'system startup' stamp: 'dgd 7/11/2004 20:46'!
startUp: resuming 
	resuming ifFalse:[^self].
""
		
			self allSubInstances
				do: [:each | each awake]! !

!VideoDevice class methodsFor: 'initialize-release' stamp: 'dgd 7/28/2004 21:14'!
initialize
	" 
	VideoDevice initialize. 
	"
	Smalltalk addToStartUpList: self.
	Smalltalk addToShutDownList: self! !

!VideoDevice class methodsFor: 'initialize-release' stamp: 'dgd 7/28/2004 21:15'!
unload
	Smalltalk removeFromStartUpList: self.
	Smalltalk removeFromShutDownList: self! !

!VideoDevice class methodsFor: 'registry' stamp: 'dgd 7/11/2004 20:45'!
register: anObject 
	"register anObject to receive the finalization signal"
	WeakArray isFinalizationSupported
		ifFalse: [^ self].
	self registry add: anObject! !

!VideoDevice class methodsFor: 'registry' stamp: 'dgd 7/11/2004 20:45'!
registry
	"anwer the registry for finalization"
	WeakArray isFinalizationSupported
		ifFalse: [^ nil].
	^ Registry
		ifNil: [Registry := WeakRegistry new]! !

!VideoDevice class methodsFor: 'registry' stamp: 'dgd 7/11/2004 20:45'!
unregister: anObject 
	WeakArray isFinalizationSupported
		ifFalse: [^ self].
	self registry
		remove: anObject
		ifAbsent: []! !

!VideoDevice class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 19:19'!
default
	"answer the default video device"
	" 
	VideoDevice default.  
	"
	^ self implementation: self firstAvailableDeviceImplementor! !

!VideoDevice class methodsFor: 'instance creation' stamp: 'dgd 11/3/2006 14:27'!
firstAvailableDeviceImplementor
	"private - answer the first available video device implementor"

	| descriptions |

	descriptions := self descriptions 
						asSortedCollection: [:x :y | x id <= y id].

	descriptions isEmpty ifTrue: [^self error: 'no video devices detected'].

	descriptions do: [:eachDescription | 
		[^ eachDescription newImplementor]
			on: Error
			do: [:exception | ]
	].
! !

!VideoDevice class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 20:16'!
implementation: anImplementor 
	"answer an instance of the receiver using the given  
	implementor"
	^ self new initializeImplementation: anImplementor! !

!VideoDevice class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 20:30'!
new
	"answer a new instance of the receiver"
	^ super new initialize ! !

!VideoDevice class methodsFor: 'enumerating' stamp: 'dgd 8/5/2004 19:30'!
descriptions
	"answer a collection of VideoDeviceDescription of available  
	video devices"
	" 
	VideoDevice descriptions.  
	"
	| result |
	result := Set new.
	self workingImplementors
		do: [:each | result addAll: each descriptions].
	""
	^ result ! !

!VideoDevice class methodsFor: 'enumerating' stamp: 'dgd 8/5/2004 19:28'!
workingImplementors
	"private - answer a collection of implementors working on the 
	current environment" 
	^ VideoDeviceImplementor allSubclasses
		select: [:each | each workOnCurrentEnvironment]! !


!VideoDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 18:24'!
applyParameters: aCollection 
	"apply the (possible changed) collection of parameters"
	! !

!VideoDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 14:59'!
parameters
	"answer a collection of parameters to configure the receiver"
	^ {}! !

!VideoDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:38'!
description
	"answer the receiver's description"
	^ description! !

!VideoDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:37'!
deviceID
	"answer the receiver's deviceID"
	^ self subclassResponsibility! !

!VideoDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:37'!
extent
	"answer the receiver's extent"
	^ self subclassResponsibility! !

!VideoDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:10'!
close
	"private - close the receiver"
	self subclassResponsibility! !

!VideoDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:14'!
isOpened
	"answer whatever the receiver is opened"
	^ self subclassResponsibility! !

!VideoDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:11'!
open
	"open the device represented by the receiver"
	self subclassResponsibility! !

!VideoDeviceImplementor methodsFor: 'initialization' stamp: 'dgd 7/28/2004 17:17'!
initialize
	"initialize the receiver"
! !

!VideoDeviceImplementor methodsFor: 'initialization' stamp: 'dgd 7/28/2004 20:18'!
initializeDescription: aDescription 
"initialiaze the receiver's description"
	description := aDescription! !

!VideoDeviceImplementor methodsFor: 'capturing' stamp: 'dgd 7/28/2004 20:26'!
nextWithBrightness: brightnessFloat contrast: contrastFloat
	"answer the next frame from the device represented by the  
	receiver"
	^ self subclassResponsibility! !


!TestDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 7/28/2004 20:07'!
deviceID
	"answer the receiver's deviceID"
	^ 10! !

!TestDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 8/10/2004 18:23'!
extent
	"answer the receiver's extent"
	^ extent! !

!TestDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 8/10/2004 19:41'!
extent: aPoint 
	"change the receiver's extent"
	extent = aPoint
		ifTrue: [^ self].
""
extent _ aPoint.
self triggerEvent:#extent! !

!TestDeviceImplementor methodsFor: 'private' stamp: 'dgd 8/9/2004 21:04'!
colorBars
	| result canvas testColors barWidth |
	result := Form extent: self extent depth: 32.
	""
	result fillColor: Color black.
	canvas := result getCanvas.
	""
	testColors :=  (Color cyan wheel: 32).
	barWidth := result width // testColors size.
	""
	testColors
		withIndexDo: [:color :index | ""
			canvas
				fillRectangle: (index - 1 * barWidth @ 0 rect: index * barWidth @ result height)
				color: color].
	^ result! !

!TestDeviceImplementor methodsFor: 'private' stamp: 'dgd 8/9/2004 21:04'!
lenna
	^ Form
		extent: 320 @ 240
		depth: 32
		fromArray: #(4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293037952 4292775807 4293035907 4293038208 4292906107 4292906619 4292970616 4292773745 4292773491 4292842358 4292969583 4292969839 4292381298 4293165676 4292643449 4292641404 4293297515 4292708211 4292972157 4293364086 4293300605 4292973432 4293632385 4293237633 4293629301 4293236353 4292974974 4293429370 4292378479 4292902779 4291451748 4289811557 4289348176 4288103014 4288888938 4289087570 4289022553 4289677920 4289546593 4290005077 4290007900 4290072153 4289417307 4290008422 4290005600 4290006617 4290465881 4289875290 4290007644 4290073436 4289416026 4290530135 4289811036 4290335323 4290207072 4291125601 4291122522 4291125601 4290667613 4291191136 4291650658 4291453282 4291125598 4291717991 4292044643 4291717989 4291191660 4291321700 4291129456 4291520874 4292110947 4291257694 4291782250 4291323230 4291783271 4291914337 4291519846 4291717216 4291914862 4291324528 4292044642 4291586661 4291980392 4291980392 4291782504 4292044132 4291716969 4292111459 4292439653 4291783789 4291652198 4291585632 4292045929 4291456615 4292045928 4291651941 4291849325 4292045928 4291587682 4291979880 4291981674 4291391079 4292439913 4290864753 4291457392 4291980139 4291521130 4291389283 4291126632 4291717990 4291979108 4291717216 4291389291 4291128426 4291784546 4291455595 4291848040 4291586662 4292109665 4291782500 4292111459 4292111460 4292111203 4291587689 4292044643 4291586662 4291848035 4291849069 4291786865 4291520617 4291585893 4291061096 4292439398 4291126370 4291980910 4291519072 4291192164 4291783526 4291125857 4291455600 4291258472 4291454301 4291651686 4291258472 4290929256 4292045160 4290863721 4291716703 4290995823 4291322973 4291322732 4291192680 4290600802 4290994033 4290731876 4290273388 4290403422 4289419359 4289548122 4289546595 4289939787 4290732130 4291322463 4292048489 4291916390 4292116594 4292249210 4292708206 4292840817 4292644725 4292514428 4292511084 4292509553 4292772208 4292576877 4292445808 4292903790 4292641660 4292839282 4292642163 4292512893 4292838779 4292970095 4292641637 4292248688 4293165404 4292576887 4292838512 4292838514 4292576106 4293035633 4292445806 4292969840 4292970867 4292250743 4292904297 4292839284 4292774777 4292970867 4292642164 4292446322 4293169517 4293705093 4294037154 4294037668 4294037409 4294038694 4294038694 4294038696 4294167951 4293176455 4291065452 4289284963 4288956510 4289484116 4289548647 4289944159 4290535007 4290272611 4290797412 4290274669 4290271838 4290338917 4290994271 4290797154 4290277240 4290337892 4290207075 4291125343 4290731872 4291322720 4291125087 4290600805 4290994782 4291322980 4290076264 4291323753 4290928990 4291322464 4290075231 4290667113 4291323751 4290601837 4290797923 4291256671 4290996578 4290536289 4291256415 4290141024 4290861405 4290206559 4290666084 4292772984 4292712336 4293499777 4292047205 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293037952 4292776064 4293231997 4293234041 4293038209 4293101445 4292905334 4292774279 4292970609 4292383868 4292837742 4292774005 4292839285 4292772719 4292839284 4292642163 4292773748 4292773747 4293299581 4292971646 4293366643 4293302908 4293629818 4293172097 4293566332 4293564795 4293628027 4293298564 4292901977 4292117114 4291518562 4290336614 4289282640 4288691558 4288299595 4288956509 4289022558 4289677921 4289481814 4290532454 4290007900 4289414487 4290070614 4290007899 4290008156 4289415769 4289877085 4290529622 4290009439 4289417052 4289547354 4289939543 4290466908 4290337112 4290139742 4291190359 4290533727 4290599511 4291454305 4290993757 4291257439 4291651426 4291387490 4291914849 4291585121 4291717991 4291585375 4291389549 4291522406 4291914862 4291586661 4291978596 4291322727 4291848545 4291127146 4291782496 4291127657 4291519585 4291653730 4291455339 4292373094 4291782248 4292111458 4291914600 4292111714 4291454575 4292505701 4292045667 4291914856 4291455339 4291848799 4292177252 4291586405 4291849326 4291717732 4291257954 4291849326 4291586405 4291980137 4292112996 4291980135 4291849325 4291849324 4291126891 4291063661 4291390570 4291586667 4292045663 4291061098 4291520348 4292177252 4291455078 4291650661 4291063147 4291717477 4291913577 4291848798 4291848810 4291979364 4291848799 4291914858 4292111459 4292111203 4291981926 4291913315 4292111971 4291453280 4291456870 4292442485 4291455082 4291980127 4290995306 4292111203 4291126371 4291521131 4291782752 4291192163 4291783525 4291191403 4292046444 4291192162 4291257956 4291192418 4291913064 4291126889 4291979362 4291586149 4291454566 4291126888 4291518561 4291258210 4291257960 4290600029 4291125859 4290733670 4290272615 4290403422 4290009193 4290074974 4289480021 4289940821 4290730591 4291322719 4292046949 4292180079 4292706416 4292183671 4292904819 4292840313 4292839799 4292514684 4292708204 4292574052 4292314478 4292313965 4293101168 4292642676 4292706939 4292643706 4292837741 4292644991 4292839282 4292772719 4292838513 4292904049 4292575603 4293035888 4292444522 4292640350 4293035890 4292380270 4292903007 4292773482 4292577915 4293101940 4292445548 4292643194 4292840312 4292839284 4292903535 4292446322 4293235053 4293705350 4294101904 4294037904 4294037411 4294038694 4294038694 4294038696 4294167695 4293110663 4290999660 4289350756 4288956508 4289680232 4289482073 4290469216 4290535006 4289750130 4290929242 4290209886 4290206048 4291191903 4290074975 4290208355 4290538605 4290272357 4290273387 4291388255 4290797664 4290534496 4291125087 4290667874 4290732388 4291322980 4290602086 4291257187 4290732389 4290929247 4290729820 4290798179 4291126376 4291127150 4290929764 4291124831 4290929508 4291323755 4290600031 4290797408 4290141280 4290272095 4290731877 4292116086 4293630342 4293500548 4292244837 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293037953 4292578683 4292906874 4292840332 4293036659 4292709242 4293101427 4292773747 4292970867 4292970874 4292970095 4292968300 4292577388 4292838255 4292839541 4292969838 4292773749 4292969585 4292644478 4293169012 4292907891 4293235591 4293632383 4293565057 4293564283 4293565052 4293562494 4293562222 4292443237 4292638841 4290993756 4290336615 4289282640 4288955993 4288690781 4288891228 4289022815 4289415005 4289481057 4290006616 4290006618 4290072410 4289481818 4289417565 4290070614 4290006875 4290531417 4289941083 4289415770 4290072410 4289480024 4290136919 4289878111 4290335324 4290730590 4291125858 4291124061 4290534753 4291388768 4291125856 4291453283 4291650915 4291190364 4291520098 4292044900 4291847267 4291718247 4291716185 4292111721 4291454821 4291914345 4291717472 4291519072 4291519073 4291324004 4291520606 4291781226 4291651680 4292045929 4292046185 4291520095 4291849582 4291980392 4292308843 4292045923 4292111714 4291980131 4292439910 4292241766 4291588195 4291782506 4292109414 4291782505 4292046183 4291257452 4291652453 4291980392 4292111458 4292505445 4291586411 4291455594 4291585645 4292111718 4291324526 4292045942 4291784061 4291126885 4291585382 4291585381 4291914603 4291783264 4291716458 4291389020 4291453804 4291784801 4291322214 4291521389 4291651680 4291846493 4291192686 4292176994 4291914857 4291520871 4292176995 4292111459 4292307815 4291847267 4291455339 4291586927 4291717732 4291454823 4291783008 4292044644 4291980128 4291914602 4291782751 4291322471 4292112233 4291060322 4291455858 4291453536 4291323491 4291256940 4291193192 4291125858 4291323238 4292045928 4290863721 4291126889 4291257437 4291584870 4290472562 4290600547 4291125860 4290731876 4290337630 4289812832 4290008669 4289417051 4289546339 4290006612 4290795349 4291388511 4291457382 4292245104 4292312422 4292249458 4292511609 4292840055 4292842363 4292644981 4292904821 4292116589 4292772970 4292969586 4292248428 4292772208 4292707956 4292511339 4292838255 4292839284 4292773749 4292970095 4292838512 4292378984 4292837726 4292838516 4292837726 4292641139 4292838256 4293035632 4292380528 4292970097 4292969839 4292446835 4292641129 4292970867 4292840313 4292446834 4292641385 4292314995 4292777065 4293639060 4293904265 4294037157 4294037409 4294038694 4294038694 4294038696 4294102674 4293178243 4291590760 4288562526 4289022046 4289679450 4289549404 4289944160 4290337888 4290336596 4290141799 4290863724 4290864219 4290075749 4291060580 4290797930 4290144872 4290928484 4289682778 4290994271 4290600032 4291321942 4291322464 4290010716 4291388518 4290798682 4290602082 4291454820 4290732388 4291585375 4290009439 4291455337 4290535785 4291126377 4291454046 4291256670 4290471784 4291519326 4290536285 4290729821 4290730851 4290075231 4290667097 4292968052 4292776837 4293823605 4290599012 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293036920 4292970615 4293035132 4293231717 4292970887 4293037175 4293231979 4292968556 4292511350 4293100139 4292970096 4292707184 4292970096 4292838512 4292640879 4292577389 4292970096 4292444773 4293232252 4293495671 4293629565 4293628276 4293171592 4293565301 4293566333 4293564279 4293562745 4293363564 4292510324 4292175459 4290994528 4290400087 4288887902 4288624731 4288691290 4289283420 4289150797 4289806947 4290072162 4289416282 4289414743 4290005592 4289873749 4290070871 4289415001 4290070091 4289285212 4290005331 4290070866 4290005337 4289416270 4290006619 4289875034 4290335059 4290731610 4290664021 4291124319 4291257184 4291323233 4291124822 4291716446 4291189588 4291846747 4291519324 4292111460 4291651680 4291323239 4291717217 4291322983 4291126627 4291979364 4290928996 4291980138 4292046441 4292110180 4291717218 4291455079 4291846750 4291979364 4291520096 4292373095 4291783272 4291586405 4291520869 4292242022 4291977831 4292439910 4291849577 4292109153 4292308056 4291783265 4291914339 4292045411 4291782248 4292110433 4292109415 4292111714 4291324268 4292046184 4291454564 4291455596 4292177250 4291782242 4291389291 4291063401 4291322984 4291590764 4291585636 4291783527 4291257437 4292110437 4291651168 4291650919 4291194211 4291326582 4291585118 4291324261 4291715678 4291914850 4291914336 4291520871 4292307302 4292046426 4291125351 4292177764 4291583331 4291586919 4291914335 4292045928 4291324268 4292243043 4291256162 4291717473 4290994789 4291650143 4290996337 4291651168 4291585377 4291257182 4291192419 4291716193 4290929514 4291847775 4291781994 4291651942 4291783008 4291388007 4291454813 4291192419 4291912037 4291126372 4291650656 4291191390 4291125087 4290732132 4290207335 4290403679 4289877598 4290006105 4289481818 4289414225 4290338914 4291126118 4291454819 4291980899 4292182901 4292247915 4292773492 4292840568 4292840055 4292840056 4292970614 4292905077 4292640881 4292640349 4292773752 4292246885 4292905333 4292444789 4292642421 4292380014 4292970096 4293100397 4292707184 4292970096 4292970355 4292574558 4292970355 4292970096 4292380269 4292838515 4292640094 4292380526 4293231213 4292380012 4292904822 4292577658 4292971124 4292837999 4293232759 4292313709 4292117610 4293173623 4293706905 4294102416 4294037668 4294037923 4294038694 4294038696 4294038420 4294101902 4293172860 4290339931 4288759134 4289742682 4289549680 4290009951 4290338144 4290273127 4290925651 4290208093 4290140512 4291125599 4290142818 4290928477 4291061098 4290206818 4290207853 4290142314 4290929252 4290798181 4290797926 4290798684 4291519582 4290535788 4290404190 4291256671 4290667109 4291256671 4290995039 4290469480 4290928989 4291191908 4291060068 4290994533 4291454563 4291126117 4291454046 4290468959 4291256927 4291257701 4291521388 4290271328 4288496467 4286719046 4284290634 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292969838 4292905332 4293035888 4293035645 4293232512 4293035132 4293036143 4292707184 4293100140 4293101686 4292706927 4293100397 4292970096 4292772720 4292575343 4292970353 4292707184 4293494636 4293167220 4292908411 4293235331 4293630070 4293563766 4293565560 4293563768 4293563770 4293431150 4293165164 4292507998 4292441451 4291320921 4290334811 4289085264 4289216333 4288626775 4289019213 4289348691 4289807957 4289676629 4290201429 4290136150 4290135894 4289545295 4290072667 4289480280 4289351004 4290595929 4289939789 4289546580 4290202963 4290005080 4289877086 4290531161 4289745245 4290860380 4290139999 4291188820 4291059809 4291190614 4290994791 4291323232 4291256932 4291191904 4291454815 4291125352 4291781476 4291520097 4292110437 4291914593 4291717218 4291454302 4292045921 4291454049 4291847268 4291586145 4291650907 4291914594 4291651682 4291979108 4292177508 4291585889 4291585888 4292111459 4292111459 4292176231 4292440151 4291652967 4292109158 4291914339 4291914859 4291717478 4292373095 4291520096 4292114027 4291127148 4291848799 4291717482 4292177507 4291781475 4292046185 4291585887 4291979108 4292045667 4291519840 4291125606 4292637029 4292109916 4290930544 4291782751 4291519841 4291453794 4291978078 4291193193 4291586668 4291979613 4292111980 4291715662 4291715943 4291257694 4291651425 4292045411 4291782762 4291780708 4291914858 4291846493 4291849569 4292175712 4291388775 4291783520 4292438630 4291783265 4291846750 4291912549 4291389022 4291519841 4291848544 4291387489 4290995045 4291848545 4291585634 4291255643 4291126372 4291781732 4291191644 4291061355 4292043364 4291126109 4291780709 4291651431 4291125598 4290994532 4291125598 4291192165 4291322462 4290076007 4290863463 4290205277 4290335579 4290465625 4290006617 4289480023 4289940569 4290860121 4291060324 4291980397 4291654259 4292183164 4292247914 4292511609 4292840311 4292776062 4292775791 4292772206 4292839798 4292838256 4292642421 4292839542 4292904303 4292970095 4293100139 4292971125 4292576105 4293034860 4293101680 4292904560 4293100397 4292970353 4292772720 4292970096 4292838257 4292574558 4292970355 4292838258 4292577389 4293101173 4292380012 4293100913 4292445549 4292772708 4292445806 4292577135 4292575079 4292774768 4293440896 4293970060 4294036384 4294038437 4294038180 4294037923 4294038698 4294103186 4293770869 4291658354 4289285210 4288695641 4289679194 4289418334 4290531930 4290338144 4290208350 4290337887 4290863462 4290206302 4290208354 4291059807 4289550692 4290207077 4291782237 4290731103 4290667356 4291060320 4290798940 4291388774 4291059295 4291519838 4290731615 4291454304 4291256927 4290863712 4291191136 4291454302 4291322975 4291323749 4291126373 4291322973 4291127147 4291125859 4291324265 4291126890 4291388511 4291717473 4290269787 4287705164 4284486211 4284095560 4284224322 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292706927 4293233268 4293232236 4292246638 4293101677 4292904303 4293034605 4293036147 4293036143 4292511092 4293101682 4293034861 4292772720 4292970095 4292970356 4292771934 4292772721 4292905333 4292774250 4293694323 4293694833 4293169278 4293565815 4293564537 4293565043 4293562989 4293236339 4293230957 4292506974 4291979103 4291586150 4290333271 4289085264 4288626775 4288623956 4289348177 4289349472 4289414741 4289544786 4289415257 4290201423 4289874265 4290595410 4289546328 4290071630 4290464858 4290070352 4289940052 4290596186 4289545039 4290007132 4290529872 4289811037 4290335836 4290794844 4290076001 4290666080 4291126374 4291060326 4291256927 4290992983 4291453531 4291780954 4291519588 4291779926 4291521376 4291715935 4291651169 4291256930 4292240737 4291520097 4290929770 4291914592 4291979108 4292177508 4291781733 4291651681 4291453538 4292110434 4291979364 4291846750 4291848297 4291914857 4292242022 4291848035 4292046180 4292109159 4292111971 4292045924 4292241761 4291980132 4291322976 4291848035 4291521126 4292370786 4291915369 4292307559 4291780957 4291586145 4291980393 4292045667 4291979363 4291585386 4291651680 4291913059 4291651439 4290928995 4292111202 4291454310 4291717483 4291913310 4291519330 4290994788 4291978594 4291127146 4291651424 4291717219 4291717474 4291651682 4292044644 4291586662 4291585631 4292179041 4291389030 4291455079 4291649124 4292045924 4291649379 4291846756 4291389542 4291454823 4292243299 4291454310 4291519072 4292241767 4291453537 4291585634 4291783008 4291125869 4291848544 4291388264 4291192420 4291780708 4291652200 4291452762 4291586407 4291587181 4291520096 4291651170 4291389022 4291717479 4291322974 4291060069 4291322463 4290075230 4290732392 4290926940 4290337118 4289810779 4290006885 4289483100 4289283925 4289286759 4290797149 4290930030 4292439143 4292180591 4292116338 4292577401 4292643192 4292971901 4292905081 4293101425 4292969838 4292774006 4292772462 4292969839 4293429100 4293035887 4292905332 4293037178 4292706669 4293035647 4292904302 4292904303 4292904560 4292772719 4292970095 4292706928 4293101680 4292970097 4292707187 4293099611 4292970355 4292182107 4293166961 4292117371 4292381042 4292116589 4292642670 4292182884 4292247919 4292313195 4292973446 4293705347 4294102947 4294037666 4294037409 4294038694 4294038694 4294038955 4293971855 4293830258 4290867314 4289414481 4289612633 4289679195 4289418334 4289877085 4290862945 4291322981 4290140766 4290272869 4290864738 4290601565 4291584863 4290140767 4290207078 4290140767 4290731360 4290731103 4290994272 4290075749 4290994783 4290732389 4290863973 4290666335 4291125087 4290929248 4291519839 4290403941 4291388511 4291125599 4291322974 4291518818 4291125342 4291455075 4291586668 4291914854 4291126624 4290137433 4286458182 4284748614 4284356925 4284291908 4284291907 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293233267 4292969597 4293166443 4293101682 4292708213 4293036144 4293034859 4292839027 4293297515 4292708213 4293035887 4292970096 4292772720 4292970099 4292707184 4293100398 4292970350 4293168506 4293366133 4293302399 4292973683 4293302397 4293628799 4293236592 4293236081 4293430900 4293299575 4292838496 4292899932 4292834143 4290992719 4289808216 4289348692 4288624723 4289281870 4288496207 4289412429 4289610579 4289676886 4290071384 4289283673 4290597467 4289284954 4290072154 4289352031 4290530380 4289545553 4290004820 4290004813 4289676632 4289414738 4289941084 4290337111 4290858324 4290664792 4291451227 4290535521 4291122266 4291125344 4291059552 4291125857 4291453533 4291780190 4291519580 4291979362 4291517786 4291519580 4292109928 4291716705 4292045157 4291585121 4292243043 4292111716 4292110183 4291388519 4292045924 4291651681 4291847519 4292308568 4291388520 4291847517 4291782506 4292111715 4291913572 4291913828 4292241766 4291849824 4291847780 4292636004 4292242264 4291715941 4292177507 4291915113 4291979618 4291849060 4292109416 4292110422 4291782763 4291847266 4292046440 4291059301 4291848553 4292175205 4291980650 4292111715 4292045410 4291454823 4292111971 4291912292 4291454301 4291847781 4291650142 4291717217 4292045668 4291848800 4292438888 4291388770 4291649118 4291783521 4292044644 4291782505 4292243308 4292111459 4291914083 4292242787 4292045668 4291389286 4292045156 4291847524 4291849056 4291716449 4291191142 4291913832 4291455853 4291913059 4291586398 4291519841 4291979621 4291388263 4291323486 4291585634 4291783009 4291584864 4291257955 4291257439 4291453025 4291519328 4291584866 4290994270 4292044900 4291192937 4291191908 4291060067 4291125861 4290666597 4291322206 4289616225 4289877341 4290466651 4289943388 4290073180 4290070613 4289415009 4290336859 4291192168 4291522417 4291654256 4292772207 4292510835 4292837740 4292972414 4293102199 4293036921 4292708211 4293101422 4292971124 4292510835 4293233015 4292839539 4293036916 4293298802 4293364859 4292970349 4292840053 4293429106 4293034604 4292970101 4292708470 4292970095 4292904304 4292904561 4292969310 4292772980 4292772464 4292577135 4292248429 4292969584 4292903791 4292773750 4292248428 4292970615 4291855209 4292247662 4292839018 4293241720 4293838215 4294036899 4294037666 4294038694 4294038694 4294038694 4294038698 4293968263 4292251494 4289810261 4289611362 4288828257 4289614942 4290008927 4290270292 4290730851 4290928480 4290272095 4290141542 4290732115 4290797665 4290862944 4290076764 4291256413 4291256415 4290143078 4290142043 4290731877 4291387999 4290798437 4290534238 4291322460 4291125862 4290731871 4290666079 4291257701 4291322975 4291125599 4291127146 4290928740 4291257181 4291586668 4291849318 4291651680 4290336607 4287179081 4284819793 4283895611 4284158526 4284291907 4284489033 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293035388 4292905587 4293035891 4292904303 4293035890 4293231979 4292970112 4293232235 4292839031 4292904558 4293034605 4292707185 4292773738 4292772720 4293100396 4292840052 4293429882 4292973680 4293300863 4293302389 4292974465 4293302132 4293302384 4293301617 4293235569 4293430389 4293494892 4293494125 4292442210 4292176218 4291321442 4290400602 4289150800 4288103258 4288628315 4289215822 4289151058 4289612122 4290069586 4290005850 4290464850 4289874773 4290006874 4289940826 4290006874 4289940057 4289806419 4290072668 4289416536 4289610827 4290201682 4289874258 4290334555 4290138713 4290727758 4290535258 4291122524 4291125081 4291059552 4291191392 4291518813 4291060321 4291191127 4291586148 4291255641 4291978592 4291322979 4291715934 4291321954 4291454305 4292243044 4291191911 4291780965 4291783776 4291650913 4291781220 4291846756 4291388769 4292175722 4291783520 4291979108 4291520352 4292044637 4291520610 4292109408 4291849578 4292437603 4292111971 4292043622 4291715428 4292045667 4291322982 4292373094 4291849321 4292242016 4291519069 4292109672 4291587173 4291782505 4292046183 4291848296 4291848297 4291585123 4291782499 4291979619 4291586662 4292044642 4292109414 4291388774 4292044899 4291979364 4292044900 4291849057 4291651425 4291454055 4291586145 4291847509 4292045670 4292177509 4291389278 4291585632 4292505445 4291650920 4292374380 4290798441 4291650656 4292046442 4292044894 4291453280 4292111979 4291585888 4292044900 4291781987 4291717216 4291322727 4291126884 4291978853 4291519323 4291126110 4292044390 4291126110 4291585633 4291584879 4291191660 4291651168 4290995300 4292043620 4291717473 4291388775 4291717990 4291454310 4290928739 4291126634 4290797148 4290666597 4290600288 4290927959 4289745252 4290402652 4289944172 4289418589 4289482341 4289545554 4290006885 4290075483 4291913593 4292310636 4292116849 4292443773 4292642675 4292970615 4292644478 4293299574 4292906367 4293036658 4292906622 4293102457 4292841080 4292971129 4292971889 4293561728 4293103727 4293364590 4292970351 4292970350 4292904303 4292904303 4293493353 4292904560 4292904560 4293034861 4293035120 4292903774 4293168241 4292116332 4292772465 4292705893 4292314222 4292511340 4292969328 4292707701 4292446323 4292511086 4292114278 4293237113 4293703302 4294100090 4294038184 4294038180 4294038694 4294038694 4294038697 4293971854 4293310607 4291461223 4289218648 4289679451 4289548380 4290005848 4290401116 4290339677 4289679965 4290272352 4290863461 4290665824 4290665568 4291717472 4290862944 4290665823 4290732134 4290140510 4290731876 4290733672 4290797406 4290599774 4291323493 4291191136 4290733146 4291257445 4290994533 4291322974 4291257439 4291191646 4291586150 4291586150 4291783270 4291850858 4291715934 4289742423 4286587719 4284616514 4284359751 4284752461 4284094524 4284687182 4284423496 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292904558 4292904303 4293297514 4292904560 4292904307 4292969325 4293232236 4292839024 4293230440 4293231484 4292970863 4293034861 4293100397 4292511350 4293231982 4293364858 4293168247 4292973442 4293302644 4293234558 4293300851 4293693306 4292907884 4293300605 4293431667 4293233268 4293167728 4292706161 4292572764 4291847516 4291584352 4290333015 4289281098 4288625740 4289280076 4288496464 4289151052 4289612116 4290071380 4289282125 4291055706 4289875029 4289873751 4290532187 4290069844 4289940056 4290071378 4289546586 4290201418 4290201683 4289479755 4290464084 4290270294 4290792788 4290665825 4291187034 4291123798 4291057493 4291454052 4290994016 4291257696 4291912032 4291453534 4291715167 4291913574 4291847013 4291453787 4291718249 4291519330 4291912286 4291979876 4291585889 4292307800 4292109416 4292110432 4292109671 4291783520 4291848294 4291520593 4292174952 4292242278 4292505702 4291454833 4292373335 4291914341 4291914848 4292307558 4291651177 4292112494 4291914856 4291915113 4291977831 4291651415 4292439911 4292374374 4291913829 4292109664 4291977062 4292373349 4291125868 4292438885 4291520352 4292177251 4292111459 4291980648 4291651439 4291980649 4291913570 4292046440 4291782762 4291781981 4291847523 4291847524 4291849056 4291848041 4292045412 4291651682 4291454561 4291387745 4292044900 4292111459 4291850603 4292243051 4292375649 4292505446 4291979107 4292044899 4291453280 4291521645 4291650655 4292044900 4291980131 4291979108 4291849313 4291715684 4291782241 4291651937 4291715684 4291781482 4291126109 4292174946 4291256418 4291979107 4291717472 4291520103 4291847016 4290930281 4291978083 4291520102 4291978851 4291323239 4291914080 4291191651 4290798700 4290600803 4291256671 4290599262 4290861917 4290203738 4290471529 4290005590 4290008154 4289547375 4289414227 4290337638 4291059551 4291918193 4292247669 4292051057 4292771947 4292382079 4293363575 4292710526 4292711795 4293233784 4293036667 4293035373 4293167219 4293561721 4292973435 4292970609 4292841589 4293168512 4293167218 4292969598 4293233267 4293037435 4292970350 4293035893 4292904558 4292903021 4293035118 4292968558 4292706928 4293102710 4292640880 4292510313 4292445037 4292315508 4292182124 4292183667 4292445037 4291919461 4292248430 4292639343 4293308023 4293839265 4294035852 4294037667 4294037923 4294038694 4294038694 4294038441 4294101900 4293172858 4290338912 4289545569 4289612633 4289482843 4289941595 4290338145 4290928736 4290861405 4290142556 4291321952 4290010973 4291125087 4290928736 4290272351 4290339420 4290732636 4291258482 4290076249 4290994536 4290799713 4290732388 4291322205 4290472564 4291585628 4291716961 4291257956 4291322471 4291913828 4291978850 4292046185 4291849319 4291127137 4289480532 4285733699 4284419651 4283831862 4284157260 4284291906 4284094783 4284877110 4284554309 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292904561 4292969837 4292709258 4293034603 4293233519 4292969069 4292970351 4293167737 4293167727 4292970351 4293034604 4293101682 4292707183 4292772463 4292905589 4293232499 4292842107 4292973426 4293103727 4293563000 4292777596 4293235566 4293366912 4293232754 4293628793 4293430905 4293100910 4292968540 4292507503 4292244847 4291125863 4290007389 4289349216 4288691278 4288560208 4289282643 4289741903 4289544788 4289808465 4289806926 4290070102 4290070101 4290532187 4289283416 4290005592 4290005336 4289349465 4290660947 4289742416 4289350999 4290005588 4290399322 4290268241 4290730078 4290729814 4290664535 4290535267 4291323234 4290468440 4291124568 4291584605 4291125857 4290861911 4292044897 4291716700 4291650405 4292109155 4291651163 4291912543 4291586402 4292110951 4292044900 4291782756 4291388518 4292177507 4291521126 4292046441 4291780963 4292175976 4291389542 4291781219 4291979363 4291979363 4291716191 4291781988 4292373094 4291193453 4292701529 4291847779 4292111715 4292242024 4292044128 4292109672 4291651427 4292242023 4291848029 4292373601 4291518307 4291717481 4292638561 4291258988 4292175206 4291717225 4291783273 4292109925 4291388511 4292111715 4292373350 4291520367 4291847266 4291914344 4291324012 4291322469 4291520359 4291717734 4291848800 4291716705 4291649637 4292110686 4291979364 4291980649 4291980135 4291980134 4291717741 4291980134 4291716968 4291848040 4291717990 4291455595 4291848291 4291848296 4291651439 4291848806 4291519073 4291716961 4291517796 4291912548 4291718246 4291717990 4291716459 4291454562 4291650651 4291322210 4291781477 4291519328 4291914090 4291717215 4291715946 4291322726 4291321953 4291978852 4291585639 4291059811 4290538348 4291191138 4290534751 4291253336 4290665054 4290927710 4289810786 4289875812 4290531416 4289416023 4289545814 4289811301 4290733164 4290864497 4291783789 4292772204 4292313484 4292708982 4292905074 4293036406 4293038723 4293168252 4293037181 4292841839 4293232506 4292971886 4292972419 4292973434 4293429369 4292973422 4293169530 4293035628 4292838767 4293035885 4292840052 4293233271 4293231226 4292904816 4292968556 4292904560 4293363308 4292182892 4292969585 4292575591 4292118388 4293361001 4292183667 4292707948 4292576119 4292445549 4292640626 4292116060 4292707181 4293965173 4293904524 4294037925 4294038180 4294038694 4294038694 4293973160 4294036882 4294032262 4292184951 4288429906 4289481552 4289547365 4290007643 4290336605 4290272100 4290270047 4290206560 4290665824 4291651167 4290863718 4290010715 4291520101 4290863462 4290667100 4290862686 4291060325 4290078819 4291256419 4290601321 4290732387 4291257186 4291126891 4291453024 4291322470 4292111976 4291520613 4292308844 4292243043 4291125855 4289675345 4285604426 4284354363 4284029001 4284422978 4284093515 4284687180 4284487740 4284355148 4284815677 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293035389 4293101684 4292904301 4293034859 4292577142 4293427817 4292972149 4293165931 4293167474 4293233266 4292904305 4292708216 4292970097 4292970095 4292970612 4292841582 4293365893 4293366643 4293495928 4293368438 4292580210 4293823859 4292972918 4293103728 4293298803 4293233530 4293559914 4292836718 4292967008 4292373862 4291257437 4290468458 4288759121 4288232527 4289216336 4288889423 4289085516 4289349208 4290201687 4290005331 4289942872 4290464857 4290005842 4290071124 4289939027 4290072663 4289676368 4289349454 4290007390 4290135632 4290069579 4289808723 4290336350 4290859098 4290141531 4290728020 4291190096 4291188572 4291124825 4291059809 4291125857 4291256157 4291519070 4291060064 4291387740 4291715941 4291257950 4291913061 4291782245 4291781214 4292177508 4291388000 4292043367 4291652710 4291977575 4292044899 4291782761 4292044900 4291913827 4291849057 4291651169 4291583588 4292110183 4292111972 4291781220 4291913827 4292109414 4292176743 4291979107 4291781727 4291914325 4292308073 4291715683 4291848548 4291649891 4292373607 4291125607 4292044898 4292111971 4291847021 4292109664 4291716191 4292043361 4291718496 4292309353 4291848298 4291650921 4291388000 4292110435 4292044643 4291392624 4291783269 4291519846 4291980128 4291454822 4291980138 4291257185 4291978079 4291454562 4291846756 4291585887 4291848808 4291849325 4291851374 4291786867 4292373603 4291585903 4291716958 4292111977 4291847523 4291322470 4291651679 4292047206 4291322471 4291520097 4291520097 4291912548 4291322470 4291520098 4292110687 4291978837 4291191145 4291190626 4291585121 4291322984 4291715172 4291914085 4291454560 4291979108 4291519586 4291913310 4291191646 4291126629 4291124571 4290996345 4290665828 4290672504 4290729819 4290138459 4290337374 4290532697 4289874017 4290073188 4289414486 4290532698 4290139483 4291783787 4291982436 4292118392 4292837482 4292446073 4292970869 4293234044 4293038715 4293037691 4292973177 4293234047 4292839281 4293036666 4293234045 4292970615 4293039723 4292970874 4293364344 4292841088 4293231466 4292840056 4293296762 4292970349 4292643707 4293295976 4292708470 4292774005 4292839542 4292706415 4292511600 4292510838 4292969328 4292707434 4292250745 4291855209 4292510829 4292247918 4292248174 4292444266 4292311911 4293171579 4293837704 4294036898 4294037668 4294037923 4293972902 4294236583 4293973143 4293905551 4293830257 4290079594 4289414488 4289617506 4289414743 4290404706 4290333527 4290273642 4290928223 4290141024 4290796896 4290076764 4291323500 4290534239 4290667099 4290733417 4290208353 4290077284 4291322211 4290602604 4290603370 4291323496 4291125859 4291979615 4291127401 4291717732 4291783534 4291981668 4292047724 4291782501 4289084752 4286193734 4283700795 4283698239 4284622155 4284097358 4284357438 4284487750 4284160837 4284947520 4284488516 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292904559 4292707183 4293100394 4292970110 4293429104 4292773230 4292969598 4293233261 4292839797 4293035887 4292903550 4293036139 4293034108 4293034602 4292839538 4293430918 4293366635 4292581505 4293432958 4292643182 4293103990 4292776309 4293038453 4293168506 4293101683 4293299322 4293035373 4293492586 4292116591 4292373606 4291717218 4289811297 4288627537 4288755276 4288821840 4288693587 4289741898 4289938511 4289872468 4289482069 4290007394 4289873484 4290530644 4289479755 4290596180 4289350736 4290071125 4290005583 4290004814 4290005595 4289940046 4290398291 4290334812 4290203476 4290792528 4290732901 4290531931 4291256159 4291059032 4291387487 4291519323 4291649371 4291780961 4291060063 4291388515 4291913310 4291978080 4291651937 4292045669 4292175202 4291520609 4291847524 4291849312 4291455079 4291849312 4291781219 4291518570 4291257949 4292175207 4291586401 4291846750 4292112228 4292111971 4291979364 4291781476 4291914339 4292046179 4292043622 4291783786 4291781989 4291979360 4291715679 4292175457 4291323233 4292308071 4291845467 4292044898 4291586160 4291518044 4292308071 4292112229 4292107353 4291322979 4292045924 4291978088 4291256410 4291715173 4292110949 4291389790 4291650405 4292108890 4291651937 4291913317 4291453793 4291781476 4291126884 4291780703 4291323743 4291715173 4291651936 4292176493 4291848296 4291454820 4291914861 4291256937 4291389285 4292110433 4291258477 4291454047 4292044899 4291323244 4291847267 4292373351 4291455069 4291717218 4291651938 4292110686 4291323758 4291583320 4291124835 4291388515 4291192159 4291649116 4291782499 4291585116 4291519580 4291715423 4291519586 4291518047 4291715423 4291847780 4291585122 4291518818 4291125860 4290600548 4290666596 4290665050 4290732649 4290861917 4290335578 4289286503 4290075229 4290071137 4289481303 4290008166 4289745755 4291060840 4291848554 4292117119 4292379778 4292511608 4292839024 4292710530 4292971387 4292644737 4293431932 4293166959 4293234048 4292840295 4292971128 4293234045 4292645756 4293232499 4293166956 4292907383 4292971380 4293035886 4292707183 4293297772 4292904303 4293034861 4292970095 4292968300 4292182892 4292904048 4292707434 4292706416 4292511597 4292116846 4292772207 4292837745 4292182381 4292445294 4292445551 4292442469 4292246633 4292576106 4293636232 4293970315 4294036367 4294038697 4294038694 4293972902 4294171048 4294037926 4293576337 4292711010 4289612885 4289544789 4289484640 4290532187 4289811286 4290338138 4290206561 4290271319 4290075489 4290860115 4290797664 4290996316 4290863721 4290732635 4290140511 4290797669 4290665566 4290733925 4290865258 4290472305 4291455334 4290930030 4291652202 4291849325 4291783533 4292113260 4292241761 4288823116 4285143621 4284490573 4284355660 4284163149 4284488775 4284556623 4284291908 4284159300 4284750143 4285404726 4284947780 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293166701 4292970097 4292706428 4293035644 4293102199 4293363570 4293363562 4292969598 4293233266 4293035133 4293036139 4293035389 4292904300 4293037177 4292972414 4292973682 4292973445 4293431923 4292974196 4293039228 4293103477 4293627007 4292841590 4293231209 4293101934 4293299060 4293363572 4292837213 4292573536 4292571486 4291256414 4290400347 4289348681 4288626001 4288690253 4289348685 4289085518 4289740621 4289676875 4289415002 4290530386 4289873491 4289874522 4289806163 4290007126 4290005331 4290135889 4290005839 4289610828 4289415246 4289939029 4290334295 4290334799 4290270815 4290728284 4290661961 4291191651 4291059031 4291125604 4291058255 4290993498 4291125081 4291782743 4291585891 4291714395 4291913830 4291123801 4291584867 4291520856 4291586402 4292175201 4292045156 4291650405 4291649630 4291781476 4292175719 4291322207 4291322727 4291847011 4291912548 4291584100 4292109665 4291781220 4291847013 4291584094 4292242024 4292374631 4292439654 4291911521 4291715931 4292109668 4291781470 4291782501 4291781213 4292109412 4292112760 4291653482 4292373092 4291978599 4291977057 4291715934 4292110436 4292043100 4291977572 4291779411 4291914081 4291519834 4291452506 4292108893 4291452517 4291519586 4291715173 4291519579 4291780959 4291519586 4291520098 4291780703 4291520355 4292108635 4291256162 4292242526 4291453536 4291716457 4291848807 4291848807 4291848296 4292109414 4291651679 4291454311 4292175974 4291389542 4292111203 4291388001 4291978085 4291716191 4291648860 4291715423 4291715172 4291717218 4291780959 4291782498 4291583583 4291322467 4291585122 4291321954 4291978335 4291518048 4291781983 4291322467 4291452248 4291915116 4291585121 4291321435 4291125859 4290536042 4291190619 4290996602 4290731355 4290137700 4290399832 4290007899 4289415513 4289481560 4289549415 4289353319 4290404198 4291060582 4291916397 4291655541 4292706157 4292707951 4292774023 4293103744 4292711032 4293103489 4292840315 4293037956 4292974191 4293232002 4293036913 4292906623 4292904817 4293167219 4293036923 4292905578 4293234555 4293035886 4292706927 4292970098 4292904303 4293036147 4292969842 4292774005 4292838255 4292903791 4292248429 4293101424 4292509802 4292379758 4292706672 4292577133 4292247918 4292641130 4292443751 4292116854 4291853675 4292245864 4293039473 4293311372 4294101903 4294037667 4294038694 4293972902 4294170534 4294170793 4294169234 4293702522 4291132275 4289348695 4289612371 4289417053 4290008671 4290270558 4291127645 4290272352 4291584862 4290076006 4290600031 4291585375 4290534239 4290864733 4291256160 4290667356 4290928478 4290077031 4291389289 4291125345 4290995823 4291126375 4291258727 4292374122 4292047974 4291716708 4289412428 4285800275 4285283939 4283833164 4283830079 4284158775 4284552005 4284223038 4284420914 4285140807 4284748854 4285015120 4285472844 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293362281 4292708468 4292969341 4292969066 4293363570 4292970357 4293299312 4293167726 4292970355 4292905586 4293035898 4292969852 4293035884 4292971129 4293561975 4293234555 4293759606 4292973434 4293365628 4292973937 4293364084 4293101683 4293036920 4292841344 4293364340 4293299059 4293101941 4293230957 4292444260 4292374121 4291319892 4289938769 4289477450 4289215310 4288098379 4288754766 4289151565 4289742674 4289872469 4290005843 4290464077 4290399578 4290463825 4290008927 4289348695 4290071130 4289414995 4290070356 4290136151 4290135122 4290399566 4290924883 4290268757 4290266700 4290729045 4290730072 4290535265 4291125602 4291057492 4291191130 4291780699 4291125857 4291648865 4291192677 4291519586 4291912549 4291716191 4291322984 4291322210 4292304229 4291586657 4291257192 4291454043 4292109154 4291847780 4291847779 4291256934 4292045928 4291650409 4291455334 4291979363 4291979620 4291781477 4291846997 4291649633 4292176217 4291781982 4291519587 4292109921 4292109929 4291980373 4291584102 4291584100 4292308070 4291520623 4291717478 4292701031 4291718245 4291980639 4291782244 4292043362 4291845209 4291387233 4292108887 4291650402 4291909985 4291518562 4291781466 4291452512 4291913829 4291453792 4292108647 4291519842 4291387746 4291387746 4291979104 4291191904 4291387484 4291585890 4291192678 4291321691 4291782507 4291322720 4291519846 4292111976 4291388517 4291980130 4292174950 4291652454 4291782505 4292110177 4291390317 4291584858 4291322210 4291454049 4291979109 4291257185 4291979876 4291387489 4291388513 4291585890 4291519843 4291780952 4291322979 4292044645 4291519330 4291323743 4291780959 4291715423 4292110950 4291321946 4291453282 4291126628 4291061099 4291125084 4290535528 4291125601 4290602865 4291321179 4289745244 4290399833 4289875546 4290006618 4290004564 4290532183 4289617519 4291518831 4291651191 4292309095 4292116848 4292576144 4292840818 4293297534 4293036661 4292972412 4293103484 4292448114 4293431421 4293166465 4292905074 4292905074 4293036921 4293232755 4292905332 4293035887 4292970094 4293233269 4293035890 4292708213 4293101426 4292904303 4292904302 4293101429 4292772719 4292642421 4292707956 4292444788 4292773493 4292313965 4292969328 4292380787 4292182124 4292641911 4292445550 4292312167 4291853933 4291983968 4292510062 4293504887 4294101395 4294036385 4294038180 4293972902 4294170534 4294368678 4293972648 4294101900 4292976758 4289484124 4289481301 4289940560 4289943135 4290469473 4289614173 4291192678 4290667879 4290668648 4291387998 4290535269 4291126111 4290665312 4290667613 4290598236 4290995820 4290077280 4291125603 4290666852 4291323234 4292308322 4292045671 4291915632 4292109400 4288823890 4285733444 4283633466 4284620619 4284421184 4283960648 4284615992 4284225605 4284814136 4284684864 4285337141 4285406789 4285931594 4285207093 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292971899 4293035889 4292970349 4293429100 4292970351 4293101941 4293298028 4293100651 4293166979 4293035891 4292970349 4293232754 4292578687 4293824887 4293235575 4293303923 4292975227 4292973178 4293302126 4293168001 4292840299 4292970350 4293035890 4292905074 4292972138 4293298811 4293102702 4293165422 4292835918 4292307046 4291518027 4290334543 4289083985 4288691021 4288690510 4289150800 4289678159 4289805906 4289481037 4290071130 4289283667 4290005330 4289874265 4289939544 4290531931 4290005324 4289547869 4289414995 4290071129 4289545297 4289939795 4290335325 4290332492 4290269533 4290730584 4290664278 4291122780 4291124824 4291125602 4291058775 4290994273 4291323233 4291454291 4291191904 4291584860 4291519581 4291913568 4291780955 4291585123 4291126367 4291978847 4291912542 4291978341 4291520353 4291256935 4291848291 4292504678 4290733423 4291780450 4291454304 4292439143 4291716451 4292175463 4291980133 4291651937 4291388002 4291650148 4292177005 4292110688 4291912550 4291912546 4291977569 4291781726 4292305764 4292043359 4291586661 4292308842 4291521649 4292110955 4291978604 4291845729 4291452767 4291977316 4291517528 4291190879 4291190102 4291648851 4291125343 4291583834 4292108642 4291520616 4291454049 4291583577 4291060320 4291387997 4291583578 4291190365 4292044896 4291321954 4291453276 4291717986 4291650147 4291782240 4291585632 4291257190 4292108901 4291651695 4291849064 4291847009 4292111976 4291455595 4292111202 4291520872 4291585115 4292108392 4290994526 4291650658 4291584865 4291060836 4291454055 4291387745 4291518047 4291913063 4291453275 4290994527 4291780959 4292174946 4291124834 4291124833 4291979620 4291322984 4291388513 4291453282 4290993758 4291126118 4291123804 4291125598 4290533991 4291322720 4289611864 4290862944 4290923350 4290400344 4289876068 4290335339 4290797923 4290995047 4291914601 4292049533 4292116591 4292575608 4292642694 4292774275 4292708485 4293234043 4292972417 4293102972 4292970368 4292907628 4292709242 4293298289 4292709241 4293036921 4292708212 4293233007 4293167734 4292970354 4292971113 4293297516 4292511350 4292970093 4293101684 4292708213 4292968300 4292971637 4292642164 4292904819 4292643451 4292707177 4292248429 4292576880 4292969584 4292379756 4292247918 4292313967 4292312425 4292378219 4291917920 4292775789 4293837452 4294101903 4294037669 4294038694 4293972902 4294104742 4294170790 4294104236 4293770608 4291594105 4289214796 4289483102 4290072923 4289811806 4290928216 4290205783 4290140769 4290732892 4290798181 4290666341 4290667357 4290732893 4290665312 4291454821 4290206813 4290666341 4291454820 4291388253 4291258473 4291455084 4292245101 4290797153 4289478736 4285928253 4283699015 4284548165 4284488252 4283898183 4284421701 4283831863 4284879433 4284619070 4285013062 4285077566 4285538895 4284421178 4285148242 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292970350 4293167731 4293166972 4292969854 4293167476 4293560689 4293101941 4293167476 4293167474 4292971378 4293364602 4293168497 4292972923 4292907891 4293300099 4293301379 4293301366 4293300861 4293693561 4293038192 4293167215 4293233011 4292707458 4292839298 4293561971 4293430644 4293233526 4293560172 4292770405 4292504408 4291125596 4290333268 4289151053 4287969870 4289279050 4288430928 4289544018 4289415000 4290003540 4289349721 4290595928 4289811550 4290532696 4289544776 4289941084 4290005587 4289676374 4290201681 4290006615 4290070349 4289874266 4290333528 4290334548 4290267474 4290728788 4290665313 4291124319 4291124825 4291059808 4291191649 4291320922 4291126113 4291256164 4291649119 4291783523 4291321177 4291519587 4291387746 4291323743 4291585634 4291322722 4291847262 4291125609 4291582811 4291913573 4291913316 4291453536 4291520614 4292045923 4291913828 4290994022 4291914346 4291584611 4291979363 4292109671 4292175463 4291389024 4291847779 4291977062 4291978860 4292109919 4292043879 4291454817 4291847011 4291192428 4291848808 4291915112 4292109156 4291914338 4292046442 4291586657 4291519586 4291518298 4291584092 4291582552 4291649885 4291255637 4291715170 4291388254 4291190879 4291124057 4292111205 4291715429 4291781221 4291780959 4291519837 4291453539 4290994528 4292240739 4290797148 4291976802 4291914345 4291324012 4291323494 4291583848 4291520869 4291586405 4291322987 4291980910 4291257444 4291389547 4291715683 4291388263 4291059806 4291586663 4291453282 4291321955 4291782496 4291388263 4291650657 4291782497 4291715424 4291715673 4291125609 4292044644 4291387746 4290928990 4291847525 4291781732 4291520353 4291715172 4291978852 4291783009 4291914337 4290994015 4291124060 4290534246 4291255388 4290075745 4290862174 4290793560 4290270555 4289877609 4289875031 4290336352 4290733180 4291060325 4291917422 4292307557 4291986305 4292838781 4292642415 4292970368 4293100666 4293036655 4293103746 4292643446 4293102454 4292774023 4292773487 4293101960 4292707952 4293430137 4292970350 4292970351 4293166187 4292970358 4293035889 4293035891 4293100138 4292903806 4292903548 4293101677 4292904816 4292968043 4292839540 4292643194 4292642666 4292969844 4292905076 4292248428 4292904047 4292574832 4292445549 4292246375 4292312425 4292312683 4291982944 4292311657 4293504633 4293838219 4294037395 4294038185 4293972906 4294368935 4294170276 4293972903 4294235305 4293308012 4290273374 4289348942 4289482841 4289941592 4290927711 4290139743 4290994263 4290729821 4290863975 4291060569 4290861150 4290667101 4290732635 4290666859 4290666340 4291322462 4291126116 4291323491 4291127145 4292113245 4290993246 4289545037 4285600060 4283893820 4284354876 4284488509 4284420414 4284685380 4284420669 4284619589 4284619069 4285208638 4285143359 4285077823 4285338679 4284948037 4285275463 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293166443 4293165690 4292970109 4293362278 4293102198 4293100394 4293167221 4292971379 4293166962 4293366143 4293101424 4293169029 4293301107 4293695614 4293302133 4292975482 4293366900 4292974202 4292907895 4293561455 4293167214 4292971643 4293035885 4293167469 4293299061 4293233262 4293300074 4293099628 4293164399 4292637008 4291453272 4290529112 4289217610 4289282129 4288625744 4289545551 4289085522 4289282894 4289742674 4289871948 4289808985 4290530135 4289810011 4290006876 4290008415 4290134864 4289611089 4289611083 4289676632 4289545297 4290465107 4290268243 4290333266 4290269784 4290729823 4290596426 4291124055 4291123286 4291125345 4290994274 4291584862 4290927704 4291518299 4291453533 4291126368 4291780960 4291783266 4291321954 4291912798 4292109160 4291717473 4290929509 4292109401 4290928992 4291781726 4291454568 4291520097 4291914083 4291977831 4291782755 4292175463 4291781213 4291782244 4292110696 4291913827 4292109670 4292175462 4291192166 4291848547 4291782754 4292177004 4291387497 4291649636 4292175712 4292042854 4292175461 4291716194 4291717225 4292373607 4291518551 4292238687 4291651693 4291911511 4291518555 4291584098 4291125335 4290994531 4290927959 4291715165 4291254859 4291584098 4291780959 4291060063 4291190370 4291454564 4291846496 4291453534 4291714906 4291060320 4291323233 4291190620 4291519328 4291716713 4291978594 4291980393 4291323237 4291387232 4291389029 4291521129 4291979106 4291520612 4291913315 4291585120 4291190887 4291651425 4291387484 4291979093 4291651179 4291650657 4290994526 4291585896 4291585122 4291518042 4291651425 4291323496 4291060063 4292240739 4291124827 4291585378 4291124577 4291979364 4291388263 4290928738 4291256691 4291387233 4291059808 4291125600 4291124318 4290073428 4290926430 4290202465 4290335332 4289873748 4290333270 4290334820 4290141019 4291126632 4291520127 4291783529 4291653998 4292444283 4292575355 4292446328 4292970864 4292972413 4292708230 4293299830 4293036661 4292970117 4292775032 4292970608 4292577401 4292906879 4293232755 4292839802 4293233269 4293231724 4292904794 4292905334 4292773748 4293166957 4292708211 4293035390 4293100139 4292316274 4292969584 4292775291 4292969583 4292971870 4292970373 4292837996 4292904830 4292576116 4292183665 4292446076 4292116340 4292444522 4292375640 4291917151 4292770672 4293571190 4294100851 4294037122 4294038145 4293972372 4294172085 4294368676 4293973161 4294365838 4292780456 4289943935 4289678968 4289877626 4289875801 4290928472 4290730592 4290139743 4290730838 4290600033 4291062108 4291060320 4290207334 4290733409 4290863458 4290666852 4291192424 4290996078 4292309097 4290796644 4289745503 4286194522 4284024658 4284552024 4283895639 4284752715 4284357954 4284619588 4284484668 4285080909 4285142589 4284882501 4285338680 4285143359 4284683320 4285340735 4285277777 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292971897 4292970355 4292970349 4292970354 4293363311 4293168762 4292972143 4293364345 4292971127 4292971646 4293169011 4292776058 4293301627 4293235316 4293236350 4293365371 4293235573 4293365638 4293302122 4293102192 4292970354 4293233011 4293035890 4292970351 4293299060 4293299067 4293297773 4293231214 4292376399 4292702802 4291254102 4289939531 4289348683 4288099917 4288102992 4289084751 4289546066 4289415000 4289674832 4290007645 4290726230 4289808211 4290529875 4290004819 4289414733 4290071118 4290007390 4290200657 4289807691 4290332753 4290200660 4290529616 4290269275 4290205022 4290728787 4291254878 4291122781 4291123798 4291060066 4291385932 4291321951 4291387487 4291322455 4291125857 4291649370 4291780954 4291520098 4291519586 4291715429 4291584351 4292175457 4291715941 4291454042 4291979360 4291452518 4292108641 4291976796 4291716197 4291847780 4291389542 4292176230 4292175720 4291781470 4291518553 4292176232 4291389798 4291847779 4291847779 4292109158 4291452776 4291650918 4291847010 4292175713 4291782244 4291257440 4291519337 4292702057 4292242277 4291256169 4292108904 4291650912 4291845717 4291452770 4291584091 4291584091 4291190878 4291320411 4291322207 4291320916 4290863458 4291714911 4290994528 4291651427 4291849061 4290992206 4290994275 4291059031 4291124575 4291321950 4291518298 4291256157 4291781733 4291585637 4290863977 4291322206 4292046703 4291323237 4291388771 4291848824 4291455592 4291586934 4291520101 4291780707 4291651686 4291190887 4291454055 4291126885 4291978851 4291322209 4291781220 4291583588 4291192159 4291781216 4291322210 4292044639 4291322204 4291322203 4291583846 4291519586 4291979365 4291715173 4291257438 4291126371 4291715690 4290928735 4291386970 4291058526 4291122779 4291321438 4289613659 4290335835 4290272094 4289940576 4290990937 4290206044 4290732647 4290993755 4292307041 4292111738 4292180075 4292707453 4292576626 4292510321 4292904322 4292380278 4292970864 4292970113 4292711043 4292970111 4293166699 4292775291 4292970867 4293101165 4292905332 4293101425 4292969581 4292512380 4293101426 4293298547 4292577914 4292576628 4293101425 4292905586 4292642933 4293362298 4292511349 4293363048 4292771708 4292839285 4292839282 4292839541 4292509038 4292183922 4292773493 4292772206 4292246887 4292706675 4291982943 4291852140 4292114796 4293633142 4293838475 4294037672 4293972391 4294170791 4294104751 4294368419 4294170533 4294038182 4293835398 4291065708 4289281885 4289547089 4289417309 4290335581 4290925139 4290140761 4290731873 4290863199 4290798181 4291125087 4291387998 4290535513 4291062134 4291191393 4291521132 4292243305 4291783266 4289349964 4285796669 4284223029 4284288067 4284156235 4284224313 4283963979 4285409102 4284356931 4285668931 4284817484 4285469503 4285473357 4285077565 4285341259 4285078853 4285538893 4284945218 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292969338 4293167475 4293167221 4293167475 4292972159 4292972664 4293364344 4293298807 4293169285 4293103212 4293300357 4293694070 4293171573 4293628530 4293693305 4292844147 4293759599 4292843368 4293693297 4293100396 4293166443 4292969598 4292839794 4293363314 4293299054 4293233262 4293496688 4293165677 4292900704 4292504408 4291453529 4290332757 4289151821 4288099918 4289279050 4289085520 4289478735 4289806417 4289872724 4289610833 4289940302 4289871955 4289415252 4289546324 4289546074 4289480788 4289741904 4289480787 4289676375 4290007388 4289349466 4290399315 4290269275 4290859604 4290728283 4290072407 4291256922 4290531155 4291125858 4291057750 4291058527 4291124568 4291191649 4290994015 4291321693 4291060319 4291388521 4291714395 4291716449 4292109144 4291849323 4291454817 4291911261 4292108893 4291518298 4291781990 4290797151 4291124831 4292109147 4291914084 4291386468 4291386973 4292371564 4291977561 4291912799 4291321953 4291322726 4291979620 4291191392 4291914855 4291652474 4291848551 4291584867 4292175719 4291649893 4292043104 4291453539 4292109927 4292175712 4291386981 4291322460 4292044132 4291716448 4291583835 4291321690 4292042856 4291190356 4291320160 4290929767 4292107359 4291191658 4291717203 4291387742 4291452757 4291059291 4291059288 4291125603 4291059288 4291059032 4291191649 4291125856 4291453276 4291388520 4291389029 4292045417 4291322468 4292110696 4291256938 4290799729 4292045671 4291061869 4291388261 4291584361 4291191143 4291585888 4291782250 4291913309 4291847780 4291126110 4291978340 4291519841 4291124834 4291781209 4291583840 4291124828 4292175208 4291323240 4291976796 4291519580 4291518048 4291781208 4291388514 4291847275 4291190619 4291321177 4291582564 4291060320 4291122520 4290601834 4290795867 4290205789 4290859352 4290989398 4289678936 4290267999 4291059055 4291190641 4291126638 4292111993 4292179563 4291590256 4292116337 4292577657 4292707697 4292906367 4292446072 4292773746 4293363824 4292775031 4292577657 4292837741 4292970868 4292905333 4292970868 4292905589 4292510836 4293232493 4292708212 4292905339 4293166957 4292576885 4293101684 4293035390 4293231978 4292708468 4292772460 4292970629 4292773221 4292642165 4292642164 4292839541 4292904047 4292182380 4292576374 4292576630 4292246631 4292248431 4292312939 4292377193 4292311128 4292050024 4293834115 4293904267 4294038695 4293972901 4294170543 4293908145 4294172082 4293973158 4294233491 4292909944 4289681749 4289347657 4289611353 4290007644 4289682010 4291450973 4290664541 4290863456 4290732133 4290667099 4290798698 4291126121 4291980132 4291127145 4292505700 4291125087 4288362575 4285798976 4283697981 4284157502 4284157245 4284356932 4284292164 4284619072 4284619597 4285013056 4285013830 4285536322 4285078076 4285144390 4284553277 4285142588 4285277776 4284618812 4284682813 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292972930 4292971122 4292972142 4292970094 4292971385 4293298802 4293364345 4292971886 4293103217 4293300350 4293302642 4293236351 4293430391 4293629055 4293170288 4293496175 4293235053 4293694064 4293233007 4293299324 4293167470 4292970092 4293169023 4292971379 4293298804 4293299067 4293299567 4293033580 4292443749 4292374379 4291320654 4290334288 4288885323 4288753992 4288690767 4288492877 4289612108 4289151828 4289874263 4290135882 4290529876 4289416797 4289742155 4289480782 4290071386 4289676368 4289742167 4289480793 4289480787 4290201431 4289610825 4290399573 4290267737 4290204245 4290729566 4290730327 4290533728 4291123541 4291125602 4291124062 4291124062 4290468696 4291255389 4291192422 4291125856 4291519076 4291453276 4291782756 4290796374 4291453284 4291520353 4291780709 4291584607 4290994785 4291648599 4291322466 4291585890 4291979877 4291650404 4291454561 4292046180 4291978081 4291716964 4291848032 4291124828 4291519585 4291781738 4291453793 4291913566 4292175462 4291584615 4292043621 4291584874 4291847006 4291454043 4292043873 4292045413 4291386717 4291977825 4292043361 4291452767 4292043357 4291518042 4291322461 4291847526 4291190877 4291843928 4291388517 4291255386 4291255893 4291320674 4291256415 4291715169 4291516509 4290992470 4291582046 4291058511 4291124064 4291125601 4291059809 4291125856 4291256414 4291387739 4292043876 4291125350 4291257452 4290929255 4291455338 4291848301 4291585374 4291388774 4292176484 4291387744 4291060062 4292044645 4291322720 4291715941 4292176231 4291913572 4291452516 4291715428 4292044901 4291322210 4291388002 4291453538 4291124833 4291583583 4291715424 4291913831 4291715672 4291452518 4291519585 4291781220 4291256162 4291321955 4290994527 4291124059 4291059059 4290664537 4291125876 4290208104 4290333281 4289678680 4290791268 4290202720 4290599514 4291126113 4290798957 4292308581 4292573564 4292050046 4292706412 4292378237 4292510835 4292707442 4292511609 4292904816 4292774278 4292381564 4292972413 4292773490 4292775290 4292969581 4292708213 4293297258 4292971127 4292315002 4292969844 4293101422 4292904560 4292968556 4292772719 4292904558 4293233271 4292708211 4293364597 4292706668 4292971388 4292969844 4292838255 4292838255 4292838512 4292575089 4292508773 4292772464 4292640882 4292247146 4292311657 4291983199 4292375912 4291785565 4293629310 4293640312 4294036642 4293973159 4294368932 4294170286 4293973424 4294172082 4294038697 4294297981 4291724639 4289085015 4288824911 4289483101 4290530906 4290138195 4290207330 4290795869 4290141023 4290731359 4290667113 4290535528 4291126632 4291849581 4291126626 4288429646 4286061119 4283500871 4284685385 4283700303 4284356676 4284091196 4284423494 4284885837 4285148756 4285540182 4285474122 4285278545 4284948300 4284751177 4285210440 4285076800 4284224074 4284748348 4284751944 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293561725 4293102974 4293364339 4293101684 4293101683 4293497209 4292970871 4293168772 4293300597 4293301122 4293300867 4293235566 4293235318 4293233012 4293430639 4293431152 4293038957 4293233264 4293233520 4293494897 4292970100 4293365108 4293298305 4293101683 4293496430 4293299060 4293100653 4293231470 4292900173 4292570207 4290927955 4290591561 4289152334 4288099148 4288688971 4289414227 4288888143 4289676372 4289676374 4289941853 4290135888 4289676631 4290003534 4290201687 4289610832 4290071117 4289415252 4290201686 4289873233 4289676624 4289415004 4290070347 4290858062 4290137174 4290730584 4291188052 4291123541 4291125859 4291124567 4291060066 4291649115 4291059809 4291191648 4291059552 4291125079 4290993496 4290927704 4291846752 4291846752 4291060318 4291453026 4291192159 4291649376 4291256157 4291190877 4291583845 4291518046 4291322209 4291845735 4291452509 4292043624 4292110944 4291977575 4292043105 4291715423 4292176487 4291454048 4291715428 4291649636 4291650659 4291716969 4291584099 4292046179 4291847012 4291845736 4291714663 4292175712 4291387754 4291845990 4291977831 4291845992 4291845986 4291584357 4291976796 4291125859 4290862941 4291125343 4292108884 4291584092 4291321431 4290991438 4291056973 4291060324 4291058511 4291058785 4291191384 4291058786 4291124048 4291125083 4291123029 4291387999 4291515995 4291717219 4291060836 4291716961 4291651167 4291062127 4291912295 4291389802 4291125868 4291651423 4291322977 4291584362 4291847268 4291388512 4291256679 4290994525 4291913316 4291322726 4291716194 4291781220 4291124827 4291781732 4291781732 4291387745 4291650914 4291585116 4291519837 4291518041 4291256931 4292109409 4291716197 4291190625 4291321954 4291321954 4291582563 4291124574 4290072409 4290730846 4290664290 4290860120 4290204762 4290926683 4290204260 4290859350 4291189346 4291125105 4292372066 4291718009 4292243561 4291786596 4292510079 4292116335 4292576371 4292709242 4292577144 4292513149 4292838528 4292839280 4292970113 4293168248 4292576371 4292774005 4293297518 4292708469 4292969844 4292969838 4292837999 4292774005 4292838255 4292575600 4292838512 4292772718 4293100925 4292971123 4292708213 4292970094 4292772462 4292577141 4292838255 4292445559 4292772207 4292117358 4292640096 4292183152 4292246889 4292246618 4292309344 4292377450 4292310374 4292310119 4292378458 4293833091 4294102672 4294037413 4293972901 4294170543 4294171568 4294369714 4293972903 4294167695 4293505923 4290078050 4289544785 4289612891 4289351772 4291056218 4290335579 4290925914 4290206310 4290797151 4290600547 4291455336 4291390058 4291126626 4289347656 4285733959 4283897156 4284222780 4283962439 4284550217 4284683843 4284159300 4284947006 4284750408 4285340998 4284947264 4284750143 4284946755 4285471295 4284814391 4285272379 4284685118 4284746814 4284551493 4284748605 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292970092 4292971385 4293364345 4293299065 4293101683 4293364338 4292840567 4292974201 4293693828 4292909169 4293301893 4293430381 4293496439 4293232492 4293232493 4293299312 4293298030 4293296747 4293232237 4293496437 4293101940 4293100395 4293364857 4293101684 4293496180 4293298805 4293102192 4292968302 4292441423 4292373862 4291189848 4289874511 4288952398 4288754764 4288754507 4288561999 4289216594 4289414743 4289546317 4290201430 4289611089 4289349460 4290596435 4289940057 4289414995 4290007133 4290135632 4290005844 4289676625 4289676625 4290007376 4290004562 4290857805 4290860124 4290072663 4290663772 4291124575 4291124825 4291124825 4291057750 4291057493 4291191649 4291125599 4291125857 4291912289 4291649370 4291321950 4291190622 4291583839 4291584363 4291783522 4291190364 4291584608 4291781216 4291976796 4291650916 4292108647 4291454048 4292436840 4291651691 4291649885 4291386981 4291911520 4291519340 4291255895 4292175719 4291845728 4291584355 4292176486 4291649635 4291649891 4291977318 4292175463 4291585117 4291584349 4292175720 4291782244 4292109152 4291191137 4292241505 4291452767 4291452511 4292374119 4291585125 4291911261 4292109149 4291911517 4291518305 4291256413 4291321692 4291387230 4291058004 4291055946 4291123541 4291122257 4291124053 4291121232 4290730577 4291188044 4290535268 4291123285 4291059289 4291125857 4291387235 4291125599 4291454050 4292110690 4290863978 4291257954 4292045417 4291649899 4291190368 4291191399 4291585120 4291191142 4291257708 4291649124 4291715938 4291389803 4291783023 4291518051 4291583588 4291323757 4291520352 4291649892 4291125607 4291387746 4291518304 4291715680 4291780959 4291848037 4291519585 4291714146 4290928479 4291059551 4291060064 4291122522 4291191905 4291254107 4290729049 4290206569 4290336358 4290269016 4290334808 4289613412 4290665307 4291190899 4291715936 4291783532 4291852139 4292244852 4292115310 4292116849 4292444031 4292574828 4292183664 4292577145 4292707954 4292446073 4292643191 4292775289 4292968299 4292970095 4292904559 4292772463 4292839540 4292839284 4292445804 4292969842 4292772719 4292970355 4292772719 4292772976 4292772719 4292772719 4293100395 4292903807 4292970351 4292968556 4292838770 4292508765 4292575346 4292902255 4292181866 4292245350 4292640113 4292704607 4291917928 4291983456 4292375131 4291916638 4292178021 4292973164 4293837964 4294038163 4293973161 4294170531 4294171827 4294104226 4294368675 4293973431 4293968775 4292382317 4289087317 4289676625 4289548893 4290006105 4289353055 4289810267 4290336861 4290403678 4290667872 4291324784 4291715678 4289478728 4286391108 4284289859 4284091709 4284419657 4284159037 4284290615 4284619588 4284947782 4285014603 4285343818 4285278032 4284686152 4285012291 4285078851 4284424268 4284488516 4284685118 4284485446 4285142066 4284553286 4284551492 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293496441 4292969836 4292972144 4293101683 4293364858 4292971127 4293167998 4293302390 4293566070 4293432704 4293496684 4293298030 4292706911 4293362540 4293297003 4293166961 4293297003 4293297003 4293299311 4293299566 4293298810 4293101678 4292774004 4293166956 4293038200 4293299566 4293233777 4293558632 4292836980 4292110418 4291385685 4289676881 4289217613 4288097352 4288689739 4289413971 4289085516 4290069589 4289546580 4289611094 4290136145 4290529875 4289481049 4290005330 4290135889 4290005587 4290071124 4289414990 4289546324 4289676631 4290070359 4290399315 4290269532 4290136407 4291319379 4290599775 4291122781 4291058768 4291058528 4291582043 4290994530 4291519068 4291520101 4291320916 4291060320 4291716452 4291190372 4291781969 4291387997 4291322977 4291649119 4291453795 4291190621 4291322204 4291519842 4291584100 4292044134 4291650664 4291652207 4291451995 4291848037 4291913822 4291125091 4291583066 4291716453 4291782761 4291779942 4292175718 4292109670 4291848546 4291649635 4292176487 4291518562 4292173675 4291780199 4291978075 4291389800 4291980131 4291911009 4291585381 4291911510 4291452768 4292370527 4292108647 4291453523 4291976289 4291583068 4291255383 4291057755 4291192951 4290996577 4291334559 4291262345 4290941591 4291065987 4290673290 4290799481 4291128679 4289943142 4290663760 4290598484 4291123798 4291124568 4291190871 4291060066 4291058269 4290994790 4291191390 4290994015 4291321698 4290862164 4292045157 4291780964 4291520353 4291847268 4291191142 4291322208 4292110188 4291388772 4291323236 4291979107 4291650659 4292109413 4292109415 4291125600 4292045412 4291717730 4291911255 4291715677 4291125602 4291715428 4291781989 4291060319 4291519842 4291388767 4290994528 4291122778 4290598759 4290138457 4290206567 4290338142 4290206302 4290333014 4290267734 4290860645 4291252566 4291058522 4291190898 4292374376 4292180591 4292179309 4292115567 4292705133 4292247140 4292444288 4292642162 4292116851 4292771950 4292708984 4292707442 4292642163 4292839284 4292773749 4292969842 4292838255 4292642164 4292643707 4292706157 4292839797 4292772719 4293100396 4292904816 4293100397 4293100653 4292772976 4292970096 4292970352 4292968814 4292641651 4292443237 4292968817 4292246889 4291918944 4292768360 4292247658 4292244324 4292246121 4292770399 4292311914 4292245604 4292702814 4292246121 4292377960 4293436788 4294168722 4293971105 4294171047 4294104739 4294302895 4294106034 4294170790 4294102930 4293768569 4290470491 4288627284 4289676118 4289483100 4290007131 4290929249 4290269017 4290208110 4290995044 4290797924 4288954193 4285865028 4284092233 4283898439 4284158781 4284159037 4284290372 4284685381 4284554052 4285077824 4284687953 4285275206 4285408330 4285537856 4284751689 4284816453 4284816713 4285341511 4284746557 4284551494 4284945977 4284750397 4284550981 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293300354 4292971384 4293168767 4293167219 4292970092 4292972671 4293366130 4293235326 4293628280 4293430125 4293101936 4292969326 4293427051 4293165677 4293034097 4292639050 4293427054 4293297002 4293299068 4292971883 4293301111 4293496436 4293167219 4293103232 4293495922 4293233268 4293692781 4293100142 4292769359 4292769905 4291125337 4289874010 4289412687 4288034382 4289345099 4288494672 4289217101 4289609039 4289479509 4290201686 4290071379 4290070358 4290005336 4290006875 4290005587 4289808214 4289415258 4290201674 4289611096 4290071380 4289939277 4290267477 4290270039 4290202969 4290731361 4290598237 4291058262 4291845211 4290993753 4291322207 4291386708 4291256421 4291189587 4291256416 4291912289 4291059543 4291387998 4291913825 4291518053 4292044901 4290928990 4291649381 4291518303 4291913830 4291649636 4292374113 4291386980 4291845477 4291453032 4292044909 4292371561 4291584356 4291518046 4291715941 4291452772 4292180835 4292176231 4291322463 4292439141 4291586159 4291650659 4291912545 4292044136 4291780187 4291585382 4291978332 4291977824 4292440941 4290994013 4292304232 4291517538 4291387227 4291584887 4290862174 4291921305 4290933359 4290871170 4291198348 4290805134 4291266440 4291407532 4291925623 4292061341 4292713365 4291539629 4291532942 4292130727 4291865249 4291865776 4291472563 4290543498 4290476659 4290007130 4291122263 4291120974 4291122767 4291058526 4291321438 4291125343 4291322728 4291780709 4291190626 4291649374 4291847526 4291518040 4291585890 4291781475 4291519341 4291388775 4291848563 4291518310 4291848040 4291125350 4291190624 4291649124 4291322209 4291322210 4291911516 4291518303 4291389544 4291583582 4291583839 4291649375 4291256162 4290994271 4291646816 4290468446 4291254106 4290665311 4290861916 4290139752 4291382613 4290203737 4290530903 4290268759 4290141289 4291123803 4291257707 4291585644 4292244075 4292113776 4292509053 4292114799 4292181106 4292310881 4292378750 4292641403 4292509292 4292578184 4292511608 4292707699 4292643450 4292969581 4292774005 4292640879 4292838511 4292706413 4292444543 4292838254 4292772720 4292904816 4292968557 4292641905 4293035117 4292968814 4292772978 4292837730 4292575079 4292902237 4292574819 4292181353 4292247146 4292180852 4291919201 4292705136 4292311138 4292311657 4291919207 4291785055 4292311914 4292311898 4291917928 4292571238 4293234550 4293507472 4294102946 4293972388 4294170533 4294368430 4294171825 4294170275 4293972648 4294102155 4292844420 4289808215 4289552226 4289613403 4289287006 4290926941 4290208093 4290406246 4291190364 4288494159 4285995840 4283897142 4283960392 4284421699 4284555338 4284288580 4284488010 4284619587 4284488002 4284621903 4285538120 4285015116 4285343567 4285079629 4285341254 4285014092 4285077820 4284552509 4284160070 4284814141 4284487237 4284289612 4284945976 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293496189 4293101425 4293299064 4293364857 4293101689 4293560697 4292907649 4293695350 4293173110 4293430389 4293296746 4293427307 4292640096 4293100133 4292769869 4292838006 4292705362 4293232240 4293103986 4293101422 4293298804 4293101428 4293167219 4292971128 4293496953 4293430905 4293428335 4293100141 4292835422 4292438629 4291650646 4290399060 4288888400 4288755789 4288034382 4289216592 4289151565 4289413715 4289740875 4289676887 4289545302 4290004818 4290005592 4290007131 4289349459 4290661204 4289479760 4290530133 4289740878 4289611089 4289808982 4291315783 4290728540 4290731617 4290596176 4291119697 4291385435 4290992214 4291059289 4291385948 4290993753 4291256414 4292045154 4291189845 4291322205 4291649378 4291781210 4291649887 4291846757 4290928734 4292175203 4291256930 4292108892 4291845466 4291584356 4292173412 4291125344 4292374887 4291584862 4291584349 4291584355 4291845735 4291848286 4291845735 4291716451 4291650148 4291386717 4291716203 4291125606 4292242022 4291584356 4292371550 4291518821 4292176730 4291845724 4291845978 4291715170 4291123289 4292375672 4291456628 4291197822 4291261575 4291331721 4290873229 4291134848 4290872203 4290674579 4291528583 4291206309 4292121991 4292055951 4292061877 4291208097 4291405471 4291599507 4292458924 4292124569 4292263089 4292257170 4292457896 4292919467 4292453542 4291409592 4291142043 4290541705 4290467672 4291189081 4290073939 4290664541 4291189596 4290469728 4291257184 4290994016 4290994015 4291519075 4291454049 4291454566 4291192430 4291127677 4291256934 4291258224 4290995815 4292045410 4291191142 4291324007 4291846495 4291519841 4291911528 4291911527 4291716961 4291322465 4291388002 4291716453 4291649637 4290994528 4291516505 4291125857 4290533725 4291252824 4290073692 4290793559 4290730076 4290335590 4290333269 4290334808 4290204268 4291125854 4291190884 4292176490 4292244075 4292179311 4292246115 4292179566 4291854185 4292117112 4292770408 4291854465 4292640622 4292379753 4292510580 4292905076 4292641907 4292643706 4292969841 4292445302 4292968556 4292642678 4292968811 4292772976 4292772976 4293100396 4292839281 4293493610 4293035119 4292509542 4293164907 4292378483 4293034863 4292444277 4292574559 4292641397 4292638813 4292313195 4291982686 4292707446 4291981660 4292310375 4292705120 4292245604 4292310117 4292312171 4292375124 4292246377 4292114279 4293567346 4293838215 4294037410 4293973158 4293973938 4293973424 4294171826 4294170276 4294104492 4293835122 4291131998 4289152858 4289481048 4290533726 4290139486 4290798943 4291189335 4289022035 4285995072 4283696967 4284355141 4284159293 4284091453 4284291141 4284682039 4284619844 4284292168 4285736780 4284290624 4285475661 4285278031 4284687182 4285146188 4285211470 4284488514 4284549182 4284419647 4284812607 4284685375 4285142591 4284945975 4284684608 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293298807 4292971385 4293364851 4292969843 4293166962 4293235067 4293238387 4293631360 4293628531 4293233519 4293363053 4292638814 4293229399 4292375904 4292834658 4292835188 4292771424 4292838770 4293301104 4293759612 4293103471 4292971891 4293364346 4293298808 4293037934 4293430650 4293232499 4293624425 4292311650 4293030499 4291779931 4289743182 4289412679 4288100687 4288754250 4289085520 4289347152 4289479244 4289675347 4289609297 4290530899 4289940057 4289545302 4290201429 4289742161 4289349197 4290596443 4289808724 4290466126 4290070354 4290267464 4291251798 4290596947 4291187025 4291122012 4291058775 4291384922 4291322468 4291256670 4291322207 4290993753 4291713625 4291584098 4291124308 4292112232 4291124051 4291322462 4291781223 4291190620 4291651684 4291649881 4291781215 4291452260 4291586673 4292111715 4291518563 4292175975 4291911526 4291912801 4292306020 4291913581 4291845728 4291650661 4291911521 4291650148 4291649892 4292176488 4292110424 4292309596 4291911777 4291780455 4291978593 4291845985 4291845979 4291518049 4291582835 4291718521 4290741140 4291133832 4291397263 4291527296 4291398796 4291200649 4291070356 4291395720 4291330444 4291203999 4292129441 4291924098 4291665047 4291467927 4291600015 4292520856 4292130476 4292126887 4291142049 4292060312 4291932319 4291995805 4291931039 4292387991 4291801760 4292917940 4292393895 4292983716 4291474110 4290944667 4289817725 4290664800 4290204503 4290726741 4291125080 4291125602 4291125344 4291059551 4290994015 4291322973 4291978855 4290931057 4291716205 4291584359 4291584360 4291518569 4291191398 4292174951 4291124827 4292042600 4291322464 4291125090 4291715672 4292042601 4291125089 4292042850 4291255130 4290992989 4291583076 4291124060 4290667366 4290532699 4291251541 4290730857 4290859095 4289809495 4289876326 4290334553 4290073690 4291909469 4291717750 4292111455 4291719024 4291787624 4292770925 4292115056 4292180341 4292770922 4291853187 4292312419 4292640878 4292444030 4292576371 4292773491 4292642164 4292707956 4292838254 4292248428 4293231725 4292577143 4293166188 4292772976 4292968813 4292511607 4293164651 4292707697 4293100912 4292836445 4292838250 4292706658 4292507486 4292509537 4292574065 4292245863 4292246377 4292310123 4292312169 4292702300 4291983719 4292310629 4292244839 4292703581 4292310631 4292374371 4291982431 4292310374 4292180071 4292969071 4293769861 4293905055 4294037666 4293972900 4294172082 4294302381 4294502322 4293906852 4294169769 4293501555 4290862680 4289219163 4290272353 4290798942 4290994266 4288497489 4285993533 4283896118 4283960389 4284157500 4284748357 4284748358 4284091453 4284225606 4284946492 4284424268 4284947264 4285209926 4285472587 4285274951 4285211469 4285080138 4284685381 4284226628 4284484927 4284419385 4284944953 4285073469 4284681529 4284748103 4284553278 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293299065 4293101683 4293297521 4293300601 4292905845 4293628792 4293629049 4293170537 4293430390 4293035374 4293425769 4292835418 4292440416 4292571229 4292899169 4292440911 4292770143 4293428075 4293298812 4292908390 4292973182 4292970874 4292906345 4293693560 4293628289 4293365100 4293495149 4292772209 4293229141 4292373337 4291649366 4290330194 4289150283 4288295755 4288166222 4289149517 4289217357 4288822608 4290267730 4290006100 4290070358 4289940057 4290005069 4290005850 4289480531 4290072664 4290070346 4290069841 4290070359 4289874522 4290333780 4290727508 4290726483 4290530901 4291122771 4291123294 4290991949 4291452004 4291844191 4291255893 4291320669 4291189581 4291648856 4291518561 4292043100 4291913058 4291714904 4291517784 4291190101 4291387996 4291715430 4291453794 4291782238 4292241249 4291386718 4292175975 4292107613 4291782500 4292110183 4291912801 4292306019 4291781733 4291914341 4291387999 4292108648 4291649886 4292043105 4291584095 4291978082 4291846754 4291845984 4291845990 4291911524 4291779694 4291654007 4291329405 4290608780 4291724159 4291068801 4292251274 4291003008 4290736255 4291134593 4291199090 4290805899 4291399569 4292189325 4291403931 4291534227 4291664023 4291861660 4291406761 4292389537 4292191908 4292454797 4292061851 4291801001 4292058005 4291533464 4291074965 4291998369 4292323231 4291472776 4292392874 4292258195 4292984235 4292787886 4292393639 4291931816 4291005584 4289749615 4290727252 4290596945 4291124318 4291125600 4291124578 4291060582 4290994531 4291060841 4290928993 4291388000 4291716195 4292307814 4291190112 4291388769 4291847525 4291191136 4291781989 4291583838 4291649638 4290797406 4291913574 4291385954 4290991707 4291124062 4291059800 4291122779 4290598759 4291255901 4290729564 4290204506 4290205800 4290465122 4289874005 4290923861 4290793560 4290404713 4291586148 4292308843 4291587695 4292835178 4291855235 4292113002 4291984255 4292114028 4292770923 4292050550 4292442747 4292116592 4292642163 4291986295 4292970611 4292445043 4293034877 4292642677 4292641136 4292705891 4292641393 4292838512 4292378986 4293034608 4292640864 4292444019 4292968283 4292641909 4292444276 4292507486 4292510582 4292966496 4292574579 4292179541 4292638045 4292243555 4292310374 4291918176 4292310629 4292703085 4292245093 4292310375 4291983456 4291985251 4292374373 4292245094 4292377449 4291785309 4293432685 4293706628 4294102434 4293973159 4294170531 4294104494 4294303919 4294369713 4294170276 4294166154 4292316791 4290007644 4290994528 4291060578 4289350491 4285929534 4283896646 4284155723 4284418875 4283962695 4284092224 4284225079 4284620101 4284287293 4285208636 4285670219 4284949323 4284947011 4285274687 4285340223 4284488258 4284357961 4284817223 4284419900 4284422461 4284554566 4284684863 4285274687 4284683322 4284551737 4284747071 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293299054 4293101685 4293496172 4293496441 4293235573 4293563768 4293563001 4293629045 4293233520 4293428334 4292377188 4292506193 4292831051 4292043100 4292637278 4292505694 4293097569 4292970610 4293430644 4293627509 4293496429 4293628018 4293496186 4293232761 4293170536 4293430401 4293429356 4293166959 4292770142 4292637280 4291189327 4290334031 4289018190 4287574347 4288821838 4289084238 4289215562 4289347408 4289675347 4289676110 4289872468 4290006100 4289806926 4290070100 4289414997 4290071123 4289415252 4290135377 4290464852 4290069322 4289939032 4290924365 4290072668 4291254877 4291059295 4291057757 4291516243 4291845476 4291384914 4291255133 4291256677 4291649884 4291125348 4291977314 4291452767 4291650144 4291715936 4291911009 4291584096 4291518310 4292042843 4292045925 4292374632 4291059039 4291715678 4291780199 4291845992 4291584349 4292107882 4291780193 4291977826 4291780444 4291585376 4292105562 4291650917 4291650654 4291650658 4291650659 4292172896 4291451995 4291847265 4291257449 4291454322 4290799484 4291001984 4290872719 4290998649 4290674825 4291594132 4291266953 4290936209 4290148976 4290736007 4291594890 4291134595 4291856262 4291267457 4292516502 4291136143 4291927189 4292189065 4291599259 4292587410 4291666332 4291868341 4291405992 4291865494 4291404198 4291141790 4292322447 4291469723 4292327853 4291535762 4292260010 4292065437 4292261294 4292587931 4292854968 4292655009 4292721829 4292524472 4290280072 4290529876 4291187800 4291122779 4291124575 4291123284 4291059808 4291191387 4291322483 4291649121 4291847522 4291583330 4291455853 4291321440 4291256935 4290863460 4291847524 4291190882 4291451233 4291256675 4291450457 4291322211 4291386202 4291060321 4291122779 4291189084 4290727767 4290140254 4290204764 4290204508 4290925144 4289875288 4289350489 4290336364 4290137175 4291125599 4291782249 4291848807 4292834409 4292180838 4292639596 4292641650 4292703593 4292116081 4292114803 4292639595 4292641135 4292116592 4292378493 4292641904 4292512121 4292903788 4292642676 4292904047 4292706672 4292509553 4292509552 4293034605 4292706930 4292509025 4292509025 4292575347 4292444534 4292900703 4292902752 4292901220 4292507998 4292507505 4292571993 4292576375 4292639339 4292244837 4292245350 4292702310 4292637805 4292179029 4292310375 4291983713 4292310117 4292704369 4292244308 4292703840 4291983713 4291980384 4292244837 4293505146 4293970315 4294038440 4293972643 4294172079 4294105785 4294107069 4294369714 4293972133 4294165636 4291392356 4290864479 4289676372 4286259013 4283897155 4284026182 4284027451 4283963725 4284224841 4284555081 4284553795 4285145164 4285013314 4285211727 4284490316 4285211470 4284750398 4284947011 4285014604 4284552260 4284092989 4284419899 4284818767 4284489804 4285339965 4284682815 4284750399 4284748863 4284550975 4284685120 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293429356 4293297776 4293234816 4292971893 4293629816 4293565043 4293564019 4293430639 4293297006 4293033823 4292505920 4292505182 4292040789 4292108388 4291912537 4292573538 4293033307 4293560942 4293431157 4293430900 4292908398 4293495680 4293233778 4293236089 4293628281 4293627768 4293365359 4293560179 4292704611 4292962905 4291388246 4290331471 4289018702 4288294729 4288229193 4289214283 4289018188 4289281616 4290004297 4289413203 4289152085 4290070094 4289872726 4289543761 4290661448 4289938516 4289480794 4289808727 4289740884 4289876055 4290464339 4289807697 4290858584 4290662490 4291320925 4291055949 4291386976 4291253834 4291714139 4291256151 4291255900 4291843928 4291584353 4291584095 4291584103 4291977046 4291518305 4291911766 4291584098 4291518303 4291979366 4291124828 4291845468 4291845980 4292175977 4292043867 4291388513 4292043873 4291979111 4291782751 4291845986 4291976034 4291911259 4291453272 4291714907 4291912541 4291519094 4291520107 4291787147 4291919487 4290931583 4290667116 4289883004 4291198582 4291856519 4291068274 4291132546 4291002751 4291066494 4291330429 4291525493 4291393930 4291333004 4291266173 4291328885 4291397268 4291397522 4291527552 4291467932 4291265411 4291859081 4291728263 4290810774 4292714889 4291273119 4292391071 4291928483 4292586896 4291994271 4291538592 4292517770 4292127144 4292326043 4291864218 4291864991 4292327063 4292588971 4292130211 4292787133 4293248172 4292721826 4292919469 4291405480 4289423216 4290726994 4291252567 4290599775 4291124576 4290929530 4291452765 4290799736 4290864240 4290995558 4291387753 4290928734 4291321696 4291913060 4291583845 4291256156 4291388514 4291844703 4291322205 4291060064 4291124318 4291124318 4291123291 4290007644 4290729564 4290731359 4290726229 4290797151 4290858069 4289878122 4290136660 4290270299 4290729564 4291060063 4291584105 4292244589 4292114290 4292637033 4292574575 4292179813 4292247657 4292309858 4292115057 4292443261 4292575597 4292444286 4292640617 4292445066 4292378233 4292707715 4292510835 4292706672 4292707688 4292509553 4292575344 4292509809 4292575604 4292573020 4292575606 4292574050 4292574031 4292575863 4292179286 4292509028 4292573538 4292573790 4292180845 4292637012 4292244838 4292246889 4292307302 4291851619 4292637806 4292635980 4292639347 4292243283 4292640628 4292638815 4292245096 4292245079 4292376168 4292309610 4292241254 4292905571 4293703558 4294102413 4294038717 4293973947 4294106030 4294303662 4294303664 4294369971 4294169509 4293239417 4289742415 4286719305 4283827266 4284026438 4283634505 4284026176 4284615747 4284158524 4284226627 4285407302 4284490574 4285603139 4284881218 4285408072 4284946754 4285144390 4285144390 4284880457 4284815419 4284224580 4284818768 4284687181 4284947273 4284682557 4284618303 4284157751 4284616519 4284489287 4285076020 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293299065 4293233272 4293627511 4293562993 4293565828 4293170542 4293627000 4293232500 4292967515 4293162594 4292505165 4291778388 4291583061 4291123269 4292437864 4292509296 4292707700 4293167216 4293038699 4293628021 4293235051 4293235824 4293430132 4293627507 4293561977 4293169782 4293429358 4293033305 4293100403 4292571469 4291581025 4290004811 4289018702 4288293702 4287771465 4288754250 4288760416 4289414478 4289871955 4289217615 4289412939 4289938262 4289676874 4289940057 4289348176 4290267474 4289872718 4289937235 4290331208 4290466653 4289742936 4290989138 4290792792 4290073429 4290662490 4291124568 4290467671 4291123799 4290993249 4291320147 4291321436 4291255899 4291190363 4291321950 4291256669 4290863202 4291256413 4291451494 4290861646 4291847010 4291322466 4291583584 4291913823 4291649894 4291387230 4291845730 4292043880 4292043873 4291387231 4291845980 4291387998 4292170085 4290996338 4291580525 4291260288 4291790745 4291594373 4291987343 4290214529 4291193721 4289485419 4290796895 4290670980 4290144881 4290996857 4290934143 4291132275 4290806138 4291131523 4291196275 4291262335 4291661195 4292051326 4291463563 4291131507 4291397247 4291594119 4291401353 4291397269 4291992205 4291532707 4292188808 4291924634 4291466648 4292392089 4291925647 4291990678 4291472023 4292191889 4291336598 4291933853 4292454288 4291735463 4292394669 4292193693 4292130229 4292787622 4292852126 4292130206 4292328113 4292723125 4292722091 4292721578 4292723379 4290086802 4290071136 4290201683 4291256418 4290601314 4291124060 4291124576 4291060578 4291649398 4290994268 4291582561 4291125620 4290994013 4291387490 4290928991 4291910245 4291451746 4290994528 4291122522 4290532443 4291123291 4291123548 4291187545 4290531417 4291253081 4290728537 4290270054 4290004307 4290070099 4289940579 4290336604 4290726229 4291059037 4291124576 4292439909 4292112492 4292180837 4292574062 4292641393 4292049777 4292705648 4292311397 4292180579 4292834682 4292049516 4292446084 4291983226 4292116848 4292574829 4292510837 4292641390 4292838017 4292901983 4292509810 4292574817 4292180824 4292575863 4292574816 4292574564 4292571997 4292576118 4292180327 4292967536 4292115544 4292573041 4292572236 4292573553 4292179302 4292638044 4292245351 4292703069 4292245351 4291916896 4292637533 4292243815 4292243299 4292179542 4292637550 4292245096 4291983712 4292178018 4291917151 4292439644 4293829739 4293906082 4294037921 4293972899 4294368430 4294303919 4294303406 4294303921 4293973160 4294233754 4289676882 4283500354 4283635271 4284484419 4284223049 4284422210 4284291399 4284292420 4284616004 4284552763 4285604940 4285076796 4284947780 4285014860 4284946754 4285341770 4285276741 4284291144 4284621389 4284226371 4284683321 4284751430 4284682044 4284620101 4284554047 4284814153 4284485939 4284812851 4284814908 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293035890 4293693303 4293171588 4293564023 4293566590 4293563258 4293363820 4293494380 4293493357 4292571231 4291845716 4291053903 4290724941 4291251023 4292044884 4292770672 4293032793 4293365105 4293233524 4293564275 4293429626 4293629049 4293365364 4293365619 4293561972 4293562996 4293561197 4293494638 4293032796 4292964451 4291979339 4290004563 4289083981 4288361804 4287903052 4288493899 4288167244 4288624717 4289151564 4289546072 4289480279 4289350739 4289610581 4289545039 4290003785 4289283667 4289479504 4290267468 4289349967 4290135638 4290071897 4289808729 4290203995 4291316818 4290595928 4291121236 4291450970 4291057502 4291385939 4291319386 4291060065 4290994529 4291975000 4290862937 4291843167 4291583570 4291846239 4291584091 4291256672 4291583057 4291583841 4291781215 4291452511 4291650911 4291911522 4291650405 4291649886 4291651173 4291910233 4292040549 4292039011 4292243811 4293178016 4291985801 4292381830 4291265935 4291132017 4290606465 4290733161 4290603375 4291321687 4290929280 4290208369 4290078331 4290670704 4290803079 4290670194 4290668140 4291259760 4290407021 4291856247 4290999922 4291129713 4291135371 4291461505 4291791764 4291592834 4291855236 4291593603 4291073685 4292842892 4291533466 4291600805 4292255630 4291595930 4291402389 4291993752 4292519065 4291867306 4292585616 4291859092 4292131763 4292784535 4292259988 4292329133 4292260501 4292588191 4292195751 4292655790 4292786330 4292522662 4292723124 4292657075 4293182381 4292985015 4291471767 4289553012 4290202460 4290338157 4290729050 4291124574 4291124317 4291124059 4291125600 4291060064 4291058267 4291125600 4290992732 4291648355 4290992989 4290994784 4291125344 4291125857 4291124574 4290532443 4291122009 4291122266 4291189340 4290139228 4290334553 4290398806 4289876059 4290135893 4289415256 4289807958 4290599260 4291974499 4291651690 4292110180 4292639340 4292574575 4292574061 4292508525 4292639854 4292244322 4292115059 4292703851 4292510320 4292641136 4292639338 4292114541 4292115055 4292576629 4292708212 4292902509 4292707688 4292511095 4292509552 4292966498 4292571998 4292573535 4292573041 4292178526 4292573554 4292572748 4292508270 4292966752 4292574578 4292573038 4292508255 4292573296 4292638043 4292638832 4292244838 4292179558 4292703069 4292244322 4292638316 4292637514 4292179560 4292638834 4292572508 4292637271 4292311915 4292245336 4292767324 4292177764 4292705636 4293703552 4293904797 4294038179 4293973936 4293908924 4294304699 4294435760 4294567339 4294234248 4288357704 4283040560 4283567933 4284091204 4284420675 4284159565 4284292163 4284617796 4284488511 4285407305 4285472586 4285078854 4285406271 4284554053 4285015630 4284879925 4284550980 4284616515 4284619587 4284487744 4285738844 4284226888 4285078850 4284027197 4284621646 4284684873 4284812594 4285736010 4285273144 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293495935 4293169268 4293628784 4293565561 4293564267 4293562223 4293298031 4293034084 4292441696 4292110159 4291120720 4289806922 4289675338 4291124308 4292635994 4292444515 4293624170 4293036143 4293628538 4293562996 4293236592 4293430388 4293432685 4293364603 4293562989 4293364859 4293560168 4293298544 4292706145 4292963933 4291517276 4290070354 4288559183 4287834950 4287311689 4288887375 4288755790 4288626257 4289085264 4288953679 4289478737 4289676117 4289676367 4289217359 4289610576 4289349203 4289742411 4289676889 4289938004 4289545553 4290465102 4289807943 4290333529 4290729560 4290663260 4291122266 4291450969 4291058519 4291056724 4291385178 4291060065 4291125601 4290929250 4291385427 4291650145 4291450715 4291190878 4292042839 4291583333 4291584091 4291583840 4291322467 4291911522 4291911516 4291453029 4292106850 4291453018 4291713382 4291385433 4291134855 4291520363 4291454565 4291059816 4290999406 4291062897 4290602084 4290733935 4290142569 4290800239 4290798690 4290535031 4290208096 4290273911 4290342755 4291129216 4291193965 4290344822 4290669696 4289489014 4291325038 4290936707 4290340477 4290935680 4291593848 4291460473 4291661451 4291332221 4291070860 4291728280 4292124059 4291594892 4291923075 4292124822 4291268231 4291471770 4291861157 4291800737 4292261025 4291664026 4291475360 4291933876 4292390287 4291736998 4292785048 4292123811 4292261793 4292852644 4292062370 4292195742 4292789176 4292787361 4292457646 4292854453 4293380016 4292985510 4292656821 4292721076 4290480774 4289023845 4290333268 4290793817 4290729307 4290599518 4291124318 4291124318 4291124061 4291125600 4291125600 4291058525 4291059800 4291646561 4291060320 4291124062 4291122779 4291124830 4291121247 4290530134 4291187801 4290203481 4289875813 4289875802 4290005079 4290005849 4289608782 4290335580 4291251797 4290927965 4292043366 4292702824 4292572009 4292572779 4292444785 4292968813 4292573806 4292182121 4292705646 4292047726 4292639597 4292116850 4292444542 4292444542 4292639596 4292575341 4292378493 4292509807 4292509296 4292706671 4292774007 4292115816 4292182124 4292640099 4292572507 4292572014 4292965728 4292508515 4292966755 4292116589 4292571745 4292508511 4292968048 4292571483 4292246378 4292180585 4292638043 4292639088 4292179559 4292638302 4292179558 4292637551 4292638046 4292246105 4292246378 4292246122 4292246375 4292701289 4291916899 4291851113 4292114022 4293956721 4293641879 4294037922 4293972656 4294303918 4294239164 4294502069 4294500509 4293100639 4283236402 4283501385 4283831114 4283831104 4284157501 4284354371 4284618052 4284684348 4284816457 4285341511 4284948299 4284750920 4284686152 4285014605 4285272380 4284553285 4284289348 4284223300 4284488259 4285278288 4284946752 4284616004 4284421182 4284223808 4284945977 4285076019 4284750915 4285276235 4285537861 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293169006 4293630590 4293501313 4293565559 4293563270 4293429099 4293166962 4292770894 4292701276 4291646547 4290198852 4288756304 4290132298 4291384920 4292044629 4292507489 4293166960 4293035887 4293629044 4293628782 4293235570 4293235825 4293430644 4293431155 4293563509 4293627506 4293563005 4293493098 4292770399 4292373352 4292042579 4290004039 4288754246 4287902538 4287378253 4288426569 4288164939 4289279050 4289085264 4289414480 4289283151 4289348687 4288822351 4289480531 4289610576 4289742411 4289742425 4289742153 4289481050 4289611094 4290660950 4290399834 4289807698 4290335325 4290397257 4290729304 4290534496 4291122263 4291123294 4291123798 4291124320 4291057228 4291452254 4290990674 4291321956 4291256412 4291321699 4291126113 4291255635 4291256158 4291651171 4291125340 4291911779 4291518297 4291518566 4291648096 4291912280 4291386976 4292371803 4294424446 4291774025 4290664800 4291192168 4290601066 4290667375 4290732648 4290730842 4290273387 4290207340 4290207337 4290865269 4290274666 4290143596 4291325557 4290410880 4291063679 4290145140 4290208362 4290931571 4290606465 4291001472 4290998891 4291129972 4291131763 4291134594 4290872205 4290803066 4291726221 4291790189 4291924871 4291594632 4291004554 4291730074 4291594119 4292389784 4292189571 4291139489 4291865244 4292784798 4292784810 4292261279 4292720033 4292124829 4292129957 4292326808 4292261273 4292589740 4292655005 4292849047 4292587169 4292131254 4292787882 4292524463 4292130483 4292328629 4292920236 4292985253 4292592307 4291207324 4289487986 4289872978 4289810779 4290992221 4290729563 4290729050 4290732902 4290663002 4291126114 4291124574 4291122523 4291059294 4291122523 4291123797 4290599519 4290665054 4290600287 4290662489 4291255389 4290792277 4289812324 4290660178 4289810267 4290071127 4289546338 4290660691 4290071651 4291124317 4291783011 4292111723 4292572009 4292443502 4293229165 4292444272 4292510065 4292573288 4292572780 4292574318 4292640109 4292114800 4292245859 4292115568 4292639852 4292443262 4292443002 4292640878 4292576886 4292706927 4292705132 4292575601 4292637544 4292179301 4292178026 4292639073 4292507230 4292506975 4292507745 4292506974 4292969587 4292506716 4292571500 4292574304 4292180328 4292639327 4292573553 4292570969 4292178020 4292638302 4292639073 4292178019 4292638045 4292247917 4292244324 4292639583 4292638574 4292639594 4292310374 4291983455 4292308328 4292115303 4293697908 4294104230 4294170789 4294500527 4294304180 4294302361 4294424436 4286453823 4282712893 4284027968 4283893571 4284484420 4284355140 4284226892 4284552259 4285012547 4285146702 4285340744 4284881218 4285669189 4285668422 4285208123 4284355646 4284289350 4284093245 4284552516 4285079107 4285273404 4285144901 4283963966 4284484671 4284419385 4284683066 4284683577 4285537862 4285471033 4284550970 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293564280 4293499766 4293763956 4293564268 4293366388 4293232495 4292967771 4292967014 4291912806 4291120709 4288561232 4288030789 4289282639 4291122762 4292636264 4292902496 4293165421 4293496181 4293170807 4293235569 4293038193 4293628788 4293629044 4293167988 4293627501 4292972664 4293429613 4293032031 4293099348 4292964192 4291517516 4290136660 4289213771 4287180874 4288097862 4287770441 4288297550 4288691537 4288759378 4289019215 4289347152 4289085516 4289676367 4289806156 4289610831 4289807960 4289217363 4289414743 4289742165 4289742166 4289547097 4290265939 4290399565 4290004310 4290463825 4290073429 4291251543 4291122773 4291122772 4290532701 4291124055 4291122264 4291056470 4291059040 4291389023 4291256420 4291321949 4291321949 4291256420 4291256413 4291649633 4291712605 4291911773 4291322718 4291583069 4291519068 4291710299 4291320150 4293704087 4291915620 4287575369 4290399073 4290142830 4290796636 4290537583 4290206821 4290864236 4290141029 4290799721 4290208356 4290274146 4290204247 4291191675 4290670445 4290603642 4291393389 4290996073 4290473842 4290147445 4291129214 4290736499 4291127919 4291001989 4290342012 4290804362 4291130742 4291066497 4291595391 4290873239 4291200393 4291596678 4291332490 4291799964 4292584600 4291337128 4291602588 4292127899 4292389530 4292391333 4291735704 4292780698 4291868063 4292721060 4292257176 4292654241 4292328876 4292652442 4292061094 4292197026 4292589731 4292589217 4292524722 4292920502 4292721055 4292525240 4292525239 4292394422 4292262573 4292984997 4292787118 4289556081 4289283671 4289150538 4290530915 4289810019 4290338150 4290204764 4290663251 4291252825 4290010723 4291254107 4290535778 4291188572 4290599774 4290598492 4291185749 4290795869 4289808214 4290925400 4289810532 4290334306 4291055447 4289086549 4290003537 4289218136 4290859608 4290993501 4292305511 4292702567 4292506473 4292902001 4292772204 4292444016 4292968557 4292510066 4292573287 4292576113 4292113261 4291590007 4292769641 4292115313 4292179821 4292113773 4292310368 4292115057 4292049008 4292575344 4292706928 4292576888 4292180310 4292638830 4292636010 4292180566 4292571757 4292900448 4292505966 4292967790 4292508514 4292573793 4292179302 4292572253 4292640371 4292572509 4292179301 4292574304 4292637548 4292179301 4292245094 4292637548 4292572520 4292180326 4292640369 4292179046 4292246118 4292247916 4292244067 4292313196 4292245862 4292179557 4292838002 4294035338 4293971876 4294369192 4294038956 4294557043 4288756307 4283170879 4283371335 4284222790 4283701577 4283832640 4284091454 4284815687 4284618812 4285800519 4285277000 4285144133 4285079365 4285604430 4285473611 4284490572 4284286788 4284223287 4284619845 4285078083 4285145676 4284161092 4284223037 4284486462 4284618822 4284684349 4285340992 4285668680 4285538115 4283566389 4283238710 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293564022 4293565571 4293500035 4293561727 4293363826 4293688935 4293032801 4292504935 4291845208 4289411659 4288163401 4288162630 4289347662 4291121997 4292109419 4292508002 4293230170 4293235828 4293628788 4293562996 4293563257 4293627252 4292842862 4293495667 4293562228 4293430644 4293625706 4293559405 4292702049 4292962905 4291517018 4290660171 4288559439 4287966790 4287375690 4288429135 4288821326 4288757834 4289348179 4289217106 4289740110 4289480534 4289480278 4289217364 4289217364 4289612115 4289217364 4289414736 4289742167 4289742160 4289741910 4289940307 4290464595 4289744732 4290859093 4290728539 4290531419 4291122772 4291121493 4290532957 4291122260 4291124055 4291124576 4291121745 4290994786 4291582042 4290993247 4291450969 4291649894 4291715169 4290796630 4291847015 4291453024 4291584090 4291518561 4291517521 4291716200 4291385944 4293230174 4290794071 4289613659 4290859352 4290731871 4290598748 4291322981 4290141021 4290207078 4290733406 4291127932 4290599791 4290207594 4290340205 4290210671 4290079861 4291257709 4290736244 4289621099 4290209911 4290670201 4290602349 4291000707 4291130738 4290736244 4291259247 4291132275 4291329656 4291134324 4290739842 4291460471 4291989378 4291464331 4292055432 4292119943 4291866027 4292126596 4291928478 4292257943 4292452750 4291799710 4292457117 4292326549 4292325277 4292718751 4291933846 4292785312 4291471521 4292656303 4292851865 4292522407 4292523434 4292523681 4292722091 4292458928 4292722877 4293051822 4292985516 4292196003 4292198590 4292919989 4293051823 4292987832 4291207075 4289351009 4289543503 4290074205 4289939287 4290464599 4290923864 4290138712 4291385171 4290531418 4291254620 4290531161 4291254876 4291121753 4291255133 4290203225 4289811291 4290335589 4289873749 4289875802 4290399827 4290071127 4289217877 4290530391 4290729316 4290990943 4292176486 4292113261 4292573291 4292444527 4292968316 4292839022 4292378481 4292903020 4292444528 4292573805 4292639854 4292311394 4291919746 4292833638 4291592052 4292179566 4292243819 4291589234 4292768616 4292574318 4292903021 4292510570 4292572525 4292509040 4292572763 4292571757 4292508016 4292900192 4292508495 4292508786 4292509538 4292508769 4292573296 4292573280 4292180840 4292570969 4292639087 4292572521 4292179300 4292640370 4292179300 4292179299 4292574577 4292574576 4292507502 4292572250 4292574578 4292571737 4292641653 4292180069 4292641137 4292509809 4292704873 4293697143 4294104747 4294169751 4294752358 4289085272 4282974778 4284026182 4284159047 4283832383 4284026183 4284352581 4284421176 4284750142 4285210184 4284357187 4285012291 4284751689 4285277000 4285538123 4285012803 4284224579 4284224835 4284749885 4284620102 4285079106 4284356169 4284160317 4284290629 4284420926 4284748092 4284490575 4285408330 4285408329 4284158780 4283238454 4283304246 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293565570 4293562992 4293564531 4293562990 4293429870 4293164646 4292899680 4291713623 4290136390 4288556874 4287770183 4288163401 4289545041 4291451992 4292242260 4292506976 4292968302 4293298800 4293628783 4293564013 4293563257 4293364595 4293429869 4293170560 4293561977 4293365876 4293428594 4293099612 4292767827 4292831833 4291648089 4289611859 4288752712 4287375175 4287442759 4288492619 4288101713 4289344330 4288561999 4288758865 4288956758 4289546336 4288891744 4289546839 4289480015 4289546330 4289873488 4289414743 4289612115 4289546323 4289350746 4289871698 4289941596 4290398807 4290203739 4290727508 4291189846 4291125345 4290528849 4291187546 4291124312 4290532444 4291124318 4291124576 4291123285 4290993247 4291058005 4291452005 4291450970 4291190362 4291649640 4291257180 4291975771 4291647581 4291912038 4291912031 4291385942 4291853172 4289874251 4290728026 4290795357 4290727769 4290601057 4291256928 4290599260 4291189096 4290076263 4290994013 4290668394 4290732650 4290797152 4290141548 4290800499 4291260017 4290605941 4290475139 4291127923 4291128953 4290079346 4291132030 4291062382 4290867586 4291452762 4290015862 4291068293 4289946734 4290734983 4291789430 4291983485 4291726992 4292054142 4291728524 4292124301 4291860369 4292193702 4292453776 4291859082 4291475363 4292518287 4291600548 4291799986 4292392341 4291797403 4292126109 4292197553 4292918178 4292588702 4291999414 4292984996 4292653982 4292458161 4292920495 4292919461 4292261284 4292722612 4292328629 4292787625 4292788145 4292459445 4292986047 4292985781 4293315496 4291276469 4289744481 4288953420 4289611338 4288825431 4289546073 4289612121 4290333528 4290794330 4290729820 4291320412 4290071897 4290795356 4290139228 4290334808 4290399329 4290335587 4290400600 4289873493 4289876326 4290203747 4289676629 4290070100 4290204517 4291123033 4291386722 4292768103 4292966254 4292444528 4292837227 4292968317 4293034087 4292902780 4292968571 4292509806 4292575600 4292640111 4292243300 4292113005 4292244075 4292242536 4291719536 4292242793 4292111722 4292114030 4292575857 4292575088 4292510064 4292967538 4292506984 4292965986 4292506956 4292507761 4292507502 4292900715 4292901216 4292902262 4292506716 4292573280 4292573295 4292572778 4292179301 4292638042 4292179302 4292573789 4292966258 4292573293 4292573790 4292506716 4292967010 4292509042 4292508783 4292967539 4292116073 4292573032 4292511351 4293034603 4292443007 4293827701 4294034043 4293958777 4288361288 4283435314 4284157774 4284029766 4284224316 4284356165 4284551998 4284422715 4285013059 4284421182 4285863997 4284291909 4285209148 4284489030 4285668418 4284227402 4284484412 4284029254 4285080395 4285539148 4285604939 4284881224 4284687181 4284092733 4284619587 4284488516 4284880962 4285934412 4286461005 4284949065 4283106874 4283304244 4283828285 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293565313 4293565054 4293563251 4293626477 4293297262 4292770654 4292636249 4290991957 4289215816 4288294730 4287180359 4288754765 4289676871 4291121484 4291913827 4292901202 4293361515 4293233520 4293235825 4293235328 4293170813 4293562494 4293564536 4293364595 4293562227 4293364846 4293232750 4293361773 4292834893 4292046954 4291714124 4290267213 4288688457 4287377994 4287375175 4287772239 4289410378 4287971408 4289413714 4289216593 4289545557 4289677655 4289283164 4289483875 4289217630 4289873493 4289150029 4289610836 4289347408 4289808734 4289544268 4290071636 4289480786 4290466395 4290269274 4290792535 4290729565 4290531161 4291255642 4290534240 4290532686 4291123293 4291124575 4291121750 4290994264 4291583078 4290992470 4291714138 4291255894 4291648089 4291584346 4292106596 4291387739 4292107102 4291255139 4291515221 4292770162 4292767841 4289678169 4290729565 4291189591 4290664791 4291252825 4290140511 4290268248 4290074460 4291386203 4290076008 4290797152 4290667363 4290669426 4291322982 4290338158 4291131506 4290665055 4290931053 4290802026 4290343032 4291128434 4291785834 4291656049 4291128175 4290273399 4291067778 4291390070 4291660424 4291457642 4291003782 4291134326 4290671997 4291989892 4292053130 4291728011 4292386955 4292053377 4291866011 4292450196 4292189077 4292327329 4292327321 4292716433 4292259232 4292130990 4292721317 4292587164 4292327342 4292591285 4292785053 4292457905 4293051316 4293047713 4292392616 4292657333 4292920239 4292918433 4292393646 4292328118 4292722609 4292330175 4292918704 4292986302 4292986048 4293708976 4291474078 4289093489 4287836226 4288756811 4289413189 4289545804 4289283409 4290530392 4289744218 4290335836 4290859353 4290205020 4290334552 4290334051 4289875544 4289808993 4290399842 4290336604 4290464853 4289610836 4289479506 4289676629 4290267477 4291124828 4291912825 4292111463 4292443758 4293228909 4292707952 4292968295 4293623414 4292969834 4292771436 4292511350 4292573804 4292574318 4292637802 4292569702 4291454317 4291915374 4291520100 4292177507 4292109925 4292177259 4292244577 4292575601 4292772721 4292443748 4292507759 4292506714 4292507762 4292901728 4292900466 4292442716 4292508786 4292507998 4292573538 4292113767 4292965728 4292507228 4292573553 4292573278 4292573294 4292572783 4292508254 4292573037 4292180584 4292572782 4292509538 4292573535 4292573278 4292510069 4292574559 4292903279 4292444016 4292968812 4292969581 4293560686 4292835944 4287703362 4283567944 4283700800 4284683075 4283964736 4283960392 4284552263 4284422717 4284748867 4284815936 4284620359 4285077053 4285537860 4285275722 4285602631 4285013060 4284616503 4283830598 4284553794 4285737294 4285536320 4284420672 4284228426 4284091963 4284224566 4285080653 4285342279 4285932872 4286330713 4284947268 4283829318 4283303986 4282843199 4287648100 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293564796 4293564535 4293562228 4293232495 4293229408 4292965473 4291582813 4290200646 4288623693 4287705161 4288490567 4288689739 4289478741 4291126372 4292307556 4292440671 4293363053 4293430896 4293628790 4293564012 4293562233 4293563255 4293365887 4293364843 4293562235 4293563509 4293230954 4293361770 4292704611 4293092190 4291255126 4289742413 4288752198 4287312202 4288622151 4287706447 4289281102 4288823123 4288693585 4289216592 4289481058 4289282898 4289480277 4289611864 4289414485 4289612121 4289414742 4289807958 4289610580 4289348943 4289742423 4289610838 4290726485 4289742680 4290400602 4290333779 4290140768 4291253337 4290531162 4291123292 4291121236 4291121754 4290533206 4291059545 4291976291 4291515986 4290992471 4291254610 4290928994 4291256670 4290863457 4291584090 4291911767 4291453274 4291713382 4291912542 4293707915 4291118673 4290073694 4290729565 4291254101 4290139992 4290794075 4290268761 4290137432 4290796906 4290666079 4290796892 4290406273 4291522167 4290663772 4290535522 4291129457 4291191143 4290076771 4290603373 4291523712 4291325290 4291196784 4291064180 4290211709 4291126645 4291265403 4291129197 4291197284 4291061614 4290544767 4291130496 4290936709 4291792525 4290739840 4291595396 4291725954 4291075491 4292252045 4291528326 4291931041 4292392341 4292319639 4292324260 4292195752 4292716174 4292258732 4292195998 4292656046 4292588968 4292522149 4292920489 4292588966 4292129449 4292657588 4293248181 4292654750 4292722091 4292722869 4292394408 4292787370 4292920237 4292788401 4292396215 4292588969 4292522158 4292788412 4292987073 4292066502 4288969878 4289296524 4288366952 4288363079 4289282129 4289547354 4290266452 4289222240 4290925145 4290334553 4290334810 4290400601 4289939543 4290530647 4290004307 4290466393 4290002788 4289283410 4290070109 4288889949 4290990433 4291054941 4291650399 4292508795 4292967279 4292510575 4293295992 4293230200 4292577907 4293428859 4292969067 4292444014 4292509807 4292575601 4292245092 4291783529 4292110434 4290863203 4291060581 4290926683 4291584356 4292110180 4292507005 4292574316 4292444528 4293229423 4292834139 4292837239 4292834399 4292900451 4292378721 4293229426 4292837999 4292444259 4292897629 4292966253 4292441691 4292572015 4292570968 4292573552 4292573037 4292575329 4292573535 4292509042 4292573532 4292967539 4292509542 4292573291 4292509538 4292902236 4292444275 4293165162 4292705900 4293166205 4293887591 4292574063 4288296013 4284290368 4284092988 4284683338 4283896131 4284422206 4284223032 4284287293 4284224837 4284618813 4285736006 4284883788 4285472067 4285667390 4284487998 4284944182 4284158278 4284417080 4284748605 4285209926 4285275718 4284621646 4284884302 4284224064 4284491087 4284555084 4285406791 4284948298 4285937500 4285734211 4284356158 4283172658 4282974271 4287053145 4292314240 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293565303 4293561977 4293363826 4293363053 4292769372 4292503384 4290858053 4289214544 4288167240 4288427084 4287770441 4288099663 4289939531 4291451222 4292176466 4292507230 4293361515 4293233777 4293169259 4293564026 4293562226 4293563256 4293169268 4293627520 4293365613 4293560941 4293429870 4292968301 4293163875 4292045653 4291581782 4289807949 4288752198 4287376967 4287966791 4288361292 4288754251 4288558925 4289480021 4289150800 4289677655 4289085264 4289478737 4289610579 4289610579 4289807958 4289414742 4289349206 4289807952 4289481050 4290069843 4289480786 4290071641 4290466388 4289809498 4289811037 4290859096 4290596697 4291124311 4291125088 4291121754 4290533718 4291122780 4291126115 4290992212 4290991708 4290995041 4291908964 4291451747 4291778903 4292104798 4291125854 4291911786 4291255140 4291319637 4292969841 4293031511 4290269013 4291253323 4290728539 4290135890 4290333272 4290267728 4290204767 4291319899 4290666335 4290797664 4290073692 4291585373 4290008666 4290671991 4291323238 4291190882 4290536285 4290669174 4290999919 4291128171 4290144888 4291125609 4291326834 4291655023 4291392897 4291260774 4290539636 4290931325 4291132804 4290599789 4291198581 4291724161 4291133055 4292248706 4290937980 4291989897 4291723378 4291403940 4292063384 4291858581 4292323227 4291999381 4292128161 4292717464 4292066233 4292720030 4292652445 4292195743 4292655525 4292786330 4292520354 4292525490 4292787619 4292524720 4292458928 4292723381 4292524721 4292787105 4292196012 4292460726 4292458665 4292127400 4291669676 4292065468 4292068803 4293053632 4293252549 4294106311 4293978063 4293713614 4291415494 4289942635 4287837003 4289085006 4289677658 4290072410 4290464598 4289875546 4290466394 4290005335 4289480533 4289283928 4290596439 4289939542 4289677909 4289612643 4289086813 4290923090 4289613668 4291124827 4291913336 4292112746 4292508781 4292969325 4292837995 4293166956 4293427318 4293100665 4292706940 4292968314 4292968315 4292510064 4292244836 4292241504 4291322978 4291058525 4291188571 4291190366 4290469728 4291781732 4292439651 4292573292 4292574318 4292444528 4292510579 4292832346 4292836189 4292443506 4292899424 4292706655 4293162351 4292835938 4292900447 4292440683 4292966513 4292508768 4292572510 4292506971 4292573037 4292574319 4292507503 4292965468 4292509298 4292508781 4292507245 4292508782 4292508527 4293163631 4292641648 4292771437 4293298035 4293036399 4292970099 4291054932 4284551486 4284418890 4283765827 4283962182 4284420679 4284156989 4283895362 4284486724 4284948298 4285013315 4285668422 4285079365 4285472845 4285077822 4285338430 4284353869 4284027709 4284488773 4285210694 4284883786 4285473363 4284423238 4283831878 4284685123 4284619074 4284816967 4285144388 4285874271 4285472839 4283634236 4283173186 4282975035 4285608264 4291458162 4293170051 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293562239 4293363824 4293560170 4293033068 4292898400 4291254870 4290134603 4288556105 4288294987 4288298577 4288360779 4288755274 4289086037 4291057490 4292437847 4292442226 4293559133 4293232238 4293629301 4293562745 4293173109 4293562745 4293564785 4293562489 4293562990 4293363564 4293429869 4293165679 4292769873 4292765542 4291254869 4289808467 4288755532 4287376455 4287378765 4288360779 4288759633 4289147722 4289217106 4288956757 4289679211 4289480277 4289610579 4289677914 4289414742 4289217106 4289480278 4289610579 4289742423 4289938002 4290071635 4289349465 4290464850 4290267736 4290925146 4290204765 4290796639 4290665311 4291122516 4291120977 4290532180 4291121498 4291124066 4291055191 4291322719 4291582043 4291058269 4290929248 4291256412 4291844961 4290863193 4291254098 4291846494 4292040538 4291845974 4293822582 4290662996 4290861662 4290727765 4290138203 4290529107 4290271069 4290268001 4290140265 4290731871 4290797665 4290138201 4290862694 4290006363 4291324529 4290599251 4291062655 4290009699 4291257969 4291128940 4291061369 4290603117 4290732133 4290734701 4291653999 4291062898 4291065459 4291062898 4290997371 4291328364 4290933631 4290738547 4291330179 4291395956 4292116341 4291396743 4291985011 4291595663 4292255122 4292120198 4291795350 4292392852 4292651177 4292191886 4292654514 4292590757 4292652442 4292059806 4292197539 4292719775 4292060826 4292196529 4292788398 4292721057 4292521377 4292723391 4292985510 4292522910 4292655281 4292262060 4292783265 4291668394 4291868346 4292133314 4293185731 4293382081 4293776579 4293580229 4293906882 4293841860 4294171848 4294108878 4294567630 4291937730 4288296255 4288753738 4288625743 4289545814 4289283937 4289547610 4289676116 4289546328 4289283414 4290528593 4289348701 4290072163 4289546851 4289546329 4289085004 4289678167 4290201959 4290597977 4291715937 4292309607 4292967537 4292706412 4293623677 4292969578 4292968827 4293560167 4293034362 4292640619 4293559662 4292575856 4292574832 4292374117 4291190627 4290991706 4290004047 4290071641 4290528852 4291124829 4291518314 4292769642 4292505959 4292969070 4292444272 4292836723 4292834141 4292509042 4292770659 4293162084 4292835937 4292443504 4292507759 4292572251 4292509553 4292506716 4292508016 4292964973 4292507499 4292509297 4292899932 4292442225 4292898137 4292445301 4292901216 4292836465 4292444530 4292837741 4292837229 4292707695 4292969584 4293625966 4291386974 4286063690 4283963980 4283764543 4284487237 4284161085 4284547901 4284490568 4284681796 4284421700 4285273659 4284751435 4285471299 4284882244 4285143101 4285076018 4284551487 4284419384 4284554302 4285406524 4285275977 4285275204 4284359756 4283964750 4284160315 4284619597 4284292167 4285080137 4285739350 4286856292 4285080651 4283565884 4283371332 4285473614 4289291386 4292051591 4293366651 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293363562 4293495674 4292640879 4292703322 4292110435 4290793300 4288758859 4288162118 4288231503 4288887117 4288165967 4288688458 4289480788 4291911770 4291980391 4292901724 4293361259 4293234545 4293561711 4293562990 4293563770 4293562225 4293563776 4293170287 4293627507 4293167739 4293495412 4293164892 4292443235 4292306785 4291713875 4289479241 4288689740 4287966791 4287375175 4288361036 4288755789 4289085520 4289217106 4289348692 4289478479 4289412943 4289676372 4288953936 4289612115 4289677658 4289217106 4289807958 4289807958 4289546585 4289478738 4290201685 4289874265 4290333528 4290205015 4290924113 4290138196 4290665568 4291056986 4290598493 4291123293 4291125593 4291058526 4291192160 4291517029 4291256925 4291126368 4291582307 4291126368 4291256932 4291254097 4291386214 4291911772 4291780194 4292112744 4291977044 4291056981 4290727765 4290135891 4290924119 4289612388 4290859351 4290728545 4291255387 4290732646 4290138201 4290205533 4290665314 4291388510 4290930034 4291191396 4290600545 4291256931 4290602851 4290733942 4290079599 4290734448 4290663514 4291196286 4290864246 4290603377 4291128436 4291262576 4290736242 4290471789 4291127656 4291000453 4291923840 4291390312 4291789698 4291659642 4291466388 4291989137 4290999432 4291732636 4292912273 4291730846 4292590243 4292981915 4292585889 4292190113 4292591535 4292652700 4292649373 4292065198 4292722350 4292587932 4292523688 4292917931 4292590765 4292851360 4292128157 4292261026 4292322715 4291670198 4291936192 4293053123 4293513410 4293446334 4293316289 4293646022 4293183165 4293644480 4293186499 4293512898 4293841604 4294040264 4294108621 4294371795 4290935674 4287243584 4287706446 4289413708 4289808723 4289414230 4289414485 4289547102 4290005077 4289480793 4289611863 4289609808 4289480020 4288759893 4289415530 4289348433 4290401379 4290664290 4291519598 4292702053 4292509294 4292835953 4293100393 4293362041 4293035377 4292969324 4292968828 4293296743 4292443774 4293232239 4292507243 4292767848 4291125084 4291316561 4288823116 4289217100 4289085522 4290268760 4290665820 4292043883 4292507256 4292508781 4292903277 4292836207 4292836976 4292441179 4293160545 4292769120 4292444257 4293228405 4292834655 4292508768 4292899183 4292900191 4292900190 4292442222 4292902515 4292506457 4292902255 4292509025 4292900972 4292899677 4292442720 4293162611 4293164888 4292770418 4292706411 4293427576 4293560684 4292699745 4287441481 4283697204 4284228167 4283830594 4283963707 4284353603 4284291389 4284161093 4284684605 4285666879 4285147217 4284682805 4285472325 4285340224 4285078340 4284424267 4284028494 4284746556 4284752459 4285210441 4285801294 4284095298 4284552775 4284161100 4284090685 4284749370 4284752970 4285869920 4286727778 4285676132 4285405765 4283698746 4285473616 4289093741 4290937978 4292970870 4293040756 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293431420 4293558375 4292705903 4292962905 4291384659 4289676106 4288032585 4288755788 4288821838 4287575630 4288753736 4288559182 4289217873 4291056468 4292701542 4292442976 4293165677 4293429357 4293563509 4293564782 4293561971 4293367417 4293564018 4293430643 4293561984 4293430893 4293232751 4293361242 4292834147 4292307042 4291647059 4290527823 4288557899 4287967562 4287311431 4288886860 4288624718 4289085264 4289151570 4289544273 4289413200 4289808739 4289153366 4289873488 4289807959 4289217363 4289480021 4289610579 4289217363 4289611864 4289480793 4290005592 4289941589 4290398801 4290336093 4290205022 4290727506 4291251287 4290599254 4290598236 4291123292 4291122003 4291058262 4291060066 4290927693 4291515746 4290928992 4291322205 4291320410 4291449953 4291650139 4291583320 4291452768 4291978345 4291715928 4290992984 4290727509 4290138204 4290793554 4290728539 4290794578 4290730591 4290666335 4291191134 4290732391 4290730078 4290731624 4290601317 4291124321 4290534501 4290928733 4290141544 4290731875 4290798698 4290136149 4290800497 4290666843 4290671993 4290732899 4291524993 4290404970 4291458684 4290992994 4291063669 4291652199 4291326847 4291588973 4290932851 4291589747 4290798182 4292512647 4291458414 4291594879 4292386963 4292382337 4291926928 4292195228 4292653980 4292059300 4292197025 4292654490 4292586137 4292126625 4292592311 4292717210 4292191381 4292787888 4292655779 4292718757 4292128411 4291861395 4291733676 4292195766 4292133571 4293512640 4293776321 4293317828 4293313467 4293316802 4293314750 4293643198 4293251781 4293642941 4293185217 4293972931 4293448130 4294235332 4293714379 4293910217 4292267982 4289418847 4287047750 4288297809 4288561231 4289874517 4289217108 4289677657 4289807701 4289414485 4289481051 4288694366 4289743192 4289545823 4289150815 4289152603 4290465121 4290598233 4291585133 4292505720 4292507754 4292444529 4293426790 4292969837 4292640365 4293232500 4293231208 4292836986 4292969853 4292838767 4292509038 4292703594 4291389288 4290795613 4289085007 4287705419 4287705419 4289018188 4290989400 4291256420 4292110441 4292704876 4292508524 4292641410 4292834132 4292441967 4292837217 4292835186 4292508786 4292834391 4292900192 4292506222 4292507740 4292509041 4292507759 4292900190 4292900713 4292507501 4292902254 4292507997 4292509041 4292509040 4292507997 4292770930 4292770674 4293098091 4292969083 4293298043 4292901482 4289020754 4284158534 4283962696 4283828551 4284221503 4284746552 4284615486 4284288332 4285535542 4285143102 4284882500 4284947523 4285342282 4285471300 4285208893 4284552773 4284091198 4284420919 4285011270 4285668668 4286127171 4284817993 4283698495 4284161097 4284291650 4284685122 4284818768 4285146711 4286197840 4286067550 4285934676 4284159552 4285603658 4288764008 4291067759 4292510072 4292841342 4292972150 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293295978 4292968284 4293358181 4291650892 4290200147 4288626251 4288162888 4288756559 4288754250 4288166993 4289281102 4288952653 4290201682 4291124055 4292043615 4292900449 4293165933 4293232492 4293562747 4293562996 4293170800 4293563768 4293562233 4293170294 4293629042 4293167733 4293492840 4293163872 4292833633 4292372819 4291382608 4289090905 4289279050 4287180873 4288032841 4288229708 4289280845 4289019728 4289217106 4289151570 4289478737 4289807958 4289610323 4289414743 4289349206 4289610321 4289614183 4289546327 4289414742 4289807958 4289872466 4290005849 4290135637 4289810011 4290334554 4290139486 4291253843 4290600289 4290663773 4291122010 4291123036 4291059296 4291646296 4290994784 4291517286 4291385946 4291713121 4291256670 4291321950 4291255892 4291190629 4291387220 4291650657 4292701281 4291253328 4290857046 4290203219 4290464594 4290858328 4290137689 4290729308 4290731872 4290731110 4290730855 4290140523 4290732388 4290666852 4291450454 4290667367 4291322995 4290076006 4290271837 4290865255 4290139230 4290210939 4290865255 4291191659 4290538870 4291128946 4291259004 4291854703 4290863215 4291594874 4291191902 4291000957 4291063659 4291131519 4291067510 4290995305 4291331974 4291850867 4291395720 4292055942 4291659655 4292385693 4292386191 4292121742 4292588213 4292654744 4292650652 4292194215 4292590245 4292788399 4292587163 4292065199 4292328612 4292782480 4291667107 4291466386 4291731633 4291147709 4293510843 4293381312 4292988610 4293643711 4293708992 4292922562 4293313980 4293315006 4292988610 4293313980 4293315006 4293251266 4293116088 4293249727 4293643969 4293055685 4294236102 4294038725 4294569682 4291936456 4287310907 4287771468 4288888401 4288494413 4289545545 4289085265 4289545815 4289283156 4289543759 4289743192 4289282890 4289741919 4289086028 4289674849 4289221212 4291252823 4291125606 4292505961 4292964971 4292378734 4293035907 4292969324 4293296745 4292837996 4292705900 4293034619 4293296744 4292444271 4292507499 4292638058 4291715940 4290924889 4288035407 4287046985 4287178823 4287310153 4289217358 4291255902 4291324524 4292044137 4292575086 4292901737 4292836466 4292902257 4292440170 4293162339 4292378720 4292902006 4292443762 4292506969 4292966515 4292509039 4292507743 4292898652 4292442221 4292509297 4292834397 4292507761 4292899932 4292836723 4292770930 4293100138 4292772204 4292771709 4293625966 4293165422 4290924622 4284946505 4283762757 4284223282 4284026176 4283960370 4284224327 4284748862 4285273404 4284883534 4285276233 4285078855 4285143612 4284685385 4285013571 4284552516 4284291133 4284092990 4284684606 4285340223 4285276234 4284816969 4284223814 4284093245 4284617795 4284750658 4284225862 4285407814 4286264413 4286136419 4285344342 4285275462 4286196814 4288501354 4291064952 4292249979 4291789944 4291789937 4292645251 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293426275 4292837479 4292044366 4291316554 4288429131 4288686920 4288756559 4289279306 4288626254 4288757329 4288623690 4289086033 4289215559 4291124579 4292374602 4292834659 4293427049 4293036406 4293431917 4293563252 4293563001 4293563000 4293563506 4293628025 4293169270 4293693556 4293298286 4292640883 4292901459 4292306007 4291583831 4289807947 4288559182 4287967049 4287247952 4288427082 4288626263 4289150799 4289019471 4289217106 4289283156 4289610579 4289414999 4289610322 4289807952 4289546329 4289482074 4290332500 4289742166 4289151827 4289807958 4289676629 4289283673 4290465364 4290268757 4290791505 4291189343 4290662995 4290597718 4291121739 4291124056 4291122259 4291057501 4290992990 4291321685 4291450973 4291189852 4291254098 4291256676 4291256414 4291913056 4291124829 4291848034 4291255131 4290662747 4290136914 4290136150 4289938773 4290205277 4290795098 4290730081 4290732385 4290727253 4290665313 4290734701 4291256157 4290732388 4290011249 4291387742 4290073683 4290929253 4290271330 4290140004 4290733406 4290668137 4291126123 4291132537 4291124835 4291588973 4291527283 4291062125 4291786087 4291455348 4290934902 4291389303 4290935924 4291986051 4291192699 4291528566 4291191674 4291792251 4292710799 4291985020 4292514434 4291990665 4292124056 4292716182 4292588951 4292187020 4292129436 4292717463 4292586395 4292522391 4292657586 4292784038 4292118394 4291464862 4291667113 4292328890 4292660677 4293577662 4293187783 4294036670 4293248444 4293576379 4292985772 4293379517 4293315519 4293381055 4292985788 4292986045 4293313980 4293774782 4292924613 4292985011 4293707452 4293252549 4293120965 4294237897 4293776581 4294042317 4291075495 4287309378 4287114311 4289607243 4287971409 4289413714 4288825172 4289281873 4288759634 4289677408 4288627810 4289282124 4288953696 4289217361 4290464855 4291120990 4291584612 4292308324 4292507755 4292968573 4292837736 4293232491 4292836988 4293230200 4292707694 4293493112 4292969067 4292640895 4292900459 4292638058 4291979619 4290204508 4288559695 4286651719 4285797702 4286060871 4288822606 4290466133 4291321954 4292374890 4292373624 4292510832 4292901488 4292837741 4292443505 4293161550 4293161331 4292770650 4292834404 4292899439 4292441433 4292900978 4292507741 4292507758 4292900720 4292835936 4293227619 4292441692 4292442223 4292769116 4293554540 4292965995 4292639600 4293754980 4293822064 4291522407 4286915399 4283895101 4283828024 4284223290 4284549177 4284681536 4284614974 4284421438 4284948036 4285076803 4285472835 4285472067 4284947526 4286062665 4284619586 4284355399 4283893572 4284292935 4285209670 4285342282 4285078079 4284159299 4284290630 4284617796 4284882245 4285742956 4285217376 4285932623 4285677155 4286132575 4285606727 4285674335 4288760686 4290541176 4291200377 4292117629 4291263608 4291919987 4292248695 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292770404 4292506203 4291779157 4289479242 4288623691 4288755531 4288166736 4288035664 4289216592 4289213514 4288690510 4288493133 4289546326 4291123798 4292636008 4292443232 4293033838 4293299573 4293365370 4293563245 4293564018 4293563263 4293365106 4293365113 4293237366 4293037938 4293296748 4293493087 4292440929 4292372831 4291319123 4289742675 4289280846 4287179847 4288687174 4287574604 4289410122 4288496464 4289348178 4289151056 4289478737 4289871953 4289412943 4289808739 4289348943 4289546329 4290071127 4289284194 4289546322 4289873494 4289349206 4289610837 4290531413 4290269532 4290334292 4290138204 4290728787 4290598751 4291188052 4291123294 4291123293 4291123036 4290994008 4291582821 4291255131 4291255893 4291648608 4291584346 4291714404 4291321178 4291125603 4292373100 4291318607 4290664029 4290138197 4290857554 4290203995 4290924119 4290728280 4290730344 4290138970 4290794329 4290074983 4291454303 4290665822 4290731110 4290072152 4291454565 4290139484 4290929004 4290205795 4290206558 4290731357 4291127928 4291125605 4291128180 4290533725 4291129717 4291128170 4291260290 4291589228 4290862697 4291328131 4291454315 4291391850 4291918719 4290736503 4292114284 4291261557 4291725680 4292048762 4291921517 4292316815 4291590785 4292384907 4292581255 4292185479 4292585373 4292654746 4292125083 4292125588 4292262314 4292979609 4292056199 4291728515 4291269027 4292263097 4293051319 4292988868 4293774526 4293644482 4294035899 4293248445 4292986301 4292656823 4292919996 4293381313 4292985788 4292986044 4292986301 4292919737 4293053120 4292985788 4293773243 4293318597 4293313723 4293314750 4293314237 4293185729 4293844169 4293844168 4293844428 4289957778 4287636798 4287181132 4288951883 4288757072 4288692815 4288956494 4289412963 4288891230 4289412941 4288104292 4289347663 4289217364 4290070101 4291123546 4291452516 4292768104 4292507756 4292771946 4293296776 4292968825 4293165415 4293428328 4292707441 4292575855 4292378479 4292509547 4292707200 4292504935 4291258476 4291059292 4289020498 4286654535 4285272634 4285993284 4287572551 4288756303 4291451740 4290732132 4292899431 4292573035 4292510321 4292837741 4292901745 4292441967 4292835695 4292835179 4292836972 4292507758 4292508015 4292834652 4292900977 4292507500 4292507499 4292509039 4292443761 4292832092 4293228658 4292834928 4292246893 4293426024 4293361020 4293625192 4292967789 4288885066 4284420419 4283829044 4283960899 4284093258 4284289598 4284419391 4284619325 4285340991 4285473869 4285472835 4285013830 4284815683 4285800518 4284357186 4284750925 4283700799 4284355133 4286194755 4285408844 4285207867 4284356925 4284288580 4284224836 4284553791 4284622928 4285277002 4285539666 4285343825 4286072185 4285869912 4286656857 4288763752 4289952379 4291723891 4291527560 4292053878 4291527029 4290867317 4291721823 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4293291345 4292043867 4290397260 4289018190 4288165454 4288165197 4288691537 4289280589 4289085520 4288690253 4288626513 4289147722 4289284428 4291122261 4292109664 4292572767 4293033308 4293296489 4293628032 4293562738 4293170038 4293627762 4293169527 4293562738 4293561722 4293431407 4293101674 4292967773 4292899425 4292174692 4291318604 4290136397 4288623947 4287966279 4287180874 4289083982 4288037457 4289281615 4288430157 4289415009 4289478736 4289217620 4289481309 4289611864 4289414486 4289546323 4290071385 4289348943 4289807959 4289151827 4289742166 4290071129 4289808723 4290989138 4289677145 4290924371 4290073694 4291252307 4290533464 4291124055 4291122259 4290993503 4291453279 4290993751 4291256933 4291322207 4291252558 4292108905 4290927959 4290862168 4292240992 4291451984 4290923090 4289614687 4290528078 4290728795 4290270557 4289612633 4290795356 4290796894 4290136662 4290667370 4291453538 4291122521 4290140515 4290272351 4290535520 4290272608 4289877334 4290335588 4290207591 4290732132 4290599773 4291323239 4291326058 4290729823 4291129200 4290929783 4291528316 4291715939 4290867571 4292117363 4290995555 4292049008 4291328883 4291591294 4292311678 4291130223 4292315267 4292115591 4291265669 4291263349 4291987327 4292450183 4292380049 4291333253 4292325024 4292653986 4292580235 4292129187 4292719258 4292453787 4291591022 4291004051 4291668663 4292590516 4293511873 4293248446 4294102720 4293315520 4292853945 4292788666 4292853945 4292986045 4293447105 4292854195 4293445301 4292987585 4292986045 4293445565 4293051838 4292722359 4293117373 4292853945 4292985275 4292988097 4292989123 4293317571 4292858821 4293843912 4293779915 4294040006 4292859343 4288630886 4287244870 4287967819 4287773009 4288887629 4288231760 4288233294 4288366673 4288824402 4288889937 4288561231 4289413971 4289414742 4290599015 4291977060 4292111204 4292964972 4292772204 4292838524 4293165944 4293166201 4292970367 4293426790 4292968296 4293361528 4292642180 4292444526 4292639083 4292439395 4291058803 4288825164 4287244107 4285072185 4284354104 4286321475 4288952395 4289807701 4291190366 4291584611 4292506989 4292509038 4292836203 4292837999 4292442716 4292899182 4292377436 4292900979 4292506196 4292506219 4292901234 4292833644 4292901727 4292835441 4292898924 4292902252 4292835165 4292379507 4292772448 4293294972 4292771961 4293232254 4293099117 4290332236 4285205564 4284025663 4285352810 4284822872 4285014609 4284550980 4284748605 4285407818 4285408332 4285405507 4284815939 4285538124 4285079365 4284948556 4284619588 4283897151 4284224836 4285210182 4285144648 4285407304 4284292425 4284226115 4284619840 4284749885 4285340223 4285015890 4285211722 4285869661 4286071661 4286460002 4286659932 4287975025 4289949317 4291852150 4291527287 4291988352 4292709491 4290278006 4290998130 4291725953 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4292632923 4291122242 4289675343 4288033355 4288230733 4289216593 4289676874 4287904080 4289282640 4288033869 4289281102 4288560721 4289281353 4291714139 4292109664 4292573539 4293099619 4293102456 4293235574 4293627257 4293170805 4293630322 4293365106 4293561977 4293562995 4293365104 4293493867 4293166192 4292899153 4292044365 4291450463 4289741385 4288690511 4287310918 4288098377 4287773264 4288820812 4288692827 4289479764 4289348435 4289283156 4289281358 4289412945 4289873488 4289217364 4289807952 4289742423 4289412944 4289610579 4289349201 4290267223 4289941589 4289939795 4290333529 4290335061 4290139486 4290794326 4290532958 4291188828 4291123036 4291057757 4291646298 4290994009 4290993247 4291973716 4290928993 4291060066 4291254617 4291256413 4291913313 4291255893 4290662996 4289613148 4291055947 4289547612 4291253337 4290925400 4290860386 4290795098 4290136662 4290733419 4291254875 4290600799 4290600038 4290863200 4290272352 4290337116 4290465634 4289220709 4290337379 4290732131 4291323495 4291126893 4290537577 4290602863 4290800751 4290995815 4292118137 4291391600 4291460982 4291130742 4291326063 4291790465 4291260528 4291721599 4292378225 4291722618 4292245872 4290867829 4291394417 4291917940 4292049789 4291525748 4292049800 4291925897 4292782240 4292646023 4292190610 4292721311 4292450444 4292445831 4291198835 4290945459 4292789953 4292986300 4293511616 4293114791 4293840056 4292787123 4292722359 4292855485 4293446335 4292990149 4292985788 4293248443 4292985781 4292722866 4293575606 4292985787 4292919994 4292788408 4292919994 4292855227 4292989893 4292987841 4294037953 4293252035 4293645251 4293646021 4293844169 4294238667 4293383621 4294173644 4292263612 4287639621 4287376198 4287509838 4287968331 4288493133 4288428880 4288297296 4288494924 4288756560 4288692814 4289217372 4289415266 4291255900 4291256417 4292769643 4292507499 4292771950 4293428078 4293364077 4292968827 4292903274 4293165674 4293232000 4292903273 4292576109 4293227623 4292376958 4291783789 4291191646 4289545300 4286588743 4285074742 4283697991 4285274946 4287114827 4288367443 4290398294 4291518559 4292177512 4292573548 4292900462 4292770929 4293228140 4292769902 4293228661 4292834396 4292442480 4292967265 4292441436 4292507757 4292443761 4292899165 4292442973 4292443505 4292835440 4293161064 4292705394 4292967276 4293558134 4293365102 4292501853 4286323520 4283699020 4284027468 4283896383 4284487739 4284353340 4285009719 4284355910 4285142588 4285275466 4285602621 4285011516 4284685641 4285603395 4284879178 4284488509 4284224837 4284880444 4285801289 4285672009 4284681788 4284423751 4284620873 4284553795 4284751431 4284488000 4284752972 4285608292 4285280084 4286593883 4286003557 4288041063 4289685625 4290609024 4291330177 4291528574 4292118128 4291790727 4290932338 4291724657 4292448647 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4291451727 4289676366 4289016907 4288753736 4288166737 4289217354 4288496209 4289216336 4289083469 4288759377 4288753480 4288624462 4289283661 4291122776 4292109666 4292574547 4292771169 4293558120 4293035886 4293431161 4293628536 4293170813 4293628797 4293170301 4293627513 4293365869 4293495406 4293033837 4292507232 4292438106 4291056462 4290133581 4289148491 4287377482 4287509066 4287314266 4288168015 4289611092 4289348436 4289282899 4289481818 4289480278 4289676372 4289349207 4289412944 4289742423 4289544786 4289415516 4289546586 4289807696 4289217872 4290005593 4290070103 4290399316 4290202189 4290858581 4290664286 4291188307 4290532188 4290599775 4291122516 4291057743 4291123543 4291058783 4290993246 4291582819 4290994271 4291650661 4291649380 4291257193 4291124318 4290138973 4290398807 4290135377 4291384922 4291188828 4290076770 4290268247 4290141031 4290797158 4290730075 4290076000 4290729568 4291321694 4289809240 4290402653 4289873504 4289811299 4290925670 4290208364 4290730587 4291129712 4290929524 4291129198 4291125604 4291061363 4291786087 4291388268 4291461495 4291650147 4291198339 4291722110 4291851892 4292050025 4291592322 4292052855 4291850591 4290013307 4292379763 4290799472 4291461237 4292182397 4291854195 4292385935 4292776582 4292185727 4292262813 4292253324 4292184962 4291198322 4289494917 4291929004 4293380796 4293051839 4293642170 4292986045 4292920509 4292655536 4292920252 4292986046 4293512384 4292923075 4293641657 4293445823 4292722873 4292854202 4292459445 4292130222 4292262585 4292986814 4292722359 4293446848 4293317573 4293776580 4293317829 4293511611 4292988354 4293379003 4292987841 4293250754 4293120708 4294303433 4294170309 4294437842 4289759128 4287703871 4286917188 4286983751 4287509839 4287378253 4288560464 4287707216 4288757072 4288691536 4289151049 4290006116 4291123034 4291715422 4292702312 4292509295 4292771693 4293232497 4292968827 4293033573 4292838783 4293033577 4292903273 4293101443 4292640636 4292641406 4292639081 4291782242 4290862430 4288626002 4287899723 4284090419 4283959607 4284355660 4286391377 4288889437 4289349216 4291126369 4292045668 4292636519 4292509295 4292903277 4292379249 4292836460 4292375642 4292509810 4292963178 4292442480 4292965726 4292442477 4292964715 4292376940 4292900977 4292834395 4292835184 4292770399 4292967278 4293294956 4293821029 4292836206 4289017154 4284025156 4283960381 4284286789 4283962696 4284354884 4284420938 4284357700 4286192963 4285012284 4284816708 4285405763 4286129228 4284687178 4285272375 4283962687 4283696184 4284748349 4285080135 4285931331 4285603140 4283896382 4284421692 4284553795 4285143619 4284422464 4284621388 4285275221 4285539921 4286135144 4286070375 4288107377 4290080390 4290805621 4291593091 4291527815 4292050544 4291658863 4290406769 4291592306 4292120186 4292121721 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290659661 4289152078 4288098891 4288231758 4288756301 4289085265 4289150544 4289019472 4289348685 4288689997 4288099403 4288559182 4290069321 4290727766 4292308316 4292571230 4292378209 4293298287 4293430901 4293430904 4293171061 4293627261 4293629047 4293430903 4293364856 4293628295 4293232492 4293034094 4292507999 4292243053 4291121992 4289746266 4289213515 4287376198 4287379795 4288493130 4289019981 4288561743 4288825172 4289348436 4289480015 4289480279 4289019728 4289808215 4289806417 4289742420 4289742423 4289544787 4290069836 4289481050 4289742166 4289940057 4289940045 4289808462 4290989652 4290139479 4290664029 4291122259 4291323746 4290533728 4291122260 4291124056 4291057244 4291582300 4290928471 4291517027 4290994528 4291516513 4290995557 4291190365 4290796894 4290860636 4289679195 4290274665 4290135637 4290730077 4290793561 4290202969 4290795605 4290664797 4291256419 4290664797 4290336347 4290727511 4290270041 4290337378 4289813085 4289814382 4291387996 4290536049 4290668651 4290533221 4291197298 4290928237 4290473073 4291520602 4290868344 4291590253 4290926946 4291461495 4291654249 4291852922 4292049764 4292116865 4292380789 4291323500 4290869122 4291657331 4291260788 4291787129 4292114814 4291327861 4292709254 4291985537 4291924619 4292782745 4292516234 4291459442 4290604404 4291073694 4292915381 4293250491 4292985529 4293248435 4292985786 4293248443 4292985271 4292854716 4293248444 4293840054 4292392885 4293707963 4292723386 4292457905 4292722096 4292656566 4292987073 4292985788 4293116856 4293841345 4292919995 4292854202 4293445306 4292656567 4292919738 4292853945 4292527039 4293052607 4292986558 4293381824 4292989123 4292923074 4293120450 4294366148 4293385421 4290096818 4288042371 4287444040 4287573575 4287574860 4287377996 4288426827 4289414225 4288688458 4289019728 4289873486 4290795868 4291716197 4292243044 4292899436 4293165417 4292836986 4293427830 4292969083 4293427573 4292837996 4292902522 4293297528 4292837225 4292444526 4292964716 4292440166 4291321951 4289478214 4287046728 4285400888 4283636806 4284029768 4285209924 4287379531 4288824913 4290791509 4291060576 4292503145 4292572265 4292509038 4292836208 4293098607 4293555552 4292439654 4292442719 4292964443 4292440939 4292899693 4292376941 4293294194 4292376682 4293162866 4292771184 4292705136 4293493112 4293689701 4293362542 4291515983 4285403710 4284355647 4283828281 4284026163 4284420665 4284091454 4284488771 4285144901 4285342283 4285605456 4285667643 4284815940 4284817997 4285270329 4284683583 4284680254 4284290124 4285473347 4285734729 4286127683 4284223805 4284486205 4284752975 4284882759 4284949323 4285211980 4285738062 4285606229 4284883528 4285741172 4288302703 4289096831 4290871157 4291199865 4291789700 4291987835 4290936951 4290738564 4291789945 4292119417 4292383100 4292318608 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288954192 4288688458 4288230990 4288166736 4289215053 4289282893 4288759373 4289150544 4288625744 4288691792 4289213771 4289083981 4289218131 4291188569 4291977302 4292571482 4292969090 4293494121 4293430894 4293561977 4293432435 4293693053 4292842611 4293430904 4293364844 4293363567 4293495406 4293033306 4292505196 4292239952 4291058778 4290135627 4288624718 4287311946 4288097350 4287769414 4288166734 4289346640 4289414485 4289282899 4289676896 4289218645 4289480278 4289873495 4288954193 4289414737 4289610574 4289349201 4289939800 4289676623 4289610839 4290596434 4289874266 4290466647 4289742424 4290205277 4291253082 4291124311 4291122781 4291123021 4291123294 4291122262 4291059296 4291320922 4291517284 4291257189 4291319376 4291257449 4292570720 4291056723 4290662747 4290728281 4290731359 4291319643 4290139228 4290203225 4290859353 4290206559 4290729308 4290730846 4290074979 4291255645 4290072922 4290798693 4290533488 4290733420 4290928230 4290206557 4290139744 4290666084 4291325028 4291128945 4290536034 4291131507 4291124578 4290344058 4292116085 4290799985 4291527286 4291649659 4290802029 4291853440 4291258471 4291853178 4291916400 4291394933 4291587693 4290930796 4292048751 4291918447 4291657848 4291918977 4291654764 4292055688 4292385166 4292251781 4290932846 4289684330 4291932343 4292785316 4292658613 4293112489 4293118146 4292525495 4292392875 4293051832 4293316034 4293445566 4292459958 4292786865 4292986301 4292788665 4292522158 4292264894 4292589997 4292853945 4293513668 4293313979 4292525493 4292525237 4292393651 4292788408 4292854459 4292788408 4292722359 4293446848 4293052607 4292986814 4292988353 4292987841 4293381824 4293317571 4293710274 4293448901 4293907396 4294765264 4292336078 4289367705 4286455362 4286916938 4287573830 4287968845 4287770699 4288296782 4289151055 4289217623 4291253081 4291715679 4292440427 4292899435 4292378992 4293297531 4292969578 4292903274 4292970372 4293428326 4293034618 4292902520 4292772474 4292706172 4292575086 4292241766 4291188571 4288757839 4287114830 4285271610 4284419134 4284096074 4285011264 4285468219 4288034640 4289414731 4291321696 4291191904 4292571499 4292508012 4293164142 4292705644 4293162083 4292443745 4292900978 4292440683 4292508270 4293225822 4292833371 4292442222 4292835182 4292771184 4292705135 4293165434 4293689443 4293099377 4292176232 4286981963 4283827781 4283962167 4283894086 4284221510 4284289598 4284554565 4285537350 4285998667 4285275722 4285603396 4285210442 4285209919 4285537091 4284485444 4284223813 4283964479 4285140795 4286390345 4285867336 4284158282 4284290371 4284224837 4284687181 4285079114 4285209410 4284750680 4285080647 4285341786 4285279305 4287117150 4288964216 4291262591 4291395969 4291854207 4291463035 4292183930 4290605940 4291133559 4292186500 4292056962 4292317834 4292253055 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288757072 4288165965 4288757328 4289281872 4288494672 4289150800 4288558413 4289150800 4288757587 4288625744 4289281102 4288493133 4289347147 4291188566 4291584090 4292638828 4292769626 4293364079 4292970355 4293627775 4293038439 4292972163 4293692801 4293561979 4293563773 4293430655 4293102197 4292838258 4292965984 4292242533 4291056727 4290202194 4289149517 4287900742 4287377738 4288425801 4288757586 4289281098 4288953935 4289348949 4289412943 4289677652 4289610580 4289151564 4289677908 4289807703 4289349201 4289807953 4289479251 4290071386 4289743699 4289545046 4289940052 4290332748 4290269532 4290792535 4290595671 4290598237 4290533207 4291189591 4290532189 4291124055 4291122002 4291059040 4291124312 4291318094 4291125086 4292637289 4291980376 4290595416 4290333006 4290858584 4290726486 4290535257 4291254365 4290139228 4290268761 4290268761 4290729564 4290860379 4290140254 4291255137 4290728288 4290732904 4290665569 4291452506 4290009707 4291451997 4290079607 4291126892 4291125350 4290736749 4291125350 4290338153 4291657085 4291191667 4292113504 4291918464 4290928486 4291918448 4292048750 4291263357 4291983987 4291918453 4290863727 4291591278 4290735228 4291128946 4290933876 4291262080 4291391599 4291329402 4292314245 4292383380 4292577145 4290142052 4290804620 4292394679 4292986550 4292457902 4292982174 4292394684 4292392355 4293643195 4292788926 4292917155 4293641907 4293182910 4293182650 4292393909 4292985270 4292788667 4292656046 4293513154 4292129708 4292657079 4292327859 4292656822 4292920252 4293051837 4293051838 4292854202 4293839549 4292986045 4293052864 4292987071 4292987071 4293380799 4293380542 4292988097 4293315006 4293314750 4292859333 4293645509 4293120964 4294171849 4294436301 4293450958 4289893531 4288890191 4286978886 4287574087 4288099405 4287837515 4288689997 4289612110 4290662746 4291583839 4292702568 4292509295 4292509808 4292903275 4293494651 4292837738 4293427575 4292837243 4292705899 4292970347 4292968585 4292448127 4292571495 4292307815 4290534239 4290004815 4287571270 4285142341 4284748855 4284157247 4283893561 4285404734 4286783304 4288295755 4289874002 4291911269 4291912294 4292636519 4292771692 4293227884 4292377181 4292836726 4293160542 4292901475 4292506219 4292442733 4292901235 4292441947 4293162867 4293098605 4293032814 4293294698 4293362282 4293229673 4289346377 4284351027 4283697464 4284287047 4283632957 4284353598 4284812606 4284551741 4285472067 4285471042 4285800264 4285081163 4285210183 4285668421 4285341514 4284357447 4284353598 4284878134 4285474125 4285210438 4284749898 4284748347 4284556109 4284682031 4285670476 4284555853 4285277516 4284621385 4285078876 4285801558 4286070131 4288631926 4291066484 4291459455 4291264897 4291460978 4291659645 4291462522 4290936181 4291923847 4292383610 4292318594 4292253056 4292711050 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287708496 4288297805 4288756816 4288562000 4289348173 4289282637 4289085265 4289282637 4289150544 4289282128 4287968333 4289216591 4289283417 4291187274 4291783016 4292639073 4292771423 4292969070 4293692541 4293365621 4293235845 4293693556 4292843399 4293235073 4293627778 4293429365 4293100909 4293492830 4292441952 4292239960 4291188821 4290465108 4288757843 4287900742 4287376967 4288361292 4288755018 4289150800 4289282643 4289085515 4289873752 4289217364 4289610573 4289874275 4289151569 4289546586 4289610579 4289349206 4289612121 4289742167 4289283402 4290071643 4289939271 4290334552 4290859090 4290728019 4291187025 4291125089 4291123798 4290533727 4291125337 4291123286 4291124576 4291122522 4291060322 4290994017 4291455074 4292307556 4290992730 4290267479 4290469730 4289610836 4290203995 4291253082 4291122515 4290729308 4290206303 4290203225 4291385692 4289549919 4290924376 4290073179 4290796638 4290139997 4290728793 4290665571 4291322204 4290011510 4291389289 4291586927 4291063407 4291058269 4291458670 4292114802 4290930791 4292315007 4291786365 4290734447 4292380546 4292046692 4291324527 4291721325 4291128449 4292114785 4290995312 4290997619 4291653225 4290996071 4291590258 4291392881 4292115826 4291129710 4290473331 4290932844 4290077046 4291533715 4292853422 4292918703 4292984750 4292918709 4292196277 4293050779 4292657847 4292653467 4292721576 4292460218 4292392623 4293048230 4292459703 4292722608 4292854717 4293182127 4292591545 4292390829 4292394165 4293379772 4293314751 4292262835 4293707184 4293315777 4293379516 4292987328 4292985788 4293379772 4293381312 4292985788 4292985788 4293381311 4292986814 4292988353 4293774783 4293052091 4293710273 4293577149 4293251267 4293839804 4293840833 4294436044 4293387220 4290083700 4285470268 4287373896 4287048775 4287377481 4288821326 4288954188 4291318874 4291126623 4292569961 4292573292 4292444273 4293100907 4292640893 4293231994 4293165671 4292837244 4293101163 4292443774 4293494647 4292837483 4292572010 4292110432 4291188572 4289283150 4287572301 4285597756 4284489546 4284091960 4284483636 4284552770 4286056509 4287574606 4289939283 4290135630 4291651427 4292504681 4292965228 4292379763 4292901997 4292770401 4292834913 4292505691 4292506974 4292898156 4292834910 4292836725 4292770142 4292705394 4293034089 4293298028 4293493363 4290729045 4285598521 4284288583 4283960382 4284157758 4284353349 4284617029 4284619592 4285600832 4285146442 4285340739 4285340227 4286060866 4285014606 4284686921 4285270329 4284485444 4284881984 4285276234 4285866823 4285409366 4284682812 4284552259 4284884817 4284816714 4284946496 4284947527 4284686925 4284554825 4284816706 4285609576 4288962667 4289951608 4291592835 4291002741 4291393408 4291002743 4291002744 4290933875 4291791492 4292120960 4292318607 4292711808 4292318593 4291793016 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288821325 4288755789 4288691536 4289216078 4289085008 4288496208 4289479245 4288561233 4288627280 4288625744 4289346125 4288757331 4289348687 4290665569 4292174946 4292573022 4293098354 4293429612 4293036146 4293430398 4293301366 4293431677 4293430140 4293693046 4293234808 4293233523 4293363821 4292968558 4292900449 4292438110 4291122517 4289610836 4288889426 4287900485 4287377738 4288361804 4288756046 4288627536 4288693325 4289414224 4289480529 4289085521 4289478737 4289546584 4289546328 4290528845 4289545044 4289610580 4289349201 4289807953 4289742417 4289806932 4290069842 4290333011 4290267993 4290137429 4290728283 4290597715 4291123293 4290535265 4291124063 4291125081 4291124319 4290534239 4291122002 4290664792 4293238918 4291121482 4290856788 4289479760 4289544789 4289415251 4290594127 4290072410 4291452253 4290665311 4290794844 4290137690 4290664790 4290860379 4290731359 4290795100 4290793303 4290205533 4290863974 4290074465 4290664804 4290864216 4291261048 4291059555 4290800245 4291396483 4291782264 4291656574 4292116106 4292245111 4290803317 4291587182 4291260784 4291723393 4291195774 4290800239 4291394677 4291848056 4291063665 4291128945 4291129204 4291128429 4290997106 4291854447 4291062899 4290078830 4290405991 4290476433 4292126109 4292782492 4292722340 4292850344 4292723391 4292854451 4292919989 4292849583 4292916903 4292524729 4292587681 4292786856 4292590768 4292129727 4292591024 4292722611 4292521896 4292327091 4293182649 4293052095 4293707192 4292591544 4293641656 4293447362 4292393653 4293643710 4293314237 4293379772 4292987328 4292986045 4292985780 4292987072 4293248186 4292788409 4292987327 4292986814 4292987071 4292986815 4293316545 4293710787 4292923331 4293252035 4293184447 4293514950 4294105543 4292994773 4288499035 4285401407 4286849864 4287573830 4288298322 4289085260 4290794075 4291847008 4291782243 4292572010 4292837741 4293230458 4293035375 4292836987 4292968297 4293231206 4292968330 4293099365 4292904316 4292835951 4292573803 4292242022 4291124574 4289480017 4287575378 4285274173 4284681527 4284417863 4284615738 4284550196 4284812343 4285993536 4287901258 4289807433 4291190624 4292043875 4292438889 4292900445 4292836981 4293227360 4292441704 4292506734 4292505946 4292833134 4292832603 4292836723 4292771185 4293096815 4292837757 4293950824 4291916392 4287570755 4284089925 4283896630 4284550476 4284554301 4284223814 4284946488 4284945474 4285208632 4285602108 4285801546 4285011266 4284947526 4285540685 4284816457 4284684861 4284552517 4284750399 4285540172 4285142588 4284091959 4284418872 4284488772 4285012290 4285013059 4285542734 4284160846 4284620616 4283963721 4285606493 4288173424 4290344836 4291790711 4291329921 4291068279 4291134328 4291131764 4291129460 4291134587 4292119941 4292383616 4292318606 4291924606 4292318607 4292317320 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288165709 4288756558 4288823116 4288627299 4289348171 4289150544 4287970896 4289022282 4289348174 4288691280 4288035408 4288627535 4289546069 4290597202 4292373612 4292112726 4293163101 4292773495 4293299065 4293496184 4292709999 4293102455 4293234551 4293039477 4293232746 4293496449 4293100651 4293231468 4292506972 4292242793 4291124055 4289283152 4288099156 4287968341 4287966277 4288427340 4288165454 4289412176 4289282637 4288953679 4289151058 4289151058 4289413201 4289807957 4289808738 4289545043 4289414743 4289610574 4289610574 4289349207 4289742167 4290071379 4289874517 4290333011 4290268754 4290859610 4290664285 4290662490 4291121497 4291125592 4291123037 4291123037 4290533462 4291252825 4290858327 4292905851 4293828215 4291317335 4289348689 4290070615 4290530648 4289545045 4290399320 4290269018 4290793043 4290729565 4290730839 4290660951 4291253082 4290075231 4290859096 4290138971 4290205287 4290271068 4290074726 4291453787 4291127668 4291124319 4290993760 4291000180 4291588719 4290862177 4291329653 4291918959 4291328884 4291461238 4291647062 4290409595 4292115311 4291851115 4291724164 4292245112 4292308853 4290937207 4290929527 4291195257 4290600294 4290603890 4291260530 4290077552 4290731881 4289879414 4291993492 4293180855 4292586654 4292519312 4292913055 4292526256 4293575588 4292656821 4292522917 4292524969 4292522412 4292787623 4292000444 4292587177 4292788132 4292655269 4292585111 4292522411 4292459438 4293445566 4292854459 4293248443 4293117371 4292920251 4292393909 4293839550 4292986045 4292657080 4293247928 4292854458 4293051581 4292919737 4292987328 4293448386 4292985788 4293380800 4293379516 4293381312 4292986044 4293051581 4293051067 4292989636 4293383107 4293317058 4293252293 4293582537 4293512896 4294301639 4292002237 4285471030 4285994566 4287703623 4287835977 4289282894 4290333267 4291454043 4292242024 4292572009 4292772207 4293427045 4292969085 4293231206 4293034364 4292839283 4293295733 4292642156 4293164935 4292444780 4292768638 4292242788 4291125857 4289480016 4287508044 4285665855 4284420422 4284814653 4284488256 4284615739 4284287285 4285074748 4286782793 4288821324 4289939794 4291386958 4292109923 4292636267 4292572761 4292510836 4292507502 4292964701 4292506205 4292833885 4292898160 4292442972 4293162354 4292706925 4293100137 4293098352 4289543242 4284025922 4284224068 4284353865 4284486972 4284288838 4284420925 4284747320 4285865803 4285406789 4285144394 4285406786 4285211722 4285471810 4284948299 4284554051 4284354878 4284684348 4285407305 4284751431 4284948041 4284224573 4284358475 4285209926 4285341769 4284683835 4284357962 4284094521 4284882008 4285342800 4287053150 4289620345 4291790467 4291593350 4291462277 4291129457 4290275697 4290278787 4291659643 4292185734 4292055432 4292055937 4292318592 4292384143 4292122752 4292317064 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288758608 4288624206 4289412171 4288628297 4288757326 4289348429 4289216336 4289083214 4289346634 4288626001 4289346381 4288556874 4289546317 4291256163 4291716430 4292964703 4292706673 4293232236 4293299059 4293037177 4293562994 4293234302 4293693309 4293430397 4293628037 4293168239 4293299321 4293623670 4292507758 4292242792 4291384144 4290333264 4288890204 4287310660 4287443016 4287838286 4288297037 4289216593 4288691785 4289217107 4289546066 4289480529 4289610580 4289610580 4289414741 4289217107 4289612114 4289349201 4290003796 4289740368 4289546579 4289610839 4290070088 4290333786 4290333009 4290139743 4291253843 4290532957 4291190624 4290597981 4290596685 4291188308 4291253338 4290073692 4290987858 4293771397 4293692788 4290658888 4289478220 4290396240 4290335579 4290136919 4289811293 4290403423 4289678170 4290270556 4290333271 4291255134 4290532182 4291318617 4290071384 4290730846 4290729568 4290666336 4291254874 4290471541 4291322199 4290206070 4291914596 4291452762 4291783548 4291717756 4291851372 4292249220 4291718231 4290404472 4290343793 4292178792 4290733675 4292379262 4291061883 4291916911 4291196546 4291061355 4291129715 4290012266 4290734444 4290994528 4290603640 4290139743 4290409086 4292259994 4292714126 4292854184 4292915110 4292522647 4292458153 4293245846 4292784556 4292523424 4292588197 4292524457 4292590256 4292521643 4292656543 4292589992 4292583578 4292064695 4292588722 4292723385 4292722616 4292525495 4293181878 4292657080 4293445566 4293445565 4292921534 4292852402 4293448901 4292722359 4292722872 4293051837 4293447104 4293051581 4293051580 4292986044 4293051837 4293051837 4293051837 4292919737 4292985530 4292985529 4292329917 4293117630 4292987584 4293317315 4293710018 4293580742 4293516489 4293582025 4293189576 4288766079 4288560201 4287046214 4287441482 4288822091 4289676880 4291779417 4292044369 4292573807 4292837742 4293035374 4292903531 4292902525 4292904814 4293034361 4292706938 4293099897 4292968311 4292510062 4292572008 4291914339 4291517793 4289217107 4288098635 4285996361 4284550205 4284420677 4285402683 4284484672 4284418363 4284811319 4285730366 4287047241 4289412939 4290790732 4291387736 4292043612 4292176746 4292703335 4292572759 4292503380 4292635479 4292963937 4292507468 4292508271 4292705393 4293032813 4293624701 4291451981 4285601344 4284026692 4284157502 4283961654 4284289350 4284420924 4284883787 4285537092 4285340995 4285207351 4285470784 4285145162 4285601850 4285276233 4284883017 4284354364 4284488516 4285015115 4285537866 4284883016 4284553804 4284160579 4284620101 4285406018 4285998153 4284488525 4284419906 4283567945 4284422214 4286725481 4289489286 4291659136 4291921798 4292051328 4291527027 4291132278 4290014581 4291397244 4291856503 4292055164 4292776842 4291990401 4292383612 4291989375 4292384144 4292122236 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288759117 4289413709 4288562001 4289216080 4289150800 4288625488 4288625488 4289022282 4288757582 4288755533 4288166737 4288691792 4289217365 4290661717 4291847767 4292573808 4293099628 4292969325 4293299060 4293495929 4293235058 4293693816 4292973176 4293233009 4293167478 4293693571 4293103229 4292837741 4292508512 4292242010 4291386717 4289940057 4288755531 4287376453 4287378520 4288556624 4288298064 4288624461 4289478483 4288953936 4289544268 4289217366 4289873746 4289151821 4289612121 4289546327 4289742945 4289807701 4289349206 4289546585 4289676372 4289742419 4291056229 4290335571 4290205535 4290791248 4291123286 4291185751 4290532180 4290664534 4290731104 4290140768 4290201942 4290136159 4291455078 4294037153 4292311126 4290132816 4289545815 4290529361 4290268257 4289284954 4290466138 4290269017 4290858071 4290729821 4290793300 4290663251 4290664286 4290598236 4291323745 4291125600 4291124058 4291124835 4291126118 4291124569 4291063423 4291190368 4290142836 4291390845 4291262319 4291852911 4292117111 4291322976 4290667901 4291456867 4291587449 4291192953 4291722357 4291258733 4291982701 4292049008 4290930791 4291388517 4291192942 4291324527 4290925141 4289744479 4289547879 4290611101 4292389794 4292971900 4292524207 4292654230 4292855493 4292915880 4292523432 4292520851 4292522648 4292522655 4292524716 4292788400 4292394145 4292719780 4292057236 4292589743 4292526265 4292590509 4292723129 4292523698 4292459701 4293247924 4292721330 4293379772 4292854202 4292854202 4293511101 4292722873 4293115573 4293118913 4292722615 4293313979 4292854202 4292985530 4293117373 4292986043 4292788408 4292788407 4292985530 4292594371 4292592318 4292594114 4293116860 4292988610 4293447360 4292990405 4292924613 4293644481 4293909705 4293845194 4294173645 4291483848 4288564822 4285861700 4287049543 4288754251 4290070873 4290995559 4292701547 4292505699 4292901739 4292706158 4292903534 4293099368 4292904062 4293427572 4292838530 4293232491 4292902776 4292640894 4292965227 4292242278 4291122778 4289480278 4287508808 4285929542 4285339704 4285076037 4284420671 4285207360 4284352820 4284418358 4284156213 4285793851 4287113292 4288889423 4289741894 4290662483 4291129974 4291531413 4291995050 4292520622 4291464597 4292110417 4292569440 4292382347 4293358179 4293232238 4292766033 4287046216 4283764035 4284355140 4284156989 4284554059 4284418876 4284552774 4285208123 4285144383 4285606224 4285406788 4285009722 4285603652 4285408075 4285078597 4284488002 4284685895 4285471302 4285145934 4285211726 4284288828 4284553794 4285210437 4285472587 4285867850 4284552764 4284553788 4283369798 4283763774 4285934680 4288568950 4291199106 4292314496 4291986045 4290740867 4290605939 4290474868 4291593849 4292185216 4292448391 4291987584 4292188029 4291988874 4292317569 4292383883 4291793783 4292382859 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289346384 4288759123 4288755786 4288757581 4289216336 4288234317 4289413200 4287970897 4288888909 4288757329 4288165194 4288689998 4289085261 4290728270 4292373610 4292507240 4293164383 4292969326 4293299060 4293431154 4293235067 4293430136 4293431159 4293627774 4293430647 4293430652 4293496447 4293231211 4292900192 4292043606 4291387228 4289873492 4288099670 4287377737 4288097349 4287772238 4288298065 4288624202 4289480272 4289348938 4289346897 4289283401 4289150031 4289873752 4289544786 4290071385 4290071384 4289348949 4289480278 4289742682 4290071905 4290007397 4289875544 4289808216 4290923606 4290141538 4290727249 4290535009 4291252825 4291189085 4290596953 4290794074 4290465366 4289741917 4294033303 4294295162 4291781220 4289346383 4290071384 4289349988 4290005590 4289940056 4290529364 4290203738 4290792535 4291254876 4290072154 4290664542 4291252560 4290597210 4291712865 4291058523 4290928505 4291123802 4290404445 4291454318 4291125855 4291061357 4291652462 4290864238 4292379776 4292110434 4290731626 4291391867 4291719773 4291063179 4291522926 4291326561 4290802549 4291786618 4291852418 4290934385 4291912545 4289358199 4291455341 4289808734 4289219944 4289551720 4291734176 4293243543 4292587172 4292457120 4292654489 4293242527 4292655516 4292457888 4292585628 4292587678 4292520601 4292787878 4292589993 4292586645 4292254611 4291667115 4292655014 4292657595 4293182392 4292851381 4293051320 4292657080 4292525237 4292655527 4292591545 4292525493 4293511359 4293051837 4293051838 4292853944 4292198587 4293117373 4293117374 4292854458 4293576894 4292593089 4292461501 4292129202 4292919993 4292395966 4293117373 4293117886 4293055685 4293052350 4293051324 4293051324 4292988353 4292987584 4293381568 4293315776 4293251780 4293516232 4293844938 4294305488 4292133810 4286123835 4286650951 4287771979 4289350228 4291518036 4291848804 4292637802 4292444785 4293099627 4293099371 4292706158 4292773232 4292902523 4293100911 4292836985 4293100153 4292642931 4292573291 4292110182 4291321693 4289546589 4287048522 4286062409 4284551991 4284483910 4284944952 4284682047 4284550210 4284681525 4284549431 4283959348 4284549437 4286915133 4288302443 4291603632 4293315521 4293449929 4293777865 4294564037 4292987842 4291926703 4292588218 4293054148 4292713353 4292571235 4288756046 4284814404 4283895110 4284418116 4284095292 4284684876 4284620103 4284683835 4285080656 4285863238 4285538116 4285274694 4284684866 4285474902 4284950359 4285604425 4284424011 4285209670 4284750398 4285012803 4284880970 4284552246 4284489804 4285342536 4285472073 4285340479 4284618308 4284290371 4283960394 4284685639 4287582582 4290999424 4291463031 4292117893 4290869363 4291129711 4290344836 4291327870 4291725181 4292119941 4291989882 4292448892 4291989898 4292382340 4292317053 4292316032 4292186485 4292316791 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288758608 4288301138 4289281872 4288691280 4288691280 4288756816 4288033613 4289609290 4288624206 4288755789 4288754507 4288755790 4288692041 4290793820 4291847775 4292703338 4292313460 4293232236 4293299066 4293430391 4293300606 4293037939 4293495933 4293169014 4293496183 4293233271 4293299316 4292968299 4292900972 4292178028 4291453278 4289350748 4289346379 4287376204 4287378765 4288950089 4288754507 4289282641 4288496464 4289543760 4288953935 4289544787 4289871954 4289217614 4289283156 4289217364 4289282899 4289546072 4289019465 4289677393 4289481059 4290204248 4289941083 4290465618 4290333529 4290202705 4290726226 4291253338 4290007902 4290730583 4291252056 4290858066 4289807188 4291713374 4294237096 4293830260 4291974498 4289018959 4290071127 4290007130 4289610837 4290070101 4290858584 4290859866 4289481305 4291254621 4290662746 4291252055 4290661464 4290006101 4290203480 4291387485 4290467931 4291256931 4291648614 4290863200 4291979630 4290929772 4291587938 4291520879 4290863208 4290869112 4291593323 4291983471 4291389554 4291981907 4290864244 4291195516 4291981933 4292049010 4291126886 4290398812 4289882748 4291584607 4289747556 4289088603 4290411400 4292582565 4292708978 4292522155 4292457381 4292917424 4292912012 4292522658 4292322710 4292981153 4292523945 4292588205 4292592567 4292255379 4292120977 4292579217 4292590005 4292587930 4292917428 4292852395 4293115057 4292657337 4292393132 4293050550 4292854716 4292392627 4293444533 4292788668 4292984237 4292986045 4292722616 4292985787 4292853944 4292985787 4292854200 4292919737 4292328115 4292656309 4292986814 4292987070 4292788151 4292985787 4293117373 4292463036 4293444795 4293054146 4292922303 4292985273 4293052351 4292988097 4293381825 4292989123 4292924357 4293975240 4293779402 4294305486 4293387214 4287116112 4286651204 4287968076 4289480017 4291124575 4292307559 4292637545 4292510321 4293099627 4292706413 4293099370 4292902524 4293100907 4292705899 4293100155 4292706153 4292968571 4292573547 4292109926 4291323489 4289347404 4287051599 4286125381 4284419909 4284617277 4284553798 4284549952 4285142074 4283762748 4283764019 4283369531 4283828018 4287784580 4293251273 4293516482 4293646270 4294105032 4293180837 4292459448 4292722102 4293383364 4293973444 4294300611 4293844430 4291139482 4284942132 4283565129 4283699528 4284226630 4284353603 4284491593 4284419899 4284815945 4285539914 4284750144 4285538380 4284619847 4285406280 4285013571 4285801805 4285144644 4284161096 4285865797 4284884045 4284879670 4284682814 4284554052 4284948299 4285276743 4284945218 4284550980 4283893827 4284619852 4285145925 4287842417 4290014851 4291659394 4292118392 4291788670 4291066483 4290933119 4290936949 4292119421 4291988611 4292120968 4292383889 4291989115 4292446848 4291859833 4291987575 4292383620 4291989116 4292317063 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288295500 4288298832 4288756816 4288168016 4288756816 4288758864 4288757072 4288298061 4288758864 4288166737 4288755531 4288034126 4289348938 4290793299 4291716183 4292047472 4293230168 4293166706 4293299058 4293628542 4293235315 4293495934 4293037949 4293495932 4293037437 4293496190 4293299310 4293033837 4292441693 4292437846 4291058007 4289939280 4288298065 4287508038 4286917191 4288491850 4288229707 4288692049 4289278794 4288494672 4289282899 4288953678 4289283413 4289346895 4289348693 4289414222 4288562258 4289150794 4289546851 4289217886 4289414484 4289546072 4289610837 4290135893 4289742936 4290991195 4290138203 4290663002 4291383890 4290072917 4290793299 4289807443 4289412175 4292515208 4294171287 4293431403 4290925402 4289347409 4289809250 4290333269 4289609554 4290466651 4290138202 4290792277 4291256672 4291124054 4290662490 4290203216 4290729820 4290596971 4290730844 4290534501 4291255388 4290466136 4290996590 4291979641 4291061093 4291455597 4292113548 4291522145 4291325298 4291453797 4292312193 4291392114 4290991707 4290800756 4291979882 4291919224 4291850080 4291320926 4289025632 4289882478 4291122779 4289679970 4289353583 4291855247 4292387221 4292652444 4292580498 4292457881 4293445556 4292850338 4292588192 4292185480 4292713367 4292124300 4292588978 4292592566 4292649881 4292124323 4292192921 4292787895 4292521359 4292983736 4292456096 4292722613 4292852395 4292459959 4293248701 4292392106 4293050030 4292657338 4292458925 4293050285 4292657081 4292393652 4293183158 4292986045 4292722614 4292788150 4292131254 4292262840 4293117374 4293051838 4293248186 4293446848 4292527552 4292590773 4292985787 4293117117 4293052863 4292528065 4293185218 4292329660 4293117886 4293054146 4292986558 4292987841 4293448386 4292858564 4293909704 4293450439 4293714382 4290086794 4285073212 4287508038 4289414223 4291058524 4291848036 4292114544 4292508525 4293099626 4292902781 4293231210 4293232492 4292837741 4293034619 4292904818 4292968058 4292838524 4292638827 4291718502 4291254369 4289483354 4287640396 4285665854 4284422213 4284617278 4284681024 4284617013 4283566902 4284092209 4282977361 4283106112 4288841626 4293843405 4294104261 4294038215 4293575593 4292258465 4292392634 4292462529 4293316288 4293907909 4293383878 4293777094 4293907653 4293252292 4284749892 4283434819 4283767113 4284092997 4284161355 4284487752 4284291145 4285341511 4285408587 4285539147 4285012805 4285737294 4285014602 4285012290 4284095560 4285275205 4285079628 4284620359 4285604682 4284489805 4284749372 4284226890 4286063167 4286065495 4285209925 4284027709 4283765312 4284221501 4286723940 4289422214 4291593598 4291723918 4291921268 4291264898 4290869631 4291000177 4292119423 4292120454 4292056952 4291860094 4292315764 4292383110 4292187513 4292054662 4292447617 4291987830 4292382855 4292316278 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288498782 4288298830 4288166224 4288757072 4288757072 4288624205 4289215053 4288625744 4289216336 4288689997 4288754251 4288690767 4289279819 4290267472 4292108894 4292636521 4292772466 4292969324 4293101181 4293628028 4293167224 4293430385 4293431409 4293430654 4293233008 4293430653 4293299317 4293361513 4292901217 4292176741 4291452253 4289217880 4288818760 4286850375 4287572807 4287901769 4288428879 4288754251 4287970126 4289413965 4289151564 4289151058 4289546066 4289283151 4289283151 4289283151 4289807445 4289085515 4289676115 4289480272 4289611859 4289547867 4290071128 4289283928 4290530648 4289808472 4290202193 4290794331 4290136145 4290794588 4290659666 4289479765 4289872990 4294364576 4293835912 4293491047 4290924881 4289545302 4290069842 4289872978 4291121497 4289808983 4291448918 4289548647 4291382613 4290532701 4290598749 4291189085 4291189590 4290532442 4291255644 4290993005 4290535275 4291124575 4290994274 4291455338 4291519850 4291060064 4291524211 4292438900 4290929515 4291130488 4291584346 4290927712 4290933111 4291982190 4292114535 4291914084 4290469479 4290076273 4290535518 4289807195 4289152092 4290080385 4291924870 4292383881 4292645265 4292523169 4292523683 4292977034 4292458660 4292646026 4292060821 4292718240 4292058523 4292456092 4292717199 4292252292 4292191906 4292590250 4292982702 4292587930 4292587432 4291995536 4292589217 4292524977 4292524977 4292523422 4292917931 4292526008 4292456104 4293051058 4292131514 4292591030 4292525493 4292788666 4292525493 4292786092 4292195765 4291934652 4292788150 4292788408 4293511358 4292986045 4292658618 4293248186 4293053120 4293117374 4292722615 4292985788 4293051581 4293052863 4293052606 4293183678 4292530117 4293051067 4293118399 4293052350 4292989636 4292989123 4293644996 4293910987 4293779145 4292267984 4286651715 4286983240 4288560208 4290793563 4292045407 4292503399 4292575855 4292771694 4292969068 4292903277 4292904822 4293033577 4293164918 4293231739 4292903528 4292640893 4292638827 4292438887 4290073941 4289676882 4286982470 4285799238 4284550968 4284354117 4284288820 4283370549 4283699001 4282712131 4284358478 4289963446 4293646266 4294105803 4293643196 4292585098 4292128438 4292988356 4292989379 4293977549 4293842629 4294107595 4294108621 4294042829 4294107082 4294635220 4287065477 4282778435 4283896887 4284093253 4284224841 4284290370 4284947784 4285737551 4285405760 4284685641 4285076795 4285211464 4285802062 4285144390 4285144386 4284227147 4285011255 4285407306 4285275461 4284292165 4285341766 4284488517 4285931337 4284227146 4284554059 4284354371 4283631940 4285929804 4288764516 4290675074 4292315783 4291920255 4291395189 4291391100 4290804609 4291395973 4292119157 4291990153 4292842377 4291990415 4292384137 4292055689 4291593854 4292448388 4291988604 4292053633 4292054397 4292382081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288297294 4288232016 4288757072 4288691279 4288625744 4289413965 4289217102 4289217101 4289217101 4289151056 4288626257 4288622152 4289217866 4291319133 4291848030 4292638303 4292835420 4293428332 4293036140 4293627775 4293628278 4293366398 4293167223 4293430398 4293628022 4293234821 4293101678 4293428589 4292507229 4291846484 4291190360 4290070095 4288164169 4287506503 4287573831 4288098634 4287182159 4288820043 4289216593 4288953936 4289412688 4289546323 4289412940 4289676367 4289610575 4289610580 4289217620 4289283157 4289808215 4289151828 4289610579 4289676374 4290005592 4290660693 4290399577 4289677401 4291384149 4290662747 4290139743 4290792272 4290926172 4289018959 4291780698 4294435506 4293635962 4293500024 4291910241 4289479509 4289413715 4290071641 4289545557 4290400603 4290793813 4290398032 4289483102 4291189846 4291513684 4291123548 4290466908 4291453278 4290008417 4291257438 4291122005 4290799993 4291585635 4291190372 4291456370 4292175970 4291123805 4290998387 4291783770 4289482070 4289682558 4291721065 4292045419 4292113257 4291126376 4290402652 4291261556 4290861658 4289807966 4289088090 4290934911 4292648077 4292714909 4292582809 4292521630 4293309857 4292450186 4292578947 4292583574 4292128928 4292124315 4292192667 4292784032 4292252289 4291727763 4292254619 4292655003 4292587422 4292588448 4292061350 4292588699 4292590517 4292520873 4292722869 4292721584 4292524462 4292460216 4292984243 4292526008 4292850082 4292985002 4292195755 4292590263 4292588960 4292194485 4292130229 4292722871 4293379772 4292722872 4292986044 4292657079 4293445565 4293051838 4292722872 4292984757 4292985788 4293183167 4292656557 4292985788 4293117116 4292527039 4292921023 4293182652 4293117373 4292395452 4292592831 4293051067 4293052094 4292990405 4293582024 4293976523 4292797126 4289301149 4285927995 4288754763 4290859854 4292242010 4292703337 4292315014 4292968810 4292903276 4293231207 4292968572 4292839278 4292968826 4293230951 4293100155 4292903805 4292182632 4291912803 4290794844 4289348431 4287838031 4285140022 4283961909 4283567667 4283700029 4283239749 4282974263 4285613674 4292197573 4293581762 4294235853 4293378212 4291530116 4291345093 4293515205 4293579973 4293907653 4293777350 4294105030 4294104773 4294040520 4294041802 4294042572 4294437328 4291672506 4282384963 4283306835 4283832401 4283897406 4284355907 4284554051 4284291138 4285998153 4284815424 4285867337 4285535551 4284095816 4284552259 4284421188 4284683835 4284816971 4285078594 4284157767 4284226370 4284750920 4285605707 4284749890 4285734210 4284356933 4284288838 4285145936 4287581547 4290868112 4291462018 4292642674 4291330693 4290804611 4291002741 4291462007 4291791231 4292384395 4292382339 4291923579 4292448890 4291987583 4292054913 4292448133 4291989385 4292382597 4292448381 4292053368 4292053624 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288756816 4288757069 4288625743 4288823123 4289413964 4288430672 4289217100 4289348695 4289414474 4289017933 4289085520 4289083982 4288954190 4290794062 4291715683 4292634968 4292378724 4293165163 4293496705 4292972141 4293236351 4293563255 4293694584 4292842602 4293430143 4293233265 4293101936 4293165675 4292507760 4292636263 4291646038 4289216332 4288296268 4287506247 4287048519 4287442503 4288556102 4288231758 4288757581 4289480016 4288953679 4289217615 4289806155 4289349464 4289742417 4289807960 4289545038 4289545295 4289872718 4289742418 4289479509 4290267215 4289283929 4290399578 4289937993 4290922829 4290597725 4291187025 4290728787 4290204259 4290267990 4290263903 4291724674 4294302618 4293897075 4292834920 4291185234 4289152342 4290069331 4289019985 4290726485 4289810267 4290529365 4289677144 4291320412 4291125605 4290661207 4290598748 4291776862 4290533730 4291057752 4290006634 4290537328 4291387234 4291390321 4292309353 4291189335 4289876839 4291259505 4290597717 4288825690 4291193717 4292309864 4292112740 4291063920 4290928744 4291258474 4291454301 4290728794 4290268502 4290530661 4291133583 4292973696 4292579977 4292520595 4292980388 4292584858 4292451996 4293038210 4291661714 4292710272 4292056215 4292724154 4292714890 4291662999 4292651685 4292651154 4292588955 4292581004 4292585883 4292586393 4292589471 4292590522 4292586647 4292525484 4292981921 4292524970 4292587176 4292983466 4292460216 4292525237 4292526265 4292194224 4292261786 4292585636 4292128685 4292460214 4293839034 4292459958 4293510841 4293117114 4292722872 4292985787 4292920251 4292984243 4292854201 4292264381 4292656557 4292919737 4292132537 4292722101 4292593088 4293118655 4293182652 4292330173 4293182652 4292592575 4292593857 4293054402 4293051323 4292462016 4293317572 4293911244 4293844681 4292663248 4288496469 4287967560 4290201675 4291583842 4292309864 4292572264 4292578682 4293297277 4292968073 4293362790 4293166705 4292970109 4292903275 4292771692 4292444527 4293096301 4291455079 4291059808 4289413708 4286126918 4284483892 4283371325 4283371334 4283172414 4282844217 4288179348 4292729549 4293711046 4293973167 4292389521 4291200918 4292593860 4293055428 4293973189 4293841346 4293448901 4293841090 4293842117 4293382594 4294104261 4294103491 4293976010 4294372042 4293648852 4283961675 4283372103 4283830592 4283830591 4284420682 4285144643 4284883017 4284686152 4285539147 4285472591 4284421691 4285603659 4284225596 4285603396 4285670222 4284881987 4284550724 4284226622 4284357961 4285406279 4285143879 4285407304 4284424267 4284419655 4284621907 4287379035 4289622647 4290935935 4292315782 4291593348 4291460725 4290997871 4291264385 4291595395 4292447616 4292381565 4291923594 4292382597 4291989131 4292448891 4291988358 4292382587 4292381823 4292054396 4291660158 4292448383 4292053633 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288824658 4288625487 4289479507 4288561743 4289019472 4289478223 4289281360 4289742159 4288888144 4289412944 4289018189 4288952910 4289807176 4290137949 4291583057 4292638577 4292836959 4293362796 4293233267 4293628287 4293170036 4293628784 4293170052 4293431421 4293628534 4293364857 4293495405 4293361514 4292506972 4292176470 4291056966 4289741648 4288229448 4287444045 4287574346 4287443274 4287966022 4288232529 4288625741 4289282130 4289348949 4289806161 4289742680 4289545044 4289740619 4289283666 4289938255 4289872975 4290068307 4289873484 4289806926 4289940315 4290069584 4290333011 4290335581 4290202194 4290662227 4291122267 4290731103 4290272615 4290069586 4289346384 4294296213 4294168726 4293502093 4292832848 4290202713 4289347408 4289217362 4289547109 4290530647 4290004565 4290923346 4290138203 4291253843 4290731874 4290135115 4290137177 4291455586 4290659148 4289879148 4292109922 4291717477 4291455339 4291258216 4290467424 4290603899 4291387231 4290072670 4290011765 4291191398 4292113782 4291586923 4291453280 4290929257 4291521883 4290728538 4289679451 4289940311 4288758611 4291333012 4292908935 4292586145 4292515987 4292982179 4292517530 4292055705 4292711303 4292122773 4292120971 4292058528 4292719522 4292117883 4292055442 4292653474 4292588703 4292588193 4292650898 4292058266 4292581267 4292526261 4292915374 4292526523 4292588195 4292652455 4292129435 4292653219 4292197814 4292520102 4292786846 4292789440 4292852134 4292060570 4292585906 4292592569 4292983481 4293443757 4292262837 4293248442 4292328373 4292852137 4292985786 4293117114 4292788408 4292591287 4292986036 4292853945 4292919738 4292262583 4292592830 4292853944 4292985530 4293116860 4292528835 4293182652 4292528322 4293185474 4293118142 4293052607 4293116860 4293052350 4292989635 4293250497 4293712327 4293778119 4290490297 4287832891 4290332236 4291453270 4292767849 4292508785 4292642676 4292838269 4293166957 4293363820 4293100156 4293364080 4293231487 4292773231 4292968814 4292178017 4291848803 4290333266 4288365903 4286781504 4284026420 4283305019 4282909757 4283765566 4289501106 4293841863 4293973703 4293446838 4291793795 4290220967 4292527551 4293317316 4294366405 4293448386 4293578948 4293642941 4293120963 4293580230 4293643455 4293772213 4293382851 4294040520 4294306507 4293845708 4286069342 4282977615 4283765063 4284617544 4284817477 4284552003 4284488259 4285209148 4285013319 4285274429 4285210441 4284617020 4284488774 4285274429 4284222525 4284222784 4284223300 4284949322 4285078083 4284752715 4286195275 4284750918 4284816974 4283898175 4286454858 4288503158 4291000716 4292578695 4291987063 4291723134 4291262335 4291264641 4291659143 4292448388 4292317052 4291923590 4292777341 4292250487 4292382838 4291989126 4292384123 4291988358 4292383621 4292381824 4292120702 4291858293 4292381825 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288627280 4289216080 4288102988 4289150288 4289217100 4289151058 4289348687 4289085517 4289742159 4289085523 4289414736 4288952397 4289086550 4290858072 4291321687 4292505690 4292837217 4293099628 4293430645 4293564280 4293628535 4293170047 4293694324 4293627262 4293169530 4293628543 4293166955 4293427048 4292442224 4292635996 4291057504 4289939799 4288230219 4287441991 4287508039 4288097863 4287115852 4289346381 4289150800 4288693587 4289282894 4289677909 4289545044 4289545038 4289742418 4290070606 4289807189 4289676882 4289677132 4289611347 4290135377 4290332496 4290004818 4290333773 4290267736 4290139999 4291186508 4291121490 4290662234 4290337886 4290202474 4290069583 4294167464 4293770886 4294159207 4292638067 4290067274 4289543503 4289151827 4289939540 4289415000 4289939799 4290269531 4290859610 4290927455 4290067530 4288888914 4290929762 4290071394 4290535017 4292305769 4290864233 4290994531 4291848805 4290469475 4290733931 4290792020 4290074721 4290536042 4292703595 4291658604 4291321444 4290925663 4291126365 4291651693 4290599004 4290204763 4290595934 4289744485 4292250517 4292776595 4292518302 4292581517 4292589474 4292121229 4292644479 4292318341 4292252038 4292121499 4292719007 4292648079 4292121215 4292456366 4292586910 4292975753 4292588183 4292585361 4292192156 4292650647 4292523442 4292912774 4292724410 4292586133 4292657333 4292063390 4292652204 4292586648 4292587171 4292591788 4292063668 4292254594 4292059296 4292589493 4292985527 4293576634 4292984757 4292525233 4292983472 4292591545 4293116856 4292130995 4292454812 4292985267 4292986045 4292854201 4292591030 4292986045 4292853944 4292658626 4292461244 4292985530 4292593089 4293118656 4293182910 4292985530 4292986813 4292787638 4292658623 4292658367 4292396735 4293118399 4292526526 4293053633 4292988866 4293450439 4293189840 4289027441 4289476682 4291059289 4292375651 4292508784 4292969069 4293428585 4293165162 4292969332 4293166956 4293099626 4293035116 4292838771 4292508527 4292770927 4291125857 4290595662 4288692813 4285009466 4283107382 4282515518 4285282137 4290686396 4293582542 4294301635 4292525209 4291461498 4290814386 4293053635 4293318854 4293973189 4293448890 4293642946 4293249470 4293315520 4293774015 4293117884 4292788409 4292919740 4293579715 4294103235 4294043086 4294370769 4286599264 4282910795 4283764292 4284158283 4284485961 4284554050 4284685638 4284947012 4285537604 4285212241 4284814646 4284683071 4285274429 4285011523 4284812861 4284221765 4284422717 4285078341 4284683062 4285997129 4284554308 4284817231 4284354374 4284947008 4287579494 4290671246 4292447362 4291921799 4291855475 4291788927 4290871156 4291528059 4292119422 4292317061 4292250496 4292710271 4292250743 4292316546 4292183930 4291989381 4292775810 4291987830 4292053633 4292382080 4292053633 4292053367 4292448128 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289282637 4289151059 4289479760 4289348943 4289151058 4289348692 4289480274 4289283151 4289412946 4289283151 4289544275 4289086285 4289740364 4290663765 4292307296 4292373589 4292770148 4293362796 4293234286 4293234806 4293629559 4293694063 4292842889 4293236333 4293694330 4293169519 4293692280 4292969583 4292901474 4291979623 4291124039 4289283160 4288165454 4287441990 4287378509 4287836233 4288885835 4289084238 4289085264 4289151052 4289937491 4288954193 4289545294 4290003797 4289479252 4290006357 4290002770 4289807183 4290002764 4290135633 4290005850 4289415770 4290595152 4290203476 4290858584 4290727000 4291252057 4290533215 4291385684 4289872981 4289740360 4290990425 4294435246 4293836680 4293564021 4293167453 4290070360 4289018957 4290071641 4290201686 4289349208 4290466651 4290529364 4290596441 4288560460 4289613412 4291449945 4291124574 4291125856 4291125086 4291060318 4291978597 4290992473 4290864757 4291256667 4290071131 4290470781 4291192422 4291322485 4291980650 4290733168 4290339170 4291586411 4291718252 4291127146 4290271073 4290266193 4289944420 4292385172 4292906617 4292513408 4292977808 4292519831 4292645255 4292646539 4292251008 4291920786 4292714133 4292719265 4292118407 4292122771 4292979625 4292456594 4292980897 4292518297 4292058264 4292581793 4292586654 4292589746 4292588956 4292522161 4292585365 4292130741 4292061599 4292721588 4292587681 4292591021 4292585377 4292649118 4292647812 4292194493 4292592051 4292917170 4292654502 4292591545 4292591543 4292985013 4292982199 4292655262 4292591803 4293116085 4292721849 4292389791 4293182388 4292788667 4292854201 4292854193 4292788403 4293183151 4293118915 4292987842 4292984496 4292854202 4292524202 4291935935 4292526781 4292658624 4292593087 4293051065 4292658623 4293051580 4293052863 4293052350 4293053632 4292990149 4293646277 4292003019 4289354358 4291056972 4292437350 4292575585 4292771953 4292640366 4292969584 4293364078 4293297003 4293362795 4292969582 4292837233 4292181335 4292505449 4291253332 4288628554 4288360010 4283565621 4283633992 4287653511 4292069580 4294302666 4293907124 4292720029 4290872983 4291212734 4293118398 4293711044 4293905600 4293513408 4293643970 4293251257 4293445310 4292262066 4292919994 4292986045 4293313980 4293710529 4293055685 4294105030 4294107338 4294307029 4286793043 4282844746 4284157252 4284553798 4284226368 4284687183 4285210180 4284947783 4285010225 4284224319 4284483904 4284681534 4285079110 4284747581 4284355659 4284618308 4284618813 4284948036 4285603397 4285144647 4283831876 4284222523 4283701832 4286851170 4289553523 4292118158 4291987590 4292117630 4291526796 4291196541 4291330180 4292578942 4291990155 4292710015 4292121203 4292645511 4292250753 4292382839 4291988096 4292448390 4291987820 4292448648 4292053623 4291988088 4292447872 4291988871 4292644735 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289151053 4289348687 4289085517 4289544275 4289480530 4289217364 4289873490 4289152079 4289808211 4289676362 4289217866 4289674833 4289413705 4290728541 4291385942 4293031795 4292769889 4293166958 4293298811 4293301357 4293235588 4293169788 4293694843 4293628537 4293170542 4293629044 4293167476 4293559916 4292706398 4292963434 4291056469 4290005845 4289213770 4287181645 4288557129 4288361033 4288166993 4289214797 4288691795 4289414479 4289545038 4290005592 4289872719 4289415252 4289874257 4290002514 4290266702 4290070610 4290070865 4289938774 4289940045 4290398547 4290858068 4290792013 4290203734 4290138192 4290072143 4291254357 4290006619 4290990167 4289608547 4292243292 4294303406 4293771146 4293825897 4291583838 4290794331 4289609296 4290071898 4289609039 4290203225 4289874264 4290267479 4288361801 4289810026 4290862173 4290534495 4291120983 4291190622 4291192679 4291321436 4291256418 4291715434 4291122004 4290536313 4290866021 4291123288 4290928230 4291913835 4291389805 4291262851 4292508024 4291390064 4291914594 4290529877 4288887116 4290340214 4291984761 4292709238 4292519332 4292580490 4292578945 4292709500 4291922329 4292118662 4292320395 4292191912 4292118396 4292249462 4292056467 4293309865 4292454296 4292977822 4292520861 4292585881 4292056730 4292588952 4292587926 4292589475 4292586404 4292587676 4292587429 4292125069 4292720821 4292060312 4292656308 4292649110 4292318348 4291270320 4292650646 4292592053 4292521112 4292523166 4292851115 4293181106 4292985014 4292591535 4292986040 4292850357 4292915876 4292459958 4292722863 4292723130 4292392371 4292853673 4292986045 4292591031 4292722867 4292457125 4292985520 4292254608 4291409336 4292788151 4292525237 4292919737 4292985530 4293182909 4293248445 4292198330 4292658624 4293117372 4293117116 4292592831 4292592574 4293119169 4292989123 4293383364 4291809741 4291135649 4292239179 4292508004 4293099100 4293231470 4293164635 4293297261 4293165419 4292772207 4293296748 4292836702 4292706166 4291913047 4290204240 4289541189 4285339196 4286858342 4290291638 4293843148 4294040009 4293180585 4291666840 4291336865 4292133826 4293578946 4293973702 4293513408 4293644225 4293183935 4293313980 4293379774 4292722616 4292788408 4293117374 4292854202 4293248188 4293579715 4293841861 4294039237 4294107595 4293846992 4286202461 4282909254 4283568465 4284357696 4284816718 4285080137 4285080910 4285342280 4284815430 4284880184 4285469237 4285008708 4284681528 4284354110 4285011519 4284553276 4285931083 4284881475 4284553534 4285272381 4283893823 4283369020 4285012291 4288169834 4291068814 4292119673 4291724168 4292247673 4291131261 4291329905 4292185216 4291989382 4292382324 4292252290 4292316033 4292251518 4292381815 4291595390 4292447615 4291989381 4292120967 4292053375 4292053890 4292446331 4291396990 4292447862 4292251008 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289151058 4289480537 4289873484 4289217353 4289807948 4290003797 4289676875 4289936464 4290004041 4289084753 4289937998 4289346122 4289611342 4290989651 4291848544 4292439896 4292378467 4293428075 4293299064 4293235076 4293628021 4293694333 4292842874 4293629303 4293564548 4293562232 4293629562 4293231210 4293164147 4292308824 4291058265 4290069830 4289082956 4287836233 4287770697 4288884553 4288756814 4288562257 4289480009 4289019731 4290070866 4289218130 4290264651 4290006100 4290136151 4289480017 4290070360 4290465872 4290070361 4289741640 4290070611 4290595415 4290136665 4290859350 4290138204 4291251800 4291189856 4291120978 4291320152 4289938773 4289411148 4292842880 4294168983 4294166917 4293032301 4292108620 4290397782 4289281874 4288954187 4289676373 4289676630 4290069842 4289018958 4290467176 4290795354 4291520095 4291119701 4291128171 4291185998 4291254106 4291259486 4291190365 4290003538 4290536549 4291320173 4291190641 4290930281 4292304993 4291325806 4291652204 4291124314 4291125084 4291455077 4290071124 4288558152 4290472831 4292908930 4292711296 4292312445 4293169782 4292584857 4292311431 4291591533 4292249476 4292322202 4292783007 4291986050 4291724923 4292649630 4292583579 4292910214 4292522403 4292518039 4292581524 4292588712 4292588454 4292583319 4292584092 4292587410 4292588975 4292586906 4292651417 4292063410 4292583316 4292656557 4292122768 4291989899 4291927458 4293045899 4292525230 4292588967 4292981424 4292586392 4292587932 4292459178 4293047726 4292460216 4292525237 4292723129 4292460215 4292788408 4292459445 4292722615 4292920251 4292392370 4292986045 4293051839 4292198833 4292448906 4291594371 4291738817 4293248437 4292854201 4292264380 4292656565 4293182910 4292198586 4292461502 4292919480 4292919479 4292395965 4292658624 4293116858 4292461501 4292394939 4293120964 4292989379 4293644995 4293516490 4291529626 4292504132 4293163362 4292640883 4293164891 4293295980 4293165677 4293624425 4292969330 4292115803 4292375125 4291714905 4289676113 4287837017 4289364622 4292200905 4294304196 4293378990 4292261026 4291733912 4291603364 4292593092 4293514948 4293249728 4293579972 4293707708 4292919998 4293839285 4292854204 4293117365 4292591029 4292985787 4292919738 4292985789 4293710529 4293120707 4293448645 4294105030 4294106313 4293912005 4286196554 4283305534 4283766856 4284357443 4284423496 4284882248 4285341255 4285344075 4284618043 4284882507 4284355910 4284880951 4285144125 4284548932 4284620623 4284949069 4285996098 4285474126 4285077815 4283762504 4283173169 4283435078 4286854761 4290737525 4292182151 4292250503 4292183421 4291131005 4291788159 4291790214 4292382852 4292317060 4292252036 4292317834 4292316287 4292316279 4292316545 4292447616 4291988096 4292447873 4292052333 4292382338 4292053623 4292054136 4292119681 4292053889 4292380290 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289480273 4289217358 4289807954 4289414745 4289610318 4289283666 4289546325 4289612117 4289151823 4290069584 4288954445 4289872462 4289217098 4291513426 4291912279 4292570973 4293165423 4293166701 4292971385 4293234301 4293629047 4293169780 4293629303 4293562226 4293563006 4293564011 4293562234 4293494379 4292771678 4291980898 4291386719 4289806409 4289082956 4287769670 4288492621 4288295500 4288165454 4289215054 4289151566 4289544268 4289283660 4289805905 4289218392 4290201169 4289871441 4290791505 4289547092 4289940052 4290070604 4290002766 4289807178 4289938513 4290861146 4290135886 4290858317 4290729559 4290594630 4291188566 4290664543 4290202196 4289541207 4293967265 4294103974 4294031226 4292703328 4291253847 4289744988 4289741389 4289544274 4289019728 4289348949 4289941596 4290858584 4291319386 4290727255 4291120471 4290664534 4290656842 4289088860 4290798952 4290661717 4290068579 4291061868 4291845986 4290929507 4291518814 4291322212 4291061866 4291715680 4290007898 4290076263 4291324268 4289810263 4288954213 4290669683 4292119160 4292249219 4292579972 4292712844 4291457644 4292444013 4292185739 4292114806 4291596424 4292057980 4291393414 4292513939 4292980377 4292518308 4292581013 4292515481 4292581515 4292586910 4292588984 4292190092 4292984243 4292190873 4292713624 4292059025 4292060077 4292653469 4292190887 4292718745 4292587681 4292579984 4291595405 4292128166 4292653219 4292521876 4292584600 4292195748 4292588461 4292195758 4292192664 4292588709 4292524728 4292785822 4292525233 4292524975 4292981669 4292459958 4293051837 4292459444 4292459444 4292854460 4292854451 4292983981 4292450970 4290940049 4291931824 4292721318 4292722608 4292854202 4292919480 4292461759 4292985786 4292656565 4292985787 4292985787 4292461759 4292985015 4292197816 4292198073 4292787893 4292658625 4292986299 4293117886 4292465093 4293449927 4292988606 4292835181 4292705888 4293230427 4293165681 4293362523 4292640097 4292771168 4292444002 4292637277 4292504676 4290859862 4289623167 4291869636 4294105545 4293974211 4292984227 4291538596 4292326818 4292391599 4292463043 4293447874 4293709505 4293250498 4293379517 4292854195 4293051830 4292919997 4292788401 4292788409 4292985787 4292919994 4293184189 4293313723 4293186756 4293906882 4294169797 4294038212 4294237897 4293189590 4284354109 4283439690 4284089922 4284290370 4284422217 4284552259 4285078082 4284819025 4285014860 4285210694 4285274429 4284879949 4284748343 4284489285 4285734468 4284617526 4285472325 4285077052 4285208640 4283828274 4283303485 4285406027 4289290875 4291392906 4292120445 4292316039 4291460746 4291264638 4291199106 4292448126 4292317061 4292250494 4292776580 4291987582 4291988096 4292316545 4292382080 4291659905 4292118138 4292053632 4292053889 4292382336 4291988353 4292248452 4292052602 4292119672 4291725697 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289611865 4289480279 4289348945 4289414481 4289743957 4290068043 4290070101 4289349195 4289610581 4289938511 4289610838 4289216589 4290462291 4290924110 4292699482 4292898656 4292705887 4292969583 4293494897 4293628536 4293169272 4293629303 4293565829 4293563499 4293563768 4293563001 4293562233 4293428586 4292968046 4292505967 4291320652 4290596183 4289082699 4287770698 4287770697 4288361036 4288756046 4289147722 4289217357 4289217622 4290333016 4289481044 4289742417 4289806932 4289807188 4290006100 4289609291 4290136153 4290135628 4289675341 4289348682 4290790735 4290924372 4290268238 4290136923 4290204504 4290727763 4290730335 4290923089 4289741396 4288819786 4294495386 4294102677 4293633916 4292239950 4290729559 4291975001 4289283929 4289019728 4289873495 4289612376 4290136148 4291384153 4290661205 4289478482 4291122265 4290068306 4289547867 4292042596 4290533467 4290666091 4291257695 4290992473 4291125362 4291649121 4291455084 4291520121 4291715165 4290466653 4290732902 4290796647 4290925912 4289086557 4290932869 4293233262 4292449174 4292577153 4292711041 4292119933 4292115066 4291457910 4291720039 4292717493 4291262831 4291061880 4292449155 4292581264 4292517786 4292583321 4292517273 4292913301 4292521633 4292583823 4292714903 4292061858 4292645764 4292127903 4292060828 4292647574 4292652700 4292582816 4292655265 4292127660 4292381053 4291331466 4292387222 4292656549 4292587429 4292587171 4292583833 4292587678 4292590507 4292589724 4292586412 4292980381 4292525489 4292523183 4292981166 4292525744 4292456112 4292918187 4292788666 4292986045 4292591031 4293052078 4292854464 4291593076 4291662489 4292262325 4292328613 4292654004 4292131512 4292524980 4293051836 4292722101 4292527295 4292723385 4292788409 4292986044 4292722101 4292329915 4292395451 4292263865 4292590772 4292853685 4291739839 4292984758 4293249471 4293052350 4293053893 4292977564 4292702806 4293428848 4292837213 4292968819 4293163103 4292443232 4292574320 4292243039 4291523712 4291737539 4293252810 4293974457 4293510049 4292194465 4292195490 4292715934 4291739071 4293118657 4293840834 4293514163 4292921024 4293445308 4292919995 4292722617 4293511350 4292722617 4292985780 4292788409 4292919995 4293051837 4293313723 4293252293 4293644224 4293513666 4293776325 4294039750 4294236874 4293511604 4282318914 4283567695 4284490827 4284686411 4284816709 4284554051 4284749895 4284488258 4285078850 4285012805 4284878643 4284549433 4284421183 4284616510 4284291908 4285668165 4284815939 4285079373 4284223299 4283565892 4284157255 4287643236 4291063411 4291987845 4292316039 4291723390 4291788669 4291330434 4292315527 4292251525 4292317569 4292382587 4291923594 4292384380 4292316280 4292316280 4292382840 4292053623 4292447872 4292055174 4292447872 4291986810 4292447863 4291988353 4292119937 4292052603 4292118395 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289480278 4289151571 4290202708 4289742162 4289742161 4289349458 4289349201 4289610581 4289808215 4289347660 4289740878 4289938250 4289612374 4291778385 4291780698 4292899424 4293099099 4292903279 4293298028 4293235318 4293628024 4293563768 4293564784 4293564799 4293563261 4293564535 4293564287 4293495150 4292705886 4292768092 4290992217 4290071110 4288558412 4287770698 4289015367 4288164172 4288757329 4288562256 4289019473 4289283144 4289740626 4289545045 4289937998 4290006866 4289676625 4289611352 4289807183 4290070862 4289676882 4289479765 4290068307 4290070098 4289414225 4290268501 4291447885 4290071130 4291384403 4290201426 4289940314 4289216080 4290133066 4294369464 4293771655 4293560433 4291979870 4292176734 4290404194 4290530135 4289415257 4289413202 4290530647 4290399834 4290329673 4289481559 4290070100 4288952654 4290993498 4291383378 4290469736 4291387487 4290267220 4290532186 4292044133 4291452532 4292111721 4291060319 4290595923 4289942875 4291060854 4291319126 4290206565 4289544785 4290410113 4292570724 4291857035 4292642936 4292711811 4291589741 4292116350 4292050297 4292317326 4291856264 4290534990 4291722370 4292119959 4292645250 4292974978 4292515994 4292582027 4292520605 4292979352 4292649363 4292124053 4291729302 4292777857 4292059548 4292252575 4292589992 4292588723 4292187537 4292653976 4292712842 4292120457 4291730087 4292785558 4292586921 4292580488 4292588703 4292589226 4292585628 4292587668 4292059547 4292713612 4292198314 4292587934 4292583062 4292585873 4292525741 4292522930 4292983480 4292457900 4292854975 4292986293 4293052866 4292258473 4291794574 4291864228 4292392874 4292720295 4292129201 4292263598 4292919737 4292395701 4292198330 4292263865 4292394169 4292523441 4293051829 4292459445 4292788408 4292395709 4292985273 4292198329 4292264122 4292195765 4292985272 4291869884 4291869627 4292724161 4293184193 4292789691 4292966227 4293361515 4293165938 4293032519 4292836466 4292505430 4292638309 4292256436 4292857796 4293909696 4293249204 4292652947 4291803821 4292786085 4291601835 4292462017 4293118399 4293841346 4292988354 4292985533 4293511101 4292919995 4292788408 4292986044 4292722617 4292985787 4292985787 4292722873 4293248442 4292985788 4293316034 4293250496 4293186243 4293579973 4293841860 4294039239 4294304705 4290749846 4282581055 4284024906 4283831100 4284227659 4284816709 4284749382 4284749884 4284488260 4284816714 4285144900 4284487231 4284880191 4284225606 4284746551 4285472587 4284750403 4285797948 4284422978 4284158537 4285730371 4286065227 4290143113 4291592820 4291987848 4292051838 4292183681 4291264369 4291264643 4292382335 4292710773 4292317830 4291987582 4292317061 4292316287 4292316544 4292316544 4291987840 4292447873 4291988096 4292119158 4291659896 4292119680 4292053890 4292446577 4291461241 4292448130 4292382585 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289217107 4289677652 4289151573 4289545032 4289545302 4289740625 4289807954 4289349201 4289807959 4289150032 4289808456 4289348427 4290857552 4291383119 4292373076 4292833630 4292968833 4292641647 4293560428 4293169527 4293563249 4293563518 4293564024 4293565558 4293564797 4293564017 4293562994 4293429357 4293099886 4292439388 4291256930 4290660172 4289082700 4287769670 4287769671 4288886860 4288100941 4289348430 4289215306 4289283159 4289414737 4289414993 4289545045 4290266449 4289611346 4290397000 4290136403 4289611090 4289677138 4289872720 4290201157 4289545554 4290135378 4290398542 4290071631 4290857037 4290202453 4290596180 4289415255 4289018188 4291058528 4294435761 4294035856 4292444262 4293425771 4291517270 4291323490 4289477713 4290530904 4289940055 4289940836 4289675089 4289873236 4289742163 4289347406 4290666348 4289345613 4290337375 4291119443 4289150032 4290599516 4291126112 4290992732 4291126111 4290859869 4290593623 4290402929 4291585384 4291122519 4290140773 4289811818 4291985022 4292116582 4292115828 4292707697 4292249465 4292181617 4291723636 4291720298 4292317068 4292186759 4290204767 4291396487 4292448898 4292647840 4292645247 4291986306 4292449938 4292193705 4292651664 4292059564 4292120208 4292712083 4292123285 4292055713 4292709264 4292653728 4292979359 4292523424 4292654252 4292313741 4291723392 4292320918 4292262561 4292583311 4292583822 4292586153 4292056473 4292587929 4292588705 4292583835 4292651665 4292061601 4292450203 4292587164 4292654514 4292188053 4292583822 4292592316 4292525747 4292590506 4292586130 4292524456 4292649377 4291596944 4292128928 4292786362 4292263337 4292194721 4292786081 4292127121 4292129455 4292656302 4292654000 4292197048 4292656308 4292198844 4292589482 4292590768 4292588972 4292195752 4292656822 4292656308 4292329914 4292327094 4291802274 4292394171 4292000173 4292720306 4292527294 4292530633 4292443517 4292966744 4293033307 4292771696 4292442713 4292579726 4291803317 4293644743 4293513149 4292916380 4292653974 4292196782 4292125086 4292131258 4292988866 4293448386 4293379516 4292986045 4293117365 4292788408 4292133052 4292853936 4292788410 4292788409 4293117365 4292854459 4293117374 4292919986 4292986302 4293379772 4293250498 4293643969 4293971904 4293448901 4293777606 4294041033 4294631888 4289754228 4282515526 4283833423 4284230221 4284883533 4284489546 4284947784 4284488259 4285079108 4285274173 4284289854 4284485190 4284221758 4284420932 4284684862 4284881475 4285734214 4285473611 4284554055 4285669958 4286719052 4288630380 4291132286 4292116616 4292119172 4292509574 4291589754 4291657341 4291987336 4292316285 4292253067 4292316804 4292317061 4292775806 4291922303 4292316544 4292316544 4292382080 4291987830 4292316544 4292383111 4291922044 4291921544 4292119680 4292053891 4292118385 4292119682 4291723638 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289612116 4289807697 4289742417 4290070352 4289740620 4289808210 4289349201 4289545045 4289742423 4289808204 4289281870 4289807440 4290987597 4291253071 4292174684 4292900195 4292771163 4293233271 4293235571 4293628024 4293563512 4293566590 4293565303 4293564284 4293565313 4293565314 4293566084 4293626224 4292838255 4292964192 4291452751 4289479504 4288755784 4287837004 4287837004 4288361291 4288168017 4289282637 4289151566 4289478731 4289612380 4289806161 4289347403 4289481045 4289545045 4289872726 4289611346 4289938511 4289871184 4289872975 4289611096 4290071381 4289874254 4290007128 4291053648 4290859099 4289677390 4290399054 4289938261 4288886090 4292248949 4294302636 4293965176 4293497718 4292375902 4292109148 4291126370 4290397781 4290595414 4290070357 4290005335 4290400859 4291056987 4289219675 4290201684 4289545049 4290399576 4291450202 4289284183 4290928480 4291124317 4291452518 4291124574 4290532186 4291122775 4290930033 4291126888 4291059807 4291255900 4289940831 4291920001 4292446079 4292050555 4292512391 4292442745 4292246125 4291457661 4292378218 4292056988 4291654241 4290205286 4291593619 4292446093 4292446855 4292643186 4292186261 4292647061 4292712596 4292517525 4292190620 4292711562 4292123291 4292317830 4292252295 4292715930 4292128685 4291919991 4292457884 4292713367 4292319108 4291590536 4292318357 4292654744 4292583320 4292648868 4292190873 4292581259 4292587165 4292582041 4292584081 4292193189 4292581782 4292588968 4292585890 4292646537 4292192918 4292588975 4292586913 4292196263 4292648844 4292319891 4291725188 4292649111 4292192151 4292129443 4292721068 4292324238 4292126876 4292780958 4291735472 4292392120 4292260774 4292263097 4292195766 4292853423 4292722874 4292656821 4292194999 4292260005 4292655279 4292261296 4291932593 4292328889 4291999931 4292393143 4291931551 4292393387 4291866287 4291868588 4292328375 4292854201 4292390573 4292440676 4292966499 4292575361 4292589493 4292724410 4294038721 4292524449 4292457633 4292657326 4292652454 4292457128 4292789180 4293514171 4293315264 4293379517 4292986301 4292788408 4292788410 4292788408 4292985787 4292985789 4292985779 4292788408 4292854459 4293511358 4292919994 4292985788 4292985787 4292854459 4293313980 4293314750 4293120963 4294235333 4294103748 4294104773 4294240211 4286859362 4283703109 4283503946 4284424010 4284357702 4284752717 4284883015 4284685637 4285078083 4284684606 4284421183 4284417848 4284814398 4284883018 4285011011 4285406794 4284815423 4284950093 4286260049 4286260813 4287901793 4290012023 4291724427 4292117888 4292116088 4291592317 4291657597 4291987591 4292382077 4292318602 4292250493 4292316287 4292382596 4291923588 4292383626 4292316287 4292316544 4291988095 4292382854 4292776065 4291988086 4292119425 4292119681 4291920751 4292119673 4291921794 4291921792 4292118396 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289414737 4289414743 4289676887 4290200402 4289283660 4289414738 4289414739 4290003784 4289676882 4289938257 4289872970 4289937236 4290266701 4291318603 4292045159 4292964702 4292771954 4293102191 4293627770 4293562488 4293565298 4293562226 4293564535 4293566076 4293564283 4293566076 4293563253 4293432187 4293231213 4292507232 4291645008 4290071376 4288558155 4287770700 4288557129 4288297039 4288757578 4289480273 4288953936 4289281360 4289610825 4289349458 4289546582 4289939531 4289675085 4289677132 4289740627 4289479760 4289937485 4289479503 4289546837 4289413198 4290596437 4290070096 4290334037 4289677389 4290990165 4290462291 4288954956 4288426569 4293830791 4294170795 4293769848 4293627764 4292838249 4291981673 4291649367 4290729558 4289609299 4290071641 4289020494 4290464856 4290202456 4291251540 4290069862 4290929505 4289542992 4290074205 4291318873 4290594900 4291256670 4291124574 4290596182 4290534760 4291256435 4291126626 4291846501 4291188826 4289348958 4291392377 4292313200 4292575096 4291788426 4292382580 4292178795 4291651178 4291852146 4291858066 4291721063 4290206314 4291788672 4292446056 4292841614 4292251004 4292182668 4292647318 4292716946 4291526271 4291855233 4292513165 4292580745 4292252297 4292127656 4292646812 4292188296 4292717717 4292126368 4292181875 4291790715 4292118156 4292260503 4292649874 4292581774 4292649873 4292062113 4292649370 4292587423 4292580247 4292584335 4292585119 4292647307 4292586918 4292581269 4292259995 4292192172 4292585127 4292982698 4292522670 4292656035 4292318350 4291729563 4292129962 4292588961 4292586924 4292655017 4292193441 4291140773 4292453780 4292262832 4292326832 4292262834 4292719017 4292264637 4292721579 4291869119 4292655783 4292198063 4292718497 4292061602 4292654243 4292589742 4292785588 4292128937 4292392368 4292064941 4291341491 4292521890 4292132288 4291932319 4291867321 4292328362 4292397766 4292970887 4292385700 4292855480 4293842121 4293182882 4291798419 4292784281 4292522397 4292981937 4293248949 4293380289 4293380030 4293313981 4293379773 4292986293 4292919995 4292788410 4292986027 4292788410 4292985787 4292788408 4293116856 4293051838 4293445565 4292854202 4292985787 4292986037 4292788402 4292919987 4293381056 4292922561 4293644224 4293842117 4293711814 4294172106 4294108871 4285671493 4282910799 4284292932 4284489286 4284947016 4285080907 4284880199 4284424010 4285080652 4284749885 4284291141 4284419647 4284748606 4285013060 4285009476 4284947008 4285277012 4285274439 4285867853 4287048789 4288962679 4291655803 4292182924 4291920494 4291526798 4291131003 4291920255 4291921543 4292317316 4292252036 4292711045 4292250750 4291923077 4292382596 4292381822 4291988096 4292382080 4292053632 4292053632 4291988087 4292184958 4291922046 4292053880 4292118141 4292054136 4291987328 4292119424 4292119416 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290003789 4289151828 4289742417 4290135377 4290071637 4289806162 4289413196 4289349203 4289742418 4289479754 4289872971 4289610314 4291316816 4291252815 4292504148 4292439646 4292903262 4293559403 4293169012 4293563000 4293564793 4293564785 4293500286 4293565817 4293566077 4293566076 4293564549 4293430639 4292967514 4292965988 4291584086 4290332745 4289084239 4287834950 4287246666 4288358981 4288757586 4289016394 4289412945 4289283664 4290001482 4289740882 4289742417 4289546581 4289938254 4289872982 4289675341 4289938506 4289675341 4289742681 4289740619 4289938518 4289348430 4289741397 4290398542 4290400338 4290334032 4289611596 4289214283 4289212748 4294298269 4294104232 4293764978 4293631090 4292508529 4292504410 4291322720 4290595665 4289875277 4289281877 4291122779 4289744475 4290530648 4289281874 4289743448 4291381579 4290072923 4291842911 4290994014 4290533737 4291647072 4291120981 4290469482 4292041314 4291257964 4291453536 4290662232 4290070355 4291064950 4292641927 4292048771 4292117631 4292577151 4292179821 4291657331 4292374121 4291723635 4291721070 4290208103 4292113539 4292642686 4292118405 4292508279 4292252026 4292714142 4292120453 4291920502 4292843656 4291989397 4292119174 4292643982 4292588201 4292585633 4292588711 4292646284 4292188550 4292778646 4291592064 4292123297 4292651166 4292973712 4292587156 4292058785 4292186770 4292649098 4292588705 4292584091 4292582029 4292060829 4292647822 4292187283 4292647562 4292654751 4291859352 4292655014 4292592829 4292588966 4292585616 4292059804 4292127654 4292719005 4292650908 4292586908 4292587924 4292655017 4291869113 4292787118 4292127412 4292261530 4292721328 4292327858 4291934896 4292129707 4292263870 4292260006 4292716183 4292128679 4292127661 4292783783 4291867310 4292785324 4291736996 4292257961 4292065449 4292258724 4292129708 4291142049 4292130738 4291997623 4292326058 4291736236 4292786085 4292591285 4293119160 4293906091 4292654745 4292261285 4292590250 4292916658 4292395183 4292854709 4293379777 4293379757 4293182901 4293248443 4292919995 4292788408 4292985789 4292788401 4292854196 4292656823 4292854201 4292591029 4292920251 4293051837 4293182906 4293182907 4292986045 4292458926 4292459701 4292985532 4293315519 4293315006 4293578945 4293776581 4294105030 4294172619 4293712840 4283238208 4283174214 4284486726 4284288573 4284552515 4284682813 4284618310 4285082191 4285275973 4284750141 4284027972 4284812606 4284619327 4285209405 4284355395 4284949579 4285605195 4286130253 4286788451 4288369023 4290800000 4291725187 4292641916 4292509832 4291199087 4292116361 4291791486 4292055172 4292316804 4292316789 4292251268 4292645509 4292710270 4292317061 4291989381 4292382079 4291988096 4292447872 4292053631 4292053632 4292447872 4291659640 4292447864 4292053889 4292511866 4291266176 4292513408 4292053633 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289742946 4289414736 4289610580 4289742423 4289151827 4289413201 4289413203 4289612117 4289742424 4290068301 4289807185 4290070867 4290136143 4291123538 4291584853 4292964958 4293230194 4293232500 4293628269 4293564281 4293564785 4293498750 4293764473 4293499255 4293564273 4293565304 4293562994 4293627244 4293165934 4292964448 4291187282 4290335571 4289082443 4287770954 4287966279 4288362061 4288755789 4289085521 4289348938 4289281361 4289806925 4289347667 4289610831 4289414744 4289151829 4289938511 4289938506 4289283923 4289610832 4289545038 4289742675 4289609554 4290002765 4290399055 4290268501 4290069586 4290200137 4289807189 4289674849 4290067527 4294369987 4294036878 4293964402 4293503114 4293032024 4292969574 4291517526 4291914084 4290070359 4291977048 4290070616 4290004052 4289940054 4289349464 4290924376 4290924889 4290661463 4291057491 4292171868 4291055947 4291388003 4291062899 4291123545 4291257192 4291651167 4290925167 4289150798 4290540412 4292246394 4292380290 4291787623 4292704118 4292113785 4292178800 4291918193 4292120187 4290797413 4290271589 4291786622 4292313968 4292049274 4292182396 4291987087 4292117635 4292124829 4291592048 4292706941 4292052869 4292317064 4292646546 4292190885 4292644232 4292650136 4292195225 4292255900 4292314501 4291919497 4292316286 4292649870 4292587931 4292521374 4292578197 4292585105 4292582799 4292582039 4292187783 4292586911 4292584085 4292649125 4292189582 4292319127 4292253068 4292646555 4292654494 4292587163 4292650396 4292061085 4292585892 4292587419 4292652700 4292652692 4292194964 4292719263 4292125596 4292125861 4292719267 4292653995 4292263867 4292324523 4292326818 4292262074 4292720556 4292195756 4292650390 4292720028 4292062888 4292778388 4291733146 4292390059 4292391841 4291539122 4292518802 4291868088 4291931537 4291998630 4291405726 4292056723 4291139734 4291275177 4291800480 4292261291 4293052604 4293182895 4293046160 4292126865 4292920753 4292524720 4292459702 4292986036 4292986047 4293775297 4293379765 4292854720 4292984238 4292722874 4292985780 4292788410 4292788400 4293182651 4292854194 4292656823 4292985780 4292985788 4293051837 4292919995 4292854203 4293511606 4292656058 4292523421 4292524213 4292986044 4293379517 4293249727 4293511870 4294104261 4294038469 4294433215 4291667349 4282187834 4283631689 4284355140 4284486460 4284554831 4284680502 4285079621 4284618043 4284486723 4284616516 4284419402 4285076805 4285208894 4285208896 4285408329 4285014091 4284683588 4285671014 4286856290 4290011269 4291591278 4292708996 4291921783 4291524219 4291723390 4291593090 4291921543 4292317059 4292711561 4292252036 4292318602 4292250493 4292317318 4291922302 4292381823 4292382080 4292053632 4292053375 4292382854 4292382079 4291594886 4292119424 4292053632 4292119424 4292053888 4292119425 4292053623 4292119416 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289612120 4289676366 4289019729 4289480278 4289480279 4289610580 4289676361 4289217354 4289412941 4289545291 4289479754 4290068301 4290200662 4290598737 4291255639 4292770159 4292705886 4293362026 4293170299 4293565816 4293565305 4293565302 4293500802 4293565821 4293565047 4293566333 4293563512 4293628026 4292968557 4292571229 4291647569 4290333782 4288558411 4287769671 4287901255 4288294729 4288690511 4289281098 4289151566 4289283403 4289740878 4289938511 4289675342 4289938505 4289545295 4289740883 4289479759 4290004054 4289347660 4289806420 4289479753 4290201422 4289675850 4290333519 4291316308 4289809237 4290265674 4289874515 4289279562 4289936713 4294566830 4293903243 4293568639 4293962607 4292641640 4292899680 4292112230 4292110162 4291914084 4291254098 4291122773 4290796127 4290070095 4289808729 4291120213 4290070871 4290794586 4291122269 4288951885 4290729822 4291124317 4291122264 4291061351 4291715165 4290667368 4289743706 4290535797 4292312186 4292639606 4291921538 4292838525 4291128429 4290733674 4292312696 4292516504 4290991961 4290670205 4292311933 4292512373 4291460994 4291854962 4292444796 4292318098 4290933363 4291389790 4292776845 4291330176 4292777350 4292256414 4292583845 4292647817 4292060577 4292119437 4292576885 4292316286 4292117894 4292651170 4292980638 4292512898 4292582029 4292517266 4292580748 4292515480 4292975509 4292523415 4292582813 4292578173 4292519325 4292584089 4292647564 4292127913 4292252809 4292254884 4292645006 4292586404 4292059548 4292254881 4292588204 4292653992 4292194980 4292060319 4292781720 4291472554 4292386452 4292129182 4292260012 4292260261 4292721333 4291934390 4291801507 4292783776 4292195772 4292652438 4292718755 4291468709 4292845978 4292126371 4292516501 4291603617 4292194479 4292260781 4291867563 4291993750 4292059556 4291864481 4292056979 4291005847 4291074719 4291997347 4293380279 4293119664 4292519570 4292584086 4291730582 4292788654 4292852661 4292591279 4292919997 4293315777 4294102976 4293313981 4292920510 4293047716 4292197564 4292854201 4292788402 4292986037 4292854203 4292393652 4292656824 4292656822 4293116857 4292657079 4293445566 4292854194 4293511359 4292985537 4291996561 4292649370 4292523942 4292854708 4293182907 4293248445 4293840831 4294102976 4293775812 4294566611 4287585880 4282910531 4284091453 4284748343 4284619081 4284746555 4284686408 4285010495 4285080395 4284752974 4284092989 4284225604 4284681278 4284683327 4285932617 4284750920 4284552512 4284221511 4285802059 4289352823 4291131775 4291855232 4292445322 4291592061 4292180599 4291525504 4291988091 4292053631 4292710271 4292252794 4292316805 4291987581 4292318085 4291922046 4292776581 4292317061 4291988095 4292382079 4292055174 4292053375 4292316544 4292447606 4292053633 4292120198 4292053631 4292447617 4291989629 4292447361 4292053633 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289283156 4289281102 4289480529 4289282900 4289480273 4289480536 4289217615 4289741904 4289152080 4290003792 4289610832 4289347661 4289675855 4291120462 4291848533 4292963935 4292771424 4292970353 4293628276 4293562745 4293564786 4293563511 4293566077 4293564272 4293566077 4293564284 4293564529 4293430908 4293032283 4292572768 4291388258 4290399815 4288494159 4288359494 4287770954 4288819785 4289213771 4289019985 4289151054 4289283403 4289740877 4289872982 4289872969 4289872976 4289740883 4289938511 4289938518 4289479503 4289545296 4289742669 4289871185 4289937228 4290531157 4290069586 4289611090 4289939278 4290070605 4289677138 4289082964 4290596435 4294436030 4293837708 4293833076 4293172082 4292504932 4292904032 4292636009 4292441709 4290661964 4291654763 4290925901 4291318614 4289806928 4291055960 4290069074 4290927710 4290267477 4289678696 4289414495 4291321437 4290403172 4291190623 4290990679 4290796135 4289414747 4291126636 4292838783 4292175714 4291920512 4292772987 4290929516 4292310909 4291262070 4292515193 4290400085 4289616752 4292046186 4292184182 4292378249 4292181356 4292446341 4291857282 4292379766 4290734447 4292245114 4291652710 4292316552 4292120209 4292318079 4292654241 4292582313 4292711817 4292383362 4291390068 4292118408 4292654499 4292583823 4292518546 4292583570 4292119937 4292972664 4292519831 4292583323 4292516749 4292977556 4292523414 4292518313 4292973698 4292389267 4292649373 4292255897 4292646809 4292252551 4292255890 4292582549 4292581780 4292588438 4292587411 4292062881 4292651163 4292713607 4292062889 4292719268 4292651691 4292649112 4292258190 4292128688 4292197299 4292720813 4292391602 4292127909 4292716172 4292126630 4292128420 4292261041 4291798425 4291663767 4291669418 4292253582 4292128679 4292193955 4292193958 4292056468 4291012780 4291460979 4290940581 4291273635 4293051835 4293577141 4292655257 4292187542 4291667091 4292657076 4292788147 4292591288 4292920252 4293051840 4293774005 4293314240 4292986038 4292985780 4292459445 4292132797 4292722358 4292854201 4292854202 4292656823 4292854193 4293182651 4292788401 4292788409 4292920251 4293051838 4293117114 4293248444 4292986563 4292127118 4292383380 4291925132 4292651152 4292457903 4293117890 4293182910 4293642429 4293776581 4293776568 4293450692 4285209149 4283697980 4284286782 4284092222 4284419396 4284550980 4284882762 4285012547 4284886100 4284820049 4283764272 4285208135 4284749367 4285604429 4285276999 4285079626 4284352840 4284026435 4286527074 4289948550 4292118387 4292251007 4292509317 4291066239 4291854975 4292316039 4291857037 4292384379 4292250238 4292317578 4292316803 4292251524 4292711044 4292252036 4292252036 4292317828 4291987839 4292382080 4292381823 4291988861 4292579456 4291923847 4292447606 4292053633 4292053633 4292053622 4292381825 4291990397 4292381816 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289281359 4289480536 4289677652 4289478482 4289478732 4289412946 4289937490 4289152086 4289806156 4289546838 4289412947 4289347405 4289939278 4291123288 4291648848 4292573537 4292901474 4293495155 4293562734 4293564275 4293565304 4293566078 4293565045 4293564285 4293566075 4293566850 4293562743 4293626738 4292837471 4292964961 4291583315 4290203483 4289083981 4288360521 4287835977 4288298322 4288823373 4289019473 4289348937 4289281360 4289543504 4289677138 4289938260 4289676887 4289545039 4289545290 4289479504 4290071120 4289740621 4289742670 4289872970 4290068306 4289545560 4290135371 4289939535 4290465371 4290070610 4289938510 4288689491 4291123545 4294370225 4294099583 4293568637 4293760623 4293172868 4292378500 4291983200 4292704864 4291848035 4292304468 4291913307 4290069333 4290858835 4289874275 4290135888 4290069845 4289940311 4291516505 4290792020 4290601826 4292306526 4290333527 4289086036 4289216336 4291721328 4291855481 4292635506 4291526010 4292969839 4291650676 4291788655 4292244345 4292055415 4289941610 4290535017 4292113775 4292051841 4292377696 4292050559 4292579210 4292249216 4291463059 4291783270 4291716471 4292116348 4292117389 4291394174 4292973957 4291724164 4292182913 4292127900 4292182131 4291985797 4291989389 4292583060 4292974736 4292520096 4292584856 4292514204 4292974723 4291989912 4292646272 4292585107 4292583847 4292516502 4292582031 4292587414 4292583319 4292251025 4292116609 4292318088 4292653465 4292251528 4292251011 4292579976 4292650645 4292584345 4292715417 4292119689 4292320921 4292127916 4292125841 4292652189 4292195507 4292194978 4292650383 4292652697 4292654512 4292326057 4291800988 4292125852 4292715672 4292125614 4292784280 4292125859 4292326826 4292783277 4292188559 4292322723 4292384654 4291670179 4292519579 4291661195 4291332751 4291137935 4292526780 4293841325 4293114263 4291339671 4292650925 4292198055 4292981935 4292459702 4292722874 4293642429 4293445558 4293051066 4293248439 4292920237 4292854195 4292656825 4292722609 4292919721 4293182650 4292788409 4292986036 4292656823 4292656822 4292591029 4292986045 4293313979 4292919994 4292854458 4293445567 4293052090 4292326295 4292318101 4292119933 4291857553 4292647052 4292788142 4292918190 4292457365 4292589747 4294364865 4293775791 4292060572 4283170871 4283698758 4283569737 4284288579 4284815933 4284947522 4284683837 4284879927 4284749371 4284422215 4284617031 4284880951 4285075268 4284421443 4284947784 4284357960 4284227143 4285208907 4289418096 4291131518 4292184710 4292116620 4291461243 4292116616 4291593089 4292119422 4292382595 4292316548 4292318601 4292251778 4292252041 4292711044 4291856510 4292711045 4292317571 4292317061 4292382079 4291987839 4292382080 4292381824 4291988087 4292447615 4291988097 4292053622 4292448380 4291988871 4292382336 4291987841 4292316544 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289873740 4289217359 4289282895 4289480529 4289085267 4289350226 4289019725 4289480525 4289806414 4289610832 4289217610 4289742406 4289874524 4291120203 4291848036 4292571997 4293492585 4293233785 4293628020 4293564786 4293566078 4293565045 4293566852 4293566076 4293563004 4293566074 4293564805 4293626480 4293231471 4292505434 4291649115 4289676880 4289213771 4287770441 4287836490 4288360523 4288626001 4289217100 4289741910 4289020498 4289806412 4289740619 4289546586 4289807959 4289742417 4289479760 4290068557 4289872721 4289545289 4289545041 4289938506 4289677139 4289676620 4290070868 4289871944 4290070099 4290397001 4289545302 4288755026 4290793812 4294436285 4293702788 4293831029 4293697138 4293691762 4293431909 4292704097 4292704365 4292835407 4292571231 4291059038 4291057758 4291122509 4291121745 4288948037 4289613143 4290597980 4289806931 4290666598 4291583323 4291123292 4289938515 4289545809 4290995834 4292181375 4292312684 4291587706 4292439905 4290931584 4291783783 4292906632 4291132279 4290070354 4290076012 4291459700 4292248175 4292575354 4292378505 4291330678 4292184946 4291261054 4292708222 4292113269 4291725445 4292317326 4292252545 4292245880 4291062376 4292977053 4291396998 4292176750 4291331476 4292712333 4292584871 4292910482 4292514717 4292579458 4292580231 4292582298 4292122252 4292646301 4292185732 4292643212 4292582537 4292520609 4292580494 4292578427 4292185235 4292122268 4292318339 4291726225 4292711806 4292647581 4292125597 4292778130 4291793530 4292381309 4291532711 4292390804 4292320143 4292319883 4292127650 4292584088 4292653989 4292653989 4292063151 4292191139 4292128147 4292193695 4292321689 4292718237 4292124069 4292253071 4292127408 4292718752 4292126635 4292129182 4292055437 4292452760 4292119175 4292059803 4291596181 4290940308 4292521886 4293579199 4293313701 4291927954 4292062633 4292721579 4292523683 4292459703 4292788923 4293117368 4293248437 4293182892 4292788660 4292722099 4292129946 4292721329 4292525239 4292722608 4292722609 4292459445 4292854201 4292854201 4292854202 4292393651 4293183167 4292986044 4292525237 4293051838 4292986301 4293051838 4292984502 4293052596 4292253333 4292120190 4291528845 4292118907 4292324002 4292259491 4292049786 4292189081 4292786855 4293642674 4294435273 4287120451 4283238471 4284091461 4284951377 4284818253 4284685639 4284683836 4284883531 4284685895 4284619854 4283831863 4284549177 4284683328 4284944952 4284614468 4284159300 4285935458 4286460760 4287576163 4289947511 4292052609 4292708738 4291657582 4292180604 4291592058 4291987335 4292053630 4292317828 4292252036 4292316803 4292645252 4292316030 4292252293 4292710271 4292250494 4291990154 4292053374 4292382079 4292055173 4292053374 4292055947 4292053375 4292054405 4292447616 4292054405 4292054150 4292382081 4291790193 4292382328 4292316544 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289217366 4289480524 4289544268 4289480537 4289151052 4289348688 4289546061 4289282897 4289283146 4289478733 4289413203 4289938517 4289675091 4291122777 4291782742 4292573296 4292839539 4293494636 4293170033 4293238134 4293236856 4293170563 4293564528 4293565303 4293563260 4293565827 4293562219 4293430903 4292967513 4292965747 4291387478 4290071124 4287969101 4287837773 4288555846 4288230732 4289215053 4289414481 4289085516 4289544273 4289612379 4289807703 4289349200 4289151823 4290004053 4289740882 4289545297 4289545289 4289545047 4289545295 4289675341 4289872727 4289611341 4290265679 4290531164 4289741390 4289413969 4289873999 4288820564 4290337365 4294501052 4294162282 4293571972 4293628772 4292513649 4293231714 4292117117 4292899146 4292704370 4292372827 4292637022 4292109404 4291121750 4289807187 4289349977 4290002254 4289017421 4290925138 4291254877 4290596953 4290795868 4289741411 4291129973 4291914358 4292901734 4291982206 4292375401 4291128684 4291979366 4291920516 4291136377 4290728276 4289484395 4291588210 4292310634 4292379020 4292116074 4292643975 4291786605 4291327606 4291656318 4292180071 4292251531 4292382858 4291521652 4291786625 4291134338 4292049545 4292052350 4292708227 4291328127 4292775786 4292975000 4292515991 4292911779 4292515981 4292120963 4292579219 4292381835 4292582298 4292580251 4292649362 4292253839 4292052617 4293039228 4292125076 4292581024 4292579196 4292646538 4292579994 4292778125 4291663262 4292841853 4292186516 4291854961 4291528356 4292055687 4292188572 4292124570 4292255632 4292647076 4292650125 4292647073 4292058772 4292654000 4292719010 4291537054 4292254624 4291535008 4292849566 4292124303 4292190626 4291401125 4292384124 4292258479 4292130206 4292451232 4291994525 4291920247 4291464333 4291002503 4291995033 4292920498 4293314207 4292518544 4292126874 4292851874 4292588701 4292525495 4292591289 4293511607 4293247675 4293051312 4292984494 4292985788 4292524718 4292523435 4292655799 4292523436 4292590254 4292525238 4292459445 4292919994 4292656822 4292854201 4292656822 4292854201 4292788408 4292984243 4293051839 4292854202 4293379773 4292987064 4293579454 4292191386 4292053118 4291920772 4291924110 4292390561 4292720276 4290403422 4290870643 4292715674 4292851111 4293247901 4293119418 4283629614 4283898952 4283828537 4284489286 4284556875 4284882498 4284815679 4285471554 4284682808 4284617022 4284355391 4285666878 4285013317 4284287805 4284358472 4285081431 4286525514 4286987372 4289355642 4291592576 4292181880 4291396239 4292180343 4291657852 4291855248 4292185738 4292054915 4292317571 4292776324 4291922819 4292776580 4291922303 4292316286 4292645509 4292317061 4292382596 4292053375 4292054139 4292119941 4292053631 4292447615 4292382079 4292054407 4291858547 4292448134 4291859833 4292381815 4292053890 4292447617 4292053632 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289676362 4289282895 4288888144 4289348681 4289151054 4288953680 4288888144 4289414480 4289151060 4289085517 4289676362 4289740882 4289479760 4291122519 4292109669 4292508769 4293491543 4293233777 4293628794 4293564278 4293629571 4293630331 4293565303 4293172340 4293563254 4293564035 4293563251 4293430895 4293361771 4292506974 4291714645 4289479249 4289282641 4287769158 4287181901 4288360265 4288624718 4289282637 4289019472 4289283157 4289478218 4289350996 4290003797 4290004041 4289086544 4290004048 4289545289 4289938264 4289742667 4289543249 4289938507 4289807943 4290201933 4289741648 4289545554 4290069584 4290004042 4289151565 4288229707 4291324500 4294236339 4293505671 4294027360 4293497980 4293300853 4293297514 4293762396 4292310130 4292767065 4292180592 4292767835 4291189852 4290922837 4289677142 4289610573 4288953166 4290334291 4290203739 4290792792 4290333781 4289739850 4291065456 4292313218 4292377451 4291126651 4292440932 4291323752 4291915628 4291589760 4291919730 4289873752 4290076019 4291390842 4292374888 4292243305 4292116846 4292643977 4291853668 4292312702 4290668399 4292246649 4292710280 4291851117 4291396999 4291524481 4292253326 4292249478 4292576135 4291126376 4292247923 4292780187 4292050843 4292446599 4292646279 4292578937 4292708743 4292977057 4292515475 4292578942 4292580745 4292581775 4292580489 4292188569 4292710008 4291856536 4292641657 4292520847 4292581790 4292184958 4292712071 4292124051 4292514180 4291131522 4291988619 4291926951 4292122001 4292190616 4292318105 4292317592 4292651167 4292584590 4292187807 4292124055 4292122012 4292059537 4292588207 4292717723 4292125853 4292841623 4291794836 4291797422 4292452245 4292252565 4292320675 4292449176 4292192179 4291994007 4291399312 4290477982 4291990169 4292458157 4293578930 4292717717 4291993747 4292063644 4292652707 4292456619 4292591546 4292921539 4293248437 4293182902 4293051316 4292986287 4292524977 4291996826 4292196788 4292657080 4292195753 4292588973 4292525494 4293050293 4292854458 4292788409 4292854201 4292854201 4292854201 4292788408 4292985787 4292722872 4293445565 4292986045 4293314238 4293445558 4292920761 4291460983 4291792001 4291857808 4292390552 4292654484 4290469983 4290406511 4292383890 4292583331 4292588711 4293844925 4289820552 4282974261 4283763517 4283828550 4284287030 4284357701 4285476686 4284886101 4284683836 4284617279 4284221496 4284489030 4285537092 4285013060 4285010761 4284159302 4285604939 4286723692 4288564850 4290934915 4291657597 4292643717 4292706166 4291592318 4291133056 4291528569 4292842372 4291989124 4292383880 4291989123 4292055689 4291989123 4292382079 4292317318 4292316287 4292053375 4292054139 4292382596 4292121482 4292053374 4292447871 4291594112 4292447872 4292053622 4292119169 4292054405 4292054150 4292382079 4292119168 4291661180 4292119168 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289281103 4289744991 4289348431 4289151060 4289348682 4289546061 4289741904 4289151053 4289151565 4289544270 4289415245 4289347410 4290070358 4291123294 4291912282 4292900449 4292838257 4293364591 4293038447 4293627519 4293172594 4293171322 4293564796 4293564541 4293564797 4293566588 4293562744 4293430901 4293295977 4293294176 4291516753 4290333271 4288493133 4288359494 4288491593 4288163401 4289282641 4289021261 4289019215 4289546065 4289217621 4289610580 4289545294 4289545296 4289676368 4289150544 4289609040 4289742662 4289347412 4289349452 4289676877 4289872720 4289611354 4290003786 4290201933 4289675086 4289610827 4288954449 4288751180 4291655534 4294567346 4293962330 4293566336 4293763442 4293233522 4293037162 4292374894 4293691744 4292242783 4292503121 4292443504 4292502875 4290070350 4290333528 4289283669 4290530905 4290924120 4290269788 4290725202 4288888396 4291323783 4292509549 4291655792 4291915360 4291982192 4291123548 4292111996 4291984758 4291193700 4289418606 4290732130 4291124340 4292444525 4292117889 4291456124 4292312177 4291721838 4291457420 4291195247 4292706413 4291132545 4291193700 4290537337 4291921524 4292644743 4292773776 4292251786 4291128425 4292181637 4291526270 4292907130 4292648345 4292119945 4291592063 4292117631 4292382347 4292381321 4292586657 4292583059 4292250509 4292447367 4292446340 4292578681 4292581261 4292187012 4292383132 4292773249 4292583311 4292781203 4292309096 4291264886 4292119695 4291930016 4291858318 4292382608 4292318600 4292250492 4292713627 4292058275 4292646528 4292583581 4292645767 4292184699 4292715420 4292645019 4292647303 4292190362 4292188833 4291796890 4292186000 4292845459 4291797417 4291924362 4292187796 4291137677 4292120456 4291792534 4290939791 4292326306 4292855215 4293311110 4292448135 4292124300 4292981153 4292522404 4292592053 4293051573 4293445816 4293642174 4293051816 4292854187 4292655792 4292588973 4292196530 4292656305 4292590511 4292590255 4292589735 4292524719 4292722616 4292656823 4292591030 4293182649 4292985788 4292788408 4292788408 4292985787 4292919994 4292919995 4292985788 4293381056 4293314740 4293053125 4292318857 4291135117 4292120970 4292781461 4292522641 4290798696 4290344579 4291202442 4292844441 4292518807 4293048234 4294567383 4286658885 4283236424 4283895612 4284418884 4284682565 4284358217 4285143104 4284357960 4284422210 4284287045 4284225862 4284947261 4285601858 4284684604 4284289352 4285079112 4286526307 4287312230 4290142836 4291330688 4292908673 4292050298 4291525246 4291657597 4291856004 4292317069 4291987838 4292053373 4292317833 4292382595 4292316803 4292384394 4291987839 4292053631 4292053631 4292119941 4292054405 4292448389 4291595139 4292448389 4292054406 4292119424 4292053632 4292119167 4292119424 4292053631 4292447615 4291989638 4292119167 4292119942 4292382845 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289283146 4289282632 4289348682 4289151053 4289217102 4289085517 4289348688 4289151053 4289217102 4289020494 4290067789 4289282130 4290004560 4290991950 4291850079 4293161826 4293361513 4293299062 4293235062 4293565297 4293564798 4293631095 4293563779 4293564784 4293564535 4293564541 4293566072 4293430382 4292968557 4292964446 4291651421 4289217625 4289414477 4288294473 4287772236 4288886092 4288624461 4289085264 4289217106 4289282901 4289610836 4289806418 4289806418 4289740883 4289349452 4290002256 4289545558 4289938250 4289545295 4289938262 4290267481 4289611346 4289742413 4289872714 4289676884 4289414990 4289217867 4289411662 4288686661 4293042044 4294297999 4293502595 4294030185 4293432445 4293502576 4292571251 4293432171 4292246393 4292441192 4291715680 4292377447 4291255130 4291778648 4291123549 4290335067 4289543761 4290663002 4290068047 4290071634 4292113802 4291856498 4292111994 4292311147 4292111739 4291323238 4291061101 4291918694 4291390319 4289284186 4290734454 4291323763 4291920241 4291721585 4292244584 4292449153 4291716200 4291850605 4291851629 4292248172 4290670459 4290930542 4291393654 4292315010 4291526270 4292313983 4291918439 4291715427 4292117637 4292513675 4292711831 4292181640 4292643958 4292512903 4292118916 4291920791 4292773484 4292253589 4292448902 4292711295 4292117642 4292316059 4291726473 4292646801 4292513683 4292974219 4292582032 4292252553 4292314737 4290998399 4290606717 4292123021 4292322473 4292643962 4292712074 4292581525 4292647834 4292251797 4292249973 4292713369 4292385697 4292583835 4292581009 4292646559 4292119690 4292124058 4292055690 4292774794 4292317587 4292190888 4292057752 4291988347 4292515987 4291990676 4291462273 4291858577 4290739841 4292579728 4293245860 4292984226 4292518523 4292124307 4292520339 4292522655 4292787365 4293117368 4293511604 4293641902 4293050796 4292789167 4292523945 4292197309 4292589991 4292196010 4292591288 4292524719 4292524719 4292525495 4292722865 4292722616 4292656823 4292788409 4293379772 4292722872 4292788408 4292788408 4292985787 4292722615 4293051838 4293182649 4292987071 4293315263 4293315267 4293312176 4291460225 4291855993 4292059027 4292521878 4291195245 4291133330 4292450712 4292582800 4292119446 4292453023 4293185977 4292857783 4283367477 4283306569 4284093510 4284290628 4284815676 4284553796 4284751431 4284551488 4285149530 4283764020 4284812093 4284422980 4285012546 4284554060 4284290373 4285344094 4286194782 4289092204 4290935694 4292250244 4292380019 4291592319 4291721854 4292116089 4291921800 4292053629 4292382078 4292317833 4292316803 4291988613 4292381822 4291987839 4292447872 4292053632 4292447872 4292053631 4292053631 4292053365 4292448391 4291987830 4292119159 4292119416 4292119158 4292122252 4292119158 4292120199 4292053622 4292447617 4292119415 4292119169 4292053624 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289545816 4289283931 4289348436 4289151058 4288888143 4289544781 4289085523 4289611853 4289085518 4289479246 4289347660 4289611346 4290727513 4292042072 4292699224 4292768604 4292968302 4293299311 4293429882 4293565298 4293563006 4293171565 4293565308 4293564541 4293565559 4293563005 4293564536 4293562484 4293361257 4292509025 4291583324 4290465362 4288492107 4287836233 4287312716 4288361547 4288692049 4289281098 4289216589 4289480524 4290069590 4289349451 4289152086 4289806412 4289545296 4289938762 4289545296 4289545296 4289543505 4289152073 4289545033 4290068302 4289479755 4289675342 4289938512 4289611082 4289673294 4289018702 4288031043 4293305753 4293640834 4293966969 4293369735 4293900400 4293299571 4293630320 4292374875 4293759344 4292376426 4292639055 4292373614 4292638566 4291384398 4291781983 4290727762 4290465626 4289543504 4289085521 4291128177 4291125094 4292308587 4292179067 4291192427 4291982700 4291127417 4292183925 4290596696 4289550968 4290730849 4291518043 4291918969 4292115837 4292114812 4291984252 4292246892 4291786352 4291915115 4292117884 4290994537 4290731895 4291849595 4291789166 4292249478 4292315267 4291655038 4291192688 4291527301 4292511618 4292579707 4292579452 4292448396 4291984506 4291984757 4292971657 4292714132 4291853458 4292116340 4292183955 4291982984 4291131531 4291005850 4292711562 4292514966 4292976014 4292974213 4292512394 4291920497 4290674583 4292319382 4292384412 4292643962 4292646785 4292647577 4292053384 4292644991 4292188566 4292646536 4292251801 4292184459 4292648335 4292446083 4292253599 4292251269 4292124064 4291789710 4292842109 4291400086 4292118927 4292449429 4292122267 4292120466 4291596173 4291924898 4291133054 4291332747 4292850853 4292592043 4292719259 4292517006 4292518033 4292519835 4292984257 4292722853 4293378992 4292984234 4292392354 4292655776 4292587414 4292194451 4292652443 4292197030 4292588710 4292588974 4292722866 4292722866 4292721841 4292525237 4292459445 4292854203 4292788400 4292985788 4292722616 4292985787 4292985787 4292788409 4292985788 4292919994 4292986045 4293381055 4292986558 4293315263 4293447108 4291594371 4291462009 4291794841 4292454556 4290996850 4291530381 4292387477 4292578692 4291130494 4291591291 4293374891 4294373322 4289558390 4282648389 4284024386 4284027974 4284555078 4284357961 4284947007 4284749372 4284423750 4283633980 4284820306 4285209411 4285013835 4285080139 4284290374 4284426059 4285737808 4286396515 4290080890 4292117886 4291920782 4292117887 4291720827 4291068032 4292118662 4292119422 4292055173 4291988612 4292318600 4292251268 4292381822 4292055174 4292119424 4292052346 4292119424 4292053887 4292053631 4292448389 4291661189 4292053631 4292382080 4292054406 4292119424 4291725185 4292120700 4291725177 4292119158 4292119169 4292119424 4291725440 4292053632 4292382081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289085516 4289544017 4289480535 4289676116 4289676373 4289478732 4289348943 4289085268 4289480781 4289806156 4289872982 4289871434 4290923351 4290795862 4292372583 4292901213 4292837989 4293299056 4293431923 4293563250 4293565559 4293564285 4293566076 4293566077 4293564529 4293565817 4293563762 4293562491 4293361512 4292900973 4291914070 4290335588 4289478727 4287834951 4287901258 4288360265 4288755790 4289150801 4288628044 4289609811 4289215823 4289873746 4289608783 4289611082 4289347667 4290002256 4289545290 4289938256 4290069577 4289610583 4289349459 4289479754 4290068558 4289872976 4289938513 4288954958 4289739851 4289018959 4288618304 4293968012 4293972391 4293834876 4293968769 4293367167 4293768837 4293167219 4293041271 4292968806 4292970851 4292436818 4293099879 4292308831 4291980650 4291251020 4290266961 4290066769 4289150029 4291392878 4292441196 4291916656 4290795864 4291457394 4291323513 4290797672 4291657333 4291125351 4289550705 4290797666 4291321710 4291922295 4291783788 4292245100 4292181100 4292643459 4291585144 4291986033 4291325820 4289876850 4289946214 4292176486 4291724931 4292511374 4291916647 4292250759 4290861916 4292510599 4292514189 4292579707 4292379295 4292446079 4292644741 4292446103 4292248223 4291919500 4292580500 4291466171 4291141041 4290284451 4290086307 4288905623 4289292692 4288831104 4290014063 4288762472 4290403928 4291922833 4291989645 4292841614 4292646021 4292580235 4292646023 4292252807 4292446858 4292712578 4292184954 4292250254 4292645763 4292582562 4292644989 4292446855 4292123550 4292119690 4292320148 4292711064 4292384140 4291987347 4291990926 4291992726 4291393666 4291924123 4291724168 4291003270 4291133559 4292191651 4292656809 4293115041 4292579975 4292517518 4292524708 4292847781 4292984483 4293117616 4293707439 4292656557 4292129181 4292719522 4292193688 4291932841 4292325032 4292063399 4292655534 4292590512 4292524975 4292524719 4292524463 4292657073 4292854203 4292854194 4292920244 4293051840 4293313464 4292854459 4293248443 4292919995 4292985780 4292919987 4293051838 4292985532 4293316802 4293381825 4293449416 4292258457 4291066751 4291862418 4292319362 4290869875 4292386453 4292186241 4290798442 4289483358 4290865524 4292321677 4292990394 4294566868 4285405493 4282975813 4283962175 4284027719 4284291648 4284818510 4284816712 4284881480 4285213268 4284226112 4285210703 4285675358 4285340998 4284945728 4285080137 4284812879 4286391907 4288565863 4291655037 4292315011 4292249464 4291985034 4291199089 4292246907 4292054144 4292053631 4292316287 4292316286 4292251525 4292776063 4291988096 4292119167 4292053632 4292382336 4292053887 4292249736 4291988095 4292316287 4292448389 4292053631 4292382080 4292119168 4291725441 4292119415 4292119169 4292119159 4292119943 4292120709 4292119168 4292119424 4292447872 4292053623 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289478732 4289283151 4289282901 4289480529 4289283157 4289283151 4289085266 4289283145 4289871693 4289283923 4290069841 4290464600 4291119693 4292042327 4292108639 4292375407 4293427037 4293299311 4293429887 4293565053 4293566077 4293566077 4293565047 4293565046 4293564543 4293564786 4293562740 4293628020 4292968043 4292901228 4292111201 4289611081 4289147980 4287181130 4288556615 4288361289 4288166222 4289151056 4289347666 4288759637 4289281102 4289480536 4289610838 4289347661 4289479245 4289216080 4289217616 4289808211 4289282126 4289545289 4289938512 4289545297 4289479754 4289675086 4289742664 4289413199 4289413192 4288622665 4288095038 4293769379 4293904522 4294100612 4293762667 4294038680 4293625704 4293830001 4292969594 4293237606 4292569194 4292446066 4292767559 4293234814 4292241743 4291719016 4291052880 4289147722 4290992986 4291585403 4292966759 4291849323 4291258748 4291320411 4290866801 4292246401 4290665054 4289943661 4290801009 4290993246 4292182142 4292111991 4291785325 4291784299 4291524479 4292372578 4291128960 4291587944 4290731885 4291718251 4291193471 4290932865 4292447865 4291788932 4291329403 4290728538 4291719803 4292378758 4292446081 4292646278 4292843389 4292706943 4291328130 4289749110 4290275200 4289624455 4289490826 4290346129 4291786372 4291267732 4291855245 4289619835 4290873239 4291200125 4289755538 4288304774 4285338951 4292447119 4292909447 4292251778 4292446857 4292580743 4292184976 4292118406 4292053365 4292055718 4292644250 4292778640 4292120204 4292645506 4292253841 4292052611 4292841849 4292382344 4292118429 4292581241 4291990175 4292120720 4291921544 4292449678 4291331732 4291394156 4291462805 4291462543 4293048725 4293709488 4292713336 4292517777 4292058256 4292587688 4292459699 4292983987 4292917921 4293838259 4292787366 4292129957 4292719521 4291868066 4292720818 4292260508 4292261790 4292657081 4292591030 4292525237 4292722617 4292722608 4292854196 4292854195 4292854202 4292525494 4293313980 4292854459 4292722616 4293313979 4292985527 4293117374 4292722616 4293445566 4292985788 4293317058 4293313210 4292923074 4293447108 4291198598 4291730073 4292250755 4291267460 4291921534 4289809986 4288039005 4287839325 4289942369 4290869886 4293442996 4294238674 4292393643 4282777648 4283239496 4284024645 4284226109 4284293709 4284750920 4285341000 4284356680 4284358216 4284158788 4285406010 4285607504 4284751432 4285275971 4284555854 4285277777 4286459474 4290014343 4291790722 4292579207 4292114299 4291592572 4291722879 4291528829 4292447615 4291989381 4292711045 4292251525 4292382079 4291922304 4292382080 4291988096 4292447872 4292382080 4292119424 4291594111 4292447872 4292316544 4292053631 4292119424 4292053632 4292119415 4292119416 4292447864 4292053633 4292120957 4291725183 4292119168 4292119415 4292119424 4292119424 4291791233 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289480535 4289085265 4289676366 4289282901 4289151051 4289478481 4289677914 4289217358 4289545302 4289872456 4290399317 4290398551 4291120724 4291318619 4292505439 4293228113 4292968560 4293101942 4293431666 4293565816 4293564535 4293565047 4293565047 4293566078 4293564272 4293565562 4293565299 4293562228 4293362795 4292507486 4291714631 4289807190 4289149774 4287900742 4287311687 4288491594 4288165454 4289214797 4288496208 4289611346 4289873746 4289019724 4289610825 4290002257 4289413197 4289675853 4289217617 4289806157 4289806413 4289479761 4290068557 4289936464 4289611598 4290397259 4289873227 4289806414 4288954450 4288623176 4288092999 4293770393 4294168469 4293703814 4293840804 4293629036 4293703047 4293430382 4293109861 4292967004 4293040500 4293363806 4293035651 4293032776 4292970872 4292106841 4289610578 4289874262 4291520360 4291519587 4291125105 4291257192 4291716728 4291126115 4292115845 4290864996 4288956264 4290864486 4291057500 4291262324 4292707710 4292247150 4291785067 4291653756 4291849327 4291986038 4291258980 4289812338 4291719011 4290929775 4291854206 4291719033 4291849322 4291921017 4291710827 4291857027 4292312715 4291919736 4292575354 4292248190 4291259013 4287707487 4288237441 4289027726 4289355637 4288824425 4287382889 4288100966 4288762216 4291195766 4291852169 4289088868 4291593343 4291721607 4292119954 4290413715 4287252605 4289421924 4291919749 4292183153 4292778392 4292973693 4292975242 4292514432 4290147988 4289818753 4290937749 4291917947 4291855998 4292974227 4292250523 4292974482 4291394446 4290539146 4289091447 4286259266 4292386465 4292643732 4291858586 4290803064 4291135362 4290932356 4292056969 4293051821 4292916119 4292518033 4292120459 4292979879 4292459705 4292983725 4293246894 4293510313 4292720552 4292984233 4292130982 4292260513 4292260513 4292721322 4292196788 4292721842 4292197293 4292591030 4292525237 4292919986 4292656823 4292656823 4292986037 4292393653 4292985780 4293313980 4292657080 4293511349 4292919995 4292919994 4293051838 4292722615 4292920251 4293379773 4292985532 4293708734 4293187013 4293906117 4292256394 4292120711 4291792517 4292120186 4290271834 4287377222 4287507533 4288298572 4289414233 4290346130 4292191917 4293514183 4294307774 4288240472 4283039803 4283697459 4283500864 4284159027 4284683333 4284749884 4284554055 4284420675 4284813885 4284488773 4284882244 4286127682 4284356927 4284882010 4284750421 4285277516 4288698231 4291129467 4292576896 4292577413 4291657836 4292049292 4291987316 4292118150 4292054404 4292054916 4292250494 4292711045 4291987839 4292384380 4292316288 4292447872 4291594112 4292053887 4292053632 4292513408 4291594111 4292447872 4292053888 4292119424 4292119425 4292119424 4291921537 4292119425 4292119424 4292119168 4292119424 4292119424 4291922046 4291921537 4292119672 4291789947 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289217363 4289480535 4289676110 4289480279 4289085265 4289283156 4289480279 4289414737 4289545044 4290070358 4290200142 4290398290 4291119694 4291123797 4292306012 4292377188 4293426521 4293232237 4293563514 4293564024 4293563767 4293566078 4293499511 4293565046 4293566079 4293564529 4293563513 4293563001 4293298551 4292899434 4292242264 4290333518 4288559950 4287965770 4287440967 4287769414 4288823378 4289216592 4288691533 4289546066 4289610581 4289478738 4289217616 4289545295 4289349459 4289740877 4289545034 4289481040 4289479760 4290068556 4289675342 4289481553 4289872714 4289675854 4289476430 4289611339 4289152078 4289147209 4288027966 4293899658 4294103214 4294102678 4293764201 4293841830 4293694050 4292974967 4293559403 4292975743 4293362249 4292245362 4293166678 4292575607 4294017360 4291519592 4291122005 4291585380 4291056492 4291126371 4291060579 4291060841 4291386977 4291130231 4290207583 4289676891 4290928999 4290665593 4291522409 4292836474 4291585640 4291852656 4291652473 4291848551 4292511620 4290401373 4290533978 4291719287 4291323513 4290932335 4291719547 4292119944 4291060065 4291057781 4291264369 4292576906 4291985800 4292643969 4292114565 4290465134 4286922341 4289094015 4291465632 4291523718 4291587965 4290798698 4290798976 4289157484 4288433787 4286657376 4287970409 4287976062 4291464080 4292450721 4292777108 4292907657 4290939021 4288438167 4287255696 4287188628 4288044417 4289416045 4290010479 4292581523 4293695626 4292578964 4291663779 4289431962 4288367485 4290870166 4290736007 4291659157 4291273402 4287586943 4289956530 4286067843 4283501372 4290148756 4292055175 4291067547 4291456130 4292390560 4292983453 4292782745 4292185991 4292186250 4292586400 4292393378 4293512124 4293641909 4293051050 4292327338 4292917414 4292458408 4292591289 4292656303 4292262325 4292196516 4292720302 4292197291 4292656567 4292525238 4292656815 4292986046 4292656822 4292854201 4293116857 4292788410 4293116857 4292920251 4292985787 4292854459 4292920251 4292919995 4293248442 4293313979 4292854458 4293313980 4293316802 4293185474 4294235593 4292259999 4292121229 4292055433 4290932825 4287967049 4286984270 4287969874 4288756299 4288827243 4290470001 4292977044 4293578692 4294433216 4293775541 4284088362 4283500352 4283502131 4284221255 4285077049 4284554310 4284749886 4284619844 4284225093 4284355391 4285209405 4285471043 4285473612 4284489801 4284555100 4284752463 4286525785 4290799990 4291265668 4292117888 4291920493 4292050828 4291788651 4292117906 4292449411 4292054659 4292054916 4292316286 4292317061 4291987839 4292317061 4292382079 4291988096 4292447871 4292183944 4292119423 4291659903 4292315272 4292053887 4291922045 4292119425 4291922036 4291725442 4292119672 4291922046 4292119424 4291725441 4291790967 4291725441 4291987837 4292053375 4291331705 4292053631 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289807953 4289414743 4289019722 4289677658 4289480529 4289675853 4289085265 4289807953 4289742423 4289675083 4289676111 4290593871 4291054923 4291844953 4292831831 4293162592 4292967517 4293496690 4293563764 4293565560 4293566078 4293499255 4293763700 4293500286 4293564272 4293499775 4293562994 4293562997 4293690216 4292769635 4292043092 4290333519 4288624462 4287311430 4287376202 4288427853 4288162631 4288691793 4289282637 4289478738 4289676367 4289217615 4289413203 4289938254 4289676881 4290266195 4289807178 4290267475 4289609548 4290398039 4289807434 4290068557 4290003028 4289544269 4290265678 4289346635 4289411662 4289081929 4288093757 4293830537 4294171311 4293503620 4294168987 4293566839 4293837456 4294092128 4293107073 4293362013 4292310641 4293363551 4292637291 4293955939 4292374367 4293162848 4290992990 4291122778 4290733673 4290533211 4291122264 4291060066 4291064178 4291519591 4289153131 4290342261 4290533478 4291655014 4292770683 4291588460 4292439399 4291192174 4292050033 4291587174 4290009960 4290073949 4290996343 4291521131 4290864750 4291916926 4291984237 4291457644 4290731628 4291983468 4292246396 4291264647 4292509570 4292052359 4291390081 4288893809 4291000729 4291590780 4291982197 4290602106 4290273400 4290076018 4288369259 4288760171 4288959595 4287777390 4285995861 4287320711 4290746292 4292976799 4292055196 4293105569 4290734484 4288901024 4289231521 4289426848 4288967078 4288903088 4286204552 4286919011 4287054433 4290408318 4290078594 4291593364 4288767369 4288106085 4286990452 4284814390 4286003559 4285208163 4287974238 4287650674 4283170897 4285738836 4291924384 4291594122 4292390301 4293048998 4292185985 4292250493 4292250507 4292520612 4292656556 4292783520 4293246881 4292918961 4292985010 4292916136 4292525234 4292524720 4292788401 4292131772 4292655269 4292722617 4291868069 4292656824 4292525238 4292722608 4292986037 4292591030 4292854202 4292788408 4292920253 4292986036 4292722874 4292722616 4292986301 4293445566 4293051063 4292920251 4292919995 4292657080 4293051837 4293248446 4293775044 4293316545 4292914327 4292055940 4291064160 4289352782 4287375175 4287708496 4288429903 4288563032 4288758873 4290076271 4292315013 4292394675 4294038460 4294501836 4287644488 4283171896 4283501378 4284491334 4284418877 4284750399 4284750142 4284750142 4284814144 4284419385 4284747065 4285144647 4285276233 4285013312 4284487751 4284291908 4285539664 4288762728 4290934415 4292314749 4291985287 4291655291 4291657854 4291593344 4291921799 4292054658 4292384137 4291989124 4292316804 4291989381 4292381566 4292317829 4291988613 4292053631 4292053632 4292053887 4292119424 4292119424 4291659646 4292119424 4292119424 4292119424 4292119425 4292118138 4291725432 4291987582 4292119680 4291987581 4291922046 4292185216 4291593854 4291594101 4292185209 4291724924 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289347409 4289612116 4289676116 4289217363 4289019472 4289745764 4288496208 4289676116 4289807959 4289415252 4290333269 4290464081 4290990423 4292108374 4292571500 4292704358 4293558891 4293166702 4293562990 4293565561 4293565047 4293565303 4293499511 4293565046 4293500286 4293763955 4293497209 4293562222 4293233009 4293228114 4291650146 4289808212 4288756555 4287900743 4287965255 4288884809 4288756559 4288624462 4289217101 4289151571 4289085522 4289741904 4289545032 4289742424 4289742423 4289216338 4290004047 4289283672 4289740877 4289872969 4289414225 4290068557 4290003021 4290266187 4290136136 4289411915 4288823889 4289081672 4288093779 4293372033 4294167194 4294105005 4293897056 4293576863 4293831535 4293570440 4293895019 4293498483 4292836680 4291123548 4293100897 4292045149 4293699443 4292632662 4290072418 4290267990 4291188314 4291126629 4290468456 4291324265 4291584872 4288167258 4289943906 4291190105 4291456624 4291918961 4292310378 4291848555 4291130997 4292047981 4291061101 4290530658 4290208365 4291193457 4291322469 4291390074 4291586411 4290995822 4291062395 4290993761 4291194753 4292184964 4291715941 4292183420 4292511625 4291059835 4288760171 4291332760 4291987854 4291588216 4290274435 4288693347 4288171124 4289288059 4287314520 4285607502 4285800008 4285669458 4285145687 4286400382 4289892523 4291988875 4292972200 4290085797 4288770728 4289234603 4289816211 4287977349 4287981200 4286332536 4286070642 4285413492 4287786139 4285740912 4285213039 4284688728 4286592095 4285343073 4286526565 4284422489 4283568968 4284359234 4282846024 4283898693 4283041865 4282648639 4291006615 4293249731 4292586632 4291918974 4292314740 4292058009 4292524459 4293315507 4293246898 4293312166 4292984754 4292656555 4292523944 4292130476 4292523943 4292920502 4292524720 4292589734 4292656305 4292261303 4292262067 4292590254 4292788401 4292524981 4292854202 4292854202 4292854193 4292788410 4293182641 4292525497 4293117106 4293445557 4293380031 4292788658 4292986303 4292854203 4293380030 4293445558 4292986565 4294038966 4292719785 4292449894 4290278263 4289939281 4287509065 4287704908 4287773008 4288887888 4288035916 4289612640 4289547620 4291462802 4292983712 4293313971 4294106560 4291337873 4282777640 4283501642 4284156733 4283831364 4285079370 4284488516 4284748093 4284817478 4284025649 4284225856 4284615474 4285144647 4285800518 4284422472 4283371088 4284160578 4286660209 4290012551 4292118131 4292119174 4292050825 4291134082 4291919723 4291921801 4292447612 4292057231 4292316546 4292316029 4292777354 4291987325 4292318859 4292316029 4292317061 4292381822 4292053632 4292119167 4292053632 4292382079 4292449414 4292119423 4291922044 4291725439 4292119424 4292119424 4292119424 4291791232 4291397504 4291987838 4292119671 4291725441 4292119680 4291987839 4291922046 4292119673 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289807959 4289348944 4289611863 4289611859 4289677396 4289216594 4289743188 4289414737 4289283664 4290070616 4291317069 4291250264 4291187284 4292106835 4292309611 4293162818 4293297521 4293429101 4293564532 4293565561 4293565047 4293564542 4293566076 4293566595 4293565046 4293500285 4293564280 4293562997 4293296747 4292835683 4292042829 4290335065 4289147979 4287246666 4287442759 4287836233 4288164172 4289411144 4289480267 4289216589 4289348943 4289019730 4289808210 4289742421 4289938255 4289938510 4289479509 4289742424 4289479753 4289871184 4290068563 4289609805 4289546062 4290854222 4289740114 4289480266 4290461521 4289149513 4288750400 4292179558 4294304703 4293833840 4293902483 4293964145 4293771433 4293965686 4293435516 4293430113 4291456099 4293160788 4290856524 4293891178 4292569682 4289810012 4289743704 4290857557 4290665310 4291126374 4291125084 4290994794 4288036426 4290073956 4290601336 4291257975 4292510831 4291192173 4291455081 4291849324 4292504936 4291590256 4289943647 4290997373 4291716447 4290734718 4291585906 4292111465 4290935158 4291126636 4290468701 4291194745 4291917419 4292509063 4291852396 4291193209 4291125366 4289089654 4290082957 4291456116 4291787886 4290076559 4287838306 4288174195 4289945980 4288366179 4287644264 4289942908 4290140540 4287053930 4287386006 4288048282 4288767907 4290474627 4289163422 4289235879 4288902804 4288174214 4285476453 4285213015 4284490841 4284947039 4285675638 4288838584 4287386755 4283961932 4286530169 4285475929 4284355929 4284226108 4284029765 4283697216 4283831875 4283766108 4283698745 4282844227 4283634250 4288510879 4292984499 4292975486 4290868614 4292054919 4292590526 4292723892 4292591029 4293246117 4292984232 4292392874 4292723124 4292523438 4292590769 4292590513 4292722347 4292722090 4292524720 4292655528 4292129705 4292328621 4292394406 4292788403 4292328628 4292330165 4292722358 4292854203 4292788658 4292986045 4292591032 4292919467 4292786867 4292986303 4293182650 4293314495 4293510071 4293380022 4293577926 4293250747 4293047699 4291392104 4290073671 4288625233 4288166214 4288103503 4287708240 4288363344 4288231759 4288560716 4288824154 4289548903 4291725194 4292717739 4292982177 4294104513 4294564042 4285011241 4284033114 4283894838 4284093502 4285078596 4284422722 4284751431 4284619587 4284358217 4284420680 4284881480 4286127173 4285078854 4284881726 4283962181 4283763018 4285010496 4288304495 4291393393 4292117661 4291657596 4291460964 4291785079 4291788441 4292120194 4292383363 4291988098 4292384136 4291989896 4291989123 4292317829 4292381565 4291989380 4292382339 4291991178 4292447358 4292055174 4292119165 4292119167 4291659645 4291987335 4291987335 4291987335 4291791230 4291725439 4292119424 4291856768 4291659645 4291856768 4291790977 4291594109 4292185217 4291725688 4292119683 4292118387 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289217363 4289807959 4289546322 4289546074 4289613392 4289217109 4289677652 4289217364 4290003797 4289609805 4290726997 4291054671 4291644492 4291255131 4292897892 4292311908 4293360216 4293235822 4293629819 4293562738 4293371001 4293564529 4293564279 4293566077 4293564279 4293566077 4293564280 4293562228 4293298286 4292769902 4292635220 4290335819 4288491337 4287964998 4287441738 4287773007 4288885835 4288626001 4288561232 4288693330 4289544274 4289415256 4290003797 4289347660 4289347661 4289545302 4289938510 4289872975 4290068301 4289872976 4289807439 4289807188 4290136397 4290266952 4289611592 4290134094 4289348686 4289017163 4288293202 4290665285 4294500011 4293906085 4293898608 4293771692 4293967986 4293769357 4293829223 4293297760 4292962648 4290924117 4292112479 4291255369 4291913832 4290598747 4290140254 4290731879 4290138201 4290598746 4291719540 4288954448 4290009457 4290204512 4290796920 4291982186 4291520892 4292243320 4291520615 4291390572 4291654509 4289941350 4291192424 4291388781 4291389805 4292047741 4290342011 4290995048 4291455872 4291060325 4290931302 4292637831 4291722606 4292112504 4291719035 4291784563 4288365938 4289815659 4291984265 4291916422 4290143884 4286926970 4290340229 4291392650 4290204251 4289481604 4290608011 4290871459 4289032358 4287315571 4286065523 4286794111 4287188343 4286725233 4288640414 4288569991 4286394988 4285609576 4286069615 4285078095 4284684381 4288309403 4288049294 4284685386 4285148267 4285476983 4285804640 4286530424 4283306827 4283765316 4283633226 4283303732 4283572072 4283503955 4283110996 4287261605 4290876559 4293443745 4292120188 4290080895 4292120478 4292986561 4293117365 4293248440 4293510566 4293048491 4292657589 4292523423 4292524979 4292588958 4292589232 4292589992 4292524720 4292524720 4292591289 4292393902 4292327845 4292262068 4292590512 4292590255 4292591030 4292722352 4292722617 4292854441 4292984501 4292525494 4292854459 4292392357 4292722098 4293774015 4292920245 4293314230 4293579980 4293250749 4291928188 4289744972 4288363849 4287967564 4287051599 4287707726 4288432991 4288756302 4288955986 4288690508 4288824918 4290073949 4289356659 4292055191 4293309344 4293246365 4293841585 4294169764 4287645776 4283105338 4284027719 4283961661 4284683589 4284620359 4285472330 4285273148 4284358218 4284816963 4284619584 4284158263 4285668158 4285341001 4284422473 4283896900 4283632460 4285999194 4289027947 4292117632 4291854965 4291657854 4291590026 4291068032 4292382074 4291989123 4292319118 4292383107 4291988098 4292449672 4291923588 4292775549 4291923076 4292448905 4292054916 4292118653 4292055173 4292447356 4291858581 4291661186 4292184978 4291921542 4291791230 4291791230 4291987335 4291987335 4292119679 4291397248 4292185216 4291725440 4292119680 4292183930 4291331960 4291986553 4292119672 4291921794 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289414743 4289742416 4289676374 4290071378 4289741912 4289742411 4289610575 4289215568 4289676875 4290465371 4290727764 4291054672 4291577925 4292108634 4292766024 4292769903 4293558890 4293233014 4293172080 4293565560 4293563511 4293564542 4293566077 4293565047 4293565304 4293565303 4293564537 4293561457 4293494380 4293162589 4291649632 4289547093 4289279307 4287247693 4287374918 4289017420 4288098379 4289085521 4289414218 4289611603 4289413196 4289608784 4289481289 4290003793 4289742669 4289740876 4289872981 4289807189 4289677142 4289479753 4289872726 4290331721 4289741649 4290003022 4289740878 4289282638 4289870922 4289346639 4289014341 4289210175 4294500537 4293770877 4293905574 4293967472 4293573017 4293836937 4293831798 4293432936 4291254872 4291712338 4290397524 4291458928 4292112740 4290997872 4291122264 4291124834 4290074725 4291192936 4289022293 4289284962 4291384917 4291322995 4292769629 4292047486 4292374115 4291652475 4291653743 4291718250 4290008680 4290731628 4291124826 4290865266 4292113261 4290864495 4291653742 4291062129 4290861681 4290994788 4291783292 4292247915 4291588478 4291914597 4292049805 4289021546 4289686142 4291326359 4291191671 4291058539 4288304506 4290076542 4291324792 4290206067 4289355412 4289025675 4288701561 4286921837 4286855786 4284883540 4286197845 4286591853 4285670753 4286663800 4287585701 4287057795 4287455904 4286791794 4286263159 4287319443 4287785892 4285807714 4285342300 4286994317 4285869667 4284885581 4285351285 4285280105 4284819028 4284029509 4283304254 4283435327 4283369001 4282515522 4285871974 4292524201 4293571976 4290735737 4290737532 4291404198 4293112223 4292394420 4293378211 4293116847 4292720814 4292985008 4292524720 4292590770 4292589735 4292591805 4292196774 4292588960 4292526010 4292787882 4292523943 4292590769 4292195755 4292656305 4292656048 4292195752 4292591031 4292919979 4292525237 4292459445 4292788666 4293313980 4292986296 4293248170 4293314496 4293576894 4293774532 4293776061 4291727711 4288494665 4288624453 4287445070 4288297039 4288363344 4287838032 4288824143 4288889680 4287970123 4288757324 4288826206 4289614440 4291135127 4292973433 4293108891 4293575836 4293644715 4291393378 4285207860 4282975800 4284614463 4284091703 4284683846 4284684349 4285274173 4285013061 4284682813 4284226371 4284617796 4284424782 4285406016 4285668412 4285015372 4284288576 4283501646 4283501373 4287776614 4290670733 4292053638 4291591807 4291985518 4291133823 4292117379 4292053630 4292777353 4292252551 4292317305 4292384143 4291529346 4292907652 4291924361 4292447875 4291989380 4292119684 4292119684 4291726468 4292055172 4292183942 4292578940 4291267204 4292119422 4292119422 4291725440 4292119678 4291921799 4292118393 4291791232 4291725440 4292185216 4291528316 4291987337 4292053629 4291987329 4291528573 4292316285 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289544787 4289742160 4289678169 4289480537 4289546322 4289938261 4289545296 4289610826 4289479504 4290070615 4290528335 4291446344 4291186521 4292108638 4292765786 4292835423 4293165678 4293299056 4293629298 4293564542 4293565560 4293564785 4293564536 4293370226 4293564274 4293566335 4293562737 4293562235 4293232751 4293163102 4291848793 4290399054 4288493647 4287966021 4287377994 4288295756 4288754763 4289806417 4289741390 4289085517 4289478733 4289611088 4289807955 4289086288 4290004048 4289281868 4289676889 4290397773 4290068306 4289740877 4289218387 4290331728 4289807434 4289871441 4289741389 4289674833 4289216336 4288954961 4289145158 4288292421 4294296962 4293906868 4294100344 4293705118 4293967988 4293771676 4293699187 4293493358 4292506459 4291054678 4291189084 4292976778 4291717221 4293232239 4290729566 4291651169 4291453281 4289285487 4289020493 4290665853 4290470506 4291718249 4290994288 4292442986 4291586429 4291457138 4290931324 4290074456 4290471543 4291125857 4290995820 4291980151 4290930287 4291127150 4291061875 4291060583 4290993758 4291391345 4291590014 4292636273 4291652731 4291649898 4289283424 4289684602 4291389576 4290865526 4291062904 4290075526 4288827517 4290016668 4289227933 4288370588 4288109177 4285999707 4285341258 4285077842 4285472342 4285408353 4284619862 4285405763 4286263922 4287913626 4287057288 4288383147 4287054973 4288635807 4287058053 4288774307 4286327656 4288504210 4288508059 4283436337 4285476727 4284224853 4285744491 4287059075 4282910789 4283369789 4283636562 4283173180 4282384469 4287521417 4292001699 4292912004 4290137186 4290273137 4292521901 4293183404 4292457377 4292588442 4292522651 4292523168 4292590513 4292525496 4292589735 4292589231 4292590250 4292587933 4292588449 4292590763 4292587691 4292132015 4292655529 4292589230 4292721065 4292262052 4292262067 4292722359 4292196792 4292788144 4292132795 4292919987 4292854193 4292920253 4293510062 4292852917 4293446340 4294038712 4292983451 4289290851 4287314528 4287575883 4288432990 4288299608 4288366159 4288362832 4287642702 4288691788 4288891218 4289877625 4289945455 4290344068 4292317837 4292648334 4293049273 4293773214 4293710259 4290804847 4282777650 4283631944 4284746045 4284617285 4284618309 4284554051 4284883530 4284947268 4284617278 4285140802 4284424779 4284352823 4285274172 4285405507 4285211465 4284816966 4284355647 4283700811 4284819034 4289289325 4291591551 4291789176 4292249205 4291132291 4291523975 4291987834 4292055689 4292316545 4292317319 4292317576 4292710530 4292448900 4291528317 4292448899 4291990153 4292447357 4292054915 4292449161 4292118909 4292120709 4292119164 4291463825 4292184956 4292119165 4292119444 4292119421 4291725440 4291791231 4291791232 4292119680 4292183930 4291397504 4291856768 4291856767 4291134333 4292185470 4292052872 4291791232 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290071128 4289416539 4290135636 4290071378 4289546329 4289545300 4289347660 4289545290 4289872713 4289873237 4290792271 4291121238 4290989127 4291778390 4292637519 4292442226 4292967514 4293102698 4293627776 4293172596 4293630839 4293564024 4293563768 4293566078 4293564536 4293564529 4293565305 4293563508 4293494123 4292769893 4292241245 4290070610 4289147722 4287313744 4287376966 4289014854 4288165710 4289149261 4289151566 4289151566 4289479245 4289609040 4289806413 4289610826 4289740878 4289808205 4289676619 4289481049 4289545294 4289543505 4289938505 4290068308 4289611597 4289871184 4289740878 4289086794 4290199630 4289349195 4288559686 4288226627 4292975755 4294101912 4293506708 4293969291 4293703049 4294169221 4293633148 4293560159 4292239187 4292372578 4293101424 4292045158 4292577671 4291582289 4291855749 4291125601 4289808221 4289284442 4290138980 4290597985 4291520874 4291715942 4292115051 4291586172 4292047717 4291389819 4290662749 4290077552 4291388022 4291059033 4291521659 4291389029 4291061615 4290931840 4291060853 4291254873 4291917692 4292441194 4291782757 4292507787 4291652195 4288692847 4289356180 4290472842 4291128424 4291458424 4291520901 4289877883 4287976331 4287254900 4285607506 4285540951 4286263146 4286593135 4286201204 4285800280 4284621646 4285408086 4285668937 4286328429 4287782811 4286859889 4288906679 4286593906 4287188612 4284553278 4287055224 4287053693 4287453584 4288638852 4285407330 4286794380 4286533764 4283433554 4285680759 4286337671 4283105333 4283107657 4282712136 4284555099 4288707222 4293184170 4293037691 4289284958 4289487476 4292652452 4292918180 4292984475 4292521879 4292652445 4292259996 4292259233 4292197045 4292656304 4292196269 4292588966 4292588712 4292591543 4292652433 4292193449 4292590762 4292654767 4292195746 4292655023 4291671727 4292328622 4292262829 4292262570 4292264123 4292525237 4292788152 4292656815 4292656824 4292656823 4292657339 4293249982 4292589722 4290608238 4289426314 4289621626 4288756551 4289478738 4288758865 4288952135 4288167245 4288035402 4288822616 4289219685 4290144633 4291461495 4292775806 4293038980 4293107335 4293438362 4293309319 4293906874 4292457360 4283891754 4284027723 4284488252 4284618820 4284487237 4285076547 4284816969 4284881218 4285800007 4284683064 4284551487 4284027709 4284815934 4284883022 4285867079 4285671500 4285279832 4284029526 4284095813 4287381352 4290342018 4291854974 4292380540 4291722370 4290803312 4292184197 4292121224 4292056716 4292318861 4292384396 4291989639 4292318088 4291990408 4292448904 4292316803 4292054664 4292054148 4292121224 4292053890 4292120709 4292120452 4291726468 4292578684 4291529360 4291792516 4291790972 4291792518 4292119423 4292119423 4291725439 4292119424 4291791232 4291922304 4291790976 4291790976 4292185470 4291789201 4291397503 4291659636 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290005334 4289875043 4290728803 4289545044 4289481049 4289674832 4289872724 4289872981 4289807189 4290266709 4290463052 4290266706 4291054676 4291846748 4292240466 4292836196 4293820265 4293036404 4293629042 4293236343 4293237892 4293236861 4293564785 4293565304 4293565304 4293565561 4293562744 4293562740 4293430128 4292836191 4292043601 4290268488 4289151570 4287375432 4287507018 4287770697 4288298321 4288693328 4289282638 4289151053 4289544275 4289480787 4289217610 4289545297 4289806413 4289086544 4290266707 4289938248 4289545047 4289742668 4289740627 4289283917 4289938250 4289610318 4289807434 4290003793 4289545290 4289086030 4289213772 4287768134 4290926396 4294502337 4294098546 4293507224 4293967223 4293700744 4294031477 4292838520 4292971874 4291910206 4290995071 4292183157 4292770154 4291988613 4292043871 4290799470 4289021529 4289353072 4290138197 4291716702 4292441710 4291389800 4291256422 4291852160 4291126118 4290730856 4290076777 4291650933 4290994527 4290995302 4291650678 4292113526 4291127410 4290535010 4290991701 4291787137 4291921270 4291257451 4291064452 4292108897 4291061627 4287901524 4291198605 4291457652 4291652989 4291320946 4288629889 4287117931 4285147733 4285209933 4286920806 4287649425 4287121279 4285609052 4284948560 4284751173 4284749378 4285337429 4285275983 4287714443 4288573083 4288045465 4287388545 4286134630 4283959098 4284817250 4284554048 4287784099 4285740650 4286131814 4287059088 4286532732 4284292415 4283368511 4285484152 4284556117 4283304251 4282712132 4283044426 4290217613 4293179043 4292641384 4289088093 4290212486 4292721316 4292982176 4292917656 4292456088 4292650385 4292127648 4292127901 4292129955 4292655280 4292588967 4292653984 4292588970 4292589212 4292652444 4292194727 4292263338 4292653728 4292196524 4292653740 4292589488 4292721062 4292262069 4292656047 4292197049 4292590773 4292722609 4292459445 4292985529 4292854461 4293249205 4293247395 4289886822 4288169315 4287055977 4289757839 4289622914 4289222260 4288692038 4289544267 4288429407 4288758888 4290142579 4290604914 4291988862 4293171079 4292972414 4292778634 4293039494 4293370256 4293242263 4293645227 4292125831 4284549938 4283892292 4284289348 4284815933 4284682825 4285010224 4285145671 4285341769 4285537346 4284686922 4284550717 4284814398 4284224071 4284681273 4285733436 4284951628 4284878148 4284951141 4284098905 4285015899 4288764281 4291657342 4292249218 4291985777 4291331202 4291133058 4292513406 4291990407 4292318093 4292711031 4291924878 4292054401 4292710531 4292383106 4291989641 4292383106 4292055432 4292447100 4292055432 4292121225 4292053117 4292514436 4291334280 4292120452 4292120451 4291792258 4292052615 4291790974 4292119423 4291792773 4291987079 4292119679 4291856511 4291397248 4292119424 4292119424 4291791232 4291790200 4292184186 4291855751 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289352029 4290791507 4289875802 4290071128 4290201429 4290005849 4290071641 4289872468 4289677131 4289807183 4290135376 4290661968 4291316817 4291845712 4292506475 4292902241 4292771678 4293298028 4293562490 4293630072 4293235309 4293238651 4293630334 4293562993 4293564025 4293564786 4293564537 4293562228 4293622886 4293163356 4292109916 4290269278 4288624204 4287377481 4287443274 4288491593 4288818248 4288626257 4289215307 4289414730 4288888144 4289478733 4289610832 4289938511 4289545295 4289412946 4289479759 4289545040 4289742668 4289545040 4289610837 4289545040 4290071888 4290198608 4290397265 4289218381 4289742413 4289478734 4289020498 4288621641 4288751162 4294235562 4293840291 4294164604 4293307536 4294165891 4293765505 4294029680 4292770662 4291127930 4290927699 4293038202 4291583586 4293166194 4290934898 4289610332 4289085265 4291386968 4291126397 4291721857 4291782499 4292177787 4292048762 4291520623 4289483358 4289617516 4291256943 4290995316 4291387745 4291584377 4291060579 4291061872 4290406270 4291058026 4291913059 4292308854 4291453818 4291851628 4292373861 4291588217 4291128954 4287903854 4291130507 4291848821 4289614959 4287251830 4286327646 4284748381 4284815945 4288306082 4287718295 4284884564 4285211991 4284226371 4285343070 4284419131 4285605735 4283893833 4287380862 4289299629 4288700559 4288440711 4286526832 4284615503 4283959367 4283892275 4288050347 4287122561 4284949071 4287649925 4286995597 4284024638 4283107419 4282974264 4287327648 4286140822 4282515519 4284621653 4290152073 4293506702 4291455844 4290076011 4291593362 4293379778 4292916652 4292917655 4292523173 4292652445 4292127905 4292128413 4292784807 4292195756 4292653475 4292194723 4292130213 4292325540 4292261281 4292194203 4292719256 4292194460 4292654241 4292195764 4292655281 4292588188 4292261564 4292262306 4292590512 4292591029 4292525237 4292854187 4292919999 4292986282 4293578156 4291401341 4286458961 4286200669 4287257211 4288698248 4290281620 4289561747 4290737782 4289945467 4290277506 4291654239 4291858048 4293170556 4292974463 4293565312 4293235326 4292645770 4293429627 4293304719 4293173891 4294038200 4292124038 4284219433 4283632456 4284288839 4284616509 4284619070 4284750655 4285145159 4285146191 4285076795 4285276747 4285209404 4284488782 4284420926 4284155961 4284878643 4285406533 4285866569 4285672270 4284161607 4284357445 4286656084 4290538362 4291920768 4291855732 4291657855 4291392627 4291460729 4292447358 4292319622 4292317063 4292253326 4292579200 4291990413 4292319620 4291988616 4292186998 4292318089 4292055175 4292057231 4292383106 4292119426 4292122249 4291660674 4291986566 4292448387 4292120451 4291529360 4291856509 4291790976 4292119680 4291528060 4292185215 4291790975 4291858310 4291856511 4292119424 4291790976 4291856767 4291659145 4291658359 4291331710 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290465882 4289743704 4290070865 4289480536 4289480792 4289742165 4289676630 4289676878 4289872725 4289413974 4290004557 4291182407 4291776598 4291385687 4292306020 4292442465 4293427306 4293036153 4293564275 4293564023 4293237373 4293236845 4293171322 4293566334 4293564023 4293564025 4293564536 4293561984 4293691755 4292769121 4292175711 4290268236 4288691537 4287376454 4287508039 4287837004 4288164939 4289213771 4289283150 4288953680 4289348950 4289676617 4289543504 4289938517 4289742418 4289742675 4290068300 4289479760 4289938256 4289545039 4289349459 4289740877 4289740621 4289217102 4289872970 4290002771 4290201939 4289742663 4289215563 4288623948 4288093515 4293367916 4294234528 4293507736 4294033017 4293700229 4293969803 4293433459 4293765000 4292906862 4291062648 4292109913 4292774784 4291189332 4291323491 4289743445 4290270818 4291123568 4292111971 4291849065 4291717996 4292044643 4290536554 4290332755 4289612638 4291126391 4291060836 4291586419 4290996849 4291126890 4290535785 4291059557 4290796888 4289548918 4291395211 4291586682 4291784569 4292242555 4292242786 4292444553 4291851400 4289021290 4291128958 4289879404 4286000735 4285603932 4284421457 4286134898 4288504472 4285741147 4284157758 4283964233 4284220484 4285343819 4284486984 4284615761 4284292180 4283958840 4288374687 4288634502 4288897411 4286395488 4283897918 4284881491 4284287815 4287718818 4288507799 4285143898 4286596745 4286860407 4284357451 4282909242 4283833168 4282974276 4286999960 4285015136 4285675621 4291796630 4293439893 4291653221 4289088871 4291661967 4292657582 4293051058 4292458659 4292587166 4292195487 4292127638 4291668119 4292259493 4291670951 4292784038 4292195220 4292783524 4292127125 4291999391 4292718494 4292717731 4291671458 4292719782 4292194730 4292653984 4292196255 4292654505 4292262565 4292262068 4292590254 4292722873 4292657083 4292986289 4293317299 4291533175 4286197573 4286263384 4287057269 4286987872 4288961912 4287778402 4289427343 4290017171 4292248971 4293170047 4293758325 4293103486 4293891458 4292972673 4292974458 4292971391 4293368452 4292973701 4292909704 4293568654 4294104498 4293441947 4283761455 4283107395 4284419128 4284812606 4284619326 4285603397 4285669446 4285473611 4284488517 4285537604 4285274687 4284747321 4285144389 4284225854 4285603138 4284881734 4285669447 4284748597 4284156221 4283635277 4284422731 4288633466 4291131520 4292117618 4291657599 4291855504 4291327855 4291986807 4291991696 4292711806 4292251527 4292318604 4292253324 4292318603 4292318347 4292318861 4292318088 4292383112 4292053881 4292053635 4292448899 4291727241 4292119426 4292122249 4292120451 4291726468 4291726468 4292578685 4291792518 4291790974 4291725183 4292185990 4291790975 4291790975 4291856511 4291857542 4291791230 4291922304 4291463040 4291725181 4291725438 4291593850 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290465882 4289286493 4290070871 4289415000 4290071128 4289415000 4290071642 4289479246 4290136402 4289807692 4290201168 4290922574 4290399560 4291909212 4292437333 4292834908 4293164144 4293495916 4293562477 4293566592 4293629290 4293564799 4293563767 4293564529 4293564799 4293564786 4293564274 4293563258 4293231211 4293163361 4292109916 4290268240 4288560464 4287963978 4287376967 4288558412 4288757841 4288624462 4288691789 4289677389 4289085522 4289085523 4289413708 4289740883 4289479503 4289742412 4289677139 4289938255 4289546831 4289610832 4289545290 4290004048 4289545296 4290068557 4289348433 4290201426 4289741392 4290003792 4289086286 4289148235 4288226885 4291655529 4294369737 4294164598 4293504912 4294167960 4293897334 4293840017 4293301876 4292641145 4293569148 4291914604 4293107836 4291584613 4288887888 4290138991 4291127145 4291651937 4291589504 4291717494 4292901237 4291128961 4289808202 4288758636 4291847264 4291388005 4291060838 4291256692 4291321454 4291127147 4291060086 4290666853 4290598240 4290346130 4290012791 4287647092 4287641420 4289480020 4291915153 4293099641 4291587453 4288760927 4288169830 4285473627 4285741162 4284685651 4286268522 4287911290 4284685120 4285081959 4284354372 4283829815 4285606226 4285541215 4283958072 4284421461 4284682575 4286465907 4289366197 4285474641 4287052143 4284421183 4284484411 4284882266 4288112807 4289166751 4286922621 4286792308 4287589023 4283564092 4283039786 4285941651 4283170860 4283111743 4287191458 4286137449 4292451994 4293370508 4290402131 4289684337 4292189855 4292654488 4293639329 4292591535 4292653206 4292062879 4292781729 4292388768 4291669171 4292128166 4292784286 4291735190 4292192920 4291602594 4292522910 4291667865 4292194458 4292128929 4292128678 4292653483 4292588453 4292589731 4292591285 4292588967 4292588453 4292591289 4292788659 4292524721 4293248678 4293114527 4286592830 4286329424 4283433535 4286528863 4289297293 4287977854 4288174711 4288041849 4288440190 4290217616 4291857543 4292973961 4293037696 4292973694 4293300848 4293235586 4293693049 4293299845 4293237887 4293239713 4293570961 4294432416 4293048480 4285207088 4283238464 4284419134 4284222271 4284748862 4285078598 4284683063 4285274432 4285211465 4285210438 4285144902 4285080913 4284878385 4284485440 4285011256 4284160070 4285143868 4285538124 4284687694 4284223315 4284621641 4285605214 4290339959 4292053637 4291723391 4291985775 4290541181 4291722878 4292448645 4292318084 4292251528 4292319366 4292318590 4292317065 4292319363 4292253844 4292317053 4292383113 4291988098 4292383880 4292383880 4292053891 4291725699 4292119940 4292118909 4292054916 4292119684 4292119938 4291726724 4291790717 4291989136 4292120196 4291790718 4291397247 4292252294 4291396991 4291856766 4291658888 4291463038 4291922304 4291855482 4291855750 4291527557 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289808471 4290595927 4289941339 4290005335 4290530648 4290136150 4289676623 4289283672 4290396750 4290006096 4289872464 4290658890 4291119952 4291845727 4292699482 4292835163 4292968558 4293233782 4293430651 4293237101 4292844418 4293631094 4293566077 4293565304 4293565559 4293564025 4293564280 4293560432 4293691756 4292768865 4292307796 4290205018 4289150800 4287311430 4287574602 4287246153 4288756046 4289414221 4289085008 4289151565 4289610316 4289151571 4289413203 4290069577 4289938513 4289347405 4289545045 4289545039 4289413203 4289543504 4289806413 4289349459 4289152080 4289872971 4290201158 4289480276 4290463816 4289415511 4289676361 4288888914 4289015368 4289672516 4294300822 4293772707 4293972387 4293699180 4293906073 4293762413 4292969335 4293374096 4293430643 4292843642 4292504407 4291257696 4288952140 4290732392 4291321436 4291782259 4292243322 4292113247 4291256939 4290796638 4289747051 4290340209 4290536804 4291125600 4291127406 4290469743 4290075747 4291192940 4290601834 4290466647 4291917181 4291915626 4292504932 4292376170 4291127423 4288369530 4286657875 4289022057 4291060077 4288892013 4285539409 4284949842 4285213272 4286662004 4286656616 4285147993 4285407842 4285145668 4284880472 4285605207 4286593899 4283698237 4284221507 4284287298 4285540951 4287583619 4287976589 4284485950 4285734484 4285144396 4284553821 4287255172 4287784071 4285212510 4288637096 4287919532 4285210706 4282384440 4286009998 4285419406 4282581050 4284821873 4290153630 4292127390 4292116323 4290009178 4290798191 4292450453 4292789432 4292456855 4292985005 4292721066 4292194717 4292783772 4291798172 4292191903 4292325777 4292391338 4292259995 4292192929 4292457365 4291734171 4291864212 4292326050 4291924365 4291932320 4292260521 4291933616 4292654504 4292129436 4292980648 4292523423 4292525492 4292722348 4292589217 4292790712 4290875497 4283105333 4284683074 4288765053 4287253610 4285798989 4290941069 4288967830 4287647083 4289885075 4287252592 4290214268 4292251809 4292644987 4293103488 4293300863 4293237639 4293628537 4293172868 4293238660 4293634197 4293505954 4294497695 4293248413 4285336881 4283106366 4284420936 4284617285 4284748863 4284619327 4285208124 4285144648 4285079623 4285667644 4284684864 4284684607 4285668675 4284423237 4284355391 4284684864 4285274430 4285732413 4284947780 4284357956 4284553801 4285012288 4287710049 4290737270 4291330687 4291197054 4291786368 4291788926 4291922300 4292318345 4292711822 4292252294 4292319364 4292318607 4291792756 4292253071 4292777341 4291990159 4291793013 4292383625 4292318087 4292055176 4292056191 4292448649 4292055688 4291726468 4292513668 4292120450 4291725201 4292054670 4291856508 4291790717 4291791492 4292185733 4291790975 4291790718 4291858310 4291790974 4291922558 4291658631 4291858309 4292053372 4291857024 4291396989 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290399319 4289217879 4290005335 4290005335 4289546840 4289806418 4289676631 4290003795 4289611608 4289806927 4290201932 4289611860 4290070858 4291777105 4292109132 4292834421 4293360982 4293494638 4293236336 4293237116 4293631868 4293562230 4293565571 4293564534 4293564542 4293564529 4293566590 4293563514 4293232494 4292770659 4292636264 4290793293 4289082443 4287375431 4287505738 4287967562 4288753736 4288625998 4289085264 4289085008 4288758352 4289151564 4289479245 4289347661 4289413198 4289217610 4289808211 4289612618 4289543505 4289938762 4289282126 4290004048 4289543504 4289477712 4289940566 4290134094 4291120729 4290004812 4289807955 4290069834 4288429390 4288688724 4291719762 4294437839 4293835649 4294104733 4293965174 4293173648 4292839017 4293567871 4292781714 4293366637 4290665055 4288754762 4290466137 4291651691 4291717760 4290862943 4291125853 4291324546 4290796121 4289083733 4290604161 4291126371 4291256691 4291257723 4290535012 4290797667 4290076004 4291321967 4290598251 4291455337 4291849065 4292311660 4292704648 4291653767 4288828015 4288096319 4289221747 4287576171 4285801554 4286267495 4286006136 4285606752 4287119995 4287057536 4285609060 4285936743 4285605466 4284289881 4285539909 4288505499 4284357191 4283827771 4283762758 4284748384 4287188615 4285741146 4286791276 4284287292 4284749126 4285011022 4284884041 4287916439 4286325345 4287057278 4287454602 4285805408 4282843191 4286529675 4288189629 4283698245 4282056772 4287984303 4291800494 4291985782 4288762223 4290404724 4291207587 4292984992 4293378480 4292852393 4292849319 4292589745 4292129194 4291866782 4291733656 4291867304 4292849298 4291600798 4292391323 4292259232 4291863445 4291732376 4292520348 4291928978 4291801253 4291994258 4292063911 4292327596 4292654252 4292656563 4292130990 4292587429 4292982188 4292722083 4292523429 4289747524 4285996869 4285404741 4284157497 4287909733 4289948032 4286263905 4287514207 4290288274 4288895360 4288903559 4289420920 4288638595 4290480274 4291592575 4292446848 4293761407 4293171589 4293566590 4293567378 4293566847 4293571221 4294891427 4290671189 4285140266 4283503421 4284287028 4284287801 4284747322 4284813113 4285208895 4284818254 4285142331 4285013062 4285669190 4285210184 4285408330 4284552764 4285339977 4284683314 4284944186 4284553535 4285342283 4284683579 4284160588 4284554059 4285474906 4288699000 4290868865 4291593075 4291396480 4290998639 4291657342 4292447615 4292318848 4292252797 4292319380 4291989127 4292319363 4292317839 4292776583 4291925374 4292385171 4292383367 4291991167 4292383368 4292055935 4292120713 4292055417 4292448132 4291726468 4291726467 4292121993 4292118908 4291792258 4291595669 4292185731 4291792260 4291726725 4292119167 4291792518 4291790717 4292054158 4291397245 4291922559 4291856767 4291395974 4292119165 4291265661 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290925402 4290466138 4289875546 4290006618 4290005079 4290005593 4289482326 4289348944 4289938255 4289742669 4289218132 4290331467 4290725706 4291646039 4292044643 4292899918 4292968303 4293301362 4293629306 4293564784 4293564541 4293563260 4293565559 4293565303 4293498749 4293565560 4293564798 4293561965 4293691500 4293096541 4292438119 4290400334 4288755784 4287375946 4287506503 4287901769 4288756302 4288691793 4289085265 4288823882 4289217101 4289544788 4289413196 4289806419 4289741388 4289543504 4290002512 4289346123 4289741389 4290069585 4289545546 4289675342 4289677133 4289872713 4290594899 4290594124 4289808210 4291053385 4289874005 4289872720 4289283659 4288885066 4289477698 4294363532 4294105530 4293836163 4293907110 4293634695 4292575079 4293302409 4293565798 4293175189 4291784546 4289017421 4291783783 4291587687 4291389287 4291520871 4291191160 4291257440 4289678678 4290205806 4291584609 4291322990 4291191930 4291125613 4291190873 4290206071 4291518831 4291124336 4291650414 4292311162 4291650933 4292043885 4290401109 4289352043 4287839588 4285147225 4284945722 4285669459 4286661234 4285610877 4285996874 4286532727 4286661487 4285805926 4285279078 4285342546 4283434053 4284221491 4288177573 4287053926 4283695933 4283895110 4284155976 4285083992 4288174208 4286003046 4284617292 4284289607 4284682818 4286394481 4286786393 4286197346 4284552777 4284950624 4287783061 4283893582 4283564103 4288323767 4286803107 4282581031 4285016694 4291604659 4289550699 4288961131 4291062639 4291997608 4293376946 4293115052 4292787120 4292523681 4292588969 4292261285 4292392871 4292259744 4292130204 4292258717 4291668905 4291931813 4292456867 4291666848 4292326041 4291991964 4291732117 4291734956 4291995285 4291995292 4292391587 4292327597 4292327340 4292196268 4292654497 4292590245 4292129179 4292519329 4292448903 4289876838 4287048279 4287774559 4288171375 4286325320 4287648622 4288700275 4286793327 4288635511 4289759386 4288304750 4289231002 4288171371 4291003787 4291921552 4292905846 4293300357 4293627774 4293566076 4293499264 4293837998 4293907610 4288368195 4283629620 4284091974 4283961918 4283960378 4284421442 4284879162 4284945988 4284813874 4286190658 4284752972 4285670734 4284686404 4285935695 4285210438 4284554053 4284291389 4284550976 4284420416 4285404215 4285341001 4284883017 4284422206 4285276742 4286591575 4289817202 4291197057 4291129969 4291065728 4290274684 4292250245 4292317576 4292253069 4292646031 4292121721 4292318606 4292318349 4292318591 4291991686 4292384142 4292316288 4292383885 4291989383 4292384397 4292383623 4292055175 4292054665 4291988355 4292514432 4291660675 4292513667 4291661189 4292118909 4292120707 4291725182 4291726725 4292119166 4292119424 4291790717 4291858053 4291790716 4292120721 4291593086 4291856768 4291790717 4291265661 4292251008 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289809754 4289873751 4290531674 4289942364 4289877342 4290726228 4290071128 4289481050 4289740626 4289675085 4289938507 4289740869 4290265163 4290992978 4291911757 4292899169 4293428844 4293035893 4293563255 4293565054 4293565301 4293565315 4293564272 4293500286 4293763956 4293498738 4293565047 4293561979 4293231467 4293098338 4292438376 4290333770 4289148236 4287377738 4287573831 4287902284 4288822095 4288687687 4289281355 4289217358 4289347152 4289478732 4289676373 4289545300 4289740883 4289938512 4289480010 4289740877 4289938512 4289479759 4289543505 4290069069 4289938511 4289282646 4290661201 4289677141 4291055697 4289743183 4290072149 4290069837 4290004551 4289086543 4288685382 4291124559 4294170785 4293906865 4293903754 4293701502 4293175954 4293630069 4293176727 4293506429 4291125591 4290077551 4291651167 4291847796 4291258745 4291126913 4291126110 4290138721 4289681010 4291258213 4290995820 4291389294 4291125599 4290536297 4291059306 4290994822 4290075991 4291060851 4291916403 4291912838 4289811821 4288961403 4290139777 4290143340 4289811056 4289615739 4287514733 4288104047 4285408339 4285538128 4286397051 4287058292 4284816985 4284291658 4284092995 4283697223 4284420959 4287118456 4288904863 4285609070 4283500337 4283894604 4283960646 4285608299 4288174721 4286067303 4284287292 4284816451 4285670495 4284554047 4285931094 4284094548 4283830847 4286598255 4287059849 4283498573 4283962181 4288387268 4284883039 4287188863 4289364391 4287909486 4288958312 4288832911 4292524737 4293310870 4292985003 4292851123 4292524200 4292591028 4292260002 4292326052 4291866524 4291800746 4291733665 4292257438 4291669933 4292522393 4291866528 4291995541 4292120970 4291662997 4291799969 4292260256 4292324253 4291277224 4292392108 4292458148 4291540133 4292720304 4292194457 4292453021 4293113254 4293441189 4293174184 4292775817 4289281354 4287114317 4287510607 4288766343 4286788693 4287448930 4287517297 4287117924 4290020490 4289095558 4288701053 4289088369 4289557122 4291659163 4292969868 4293105293 4293566847 4293504412 4293973150 4294359937 4286980665 4283435332 4283896114 4284356934 4284682822 4284417850 4284880954 4284879154 4285472325 4285472583 4284552247 4285866826 4285537861 4286063437 4285012027 4284289342 4284420663 4284815945 4284748863 4284812855 4285342283 4284751688 4284358216 4285475423 4285867351 4288106344 4290342520 4290409844 4290278006 4290275441 4290540914 4291856767 4292385157 4292253573 4292646772 4292646031 4292318589 4292318606 4292186999 4291990146 4292317831 4292383880 4291989639 4292382855 4291988871 4291989639 4292383885 4292383103 4292382339 4291989128 4292449672 4292054659 4292120451 4291729039 4292120200 4292119940 4292512893 4291727498 4291725181 4291988365 4291791491 4291856510 4291462782 4291922560 4291856768 4291265916 4291592838 4291659645 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290465882 4289875546 4289875290 4290006618 4290201172 4289349464 4289480792 4289938003 4289742674 4289742675 4289740878 4289675854 4290069323 4291381324 4292306271 4292506203 4292706417 4293299310 4293561726 4293561979 4293171324 4293566849 4293565052 4293566077 4293499254 4293499511 4293564031 4293563763 4293494381 4292769617 4292110429 4290795090 4288557387 4287441482 4286982983 4287969101 4288360776 4288166993 4289216593 4289085008 4288953936 4289546066 4289019729 4289676373 4289610825 4289545290 4289609041 4289938518 4289872975 4289740883 4289741388 4289675340 4289413974 4290595918 4290135126 4290398797 4290202715 4290267470 4290266702 4290398031 4289611091 4289871949 4288954961 4287964744 4293107047 4294237102 4293905311 4293634428 4293901959 4293438350 4294029424 4292969849 4289012543 4292842862 4291977570 4290926939 4291060838 4291127402 4290731371 4290206572 4290534765 4291060079 4291389036 4290993773 4290609561 4290932132 4290800270 4290669449 4290138519 4289881480 4290798220 4291390084 4291980158 4291190888 4291585131 4288955731 4287774300 4289151586 4288428900 4286589790 4285870449 4287381367 4287912303 4287054964 4285146449 4283635785 4283894090 4283762502 4284748873 4286792312 4289167271 4285010235 4283697222 4284093511 4284879679 4285739879 4286722657 4285806701 4284881222 4284748106 4286260813 4284419901 4284095554 4284748362 4283565118 4286795654 4286727804 4283170889 4286207373 4287590581 4288964498 4291400859 4288772258 4285735503 4290077307 4289895598 4293179296 4293180328 4292458147 4292523938 4292590250 4292720816 4292259487 4292325545 4292456859 4291799193 4291799705 4292259222 4292324245 4291800998 4292323484 4291862433 4291468693 4291209378 4291998372 4292457379 4291670187 4291997602 4292458405 4291538858 4292127133 4292521369 4292388502 4293440701 4293307568 4293244601 4293374374 4292974481 4291649645 4289216077 4286723935 4286852173 4289558941 4287976819 4288172144 4287979140 4288964223 4289366168 4289425292 4288834181 4290080135 4291266434 4292774535 4293698945 4293640351 4294300559 4292573019 4285929529 4283829309 4284093501 4284616006 4284026174 4284812863 4284813625 4285471557 4285670737 4285275202 4285602365 4285273145 4285407300 4285012285 4284946748 4285801032 4284684605 4284620358 4284684606 4284681017 4284947782 4285538114 4285012290 4284947273 4285408338 4286657625 4289289338 4290215544 4291325566 4289883765 4289096054 4291523980 4292120967 4292318603 4292646800 4292253587 4292318347 4291990926 4292383623 4291988873 4292383609 4292383625 4291988857 4292317320 4292712063 4292318849 4292318073 4292382855 4292055432 4292055688 4292119426 4292119427 4292056457 4292118653 4292118909 4292120451 4291727240 4291727241 4292120451 4292119167 4292120964 4291857795 4291858826 4291528575 4291463040 4291856768 4291922560 4291463040 4292119165 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289809754 4290400346 4290531417 4289350746 4289676373 4290071385 4289610839 4289481037 4289544783 4289808211 4289545290 4289478225 4290462794 4290857548 4291781977 4292964192 4292704096 4293496432 4293630328 4293565827 4293630837 4293565058 4293566850 4293564015 4293501060 4293764474 4293499250 4293562740 4293624429 4293099125 4292110420 4290857809 4288560721 4287376966 4287572039 4287967562 4288360009 4288756302 4288624202 4288562000 4289282636 4289480281 4289546065 4289217620 4289413203 4289478734 4289217866 4289545296 4289543504 4289545295 4289938517 4289677142 4289742417 4289282133 4290070603 4289939288 4290726995 4291251795 4291252313 4290793815 4289941330 4289415498 4289477451 4288819529 4290200400 4294368693 4293769608 4293443216 4293702786 4293700992 4293771925 4291124829 4290734188 4293295212 4290795613 4291121744 4290994799 4291123576 4290270047 4290537333 4291323003 4291584862 4291521919 4289946498 4290995327 4290928222 4289679977 4289880972 4289883529 4290079368 4288634503 4288893315 4288701337 4289814404 4288759922 4286527084 4285407826 4287971181 4285868892 4287317100 4287315815 4287778680 4287255441 4286000223 4284292163 4284422747 4284225096 4284157253 4284749393 4287520648 4287979396 4284091972 4283961669 4284879941 4287586452 4284547901 4284227400 4285340227 4285342545 4285867362 4287187570 4287778206 4287187839 4287386514 4286129250 4288048807 4285938050 4285606500 4287389854 4287322503 4289291655 4289819024 4287585686 4288766088 4291932340 4291994796 4292654241 4292914849 4292195742 4292719007 4292130220 4291539373 4292784532 4292194463 4291733408 4291734425 4292061091 4291798952 4291734683 4292322452 4291732376 4291403679 4292061342 4292321435 4291932075 4292456870 4292325789 4291734950 4291538088 4292587426 4293505179 4293307555 4293767866 4293572006 4293574575 4293574819 4293700505 4292259475 4292703852 4290530388 4288691797 4287510363 4287052106 4289627298 4288170599 4286988398 4286787652 4290412161 4289428618 4289623192 4289687432 4291395975 4292581023 4293965463 4293239155 4288757065 4284287806 4284222781 4284486725 4284356164 4284291140 4284881726 4284418104 4285535808 4285603390 4284882501 4285998668 4285537351 4285012541 4285013831 4285668423 4285471811 4284750658 4284551486 4284351294 4285274944 4284945203 4285732413 4284949580 4284424010 4285146185 4285540188 4287709276 4289687932 4291065972 4290015350 4289357676 4290408823 4291200120 4292515724 4292253585 4292712338 4291925890 4292188290 4292054904 4292318088 4292382855 4292055950 4291991180 4292383624 4292318093 4292253325 4292316547 4292383112 4292056200 4292054399 4292120199 4292121224 4291659907 4292513411 4291662472 4292119684 4292120451 4292119683 4292119683 4292120452 4291726716 4291790719 4291398533 4291922046 4291462783 4291922304 4291856769 4291594110 4291922806 4291461766 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290333527 4290334810 4289811292 4290595927 4289349464 4290331731 4290529357 4290071387 4289742417 4289347404 4289479246 4289477450 4289346897 4291054155 4291716451 4292572512 4293099629 4293496694 4292971631 4293630332 4293172857 4293630838 4293564284 4293566077 4293564789 4293500285 4293564786 4293562484 4293232751 4293098587 4292701800 4290072400 4289147979 4287375175 4287506760 4287966278 4288363600 4288755018 4289217105 4289085264 4288953680 4289348937 4289281360 4289478739 4289610825 4289413197 4289609041 4290004298 4289545290 4289349459 4289675090 4289938505 4289413711 4290531156 4290529874 4290201940 4291120205 4290072412 4290074712 4290923603 4289743700 4290791250 4289741904 4289152076 4288554320 4293832584 4294369989 4293772192 4293638018 4293834357 4293840283 4292242804 4293363550 4291123810 4291124821 4290599004 4290862950 4289874772 4289219690 4290797665 4291258211 4290865025 4290864742 4289940072 4290335315 4289152358 4290798466 4292045163 4291979628 4291780472 4292045961 4291195767 4289092993 4287907950 4285014612 4285867090 4287248998 4285342550 4287642477 4287379304 4286725996 4287188094 4286856543 4285674332 4285080916 4285604687 4284097358 4283500616 4285801832 4287052647 4286990976 4284882772 4284948560 4285999955 4286201447 4284418878 4284554307 4284488515 4284226887 4285211471 4284747578 4285343055 4285211978 4284421189 4284618826 4286991736 4285015634 4285935465 4286595953 4286859152 4287056770 4289433014 4288501645 4291539622 4291725986 4291995306 4292258192 4292651669 4292127638 4292127398 4292326815 4292456858 4292389019 4291926427 4291731094 4292649625 4291144102 4291863959 4291990672 4291930005 4291995285 4291864483 4291798166 4292321694 4291799454 4291209126 4291667110 4292062628 4293178540 4293440944 4293243824 4293637801 4293179562 4293571753 4293574318 4293574318 4293573556 4293703093 4293300615 4292501607 4289870411 4287183955 4286392929 4284751668 4289886868 4287051857 4286003817 4286464101 4290151068 4289558920 4289492872 4290740626 4292646806 4292046180 4289943647 4286325578 4284023612 4284483653 4284355141 4284356676 4284288836 4284552773 4285078854 4285207864 4285141816 4285603655 4285472325 4285144126 4285603912 4285406787 4285406786 4285474638 4284814391 4284419392 4284226112 4284945721 4284487742 4285472325 4285012546 4284420680 4284882774 4286327886 4288697966 4290082156 4290146946 4290013045 4290015093 4289950082 4292447614 4291991699 4292386177 4291990653 4292384659 4292056978 4292055692 4292317831 4292383373 4292055934 4292448137 4291793788 4292383615 4292317832 4292383097 4291989128 4292054658 4292449407 4292056206 4292119943 4292121224 4292054402 4292122510 4292119938 4291728009 4291792003 4291792260 4291726468 4292120709 4292119166 4292185733 4291332741 4292251525 4291397248 4291791223 4292119165 4291527047 4291528831 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290333527 4290335065 4290465123 4289808727 4290071128 4289940307 4289611095 4289676880 4289938261 4289610832 4289283146 4289086286 4289543249 4290728014 4291321951 4292439111 4292772210 4293100652 4293431923 4293564290 4293237634 4293172084 4293566076 4293565563 4293566594 4293565820 4293565304 4293564281 4293689965 4292705635 4292176484 4291319120 4288625996 4287376967 4287572039 4287312202 4288556872 4287575118 4288691792 4289016650 4289807952 4289413203 4289611087 4289413196 4289545296 4289610834 4289347666 4289609039 4289740883 4289545295 4290004048 4289609805 4289872975 4289741397 4290724941 4290859099 4290660172 4290663003 4291384410 4290073430 4290596179 4290005586 4289676876 4288953936 4288556623 4293763958 4294104227 4294104487 4293574548 4293638788 4293572754 4293372788 4291914086 4290337372 4291322489 4291128185 4289547091 4289348178 4290337636 4290537854 4291322485 4291060339 4290797922 4289811317 4290073449 4291588720 4292374904 4291717493 4291190634 4289547391 4288759377 4292375421 4291323771 4289220477 4286195541 4286065513 4285346142 4284750677 4285212237 4286127195 4286593633 4287384702 4286922352 4286066284 4285342540 4283766084 4283963475 4285145168 4285805412 4285474909 4286658411 4287515770 4286466178 4285146701 4284027196 4284618318 4284748092 4284748606 4284813628 4284488258 4284555340 4284356155 4284487740 4284157250 4283565127 4285215854 4285671516 4287583864 4285678193 4285080953 4286205059 4288175246 4288247198 4289493641 4290745240 4292125069 4292784799 4292122775 4292390299 4292127654 4292849570 4291732898 4291534994 4291403422 4292252040 4291277226 4292649355 4291533721 4291930260 4292322474 4291928476 4292061074 4291403425 4292061846 4291794824 4291602098 4292983972 4293440175 4293706158 4293241769 4293245356 4293570475 4293571765 4293573284 4293572785 4293572786 4293573031 4293574305 4293303942 4292901753 4290856525 4289018444 4286656082 4285209673 4285999955 4288174464 4287907938 4284618062 4289558915 4289753241 4290477701 4290478489 4291135367 4291193964 4290073179 4287834697 4284221501 4284549190 4283896631 4284091967 4284484925 4284683070 4284881732 4285667908 4285275460 4285735753 4285669960 4285079370 4285535802 4285211209 4285013830 4285143613 4285077056 4284354106 4284614963 4284619328 4286194254 4285471299 4284488256 4284752723 4286129483 4286987879 4289819515 4290869378 4290474612 4289292909 4289880181 4291066238 4291398532 4292843149 4292319108 4291989901 4292384899 4291990909 4292383117 4292384644 4292059527 4292054665 4292055925 4292120713 4292055950 4292384396 4291990406 4292382855 4292054664 4292055432 4292448382 4291990670 4292447875 4292055432 4292121479 4291990664 4292447618 4292121480 4292119674 4292120197 4291725182 4292120965 4291725184 4292184950 4291790719 4291856511 4292185217 4291659645 4291331453 4291725181 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290399063 4289939543 4289875802 4290530391 4289349464 4290201429 4289415251 4289938261 4289479759 4289610832 4289479245 4289542478 4289084742 4290792789 4291779155 4292637534 4292772208 4293362024 4293431930 4293563260 4293631868 4293628273 4293564284 4293565819 4293565563 4293565820 4293565303 4293562489 4293035635 4293097064 4292636246 4290596434 4289345352 4287309639 4287441223 4288689226 4287181388 4288820042 4289414227 4289215568 4288888143 4290069845 4289806161 4289349458 4290003796 4289545044 4289808215 4289217620 4289806418 4289806419 4289086793 4290068563 4290201426 4289349710 4290399829 4289873231 4290663261 4291254356 4290072412 4290857041 4290205537 4290333774 4290200912 4289281869 4288554827 4293238151 4294171574 4294037666 4294101907 4293770631 4293705083 4293757799 4290926684 4291126374 4291124827 4291190875 4290664311 4290073975 4291518832 4290535542 4290861655 4290141548 4290073191 4291455609 4291982700 4292570230 4291585379 4291452269 4291455365 4289743964 4288239216 4290206819 4288889430 4288691031 4286722132 4286002544 4285605201 4285209685 4284946005 4283830616 4286525800 4286396511 4286461280 4285933660 4286791793 4285673060 4285278289 4284289364 4287055487 4284024397 4286070401 4287914380 4288436105 4284882517 4284024651 4284683572 4284622159 4284419899 4284424267 4284685122 4284884559 4284353859 4283898176 4283698759 4283827764 4285938535 4289616260 4289090932 4287642466 4285610099 4287789493 4288841640 4290156447 4291927451 4292514441 4292126624 4292127131 4292127901 4292128947 4292456856 4291340447 4291402652 4292648591 4291859593 4291403165 4291864481 4291732136 4291799960 4292325538 4291928467 4292189325 4291797678 4291865250 4291465875 4291863467 4293244064 4293308320 4293638578 4293508526 4293573286 4293571752 4293573298 4293574573 4293572786 4293507249 4293573029 4293572258 4293571999 4293699729 4292836983 4291446872 4290068303 4287574346 4285539667 4283302972 4286266455 4287910510 4286787161 4286987865 4289821328 4290080888 4290678683 4291921798 4292049271 4290139228 4286190915 4284619582 4283829054 4284549190 4284681021 4284355660 4285207354 4285668936 4285277772 4286062403 4284814139 4285933389 4285930816 4285868622 4285540430 4285733958 4284618813 4284486975 4284486969 4284419657 4284419891 4285077565 4285274172 4283898700 4284948039 4285737304 4288763254 4290602611 4290540660 4289228921 4290404974 4290212213 4291396986 4292186245 4291990404 4292318605 4292384914 4292252043 4292383374 4292319364 4291990668 4292055429 4292449159 4292055951 4292055176 4292055935 4292382600 4291991168 4292384399 4292055934 4292120712 4291989639 4292448904 4291593588 4292121993 4292054402 4292842631 4291990151 4292118672 4292121481 4291725182 4292120708 4292120452 4292120700 4292120710 4291792261 4291792517 4291790976 4291856768 4291922561 4291724671 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290008156 4289348951 4290005592 4290530391 4289414743 4289941595 4290071129 4289413959 4290133838 4289545290 4289347153 4288952653 4289020499 4290269527 4291190108 4292636764 4293098345 4293102457 4293299058 4293237370 4293238393 4293172601 4293566593 4293566337 4293566593 4293565563 4293566078 4293564275 4293231210 4293492077 4292110955 4291319376 4288426828 4287377994 4287505738 4287966790 4287771727 4289411917 4288496463 4289085007 4288759893 4289217358 4289152085 4289871697 4289283671 4289546580 4290003789 4289217621 4289545295 4289740883 4289543503 4289480015 4289675090 4289741390 4290595415 4290201939 4291253074 4291120473 4290661968 4290730335 4290727499 4290857295 4289873999 4289413709 4288884559 4293041032 4294171818 4294036638 4294038184 4293905312 4294162036 4291119693 4290595409 4290599004 4291128187 4290075227 4290600561 4290666846 4291060598 4290273116 4289347418 4290399602 4291389811 4292178039 4292176754 4291914362 4291847780 4291062147 4290270046 4288757332 4288229449 4288823137 4286716747 4285537096 4287581315 4286265704 4284226371 4284028996 4283503943 4284159047 4284226367 4286727813 4285868892 4286067565 4285875062 4287252335 4284883034 4284027717 4286333033 4284682825 4284620126 4288306841 4289297052 4286266980 4283695924 4284422732 4284616000 4284687437 4284683586 4283829319 4284487235 4284094024 4283631420 4283434046 4285212256 4288304518 4290539632 4287440467 4288430949 4288176553 4290221230 4290279817 4292194465 4292784789 4292585630 4292718483 4292062629 4292719271 4292720544 4292193959 4291799201 4291859851 4291595667 4291468708 4291665307 4292517014 4292259494 4291800738 4292059281 4291267982 4291465351 4291665294 4291924628 4292913821 4293506212 4293704617 4293573032 4293574062 4293772212 4293506981 4293573043 4293572773 4293574319 4293506981 4293772456 4293506737 4293509041 4293570208 4293567883 4293298310 4292107864 4289739855 4287836233 4286062663 4284289603 4283697979 4287715699 4286723937 4286458461 4289886865 4289950356 4290475395 4291659396 4291590273 4290399827 4284552261 4284748349 4284289341 4284680516 4284160069 4284815933 4284682042 4285141814 4285801547 4284684866 4285802314 4285339200 4284882245 4285344334 4285537604 4285143356 4284488773 4285013318 4284157760 4284681523 4285404730 4285342540 4284685380 4284159039 4285011018 4286595688 4290079602 4290477689 4290936952 4290014325 4289226608 4290345591 4291265929 4292121472 4292383882 4292382585 4291728762 4292777359 4291727995 4292383352 4292384917 4292054911 4292056705 4292383610 4292382843 4292383612 4291990409 4292383355 4292317817 4292384143 4291793787 4292383625 4291988872 4292450433 4292053635 4292121736 4291662216 4292120194 4292120450 4292120452 4292118910 4292121482 4292120452 4292118910 4291726725 4292119166 4292184960 4291725431 4291594111 4291920499 4291527559 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289416805 4290661718 4289544788 4290072410 4289416282 4290661463 4289414999 4289808740 4289283659 4289676369 4289085517 4289217357 4289214286 4290266951 4291453027 4292638301 4292770670 4293166450 4293037941 4293630587 4293563778 4293566075 4293565563 4293565819 4293564027 4293566076 4293565558 4293561977 4293689963 4293033330 4292372560 4290661455 4289214281 4287900743 4287443015 4287245383 4289018702 4288232016 4289413714 4288953935 4289741908 4290004053 4290133834 4289479765 4290135635 4289479508 4289545044 4289610837 4289872975 4289872969 4290398037 4290002770 4289741646 4290464596 4290267731 4290267993 4290663003 4291124567 4291189342 4290596697 4290664799 4290726482 4290334043 4289675340 4288950086 4293170040 4294171046 4294037681 4294035320 4294237874 4293229398 4289675344 4290200659 4291387744 4290598746 4290796901 4290732388 4291453041 4290669171 4290331727 4289615214 4290996337 4291783019 4292702072 4291193452 4292175722 4290337122 4291190615 4290670204 4287045453 4284679228 4285799999 4283763523 4285347172 4286726751 4284684610 4283763014 4284751171 4284423232 4284094557 4284093256 4286857318 4287055990 4285538129 4286198882 4287189895 4284357457 4283634759 4286396530 4285604434 4283368251 4286203019 4288180897 4289428914 4285341776 4284159025 4284091460 4283962428 4284748357 4284747581 4283108412 4283697207 4282910790 4284488011 4290345086 4289226872 4288171139 4287969358 4290743457 4290221221 4289236396 4291136428 4292523418 4292127897 4292652692 4292194973 4292654254 4292195242 4292326059 4291603609 4292187799 4291859081 4291858564 4291924359 4291663767 4291534736 4291998631 4291798687 4291665060 4291200134 4291596710 4293369997 4293045156 4293765533 4293243300 4293245611 4293638567 4293180329 4293573806 4293574062 4293574320 4293572000 4293506993 4293508526 4293508013 4293706419 4293706407 4293507751 4293570229 4293628287 4292238178 4290461515 4289475145 4285340994 4284552772 4284091970 4285471555 4287513449 4286065491 4288310139 4290149531 4290612641 4292117628 4291726486 4287703364 4285274178 4284292935 4284292173 4284618820 4284815933 4284421446 4285731387 4285734732 4285468984 4285606480 4285865280 4285211723 4286393930 4285604422 4285932875 4284752459 4284748094 4284682809 4284553280 4285011520 4285143359 4285470007 4284091714 4284488279 4285014597 4288236908 4290017402 4291328885 4290474869 4289228921 4290277236 4291659385 4291988096 4291856512 4292119166 4292055689 4292450709 4292253053 4292384141 4291990159 4292187258 4292384128 4292055686 4292055176 4292055177 4291859320 4292055944 4292383625 4291989639 4292384397 4292318088 4292317818 4292056192 4292055945 4292054658 4292121225 4292118652 4292120457 4292119683 4292120452 4292120709 4292118653 4292119684 4292120709 4292119684 4292120965 4291331455 4292513409 4292119671 4291593610 4291528313 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289546070 4289416282 4290072666 4289416026 4289613146 4289480536 4289807701 4289283670 4290003791 4289610576 4289348682 4288954193 4289346122 4290859601 4291190107 4292702316 4292771421 4293166444 4293495678 4293172103 4293563764 4293564540 4293566076 4293565563 4293566076 4293564283 4293565571 4293561974 4293234301 4293032027 4292636263 4290138453 4289215306 4287246666 4288029255 4288425543 4288230476 4288756557 4288759378 4289217106 4289478737 4289413201 4289349464 4289545043 4289677143 4289872723 4289676887 4289479501 4290068562 4289282130 4289479764 4289807188 4290136407 4290004822 4290529104 4290202706 4290727256 4291121746 4290531162 4291123029 4291121490 4290596950 4290792531 4289740619 4289476703 4291849820 4294304197 4294038179 4294036624 4294100375 4290595907 4290201422 4290333012 4289808470 4291387743 4290137442 4290206308 4290731367 4290397774 4290074482 4291782750 4291452531 4291321694 4290531668 4291259521 4291649882 4290794098 4291126901 4290536321 4286007142 4283895618 4284154439 4285079628 4286860657 4285930567 4284093762 4284750147 4284616259 4283830855 4284750911 4284027720 4284752736 4287317107 4286068083 4285932112 4286595699 4286199903 4284024632 4286335106 4284819029 4283631166 4284026189 4286530173 4289301169 4287321243 4287713680 4288108936 4284818774 4283499572 4283240775 4283435327 4283107655 4284156221 4290478467 4292841354 4288494698 4287907166 4291137191 4293176223 4291135370 4287915681 4290093477 4292982439 4292255126 4292260765 4292129714 4292589745 4292656300 4292128673 4292582027 4291598229 4291465863 4292120719 4291662737 4292059555 4292127393 4291933345 4292126354 4291923586 4292775050 4293238924 4292973708 4293306013 4293241763 4293310112 4293244846 4293571754 4293572774 4293706664 4293508271 4293574050 4293508271 4293706418 4293706162 4293640369 4293640112 4293640370 4293706677 4293571478 4293302929 4292376182 4290133317 4288561746 4286979909 4283500605 4284552522 4284748104 4287710303 4285473879 4287711066 4291138458 4291134101 4291665828 4291592071 4286521154 4283961674 4284813884 4284225607 4284746550 4284487239 4284814648 4285207865 4285930052 4285932100 4284685122 4285865547 4285933386 4285145674 4285867594 4285997901 4284420918 4284553280 4284946491 4284615732 4285601344 4284947526 4284684349 4284556108 4284816452 4286852698 4289226094 4290936953 4291263093 4290081398 4290340721 4291003011 4291462781 4291528576 4291134074 4291331454 4291856511 4291726467 4292448648 4292384397 4292385155 4291991699 4292319121 4292384397 4292055940 4292120712 4292055169 4292054409 4291793270 4292448649 4291988098 4292317321 4292385159 4292054151 4292055175 4292448904 4291660674 4292448132 4292120451 4291726468 4292120708 4292120195 4292121482 4291726468 4291725182 4292120966 4291725182 4291856768 4292119424 4291725687 4292052864 4291658627 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289741909 4289547611 4289612119 4290071127 4289546072 4289742165 4289283414 4289807696 4289546581 4289414737 4289283153 4289345613 4289152329 4290529111 4291059800 4292702299 4292837745 4292970357 4293236087 4293629051 4293566332 4293564539 4293564283 4293566594 4293565563 4293565820 4293565558 4293561727 4293429610 4293101688 4292371810 4290073437 4289480278 4287310662 4287375431 4289083213 4288164940 4288755789 4288757331 4289085007 4289086034 4289610580 4289807952 4289938260 4290068305 4290002768 4290201942 4289676887 4289479501 4289545300 4289938259 4289807187 4290070614 4290070358 4290464342 4290858841 4290201940 4291119697 4291125345 4291124056 4291121490 4291120985 4291187034 4290004306 4289478224 4290332745 4294300848 4294038434 4294106031 4293304174 4290985289 4290203479 4290267730 4289744219 4290266709 4290207841 4290335321 4290928227 4290010484 4291520106 4291255647 4292111482 4291849323 4288888162 4291125360 4290466904 4290664536 4290531433 4289153379 4287642451 4283893317 4284747588 4287120229 4287712381 4284026179 4284156223 4284026179 4284882760 4284619842 4284488266 4284487751 4284094534 4284883792 4287318130 4285999455 4285671254 4285869674 4284948320 4286336104 4286064237 4284421210 4284685142 4284885329 4289961410 4285209158 4285140791 4284686923 4284617276 4283240782 4283435315 4283303730 4282975800 4290085255 4292776578 4290465108 4290006889 4291267740 4292982689 4292710016 4291794592 4288375444 4289561263 4292130231 4292520855 4292713359 4292590516 4292720024 4292259993 4292452767 4291271332 4291857534 4291925406 4291662225 4291467168 4291799455 4292459179 4292190608 4291787401 4293234319 4293433227 4292975006 4292978063 4293700255 4293243811 4293243826 4293638566 4293573030 4293506994 4293706419 4293706419 4293508014 4293706419 4293706162 4293640112 4293904826 4294102976 4293772213 4293970877 4293507499 4293633662 4293034367 4291380818 4289804877 4287637832 4284613690 4283699005 4284289610 4286064709 4287576168 4286261327 4291203494 4291069853 4292058801 4290936186 4285469509 4285141304 4284619326 4284548676 4285013573 4284748855 4285077566 4285274946 4285209152 4285340996 4285407043 4285669959 4285210442 4285933129 4285868879 4285011259 4284487239 4284812345 4284683323 4284617531 4285338937 4285470775 4284094020 4284617544 4284948324 4287711068 4289556609 4291330935 4290674553 4290340978 4290080629 4291528574 4291922303 4292052872 4291790464 4291199610 4291725181 4291331197 4291856767 4291725181 4292119684 4292054663 4292450445 4292053633 4292120968 4292055936 4292384642 4292383113 4292382340 4292054659 4292054657 4292187256 4291990143 4292383629 4292383879 4291988354 4292121224 4292054658 4292120457 4291791235 4291725182 4292120709 4292118909 4292120709 4292448381 4292054134 4292120966 4291725440 4292119680 4291987328 4291594108 4291724928 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289480787 4289546072 4290071127 4289612376 4289546071 4290071385 4290070611 4289742424 4289610317 4289480280 4289348681 4289347153 4289085523 4289742674 4291979113 4292242519 4292837733 4293429099 4293234558 4293627516 4293171580 4293172098 4293566076 4293565563 4293500028 4293565820 4293565303 4293564281 4293691248 4292705119 4292768619 4291253843 4288625231 4287377481 4287572809 4287181130 4288885321 4288624974 4288957008 4289019215 4289478737 4290070870 4289348950 4289349206 4289611088 4290071381 4289611094 4289872466 4289677143 4289938259 4289677143 4289807188 4290136400 4290070871 4290330704 4290067787 4291068546 4291122261 4290531924 4291124311 4290465884 4291450963 4291120973 4290858319 4289805904 4289803101 4293965434 4294039477 4294237612 4292509295 4290401116 4290135895 4291255639 4291254620 4290138971 4291583068 4289611101 4289480797 4292113786 4291454563 4291125596 4290991963 4290599786 4287772240 4285999949 4287380070 4287377251 4285865805 4286722114 4286921065 4285932624 4284093507 4287583364 4286592598 4284091455 4284420932 4284155712 4285998167 4284352830 4285868890 4284356166 4284685130 4284093250 4286001501 4285872748 4285473615 4285409367 4285738091 4286594687 4284818258 4284953183 4284619875 4284816468 4288908201 4285868644 4283894087 4284090671 4283172936 4283435314 4283369524 4282581054 4289027443 4292977802 4291054683 4290200928 4291794356 4293181096 4292579980 4292645765 4292775821 4289165214 4289039013 4290223783 4290942383 4291927445 4292786601 4291534236 4292193962 4291861403 4292124042 4291863719 4291270549 4291664023 4291666323 4291997850 4291987074 4291983222 4293430150 4292973435 4292976272 4293369992 4293700513 4293176227 4293637805 4293572010 4293574576 4293506982 4293772457 4293508013 4293706420 4293706407 4293508014 4293640112 4293970619 4293904826 4293838520 4294102709 4294102709 4293640875 4293570977 4293299330 4291648858 4290395469 4288426055 4285600322 4283237951 4284485175 4285209160 4286657875 4285079129 4290276991 4291334296 4292520355 4291266445 4285338686 4284882764 4285209926 4284816704 4285928263 4285341252 4285998157 4285210440 4285014087 4285602108 4285079113 4285932618 4285869132 4285409616 4285866050 4285143102 4284552510 4284357440 4284880185 4285209407 4285079624 4284818250 4284484424 4283896905 4285999184 4288765795 4291001219 4291134585 4290801010 4289619062 4291331449 4291922303 4291793282 4291790975 4291528577 4291331453 4291988096 4291397246 4291134073 4291790216 4291857022 4292052615 4291790973 4291792260 4292121481 4292120453 4292118645 4292055419 4292056457 4292054659 4292054665 4292382848 4292056718 4292055943 4292055949 4292447874 4292120967 4292121224 4292120194 4292123024 4292512893 4291661189 4292120197 4292118911 4292055165 4292119169 4291725440 4292118138 4291725696 4291789957 4292051587 4291658615 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290331731 4289677906 4289416540 4290265934 4289482332 4289676629 4289938004 4289349200 4289414738 4289282900 4289085517 4289414474 4289019981 4290398286 4291255381 4292769648 4292377951 4292971900 4293299837 4293238387 4293629814 4293630839 4293564789 4293500802 4293764216 4293500802 4293566077 4293562995 4293036656 4293098602 4292372068 4290664029 4289282129 4287311688 4287508307 4287966277 4288230732 4289212488 4289018189 4289217106 4289282898 4289152607 4289807957 4289676629 4290201428 4290006372 4289610836 4290071641 4290068048 4289611604 4289938259 4289938516 4289413972 4290002512 4289742421 4291331195 4293302389 4290921551 4291120472 4291123550 4291122772 4291448912 4290531933 4290726220 4290334042 4289545301 4292374615 4294503881 4294171560 4292370776 4290990157 4290598494 4291124832 4291124574 4290205287 4289542990 4289482590 4291655043 4291781731 4291059829 4291784057 4290141029 4287645038 4288104558 4286918756 4286460750 4287511382 4285599035 4286063701 4287113536 4283632714 4284550204 4288244635 4285537612 4284027717 4283764287 4284292676 4286527596 4284490314 4285604679 4283962187 4284555337 4285538386 4284159043 4284948304 4285673055 4284292185 4284554054 4287714689 4286991231 4287846030 4284488258 4283959373 4287391371 4287846788 4283695669 4283239755 4283435320 4283369791 4282515512 4287780210 4293107078 4291585386 4289152103 4291988369 4292719509 4292513418 4292252808 4292316802 4292450982 4289167509 4290220205 4291736226 4290483869 4291866032 4292328373 4292589473 4292390564 4291662472 4292123555 4291992731 4292059289 4292125083 4291929248 4292117892 4292377457 4292972450 4292973702 4293432447 4292976538 4292977809 4293242021 4293240719 4293573792 4293571999 4293572774 4293572788 4293508514 4293508271 4293508269 4293508014 4293706151 4293970621 4293904826 4293508269 4294102976 4293706163 4294102723 4293838754 4293569692 4293369232 4292568684 4290854980 4289344843 4285404479 4283963971 4284221503 4284220995 4285865547 4286984281 4287119446 4290743961 4292778662 4291004803 4288035425 4284227143 4285539400 4283829562 4284816450 4285666877 4285340738 4285211464 4285406786 4285274947 4285801799 4285211466 4285801801 4285802058 4285931331 4284357445 4284159551 4284812088 4285078855 4284619328 4286127428 4284619587 4284092748 4283698752 4285805662 4289883262 4291263605 4291327850 4290342004 4290278004 4291463038 4292120713 4292120457 4292184959 4291462775 4291988097 4291528576 4291592828 4291658630 4291068805 4291199609 4291397245 4291199611 4291790717 4291724924 4291462783 4291858827 4292120709 4292119684 4292514692 4292120451 4292054665 4292056201 4291923312 4292120968 4292120199 4291728008 4291726210 4292120708 4291724924 4292121739 4292118909 4291725183 4292119424 4292119168 4292119425 4291593853 4292119681 4292447873 4292119679 4291791487 4291658629 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289874520 4290006875 4290072410 4289416796 4289741908 4289742422 4289546579 4289611866 4289677646 4289480280 4289544268 4288953937 4289411402 4290267988 4291125595 4292504665 4293164147 4293100907 4293496695 4293236354 4293632387 4293171570 4293566594 4293566337 4293500028 4293564789 4293565303 4293564012 4293298035 4293098864 4292307552 4290138715 4288824412 4287966791 4287376965 4288426066 4288232013 4289215308 4289282898 4289283155 4289808738 4289938257 4289872723 4290071384 4289349988 4290007130 4290397522 4289415257 4289677143 4289938253 4289479765 4289413972 4289872724 4289739856 4291780192 4292772962 4290136401 4291121999 4291124568 4291055961 4291057253 4291056202 4291123550 4291124063 4290725968 4290136662 4290859107 4293969295 4294435255 4292116840 4290923091 4291122773 4291121742 4291189590 4290733162 4289874778 4291258214 4291319636 4291848553 4291124830 4292113033 4292110970 4291647580 4290202717 4289615211 4288563049 4285405507 4284225855 4284554820 4283894595 4284026183 4285274707 4287585930 4285075262 4284023625 4283831098 4287183994 4285144638 4284686416 4285472851 4284158783 4284883013 4285081428 4283960393 4284552265 4285737045 4285341001 4283962450 4286330458 4288371355 4288838823 4285871218 4284616266 4284688468 4288315306 4283498549 4283304243 4283435321 4282515522 4287318121 4292846466 4292110950 4290270556 4291593354 4293047468 4292842383 4292982179 4292057755 4292122001 4292713632 4289429652 4290090160 4292583305 4292059814 4292193697 4292262578 4292262332 4291797911 4292122519 4291729558 4291992722 4291795353 4292056972 4292116077 4292968309 4292706956 4293365626 4293367950 4292973458 4293371036 4292978065 4293703591 4293176244 4293572254 4293572021 4293574576 4293574050 4293508272 4293706408 4293706163 4293706164 4293640359 4293904816 4293904570 4293904826 4293838519 4294036927 4294036915 4293574580 4293508266 4293698191 4292572024 4291119180 4289080134 4286782535 4284878134 4282976563 4284614718 4284421442 4287053672 4285668694 4291992483 4292122261 4291662223 4287445082 4284423498 4284423496 4285018718 4284224570 4285078854 4285209929 4285407050 4285538381 4285932874 4284818253 4285867593 4285738061 4285867851 4285536316 4285078598 4284550712 4284487746 4284944689 4285538118 4285472068 4284815680 4284223043 4284486723 4287841888 4290540920 4291134329 4291198071 4290078579 4291331450 4291856255 4292123271 4292120704 4291726469 4291922812 4291462784 4291528576 4291594112 4291594111 4291396988 4291659905 4291265403 4291265403 4291462525 4291464068 4291199610 4291396989 4291331197 4291594112 4291528575 4291856511 4292119423 4292513658 4292056459 4292121735 4292121735 4292119426 4292120456 4292120451 4291726724 4292118909 4291727755 4292119167 4292119424 4291725440 4291790967 4291791233 4291987838 4291922292 4291594110 4291790215 4292052591 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290660949 4289939799 4290070871 4289676373 4289546585 4289740624 4289742417 4289544788 4289217359 4289546066 4289151053 4288953936 4289349453 4290463831 4291712847 4292310382 4292770137 4293362288 4293235326 4293237371 4293236857 4293238137 4293566081 4293370229 4293564789 4293567110 4293566849 4293563007 4293560939 4292770146 4292111460 4290861153 4288824410 4287246677 4287378250 4289017170 4288229972 4288690782 4288693583 4289348692 4289807957 4289742422 4289479507 4290069842 4290071384 4290004050 4289741651 4289807187 4290068304 4289807189 4289872717 4290397780 4290070614 4290334035 4290597975 4290400602 4291187546 4290534753 4291121497 4291386717 4291385938 4291059298 4291122259 4291056979 4291125600 4290858071 4288822108 4292705638 4294637506 4293304449 4291120726 4291124055 4290597212 4290004049 4291188825 4292174434 4291322471 4290930023 4291057258 4291916160 4291584878 4291713394 4289086812 4290005864 4286782530 4284814148 4284095301 4285213534 4285865550 4283501378 4284419139 4283893817 4287912840 4284750405 4284159298 4285144136 4284949843 4284290373 4285672543 4284223044 4284490570 4285667415 4284818513 4284292164 4285736791 4284884561 4283828035 4285934435 4286922627 4286859387 4286066777 4287648396 4287253912 4287318400 4290357952 4285871465 4283106095 4282712894 4286197329 4292187273 4292636512 4289744476 4291195526 4292787883 4292908679 4292846999 4292521867 4292651951 4292714901 4291866790 4290284451 4289499044 4292384395 4291796106 4292655023 4292723387 4292918954 4292188571 4291928474 4292123032 4291793288 4291465362 4292444281 4292968569 4292708242 4293429118 4293301115 4292975506 4292971666 4293304198 4293240222 4293569197 4293572777 4293570477 4293572021 4293572774 4293574052 4293508271 4293706151 4293706165 4293640358 4293640371 4293772469 4293904569 4293838776 4294036926 4294036669 4294036671 4293904815 4293443251 4293633933 4292902776 4290790224 4289279563 4287702601 4284354360 4283107399 4284091452 4283830600 4287379545 4285209937 4291534500 4292057762 4290743449 4288561243 4285668422 4284424011 4284750662 4284751689 4286064204 4285143101 4285012805 4285540430 4285865801 4285867850 4286128967 4286129479 4285472837 4285472836 4284617021 4284750399 4284618814 4285340740 4285272629 4285275720 4283569471 4284093248 4286260819 4288046722 4291460213 4291330156 4290212471 4291258991 4291068536 4292579977 4292187517 4292055937 4292120967 4291726214 4292186235 4291856502 4291528576 4291528576 4291594112 4291396989 4291462782 4291265401 4291134343 4291199609 4291528319 4291396980 4291462783 4291199095 4290413437 4291462525 4291462269 4291332483 4292250494 4291792004 4292187785 4291792003 4291859337 4291792002 4292054672 4291790974 4291790719 4292185216 4291725440 4292185216 4291725441 4292185216 4291594109 4292052866 4291789429 4291987065 4291789943 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289940056 4290006874 4289416283 4290071378 4289742166 4289347409 4289479502 4290005336 4289283145 4289149520 4289151821 4289345614 4289415239 4290004311 4290994267 4292568151 4292836720 4292970607 4293430140 4293630082 4293629300 4293632130 4293632387 4293172860 4293565565 4293369710 4293565822 4293630582 4292969600 4292835673 4292703080 4290139477 4289214806 4287903060 4288033363 4287773270 4288364621 4288627277 4289546337 4288888141 4289676372 4289545043 4289546329 4289481049 4289872466 4289611350 4290070614 4290136150 4289611350 4290201942 4289611351 4289741395 4289940314 4290659667 4291187281 4291126380 4291121232 4290531161 4291123293 4291388255 4291253849 4291320923 4290993503 4291581017 4291647331 4290467918 4291186263 4291054406 4294365338 4293967523 4291581773 4290994267 4291121748 4291183960 4291587689 4291518562 4291060057 4291651966 4292110202 4290927698 4291324005 4288822091 4289217874 4287573581 4284815957 4284816708 4286133604 4287516536 4283566896 4283894599 4284026693 4283893827 4286859128 4286726262 4286393934 4285409634 4283962936 4285277270 4285345629 4284288837 4284947782 4284950611 4284945733 4284489287 4286397804 4285537625 4283960388 4284156989 4288505251 4285739102 4286657128 4285606241 4283762510 4283566137 4289764279 4284884068 4282646569 4285406289 4291531132 4292377973 4289811049 4290601850 4292522394 4292974986 4292449167 4292912780 4292588981 4292195482 4292716963 4291931816 4290346907 4289233563 4291859343 4292386965 4292589228 4292985526 4291799709 4291792775 4291596685 4291926166 4291992204 4292639361 4293034115 4292511619 4293496696 4292974228 4293369227 4292973986 4293367949 4293238414 4293634977 4293570975 4293570480 4293575333 4293573030 4293572776 4293574051 4293508527 4293706165 4293640358 4293838254 4293838264 4293772469 4293904570 4293904569 4293838776 4294036669 4294036669 4294036929 4293838497 4293505967 4293755523 4291778386 4289807955 4288489799 4285730106 4283567680 4283960141 4283699516 4285144144 4286065748 4290080396 4292452504 4291529879 4289089380 4285932620 4284224826 4284095299 4285209669 4285734471 4285605455 4285013316 4285406528 4285605966 4285013062 4286194503 4286131787 4285342795 4284751689 4284291141 4284749886 4285078598 4285076795 4285343828 4284685893 4284355142 4283961924 4287843429 4290738553 4291527300 4291131765 4290343798 4290540405 4291396988 4292123285 4292055422 4292121216 4292122774 4291991148 4291728529 4291792778 4291857029 4291922046 4291528320 4291528575 4291528574 4291791502 4291396988 4292053633 4290808189 4291659649 4291330938 4290479230 4291002758 4291659645 4290676609 4290870401 4291330938 4291462524 4291594112 4291396732 4291528318 4291923846 4291856510 4291790976 4292185215 4291199869 4291922560 4291790976 4292185207 4291593853 4291463040 4291594109 4292118392 4292053117 4292116093 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289806930 4290071128 4289480536 4289939541 4289546329 4289742422 4290070100 4289742423 4289478477 4289151565 4289151566 4289346382 4288819531 4290071118 4290993754 4292768365 4292639837 4292969067 4293694851 4293236351 4293238406 4292910448 4293236867 4293435764 4293566335 4293566595 4293564528 4293561720 4293363569 4292838000 4292241766 4290204509 4289282634 4287311444 4287377480 4288557124 4288168034 4289216078 4289019213 4289217106 4289480278 4289610323 4289678425 4289938003 4289611350 4289741395 4290726485 4289940313 4289611094 4290201686 4289545558 4290201943 4289413967 4290268506 4290594897 4291717224 4291447378 4291125345 4291056723 4290927968 4291517020 4291517020 4291583077 4290994264 4290993760 4291645271 4291449439 4291254116 4292771679 4293832570 4291450705 4291057758 4290789968 4291520871 4292109921 4292177784 4291452532 4291388776 4291456618 4290998409 4290728809 4288755808 4285272377 4284028230 4284945512 4284489553 4287256727 4286398571 4283957317 4284092992 4284158539 4284089415 4284160579 4288110478 4284882762 4283828550 4284225856 4286926205 4284818256 4284943686 4284882758 4285142107 4283829574 4285281635 4285998928 4284884561 4284419414 4284488261 4285938539 4283434812 4286268021 4285011268 4283107138 4283367485 4285881460 4288504991 4283629625 4290544774 4292706929 4289810270 4291060326 4292193185 4292578687 4292907398 4292517522 4292520083 4292588968 4292652964 4292326563 4292062118 4289105825 4288963436 4291602601 4292261039 4292132285 4292390810 4291336610 4291923587 4291530644 4292317568 4292771704 4292969864 4293036436 4293103734 4292973475 4292974238 4292975519 4293763190 4293238668 4293303687 4293240481 4293240979 4293181087 4293569437 4293571756 4293574563 4293574065 4293506725 4293838766 4293640372 4293838253 4293640102 4293838263 4293904816 4293904570 4293838777 4294036669 4294036669 4294036670 4293905072 4293572538 4293168767 4292111970 4290197834 4289278793 4286389065 4284028478 4283830860 4284287308 4283962692 4288101473 4287843683 4292780443 4292518813 4289022562 4285075767 4284291657 4285207874 4284685640 4285407818 4285144390 4285606736 4285342794 4284881987 4285604941 4285211722 4285929792 4285210441 4285276230 4284684349 4284618815 4284748599 4285539662 4285012547 4284225091 4283765060 4285076805 4288697463 4290934645 4291266171 4291132022 4290212212 4291199865 4292186245 4292188289 4292450710 4292054911 4292122238 4291661707 4292513919 4291924344 4291662456 4291464843 4291663229 4291857797 4291857028 4291462782 4291528566 4291462784 4291987841 4291528576 4291462525 4291396474 4290937222 4291134074 4290805372 4291004788 4290741889 4290545549 4291132786 4291134589 4291921801 4291199609 4291593852 4292119166 4292052873 4291725180 4291724416 4291528576 4291462267 4291856768 4292119680 4291987328 4291856259 4292511094 4291527794 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289676630 4289480793 4289742160 4289742166 4289546579 4289610324 4289349201 4289412946 4289480525 4289348688 4289151566 4289803847 4288823122 4290398542 4291451732 4292701790 4292838000 4293165947 4293430644 4293173383 4293630578 4293630339 4293370484 4293566084 4293498997 4293565564 4293565559 4293562495 4293299310 4292772206 4292439144 4290203987 4289280848 4287312715 4287441988 4287771998 4288822861 4289150799 4288825428 4289216336 4289481057 4289349205 4290070099 4289609296 4290005849 4290135893 4289941852 4289806418 4289806931 4289611350 4290136406 4289609810 4291055961 4290332757 4290792792 4290534238 4290468960 4291055961 4291384152 4291974486 4291385691 4290990670 4291122772 4291124312 4291055444 4291058519 4291322459 4291914343 4290992450 4292508775 4290857555 4291124568 4291123285 4292569440 4292376968 4292307561 4291131283 4290209423 4290079371 4289287544 4287773009 4285863503 4284359235 4286855547 4283960121 4283564095 4286797442 4285078875 4284219455 4285545329 4284422212 4284684363 4284023359 4284488255 4287054720 4284024891 4286727287 4287315557 4284552512 4284353609 4284751683 4284553289 4284219461 4286793826 4284615509 4287317611 4284028241 4284420676 4283369539 4285409112 4287387271 4284489301 4283238198 4283303991 4283502922 4288373409 4289556348 4293367926 4290401117 4290531677 4291861917 4292908413 4292972932 4292315786 4292645768 4292586131 4292588962 4292259749 4292391592 4291867570 4290812835 4288896389 4291602608 4292394406 4292784285 4291859861 4291858838 4291462022 4292314221 4292968583 4292773773 4292971652 4292971138 4292644516 4293367687 4293303432 4293303177 4293304458 4293303945 4293239455 4293633162 4293568413 4293571248 4293572268 4293573286 4293572787 4293574307 4293574321 4293508258 4293508271 4293706165 4293706151 4293838264 4293772458 4293904572 4294036915 4294036670 4294036669 4294036669 4294102979 4293509285 4293695612 4292636538 4291051601 4289676878 4286719815 4283833421 4284354107 4283567171 4284418878 4286925165 4287247703 4291928487 4292715687 4288364630 4285210435 4286130775 4284090440 4285210180 4285343051 4285866567 4285277258 4285932361 4285933129 4285474895 4285475919 4285408587 4285011257 4284422981 4285078340 4285406786 4285340224 4285276234 4284880182 4284221250 4284752463 4286727788 4289818745 4291331449 4291262314 4290736746 4291000198 4291068023 4292122768 4291859837 4291858293 4292121744 4292119943 4292121733 4292056718 4292120968 4291792266 4291992194 4292121998 4292119161 4292121999 4291792511 4291859083 4291857797 4291856502 4291528576 4291595398 4291593596 4290545538 4290805379 4290607991 4290808201 4291592826 4290413685 4290676621 4290739843 4290936437 4291134086 4290805359 4291331187 4291133560 4291462782 4291659905 4291397245 4291331453 4291856768 4292185217 4291790715 4292118387 4291790464 4291855222 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290136144 4290071379 4289676624 4289480794 4289807702 4289414737 4289612112 4289806413 4289610832 4289480537 4289151053 4288954450 4289347142 4289611096 4291519840 4292504154 4292442991 4293034601 4293236099 4293695864 4293172871 4293631096 4293566082 4293304693 4293763960 4293501313 4293566076 4293562231 4293429617 4293294195 4292834395 4290071900 4289215561 4287834958 4287967571 4288426566 4288165462 4288822093 4289150561 4288627790 4289678437 4289610320 4289742422 4289676886 4290071127 4290005848 4289939800 4289874777 4290726742 4289675859 4290266451 4290070614 4290268248 4290858585 4290071890 4291120472 4291451732 4291385435 4290402646 4291120992 4289875794 4291189342 4290005080 4290070360 4289678161 4290596442 4292835677 4291254604 4287704908 4290070624 4291123025 4290198607 4292965996 4291517291 4292701551 4290603410 4289159320 4289556620 4289619347 4288434527 4287378512 4283368516 4285542755 4285935967 4283434054 4282843192 4287784859 4285146964 4284750408 4286199665 4283697467 4285276746 4283895112 4284157506 4284682052 4287783323 4287649142 4285209411 4283960387 4284221754 4285145949 4284419142 4284287283 4287519132 4283433013 4285210460 4286331236 4284880981 4284882273 4283695153 4288906942 4285802066 4283106358 4283369779 4282713152 4286987352 4290807955 4290531166 4289415766 4291402411 4292978829 4292512637 4292578941 4292251266 4292120465 4292123035 4292654247 4292260273 4292194212 4292522913 4291405992 4290545559 4291537060 4292521123 4291794326 4291925915 4291593620 4292969589 4292971420 4292711570 4293298838 4293035147 4292645758 4293430411 4293303691 4293302923 4293301388 4292975263 4293238408 4293699214 4293238665 4293568671 4293570987 4293570206 4293573542 4293572789 4293573019 4293571499 4293573032 4293574308 4293508258 4293508015 4293838508 4293640116 4293772457 4293904572 4293838776 4294036669 4294036927 4293772200 4293508530 4293635985 4293098876 4290660175 4289479758 4288293448 4284551739 4283369285 4284092231 4284287033 4286789984 4286653512 4291926432 4293110952 4289157735 4285603418 4285734213 4284553275 4284684617 4285668675 4284751178 4285145158 4285539148 4285474124 4285803596 4286325317 4284949839 4284683837 4284552247 4284488517 4284552765 4285145671 4285405758 4284552516 4284158797 4285012044 4288433513 4290081925 4290871671 4290867060 4290867830 4291196264 4291725430 4292448649 4292383365 4292056720 4292119160 4292120200 4292120191 4292120711 4291791748 4291596664 4292120448 4292123028 4292055678 4292055687 4292449934 4291925627 4292119939 4291792261 4291856254 4291989126 4290873733 4290938754 4290939267 4291199100 4290545259 4291004548 4290805380 4290805370 4291462525 4290414218 4291002229 4291002499 4290936706 4290936697 4291199609 4291133815 4291461253 4292053888 4291988097 4291133818 4291659904 4292051571 4291396987 4292053122 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289611094 4290071385 4289611095 4290333008 4289348950 4289217365 4289807948 4289347662 4289413197 4289480531 4289348938 4289016394 4288888657 4290004556 4291124830 4292702313 4292641904 4293037433 4293365376 4292907911 4293695608 4293173385 4293566333 4293565307 4293501316 4293500545 4293565820 4293564792 4293495155 4292770145 4292306529 4291252561 4288953936 4287836744 4287376454 4288426057 4288822102 4288622930 4289348432 4289348693 4289610320 4289612901 4289546584 4289544784 4289481573 4289806417 4290136150 4290266194 4290202454 4290070614 4290070615 4290660432 4289808729 4290268754 4290728022 4291121494 4291058003 4291318865 4291582814 4291256668 4291975009 4291649114 4291972691 4291782238 4291384665 4291846489 4291921792 4287113289 4290402915 4292121211 4291862936 4290266706 4291320407 4291519632 4289488277 4289755798 4290011523 4290729820 4292110683 4290072428 4286387284 4284422980 4287523233 4285143630 4283107143 4282908731 4287589529 4286594165 4285014875 4283763513 4284358240 4284682825 4286068318 4285930337 4287915934 4286528868 4286131300 4284161349 4284548682 4284223803 4285540689 4283958857 4284749124 4286927746 4283695931 4284420420 4287848855 4285406034 4284156730 4286270858 4285542227 4283499571 4283700815 4282844222 4285606987 4291267971 4288825442 4287577179 4291922308 4292783250 4292512639 4292579719 4292580749 4292710530 4292054143 4291797919 4292653989 4292721072 4291604134 4292130216 4292455596 4291470227 4292063918 4291733153 4292254864 4292447095 4292445048 4293037725 4293103993 4293103245 4292646282 4293037964 4292971937 4293169810 4292975259 4293305758 4293304456 4293236875 4293632909 4293238921 4292908959 4293632390 4293569185 4293570204 4293570748 4293574806 4293573046 4293179297 4293571756 4293572775 4293574321 4293574062 4293442222 4293838509 4293838265 4293904815 4293838778 4294036926 4293838519 4293970621 4293839023 4293570968 4293033854 4291053906 4289674062 4288292935 4284157766 4284025911 4283896386 4283962699 4286328663 4286981970 4291200921 4293044131 4289883515 4286720077 4285211979 4285274951 4285540171 4285934424 4285605707 4285998153 4285081167 4285278540 4285867081 4285409102 4285734469 4284620103 4285144388 4284817995 4285208124 4285144133 4284816970 4284290368 4284026444 4285213005 4289357438 4290543223 4291328629 4290146935 4290077543 4291002745 4292184962 4292056192 4292383368 4292384383 4292055943 4292121998 4291725185 4291795087 4291792251 4291991423 4292119942 4292121213 4292450453 4292057219 4292055434 4292057234 4292123028 4291725954 4292186250 4291595377 4291987584 4291659648 4291330425 4290873477 4291461754 4290938756 4291133819 4291198581 4290085499 4290541940 4290871430 4291002487 4290805882 4290805110 4290805110 4290805893 4291133557 4290805369 4291396474 4291463040 4291986550 4291856000 4292119422 4291462524 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289740624 4289481050 4289742154 4289479246 4289613146 4289806160 4289742675 4289545289 4289543505 4289610831 4289544269 4288954192 4288954192 4289545046 4291320667 4292703851 4292837741 4293035132 4293365377 4293304694 4293564284 4293565562 4293566334 4293565306 4293501316 4293698424 4293500284 4293563768 4293101935 4292771424 4292768605 4291187548 4288626258 4287901522 4287443273 4287770696 4288230218 4289282639 4288496207 4289348428 4289677914 4289151569 4289544785 4289742944 4289677910 4290071641 4289808469 4289611350 4289611094 4290201686 4289545809 4290068560 4289874521 4290398038 4291187539 4290532693 4291054680 4291387230 4290924115 4291712855 4291582545 4290861398 4291322977 4291121484 4291123554 4291909976 4293110919 4292045904 4292699980 4293555017 4294883953 4292569443 4290729596 4288768140 4290343316 4291323524 4290664277 4291848546 4290929006 4285930819 4283699002 4285214332 4288113818 4284025662 4283566143 4283499075 4287326865 4287780755 4283761714 4283764291 4284551750 4283697477 4286197605 4287782267 4287054963 4286067549 4285473362 4284157760 4284091963 4284223298 4285342814 4284093770 4284886612 4286592612 4283564862 4284221756 4288048042 4284353611 4284090679 4287060099 4283630379 4284885106 4283765081 4284156731 4291070096 4292109418 4288425022 4290935179 4292853675 4292970877 4292516750 4292584597 4292713613 4291925128 4292052857 4292387738 4292653997 4292261281 4292325551 4292785829 4291013810 4292457129 4292326561 4292247405 4290333765 4291847793 4292639881 4291985276 4292838779 4292644505 4293235364 4293038717 4293433738 4293368205 4292976793 4293303945 4293238152 4293633935 4293566859 4293239711 4293698440 4293568673 4293567883 4293569186 4293570718 4293573291 4293571743 4293637549 4293573276 4293573291 4293573020 4293506984 4293706667 4293706154 4293706151 4293574324 4293904558 4294036927 4294102720 4293574320 4293706681 4293638034 4293300344 4291121495 4289080136 4286784330 4284876852 4284090696 4283830583 4284287043 4285277003 4285404486 4290479498 4293046698 4290476165 4286325832 4287313496 4284554823 4285935448 4285542992 4284751175 4284948557 4285735748 4285800264 4285737805 4285801543 4284421436 4284554052 4284620103 4285274684 4285078855 4285146959 4285011514 4283568463 4285275968 4287186548 4289687672 4291392114 4290674553 4290211958 4290935158 4291265660 4292119932 4292121472 4292056719 4292055169 4292056193 4292251009 4292123024 4292118398 4291990137 4291792268 4291990643 4291729041 4292054653 4292450437 4292057235 4292449420 4291859061 4292122496 4291726984 4292187019 4291857030 4291529595 4292054151 4290744184 4291396745 4290284924 4291133306 4290611075 4290479241 4291133302 4290805625 4290805635 4290805643 4291134339 4290870644 4290674050 4290476662 4291133560 4290348426 4291133557 4290934387 4291723386 4291396220 4291659636 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289546842 4289938002 4289743962 4289742423 4289347152 4289545300 4289545294 4289740627 4289938505 4289414995 4289085523 4289412944 4289082438 4289677144 4291779416 4292310121 4292506731 4292709226 4292972162 4292908940 4293631610 4293566336 4293566850 4293501316 4293500541 4293697906 4293500541 4293563000 4293495162 4292771422 4292570462 4290859089 4288691789 4287901512 4287375687 4289081179 4288232526 4288691542 4288757584 4289414247 4289217361 4290333014 4290071383 4290070374 4289676628 4289609294 4289742422 4289872467 4289742422 4289218134 4290134096 4290399834 4290268243 4290793814 4291121747 4291056733 4291842900 4290927447 4291646554 4290862432 4291648857 4292039519 4290662484 4292118930 4293905048 4292777579 4291652176 4283498551 4285073724 4285271874 4286976310 4290863978 4289293730 4289619083 4291062133 4291255640 4290726486 4291451737 4289216360 4284221760 4285675132 4286069600 4286667410 4282843185 4283500888 4284750938 4288444326 4286134626 4283564601 4284354373 4284490825 4286064990 4285935189 4285077568 4284356157 4285079629 4284485183 4284483145 4284421196 4284681794 4284490313 4284815939 4285737299 4284225104 4283957314 4285412965 4287193227 4284157247 4285278301 4287055991 4285279854 4283567422 4282975036 4288962407 4292581235 4288691032 4289943137 4292986811 4293236094 4292449410 4292583827 4292655261 4291925647 4292249476 4292116619 4292124816 4292654509 4292263099 4292263097 4292588725 4292984229 4292128911 4288103230 4287043898 4288428377 4290400867 4290072405 4291520626 4291784323 4292376689 4292113781 4292774292 4292842625 4293042077 4292975262 4293763447 4293240225 4293237903 4293633166 4293236875 4293237648 4293238407 4293174435 4293567098 4293568673 4293573545 4293574823 4293179298 4293572269 4293569949 4293571758 4293574566 4293508507 4293508260 4293508016 4293838241 4293904830 4293772213 4293970610 4293706669 4293639313 4293500823 4292904061 4290593608 4286848071 4285535040 4285142586 4284483897 4283828295 4284026683 4285798734 4286260063 4288768382 4293574052 4291133565 4286918224 4285340739 4285736275 4285801798 4285340999 4285608283 4285605193 4285410906 4286134618 4286265163 4285276236 4285668164 4284421180 4285341255 4284291652 4285603139 4285341512 4284226371 4284029513 4284818255 4288435575 4290410629 4290869621 4290737780 4290209907 4290540404 4291725437 4292448133 4292056199 4292120955 4292381567 4292121217 4291728011 4291922046 4292120436 4291792510 4291597695 4292119175 4292121719 4292121743 4291661192 4292121469 4292056462 4292121224 4292121486 4291790980 4291790710 4291922038 4291529863 4291528053 4291595399 4291659645 4291004806 4291790719 4290414211 4291198839 4290742670 4291265412 4291133816 4290742142 4291003014 4290674050 4291133302 4290348159 4290279809 4291133825 4290411125 4291068547 4290739830 4290998911 4291068279 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289740625 4289938259 4289479250 4289807958 4289546579 4289742423 4289740369 4289874520 4289742418 4289412946 4289544780 4288953936 4289086286 4290070091 4290928473 4292767850 4292575086 4293624942 4293629303 4293628288 4293565818 4293566336 4293501315 4293763958 4293500546 4293501317 4293564789 4293564786 4293297771 4292772467 4292372062 4290664287 4289282636 4287246672 4287510356 4287837255 4288364377 4288754759 4289149269 4289151567 4289283155 4289151571 4289546328 4290071383 4289415255 4290333794 4289217620 4289939798 4289479251 4289676630 4290006106 4290004048 4290595408 4290332759 4291186003 4291121995 4291058780 4291058263 4290927191 4291975512 4290861917 4291779423 4292039777 4294564528 4292380516 4289015872 4286455371 4283302967 4283697220 4283237962 4285144404 4290674579 4292523716 4292591282 4291974237 4289872465 4290138714 4288559435 4285007421 4284621389 4287186817 4286602386 4285473878 4283828295 4283565635 4286200942 4288646061 4285870956 4283564594 4285144400 4284680000 4284161093 4284945467 4284553803 4284686924 4285606486 4284091455 4283831110 4285474381 4284159299 4284421702 4285411423 4286264937 4285408590 4284944726 4285608560 4286859126 4285143900 4285741416 4284093263 4283106109 4282581044 4286792543 4293302917 4289479521 4289150294 4292655261 4292516997 4292910719 4292518293 4292523163 4292589735 4292249485 4291725690 4291724171 4292128679 4292196523 4292656822 4292656824 4292854962 4291140745 4288688457 4288887639 4289613936 4289744213 4289216595 4288953422 4289282130 4287771207 4288822362 4290401105 4290796383 4292966519 4292971653 4292975756 4292977052 4293700769 4293239710 4293631608 4293238409 4293698957 4293235342 4293632891 4293568420 4293567882 4293572526 4293572001 4293572001 4293568941 4293570464 4293574047 4293570984 4293573023 4293574065 4293508273 4293706143 4293838256 4293706410 4293773233 4293507993 4292973702 4292181874 4291188057 4288231239 4286128200 4285732160 4284681786 4284418363 4283960637 4284089418 4285211715 4286526316 4287318119 4293640119 4291658886 4289221493 4284947525 4285142597 4286329944 4284949832 4285342279 4284882764 4285867080 4286198091 4285211211 4285732922 4284552764 4284291404 4285078082 4285276743 4284423237 4285472073 4283766853 4284224582 4286722136 4288438902 4290934901 4291263604 4290542213 4290013044 4291200121 4292185734 4291991425 4292448386 4291595901 4292449158 4291660165 4292119669 4292120452 4292515196 4291726471 4291791997 4291792253 4292119668 4291332485 4292120442 4292120971 4291924854 4292121473 4292121225 4291990903 4291858046 4291528321 4291528319 4291925380 4291921780 4291529863 4291659390 4291595654 4291725182 4291005062 4290873215 4291398539 4290805636 4291528583 4290739833 4290541940 4290479755 4290673783 4291133826 4290476660 4290805635 4290280065 4290608502 4290345090 4290934644 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289676624 4289218658 4290137176 4289283414 4290003539 4289742423 4289481300 4290068043 4289676882 4289808211 4289085517 4289217357 4288886605 4289938510 4291386467 4292505693 4292837998 4292970109 4293234550 4293562497 4293566849 4293566337 4293566847 4293500543 4293763440 4293501315 4293567365 4293563516 4293431165 4293099097 4292766829 4290663252 4289017932 4287967056 4287441743 4287903062 4288363347 4288755541 4288891476 4289151056 4289677152 4289807957 4289480533 4289676629 4289742165 4289415256 4290071385 4290005849 4290136151 4290530382 4289675854 4290331470 4289808987 4290268242 4290727256 4290600290 4291122259 4291450970 4291254105 4291255393 4291388264 4290994012 4291518560 4294031229 4292054917 4287639624 4285732933 4284881214 4284090186 4285271358 4289354360 4291137451 4293894518 4294024031 4291581017 4287442505 4287310672 4286721105 4285143384 4285148249 4286596979 4288576431 4283105332 4283370327 4284687211 4287515784 4288512403 4285411939 4283761460 4284027714 4283630150 4285016146 4285676649 4285281375 4284093242 4285675623 4285013832 4284028986 4284948057 4284354869 4283960896 4283893572 4286526558 4287913626 4284352816 4286531719 4284492363 4285276772 4285478248 4283829053 4282976069 4285539662 4292119925 4290994018 4287969350 4292187805 4292648847 4292974988 4292452755 4292521363 4292919715 4292720546 4291659645 4292116620 4291862163 4292719781 4292654260 4292591801 4292462257 4292052343 4290661976 4292045669 4292903310 4292639868 4292510063 4291653496 4290993778 4289942883 4288692059 4286322751 4286587972 4286519875 4287509580 4289610832 4291786094 4293299342 4293500287 4293368718 4293304458 4292978087 4293304456 4293304714 4293171345 4293631860 4293569970 4293570473 4293572002 4293573273 4293568414 4293570204 4293567902 4293570208 4293572761 4293574312 4293574812 4293575084 4293903526 4293638043 4293432444 4291786351 4290466396 4290399055 4288034633 4287769159 4286453062 4285930052 4285138489 4284484916 4284353350 4283897157 4285012298 4285408334 4286529112 4293375146 4291334552 4289552998 4284290374 4284291401 4285735761 4286851655 4285738839 4285408587 4285801802 4285604423 4285078852 4284819283 4284948553 4284749365 4284227404 4285142332 4285540172 4284946752 4284619595 4284420670 4286528358 4290343034 4291329396 4290670975 4290472816 4290080630 4291725179 4292054149 4292712065 4292318339 4292447350 4291988604 4292119941 4292120701 4291725692 4291660935 4292513142 4292119933 4291791495 4292119167 4291792517 4292185477 4291397762 4291859082 4291725955 4292122752 4291792523 4291856255 4291529852 4291528576 4291921791 4291531404 4291528053 4291595399 4291593845 4291595654 4291659390 4291660930 4291397774 4291792257 4290545546 4291136388 4290610557 4291067510 4291133559 4290673784 4290151554 4290542196 4291199874 4290277746 4290016131 4290146420 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290726742 4290071384 4289676373 4289742422 4289546328 4289676623 4290003540 4289283665 4289874258 4289939021 4289478734 4289019729 4289019728 4289347663 4291385946 4292570972 4292836459 4293034105 4293693309 4293566587 4293565563 4293564789 4293566852 4293566080 4293501831 4293566851 4293565043 4293562755 4293692523 4292704099 4292375130 4290926165 4288690256 4287312457 4287379027 4288492616 4288297814 4288691535 4289280846 4289544786 4289217363 4289741908 4290072923 4289611093 4289676886 4289938259 4289479501 4289740625 4289479764 4289806932 4290202201 4289675854 4290398797 4290859099 4290726482 4290729047 4291189342 4290401628 4292040799 4290926939 4290796641 4291786611 4292767591 4291979108 4293562219 4290273876 4286259016 4284941872 4282976315 4283106367 4288894833 4291329149 4291909976 4287704650 4288892244 4286191168 4288103524 4287048025 4285013577 4286792838 4286599558 4285274679 4284024921 4284355917 4286335609 4287119238 4286338941 4287058300 4283170864 4283894092 4284294221 4286008178 4286063457 4284357181 4285483122 4285936730 4285675371 4283961150 4285537859 4283696966 4284288322 4283369532 4283959357 4286267252 4286924934 4286799768 4283695152 4287777935 4283896127 4283172676 4282777660 4290276982 4292646283 4289345609 4290873496 4293182117 4292709250 4292450960 4292915873 4292524721 4292855225 4291992460 4291983755 4291662471 4292191649 4292196283 4292265395 4292985011 4290930281 4290662741 4292898408 4292444540 4292970107 4292443511 4292835962 4293037717 4292905086 4292834425 4291190877 4290598506 4288756568 4288425032 4286653254 4286584389 4287373126 4288757327 4292376968 4292909182 4292972935 4293367949 4293298829 4293237903 4293697910 4293173413 4293570225 4293569945 4293571997 4293570220 4293568668 4293569947 4293573286 4293572769 4293568689 4293574561 4293764753 4293436554 4291982692 4290072656 4288362832 4287309634 4286196304 4287379026 4289286760 4289283680 4290137431 4289345607 4285993794 4285206326 4284224056 4283764551 4284685119 4286195291 4285937742 4292916928 4291856014 4290867322 4285668671 4284882506 4284817225 4285675085 4286197332 4286129222 4286131018 4285867594 4284947523 4284092981 4284555341 4284947266 4284814135 4285273655 4285211465 4285209668 4284356937 4285143640 4288432992 4290346631 4291132288 4290473072 4290079875 4290804074 4291659646 4292383363 4292710533 4291988346 4292054150 4292382598 4292119942 4291725184 4292119942 4292121475 4291726461 4292120711 4291790710 4291792519 4291856256 4291792251 4291924106 4291398019 4292186249 4291791484 4291662713 4291790720 4291858054 4291922049 4291463031 4291528320 4291989374 4291529597 4291595390 4291528062 4291529860 4291791759 4291595137 4291397773 4291529357 4291331461 4290936707 4290808204 4289888659 4291133302 4290608515 4290411392 4290214272 4290083202 4289951349 4289950839 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289676881 4289544273 4289546585 4289938001 4289481316 4290072666 4289480536 4289546586 4290068050 4289545290 4289742411 4288950859 4288954449 4289610828 4291385169 4292110690 4292903792 4292707182 4293234551 4293564540 4293566591 4293564015 4293566594 4293565559 4293566080 4293500544 4293566590 4293565827 4293494640 4292969584 4292767836 4290598238 4289412940 4287834705 4287968851 4288427091 4288232271 4288756812 4288823893 4289609809 4289610322 4289483365 4290005591 4290397523 4289611094 4289872724 4289938260 4289479765 4289806412 4289413968 4289872713 4289808729 4290070616 4290068300 4290859098 4290071122 4290726225 4291122266 4290924375 4291259246 4292840053 4292969598 4292507242 4292965997 4292773758 4289088613 4284549940 4286922600 4285541203 4281794624 4287912580 4291193463 4290406264 4288753487 4287642713 4288233564 4286455380 4284816713 4285607778 4287453067 4286201459 4283566947 4284094541 4286335606 4287914659 4284025156 4284886614 4289299384 4283696695 4283830603 4283765308 4286394214 4284947268 4283699790 4283959106 4285675121 4287715206 4285342790 4283762744 4283828532 4284551481 4284548934 4284484930 4284097361 4285808208 4288310683 4283435318 4285542751 4283499574 4282712110 4286595681 4292976001 4291518554 4290208378 4293378736 4292449658 4292908679 4292454548 4292915361 4292723381 4292064933 4291921544 4291528585 4292190353 4292196797 4293183923 4292787105 4289679430 4291384406 4292109937 4291585123 4292768635 4292702569 4291852677 4290332495 4292970350 4293102729 4292969600 4291320933 4292440671 4290460751 4289347664 4289477453 4288689481 4287378250 4288360529 4289676875 4292109436 4293367425 4292972410 4293365904 4293301133 4292841112 4293696118 4293567369 4293568673 4293571996 4293572513 4293569200 4293568412 4293571996 4293173917 4293305485 4293568406 4292444800 4289809752 4288097098 4288626013 4289548901 4289024355 4290995829 4291058793 4292441971 4291252035 4290594123 4289216336 4286192712 4286258762 4284288061 4284158535 4284287040 4286132048 4286653276 4293047199 4291661198 4290078583 4286655054 4284947268 4284422724 4286921303 4285143367 4286195270 4285671245 4285869645 4285144134 4284881730 4284685892 4284618300 4285144648 4285602886 4285670222 4285145933 4284882504 4285406797 4288634745 4290411382 4291394676 4289686903 4290209905 4291134331 4292580487 4292120690 4292319106 4292383883 4291989381 4292382583 4291858549 4292119160 4292447617 4291725942 4291790722 4292119424 4292119417 4291790968 4291790967 4292184705 4291332732 4292184695 4292120453 4291793539 4291791998 4292184952 4291858047 4291464052 4291922307 4291528567 4291528577 4291594112 4291529596 4292054661 4291529348 4291529603 4291529603 4291397774 4291659385 4291529103 4291005316 4291593594 4291200653 4290676593 4290085512 4290870655 4290477441 4290015616 4290279041 4290081921 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289545042 4289547365 4289807444 4289480535 4289547610 4289677655 4289546329 4289544782 4289808210 4289478734 4289086030 4289281867 4288951115 4289742930 4291583329 4292372834 4292444000 4293034860 4293430398 4293565557 4293500802 4293566594 4293565563 4293500802 4293500289 4293764986 4293500543 4293566070 4293101431 4292706159 4292703838 4291123294 4289083977 4287836233 4287376453 4287771982 4288887117 4288626000 4289545557 4288562257 4289677914 4290003025 4289676886 4289348179 4290071642 4289872718 4289545816 4290266962 4289346640 4290267732 4289872970 4289807178 4290266447 4290399317 4290397776 4291119956 4290072152 4291186772 4290990935 4292904818 4292904579 4292642674 4292509550 4292574316 4293625958 4292982166 4289032315 4291790729 4291656841 4287974243 4289558185 4291123541 4294019187 4289478744 4285474899 4285209924 4284029762 4285605730 4286657392 4288379831 4286460263 4286132069 4286065769 4287785895 4285738853 4282843196 4284157500 4288638610 4284686937 4284093767 4284093257 4286926715 4284486723 4283697986 4283762498 4285149031 4288243080 4286196830 4284155707 4284155962 4284483386 4284816959 4284549949 4284221507 4284221247 4284619849 4286727804 4283564076 4283041593 4284223798 4292582541 4290859610 4289679971 4292655271 4292582787 4292516238 4292451219 4292916638 4292591276 4292855224 4292716688 4291793306 4292057223 4292653222 4293316280 4291210382 4289608255 4290200143 4291513935 4290070349 4291054920 4290925643 4290990402 4290925646 4286251838 4289348685 4293167966 4291843670 4289544014 4290135895 4290331994 4291127161 4290792274 4290468198 4291051087 4290464852 4290527329 4291650655 4292769651 4292969884 4292837751 4293102215 4293693306 4293170574 4293569185 4293570201 4293570994 4293571495 4293571981 4293569200 4293571760 4293699741 4293040767 4291985029 4290991449 4289747561 4290270816 4290403675 4290862688 4288756040 4289018696 4290205007 4290003784 4287837520 4288229193 4288032842 4286259271 4286263888 4284289604 4283962431 4284094532 4286132316 4285670226 4292782240 4292120458 4290078327 4286989919 4284877113 4284881218 4285806426 4284949066 4285343053 4286262345 4285932619 4284486972 4284881728 4285076292 4285210183 4285144390 4285276233 4284619845 4284683844 4285211473 4286591574 4290015099 4291196544 4290343798 4290340712 4290602868 4291857014 4292054905 4292383111 4291987327 4292317046 4292381825 4291988097 4292447617 4292053634 4292053623 4292119172 4292120180 4291725442 4291725432 4292119426 4292119425 4291726973 4292184705 4291725941 4292120702 4292120444 4292119935 4291790969 4291462776 4291856516 4291922295 4291528578 4291528576 4291594111 4291659647 4290807941 4291660676 4291529348 4291923588 4291594881 4291465108 4290939266 4291396216 4291790977 4290873216 4290807949 4291133827 4290151552 4290605681 4290149250 4290082945 4289949824 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289610580 4289611858 4289547090 4289941861 4289939284 4289939542 4289544789 4289808204 4289151831 4289283146 4289283150 4288491851 4289081417 4289741385 4291124568 4292503652 4292902254 4293166706 4293627516 4293106819 4293764215 4293500545 4293498997 4293698425 4293698424 4293500287 4293566590 4293561980 4293037689 4293231468 4293031531 4291056723 4289281619 4287835976 4287376967 4288492361 4288165711 4289213770 4289217363 4289216594 4289610580 4289283671 4289872467 4290201943 4289741647 4289544013 4290398032 4289348682 4290462795 4289807434 4289412433 4290069069 4289742160 4289936977 4290660691 4288957276 4290599790 4290146446 4291983730 4292245347 4292446843 4292839281 4292643207 4292837758 4292969580 4293762156 4293956978 4293173639 4293499012 4291912543 4287047246 4286849600 4286192200 4283696957 4284692573 4284357213 4285278562 4286333814 4288245665 4286530412 4284682059 4287118982 4285937004 4287850635 4285342555 4283040823 4283631947 4285612649 4287057020 4283826244 4284421700 4287452540 4283829571 4283698236 4283894599 4284225850 4286662519 4287914640 4283172402 4284094016 4284552511 4284419135 4285141575 4284553529 4284748607 4283566135 4283896886 4284618344 4282646581 4289357164 4292840056 4288492883 4292254358 4292982164 4292514191 4292910475 4292849553 4292787377 4293182910 4293114036 4291604382 4292319115 4292586407 4293119172 4291469179 4288814906 4289083980 4289347660 4288951878 4289875021 4287176263 4286915911 4286980936 4286653004 4285138748 4286193733 4288687689 4285795650 4285272378 4286059586 4288624976 4291455586 4289477709 4292239990 4291191385 4291842656 4291975524 4291321440 4292439925 4292639861 4292968839 4292972151 4293296007 4293235340 4293567626 4293570991 4293571482 4293573544 4293572016 4293569418 4293634736 4293309353 4293298307 4292114806 4291061104 4291126362 4288494415 4287114313 4285534524 4285927743 4285602377 4286717256 4286585160 4286653767 4287704135 4287700039 4286984780 4285468215 4284551742 4283762500 4284617027 4287249256 4285273673 4292913567 4291664800 4289483877 4289024103 4284684612 4285076290 4286527564 4285211733 4286327881 4285211466 4285406018 4285078341 4284488517 4284684350 4284618813 4284947012 4285339966 4284424006 4283829061 4284685894 4288236653 4290738037 4291134596 4290477176 4289554539 4291132025 4291857026 4292448134 4292121720 4292383366 4292316032 4292186997 4292119161 4291659650 4292119415 4292448640 4292053615 4292053635 4292119415 4291922048 4292119417 4291790968 4291790712 4291792510 4291792255 4292119159 4291725959 4291725943 4292185209 4291397251 4292250734 4291397251 4291922295 4291922295 4291529862 4291594111 4291659647 4291595397 4291529603 4291921790 4291595139 4291398029 4291396998 4291134600 4290804854 4291136645 4291396228 4290479495 4290542466 4291134082 4290673781 4290345589 4290082945 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289610574 4289612123 4289610323 4289807951 4289610324 4289414743 4289610825 4289610833 4289872970 4289546312 4289018190 4289217618 4288555848 4289872980 4291386958 4292768365 4292442461 4292837485 4293497471 4293564021 4293500028 4293501317 4293500283 4293698940 4293500031 4293764215 4293500802 4293563772 4293496694 4293033305 4292177256 4291515986 4289281356 4287247695 4288032327 4288359495 4288230732 4288688715 4289283149 4289151821 4290004047 4290201938 4290136401 4289873493 4290265930 4290331729 4290004042 4289871185 4289216589 4290068564 4290069840 4289412945 4290263881 4289609295 4289677405 4291332770 4291204501 4292188027 4292115297 4292967278 4293164904 4292969597 4292771963 4292772445 4292904303 4292707697 4289742162 4291122264 4291789181 4287709026 4283957309 4283958852 4283237431 4283173973 4285676394 4286072947 4286922116 4287650706 4288840883 4285208150 4285473635 4287059856 4285608291 4288442789 4284752730 4283435851 4284291640 4286528620 4286005358 4284552516 4283700035 4287324286 4284288067 4283894855 4283959616 4283829335 4284291149 4288772512 4288306591 4284093247 4283893561 4284159546 4285141563 4285142324 4284090176 4283632699 4283503427 4282843187 4285411148 4292715411 4291056987 4290733435 4292987056 4292448126 4292517012 4292912526 4292785829 4293182387 4292657330 4292130210 4292652966 4292979092 4293382328 4290875748 4287371579 4287837514 4288031303 4287700809 4285599550 4286257737 4285536579 4285602628 4285664574 4285338171 4285929538 4285733187 4284552764 4284879926 4284419124 4284090164 4284743741 4286847040 4291124837 4292444545 4291845218 4291976812 4291910244 4292240496 4292374901 4292900971 4292771445 4293033348 4293101192 4293627003 4293568656 4293569946 4293572516 4293506995 4293508770 4293574826 4293310614 4293435784 4292245086 4288361038 4286652479 4285076543 4285793342 4285403455 4285601856 4285794363 4285206075 4285274173 4285669186 4285995848 4286389576 4286851655 4286590541 4284745526 4284551998 4283762764 4284287032 4286659945 4285270344 4292650397 4292650402 4288765551 4288824932 4286591830 4284027965 4285935963 4285671495 4285604423 4285737035 4285472836 4284617021 4284684350 4285274942 4284816194 4284882243 4285604940 4284226370 4283696201 4284748858 4288700539 4290937209 4291130472 4290146679 4291258992 4291068785 4292120183 4291988614 4292448125 4291594621 4292448391 4292053369 4292119408 4292119417 4291922047 4292052344 4292447866 4292382845 4292053891 4292119417 4292119407 4291725443 4292119424 4292119169 4292119933 4292119170 4291989619 4292120960 4291725177 4291922297 4291397241 4291922304 4291463041 4291528576 4291594111 4291594112 4291594112 4291594108 4291398032 4291595396 4290939012 4291725181 4291265404 4290216832 4291790717 4290805124 4290479472 4290150783 4290676352 4290084989 4290082945 4290148994 4290212992 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289282895 4289677646 4289480280 4289085265 4288957010 4289282901 4289544269 4289151565 4288953937 4289282894 4289147979 4288754764 4288165196 4289346379 4291120206 4292635990 4292443508 4293493610 4292841845 4293630333 4293500028 4293697907 4293699197 4293698684 4293698423 4293500291 4293764471 4293563263 4293230440 4293034350 4293097585 4290466131 4289347149 4287313225 4287375175 4288361546 4288754764 4288624974 4289083982 4288950858 4289413715 4289740620 4289611353 4290331471 4290331723 4289609806 4289479754 4290069070 4289545547 4289741390 4289741646 4290067018 4289149269 4289347407 4290743466 4292581767 4294500247 4293097824 4292177258 4292575328 4292444275 4292378221 4292969852 4293231227 4292314241 4291127675 4288039527 4284354121 4287251300 4287443541 4283565120 4283172928 4283106126 4286927751 4288507815 4287116146 4285609830 4288969909 4285737551 4287778956 4285739877 4286990984 4286662259 4288710588 4284422978 4283501654 4283633989 4286529392 4283564089 4286725511 4283830590 4287850153 4283960375 4283830847 4283893572 4283500604 4283631933 4285080664 4288444072 4288309924 4285672545 4282908720 4284352049 4285141822 4284814399 4283174217 4283303998 4283433012 4290741630 4291655276 4289479758 4292788659 4292910973 4292841612 4292716930 4292456086 4292851379 4292986294 4292459183 4292588206 4292588954 4292527542 4290943848 4287239744 4287503431 4287178824 4286385732 4285470016 4286190405 4285339708 4285276229 4285927229 4285206076 4285272628 4284352582 4285472841 4287316062 4287313233 4285403964 4284288562 4284484922 4284549180 4286845760 4291645277 4291719292 4291913321 4292501352 4291976806 4292437883 4292505440 4292835208 4292772980 4292968339 4293628794 4293175201 4293570219 4293508770 4293706419 4293640373 4293640619 4293635982 4291190367 4286652231 4285472585 4284618304 4285277003 4285535549 4286851141 4286717504 4285403709 4285471294 4285928770 4285801805 4285539144 4285537090 4287177802 4285730110 4285207094 4285141567 4283894583 4284029254 4286786394 4284616507 4292514956 4293044134 4289617770 4288106083 4285803592 4285736273 4285541458 4285736008 4285867851 4285406019 4284748855 4284487239 4284423237 4285208638 4284487742 4285602883 4285015116 4284292160 4284024394 4285145679 4289881203 4291659397 4290803573 4290080885 4291392381 4291922816 4292448391 4292382597 4291859066 4292119160 4292053623 4292119427 4292052348 4292448120 4291922303 4291791490 4291528309 4292119426 4292118130 4292119418 4292120192 4292119414 4292249729 4292119416 4291332734 4292184951 4291790978 4291725176 4292119673 4291790969 4291856770 4291856768 4291922295 4291528577 4291594112 4291396989 4291528059 4291398289 4291527800 4291659647 4291005061 4291462792 4290084988 4291724666 4290544766 4290676349 4290804864 4291002764 4290739584 4290476928 4290542978 4290345588 4290411394 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289151058 4289085266 4289546059 4289151059 4289216588 4289546066 4288953680 4289282893 4289085264 4288625741 4288758354 4287769157 4287705162 4289148488 4290664538 4292110180 4292901724 4292837486 4293693816 4293566077 4293500799 4293697908 4293498742 4293698423 4293501318 4293763440 4293501060 4293561969 4293694321 4292706405 4292504404 4291123552 4289542986 4287310919 4287375432 4288360007 4288689228 4289347147 4289215568 4289151821 4289283152 4289413198 4289545033 4289677133 4289216590 4289740876 4289741396 4289477968 4289806926 4289609544 4289083208 4288951883 4288751178 4292119937 4293838754 4293966228 4294231416 4291580745 4292703837 4292507249 4292836700 4293100911 4293233520 4290928223 4290867329 4289817463 4286915403 4286527830 4285930048 4283958329 4283500359 4283039801 4287525024 4288705195 4285409359 4283826222 4288443568 4284357954 4283962711 4286005886 4286924151 4286132333 4287590049 4288773025 4283898706 4283499319 4284096333 4286266735 4283698760 4285278036 4285146967 4288377760 4284489031 4284487751 4284554058 4284223286 4284222285 4283435077 4285674585 4288441497 4287190407 4287187071 4285208919 4284351547 4283763000 4283763007 4282712115 4287449703 4293172108 4288622656 4292122530 4293180581 4292842633 4292909195 4292518292 4292521361 4292591283 4293181880 4292657332 4292457381 4292986287 4291862662 4287042109 4288622407 4287114056 4286518856 4284747061 4285536831 4285206073 4285863235 4285205817 4285730116 4284550973 4285141588 4286585150 4287582327 4291276720 4291079361 4289485441 4285668164 4283891766 4284090163 4284022838 4286522697 4292239962 4292308838 4291649382 4292042594 4292700520 4292438907 4293161833 4292703882 4293361277 4293561981 4293568398 4293703851 4293838520 4293772214 4294235057 4293508502 4289939287 4284287291 4284553800 4284223303 4284621899 4285539410 4286525282 4288766855 4290411660 4288104285 4285204797 4284680502 4285600572 4285799747 4286192970 4285734468 4284812085 4286126148 4284422213 4284287807 4284616506 4286659171 4285466680 4291728280 4293046441 4289421427 4287382112 4285801027 4285472849 4286067285 4286329422 4285801290 4284816450 4285011527 4285010482 4285274431 4285143102 4285404727 4284817995 4284553792 4284291151 4283963971 4287905118 4290541689 4291656049 4291132022 4290606197 4291725435 4291595913 4292054899 4292054142 4292054910 4292054141 4292119428 4292053614 4292316288 4291856002 4291789938 4291592570 4292119673 4292316287 4291724413 4291922294 4292119424 4292118151 4291921793 4291725431 4292185217 4291725697 4291987581 4292119680 4292117380 4292119673 4291593845 4291922561 4291463041 4291725182 4291331453 4291725184 4290545799 4291593594 4290480014 4291593595 4291527545 4290674298 4291462791 4290346116 4290739576 4290805377 4290083202 4290082421 4290674037 4290542978 4289819765 4290475394 4289951092 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289085259 4289743451 4289480280 4289019214 4289019216 4289348944 4289085008 4288494413 4289150800 4288757585 4288293960 4287838029 4288359239 4289148489 4290662735 4292439659 4292900700 4292969326 4293431424 4293369967 4293566853 4293565308 4293566334 4293501831 4293499513 4293501832 4293565561 4293564286 4293297772 4292772197 4292504679 4291450194 4289281608 4287245383 4287967047 4288229450 4289214284 4288952910 4289151826 4289478739 4289610832 4289740877 4289479760 4290264144 4290069577 4289938519 4289675340 4289938762 4289543761 4289804878 4289542734 4289019214 4288751179 4293633670 4293372833 4294035852 4293293148 4290796897 4292112750 4292508252 4293099628 4293166702 4292442223 4287706470 4291851376 4290996084 4285999955 4287048534 4283040325 4283569741 4283829840 4285745272 4288113546 4285144663 4283367478 4286800026 4286463846 4282843203 4282780487 4286331248 4288574640 4287188357 4287585924 4287056247 4283633993 4283698244 4284162635 4285211719 4284154695 4283636044 4284221502 4287257978 4286268525 4284158530 4284683843 4284287814 4284552507 4284358212 4284028221 4284684864 4283697208 4285081161 4286467183 4284554314 4284220995 4282778418 4283762747 4292055177 4290927196 4289089904 4292987831 4292644981 4292516484 4292522905 4292584848 4292456363 4292986303 4292591033 4292853411 4293248697 4291930767 4286979643 4288886860 4288033870 4287043651 4285140796 4284614198 4284947524 4287510607 4285536829 4286063176 4285732939 4283236923 4285079104 4286921064 4286918739 4293245876 4293378746 4292065466 4290415257 4286455108 4285731902 4289152875 4287242819 4290992219 4292107369 4291778404 4292303715 4292043880 4292963174 4292574074 4292769638 4293363076 4293363590 4293566090 4293441971 4293904571 4294103481 4294234542 4291457377 4286059331 4284094787 4284552260 4284159296 4284093529 4286392382 4290615230 4288762976 4291601329 4291129462 4286916678 4285205819 4284156211 4285996102 4285405501 4285275205 4285470271 4285076287 4284748606 4283958328 4284685122 4287247709 4284153917 4292120197 4293111453 4289288831 4288103002 4286791520 4285933381 4286791000 4285670216 4286261066 4285276233 4284943934 4284814905 4284618814 4285015374 4284817482 4284554051 4284485961 4283897411 4285667922 4288697698 4290869369 4291593077 4291134329 4290472306 4291594109 4292119932 4292448383 4291987833 4292381815 4292449159 4291594093 4292579204 4291528308 4292119681 4292119683 4292119663 4292315525 4291461232 4291988087 4291987830 4291725443 4291987828 4291725688 4292185220 4291986552 4291789947 4291791223 4291856770 4291397505 4291856760 4291857017 4291658880 4291922561 4291922551 4291594113 4291528318 4291396473 4291462782 4291856510 4290676622 4290087557 4290739320 4290411125 4291133816 4290607989 4290279811 4290411381 4290214006 4290213251 4290278784 4290016884 4289624451 4289622660 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289414738 4289480273 4289348429 4288693331 4288627788 4289609805 4289151572 4289348429 4289346891 4288753995 4288296524 4287836234 4287835207 4288560459 4291253332 4292440154 4292115050 4293297517 4293628786 4293370743 4293565822 4293305465 4293565307 4293500286 4293698939 4293697911 4293501831 4293633413 4292969838 4292968290 4292570215 4291057743 4288888145 4287769671 4287770183 4288755276 4289082955 4289739850 4289283414 4289413196 4289479760 4289872720 4289872719 4289218386 4289545040 4289283660 4289939027 4289676877 4289611087 4289214541 4289347665 4289345612 4287634755 4290271584 4293046163 4293047670 4292919204 4292247678 4292310388 4292442475 4292968573 4292968813 4291982183 4290994801 4294023794 4288755020 4284683834 4285469266 4283304006 4284488279 4287320965 4287387268 4284481594 4283566910 4286334062 4286527065 4284685406 4283501645 4284681809 4285806184 4288707738 4286591865 4286932880 4287054721 4284751942 4283896398 4283766077 4284091209 4284354874 4284881227 4283304267 4284755796 4288443022 4285079638 4284552770 4284090166 4284549196 4284418876 4285014867 4284618052 4284156977 4284293962 4284029255 4283958841 4284621908 4286328949 4288895866 4292906096 4288885323 4292917421 4292981909 4293041274 4292652182 4292588191 4292521379 4292854965 4292985790 4292986029 4292920756 4292590745 4287246912 4290004565 4289149516 4286783558 4285600581 4284748599 4285533247 4287243333 4289746545 4287574602 4286789204 4288238448 4285272386 4285998151 4288435830 4284088363 4292656837 4292985012 4293444789 4292723129 4291393679 4287240508 4290993503 4290463827 4290329674 4291320922 4291447898 4291189604 4292501351 4292111993 4293225064 4292963446 4292967811 4293630330 4293502621 4293838776 4294038200 4294301632 4292387215 4288427331 4286979921 4285209150 4286724951 4284353341 4284750914 4286261061 4288300910 4287122540 4293046197 4291659913 4289738821 4285734474 4285008950 4285406016 4285598777 4285797955 4284880448 4285207096 4284753995 4284618308 4284552773 4287184499 4284284986 4291859101 4292519846 4290345603 4288424528 4287189371 4285799485 4286530407 4285210439 4285342795 4284686410 4285470008 4284816451 4285077563 4284814134 4284685895 4284419900 4284292163 4284423754 4286261838 4289817984 4291461995 4291391360 4290738293 4291066230 4291921266 4292448647 4291987840 4292644216 4291988097 4292053375 4292514183 4291528317 4291659647 4291791481 4292248693 4292315004 4291331187 4292185467 4291988095 4291920762 4292577906 4291462275 4292183933 4291594092 4291658362 4291988095 4291987331 4291592559 4291857017 4291659648 4291659637 4291922562 4291790709 4291134076 4291528318 4290217080 4291133829 4291134590 4291002490 4291790716 4290411395 4291133816 4290739840 4290411393 4290148995 4290082933 4289949571 4290017155 4289819508 4289492611 4289490819 4289163395 4290082419 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290003795 4289217363 4289743450 4289085265 4289807445 4289283151 4289414216 4288560209 4288689741 4288168785 4288885836 4288491079 4287180359 4289540939 4290662993 4292503640 4292965470 4292642934 4293628029 4293565313 4293501316 4293763704 4293501314 4293697907 4293700226 4293698682 4293500541 4293563777 4293495160 4293097566 4292243291 4291843929 4289413197 4288228166 4288360007 4288755020 4288559438 4289545038 4289414988 4289545041 4290135373 4290070605 4290266448 4290136402 4289611089 4290200913 4289808727 4289806414 4289545304 4290005325 4290004815 4288164170 4284809277 4288435534 4292259257 4285270077 4288498502 4294035106 4293834922 4292970091 4292771433 4292970357 4290663266 4287114821 4287506765 4284093503 4283303496 4283764043 4283502156 4286995088 4288044922 4284356698 4283564087 4286137468 4285935971 4284027472 4286534012 4284220493 4284160334 4287124364 4288440741 4285870697 4288908458 4286594164 4283700029 4283635271 4284816203 4284488007 4284227404 4284352576 4283369802 4285142343 4289167281 4285737561 4284484672 4284486728 4284026429 4284618808 4284949319 4284353592 4284155962 4284418879 4284091190 4283371334 4283367494 4284489529 4289293452 4287181389 4290210944 4292720289 4292050819 4290740859 4291464868 4292125089 4292525488 4293051839 4292264373 4292788662 4293117345 4289548133 4289676885 4291451996 4289809247 4289215053 4288689748 4286060612 4285729087 4288293712 4288891729 4290145404 4285601093 4286659676 4288170084 4287447648 4285597738 4288702635 4292924615 4293380031 4293445050 4293839547 4293174933 4288953184 4288885071 4291782245 4289802569 4291120722 4291055198 4292039266 4291452003 4292109158 4292963175 4292114553 4293693319 4293365379 4293505194 4293772725 4294102979 4293841587 4291979877 4288756053 4289815158 4285537082 4288762737 4287842913 4287903056 4287975023 4285269559 4290280354 4292978075 4292182412 4289284170 4286784072 4285402169 4285074999 4284483383 4285666622 4284748084 4285338938 4284353605 4284090435 4285341504 4287250531 4283957300 4291135887 4292523177 4291198854 4285999941 4287911275 4286196305 4287646558 4285275979 4286063170 4284618302 4284421176 4284422981 4285079108 4285144134 4285209926 4284554309 4284226627 4284879943 4286989929 4290670711 4291133306 4291265132 4290603634 4291002488 4291922562 4292120710 4292120444 4292055166 4292119169 4292119415 4292119425 4291594101 4292185476 4291789938 4291988097 4291791471 4291855743 4292052335 4291330431 4292185465 4291659898 4292512380 4292054392 4291985799 4291397497 4292185209 4292119673 4291791483 4291986554 4291857017 4291462525 4291789433 4291199859 4291528575 4291462782 4291264889 4291068282 4291462522 4291134084 4290542720 4290937477 4290673267 4290609038 4290345844 4290211700 4290016375 4289885303 4289687927 4289687414 4289360773 4289756540 4290939005 4291793288 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289546585 4289480278 4289217364 4289676360 4289480530 4289282900 4289415003 4288559951 4288693328 4288822608 4288295244 4287967047 4287375175 4288559182 4290204239 4291847527 4292509297 4293232241 4293628285 4293498747 4293699195 4293698168 4293500032 4293502089 4293699451 4293501319 4293763958 4293566332 4293298803 4292706674 4292570199 4291386199 4289086282 4288164941 4288229193 4288754764 4289148234 4289216336 4289740628 4289611340 4290530131 4290923087 4290005068 4290069585 4289874778 4290331987 4290070616 4290531663 4292044893 4288361285 4286388288 4285799751 4283893560 4283630393 4291731099 4290208893 4290685092 4293043858 4293970858 4294107604 4293837726 4290400076 4283959365 4283108423 4284091968 4283829067 4283959111 4283371842 4286860417 4287054944 4284945227 4284950111 4284620631 4286592878 4285214832 4284489022 4286198124 4285281125 4286133631 4287391119 4288638109 4286527872 4289367719 4286860676 4283435327 4284157258 4284687434 4284421704 4285409358 4284288834 4283567687 4284617535 4286665327 4285208145 4284225593 4284751943 4284419134 4284419391 4284554309 4285273150 4284157760 4283893822 4284419144 4283569744 4282977863 4289095300 4290141541 4287903832 4290753463 4291068292 4292121749 4292060050 4293047713 4292526521 4292985531 4292656817 4292854454 4292790438 4289414230 4289547350 4291256158 4291454048 4291781496 4291126109 4290401627 4289217617 4285858365 4286123070 4290072150 4290599780 4289291646 4286261842 4284617016 4285667914 4288110494 4292133055 4293576118 4293575348 4293771697 4293310895 4292972412 4291190119 4290853965 4292108643 4291119958 4291186259 4292174187 4291187035 4292171111 4292174950 4292375161 4292900967 4292575627 4293630581 4293638845 4294103488 4294103748 4293512367 4290333793 4289939550 4291001473 4290076816 4285868109 4287775836 4286990438 4286062406 4288765333 4291671737 4292842909 4292508555 4289869643 4286587720 4285730366 4285009212 4286385988 4285075766 4284681524 4284354107 4284419383 4284417603 4285870935 4286725214 4284089928 4291265694 4292979362 4291264900 4286193734 4287188084 4286788442 4286923618 4285537347 4285276234 4284618301 4285472322 4285275719 4284356931 4285737551 4285339967 4284552503 4284223044 4284355906 4288895087 4291003001 4291134328 4291129458 4290475906 4291725171 4291790711 4292119933 4292119943 4292119159 4292119426 4291659896 4292119681 4291594102 4291791216 4291921281 4291593591 4291855496 4291857016 4291593854 4292119166 4292052090 4291791481 4291920252 4292118396 4292119928 4291659638 4291462269 4291790717 4291988086 4291986554 4291659639 4291921267 4291397505 4291133817 4291002748 4291331196 4291199352 4291005317 4290542465 4291199867 4290476918 4290342770 4290871683 4290148212 4290015875 4290148214 4289425543 4289556341 4289687926 4289691008 4291004529 4292118917 4291793291 4292386195 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289610573 4289414743 4289414742 4289676117 4289019722 4289546072 4289283157 4289281098 4289414221 4288100945 4288427083 4287376967 4287375175 4288559182 4290858839 4292109658 4292903264 4292837229 4293234551 4293566332 4293698424 4293500805 4293698938 4293699451 4293501317 4293500802 4293501830 4293565314 4293430644 4293099872 4292240994 4291318092 4290070353 4288556872 4288820299 4288624974 4288954961 4289806413 4290596169 4289414227 4290529105 4290201940 4290267476 4290793306 4290923603 4289348176 4290987590 4289345864 4286392132 4284945477 4286725471 4286060876 4286595166 4289422720 4292520098 4290740627 4294021520 4293638561 4294967256 4294965695 4290869602 4284223309 4285873771 4283368518 4284157506 4282910535 4283763514 4286003566 4288042137 4286266487 4286465410 4285478247 4284221519 4285608554 4286268530 4286596492 4286463850 4287779457 4285737567 4287590565 4287584403 4285802065 4287856563 4287915677 4284421696 4284949583 4284354118 4283698744 4285275974 4284224073 4284746551 4284289603 4285736010 4284748357 4284948562 4285472072 4284487232 4284812350 4284356924 4284486726 4284091449 4283436346 4283238199 4283504206 4287054430 4292252037 4288228429 4291135879 4292653223 4292378992 4292650132 4292652700 4292525490 4292525237 4292330176 4292918948 4292655527 4289153095 4290663779 4292238714 4291319131 4292106598 4292243572 4292505973 4292374645 4290206060 4288164167 4288035148 4290069583 4291189099 4291589000 4290145938 4289879940 4290084764 4292459708 4292658617 4293181621 4294168511 4293773238 4293173651 4292634220 4293100654 4292240238 4290595922 4292309098 4291646558 4291578709 4292107874 4291715430 4292107878 4292108900 4293029238 4292969353 4293566090 4293641395 4294038725 4294104518 4293442473 4290069322 4289083208 4290142324 4291199367 4289292159 4287907454 4287909249 4289623731 4291147450 4292978098 4292058283 4292048242 4289476928 4286782023 4285536836 4285667648 4286057279 4286324554 4284489544 4284420412 4284753488 4285012288 4285804624 4286133086 4284092733 4289685104 4293112748 4291071129 4286656344 4287186289 4287251547 4287055961 4285606742 4284552249 4284554310 4284488516 4284748350 4284618814 4285669190 4284947780 4284554566 4284484416 4285343825 4288569967 4290936697 4290803317 4290804086 4291065715 4291725182 4292582033 4291660155 4292119169 4292120185 4291659896 4292577661 4291725697 4292053375 4292052858 4291266166 4292249468 4291987320 4291593844 4291860625 4291462527 4291265899 4292185476 4291790203 4291791480 4291790979 4292250745 4291200118 4292185465 4291987330 4292119424 4291133821 4292119672 4291199860 4291331197 4291396988 4291133817 4291330937 4290674041 4290542453 4290870902 4290936439 4290608759 4290344067 4289820022 4290541187 4289425270 4289753460 4290676611 4291658877 4291989112 4292581014 4292125058 4292651419 4292653192 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289742166 4289546322 4289611865 4289414736 4289480279 4289414482 4289546310 4289018190 4289149261 4288757326 4288363855 4287966279 4287244359 4289148235 4290728784 4292503911 4292835164 4293036403 4293495677 4293171580 4293566079 4293305207 4293698683 4293501318 4293502087 4293764215 4293501575 4293499765 4293627769 4292968301 4292637019 4291518812 4289740882 4289215566 4287445586 4289213770 4289542477 4289478224 4289873231 4291119697 4290792275 4290729052 4290728021 4291251539 4290596689 4291063409 4285074489 4284417090 4284418363 4285403965 4289156727 4290215056 4292251041 4292772486 4293041283 4293509315 4292780418 4294895022 4292187496 4285540151 4283302987 4283898682 4287585434 4282976575 4283305813 4285408863 4287455918 4289367741 4288111755 4286796158 4283236399 4283436106 4283564105 4286600089 4284353854 4287778439 4285874030 4285936487 4285871488 4287526816 4288509628 4284092753 4289109693 4288440477 4286531447 4285341509 4285213271 4283765317 4284486728 4284155696 4284353343 4284488523 4284554048 4284225609 4286063944 4284947267 4284881227 4284684348 4285016398 4284225086 4284156986 4283304256 4283173691 4284354120 4291989639 4290005586 4289484151 4293446844 4292580996 4292580496 4292585619 4292522913 4292657339 4292919733 4292527532 4292132268 4289280828 4291119964 4291322720 4291518305 4291519855 4291320921 4292572776 4292180616 4292441206 4293032293 4290996606 4290595163 4289281900 4289873751 4291450215 4292111455 4292380575 4292970646 4292513673 4292713371 4292915365 4293635995 4293042585 4293174953 4292250784 4292635773 4291714173 4292502641 4292240744 4291976289 4291844197 4291777891 4292108647 4292044410 4292105828 4292639609 4293624704 4293565322 4293639863 4294040263 4294169540 4292782750 4290996100 4289743719 4289940306 4291121785 4291657618 4291395988 4291659678 4292055977 4293042594 4291924889 4292442983 4290923596 4287770699 4285202485 4286326857 4286981192 4285865288 4286127432 4285471298 4284291146 4285081165 4284619079 4286397004 4286393942 4284353855 4289424782 4293175698 4291205789 4288038759 4287117645 4287189874 4285798720 4285670214 4285080145 4284550197 4284750410 4284091955 4284749113 4286061636 4284948037 4284484656 4284488262 4286593873 4290014589 4291003000 4291263606 4290144370 4291200122 4291922560 4291725700 4292184962 4291725432 4292119160 4292185219 4291331951 4291855484 4291857018 4291725174 4291067769 4291659647 4291987320 4291790978 4292185218 4291860110 4291658634 4292381296 4291790207 4292052866 4291791223 4291791233 4291659647 4291659638 4291528317 4291526510 4291463032 4291592312 4291331445 4291067767 4291067767 4291330937 4290542979 4290540145 4290608515 4290411650 4290610044 4290737011 4290016630 4290082167 4289622647 4290673528 4291728001 4292252048 4291796612 4292717469 4292128391 4292719242 4292981896 4293439119 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289482331 4290071384 4289741909 4289807701 4289612640 4289677646 4289609805 4289085264 4288626257 4288164427 4288361804 4288492106 4287897671 4288558668 4290400334 4291913831 4293294686 4292838767 4293497215 4293172338 4293566337 4293565822 4293698682 4293699197 4293699196 4293501832 4293698681 4293697913 4293561982 4293231210 4292571501 4291318609 4289348432 4288623435 4288752712 4289086290 4289479246 4290068557 4289545560 4290333780 4290074202 4291318353 4290597724 4290530898 4292109402 4289159764 4283760699 4284023612 4286458174 4289548155 4291662733 4292249999 4290936975 4292249738 4291522181 4291660173 4293638592 4289948522 4283106356 4283899488 4283766855 4283631967 4287321741 4287520666 4288041876 4287393177 4287122798 4284620106 4286534021 4284356685 4283108164 4283565125 4284291395 4287721128 4283237425 4286731655 4285937268 4285674346 4286135946 4287454087 4289236144 4286989708 4289305512 4286926983 4286923642 4285017690 4286925439 4283371328 4284420418 4283828553 4283962682 4284486717 4284420938 4284552515 4285011268 4284683070 4284682556 4285144901 4284552514 4284812089 4283566395 4283304250 4283105327 4288371034 4292444795 4288751935 4291863713 4292916640 4292514189 4292583826 4292587678 4292459442 4293445303 4293117866 4292329649 4289280570 4290004565 4291582047 4291714679 4291585636 4292111731 4291783033 4292834682 4292833909 4292376953 4292377207 4292571525 4291256156 4291914865 4291519091 4290399069 4291647839 4289539914 4290665566 4292701813 4291193697 4291849322 4290273135 4292313474 4292056988 4292648113 4292520873 4292976265 4292506995 4291844196 4292041831 4291648353 4291780964 4292237928 4292042854 4292501097 4292703609 4292638592 4293238689 4293703334 4294038725 4294106567 4293113262 4293368969 4292385449 4291596451 4291065464 4292642696 4292175212 4291320929 4292376182 4291262573 4289545046 4288754249 4287636809 4286975299 4285603650 4288298579 4287706185 4286389064 4286061125 4285406533 4284223804 4285672014 4284816455 4286067296 4285868098 4283370570 4289618811 4292714386 4291862684 4288764006 4285804636 4288695916 4285935180 4285932619 4284224827 4284554310 4285143098 4284685118 4285534010 4285409101 4284817224 4284684871 4286334557 4288760428 4290540919 4290935158 4290210419 4291195506 4291265917 4291856511 4292119943 4291725422 4292119417 4292513410 4291725432 4291723642 4291659647 4291462258 4291528060 4291397246 4291725182 4292053632 4292184951 4291792261 4291926670 4291462773 4291594112 4291725182 4291463032 4291856770 4291791232 4292185208 4291659639 4291528317 4291855473 4291133819 4291331445 4291199611 4290739576 4290805112 4290805111 4291265142 4290542980 4290476662 4289754485 4290540415 4289951618 4289885570 4290673529 4291332200 4292188551 4292320154 4292390516 4293110406 4292979589 4292980363 4293306751 4293046137 4292983964 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289872466 4289676373 4289547868 4289546329 4289480016 4289348437 4288430671 4289216592 4289213770 4288756559 4288359238 4287901511 4287310151 4288622665 4291119692 4292374362 4292443506 4293036147 4293431665 4293565315 4293566850 4293501059 4293501315 4293699198 4293831795 4293501576 4293700224 4293500027 4293629053 4292839282 4292964175 4291649367 4290201677 4287901769 4288755020 4289082443 4289283403 4290071108 4290070873 4290462539 4291384403 4290005337 4291251794 4290726232 4292107591 4290934127 4284153912 4285669437 4291786387 4291587700 4293042317 4291260025 4289950089 4290081947 4289948816 4292186240 4288368471 4284423245 4286133870 4285736540 4284290131 4284554322 4284223822 4288577188 4288442010 4285143393 4283632960 4287719586 4287059324 4283171381 4283829066 4284226138 4284291127 4287194792 4284096354 4286335338 4287191952 4283565639 4285609072 4287456158 4287848852 4287913120 4288773800 4286856567 4287454362 4288583609 4283827256 4283959098 4284552010 4284160839 4284750404 4284614461 4284421195 4284815932 4284485445 4284353341 4284753488 4284947264 4284484915 4283894076 4283304757 4283040831 4285144382 4291925653 4290396233 4289680491 4292526759 4292251005 4292582288 4292587924 4292523432 4293116602 4292527797 4292593066 4288624962 4289410382 4291775831 4291518819 4292112243 4292373364 4292441715 4292634998 4292375410 4292114567 4292573026 4292637319 4292180613 4292770440 4292508280 4292570741 4290728531 4291911531 4289676376 4291192951 4291129981 4290604174 4289941861 4290271096 4291134855 4292180620 4292381055 4292970380 4292376688 4291849336 4291842912 4291583073 4291583860 4291717244 4292237670 4292043112 4292106342 4292310900 4293098612 4293235081 4293506485 4294104261 4294106058 4292983209 4292776097 4292576621 4292508018 4292637556 4291783525 4290598009 4289484393 4289550709 4289613906 4287313001 4287374920 4286654792 4288626008 4287772494 4289543502 4287966026 4286256453 4285996103 4285466937 4284483897 4284750410 4284949324 4287315800 4285803081 4284288359 4289158000 4292977055 4291995040 4290210435 4285998931 4287780717 4286523977 4285406018 4284488516 4284619588 4284358732 4284484920 4285603911 4285734726 4284029507 4284685128 4286657871 4290275189 4290477689 4290935158 4290735731 4291066230 4291725173 4292120459 4292253305 4291790722 4291790977 4291725441 4292185208 4291594102 4292119167 4291856770 4291725182 4291594368 4291134076 4291526508 4291659638 4291528579 4291133552 4291659649 4292316536 4291134076 4291789433 4291725173 4291724674 4291659647 4291659637 4291790467 4291395964 4291199610 4291199601 4291132793 4291066732 4290870905 4290345336 4290606197 4290278004 4290343796 4290015875 4290870388 4290542456 4291529080 4291858308 4292387463 4292781703 4292849779 4292979081 4292916620 4292916629 4293243264 4292851849 4293045146 4293178760 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4290201686 4289480787 4289611858 4289938775 4288759374 4289808975 4289216080 4288101200 4288754507 4288887118 4287773008 4288032583 4287441479 4288032841 4290859603 4291781210 4292574046 4293034605 4293628280 4293564539 4293500544 4293698938 4293500804 4293699452 4293501576 4293699195 4293699453 4293500800 4293563524 4293165418 4293291097 4291386198 4289676621 4289081673 4288688713 4289148491 4288954193 4289740878 4289741648 4290267727 4290661722 4291254870 4290726487 4290857039 4290660950 4291987332 4289424762 4290935934 4291196312 4290142349 4290345627 4291730337 4289095529 4287313231 4285013834 4285869661 4286664827 4286855785 4284357956 4284483910 4283306555 4284093263 4283171924 4284822105 4289499832 4288183486 4287388572 4289496245 4287055498 4286995873 4285015122 4284556637 4283105347 4287124346 4285210475 4285674592 4287654063 4285212503 4284559735 4287585420 4287058323 4288970158 4288771762 4288247468 4288713136 4284421184 4283039806 4284556878 4284292419 4284353846 4284424011 4284620357 4284616253 4284095813 4285142339 4284750140 4284555853 4284226629 4284486203 4283566388 4283304245 4283170872 4290410615 4292377712 4289018190 4291593351 4292385932 4292187023 4292586140 4292519329 4292722612 4292527549 4292987049 4288693052 4289013318 4290660436 4291646551 4291781739 4292175476 4292045189 4292771958 4292768115 4292115851 4292770675 4292903561 4292310898 4292571490 4292507237 4292838524 4292046212 4292638841 4292571494 4291979638 4292111216 4292111476 4292047477 4291652465 4292314257 4292380817 4292380560 4292576135 4292114043 4292444049 4291856273 4291582563 4291975524 4292242039 4292372833 4292042600 4292043368 4292301670 4292634230 4292706452 4293559931 4293506997 4293905596 4294040777 4293968570 4292320922 4292579454 4292576392 4292243588 4291913590 4291518830 4291915126 4291124846 4292109439 4291059547 4288757844 4288951113 4288823122 4289938761 4288626510 4289016905 4286059589 4286651978 4284812087 4284550708 4285338936 4285405762 4286067532 4285672294 4284286009 4288764799 4292383115 4292457653 4290410110 4286326609 4287776618 4286062404 4284355911 4285078340 4284552246 4284616255 4284353842 4286461009 4285078076 4284550978 4284550201 4287775589 4290149243 4290803318 4290801267 4290078835 4291397493 4292184951 4292122252 4292118902 4291725441 4292185208 4291791223 4291593090 4292119167 4291200117 4292119167 4291659127 4291527303 4291528568 4291857283 4291725184 4291723886 4291725441 4292117871 4291265920 4291462773 4291725439 4291396991 4291396980 4291397247 4292052862 4291068015 4291396990 4290673783 4291330939 4290805112 4290411384 4290936696 4290608504 4290408821 4290346360 4290540147 4290212481 4290216579 4291989120 4292386201 4292455796 4292652683 4293110935 4292916373 4293179020 4293245829 4292850313 4293638535 4292850573 4292981372 4293178509 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289348949 4289611865 4289545815 4288759380 4288758866 4289150543 4288691536 4288296269 4288820299 4287773522 4288032841 4287507271 4287043143 4288753994 4290463052 4292242005 4292573296 4292904564 4293300605 4293237889 4293566851 4293698938 4293698683 4293699197 4293501831 4293700222 4293500546 4293567105 4293627255 4292969581 4292506992 4292043854 4290200913 4289079878 4288097094 4288624972 4289217357 4289806926 4289741643 4290923344 4290726991 4290529870 4291185742 4290792536 4290265681 4292437342 4292119678 4292377995 4292843668 4293174677 4291917680 4289418850 4287048553 4285478507 4285148242 4286332004 4287646579 4285278543 4283501894 4283763524 4284884328 4284421462 4284423250 4284027491 4285080412 4288844471 4288776372 4288377508 4288510642 4287194002 4284882004 4284554325 4283369030 4285477480 4286333550 4285078885 4287454597 4288242602 4286466942 4285279066 4285606227 4287324573 4287256966 4289564600 4286861185 4286530931 4286593127 4285409620 4284613698 4284291142 4284487997 4284813887 4284553278 4284815676 4285143884 4284554307 4284813628 4284551997 4283697976 4283698507 4282777654 4286527565 4292514950 4290793557 4290073178 4292985264 4292972673 4292976524 4292455833 4292656563 4292986033 4293449656 4289153848 4288162891 4290461004 4291123290 4291909735 4292237157 4292506741 4292834419 4292508807 4292706934 4292509830 4292640886 4292771716 4292837251 4292967559 4292642431 4292442724 4292833651 4292310902 4292311159 4292963681 4292376695 4292572798 4292575106 4292576391 4292905357 4292643497 4292841864 4292970126 4292448930 4292973710 4292507506 4291650165 4292174692 4292242803 4292503436 4292109924 4292367464 4292371048 4291779682 4293424003 4292908188 4293572787 4294102717 4294104262 4293510583 4293111213 4292387235 4293036181 4292774528 4292443254 4292113510 4292636788 4291781237 4291716448 4291386462 4290399319 4290465110 4289348951 4289941597 4289939025 4288690252 4287174983 4286457929 4284745782 4285338688 4285406277 4284816197 4286130760 4285672273 4284355923 4288239730 4292908677 4292585635 4290344847 4286328651 4286984527 4284818762 4285733180 4285537604 4284555854 4284161349 4285012027 4285999437 4284814395 4284156994 4284421433 4288367461 4290083963 4291326835 4290344310 4290144114 4291134073 4292185991 4292118900 4292120199 4292184960 4291134077 4292251010 4291791223 4291857026 4291724153 4291723896 4291659138 4291922551 4291659639 4292248182 4291462770 4291527297 4291528059 4291331446 4291856511 4291134076 4291987067 4291397247 4291659906 4291265661 4291132266 4291396992 4291133809 4291133560 4290739576 4290608497 4291134084 4290934388 4290606197 4290608504 4289425015 4290148219 4291069056 4292188029 4292715650 4292653711 4292981129 4292983711 4293574014 4293114503 4293506431 4293178766 4292720288 4292849543 4293179021 4293570693 4293309569 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289807958 4289414743 4289151051 4289348173 4288822861 4288691536 4288755789 4287642450 4288885835 4287837515 4287443786 4287764551 4285340488 4287833926 4290071119 4292110944 4292573278 4292970358 4293102461 4293237114 4293566333 4293500801 4293698682 4293699197 4293501831 4293501831 4293567879 4293566590 4293561720 4293166960 4292964688 4291583576 4289544778 4288556105 4288755277 4289082956 4289413201 4289084753 4290135879 4289938515 4290725966 4291252053 4290529358 4291185741 4290596441 4290923858 4292310392 4292383379 4292445825 4290335599 4289486705 4288435577 4284685649 4284488520 4287054703 4287649671 4286265435 4284554586 4283434824 4283831366 4286205313 4284357437 4285935714 4285936228 4287387276 4287188869 4285941637 4285873774 4286797181 4285805156 4284223294 4283828547 4283567932 4284620374 4285872260 4285082706 4283896918 4287656357 4288703665 4287255449 4287586726 4287386003 4286137720 4287061650 4284224585 4287651219 4284226633 4284553535 4284225092 4284551741 4284029246 4284486712 4284682566 4284223043 4284621642 4284225102 4284292160 4284226637 4283830595 4283369787 4283762486 4291003783 4291784293 4289016650 4292119435 4292649874 4292520340 4292456862 4292852150 4293182645 4293450686 4289552981 4287043651 4289871178 4290858582 4291448412 4291582292 4291914615 4292109684 4292375668 4292510343 4292837509 4292837251 4292773000 4293035915 4292905880 4292907143 4292970385 4293100188 4292377984 4292903813 4292839841 4292967825 4292644482 4292839331 4292843166 4293104795 4292907415 4293104773 4293039007 4292905364 4292843144 4292906633 4292177284 4292173920 4292177015 4292833656 4292374114 4292696171 4292107111 4291977575 4292630375 4292770182 4293363590 4293175223 4294102973 4294042061 4293837747 4292654766 4292849062 4292842634 4292250500 4292969354 4292575879 4292442488 4292372066 4291912290 4291913336 4291714652 4291121750 4290732393 4291384409 4289810010 4289674052 4286325576 4287046729 4285074235 4285404735 4285470269 4286194760 4286656853 4285739092 4283829822 4288369521 4292318612 4292392124 4290214522 4287116382 4286529379 4286197579 4285012288 4285143613 4284422462 4284221497 4284749113 4285734984 4284289842 4284355403 4284684870 4289356915 4291130228 4291064173 4290344055 4290606197 4291725179 4291790719 4292120967 4291725183 4291726973 4292644993 4291330174 4291857017 4291658361 4291724153 4291331711 4291725181 4291528834 4291723897 4291266175 4291725183 4291922552 4291790976 4291593852 4291331445 4291462783 4291593088 4291265394 4291528319 4291133817 4291199611 4291002232 4291199602 4291133304 4291133560 4291264889 4290148727 4290082936 4290410872 4289819255 4289884279 4291399306 4292057985 4293373588 4292523664 4293245574 4293508225 4293507968 4293048712 4293112454 4293310330 4293113988 4293177227 4293179792 4293047162 4292785546 4293178767 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289415000 4289609803 4289019729 4288756042 4288363854 4288166737 4288886603 4288359237 4288295756 4288558924 4287506759 4287111240 4286717512 4287242310 4290201168 4291649880 4292967020 4292837740 4293562230 4293237127 4293566080 4293764473 4293501319 4293700224 4293698941 4293699451 4293502088 4293565816 4293629305 4292967788 4292507730 4291846483 4289544267 4288624460 4288688713 4289278790 4289084748 4290004298 4290463312 4290333268 4290730074 4290596184 4291187033 4290726229 4291186258 4290339704 4290863222 4290602621 4288956530 4289942633 4289217894 4285668190 4286466177 4287384703 4288175761 4285607779 4284158530 4285079125 4283568456 4285012561 4286597259 4286064747 4286795412 4287982251 4288113807 4286987895 4283765060 4285544037 4287915170 4284950093 4283041859 4283895371 4285210726 4284423259 4286859889 4286597247 4284159086 4283305533 4288971954 4288780477 4288048279 4285144664 4286070642 4286068845 4289574613 4285413219 4283237440 4284225606 4284619843 4284422468 4284882759 4284223037 4284486718 4284289348 4284487752 4284752457 4284356948 4284097093 4283505234 4282583888 4287843438 4292776303 4289804365 4289679979 4292585884 4292518032 4292522399 4292916652 4292984755 4293515461 4290413407 4285468223 4290390598 4290202453 4292103517 4291842915 4292369508 4291847266 4292308084 4292374132 4292902249 4292772230 4292969089 4293035917 4293366157 4293367180 4293362826 4292775831 4293763190 4292974749 4292711583 4293103240 4292646540 4293103762 4293041818 4292713109 4293040027 4293039758 4293036937 4293041310 4293102986 4292972688 4292445322 4292439406 4292176503 4292967530 4292309109 4292439398 4291911527 4292370536 4291911783 4292630631 4292572037 4293235589 4292849337 4293970360 4294039494 4293971131 4292980654 4293174684 4292778922 4292971399 4292840061 4292509317 4292379512 4292243335 4292373876 4291716213 4292040539 4291583608 4291057496 4291187801 4289480792 4289151828 4287567430 4286389577 4285273661 4285602110 4285209668 4286130249 4286654280 4285080133 4283499347 4288301668 4292122273 4293243559 4291267216 4286590804 4286066251 4286391373 4284616511 4285669957 4283700536 4284812610 4285404472 4285211464 4283894841 4284549179 4286786129 4289751145 4290803575 4290738295 4290341234 4291263350 4291464582 4292186503 4291725173 4292119426 4292119415 4291528318 4291725182 4291857017 4291921276 4291462524 4291528058 4291988354 4291001976 4291988344 4291528577 4291725183 4291790966 4291068017 4291199869 4292052605 4291199868 4291265651 4291199354 4290611074 4291462524 4291331454 4291395438 4291133561 4291002747 4290805369 4290804076 4290082937 4290671221 4289622648 4290081654 4291137153 4292191367 4293110918 4292655265 4293575063 4293377415 4293705107 4293048453 4293507468 4293112454 4293114759 4293177229 4293309566 4293178244 4292785039 4293637511 4293113221 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289412684 4288430672 4289150287 4289216592 4288755789 4288887117 4287706190 4288426057 4288557129 4287377738 4287636551 4287176776 4287176007 4287835978 4289610313 4292372829 4292506476 4293296489 4293234558 4293236351 4293566851 4293501574 4293501055 4293697912 4293832052 4293435527 4293700479 4293500284 4293562738 4293166959 4292964704 4291583580 4290005066 4288556873 4288163914 4289148748 4289215819 4289348174 4290003027 4290070097 4290858066 4290661977 4290661203 4290664022 4290793319 4291582049 4289810560 4288824943 4290801826 4291135135 4288766894 4289433030 4289699772 4289696188 4287320700 4284818271 4284818506 4284357208 4285078357 4285083222 4288440993 4285541214 4288183215 4287716483 4287781798 4286134380 4285805177 4289037493 4286857074 4283237951 4283239499 4283567694 4284027715 4285147748 4287715483 4288969379 4286465669 4285280866 4285212262 4285809261 4288509618 4286661783 4288373165 4288785870 4288048003 4284683342 4285213011 4285144901 4284618311 4284683586 4284619596 4284685389 4284093501 4284550205 4284357699 4283964750 4284227395 4284028230 4283044435 4284418872 4292054648 4291716186 4288953937 4291598483 4292648600 4293307546 4292523681 4292458409 4293315248 4291603076 4285072958 4287965255 4289347404 4290988625 4291449430 4291714655 4291518057 4292107621 4292309895 4292767606 4292573303 4293359745 4292903059 4293034880 4292969866 4292974996 4293167231 4292972693 4293236110 4293765000 4292974237 4292972957 4293366407 4293102230 4293763699 4292973985 4292975501 4293037982 4293040797 4293039515 4292777876 4292577390 4292771703 4292113030 4292636512 4292311927 4292371321 4292896871 4291977063 4291977063 4292960619 4291910245 4293028472 4292837255 4293702054 4293772725 4294038982 4294103233 4293309608 4292323996 4292845971 4292842892 4292445857 4292509572 4292771195 4292638049 4292242552 4292174436 4291913316 4292170853 4291452258 4291057755 4290925660 4288888393 4288161096 4285863237 4285141579 4285338684 4285866052 4285665597 4286527319 4286390086 4283564100 4287710042 4292777893 4292785052 4291530148 4287117138 4285540683 4285734982 4284353342 4285538885 4284422719 4284486969 4285013574 4284423237 4284812094 4284684610 4287643733 4290668663 4291266426 4290734962 4290083449 4291265659 4292251270 4291726451 4292120965 4292119415 4292119426 4291856759 4291659646 4291723896 4291462523 4292119166 4291528577 4291593594 4291396990 4291725182 4291725182 4291725173 4291592832 4291265395 4291528567 4291593843 4291265405 4291331188 4291133817 4291330681 4290279799 4291133559 4291133560 4290411384 4290868597 4291000182 4290082936 4290409077 4289754743 4290213753 4291005302 4292844694 4292980617 4293180038 4293116032 4293575308 4293770883 4292984961 4293311387 4293245296 4293309818 4293113229 4292785044 4293374338 4293112709 4293440888 4292784008 4292983451 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289085264 4289413196 4288760660 4288756815 4288230733 4288363857 4287902798 4287904079 4287378252 4287574602 4287046986 4286784071 4286061128 4287967046 4289609808 4291845968 4292245350 4292904819 4293693303 4293237890 4293370228 4293764730 4293500803 4293698682 4293633663 4293698682 4293698682 4293500283 4293561984 4293428330 4292572769 4291515733 4289544778 4289149005 4288097094 4289148748 4288954450 4289609543 4290069069 4289674059 4290070109 4291316037 4290597497 4290470537 4290475683 4290414249 4289368257 4289958849 4291468214 4290948796 4288579485 4287916416 4286927992 4286266978 4285540180 4285013334 4285212756 4286134120 4285013594 4286594427 4286994314 4286263921 4288113564 4287389596 4286396265 4287784090 4288770723 4287515259 4284224574 4283041866 4284288066 4283697466 4284490316 4283831645 4284355651 4286532993 4287518104 4287653793 4288113051 4286599584 4285738851 4289041839 4289180349 4288241294 4284883535 4288900746 4288958062 4287116883 4287316568 4283237956 4284094523 4284882758 4284353859 4283964231 4284421186 4283832653 4284419657 4283175248 4283239744 4288042607 4293170551 4288755801 4289942117 4292982197 4292583053 4292458658 4292457127 4293183164 4292988844 4284880433 4286714181 4288884807 4289869902 4291122009 4291384415 4291843941 4292303720 4292042598 4292109941 4292964453 4292573306 4292772231 4292968562 4293035138 4292775064 4293365131 4292909476 4293760887 4293237642 4293304223 4292975257 4293305226 4293697676 4292977049 4292973473 4293367431 4293168788 4292977048 4292976536 4293436038 4292644237 4293362072 4292640887 4292771451 4292308080 4292572044 4292572770 4292177527 4292106086 4292175464 4291976033 4292826219 4292437347 4293035143 4293240743 4293836984 4294040006 4294103747 4293178794 4293108887 4292844177 4292385947 4293101442 4292445548 4292767861 4292112263 4292504674 4292308854 4292043896 4292108391 4291518818 4291450465 4291188563 4290137172 4286915139 4285931593 4284945727 4285077063 4286194248 4285409099 4287181388 4285142600 4283237440 4287313245 4292385424 4292845986 4291270040 4288105050 4285341509 4285272382 4284024883 4286195525 4283827779 4285077816 4285603397 4284682808 4284487750 4284486205 4289550188 4290346619 4291065193 4290278776 4291127150 4291923074 4292121474 4291725694 4292184705 4291397239 4291856769 4291659646 4291856768 4291659646 4291922816 4291855482 4291790974 4291134075 4292053889 4291331452 4291790209 4291594105 4291396991 4291725699 4290936956 4291331196 4291134591 4291199353 4291134599 4291199608 4290936954 4291133559 4291133816 4290673528 4291002489 4290212971 4290344581 4290148726 4290145918 4291528579 4292124031 4292849820 4292982139 4293837718 4293771928 4293770881 4293706391 4293639570 4293048198 4293508227 4293047695 4293570436 4293377135 4293176453 4292983711 4293179011 4293179276 4293311379 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288757071 4288102222 4289218660 4288232014 4288362318 4288361547 4287771980 4288556873 4288033098 4287574087 4287767879 4286783048 4286257991 4287308617 4290466389 4291846745 4292245093 4292772979 4293299313 4293236354 4293566337 4293500285 4293501574 4293501319 4293699453 4293698425 4293501318 4293566847 4293627505 4292839284 4292637003 4291517533 4289808980 4289079622 4288752711 4289083212 4289018702 4289673550 4289740109 4290201454 4290662250 4290148009 4291730093 4291462047 4291463849 4290999693 4291195264 4292116091 4291000719 4286133070 4283895366 4284094041 4286793841 4284819560 4284357975 4285738589 4285606492 4285277024 4285473625 4287059841 4287317383 4285479268 4287655081 4285740647 4288116401 4289035689 4287189638 4284819538 4283963459 4284490318 4283633992 4283895119 4284025923 4283831114 4284093784 4284820060 4286069368 4285805415 4288311973 4289757101 4288512432 4285215068 4282844214 4282843205 4285805915 4291004295 4290212466 4288698467 4287575912 4283635790 4284620613 4284291651 4284161097 4284225862 4284029254 4283766087 4283571273 4283567695 4283765314 4292383629 4290469986 4289743964 4291527562 4292718487 4292522904 4292851381 4293379239 4293583297 4286394942 4284284979 4286782535 4288752455 4289873225 4291644504 4291712597 4291976547 4291910502 4292042343 4292701816 4292440161 4293227143 4292576119 4292967033 4292836755 4293627011 4293235834 4293303946 4293236111 4293237389 4293305499 4293302685 4293302667 4293238666 4293369479 4293371292 4292976539 4293370247 4293367945 4292977049 4292974240 4293105534 4292907148 4292640632 4292441443 4292509580 4292900966 4292638075 4292896121 4292633705 4292176744 4293220709 4292370537 4292111734 4293293440 4293238189 4293838773 4294038469 4294103746 4293377464 4292650386 4292775829 4293234834 4292383118 4292904850 4292444777 4292767351 4292175458 4292567930 4291977060 4292108389 4291649656 4291844958 4291125600 4289476943 4287046727 4286586697 4284944701 4285866051 4286131019 4285997127 4287051084 4285010752 4283764297 4286719063 4292122269 4292781728 4292515462 4289093756 4285078336 4285209151 4284027188 4286193735 4284354360 4285209663 4285144648 4284683321 4284483901 4286522957 4289683557 4290806139 4291195509 4290212202 4291195766 4292185463 4292120454 4292119932 4291792253 4291856513 4291856769 4291397238 4292250754 4291462266 4291527302 4291331709 4291331454 4291856510 4291134074 4291593094 4291594369 4291396981 4291462775 4290936182 4291396733 4291396732 4291068285 4290870896 4291462524 4291199610 4291330938 4290805111 4290411384 4291000181 4290411128 4290410873 4290211700 4289885047 4291003776 4292451204 4292718733 4293246085 4293048455 4293772183 4293376383 4292984707 4293573778 4293376642 4293507969 4293048456 4293179781 4292982686 4293177730 4292786059 4293572999 4293113987 4292916889 4293509268 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288821589 4288296278 4288365134 4288427598 4287770955 4288492105 4288493900 4287967305 4287508295 4287112520 4286655560 4286914120 4286257735 4287441994 4289283148 4291453276 4292706417 4292772719 4293366393 4293237115 4293566336 4293501313 4293698163 4293697912 4293698426 4293502859 4293568135 4293564282 4293563001 4293165673 4292769399 4291582539 4289018696 4288033354 4288164938 4289279563 4289018702 4289150544 4290790988 4290081156 4291133055 4291190368 4290924116 4291122782 4289819014 4289357720 4289622685 4289089909 4286133336 4285208930 4285477475 4287317871 4285940854 4285210696 4285736802 4284423769 4285148755 4285080914 4286598527 4286070920 4285675378 4288047259 4287584412 4288513221 4289165459 4288509857 4284617526 4283895622 4284686944 4284683327 4284354114 4284423498 4284422734 4284027460 4283963455 4284291415 4286068827 4286401668 4284091962 4284687931 4287121240 4283828534 4283238719 4283503433 4287970653 4290344049 4290345850 4289351017 4285606469 4284291395 4284157261 4284160316 4284423237 4284224316 4284029254 4284226373 4283631691 4283371077 4287384685 4292382071 4289613920 4290073953 4292324514 4292517004 4292918702 4292589985 4293843148 4289169250 4282646578 4285401145 4286717769 4288824399 4290725716 4291517284 4291843166 4292041564 4291649895 4292240738 4292175973 4292504186 4292639351 4292966012 4292771943 4293233281 4292970382 4293365648 4293299085 4293237900 4293695865 4293238923 4293305501 4293302410 4293303177 4292977055 4293303943 4293369735 4292976283 4293305758 4293302923 4293365630 4292840844 4292903289 4292969351 4292967545 4292703862 4292638841 4292703096 4292899430 4292043367 4292109160 4291846504 4292106599 4292370530 4292902276 4293304218 4293839031 4294037697 4294038468 4293838775 4293043349 4292843157 4292383101 4293036677 4292642689 4292706681 4292703096 4292833657 4291846772 4292632424 4291846266 4291846243 4291125852 4291777377 4290005583 4286586183 4286062665 4283961661 4285931587 4285734988 4286195526 4286987352 4285208135 4284220231 4285343052 4292711819 4292188325 4291660665 4291133079 4284878132 4284813626 4284352308 4285207610 4284943930 4285339960 4284816708 4284549177 4284352828 4287248470 4290079598 4291198073 4291197290 4291127409 4291134586 4291790721 4292121474 4292119686 4291726717 4292184961 4291790966 4291923847 4291790967 4291922552 4291528577 4291725182 4291988088 4291396991 4291397237 4291790465 4291528314 4291658632 4291462773 4291331197 4291396723 4290805370 4291199344 4291265921 4290476921 4290805109 4290740093 4291068025 4290936697 4290212213 4290214264 4289688440 4289820280 4290737272 4292383873 4292850295 4293244560 4293441929 4293441674 4293574290 4293769858 4293443740 4293574791 4293638001 4293180316 4293507968 4293048458 4293376362 4292983200 4293376916 4293245330 4293247390 4293839262 4293181595 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287771723 4288558407 4287312203 4287968588 4288034380 4287376454 4288032842 4287509581 4287573575 4287048776 4287375688 4286323271 4285669192 4287437639 4290200394 4292046170 4292571754 4293166189 4292907381 4293697404 4293566851 4293565821 4293501575 4293697912 4293700225 4293698680 4293501058 4293566849 4293562238 4293359980 4292965208 4291253590 4290006090 4289212489 4288292166 4288036434 4289082442 4289544780 4289415257 4290531938 4290396751 4290728281 4290596695 4291255404 4291128986 4290072944 4288695395 4286267257 4288042892 4286794363 4286925165 4286400646 4285933650 4286327910 4285210442 4284554583 4286065262 4286992780 4288113318 4284093257 4285805668 4288838329 4288645803 4288505483 4284685132 4285015902 4285479295 4284554819 4284686920 4284488008 4284291397 4283897924 4284159050 4284159050 4284360019 4284356171 4283502910 4286394714 4286728578 4284750408 4287840078 4283829312 4283238463 4283827769 4288367456 4290472829 4290938501 4288826473 4288568184 4284421181 4284028992 4284289859 4283634746 4284155974 4284293958 4283435331 4283107654 4284292166 4292450957 4290602343 4290139497 4291394956 4293443241 4292851116 4292456083 4293117365 4291933841 4282974254 4284746815 4285797698 4287046981 4289281355 4290988887 4291255635 4292237156 4291256926 4292498531 4291713637 4292698987 4292965223 4292179064 4293425017 4292510330 4293295237 4292967809 4292972666 4293302669 4293304714 4293238667 4293699472 4293238150 4293239709 4293240993 4293304455 4293762954 4292909471 4293369226 4293237130 4293303434 4293301390 4293167749 4293102466 4292575093 4292902024 4292247162 4293097085 4292442728 4292767863 4292241510 4292242280 4292761963 4292109927 4292501605 4293098631 4293103244 4293706931 4294039239 4294040521 4293838261 4292649636 4292448384 4292841124 4292971138 4292840320 4292835716 4292704376 4292506979 4292700281 4291911267 4292436070 4292108393 4291977056 4291121228 4289149772 4285667392 4286849097 4284420413 4286325322 4285404218 4285802315 4288167501 4284487241 4284220994 4285534783 4292120216 4292583840 4290733687 4290812575 4285665596 4284617016 4283959112 4284419897 4285670722 4285471559 4285010226 4284488000 4284614722 4288104027 4291066481 4291460707 4291261817 4290409333 4291790975 4292121468 4292120188 4291726717 4292184953 4291791223 4291922306 4291462783 4291922305 4291265662 4291330680 4291790974 4291790719 4291134331 4291855225 4291199867 4291725180 4291199866 4291528320 4291134590 4291134592 4291592573 4291331453 4291133817 4291462523 4290740102 4291462008 4290412167 4290738539 4290477177 4290082424 4290474358 4290081910 4291989380 4292324984 4293702016 4292983175 4293835655 4293638514 4293178746 4293441674 4293048455 4293442178 4293246603 4293442176 4293180810 4293507966 4292917409 4293573243 4293180549 4293575835 4293575320 4293509526 4293445023 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287969357 4287967828 4287443787 4288164681 4287443018 4287574346 4287573575 4287049290 4287640138 4287770951 4286717511 4286457419 4286455368 4286851399 4290265166 4291189074 4292705134 4292705643 4293824638 4292907894 4293238922 4293370227 4293567111 4293370486 4293566854 4293501573 4293501315 4293566074 4293627768 4292968300 4292573535 4291518046 4289610831 4288624460 4287640140 4289346638 4289083981 4289348950 4289610322 4289350746 4290335067 4290137947 4290598748 4291647070 4291324517 4288363869 4287511671 4286067810 4285279840 4287385735 4288044703 4285932368 4288372624 4286986087 4284421456 4285540955 4287453852 4288180381 4284751707 4284029027 4287123338 4288779448 4286269579 4287454349 4284557403 4285808763 4286069599 4284487254 4284092998 4284091979 4284619594 4284884045 4284423495 4284487239 4284686409 4284290637 4284488264 4285015622 4284161609 4284422467 4287839828 4285142077 4283107122 4283632701 4287711844 4290210939 4290340213 4290416780 4288238429 4284156989 4283305275 4284027451 4284222272 4283305016 4284486988 4283238462 4282974259 4288762470 4291723885 4290136661 4290271078 4292920242 4292850318 4292852399 4292523426 4293842364 4284950589 4282779215 4284552768 4285208124 4288293448 4289086286 4291319126 4291383382 4291842404 4292502122 4291977576 4292370280 4292109671 4291713894 4293356137 4292312938 4292966014 4292312166 4293099396 4292970903 4293693306 4293235088 4293302674 4293237388 4293238687 4293631367 4293634206 4293240221 4292909466 4293368711 4293237388 4293696633 4293236882 4293168245 4293166219 4292968835 4292640648 4292638583 4292899176 4292445550 4292965225 4292504442 4292109159 4292370525 4292106600 4292109414 4292766844 4292768866 4292974492 4293705911 4294037954 4294038725 4293643198 4293042076 4292449417 4293168523 4292776335 4292837769 4292708220 4292310648 4292769146 4292370292 4292307849 4292042597 4292108392 4291779686 4291319126 4288689739 4286258248 4285668938 4284027191 4286456394 4284357962 4287047494 4288038490 4284746805 4284221251 4285666636 4291465098 4292581787 4290867580 4292845454 4285472071 4284222264 4284880445 4284617273 4286394446 4284814393 4284619328 4284877109 4284816190 4289154389 4290802797 4291262829 4291064180 4291134329 4292052860 4292120968 4292055436 4292119168 4291725423 4291658883 4291463031 4291922305 4291856759 4291922562 4291790965 4291134332 4291199611 4291659388 4291397247 4291331196 4290937212 4291331196 4291331187 4290805370 4291594104 4291133808 4291199611 4291067766 4291462781 4290870389 4290476919 4290542711 4291000438 4290540405 4289491578 4289684840 4291330941 4292516484 4292981128 4293246363 4293641355 4293376640 4292851873 4293637498 4293640086 4293245040 4293442434 4293245595 4293442174 4293639570 4293639314 4293508227 4293181856 4293641113 4293641885 4293707419 4293772966 4293379239 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288033364 4287510094 4287639625 4286983754 4287638598 4287639882 4287048263 4287179847 4287178314 4287178567 4286915656 4285865800 4285797445 4287441480 4290198855 4292109664 4292046700 4293035893 4292775037 4293303175 4293631353 4293566082 4293371513 4293172103 4293566849 4293500288 4293764214 4293499778 4293627768 4293100396 4293095004 4291847259 4289413711 4288686662 4287771465 4288754507 4288626000 4288953420 4289677911 4290005586 4290923603 4290726476 4291120983 4291056726 4291583335 4287175505 4286266228 4288638384 4289103801 4288443033 4285474645 4287511406 4289750656 4286722664 4286133603 4288702881 4287456138 4284358238 4283635772 4284685161 4285147748 4287788449 4288113326 4286073469 4286859396 4284883774 4285278825 4284685385 4283896131 4284292160 4285078602 4284752973 4284686408 4284095813 4284554569 4284293963 4284095551 4284622167 4284159289 4283961924 4287050567 4285272893 4282778686 4286457419 4288694358 4289817971 4288429943 4292583812 4291527288 4286461014 4282778422 4283305541 4283502908 4283762746 4283436345 4283500344 4283960896 4291990134 4290667879 4290139994 4291261311 4292656554 4292785570 4292591284 4293383355 4288836969 4282713155 4284094789 4285144644 4286060870 4286915655 4289609035 4290857814 4292238180 4291058512 4292105569 4292370537 4292307816 4292043623 4293355628 4292505721 4292639098 4293095784 4292966012 4292903285 4292838518 4293296520 4293234812 4293235324 4293629306 4293698954 4293239967 4293237892 4293634465 4293302663 4293303178 4293304716 4292908687 4293431424 4292577928 4293430891 4292706186 4292833124 4292835950 4292898148 4292704893 4292243319 4292832615 4292109673 4291842910 4292175978 4292109154 4292438881 4292443272 4292840088 4293571488 4294103490 4294040264 4294234047 4292649892 4292448386 4292778131 4292643205 4292708736 4292509576 4292639846 4292309878 4292440948 4292500581 4292108136 4291780454 4291257187 4290530384 4288361292 4286456392 4284618819 4284553534 4285602111 4285074227 4286455880 4287514448 4284810810 4284352586 4284482366 4292055184 4292978334 4290607995 4292124302 4287840095 4283826747 4284090420 4284288051 4286394188 4285277002 4284881472 4284291134 4287177799 4290407023 4291394414 4291130230 4290670953 4291660429 4292125317 4292056982 4292253032 4291659650 4292120191 4292119424 4291856769 4291856769 4291463032 4291725182 4291461758 4292117372 4291791231 4291199858 4291331197 4291133817 4291133817 4291331196 4291396732 4291068541 4291199344 4291134079 4290673782 4290936954 4290739318 4290282625 4290542455 4291000437 4290080885 4290015094 4290406258 4290345852 4292318585 4292982153 4293507204 4293572465 4293574037 4293704582 4293835652 4293376900 4293376898 4293442436 4293441676 4293639534 4293443996 4293375367 4293182595 4293181342 4293773212 4293247903 4294233759 4293445539 4293511330 4293576865 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287574345 4287048776 4287050828 4287704132 4287051862 4287115336 4287181385 4287179849 4286785095 4286851912 4286324808 4286585928 4285798725 4287571015 4289870410 4291453787 4292706416 4292575598 4293167218 4293694082 4293171066 4293566336 4293566337 4293630322 4293501316 4293698424 4293500545 4293564796 4293366650 4293361513 4292833888 4291978319 4289610320 4288752454 4287771466 4288821066 4288756820 4289547878 4289019470 4289676887 4289939030 4290793559 4291119960 4291054170 4290332290 4287319195 4290291909 4289563555 4288111492 4285343330 4286397032 4289488016 4287058829 4285275216 4288770994 4287192199 4284750426 4284752724 4285015908 4285214815 4283895646 4285085792 4288841656 4286595696 4287457175 4284224337 4285212499 4285276744 4284357723 4284292166 4285802828 4284158528 4284094534 4284423236 4283897142 4284614985 4283963717 4284358211 4287785870 4283827768 4284746038 4286196296 4283438151 4283564092 4289022823 4289225336 4287903840 4289153611 4293242529 4291594109 4285999435 4283043144 4283369533 4283568450 4283173182 4284219459 4288038485 4292314729 4290329678 4290009189 4292588208 4292849317 4293445043 4293316022 4292264619 4283301955 4283106363 4283832900 4285929790 4285864261 4287504202 4289413960 4290399064 4291448403 4291714658 4291910503 4292042850 4292109416 4292633450 4292570473 4293161064 4292965243 4292902519 4293098628 4292967047 4293427823 4292969349 4293495685 4293299602 4293236879 4292908190 4293302920 4293238691 4293631607 4293239180 4293300366 4293235585 4293761401 4292906642 4293626758 4292969096 4292771943 4292575103 4292964197 4292112778 4292962917 4292963175 4292175977 4292042589 4291715676 4292039521 4292175464 4291978615 4293032311 4293230480 4293173419 4293838774 4294040521 4294169024 4292978345 4292643725 4293103482 4292907646 4292115844 4292835958 4292117385 4292834167 4292374899 4291978104 4291912802 4292109920 4291517796 4290792529 4287438919 4285535550 4283960644 4285603652 4285336634 4285209924 4286458442 4287512145 4284483380 4284024901 4284155706 4291003528 4292978846 4291064709 4291857020 4288963444 4284488517 4283762233 4283960383 4286064461 4285078341 4284227143 4285271871 4288165962 4290605170 4291262829 4291130229 4290670698 4291725433 4292255372 4292057218 4292118658 4292119425 4292119160 4291792510 4291659390 4291856760 4291922562 4291921018 4291594370 4291134323 4291199868 4291528576 4291133816 4291331196 4291528575 4291133817 4291002748 4291199609 4291199611 4291067511 4291265402 4291265402 4291330682 4290870647 4290542712 4290540661 4290345593 4289950585 4289753977 4291856499 4292780423 4293177227 4293377153 4293837192 4293311105 4293900663 4293311364 4293442692 4293374089 4293442690 4292982663 4293639571 4293179539 4293772939 4293511336 4293839776 4293839520 4293839777 4293904024 4293511332 4293772698 4293183142 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287574088 4287050839 4287114323 4287705429 4287113539 4287181131 4287246679 4287310673 4286197322 4286917191 4286456904 4285602115 4285996361 4286325575 4290396237 4291255643 4292704620 4292838015 4293167217 4293170812 4293632384 4293566336 4293630335 4293172615 4293566851 4293697648 4293501318 4293562737 4293626481 4292968557 4292899424 4292174159 4289020752 4288228167 4287180358 4288293968 4289417569 4290477488 4289609291 4289675087 4290660945 4290132566 4290860658 4290804914 4289700012 4289956503 4287058030 4285212242 4284485963 4287052401 4290217902 4288502921 4285342287 4288579002 4287453300 4283633465 4284157284 4287256200 4285410149 4285872498 4284289371 4287128238 4289037500 4287057026 4289104824 4284947801 4284752711 4285146965 4285212244 4285143359 4286132823 4283766341 4284489279 4283830080 4284290114 4284227400 4283761224 4284555343 4286004310 4284748858 4285211463 4286062148 4283959614 4286455115 4288694622 4289823382 4290800230 4286584908 4290727515 4292189570 4292057233 4284419389 4283239490 4283305288 4284025158 4283957301 4290411895 4290863463 4289678424 4291125861 4292988605 4292918966 4293248447 4293845191 4286658352 4282778169 4283567171 4284881727 4286722127 4285733704 4288032586 4289410636 4290264908 4291384403 4291711323 4292109157 4292172137 4291977058 4292568170 4292700008 4292964987 4292767330 4292966524 4292705418 4293099615 4292969112 4292967807 4293101458 4293038965 4293694076 4293304979 4293237390 4293239178 4293630588 4293239180 4293300366 4293302670 4293037210 4293562244 4293103223 4292706424 4292772203 4293095033 4291977062 4292504933 4292175462 4292244349 4292307040 4292172138 4292172901 4292238687 4292106595 4293029736 4292570482 4292904847 4293238677 4293838518 4294038982 4294170310 4292979108 4292381815 4293166996 4292185476 4292968851 4292246391 4292771193 4292308594 4292833914 4292108897 4292109434 4291387491 4291713883 4289874005 4286522182 4285210185 4284095554 4285538380 4285210435 4286193225 4286262092 4288169551 4283893567 4283762999 4284284991 4290869120 4292517020 4291261063 4291266693 4290077821 4284947010 4283305279 4284618302 4285668412 4285210695 4284093763 4284812095 4288633948 4291589229 4291199601 4291129972 4291132280 4292186503 4292382596 4292187776 4291858292 4292118906 4292120183 4291790712 4291922306 4291463033 4291528567 4291463042 4291527294 4291856502 4291593851 4291265404 4291002748 4291133817 4291133817 4291199353 4291396988 4291067768 4291133048 4290939767 4290739320 4290802548 4290348669 4291001975 4290279544 4290936697 4290210922 4289360750 4290936435 4292253297 4292979851 4293508737 4293574295 4293113453 4293640087 4293374090 4293377412 4293178235 4293638015 4293769863 4293836931 4293114759 4293575579 4293641630 4293839520 4293839274 4293644455 4293379745 4294233759 4293313439 4293379231 4293445022 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287576401 4287639379 4287050570 4287116105 4287181655 4287246419 4286067017 4286852937 4286917191 4286916680 4286521929 4285274173 4285598781 4287113032 4290005069 4291321180 4292704877 4292773231 4293299064 4293693563 4293171334 4293632127 4292844157 4293236346 4293566851 4293501575 4293699452 4293497970 4293628021 4292968300 4292964959 4291386204 4289938515 4288162886 4288555080 4287636291 4289551208 4290148237 4288953423 4289083477 4290072949 4290741425 4291143094 4290805642 4290934662 4287903083 4283039798 4284095059 4286195824 4289491094 4291665081 4287052908 4287985070 4286332520 4283895626 4284290155 4283572301 4287656629 4285546348 4285081722 4284754026 4288912581 4288118441 4288241315 4286930047 4287059083 4283962426 4285012826 4285347429 4284949329 4285539686 4284091193 4283697990 4283830082 4283566912 4283833167 4284091712 4285801283 4287706954 4287771468 4287576401 4284484408 4287576159 4287509082 4288306049 4291991698 4292514441 4287836489 4285405763 4291323488 4292843637 4286260552 4283041331 4283435323 4282843953 4286330706 4292251261 4290268507 4288958557 4292453788 4293510836 4293380025 4293842107 4290613870 4282384440 4283697471 4283500606 4285078084 4287049294 4285664320 4288030023 4289017932 4290397001 4291121754 4291384159 4291386197 4292241002 4292109666 4292699243 4292110695 4292633958 4292966273 4293096041 4293098853 4292706442 4292904055 4292970365 4293166471 4293297807 4293232511 4293235345 4293697145 4293233552 4293235842 4293302159 4293301376 4293301633 4293302401 4293036421 4293364880 4293035143 4292837994 4292308840 4292240999 4292505192 4292307048 4292306790 4292438633 4291584358 4292433503 4291647062 4292238440 4291845735 4292764259 4292774048 4293305002 4293839029 4294038468 4294104260 4293575102 4292774264 4292777869 4292903049 4292642428 4293031287 4292704379 4292374387 4292439137 4291978106 4292174949 4292106849 4291256929 4288754505 4286980167 4284156233 4283830854 4285144389 4286261321 4285536576 4286917448 4287972700 4284351027 4283763014 4284416837 4289424233 4292387226 4290474096 4291988615 4290540411 4284753477 4283368248 4285013314 4285209927 4284751687 4284023875 4285934412 4289813873 4291394415 4291392865 4290670453 4291263601 4291990650 4292120958 4292054653 4292448136 4291858550 4292119161 4292119427 4291331704 4292250745 4291791235 4292119156 4291528578 4291134330 4291658632 4291462772 4291133817 4291331196 4291199352 4290742147 4291068285 4291328875 4290479730 4291001979 4291133559 4290805369 4291462266 4290279543 4291068281 4290016376 4289820026 4290277238 4292119666 4292127376 4293441913 4293376902 4293901685 4293574296 4293572723 4293375341 4293833861 4293442694 4293245042 4292984708 4293377433 4293707147 4293970075 4293773729 4293644959 4293644199 4293839776 4294233513 4293576091 4293575062 4293379487 4293575329 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287574602 4287574859 4287640394 4287114068 4287183438 4287181653 4287378516 4286786633 4286258503 4286457672 4285932361 4285862978 4285272635 4286589260 4289869380 4291519062 4292703341 4292575068 4293363843 4293300863 4293238661 4293565056 4293630592 4293566076 4293565562 4293500546 4293697906 4293496959 4293562484 4293427049 4292507232 4291714131 4289280586 4288293959 4287770696 4287704134 4289935945 4291268772 4289350275 4290073726 4291404201 4291658639 4289548150 4289883286 4290016401 4285867597 4284618066 4286328692 4289165723 4289560491 4287052626 4288177556 4287052126 4284750663 4284951155 4284095819 4286269569 4286531707 4287394217 4285544581 4286798237 4288512684 4286533760 4288970686 4285476949 4288974254 4284815701 4285212756 4285411419 4284357702 4285277771 4284354373 4283566135 4283436351 4283238456 4284025152 4285342282 4288496709 4290146686 4289085008 4287310406 4284548670 4288364376 4288040590 4290739343 4293242779 4293309078 4289814379 4283105348 4288034884 4290150008 4284815687 4283172661 4283369782 4282974260 4291066751 4290800990 4289683046 4290601062 4292720815 4293248688 4293314742 4291870107 4283170856 4283107385 4284156736 4282976056 4285670208 4287379276 4286191173 4288030024 4289081673 4290333777 4291182669 4291779429 4291582821 4292436329 4292042601 4291845991 4292633188 4292832874 4292961385 4292572537 4292769673 4293098626 4292903815 4293426035 4293166729 4293102981 4293100676 4293365118 4292908433 4293102474 4293302144 4293300880 4293302669 4293234065 4293429382 4293561223 4292969847 4293100149 4292639871 4292570981 4292637544 4292108648 4292109160 4292373096 4291649125 4292303716 4292106083 4291911005 4291845218 4292171880 4292573028 4292576140 4293303947 4293506229 4294103746 4294040264 4294102213 4292312425 4292708999 4292445820 4292705913 4292510317 4292376694 4292636807 4292109942 4292174435 4292438888 4291779686 4290529870 4288755787 4285406021 4283568955 4284292163 4284947012 4286129995 4285998663 4286722380 4288693843 4284221235 4283763001 4284024379 4289547635 4292057752 4290938768 4291267982 4290674309 4285341003 4282909745 4285207875 4284620098 4284157245 4284288058 4287050835 4291194481 4291265393 4291194731 4291064180 4291331968 4292513671 4291858801 4292120445 4292053624 4292315251 4291921796 4292119672 4292053376 4291331706 4291922552 4291265664 4291594360 4291592831 4291397235 4291725443 4290936955 4291396732 4291200128 4290478959 4291527805 4290282875 4291330426 4290936954 4290870904 4290672748 4290673528 4290214521 4290540652 4289623161 4290472306 4291722864 4292451207 4293308807 4293441932 4293377655 4293770619 4293311363 4293769609 4293572222 4293376395 4293376897 4293441923 4293772943 4293509528 4293839779 4293773729 4294167965 4293839017 4293839262 4293840044 4293184671 4293905312 4293247903 4293772955 4293707418 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287509078 4287575372 4287574615 4287181897 4286655314 4287246931 4286655304 4287374918 4286917707 4286455880 4286257475 4285406015 4285138744 4286650950 4289872974 4291584348 4292243815 4293165694 4293169515 4292909196 4293236869 4293565817 4293566593 4293564788 4293500028 4293698424 4293500801 4293565041 4293627765 4292968301 4292964193 4291453007 4289609041 4287508554 4288555079 4287770183 4288623433 4290269780 4291989405 4290804116 4290402941 4289152113 4289287297 4290733183 4290142828 4287639141 4285866853 4288628081 4290016907 4287451519 4285085049 4286928002 4285676391 4287393185 4284157509 4285806462 4287782809 4285674868 4288120501 4285339731 4287327651 4286932134 4287913632 4288717245 4286197618 4289039025 4284816457 4284354115 4284619077 4284752973 4285343309 4284092987 4283829312 4284157769 4283566389 4286261845 4285013069 4286194758 4289616227 4289414480 4285927232 4285937260 4287186793 4289949553 4289674057 4293441438 4293116066 4291919739 4283826744 4286191679 4287906383 4283105330 4283369781 4282975797 4286063672 4291594102 4290990166 4290074463 4291659422 4293184184 4293511348 4293842617 4284553533 4283042618 4284090688 4283566911 4283893567 4284948288 4288758367 4285996614 4287507015 4288557388 4290462285 4291448140 4291710041 4291979875 4292432733 4291977314 4292959851 4292309096 4292634218 4292963434 4292963961 4292903030 4293226617 4292903541 4292901496 4292969611 4293562247 4293099393 4293100932 4293363593 4293363831 4292972434 4293299834 4292972951 4293300090 4293693567 4292973182 4293232269 4292901499 4292901226 4292373095 4292307049 4292240744 4292042600 4292174181 4291912804 4291910754 4291515474 4292105828 4292238681 4292106599 4292569976 4292967057 4293299082 4293570727 4294103747 4294042573 4294038208 4292511120 4292514429 4292772475 4292509833 4292574054 4292180106 4292767606 4292504672 4292241786 4291714660 4291845725 4290071379 4288164434 4284550983 4284092236 4284685389 4284224053 4286785353 4285866055 4287377996 4287379792 4284613173 4283697467 4284812859 4287973471 4292253079 4291859103 4291394939 4290347143 4285538375 4282779194 4285604422 4283633211 4284685892 4284550474 4288105306 4291130985 4291197037 4291194987 4291065452 4292185465 4292384125 4292120959 4291923829 4292119936 4291725690 4292050540 4291725938 4291791227 4292185199 4291658884 4291725172 4291527804 4291922561 4291594115 4291199858 4291331197 4291133560 4291594110 4291200128 4291199609 4290936442 4291265145 4291133560 4290411127 4290477177 4290936696 4290804856 4290148729 4290082424 4290211701 4291790975 4293045639 4293244272 4293902732 4293769861 4293508758 4293374848 4293507446 4293770375 4293310601 4293639315 4292984448 4293903512 4293774242 4294167710 4293644189 4293839009 4293645216 4293839009 4293644188 4293839263 4293445550 4293839774 4293445537 4293511342 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288033353 4287509844 4287576400 4287114054 4286657879 4287244880 4286721864 4286853197 4286326855 4285932104 4285733700 4285271868 4285272893 4286647620 4289935684 4291388001 4292311142 4292838766 4292970375 4293694078 4293565311 4293566336 4293566079 4293566852 4293500545 4293698423 4293499771 4293565560 4293561973 4293756267 4292442450 4292105816 4289149514 4288818247 4287768648 4288556615 4287510350 4289150799 4289545555 4290466915 4289421708 4289031839 4289490835 4290145697 4291129992 4287249262 4284223820 4286135918 4288243090 4286659955 4286859912 4286791277 4287257758 4283895362 4286269579 4286728583 4285737577 4287396272 4287123580 4285805954 4286800283 4286202494 4287851428 4289898167 4286063988 4285747829 4284951139 4283369778 4283700809 4284093258 4284621387 4284489544 4284484425 4283962430 4283830606 4284487740 4285547641 4287055466 4286461523 4288232796 4285998158 4291137424 4290865503 4290335837 4287637832 4286915400 4289752161 4287976021 4284286516 4283763512 4285471307 4283370547 4283173701 4283170858 4288765300 4292115302 4290073955 4290207082 4293050043 4293907125 4293841334 4286929493 4283170860 4284027202 4284091705 4283959616 4283631159 4285999954 4288235341 4286650439 4287312199 4289607756 4289674833 4291119433 4291385435 4292236643 4291650151 4292175209 4292109672 4292435041 4292634730 4293160299 4292505979 4292965241 4292900983 4292967547 4292901753 4292903030 4293228402 4292970621 4293230979 4292838259 4292970383 4293103241 4293693310 4293167747 4292969871 4293298560 4293035133 4292969849 4292836459 4292309625 4292703080 4291649114 4291517285 4292237922 4292109415 4292309370 4292367201 4292238693 4291911010 4291514457 4292042601 4292373344 4292837769 4293168767 4293173928 4293973185 4294042060 4294170053 4292710796 4292707970 4292315019 4292706165 4292706684 4292376693 4292636511 4292177289 4291256419 4292370538 4290600029 4289478234 4286979907 4283239238 4284027718 4284749883 4285146446 4286654791 4285736778 4287376198 4287444046 4285404479 4283697204 4283697466 4288755038 4292580737 4291465626 4291788413 4290871928 4287315039 4283631931 4284488511 4284025145 4284550724 4285801031 4289222496 4291198588 4291525238 4291129451 4291589223 4292119427 4292055677 4292119422 4292120703 4292119159 4292119684 4291528559 4292249462 4291397489 4292251013 4291200373 4291988099 4291332731 4291725182 4291396981 4291658621 4291397236 4291594111 4291134335 4291068284 4291001975 4291462516 4290676612 4290936688 4291002747 4290868597 4290477176 4290674296 4289949045 4290277238 4290936692 4292977529 4292851081 4293835653 4293705861 4293311365 4293900150 4293311623 4293572726 4293311363 4293835140 4293051527 4293903513 4293381019 4294167711 4293578654 4293446054 4293839264 4293839265 4293839264 4293644200 4293839274 4293839528 4293839530 4293839529 4293839517 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287967827 4287509837 4287509065 4287575128 4287705159 4287114824 4287181900 4286788429 4286915143 4286520904 4285668163 4285601085 4284483127 4286388544 4289348169 4291384917 4292505438 4292575856 4293168764 4293170567 4293630847 4293566335 4293566336 4293500544 4293763958 4293501575 4293566851 4293564541 4293562989 4293427563 4293293397 4291517523 4290068302 4288164426 4287967047 4287770953 4288754247 4288951117 4289153633 4290275459 4290008976 4289481573 4290669442 4290671495 4289292177 4286063692 4286064999 4287450750 4286721123 4286135656 4287915164 4287386251 4285538915 4286399861 4286664319 4285738888 4285082721 4288776887 4284683880 4284817472 4286801571 4285737063 4287852963 4289241524 4286724487 4284624459 4287848865 4283367482 4283700036 4284817482 4283960888 4284421708 4285408069 4284488263 4284290372 4284154939 4285079366 4287054703 4285602882 4286916697 4289023309 4291529620 4290854725 4288622658 4285600059 4287192696 4287515494 4284553289 4283500857 4284422462 4284421449 4283040818 4283830582 4287776347 4291129439 4290268248 4291124061 4291661193 4293644978 4292121462 4290745729 4283105335 4283172922 4283238714 4284091707 4284091707 4284023864 4285738046 4289223534 4286323268 4288554570 4289016393 4290198603 4290791244 4291318872 4291059290 4292303454 4292305760 4292501094 4292242024 4292767338 4292370537 4293158249 4292703591 4293294206 4292705386 4293099912 4292968566 4292444538 4293097863 4293033857 4293232517 4293166472 4293100423 4293300860 4292970126 4293168260 4293363595 4292708220 4292575097 4292705658 4292377212 4292372833 4292171620 4291579992 4292436330 4292043367 4292896616 4292044134 4292106344 4292040806 4292105569 4291980388 4292633723 4292639858 4293169046 4293566873 4293773497 4294043856 4294169797 4292714127 4292572516 4292573828 4292901511 4292706682 4292442487 4291915129 4292241525 4292173415 4291584356 4290992738 4288823379 4284484920 4283765056 4283963975 4284815687 4284417852 4286521416 4287049289 4286787661 4286983754 4285142078 4284090421 4284680245 4286393166 4291266959 4292054674 4291197321 4291727235 4288305260 4283896121 4284419897 4283371323 4283435332 4287247175 4290141544 4292052327 4291657581 4291128681 4291265917 4292516227 4292054663 4292119928 4291790712 4291790978 4291790968 4291922555 4291659130 4291790712 4291200118 4291986296 4291725174 4291133821 4291790975 4291396981 4291397246 4291789704 4290674040 4291528565 4291330941 4291331188 4291133810 4291330169 4291133304 4291133561 4291066988 4290739578 4290474870 4290538355 4290147692 4292253820 4292977801 4293508479 4293706651 4293704325 4293507188 4293704842 4293572724 4293376899 4293573779 4293509770 4293837188 4293774244 4294167711 4294102174 4293578654 4293839265 4294167969 4293969815 4293445539 4293445281 4293839518 4293250206 4293839517 4293839273 4293839528 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287969872 4287443273 4288099928 4287508294 4287640396 4287050060 4287771209 4286653255 4286848840 4286324552 4286651978 4285533497 4284549175 4286386752 4289607496 4291387481 4292703582 4293101169 4293298807 4293694068 4293237888 4293172358 4293566335 4293566079 4293501315 4293501058 4293567622 4293565302 4293563520 4293558632 4292441441 4291649109 4289807949 4287703878 4287307845 4288228169 4289543524 4289687943 4291654557 4290075505 4290464342 4289352826 4290401404 4290729319 4288691812 4285539677 4287050606 4287319659 4286195557 4286729095 4289099950 4286134372 4286135921 4286134637 4286197878 4284290636 4287984291 4287390356 4283239223 4285082495 4288775356 4285475168 4287062700 4288715442 4287782298 4284223800 4288708792 4283500848 4283765324 4284354900 4284620885 4286399851 4284618048 4283829821 4283106872 4284685901 4285867338 4286725484 4288764260 4287979136 4288560467 4291852120 4292057997 4290474098 4288300908 4287842384 4285605706 4284091192 4283500602 4284421702 4283107133 4283367485 4288379802 4291394954 4289816933 4288563810 4288236389 4291330673 4291002998 4290809491 4290414472 4285539917 4284220985 4283435066 4284812347 4283960371 4284159052 4286326590 4288764011 4287439431 4287900231 4288622921 4289151822 4291447889 4291383639 4292236128 4292043624 4292172131 4292106851 4292109416 4292765802 4292832616 4292964733 4292572279 4293096296 4292507771 4293098599 4292903288 4293360244 4292903285 4292706182 4292904061 4293167226 4293100937 4293363593 4293166215 4293168258 4292972145 4293033348 4292967292 4292440420 4292703849 4291515234 4291119184 4291581278 4292109416 4292965225 4292244087 4292766586 4292834412 4292108903 4292172643 4292172138 4292439909 4292637050 4292971165 4293632666 4293838520 4294044369 4294169797 4292777874 4292050540 4292377463 4292379002 4292576106 4292177288 4292569954 4291912291 4291651946 4291058524 4290139742 4287244872 4283960899 4283961668 4284553532 4284751431 4284619324 4287178312 4286264141 4286851913 4286984011 4285601854 4283631669 4283632441 4286319675 4290740603 4291797404 4291528340 4292317046 4289028987 4285600830 4283765816 4283173706 4284418867 4288498785 4290344822 4291656816 4291330426 4291393909 4292248173 4291662725 4292118902 4291725176 4291856760 4291790978 4292185209 4291265912 4291789690 4291265910 4292184962 4291134068 4291790712 4291988336 4291396991 4291462783 4291725433 4290676852 4291593855 4291462784 4291462774 4291331197 4291264634 4290089859 4291133047 4291002482 4290739578 4290673005 4289751146 4290081142 4291000186 4292319614 4293047412 4293574293 4293837429 4293704327 4293704585 4293834614 4293311364 4293574037 4293705600 4293705876 4293641888 4293839265 4293578654 4293773729 4294167710 4293839522 4293248387 4293445542 4293839519 4293839530 4293445288 4293776308 4293510571 4293250470 4293839536 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288559951 4287314522 4288099401 4287509839 4287050572 4287705161 4287050058 4287245383 4286721096 4286913864 4286520649 4284878134 4284549175 4286714694 4289347662 4291321430 4292507243 4292967529 4293365892 4293236864 4293236870 4293632127 4293566335 4293566079 4293501315 4293764729 4293500290 4293564528 4293562745 4293099884 4292900188 4291976024 4290002510 4287506507 4287639113 4289481865 4290608278 4291261064 4290005329 4289675875 4290464592 4289811591 4290008175 4290731111 4287445101 4286459757 4285080893 4287382151 4286594945 4288705699 4287717516 4286199142 4286728051 4285082721 4286070646 4283500867 4288777416 4286004843 4283106387 4285344612 4287791022 4285935757 4286335086 4289240504 4288965291 4283171891 4287261836 4284750939 4284554056 4285872495 4285475663 4284026686 4284616511 4286065484 4282975794 4284157768 4285537599 4287575882 4289887339 4290075221 4284416830 4285210186 4287970130 4289682287 4284553532 4283698488 4283566131 4283370805 4284025139 4283632965 4282974254 4286204775 4292978838 4292908422 4292317060 4291463297 4290280591 4289624208 4291474855 4292849030 4289220433 4284088371 4283369781 4284290623 4284682810 4283960384 4283958084 4286001476 4289748327 4287835722 4287177287 4289083469 4290526534 4291121754 4291777373 4291780960 4291908445 4292175978 4292106850 4292699499 4292502378 4292568937 4293161064 4292572539 4292965245 4292965241 4292900727 4293098374 4292444793 4293294710 4293035655 4293034354 4292969351 4293231481 4292772471 4293234311 4292839290 4293034633 4293100936 4292444523 4292704124 4292639850 4291648358 4291117636 4292433761 4292766059 4292899436 4292897642 4292967023 4292505703 4292967023 4292304740 4291842902 4291911256 4292900461 4293625724 4293109665 4293838764 4294104008 4294301885 4292186764 4292442230 4292770936 4292377719 4292768123 4292636510 4292571768 4291912548 4291977057 4291649377 4289219159 4284617279 4283436358 4284289356 4284486211 4284554051 4284946756 4285998920 4286393418 4286917191 4286982987 4285536575 4284025651 4285011526 4283960636 4291131774 4292319893 4292117909 4291593346 4289949291 4284947776 4283567935 4283238455 4283761730 4288698470 4292049015 4292575081 4291919451 4290999148 4292119931 4292513661 4291727492 4292186502 4291790977 4292185208 4292119675 4291331437 4291528062 4291987326 4291265645 4291856504 4291331446 4291396992 4291265403 4290936955 4291265404 4291593855 4291265404 4291265395 4291528568 4291199354 4290805360 4291395706 4291330937 4290870904 4290146421 4290474870 4290343286 4290671733 4292251517 4292713602 4293509252 4293508500 4293836151 4293311366 4293506931 4293508760 4293376642 4293507450 4293640598 4293838232 4293904538 4294102430 4293773729 4293773729 4293773729 4293839520 4293511077 4293905312 4293839264 4293250207 4293905567 4293249960 4293709732 4293904819 4293445545 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287316560 4288689741 4287312459 4288100430 4287509067 4287575631 4287639881 4287048522 4287245127 4286849096 4286456905 4285730622 4284941368 4287047240 4289217615 4292108639 4292111202 4292837486 4293169267 4293236865 4293631103 4293564799 4293172357 4293566335 4293566079 4293500033 4293764729 4293501059 4293563518 4293362798 4292964703 4291518811 4290135889 4289283178 4289748615 4289617254 4289940053 4288887371 4288954191 4290069338 4290070620 4289420669 4291191933 4290074740 4286921323 4285801296 4284557409 4287975557 4287058824 4287783564 4287517561 4286920822 4285806693 4283827790 4285145964 4286799267 4287657107 4285804898 4283699796 4283306573 4287984814 4286925697 4285080947 4289041838 4289432248 4284287822 4286142847 4288510113 4283435084 4284816445 4284421445 4283766073 4285208125 4287447652 4283695928 4283698746 4284161355 4285608808 4284879935 4283368501 4284155707 4283829299 4286595184 4288702331 4287247954 4284221233 4283370560 4283565888 4284486215 4283304250 4282515495 4290026403 4291989382 4292713625 4292124827 4292714139 4293175951 4293375380 4292849554 4289683809 4284746551 4283697206 4284352822 4283698742 4285076019 4284485442 4283827253 4286525781 4288633190 4288426825 4287635523 4289541964 4290068049 4291121489 4291516759 4292041822 4292043366 4292304995 4292696679 4291845992 4292568170 4292962155 4292899195 4293160553 4292705130 4293096299 4292900476 4292903799 4292967290 4292901754 4292901239 4292706184 4293297529 4292838521 4293232267 4292839048 4293034629 4293035639 4292707467 4292444522 4292704121 4292441718 4291516006 4291576910 4292303714 4292964206 4292439638 4292831321 4292827461 4292702308 4293028960 4292109159 4292104801 4292366173 4292305514 4292901756 4293697143 4293508023 4293838240 4293708731 4292114285 4292377207 4292770936 4292312185 4292770168 4292244870 4291390587 4292043620 4291256418 4291189597 4287112784 4283632972 4284748859 4283372354 4284159051 4284489803 4284815683 4286586696 4286919757 4286391367 4287049292 4284811573 4285402942 4284876867 4283957309 4288897396 4292123807 4291730075 4291131504 4289751934 4285865288 4284157753 4282975812 4284878652 4289748072 4291790708 4292116580 4291460463 4291394426 4292121982 4291726462 4291857015 4291790977 4291856759 4291397241 4291856761 4291790721 4291725174 4291528569 4291790976 4291134076 4291856511 4291594104 4291856511 4291528575 4291331196 4290936955 4291594110 4291265406 4291331188 4291068542 4291462527 4290479472 4290674052 4290936438 4290805112 4290474613 4289819769 4290474099 4292449681 4292982152 4293572222 4293706118 4293704327 4293311107 4293704584 4293834613 4293705863 4293705347 4293838234 4293182855 4293839523 4293773985 4293773729 4294167965 4293839264 4293446309 4293576609 4293051556 4293839274 4293775268 4293511351 4293775267 4293709731 4293445299 4293839526 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287968331 4287903823 4287967048 4287967820 4288033612 4287443017 4287573062 4287705930 4287176775 4286784584 4286325832 4286586185 4285403967 4288030791 4289807952 4291585891 4292704621 4292575599 4293168510 4293628801 4293169023 4293632383 4293172357 4293566335 4293500544 4293764729 4293501060 4293566074 4293562488 4293165419 4292506717 4291583588 4290336625 4288758618 4287046722 4288358467 4287968333 4289282892 4289478738 4289807187 4290660946 4290138481 4290534278 4288764039 4287510111 4287312746 4285737062 4287910022 4286922622 4289035168 4288634778 4286921062 4285410926 4282843187 4284820602 4289637316 4287972482 4284818762 4285937539 4283631709 4287391632 4287388563 4286134918 4288315565 4291083200 4285540219 4284821075 4290158522 4283762751 4284357440 4283898185 4286724712 4285407045 4287381328 4283105841 4283501640 4283503418 4284684858 4285344354 4285015379 4283567180 4289954207 4290352550 4284088366 4283826742 4283632454 4283830594 4284619320 4283172928 4283303731 4283435330 4292655524 4292193444 4292785306 4292585884 4292588970 4292128666 4292128159 4288369500 4284024376 4284024628 4283501366 4283828540 4284485171 4284880204 4284549944 4284286534 4286065475 4288894313 4287902795 4288686409 4290067534 4289543505 4291120971 4291777632 4291778387 4292236888 4292107110 4292501854 4292435808 4292568171 4292767337 4293159787 4292702310 4293095051 4293028967 4292904315 4293096556 4293229685 4292837752 4293100663 4292968563 4292706183 4292903302 4292970106 4293230721 4293232261 4292839553 4293298057 4292966778 4292640380 4292832889 4291979874 4292235370 4292110181 4292831838 4292042844 4286385727 4284416064 4288159299 4290329157 4291054416 4292106837 4292108378 4292303451 4292436581 4293169304 4293636779 4293839280 4292645248 4292378748 4292379001 4292770680 4292576109 4292571748 4292440182 4292239459 4292043878 4291191648 4289152340 4284552255 4284354370 4283766348 4284094788 4284424785 4285473871 4285471547 4286326088 4287511120 4285275204 4287114828 4285074998 4285339963 4284418867 4283891768 4289224318 4292711577 4291664283 4291194733 4290609799 4286067279 4283764035 4283633485 4286132052 4290734187 4291462518 4291986289 4291525742 4291134324 4292513927 4292121469 4291791486 4291856769 4291856769 4291922562 4291725183 4291134067 4291593853 4291397238 4291789433 4291659379 4291396990 4291462783 4291265395 4291133561 4291133818 4291462268 4290611074 4291396724 4291199603 4290673778 4291199603 4291330674 4290476663 4290476923 4290805112 4290345337 4289227628 4291790709 4292255872 4293111182 4293835128 4293836153 4293836152 4293705863 4293705862 4293638534 4293705347 4293641614 4293904540 4293969819 4294167967 4293575835 4293839776 4293379747 4293839262 4293840289 4293839262 4293709734 4293709476 4293315506 4293315745 4293315503 4293904560 4293709987 4293445291 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287967049 4287968587 4287968844 4287312716 4287968073 4288032841 4287510608 4287048519 4287178056 4287242823 4286850632 4286325832 4286192712 4288229451 4290992472 4292110947 4292640109 4292772975 4293298807 4293693306 4293238917 4293172358 4293632127 4293566336 4293566079 4293501574 4293566850 4293565057 4293564286 4293297002 4292900705 4291716710 4290595156 4287967046 4287899463 4287770697 4288821582 4289019729 4289413196 4289872724 4289939028 4291055450 4289485434 4288562022 4286853982 4288363877 4286856032 4286596475 4287582343 4291135629 4288040825 4286069100 4283566934 4282974276 4286997912 4288775073 4284750431 4285150566 4287385739 4284359517 4286533513 4286928532 4286726281 4288310690 4289507500 4287712919 4283698759 4289174733 4283961667 4283437903 4284288067 4286987864 4286391875 4285736007 4284748346 4282975288 4283567160 4283238213 4283305023 4286527858 4286261864 4290087579 4290606451 4285007942 4284028479 4283832647 4284948295 4283698752 4283106873 4282318888 4287521411 4292056457 4292777606 4292720807 4292522657 4292524710 4293052076 4290080378 4282843176 4283762740 4284025922 4283762746 4284287808 4284749122 4285405240 4284944954 4284220477 4285802050 4289422964 4287642454 4289800773 4289545295 4290659146 4291053641 4291580496 4291386970 4292236889 4292172890 4291977573 4292436067 4292370027 4292962412 4292570217 4292833131 4292704874 4293032303 4293097070 4292510588 4292967543 4293293688 4292508537 4293098117 4293100147 4292970366 4293429637 4292837509 4292970356 4293230722 4292904587 4292380272 4292901741 4292442215 4292899454 4291710289 4292305503 4293157220 4291056979 4289281358 4287311946 4290136668 4290070355 4289934411 4289016651 4291053388 4292106084 4292371041 4293098858 4293305505 4293375138 4292907671 4292644748 4292769913 4292377722 4292376441 4292375673 4292767840 4292046711 4292109157 4291191391 4286916426 4284159304 4283961925 4284290378 4283765327 4285012537 4284552507 4285537866 4287508295 4286785609 4286457159 4287049807 4285009206 4285404736 4285404480 4283629627 4287709021 4292646791 4292191134 4289422448 4291332225 4286721604 4283369269 4285669447 4288297038 4291066481 4292116852 4292509033 4291853657 4292052349 4292054397 4292118903 4292119426 4291463032 4291331189 4291265653 4291988355 4291331446 4291397248 4291462782 4291462783 4291199611 4291659905 4291265404 4291528310 4291528576 4291331188 4291133809 4290870907 4291199602 4291199603 4291199612 4291265138 4290871163 4290870904 4290936696 4290408821 4290279800 4290539639 4291856499 4292650378 4294030451 4293837197 4293640326 4293638535 4293836151 4293638533 4293836680 4293640083 4293576097 4294102431 4293773985 4293773729 4293839519 4293510828 4293644443 4294167732 4293839011 4293643952 4293709232 4293643940 4293643939 4294298544 4293316530 4293315752 4293510560 4293841064 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287968076 4287314002 4288555846 4288557129 4287900743 4287968589 4288095814 4287574087 4287113031 4287181642 4287244103 4286719047 4287046983 4289346889 4290729308 4291849833 4292379260 4293100169 4293496186 4292843143 4293302661 4293631865 4293563520 4293566592 4293566079 4293566850 4293566850 4293565818 4293563261 4293494641 4292833373 4291977311 4290003016 4288622922 4288425031 4288363600 4288297546 4289217358 4290069583 4289545559 4290924115 4290073971 4289683590 4289087086 4287711089 4287903858 4286133606 4287513975 4285543531 4287120495 4286460770 4285542267 4282908724 4285810319 4289500082 4287320983 4284948556 4286336644 4286730638 4283369543 4286665863 4287786667 4286072691 4288114088 4288842669 4289495982 4285011025 4289176500 4285343568 4283107127 4283107134 4284813114 4284024899 4288899691 4291065458 4283895612 4283307342 4283369797 4283369525 4282909247 4287521158 4288771214 4285141320 4283500852 4284752464 4285405247 4284619838 4284816468 4284948280 4287444074 4289487967 4290934126 4292120701 4292908933 4292972930 4293765527 4291075983 4285734454 4283631162 4284155962 4284815673 4284944953 4284880184 4284418356 4285470021 4284486201 4284353858 4286525272 4289948785 4289018190 4288358726 4290201160 4291184467 4291647575 4291709525 4291975266 4292173152 4292172889 4292106860 4292501350 4291978594 4293224813 4292634472 4292964728 4292965239 4292966781 4292704362 4292966011 4292574587 4292769643 4292967291 4293099907 4292640648 4293295984 4292968068 4292969604 4293166730 4292969349 4293233019 4292772218 4292967034 4292706942 4292508263 4292107642 4291973983 4291907932 4292109151 4292830310 4292764773 4292569195 4292503136 4292367709 4290664538 4290463056 4291777118 4292103769 4292179591 4293047479 4292649097 4293104269 4292905846 4292509576 4292443253 4292440945 4292505458 4291652236 4291779424 4291587694 4290333787 4284683075 4284029515 4284359242 4284425031 4283698236 4285211993 4284095559 4286194760 4287310406 4286852940 4285670986 4287640395 4284943669 4285404735 4285668415 4282975030 4286130514 4291925394 4292317839 4290409085 4291332231 4287053665 4282974271 4285801545 4288958299 4291263345 4292249194 4291526760 4291263357 4291987828 4292120711 4291726470 4292120958 4291790968 4291856771 4291988089 4291264890 4292315252 4291528051 4291397247 4291265403 4291266689 4291659905 4291133550 4291134337 4291265403 4291528567 4291396734 4291396980 4291002741 4291068533 4291462517 4290673785 4291330940 4291000939 4290936954 4290212470 4290211959 4290540904 4292447874 4293109874 4293312135 4293704325 4293638535 4293706118 4293704326 4293442707 4293837702 4293904799 4294101642 4294036641 4293904024 4293578910 4293839273 4293250463 4294233246 4293773725 4293643954 4293710001 4293644710 4293839015 4293840558 4293250212 4293840044 4293839261 4293839529 4293839271 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287966278 4288100687 4287377225 4287969104 4287966791 4288030278 4287377994 4287574858 4287045703 4287176778 4287114823 4287115082 4287312714 4289542487 4291190107 4292113273 4292378748 4292708207 4293496188 4293693561 4292842630 4293695103 4293171590 4293171840 4293566335 4293566850 4293502344 4293566333 4293564029 4293297003 4292900450 4291520093 4290201421 4288753993 4287180359 4288358981 4288757586 4289280842 4289217871 4289806930 4291186532 4290405772 4290730353 4288168793 4287052893 4284748882 4286658144 4286926975 4286067039 4286659684 4284359512 4283433017 4285081955 4289431464 4287385470 4285080663 4286728829 4286004858 4286069621 4285604983 4285810534 4287787168 4285802094 4287457966 4287453585 4290226620 4286201739 4288841637 4287124101 4282908720 4283306565 4285801805 4283695163 4291393145 4293435523 4288760148 4283958841 4283304241 4282910545 4283766856 4288639649 4286334829 4284159556 4282581040 4287251823 4286987854 4289813115 4288632169 4289355638 4290676623 4288628553 4289945452 4290795104 4289747053 4291671723 4291547577 4284418097 4283302966 4283500601 4284288064 4285281631 4285287530 4285411927 4284812850 4285008183 4284354105 4284421452 4285802827 4290080886 4288825438 4289080903 4289741646 4291120463 4291841111 4291516238 4291975003 4292040554 4292172640 4292501586 4292177003 4292959839 4292437098 4292436584 4292963452 4293096811 4292899962 4293096043 4292575101 4292966266 4292964474 4292379499 4292901499 4293298035 4292639112 4293034866 4293230978 4293166725 4292970107 4292969351 4293034611 4293099399 4292378730 4292901997 4292703610 4292572004 4292635004 4292235879 4292565605 4292960104 4292502117 4292831588 4291905883 4292299875 4292438649 4292120737 4292716206 4293112245 4293440659 4293040272 4292710804 4292249475 4292576620 4292246664 4292244355 4292571507 4291321960 4292505190 4291454305 4287113549 4284026171 4284357698 4284357965 4283963984 4284226378 4284881987 4284751688 4285405766 4287972430 4286658136 4286916424 4286984267 4285139770 4285339966 4285008188 4284024640 4286189128 4291728012 4292126366 4290407792 4291200903 4288368226 4283960645 4285143874 4290799724 4292379748 4291986300 4292114781 4291461488 4292514441 4292054140 4292186495 4291725167 4292119427 4292185207 4291265921 4291331446 4291659649 4291790710 4291856512 4291199859 4291462783 4291462781 4291724168 4291462772 4291528575 4291199098 4290413695 4291068285 4291462525 4290936699 4291133304 4290936946 4291002482 4290870906 4290214253 4290475626 4290866292 4290805631 4292319099 4293177223 4293900663 4293639047 4293836151 4293638791 4293638531 4293837960 4293904267 4293904283 4294036641 4294036638 4293708193 4294167710 4293773728 4293839265 4293773729 4293773728 4293644700 4293643698 4293839782 4293840039 4293840554 4293511587 4293773725 4294233510 4293379753 4293709743 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288032841 4287444302 4287509324 4288097350 4287441990 4287312973 4288754505 4287442503 4287769159 4286523207 4287770952 4287507526 4288427607 4289216591 4291126371 4292112508 4292576882 4292970871 4293365633 4293235584 4293760378 4293169537 4293628794 4293564282 4293566336 4293500287 4293764729 4293500801 4293564029 4293492584 4292901470 4291844950 4290594892 4288032844 4287900742 4288362060 4288755789 4289019728 4289544786 4289413715 4290597214 4290141281 4291514218 4290009216 4284486228 4283434052 4285080409 4287056008 4285937766 4285737559 4284944995 4283436366 4288709805 4287712881 4283963977 4284487762 4286727560 4286068854 4285674590 4286796697 4286666127 4287519650 4286070398 4288053168 4286527610 4288517029 4288501409 4288710823 4289100453 4282975030 4283435070 4285734722 4283566149 4290339954 4293107304 4292384888 4284022841 4283238456 4282974264 4286603651 4285734475 4285996608 4285867609 4286133856 4287318348 4289353343 4289419378 4290676108 4292130483 4289950051 4289744220 4289280588 4289746790 4290677898 4294175696 4288959058 4282777671 4283895375 4284222780 4284355389 4284945984 4285736261 4284422725 4285208638 4285209407 4284354111 4284219456 4286526544 4290082425 4288953161 4288493131 4290000973 4291512911 4291580495 4291319131 4291714651 4292236886 4292043361 4292107104 4292106602 4292173667 4292567914 4292700521 4292960363 4292702567 4292963964 4293031021 4292833895 4292573307 4292771692 4292967551 4293031273 4292968581 4293034115 4293033859 4292640390 4292838260 4293232261 4292969604 4293230979 4292708219 4293034374 4292444552 4292900739 4292899687 4292310648 4292568936 4292110694 4292501609 4292441189 4292837767 4292377723 4292114548 4292774550 4293836730 4292984748 4293376428 4292980395 4293041547 4293496720 4292639860 4292575369 4292443253 4292508276 4292111991 4291718006 4291519589 4290860890 4284224317 4284030789 4284353602 4284620612 4284028996 4283505233 4285145929 4285341513 4285998933 4287710289 4287310663 4286790482 4286915398 4286062410 4286459463 4284354360 4284549186 4284549434 4291396744 4292583839 4290209380 4291003526 4287315804 4285208643 4286785101 4291132529 4292117617 4291329389 4292378740 4291068535 4292119924 4292120192 4291331448 4292185209 4291790977 4291397507 4291723887 4291922554 4291922553 4291134076 4291199869 4291855216 4291265661 4291002493 4290742644 4291528319 4291265404 4291133809 4291396734 4291396979 4290805371 4290740084 4291134068 4291133561 4290805112 4290936696 4290082682 4290148730 4289753710 4291659125 4292780148 4293507202 4293704840 4293704326 4293640329 4293835893 4293640858 4293837445 4293772185 4293708450 4294036638 4294102174 4293773729 4293773729 4293773986 4293839521 4293773728 4294102184 4293644715 4293710235 4293315506 4293511338 4293250988 4293315492 4294233253 4293184688 4293839021 4293644719 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287509067 4287575374 4287574860 4287508553 4287444559 4288688972 4287378508 4287574602 4287047754 4287311943 4286587975 4287574346 4287708493 4289415273 4291126375 4292246641 4292904303 4292970111 4292973446 4293365894 4292842872 4293696122 4293565313 4293566593 4293566079 4293567365 4293501058 4293566592 4293563004 4293298285 4292376432 4292505188 4290003534 4288100172 4287901769 4288427340 4288755789 4289282899 4289281358 4290004052 4289609294 4290531179 4291458179 4292446106 4286260306 4283368260 4285213271 4287056253 4285998158 4286067562 4284552284 4288250283 4287917197 4284555863 4283633495 4284293208 4286265451 4285740914 4285411183 4286665601 4287394468 4287190161 4287783063 4287524251 4285539697 4287458713 4288771494 4288315038 4289564844 4286003569 4283304261 4285146189 4284810809 4287382612 4291262600 4289738814 4284882755 4283107658 4284954450 4284884304 4282977097 4285935694 4289096834 4289223540 4290076037 4289751417 4290940319 4292785572 4291402372 4288690263 4288236366 4289880961 4290278516 4293775048 4291143045 4283435065 4283830861 4284358219 4284358222 4285078082 4285144901 4285145160 4285668676 4285210698 4285077565 4284814140 4283765579 4285870664 4290146946 4288366938 4288555846 4289414736 4290857296 4291384416 4291649120 4292499046 4292173152 4292107097 4292957536 4291911773 4292633699 4292700522 4292634217 4292767081 4293095532 4292703594 4293096557 4292572029 4292835945 4292963447 4292704103 4293098631 4293034115 4292902772 4293231235 4293233016 4293168776 4293034631 4292969605 4293035396 4293099137 4292838798 4292641382 4292641145 4293033340 4292245626 4293226087 4292636794 4292637302 4292969085 4293436046 4292717726 4293162623 4293367688 4293441699 4292918444 4293768619 4292981148 4292712852 4292775803 4292707455 4292444536 4291916923 4292570994 4291321704 4291651709 4291389801 4287904345 4283767114 4284620123 4284423240 4283963470 4284223812 4284161347 4284685388 4286261834 4285799749 4288631119 4286061893 4286857810 4287047754 4285272640 4286787661 4284485943 4284418117 4283498546 4290017924 4292781725 4290076268 4290807174 4287249491 4286654031 4287774542 4291327867 4292182383 4292115295 4292443240 4291988847 4292120713 4291725166 4291858303 4291790977 4291856759 4291922296 4291725184 4291725183 4291922552 4291592832 4291462774 4291462784 4291133561 4291331187 4291330940 4291528575 4291331196 4291133810 4291331188 4291133563 4291594102 4290936442 4291134078 4291132783 4290870904 4290477178 4290343529 4290146679 4290342507 4291660148 4292845963 4293505409 4293507444 4293704585 4293441139 4293640329 4293639551 4293837980 4294101900 4294102176 4294036640 4293773729 4293839521 4293773986 4294101385 4293773730 4293578654 4294167453 4293839777 4293839786 4293709476 4293644712 4294232984 4293643953 4293643940 4293315501 4293840818 4293840569 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287575631 4287640396 4287048262 4287574346 4287509324 4288033097 4287507017 4287573831 4287180615 4286782536 4286650696 4287573574 4288562258 4290071638 4291060583 4292114813 4292903289 4292643460 4293627002 4293235584 4293694068 4293171075 4293564538 4293565818 4293566851 4293566593 4293501830 4293565817 4293563268 4293232494 4293293913 4291848808 4290398542 4288753480 4287311945 4287246924 4288298065 4288757321 4289348949 4289481044 4290333018 4290800533 4292906137 4290401908 4286067293 4284683614 4285213526 4287188366 4284687455 4286990215 4288113054 4288774825 4285080136 4284751193 4283965527 4284358489 4285937253 4285872246 4284557671 4286069611 4287060382 4286266725 4287389849 4287853218 4286466444 4286469501 4288974256 4287519885 4288315309 4287981721 4285672546 4285606220 4287512184 4287053167 4288694614 4288494960 4285672285 4286263127 4285672011 4282910534 4283043401 4285872745 4290934907 4289951884 4290674309 4292058019 4292519575 4292132535 4288493636 4288236623 4288557157 4290931301 4292262587 4293118114 4284618816 4283962692 4284160068 4284820049 4285474384 4285145934 4284885332 4285605452 4285804109 4285669447 4285732931 4284355918 4284815942 4286459729 4289554805 4288893041 4289149773 4290593618 4290530905 4292236383 4291583334 4292107362 4291844962 4292043109 4291977316 4292109675 4292633701 4292436587 4293161836 4293093996 4293095530 4292702057 4293095274 4292769384 4292963960 4292703370 4292968060 4292510328 4293099654 4292575352 4292706439 4293033859 4293231481 4292643217 4293297265 4292903301 4292969095 4292444008 4292903050 4292508296 4292705402 4292508777 4292640383 4292833381 4292772729 4293168775 4293638314 4293376180 4292644500 4292974717 4293442229 4293704112 4292916390 4292983218 4293106325 4292578183 4292311412 4292441718 4292443771 4292243077 4292308838 4291456112 4291453281 4283896899 4284292937 4283768654 4283636560 4284226377 4283965005 4284425036 4286000213 4286130249 4285734985 4288368209 4286128969 4287378505 4286325831 4285932872 4286652488 4285474117 4284352330 4283958854 4289156203 4292650385 4290149257 4291134852 4287248976 4286657870 4289747059 4291395942 4292116838 4292311925 4291526502 4291987833 4292120703 4292119417 4291790977 4291922304 4291463041 4291528568 4291593597 4291397237 4291331456 4291856502 4291199603 4291462784 4291265403 4291528575 4291659648 4290542197 4291396989 4291199354 4291331197 4291396733 4291396732 4290413696 4291330683 4290541420 4290870906 4291132525 4290212471 4290081144 4290212717 4292185473 4293108079 4293377165 4293704584 4293836151 4293837199 4293834098 4293838238 4293381004 4294102177 4293708709 4294102924 4293773730 4293773985 4293969561 4294102432 4293773729 4294167454 4293578654 4293643933 4293643941 4293839786 4293643950 4293839795 4293644722 4293643937 4293840575 4293249963 4293839790 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287573062 4287051085 4287637575 4287573831 4287573831 4287571783 4287573837 4287574087 4287178824 4286127432 4287372615 4287048521 4287051095 4290074214 4291586407 4292113785 4292707711 4293363327 4292775793 4293301895 4293235847 4293629043 4293565570 4293564800 4293566079 4293501574 4293763701 4293501058 4293562999 4293756779 4292377698 4291715423 4290201163 4288099916 4287967562 4288557129 4288164427 4289151569 4289674830 4289476185 4290995568 4292773796 4290470003 4288830085 4286853483 4284951378 4285803116 4286329433 4287253129 4289235633 4287715975 4285341760 4285278311 4284027202 4283898973 4284355919 4285937767 4285805924 4286265708 4285346149 4286069623 4285475943 4287259798 4286599558 4286796685 4285607530 4288510895 4286071934 4289566385 4288767646 4285936482 4286527085 4287452544 4287644524 4287186283 4287055193 4284157509 4284488255 4285211470 4283041339 4285801307 4290423992 4291400104 4291659909 4291796642 4291273389 4292131758 4290282872 4288032842 4288955495 4288036680 4290274674 4293713326 4285212733 4283565876 4284158795 4284422468 4284356669 4284814392 4285338936 4285272887 4285472582 4286064714 4285868107 4284619586 4285470263 4284222276 4284814654 4289621379 4289091174 4289279052 4289741897 4291252815 4291186517 4291909721 4291648852 4292172640 4292567390 4291977061 4292173651 4292370286 4292502369 4292766826 4292833640 4292507262 4293161065 4292505721 4292635000 4292767846 4293095273 4292703079 4293293947 4293098599 4292575613 4293360499 4292704906 4292706661 4293164932 4292704645 4293100934 4292640632 4292509805 4292510059 4292575338 4292311672 4292575854 4292704888 4292772986 4293100409 4292975510 4293577139 4293247154 4292977055 4293368700 4293180342 4293443000 4293311658 4293377190 4292645255 4293231481 4292575879 4292179590 4292640357 4292308871 4292308838 4291979877 4287708505 4283829822 4284359242 4284358730 4283962173 4284618824 4284028997 4283700291 4286000204 4285407302 4286524239 4288297553 4286064457 4287379791 4286260554 4286455624 4286260292 4285008693 4284418362 4283434036 4287579230 4292843659 4290808974 4291135109 4286394702 4289223277 4290339170 4292378211 4292116840 4291719514 4291593591 4292185210 4291725942 4292119417 4291856513 4291463031 4291922560 4291724674 4291397238 4291265404 4291462783 4291397238 4291528577 4291265394 4291331196 4291133561 4290413680 4291265147 4291265136 4290674301 4291528061 4290608749 4290870907 4291790701 4291134070 4290870906 4290805369 4290674545 4290411642 4290473319 4290803319 4292054655 4293240194 4293770887 4293836408 4293834617 4293638277 4293838495 4293903751 4294102177 4294037409 4294036382 4294036384 4294102174 4293774500 4293380504 4293773729 4293839265 4293774499 4293839265 4293773727 4293839788 4293250724 4293710259 4293839781 4293644709 4293839538 4293840562 4293840561 4293839801 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287574346 4287049546 4287637575 4287574858 4287048522 4287050058 4287574087 4287572296 4287766343 4286783560 4286653255 4287572553 4288365134 4290072162 4291455613 4291786347 4292379777 4292775029 4292972419 4293758842 4292909943 4293234819 4293563002 4293566592 4293566079 4293501570 4293501575 4293566332 4293563775 4293232494 4293227613 4291913050 4290333008 4288100172 4287375175 4287179846 4289412687 4289016906 4289150027 4290335585 4291725736 4289943916 4289680492 4289158790 4285799228 4286194792 4285215070 4286527345 4289888938 4287980166 4283367482 4283961670 4285944433 4283701318 4285409104 4284357462 4286002551 4284887386 4286198903 4285342810 4286205056 4285673072 4286333801 4288509620 4284489296 4286004611 4287655060 4288112798 4289499823 4288378005 4287118713 4284420924 4290479257 4287907676 4284881480 4285602619 4284420668 4283236416 4286127427 4286790228 4288763758 4291264133 4291593587 4291004314 4292584599 4291936173 4292460705 4289215295 4289024859 4288691273 4288693078 4292723888 4288372821 4282384446 4284418366 4284288062 4285865789 4284355647 4285010739 4285271102 4285272375 4285207612 4287116366 4286061640 4284617783 4285207613 4284154942 4285669180 4288829798 4288958562 4289417309 4289477711 4290922316 4291578451 4291646300 4292499297 4292107359 4292106853 4292765285 4291911781 4292630876 4292437100 4292963693 4292568425 4293161323 4293028202 4293161321 4292571260 4292769130 4293095274 4292507005 4293096298 4292573309 4292836458 4292770955 4292837989 4292965757 4292575609 4292771975 4293166970 4292575355 4292770682 4292507017 4292315007 4292575369 4292573543 4292247674 4292968581 4292839578 4293306510 4294102719 4293378996 4292979122 4293237379 4293837497 4293378741 4293246110 4293374371 4293040270 4292710023 4291850869 4292507509 4292311434 4292242528 4291784063 4290798447 4285073728 4284161099 4284093258 4284684874 4284489289 4284554824 4283700030 4284752718 4286262088 4286064457 4286722379 4288298066 4286784582 4286722124 4286979912 4287049288 4285601860 4285666365 4284550195 4283893314 4287905119 4292120450 4290348163 4290801517 4287771987 4288896617 4290535008 4292181859 4292445299 4292115039 4292117361 4291727233 4292184953 4291790968 4291858302 4291922306 4291463041 4291790710 4291331447 4291397247 4291659388 4291265404 4291133817 4291331196 4291528319 4291528575 4291068285 4291199609 4290870907 4291134332 4290607990 4291528062 4290936442 4290282879 4290805615 4290542957 4291395438 4291132782 4290672248 4289882988 4290671730 4292580727 4293374835 4293900663 4293638792 4293638792 4293837430 4293771654 4294102690 4293708964 4294036383 4294036639 4294036639 4294036639 4294102174 4294102175 4294102174 4293513118 4294232989 4293184672 4294233255 4293840040 4293511101 4293775779 4293249711 4293775794 4293578414 4293839779 4293446587 4293840559 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287639367 4287114055 4287048776 4287637831 4287638343 4287043911 4287703624 4287180615 4286653259 4286849863 4286654538 4287574345 4287771468 4289416790 4291125598 4291654783 4292642159 4292970614 4293365627 4293234810 4293302146 4293631349 4293564283 4293566593 4293500544 4293698166 4293698937 4293501318 4293563504 4293299312 4292836976 4291649882 4290726471 4288752199 4287309895 4288622922 4288296781 4289016656 4289609820 4290936990 4290667639 4289677681 4291456113 4289355384 4285273434 4285800288 4287319417 4288765082 4288578468 4286462322 4283371331 4285012823 4285083987 4286135929 4285410160 4284819527 4286069098 4284224828 4286862202 4285671764 4285280111 4285804639 4285935719 4287984550 4284355934 4285806706 4287983267 4289362854 4287322501 4288244378 4289098663 4286527835 4293568905 4285727539 4284816458 4283958838 4285801802 4285869651 4287512664 4289615732 4289021025 4289424500 4291331988 4291205020 4292062114 4292857541 4290139736 4288168784 4288164940 4287970387 4291271073 4290483320 4282908729 4283828550 4284684871 4284945979 4285866059 4285537860 4285077824 4285668671 4284550451 4285408071 4287050058 4286523723 4284880448 4285142079 4285008707 4285468218 4288173670 4288563033 4288830568 4288884807 4290596950 4290596175 4291779424 4292040547 4292172896 4291912037 4292435800 4292305002 4292304740 4293026661 4292767338 4292634218 4292768103 4292966014 4292700775 4293093994 4292769644 4292766313 4293095530 4293029996 4292767076 4292966783 4292966266 4292640125 4292573048 4292836462 4292836458 4292575357 4293227883 4292248443 4292769399 4292770679 4292313208 4292708999 4292904829 4292707451 4293431925 4293177254 4294036668 4293903797 4292980386 4293299330 4293113001 4293904568 4293638324 4292979591 4293106059 4292509062 4292505968 4292509814 4291916165 4291588477 4291980903 4288824666 4283436870 4284356928 4284160844 4284423236 4284291650 4284160585 4284554822 4284751174 4286261587 4284818251 4288034638 4287641674 4286065482 4287509581 4285926717 4286525260 4285668931 4285078079 4284418110 4283826759 4286463071 4291924354 4291597214 4289948790 4287576399 4290276991 4291456101 4292180064 4291721303 4291788920 4291790454 4291856496 4291790970 4291856771 4291462775 4291725173 4291528578 4291265654 4291988346 4291789434 4291397238 4291528575 4291133560 4291331196 4291134324 4291331196 4291199353 4291133818 4291396979 4291068541 4291264890 4290676596 4291462260 4291264890 4291067770 4291133817 4290934391 4289491579 4289818219 4290343283 4291001441 4292450948 4293308022 4293509016 4293836150 4293966973 4293770635 4293904009 4294036641 4294036640 4294036364 4294036640 4294036383 4294102174 4293313955 4294102945 4293707937 4294167710 4293774499 4293904800 4293250206 4293316265 4293775791 4293446325 4294300327 4293184164 4294299313 4293250736 4293447344 4294168248 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287113290 4287245895 4287180615 4287113291 4287702087 4287769415 4287114824 4286653768 4287372359 4286129224 4287244103 4287639881 4287248473 4288759888 4291060344 4291982704 4292247432 4292774275 4293365631 4293236359 4293236608 4293628538 4293566849 4293565305 4293566850 4293501573 4293500804 4293764214 4293563519 4293495155 4292835933 4292175949 4290528589 4287508298 4287440967 4287181385 4288820050 4289019475 4290605454 4291064967 4289152615 4290528332 4291391353 4288434816 4285078862 4287054458 4287709052 4287060103 4288243608 4285342803 4284487235 4284752745 4284423250 4286004330 4285541977 4285938040 4285475175 4285279854 4285806955 4286727281 4284557142 4285542509 4285281627 4286402175 4287385730 4283501644 4284291927 4288047503 4289300411 4287256978 4288773791 4289956258 4291191395 4282581036 4283700548 4283696191 4285803335 4290605962 4289094277 4288104029 4288826726 4289753979 4291137435 4291663759 4292922821 4291200883 4287840074 4288165202 4288691799 4290144872 4292855198 4282908716 4283502911 4284089418 4286063940 4287180878 4284618819 4285013061 4284484409 4285996102 4285536574 4286126665 4286461261 4286984268 4286193482 4285074742 4284155961 4284813115 4289093223 4288300632 4289812078 4288490308 4289674832 4291775829 4291709007 4292435807 4291910486 4292960614 4292436057 4291845995 4292633949 4292436835 4293224046 4292701545 4293093996 4293031533 4293093996 4293030252 4292766313 4292766825 4293094252 4293093994 4292572798 4292834409 4292899946 4292442216 4293032063 4292835690 4292504456 4292510828 4292702583 4292376185 4292509545 4292769399 4292311675 4292510830 4292836743 4292969864 4292840618 4293308829 4293512128 4293909193 4292915124 4293174713 4294104258 4293905326 4293574843 4293376438 4292778656 4292441458 4291981943 4292439940 4291455350 4292308853 4291849595 4284945218 4283830596 4284225101 4284291391 4285016915 4284292939 4283962946 4284225858 4284949067 4286129478 4286589257 4286657358 4287771988 4286784582 4286788429 4285864775 4285866823 4286719306 4284814130 4284483911 4283892544 4286330721 4291460473 4291401108 4290736755 4287512668 4290273895 4291455583 4291983726 4291525477 4292183412 4291987832 4291792512 4291790970 4292184952 4291857544 4291856760 4291659647 4291922553 4291330682 4291265651 4291265662 4291265403 4291528575 4291265403 4291331722 4291331195 4291133817 4291594111 4291134075 4291001974 4291462781 4290476922 4291265146 4291199613 4291461221 4290739836 4290541165 4290280559 4290278510 4289753978 4291263348 4292778114 4293702267 4293704582 4293638534 4293770633 4293904266 4294036898 4294037153 4294036382 4294037410 4294036382 4293513119 4294036382 4294102945 4294101917 4293578653 4293839008 4293839264 4293250206 4293905320 4293710257 4293250224 4293906857 4293446323 4293906099 4293644720 4293511858 4293840561 4293578422 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287313741 4286193223 4286848072 4286784583 4286719303 4286656331 4287243847 4286720328 4287308872 4286718024 4287179080 4287047494 4287903307 4288759912 4291323492 4291127933 4292708477 4292970109 4292972417 4293694841 4293630329 4293171335 4293566591 4293566851 4293566850 4293501317 4293765243 4293501060 4293565815 4293297773 4292443490 4292043879 4290335575 4288227912 4287965511 4288554821 4287967053 4289618807 4291725215 4288822098 4289871952 4290596178 4290209918 4288300911 4285474656 4286329712 4283697204 4287917224 4286728555 4284225103 4285278291 4284357971 4286204273 4285014120 4284685910 4286072969 4284950102 4286797450 4285872481 4287056000 4286003563 4285346410 4285806692 4286003062 4286599812 4286860428 4283829838 4284950122 4288773784 4288769183 4287789996 4290091952 4284621903 4282976061 4282911817 4286133080 4291720066 4291918460 4292324521 4290420402 4290151080 4291335844 4292851878 4292462015 4292128909 4287374650 4289155930 4288824155 4289944676 4292462525 4285804356 4283439441 4283371850 4283566908 4287051854 4288759635 4285470268 4284357958 4284681267 4285996870 4285010749 4285799491 4285801030 4287642964 4285800510 4284876854 4284811331 4285467965 4288303976 4288363338 4289287277 4287903564 4290525517 4290399059 4291187018 4292497760 4292107616 4292041311 4292436064 4292699486 4292435558 4292567908 4292375911 4293158510 4292701289 4293095532 4292702313 4293095532 4292766569 4292634218 4292832106 4292702568 4293226607 4292440423 4292307560 4292966254 4292441448 4292898666 4292505444 4292573290 4292376952 4292378493 4292701305 4292507751 4292772477 4292839810 4292971392 4293102196 4293038194 4293363060 4293434235 4293431428 4293705886 4293971110 4293433747 4292710802 4293102456 4293436310 4293107093 4292110702 4291781752 4291913844 4292113272 4292048513 4289284432 4283635800 4284029508 4283764030 4284489029 4285016915 4284029764 4284357186 4284555080 4284685639 4286131018 4286458953 4287379022 4287184465 4286654022 4287968332 4286264653 4286456391 4287049548 4285400890 4284025140 4283565622 4285539925 4290937469 4292648859 4289815913 4289024365 4290145134 4292311649 4292441686 4292115556 4291197789 4291857020 4291792512 4292119408 4291790969 4291856760 4291594111 4291921267 4292119168 4291594361 4291265662 4291527024 4291331197 4291462783 4291462773 4291528318 4291331196 4291396476 4291002749 4291197802 4291462782 4290870905 4291528316 4291067769 4290674533 4291068286 4291197024 4290477693 4291196266 4290080376 4289162875 4291918438 4292650110 4293635187 4293706375 4293639812 4293904268 4293838749 4294101919 4293513632 4294102689 4293708707 4294036638 4294101919 4294036382 4293512861 4293512872 4294232743 4293578663 4293840033 4293839788 4293512107 4293839538 4293907637 4293511858 4293577650 4293250736 4293840553 4293840308 4293579182 4293839536 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4286917447 4286455112 4286324552 4286979400 4286850888 4287309127 4287246152 4286719048 4286719816 4287307080 4287177287 4287574858 4288426569 4288760925 4291192689 4291852140 4292379776 4292972155 4293431667 4292907403 4293302661 4293237630 4293564799 4293566336 4293565822 4293501573 4293501573 4293566850 4293565054 4293495148 4292836977 4292369487 4290790479 4287573833 4287377478 4287703630 4289281881 4291790494 4289153120 4289214033 4289674828 4290070633 4291329419 4287513455 4285210432 4284744786 4284227662 4287849612 4288837288 4285144389 4285147495 4284620356 4285213525 4285146446 4284227161 4285018210 4285672298 4285674080 4288373677 4286661732 4287453069 4285742712 4286071678 4286200684 4284687192 4288048284 4286268275 4283961931 4285213025 4285480041 4288508071 4288380840 4288511912 4283437903 4282515509 4290207597 4288494677 4289550714 4292122792 4293118910 4293313721 4293774000 4293248687 4292588956 4288032317 4289286235 4287901524 4289547086 4291404962 4290347112 4282777648 4283960894 4284090685 4283894839 4287704652 4288695885 4283959608 4285404224 4283893817 4285997125 4285864517 4285603138 4287051086 4286262089 4286588492 4284684345 4284745539 4285469245 4288434791 4287247178 4288500825 4288818759 4288952649 4290985802 4291972440 4291321174 4292367718 4292699999 4292435551 4292109671 4291911513 4292502879 4293026407 4292569442 4293158756 4292701034 4293095532 4292703594 4293095532 4292766569 4292374630 4293619568 4292176995 4293028970 4292896859 4292632161 4292372838 4292439402 4292637033 4292574318 4292439657 4292639852 4292964457 4292574832 4292376423 4293159533 4292111211 4292830822 4292567394 4292698475 4293093737 4292897917 4292900721 4293228935 4292770677 4293420667 4293487483 4292835703 4292309866 4290135913 4291255899 4291588218 4292245881 4291784302 4285011005 4284029769 4283961670 4284357699 4284620619 4284422983 4284686411 4284423497 4285014859 4285013316 4286067021 4285932615 4286852172 4287184206 4287311433 4287050575 4287507017 4285800264 4287116620 4284879161 4284025141 4284483654 4284617022 4290938501 4292123291 4289220701 4289485671 4291586917 4292050267 4291790199 4292114783 4291854455 4291857018 4291791738 4292119161 4291858311 4291397240 4292316547 4291134067 4291199613 4291462775 4291133561 4291331445 4291001975 4291134325 4291725699 4291002492 4291199097 4291005561 4291462012 4291068541 4290936697 4290740091 4291133831 4291199601 4291067771 4291263851 4290805628 4290670698 4290606712 4289884782 4289881964 4291134327 4293107578 4293375112 4293638788 4293968783 4293838216 4294036897 4294037152 4294037164 4294037152 4294036382 4294036381 4293512862 4294037153 4294102689 4294168224 4293579167 4293643943 4293773477 4294233767 4293054894 4293905844 4293251237 4293512626 4293513397 4293775534 4293249721 4293645475 4294233276 4293579686 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285930824 4285996872 4286586696 4285800008 4286390856 4286848072 4286720840 4287310152 4286784584 4286783048 4286586440 4287573830 4287903309 4288168539 4291257701 4292113786 4292772989 4292972672 4292972678 4293302660 4293237374 4293237893 4293567107 4293565048 4293501575 4293765243 4293501058 4293501316 4293564279 4293493873 4292836960 4292043608 4290069839 4287638344 4287373123 4288165210 4290672020 4290077039 4288295247 4289740363 4289219420 4291389055 4291527576 4287706218 4283896638 4283632724 4286464633 4284291657 4286993295 4285278051 4285082194 4284950365 4285608559 4285476451 4284751703 4283506010 4284817236 4285744263 4288315565 4286398065 4287715990 4288043915 4285677420 4285610612 4285475192 4285081938 4288574634 4286659197 4284690281 4287060390 4286728579 4288314033 4287713151 4288244391 4287850407 4293631911 4289360558 4288308897 4291340207 4293245111 4293708735 4293446074 4292724151 4289283652 4288957273 4289480532 4288691799 4290674041 4292659378 4282908719 4283437392 4283633456 4284554060 4284025919 4285274173 4288232018 4284091192 4284879412 4285010494 4285600316 4285406525 4286063945 4287047752 4286262346 4287705163 4283958067 4285074750 4285203252 4288703091 4287443270 4288695390 4287114311 4289081674 4291117643 4290990165 4292103511 4292433768 4292109919 4292109407 4292699482 4292630881 4293089888 4292437342 4292567908 4292370797 4292832352 4293028459 4292507257 4293095018 4293095274 4292834412 4292443246 4292634447 4289735748 4289343814 4290464324 4291516744 4291845970 4292044125 4292503135 4292307035 4292107618 4291912284 4292169806 4291841868 4291843664 4292173127 4291973710 4291776851 4291118419 4292695904 4292565340 4292310373 4293028962 4290066758 4290063420 4291117906 4290991440 4289542220 4289872720 4291520612 4292771964 4291919489 4289613926 4284422212 4283701326 4284355907 4284619586 4285146187 4284226114 4284291907 4284290364 4285800262 4285340484 4287183953 4285470016 4286789196 4287374924 4286064968 4287906386 4286259271 4285600319 4286457417 4286062654 4283893556 4284483646 4284156738 4291130492 4292123030 4289484655 4290670444 4291261031 4291918961 4292836704 4292052845 4291458414 4291659648 4291857520 4291791478 4291856514 4291988080 4291199863 4291988346 4291593597 4291396982 4291659907 4291265395 4291199098 4291528576 4291396219 4290676594 4291068286 4291659382 4290414462 4291133829 4290936697 4291199613 4290676586 4291264883 4291199602 4291199869 4290805112 4291132781 4290279801 4290146169 4289686882 4291987330 4292387683 4293832323 4293836938 4293838474 4294036898 4294036381 4294037922 4294036124 4293512862 4294102688 4294037164 4293512861 4294101917 4293773473 4293774498 4293838753 4293578650 4294168245 4293579173 4293511605 4293645477 4293841847 4293840049 4293709998 4293644463 4294168753 4293840062 4292989098 4293841589 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4286128968 4285733954 4285602883 4286587720 4286455880 4286850888 4286784840 4287306824 4286784072 4286717000 4287769415 4287573832 4287183436 4289810016 4290995068 4291855728 4292378760 4292971898 4292973184 4293697919 4293631871 4293173127 4293566078 4293567367 4293764472 4293501319 4293500800 4293698680 4293564281 4293495405 4292900192 4292107349 4289677399 4288295505 4286781506 4290937243 4291130760 4288952401 4289016911 4289280087 4290866052 4292839577 4291001477 4287047767 4284488800 4285934677 4287515525 4283565112 4284227646 4285145683 4285345365 4284622939 4286004584 4285411944 4285211746 4284290396 4284356964 4286271874 4288777649 4288244130 4287650710 4286531959 4287980189 4286924403 4285941359 4284685421 4285346394 4288311715 4288313773 4287191169 4284686938 4286272120 4285150842 4285801801 4291066753 4289820304 4289419622 4291862419 4292786872 4292392626 4294102463 4293053109 4289688952 4287902279 4289155163 4288822360 4289682022 4293449932 4287054670 4283367496 4284553787 4284554310 4285472840 4283960377 4284813107 4287182671 4285276229 4284417850 4285207866 4284944953 4285471293 4286128714 4285668411 4287048778 4287511377 4284811062 4284155955 4285205305 4288565852 4286325832 4288826203 4287313738 4288162374 4289807439 4290856006 4291778907 4291777609 4291649636 4292830569 4291911514 4292110177 4292106842 4292501350 4292110941 4293225052 4292702827 4293487470 4292964217 4292770412 4292899709 4293096301 4292967537 4291449940 4289084495 4289542744 4289407558 4288357704 4289210951 4290065219 4290394694 4290590278 4291115844 4291119689 4290461262 4290263626 4289803339 4289015624 4289276229 4289933127 4291050831 4291776340 4292233814 4292302427 4291312735 4289939019 4289082457 4289808987 4291385966 4290991705 4291388767 4292703610 4292051071 4292244846 4285406019 4283699013 4284094789 4284290364 4284356169 4285603912 4284290115 4284290115 4285342280 4284685122 4286327630 4286590794 4285406532 4287969874 4286656075 4286787915 4287773009 4286392136 4285071926 4287117134 4286590027 4284615736 4284158533 4284419394 4288962432 4291992202 4290143093 4290936967 4291915356 4292445552 4292245854 4292444784 4291593322 4292187017 4291396727 4291860358 4291856504 4291265655 4291988089 4291463033 4291594105 4291331446 4291856001 4291265404 4290808182 4291396467 4290479742 4291331200 4291068274 4291199097 4291462012 4291199353 4291133810 4290151040 4291330427 4290871162 4290871164 4291263852 4290870905 4290345594 4290211959 4289293422 4290211182 4292182892 4293110141 4293703301 4293770632 4294036366 4294037153 4293709476 4294036906 4294037921 4294102431 4293513633 4294036381 4294101917 4294036394 4293513116 4294167464 4293579421 4293838763 4294102695 4293644455 4293710255 4293839548 4293250209 4293514681 4293513140 4293382326 4294168486 4293579698 4294234290 4293774770 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285602887 4285800524 4285733954 4286062153 4285866568 4286980168 4286852680 4286783560 4286848584 4286850887 4287112518 4287576663 4287838055 4289548373 4291126117 4291590783 4292968569 4292972662 4292973182 4293238150 4293631871 4293566850 4293566851 4293369970 4293500804 4293698680 4293699709 4293697916 4293563000 4293100915 4292573549 4291782246 4290070351 4287636052 4290275977 4291987366 4288562004 4289080909 4288950861 4289418864 4292312212 4290868092 4290341511 4286590046 4284160835 4286661231 4284948291 4284226646 4283564614 4285541463 4285543800 4285213779 4285544820 4285212243 4285086306 4285475965 4284291168 4286598279 4288839344 4288116389 4287254916 4286796154 4287187858 4287191431 4287980203 4286926199 4285742470 4287056245 4289566383 4286991233 4285012810 4285348476 4283765580 4286530161 4291129996 4291261038 4292962908 4292891488 4293117884 4293714124 4293447364 4292523685 4287972432 4289807701 4288492116 4289549928 4292986041 4289890928 4282581056 4284355893 4285078598 4285272378 4284552504 4284093502 4284747059 4286064461 4286522179 4284290618 4284943930 4285996613 4285340743 4286128968 4285667907 4285803082 4287575888 4285272893 4285075782 4284353855 4288695916 4287113800 4287511631 4287444817 4288360009 4290002508 4290199118 4291318611 4291451737 4292369243 4291979105 4292236376 4292172635 4292043099 4291977316 4292435565 4293224814 4292634218 4292570217 4292831848 4292770156 4293163119 4292704364 4292901742 4292238440 4292107368 4292763491 4291648868 4291184217 4291380306 4290722642 4291315799 4292298576 4291973472 4292564073 4292104542 4291581029 4292041310 4292103276 4291710811 4292040541 4292102240 4293283686 4292961668 4292960640 4293095552 4292700821 4292828533 4292042609 4292112762 4292110695 4292571001 4292640874 4292507260 4289809240 4283370825 4284029252 4283832399 4284619586 4284687435 4284620875 4283765823 4283898184 4285209148 4285338431 4286723918 4285471559 4285865287 4287839311 4286722123 4286655563 4287773265 4286390856 4284681783 4286461005 4287117145 4284484924 4284551493 4284092221 4288696683 4292842624 4290079607 4291660672 4292113755 4292118140 4292378718 4292052074 4291592820 4292119161 4292186504 4292118903 4292185209 4291528569 4291528578 4291790717 4291528578 4291988088 4291331455 4291462782 4291593855 4291396476 4290873732 4290936183 4290939270 4290939013 4290873718 4291133564 4290742147 4290739062 4291462515 4291134077 4291330683 4290936946 4290476922 4290870125 4290015339 4290016113 4290276460 4292120952 4293042823 4293835126 4293904267 4294036641 4294037152 4294102442 4294037921 4293512614 4294103470 4294036896 4294101917 4293513633 4294101917 4294167452 4293774249 4293840304 4293579164 4294167976 4293709990 4293250480 4293840561 4293841076 4293840037 4293842360 4294234022 4293579688 4293840052 4293775795 4294102448 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285144905 4285864770 4286128969 4285603394 4286586696 4286388808 4286260040 4286850120 4286847815 4286195530 4287179336 4287579739 4287711570 4290007429 4291323489 4292116096 4292708209 4292972157 4292972408 4293697917 4292976506 4293631617 4293566850 4293567110 4293566851 4293502088 4293501318 4293500800 4293629558 4293429098 4292573547 4291648093 4289935962 4290147723 4292187563 4288626502 4288096066 4288688719 4288952924 4290996352 4292116631 4290535542 4289812857 4286528867 4285212752 4285015124 4286198874 4284682556 4285080412 4284026688 4284620864 4283437383 4286267502 4285343597 4284754510 4286988156 4283830877 4286140812 4289572550 4288639648 4285080682 4286598272 4287385990 4286663326 4286599541 4287979662 4286861180 4286992256 4285278051 4286729845 4287254677 4284954220 4287123600 4289162136 4292970102 4293817171 4292110181 4291711841 4292449410 4294567121 4292855227 4289360234 4288757341 4288562257 4289483354 4292321936 4292461988 4284089920 4283241801 4284686925 4285208891 4285210184 4284226630 4283895614 4284814911 4286260809 4286194763 4284681522 4284551994 4285736267 4286324290 4286128970 4285668930 4285998410 4286986320 4285208643 4284551997 4284616512 4288041063 4286062662 4287707982 4287575117 4287247180 4289673289 4290135114 4291710556 4291581522 4291451480 4292108629 4291845472 4292433505 4292108634 4292042854 4291977053 4292568171 4292110695 4292898154 4292831848 4292639104 4292378219 4292966525 4292704364 4293228143 4292308584 4292370015 4292501843 4292502870 4293088103 4292433261 4292826462 4293086293 4292958815 4293483889 4292503674 4293353079 4293554821 4292968615 4292837555 4293102234 4293036212 4293108386 4293175472 4292979898 4292981672 4293293965 4292501891 4292504710 4292182122 4291918717 4292639078 4292770687 4291455583 4284879686 4283830597 4284292427 4283897925 4285078339 4285865285 4284356682 4284160574 4284422205 4285538373 4285014858 4286851659 4284815944 4286457671 4287774282 4286656588 4287179848 4287641423 4287050062 4285206329 4287048781 4287052876 4284420925 4285206842 4283697215 4287448156 4292254356 4290346891 4292116334 4292376422 4292970616 4291918175 4292314233 4291396727 4292055662 4291398262 4291857273 4291659392 4291528569 4291594103 4291528578 4291331188 4291528579 4291396980 4291659906 4290936955 4290936947 4291659391 4291199354 4291133810 4291133565 4291133811 4291068541 4290936441 4291528051 4291068286 4290739319 4290675316 4291396221 4290674540 4290606200 4290476923 4289292642 4290668906 4292447353 4293177476 4293836938 4293839005 4294037153 4294037665 4293709229 4294102430 4293840549 4293578139 4294102688 4293512617 4294168737 4293512604 4293579177 4293839527 4293579175 4293644455 4293841069 4293251240 4293775536 4293774770 4293841845 4293841075 4293643448 4293644466 4293644466 4293840553 4293839527 4293579176 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285406275 4285275971 4286128969 4285996616 4286520904 4286392392 4286917192 4286850888 4286848072 4286848071 4287771209 4287378510 4288299869 4289417809 4290340480 4292377454 4292510835 4292970112 4293365114 4293238662 4293631873 4293370227 4293566595 4293567111 4293502829 4293699453 4293698681 4293567107 4293300100 4292708482 4292573299 4291187576 4291130510 4292251809 4288693065 4287113028 4288426313 4288622159 4289744223 4292117641 4289747574 4290532700 4289155450 4287839848 4285934699 4285012805 4287783590 4285409871 4285015373 4283303752 4284683865 4283501886 4286468232 4285869142 4284882505 4286929825 4283105347 4286470035 4290228665 4288179106 4284818775 4284621420 4286468491 4287455896 4287522461 4286594430 4286201458 4286596736 4284161874 4284819546 4288112286 4286928278 4288312998 4288966291 4292313745 4293163621 4292831837 4291709019 4291522418 4293320148 4291201145 4288951626 4289088857 4291127912 4292846989 4293249970 4286658626 4283110727 4284687693 4284554822 4285014093 4285013315 4284617787 4284093504 4284420409 4285601855 4285799748 4285865287 4284549939 4284814405 4286260555 4285274171 4286194249 4285866823 4287572553 4286128969 4284418366 4285602108 4286988881 4286195529 4287772497 4287052113 4287047497 4288229705 4289741391 4290661698 4291383385 4291382609 4291975524 4292038223 4291909724 4291714913 4292303711 4291977566 4292501351 4292435557 4292567915 4292897641 4292835949 4292770158 4293096043 4293097328 4292640880 4293160812 4292896098 4292370031 4292631385 4292435040 4293680473 4293025376 4292169058 4292825956 4293348955 4293747056 4293290120 4293033875 4293497465 4293701281 4293635470 4293632905 4293635739 4293637802 4293706169 4293307804 4293554560 4292304496 4292308866 4291918201 4293035146 4292570227 4291392881 4287575373 4283765059 4284224571 4283633225 4284555078 4285012547 4285407051 4284157496 4284091450 4284684607 4285668926 4285405244 4285470270 4285798723 4286918732 4287579997 4287178055 4287575887 4288360777 4285666372 4285537091 4286984269 4287512657 4284748356 4284485444 4284617797 4287774306 4291861916 4291525759 4291855229 4292049246 4291855467 4292836454 4291462261 4291922545 4291856260 4291463807 4291857791 4291661429 4291528313 4291528579 4291922295 4291922298 4291922296 4291594115 4291396980 4291659907 4291790713 4290807676 4290938997 4291067773 4291071096 4290871680 4291396732 4291133820 4290873733 4291462269 4291199600 4291528063 4290151281 4290608250 4290081132 4289754490 4289358204 4291064420 4292317318 4293506177 4293967992 4294037669 4294036895 4294037678 4293513373 4294168738 4293774756 4293775012 4294102432 4293644446 4293774765 4294102696 4294166961 4293579945 4294167718 4293840310 4293840294 4293840309 4293185715 4294234291 4293578673 4293645226 4293644456 4293644445 4293839785 4293839777 4293579424 4294101919 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285538117 4285079626 4285798722 4286127945 4285932360 4286455368 4286979656 4286325320 4286454085 4286259271 4287115596 4288102222 4288366435 4289413981 4291258475 4291588991 4292837739 4292513660 4293366151 4293236095 4293632126 4293172617 4293371513 4293565564 4293501316 4293501318 4293501317 4293566333 4293300622 4293172638 4291395489 4290734991 4291462301 4288693584 4287243076 4287508551 4287834956 4288691034 4290536318 4291596197 4289218411 4290137190 4287975283 4285802835 4286659198 4285672014 4289436089 4286130529 4283696959 4283961674 4283305284 4284819043 4287258515 4285607008 4284422231 4287126153 4284488289 4287065238 4290095031 4288770980 4285410414 4284161107 4286203762 4285741695 4286796946 4288577459 4287322504 4286268024 4285609583 4285213522 4286791524 4286532228 4288970683 4289097369 4291528872 4293030747 4292368232 4291125612 4292067016 4292329645 4286784316 4289879145 4291126882 4293632381 4292781957 4289093210 4283041342 4284426320 4284090697 4284555339 4285406013 4285144390 4284684349 4284618297 4285139000 4284420658 4285996613 4285537086 4284945721 4284749113 4285471293 4286194249 4285472840 4286064200 4286461005 4286064200 4284880189 4284486979 4286525516 4286454846 4287709009 4287182414 4286586950 4287969872 4289608778 4290529365 4291119182 4291448915 4292301923 4291188571 4291908183 4291582814 4291712093 4292498791 4291977304 4292568676 4292106082 4292374119 4292900460 4293160553 4292965501 4292640623 4293554543 4292705134 4292833386 4292374375 4292106340 4292305248 4292040024 4292042086 4293220198 4292435310 4293089118 4292957532 4293287788 4293489012 4293227143 4293227389 4293231750 4293228927 4293226110 4293225595 4293033617 4293229712 4292107371 4292310662 4291917688 4292510330 4292705641 4291917943 4291388263 4284090430 4283895349 4284289866 4283895615 4284226372 4285405757 4285208638 4284552762 4284223290 4284815679 4285273405 4286919247 4284550194 4284944189 4286786380 4289022552 4286457931 4287773518 4287118415 4286260295 4286522952 4286259781 4288041052 4285009717 4284487236 4283962180 4287445858 4292319890 4291135372 4291789686 4292510828 4292905852 4291919460 4292182897 4291594104 4291661430 4291924342 4291857535 4291857791 4291529599 4291792756 4291528323 4291528568 4291528570 4291594105 4291594106 4291659641 4290742140 4291265150 4290807686 4291790968 4291396221 4291067510 4291462259 4291068275 4291133821 4290479216 4291330684 4290871154 4290870649 4290476920 4290936698 4290013035 4289425007 4290211440 4292515452 4293834115 4293904267 4294036897 4294038952 4294038177 4294103214 4293512346 4294103457 4293773994 4294103457 4293578922 4293773982 4293774764 4293645983 4293839283 4293645226 4293577889 4293841080 4293841063 4293841069 4293775531 4294168737 4293643933 4293839008 4293644962 4293839264 4293773729 4294102176 4294035851 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285867084 4285535804 4285799748 4285734979 4285996104 4286520648 4286389320 4286521160 4285865288 4286454343 4287180617 4287247695 4289086555 4288627280 4291257187 4291851375 4292577411 4293363327 4292972922 4293302905 4293172358 4293632901 4293566594 4293501318 4293699453 4293698680 4293502859 4293566332 4293301395 4293037196 4293045913 4291655041 4290466639 4287568707 4287044424 4287506756 4287703894 4289679732 4291926955 4289547366 4289674605 4290204773 4288366195 4284748871 4285538905 4286734733 4288771478 4285012036 4284291149 4284161347 4284223064 4284952153 4287192225 4285077823 4288041886 4284363872 4286394237 4288517308 4289236903 4287585690 4288246951 4284091724 4286071676 4286533511 4284157785 4286139766 4288906428 4287060116 4288177037 4286597775 4287456939 4286860670 4289829046 4291268522 4290082711 4292707230 4291312472 4292118407 4294107590 4289096568 4289547874 4291984238 4293760109 4293514404 4290275698 4282912579 4284096336 4284751430 4284423492 4284948039 4285080909 4285211212 4284687182 4284421693 4284552247 4284817995 4285407052 4285406531 4285342283 4284617527 4285601852 4286197836 4286127176 4285603648 4286590538 4286654795 4284943928 4285143369 4286790996 4286788436 4287774288 4287247182 4286784583 4286982470 4288757587 4289611590 4290792791 4291120724 4290925396 4291711309 4291121231 4292302429 4291646555 4291715676 4292108128 4291847271 4292042338 4292108904 4292308069 4292702332 4292374371 4293161837 4292442749 4293161837 4292767849 4292765290 4292109161 4292307806 4291977300 4292236637 4291714146 4292436313 4292895331 4292959583 4292957540 4293551232 4293093494 4293355143 4293291909 4293290887 4293289863 4293355655 4293420935 4293156468 4292045443 4292312707 4292510328 4292313738 4291784299 4291456114 4287509322 4283829056 4283965263 4284096335 4283831359 4284226111 4285669956 4284422724 4284684350 4284750143 4285733695 4285207869 4286260810 4284552505 4285797184 4287246668 4288366426 4286588232 4287052620 4287116879 4287374662 4286392904 4285667655 4287974481 4285338429 4284945475 4284225096 4286331996 4291924881 4292186498 4292249723 4292706932 4292120957 4292442726 4291528826 4291856514 4291923072 4291462522 4291661430 4291856250 4291528568 4291593859 4291333235 4291987843 4291528568 4291594106 4291594106 4291659641 4290939520 4291593589 4291528053 4291528064 4290807931 4291199355 4290348163 4291134076 4291133819 4291068544 4290542970 4291132783 4291003506 4291002233 4290082682 4289623407 4289425008 4290864995 4293039225 4293376904 4294102690 4294038436 4294037921 4294038191 4294037407 4294103986 4294037664 4293708449 4294036895 4294037674 4294103993 4294102950 4293382071 4293644464 4293579431 4294169528 4293775275 4293776303 4293643675 4293643933 4293643934 4293446813 4293839523 4293446282 4293969820 4293773197 4293838747 4294036897 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285405507 4284552247 4285930309 4285798979 4286127689 4285994309 4286586952 4285996104 4286061640 4285734215 4287640652 4289083979 4287514976 4289412945 4290666345 4291390566 4292640877 4292971122 4293168251 4293235591 4293631868 4293370487 4293566339 4293699452 4293699452 4293501319 4293764986 4293566850 4293301635 4292708739 4292966004 4291255649 4289675079 4287835719 4287046726 4288032600 4288296026 4291792289 4291131524 4289018475 4289480538 4290473341 4286660194 4284750692 4284224576 4288776619 4288440201 4283829049 4284029254 4284946779 4283307334 4286535047 4286990982 4283502413 4286464885 4286726021 4285610088 4290161853 4287915951 4286134883 4288516543 4286989199 4286136433 4288443570 4285215591 4284950108 4286072690 4289496248 4286857080 4288710587 4288971431 4287779984 4287850382 4292517294 4291530133 4290999949 4291314533 4291133573 4292922305 4289615979 4291917946 4293431923 4293904549 4291199605 4285211451 4283701601 4285014858 4283833926 4284424781 4284621388 4285801805 4284424268 4285344592 4284359499 4284555339 4285014602 4285144901 4284946755 4284949323 4285669189 4284949839 4285079367 4286195527 4285736523 4286001485 4286656330 4285277005 4284945467 4286196300 4286918996 4286788426 4286198862 4286324039 4287181130 4288358982 4289936717 4290004551 4290922317 4290789958 4291515475 4290991958 4291384925 4291124828 4292107108 4291780700 4292110951 4292373097 4292307303 4292765035 4292506469 4292700777 4292767847 4293160553 4292703594 4292834925 4292242534 4292569194 4292633451 4292109418 4291977309 4292042860 4291977555 4292302176 4292235613 4292761696 4292959327 4292829544 4292763241 4293357948 4293092716 4292960361 4292434535 4292694117 4292110947 4292509559 4292248457 4292441461 4292246381 4291851378 4289874504 4285865792 4284089923 4284686409 4283831359 4284357699 4284816976 4285076291 4284161350 4285734979 4283767108 4285667902 4285867333 4285865796 4285142329 4285600320 4287772748 4287577418 4286522697 4288364361 4287703627 4286659152 4286389063 4286257478 4288567132 4284944955 4285537350 4284551748 4287183205 4291924625 4292055444 4291525739 4291920744 4293233269 4292182114 4291659632 4291923841 4291528047 4291529591 4291923584 4291923573 4291528578 4291528566 4291988360 4291464052 4291988608 4291528568 4291594105 4291396736 4291527796 4290939528 4291136126 4290807668 4291724671 4290544512 4290807667 4291001977 4290413954 4290413944 4290936183 4290870649 4290936698 4290081645 4290475631 4289687663 4289488253 4290212450 4292712834 4293574544 4294103201 4294037420 4294038189 4294037418 4294038436 4293512345 4294037677 4294103213 4294037664 4294037417 4293513894 4294038200 4294169256 4293710506 4294102965 4294102953 4293514145 4294167967 4293578398 4293839266 4293773730 4294167178 4293641629 4293641374 4294167966 4293773986 4293969560 4293708193 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285344081 4285471556 4285338685 4285274948 4285404733 4285802052 4286127178 4285734468 4285668675 4286388551 4287509838 4288563795 4288296781 4288494416 4291255389 4292637798 4292379007 4292642417 4293232001 4293302901 4293174153 4293371257 4293567110 4293501317 4293500803 4293698680 4293502088 4293566850 4293628545 4293035890 4292507757 4291912520 4289611095 4287899977 4286457925 4287308632 4289814632 4291531946 4288952939 4289415001 4290269278 4289615986 4285274966 4284882258 4285471571 4289500582 4287456134 4283498555 4285274692 4283175498 4283764288 4286864794 4285477979 4283960916 4284358495 4286204551 4286724485 4290170572 4288772787 4284818024 4286404487 4288970939 4287125908 4288445345 4286594429 4285409123 4284749413 4285812092 4288977340 4287984549 4287053162 4290218651 4285540963 4290021295 4290141818 4290087596 4290990687 4291007142 4292728011 4292968305 4293566330 4293634958 4293576074 4285666116 4283702881 4284358469 4284422988 4284687952 4284752460 4285211470 4285143613 4286063427 4284881730 4284617539 4284488268 4285539147 4284815935 4284618043 4284556110 4286455879 4285672010 4285210443 4286196556 4285734722 4286065739 4285998664 4285930307 4284553536 4286128967 4286985550 4286851659 4287445841 4285798982 4286263115 4287376967 4289082957 4290070091 4290529620 4290594385 4289871689 4291121498 4291578970 4291253840 4291712864 4291451735 4292108389 4292042339 4291976552 4292638311 4292632424 4292309623 4292700537 4292638331 4292963965 4292833382 4292897640 4292963946 4292567400 4292242024 4292501091 4292699494 4292042591 4291715426 4291319128 4291449943 4291906388 4291842390 4292433758 4291906651 4291905881 4292103780 4292106081 4292045428 4292448388 4292182427 4292638307 4292705898 4291918452 4290991184 4286719307 4285079365 4283896902 4283895615 4283501629 4284421701 4284554051 4284616502 4285407306 4285079368 4286522953 4284683834 4285601085 4285472839 4285535291 4285535039 4288304216 4287574611 4287115339 4287052108 4287051086 4287377996 4286324551 4286258502 4287840082 4286255934 4284945989 4283898180 4286856811 4292118650 4292121502 4291919722 4292316023 4292446070 4291723390 4291463026 4291529590 4291529600 4291398518 4291528312 4291529597 4291594112 4291594113 4291332217 4291595391 4291528310 4291595656 4291528311 4291793531 4291593857 4291790710 4290611079 4291004292 4290938740 4290545270 4291527539 4291133820 4290870908 4291265405 4290541943 4290348146 4290803565 4290346107 4290278511 4289555823 4288898154 4290405997 4292516991 4293902725 4294038181 4294038692 4294038703 4294038190 4294038177 4294102958 4294037407 4293579425 4293513898 4294103734 4293709494 4294104224 4293711033 4294103722 4294103980 4293513385 4294167968 4293512862 4294233248 4293772940 4293839266 4293773986 4293445283 4293644444 4293839020 4293773726 4293578666 4294101916 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284226632 4285208637 4285209408 4285603400 4285534780 4285468987 4285471294 4285467448 4285731904 4286260554 4287970639 4288431954 4288297553 4289084494 4290666593 4291389547 4292771180 4292247931 4293101167 4292908941 4293632385 4293566595 4293370485 4293501319 4293698937 4293699453 4293699451 4293566336 4293367164 4293166442 4292966514 4291322460 4290200910 4287179337 4287109190 4287310667 4289748342 4291135134 4288364128 4289808987 4289421439 4286200680 4283897143 4284292208 4286657107 4289300899 4287118439 4284027196 4284029516 4283501915 4284886620 4287387534 4285211470 4284554862 4283239743 4284358510 4287981485 4290623162 4289170095 4287186069 4284490857 4289566903 4287194018 4288313771 4286729604 4285939576 4285019249 4286670249 4288247975 4288841130 4288178601 4288107626 4286853739 4288311974 4287972723 4289491091 4290857295 4292065986 4292848810 4292309111 4292975745 4294429841 4286324029 4283240779 4284030026 4284096336 4284751687 4284029764 4284555083 4285078339 4285539919 4285865538 4285407050 4283765815 4284486454 4286193740 4284093768 4285079628 4284687175 4284816970 4285669447 4286521922 4285339196 4285406013 4286128200 4286063688 4285800003 4284751172 4285668680 4286593104 4285735496 4287447634 4285866055 4286389828 4287574858 4289407814 4288886092 4289478216 4290660168 4290397513 4291251536 4290462784 4291319130 4291777877 4291451998 4291910241 4292240996 4292042600 4292108902 4292110457 4292571491 4292964455 4292506983 4292507239 4292309111 4292570235 4292109666 4292636284 4292108646 4292108902 4292700521 4292108903 4292306790 4292374139 4292438119 4291256682 4291188573 4291125342 4291650422 4291979105 4292243574 4292378744 4292773758 4292509830 4292442228 4292439154 4292441223 4291720813 4286123580 4287509326 4284814658 4284157515 4284095303 4284095047 4284158269 4284751175 4285276743 4285012549 4285609291 4285933130 4285275200 4284947783 4285801034 4285077828 4285599292 4288632177 4287444299 4287573577 4287577928 4287708504 4286720840 4286389319 4286260298 4287907665 4285799751 4285867340 4285143365 4285936472 4291660948 4292518544 4291788139 4292708735 4292314736 4291919981 4292250747 4291464063 4291922557 4291529599 4291528065 4291990156 4291528320 4291595388 4291595143 4291593855 4291595655 4291593845 4291595399 4291529596 4291660934 4290939261 4291856246 4291070598 4290938756 4291004548 4290807425 4290676350 4290545010 4290739066 4290347903 4290804859 4290807923 4290145910 4289819246 4289622397 4289421661 4289880942 4292516981 4293904539 4294037665 4294038704 4294038703 4294037919 4294037431 4293513886 4294103728 4293578651 4294168489 4293709737 4294103733 4294037929 4294038197 4294102965 4293512613 4294167196 4294101918 4293839264 4293379746 4293840036 4293578653 4294167454 4294102943 4294167208 4293578650 4294168235 4293513629 4294037163 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285276230 4284552765 4285079111 4285471556 4285142327 4285996358 4285602367 4284945468 4285795389 4286523979 4289682276 4289087054 4288890969 4289482341 4291189595 4292111720 4292244584 4292509807 4293037170 4293694843 4293565817 4293566851 4293567111 4293763701 4293500804 4293501316 4293503114 4293566335 4293630082 4292970357 4292903262 4292109406 4290202450 4287769673 4287043653 4287374411 4289618823 4290347676 4289280079 4289412717 4287512164 4286330456 4285410154 4284422725 4286134620 4288574627 4285274431 4284620873 4283963724 4283107656 4284821343 4286269560 4283636547 4286002527 4283831383 4283633481 4288779701 4290159276 4288182198 4288841635 4285673594 4286408859 4289497269 4288379554 4287650465 4286797194 4288577460 4287517045 4284822902 4288378026 4289034403 4287579001 4284425551 4288970677 4288443544 4287980701 4288960124 4292649642 4292133828 4293763456 4294565274 4289022033 4283308618 4283834447 4284226628 4284488771 4284423496 4284489030 4284488002 4285473611 4285473357 4285996608 4285081167 4284226367 4284751175 4285474379 4284947779 4285407049 4284554309 4285079371 4285474379 4285276235 4285669961 4285801026 4286062664 4286063688 4286130249 4285404733 4284945982 4286129992 4285930311 4287575887 4285933385 4285602634 4286788685 4287837258 4289411148 4289084748 4289478226 4290594376 4290332499 4290596956 4291578967 4291320418 4291648607 4292567403 4291649632 4292042600 4292373094 4292108644 4292832122 4292375158 4292110966 4292962921 4292897639 4292307810 4292440441 4292373347 4292439140 4292440696 4292044149 4292242295 4292965480 4292508009 4292507750 4292966275 4292969350 4293033108 4293033335 4292837242 4292838777 4292836998 4292643458 4292967303 4292373360 4292508026 4292050033 4290073176 4283891767 4287181134 4284554306 4284225100 4283634232 4284225866 4284094524 4285014086 4284619845 4285276745 4285208893 4285147218 4284750143 4285274944 4285205812 4285273669 4284878658 4288892502 4287444298 4287574604 4287577167 4287642954 4286656073 4286390855 4286194246 4287840082 4286588999 4285795132 4285078343 4285080912 4291201665 4292515982 4292312931 4292252288 4292248440 4291658601 4291464321 4291528056 4291858055 4291726709 4291726956 4291528056 4291594103 4291659393 4291464307 4291594113 4291594111 4291594113 4291594102 4291659649 4291659645 4290939526 4291461498 4290873219 4290938740 4291396212 4290151294 4291004288 4290347137 4290413166 4290676355 4290345593 4290673529 4290279801 4289752941 4289097329 4289094771 4289751653 4292777832 4293904538 4294038693 4294038702 4293972910 4293973168 4294037931 4294103714 4294037161 4293711034 4294038198 4294103734 4294038701 4294038200 4294102953 4293513372 4294233504 4293579168 4293643932 4293643943 4293774241 4294102687 4294101673 4293579167 4293578151 4293579948 4293773994 4294037932 4294036907 4294037151 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284816713 4285012804 4285602628 4284816196 4285339973 4285205316 4285074491 4285076286 4284944959 4288231759 4289087318 4289876831 4288824909 4290007141 4291124577 4291455339 4292312172 4292573804 4292904834 4293301114 4293238151 4292977020 4293565820 4293501575 4293764729 4293500802 4293567108 4293566591 4293563009 4293233268 4292507999 4291455078 4290854727 4287640136 4287046994 4287374926 4289611611 4290674585 4289480299 4288501355 4287581039 4286986852 4285538888 4287185522 4285346395 4287121770 4284028488 4284619598 4283569742 4283107400 4285348196 4286926980 4284028483 4285476454 4284554602 4283898715 4287460257 4290553019 4287463081 4287120251 4288775350 4286332284 4289309120 4288378283 4287453841 4287456912 4287521933 4284950381 4286072967 4287065761 4290082712 4289742931 4284486233 4287721359 4287451258 4289360293 4290668163 4292988870 4293906873 4294693532 4292116324 4284618310 4283698763 4284028492 4284161091 4284622416 4284421447 4284226114 4284488255 4285669190 4285734471 4284882504 4285604939 4284222532 4284095042 4285736528 4284943920 4284882500 4285209926 4284029507 4284881471 4285277257 4285867082 4285801035 4286128712 4286063688 4286129224 4285339711 4284748082 4286260042 4285668674 4285932615 4286067277 4284882248 4286457159 4287703367 4287244874 4289543242 4289083208 4290069836 4290594376 4290987078 4290989909 4291907162 4292042340 4291715426 4292237917 4292370279 4292175994 4291979880 4292440696 4292174945 4292832122 4292505956 4292702330 4292767609 4292572516 4292702074 4292701816 4292508005 4292768632 4292507749 4292838284 4292574837 4293101969 4293429132 4292974480 4293366138 4293166467 4293231764 4293034352 4292970378 4292707452 4292311669 4292443515 4292640379 4291982439 4285993538 4284747581 4287379534 4284029506 4284091206 4283831871 4284620360 4284096070 4284750917 4284553796 4285868875 4285013576 4286523720 4284355901 4285866571 4285076024 4285012293 4285468989 4289616225 4287510349 4287573576 4287510855 4287575119 4287837260 4286129735 4287311689 4287773009 4286458699 4284681784 4285670216 4285536323 4291400851 4292451486 4292249974 4292711560 4291917659 4291462775 4291989376 4291529333 4291923326 4291529086 4291531140 4291594885 4291726212 4290940810 4290939013 4291725184 4291659647 4291068541 4291725185 4290873973 4291266447 4291790718 4290219390 4291135878 4290741375 4290939012 4291264634 4290479233 4291004273 4290348423 4290410871 4290871163 4290083435 4289819512 4289031296 4289228656 4289226114 4289159265 4292387716 4293904279 4294037665 4293973177 4294170798 4294170787 4294038705 4293514403 4294038177 4294038189 4294038177 4293513127 4294103715 4294037406 4293513385 4294168749 4293512602 4293839530 4293578406 4293774764 4294168748 4293513374 4294103458 4293708451 4294102688 4294036381 4294036637 4294036381 4294036638 4294036382 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284684606 4284488774 4284551741 4285601090 4284881731 4284947524 4284816450 4284881732 4285996361 4288168011 4289939532 4288825953 4289742680 4289807701 4291258213 4291782248 4292770157 4292115814 4293101425 4293235330 4293632127 4293632387 4293566850 4293566079 4293565824 4293567365 4293566593 4293566591 4293627266 4292970359 4292902496 4292108635 4290332501 4288231500 4287571014 4287571779 4286987353 4290013843 4289813114 4289287278 4287050846 4285739354 4285869153 4288043394 4286858865 4286659687 4284620615 4283962446 4283632715 4283501643 4286006125 4286857840 4283108167 4285212240 4285408599 4283960667 4286799507 4288905373 4286732681 4286338457 4288047513 4287255699 4287264922 4288908473 4287321742 4287981723 4286597764 4285873768 4285675904 4285611371 4288446635 4291645816 4291118948 4289101220 4285477729 4288045967 4288757592 4292583048 4294497977 4291137396 4283959615 4284228172 4283570767 4284621900 4284425036 4285015375 4284620614 4284818510 4284881738 4285143102 4285866571 4285932354 4284947524 4284029245 4284488259 4286064203 4284487742 4285536836 4286062660 4284619070 4284289599 4284746549 4285933389 4285406789 4285340731 4286128713 4286131020 4285470013 4285142073 4285603658 4286130248 4285996616 4286657615 4285339195 4285997129 4287311687 4286520647 4288095303 4288821837 4289152334 4289543505 4290004815 4291316553 4290595153 4291841371 4291847005 4292436076 4291781733 4292044899 4292306792 4292702564 4292440440 4292309110 4292570979 4292506981 4292375671 4292311419 4292900968 4292967802 4292837767 4292575351 4292640890 4292769892 4293102487 4293168264 4293301388 4293302411 4293302671 4292972687 4293034366 4293033873 4292576647 4292707449 4292379030 4292508277 4292117354 4289813352 4283498540 4285076542 4286196556 4284224322 4283635272 4284291397 4284030543 4283831620 4285079111 4285278289 4285472323 4286330190 4284881735 4285141558 4285996356 4284422463 4285340484 4285995327 4288831842 4288231755 4286918733 4288431705 4286985037 4287181385 4286784839 4287115596 4287773009 4286392138 4286061384 4286193221 4284619079 4291595660 4292452756 4292249717 4292712333 4291655008 4291331970 4291593848 4291334268 4291922303 4291334521 4291593344 4291662217 4290939013 4291724925 4291792006 4290939254 4290939270 4291790718 4290873990 4291724929 4291137398 4291790721 4290938741 4291070327 4291136134 4291069826 4290282621 4290216577 4290410874 4290870639 4290413696 4290476922 4290345592 4290016889 4289622637 4289227878 4288634736 4290011755 4292912773 4293707934 4294038948 4293972921 4293972910 4293972901 4294037922 4294037409 4294037420 4294037419 4294038434 4294102442 4293512602 4294103213 4293513372 4294036648 4294103212 4293513385 4294103201 4294103201 4293513385 4294103470 4294036381 4294036638 4294036382 4294036639 4294036639 4294036639 4293838489 4294036896 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284878650 4284880184 4285272639 4284749111 4285013067 4285076548 4284684348 4284554823 4286126144 4287903824 4289679968 4289742422 4288629333 4290531418 4290994789 4292438373 4291654246 4292576886 4293036161 4293498234 4293632128 4293238649 4293237638 4293041787 4293370743 4293566594 4293501574 4293567107 4293562229 4293560952 4292835420 4292108893 4290201419 4288229961 4286978630 4287442769 4288952657 4289090157 4288433254 4289285742 4287316853 4286525781 4285938279 4286989156 4287320434 4285675114 4284687193 4284161360 4283568971 4282976587 4286532715 4286855806 4283307332 4283503687 4285867874 4285606768 4286731125 4288642982 4286730132 4285875847 4287652238 4287919525 4287651232 4288511662 4287917731 4288116647 4287982245 4287324069 4285217899 4285345900 4289169333 4289223045 4293282386 4290151341 4284820051 4286928264 4288370048 4290278786 4292334541 4285015359 4283505223 4285276745 4283962947 4284552519 4284684618 4284357446 4284293195 4284357704 4284616502 4285604936 4285804366 4285864514 4285078336 4284027453 4284814921 4286064203 4284618301 4284357445 4286128708 4285140798 4284552503 4284817485 4285601083 4286324810 4285798723 4285668162 4286194249 4285407303 4285535806 4285471805 4286129481 4285668931 4286259266 4285798724 4285012547 4287510606 4286850631 4285533506 4287110984 4289016905 4289150287 4289609800 4290461519 4290397511 4291055177 4291384668 4292106838 4292373354 4292373096 4292108903 4291914345 4292438886 4292964708 4292505482 4292768628 4292375413 4292768374 4292639866 4292771191 4293034131 4293299588 4292708235 4292903577 4292970121 4293367934 4292975781 4293365629 4293301135 4293367695 4292774295 4293497228 4292644745 4292510857 4292770422 4292247689 4292577389 4287179591 4284024906 4285276229 4287047240 4283569224 4284290378 4284028485 4284029500 4284818254 4285146444 4285998153 4285406532 4286261321 4284551734 4286326347 4285671240 4285010232 4285928256 4285603650 4289550442 4287445078 4287574859 4287644763 4287706960 4286653513 4286654534 4287771724 4287772495 4285866820 4286589256 4285536856 4285537868 4291530637 4292321690 4292117870 4292843661 4290932332 4291856249 4291528322 4291728252 4291923060 4291530895 4291398514 4291660678 4290807410 4291726726 4290742145 4291593341 4291659647 4291331464 4291528059 4291790720 4290153595 4291135878 4290807674 4291921792 4290545027 4290676354 4290544769 4290675834 4290084991 4290476409 4290348157 4289951863 4290411128 4290016888 4289819002 4289227894 4288635240 4289687918 4292981908 4293840803 4294038704 4294236332 4293972912 4294038693 4294038180 4294038180 4294038180 4293513374 4294037422 4294036891 4294037676 4294037417 4294038189 4294038189 4294037676 4294036894 4294037666 4294037923 4294036381 4294036381 4294036639 4294036639 4294036639 4294036896 4293838489 4294036896 4293904539 4293772181 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284748607 4284554309 4284422980 4285077566 4284684604 4284552516 4284358474 4284355138 4286456647 4288757838 4288957520 4289810013 4288890710 4289019732 4291520351 4291914601 4292768618 4292509550 4292906109 4293300864 4293238149 4293042041 4293632388 4293436280 4293566852 4293500545 4293763699 4293500798 4293563773 4293299578 4292900972 4291454300 4290069583 4288293958 4286979399 4287509841 4288362055 4289288575 4287581811 4290338419 4286193222 4285082715 4285805425 4284291401 4288834701 4285280858 4284291914 4285081162 4284029004 4283305276 4286793076 4286463864 4283436091 4285146206 4284161876 4286199684 4287517575 4287328145 4287127954 4284553539 4284948337 4284754778 4288049320 4288049316 4288447926 4288773045 4287984292 4288113561 4287584417 4285017703 4289039782 4288766359 4291183467 4291270831 4287449457 4285017180 4288502902 4289089893 4293316275 4284617559 4286859098 4284686931 4283569234 4284163148 4284293708 4284883790 4284225856 4284884046 4284617786 4285871454 4286128709 4285669960 4284161610 4284222781 4285603395 4285736265 4284618814 4284551996 4284882245 4285342282 4284028231 4285011254 4284487999 4285078076 4285406278 4286194505 4285669186 4286259018 4285472061 4284881213 4286194249 4285734467 4286064456 4286129481 4285141819 4286983754 4287377486 4285926979 4285470016 4286716743 4288031303 4288754250 4289086799 4289544783 4290987335 4291384148 4291452511 4292303460 4292171877 4292175207 4292175993 4292240997 4292176758 4292374385 4292575114 4292377977 4292572771 4292903305 4292576636 4293036671 4292973203 4293039521 4293431157 4293167768 4292971919 4293366646 4292972951 4292971896 4293366413 4293366667 4292973454 4292644488 4292574859 4292573542 4292708226 4291589230 4284745528 4283632958 4287050063 4284619588 4283503431 4284554572 4284426063 4283765836 4284818252 4284555340 4285540172 4285408077 4285931331 4284615736 4286132558 4285143101 4285077566 4285340999 4286915400 4288767849 4288299089 4287377746 4288301388 4287051601 4287178568 4287181903 4286591051 4287179596 4286522180 4287051350 4284683074 4284942395 4291599772 4292255132 4292511864 4292382080 4291001196 4291659908 4291529598 4291728251 4291529087 4291857512 4291595144 4291528834 4290939527 4291725182 4291070340 4290939525 4291921791 4290022009 4291004290 4291005063 4291987061 4290939526 4291921791 4290873220 4290938224 4290676356 4291132791 4290413950 4290019195 4290348157 4290150512 4290410871 4290214008 4289885048 4289493105 4288638057 4289159028 4290475900 4293835924 4294102944 4293974194 4293973936 4294038435 4294038694 4294037409 4294036639 4294037666 4294036640 4294038434 4293513141 4294038443 4294037417 4294038189 4294038177 4294037409 4294037923 4294036382 4294036639 4294036639 4294036639 4294036896 4293838491 4294102689 4293838489 4294102690 4293904539 4293970845 4293838489 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284748349 4284552516 4284949065 4284882504 4284420426 4284420667 4285079371 4284357187 4286195278 4287640654 4288298576 4288890445 4289545552 4290201173 4291125856 4292112992 4292177767 4292707184 4293232500 4293301638 4293238919 4293631616 4293370228 4293370230 4293566078 4293566073 4293502602 4293565562 4293563767 4293298034 4292835424 4292241235 4290267731 4287639625 4287634502 4287574357 4287249230 4289088342 4289485937 4286590559 4285146456 4285670757 4285146703 4284553802 4289104296 4285342801 4284096589 4284752985 4284226374 4283701340 4285545570 4286462833 4283174730 4285147739 4283568727 4285412210 4287587481 4288508810 4286865038 4285080423 4284294722 4284225889 4285609851 4286865045 4288446631 4288511915 4286929052 4288642997 4287593393 4287125919 4288179609 4289757095 4291193227 4290873252 4290659407 4287385219 4286597989 4287315807 4284425792 4284950090 4287053660 4283899209 4284228683 4284554825 4286391625 4284291911 4284356928 4284294993 4284161096 4286259014 4286063688 4286195017 4285208892 4284226630 4284684607 4286327628 4284618044 4284555854 4284945717 4286457675 4285010223 4284224333 4285797696 4284226373 4286129996 4285735499 4285798467 4285405757 4285865028 4285538376 4286195273 4285734210 4286129996 4286129736 4285143875 4286458699 4287508810 4285406787 4285467705 4285073464 4286453832 4287046472 4288886090 4289671241 4289740109 4290921542 4291514969 4291714144 4291979368 4291780192 4291913322 4292570725 4292176760 4292964455 4292309624 4292640103 4292115851 4292704887 4292771975 4293296759 4293236375 4292711318 4292974481 4293299596 4293302669 4293299597 4293299852 4293365133 4292974749 4292976026 4293042308 4292904589 4292376952 4292118133 4291988604 4290464856 4284353591 4284551751 4286916679 4284423754 4284162636 4284687694 4284095821 4284161870 4284817995 4284620876 4285669958 4286263373 4285143616 4284615992 4286062660 4284749373 4284816453 4285864259 4286062404 4288831589 4288035928 4287444044 4288237421 4287115595 4287113033 4287707473 4287116107 4287835981 4285998909 4286918477 4286195269 4285008203 4291270281 4292912016 4292250238 4292384652 4291590760 4291199860 4291594106 4291660412 4291267978 4290941843 4291529586 4291004791 4291593598 4291199355 4290939525 4291921789 4290088330 4292118142 4290284939 4291069553 4290219404 4291395707 4290676607 4290873216 4290284417 4290807172 4290022010 4290739076 4290085247 4290804342 4290150784 4289822592 4290148469 4289557631 4289294448 4289291113 4288505464 4290541423 4293115033 4294104229 4294170540 4293973948 4294038436 4294037923 4294037409 4294037666 4294036896 4294037666 4294037409 4294037407 4294037429 4294038188 4294038188 4294037420 4294037665 4294037153 4294036639 4293838747 4293838489 4294102689 4293838748 4293904007 4293772440 4293970848 4293837956 4293772695 4293048462 4293505670 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284358730 4284614211 4284751686 4285211212 4284161090 4284488267 4284224567 4284486455 4285798978 4286723407 4288494159 4289087323 4288759382 4290927190 4291716962 4291914601 4292638828 4292641135 4293234295 4292908926 4293303669 4293566852 4293631872 4293566080 4293566847 4293501059 4293764472 4293501316 4293565053 4293496687 4292834909 4291849050 4290135119 4287900742 4286588999 4287179590 4288034122 4288957034 4289944438 4284093768 4284424007 4284752712 4283763544 4284756059 4288770445 4287055205 4283698259 4285475413 4285870443 4283567930 4286004846 4285673308 4283700554 4284620093 4283831387 4283566157 4288113051 4288905139 4288776108 4285869938 4283897174 4286132080 4285281897 4286337161 4287585953 4287916196 4288182182 4288447149 4288905656 4286995100 4287652246 4288701598 4290478241 4290020516 4286989689 4289218415 4287255136 4288174438 4283766858 4286722131 4283965516 4284032334 4284027980 4284292172 4284686924 4284425037 4284094795 4284225856 4285012032 4286195016 4286061639 4286064456 4285012292 4283765815 4285077821 4286985551 4283961667 4284423496 4284554310 4285867592 4284554568 4284552246 4284423238 4284945207 4284225859 4285932363 4286195273 4285405244 4285933389 4284420405 4285930563 4285539913 4285733952 4286197580 4285404731 4285802056 4286196810 4287706188 4284813879 4285076539 4284156978 4286583109 4287176777 4287836490 4289212489 4290070348 4291316041 4291125081 4291975264 4291583326 4291584873 4291781495 4292701796 4292307832 4292703846 4292376955 4292833657 4292510570 4292901767 4292575094 4293101453 4292972167 4292840583 4293299599 4293369737 4292972960 4293366920 4292973710 4292973452 4293039764 4293103245 4292512142 4292244613 4292707195 4291194735 4289608783 4283761470 4284224073 4286522950 4284095560 4284098385 4285014859 4284557136 4283901005 4284424267 4284620876 4286260550 4286329681 4284943416 4285473349 4284750148 4286127684 4285403968 4285077570 4287245130 4289554028 4288035928 4287441992 4288367961 4286458954 4287179077 4287641680 4287050062 4287771980 4286127431 4288101706 4285011025 4283960909 4292446851 4292387485 4292250227 4292843404 4291002480 4291331199 4291791216 4291004808 4291791997 4290939005 4291790721 4290807941 4291133048 4290219660 4291921790 4290807681 4291593351 4290219388 4291069569 4290938754 4291593351 4290219388 4291201670 4291069812 4290544258 4290610544 4290673541 4290085246 4290673528 4289951095 4290410871 4290476662 4289754503 4289622378 4289162882 4289291377 4288438121 4291726209 4293839005 4294038435 4294170554 4294172079 4293972901 4294038180 4294037666 4294036896 4294037666 4294037666 4294037409 4294038179 4294038190 4294038177 4294037420 4294037665 4294036382 4294036382 4294036897 4293837957 4294102946 4293706646 4293838232 4293706645 4293376649 4293507980 4293506441 4293500292 4293299297 4291455309 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285012799 4284620356 4284420413 4284355133 4284814141 4284680260 4284029757 4284621390 4285405507 4286391367 4288100174 4288300876 4289676882 4290271586 4291324779 4292108638 4292640367 4292641132 4292970368 4293761152 4293238407 4293631353 4292843142 4293632385 4293566850 4293567108 4293501573 4293566336 4293563766 4293429624 4293164652 4292109407 4289676622 4286917196 4286389843 4286129476 4287112778 4290278273 4286327625 4284619843 4284617290 4284029254 4285543775 4286333048 4286855510 4287184497 4284028998 4284884301 4286132049 4284620874 4286330983 4285280874 4283699780 4284029796 4284161861 4282778195 4287389319 4289303220 4287985824 4287651214 4284027465 4286334078 4285675902 4286531963 4287718559 4286334335 4288180136 4287848859 4288517295 4288645566 4288974008 4287191964 4288970156 4290940071 4292062647 4284882517 4285872750 4287515236 4287649392 4283702088 4283439952 4284361298 4284226370 4284360271 4284817996 4284620361 4284292934 4284490573 4284622161 4286063942 4285868618 4287247181 4284358732 4283831360 4285537347 4286196043 4284815678 4284751174 4285276230 4285012805 4285146959 4284618301 4285341256 4285013573 4284881728 4285405507 4285867596 4285275714 4285409102 4285999436 4284816197 4286259271 4285736011 4285145931 4285274947 4286063432 4287443274 4287310919 4286457674 4285339198 4285142585 4285336377 4285273143 4286716232 4287508813 4288229961 4289805386 4289413701 4290134858 4291120206 4290928217 4291582562 4291388262 4291256691 4291848030 4292439935 4292505444 4292442489 4292114053 4292772214 4292771716 4292967826 4293037194 4293432695 4292971428 4293369211 4293037968 4292512390 4293364615 4292709237 4292904848 4292378484 4292377993 4291853424 4291326062 4289807956 4283895113 4284358467 4285407836 4284230480 4284293707 4284885603 4284032334 4284819024 4284949582 4284425039 4285673033 4286328652 4284752459 4285869131 4285143356 4284882245 4285472067 4285078603 4287246922 4288765020 4287906385 4287510862 4287514199 4287772234 4286526027 4287577944 4288166224 4287574603 4286656075 4287316058 4286063185 4284748857 4291139482 4292448647 4292708729 4292119681 4291067769 4290871411 4290540151 4290282866 4291264882 4291462260 4291199354 4291462002 4290873733 4291330684 4290938754 4290481289 4290938753 4291330428 4291136133 4291004290 4290676095 4291790204 4291001990 4290284410 4290544769 4290084221 4290676353 4290541944 4289429887 4290282368 4290213495 4290082680 4290214007 4289427569 4289227620 4288702329 4288899440 4292386417 4293641630 4294038434 4294170543 4294170543 4293973157 4294038180 4294036896 4294036896 4294037666 4294037666 4294037409 4294038180 4294038179 4294038180 4294037665 4294037153 4294036382 4294036896 4293706388 4294168741 4293772695 4294034827 4293575057 4293440663 4293174379 4292841319 4291717190 4288956486 4286327112 4284421191 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284288836 4284288579 4284226885 4284619588 4284815938 4284224069 4284745532 4284096582 4284355644 4285996360 4287640140 4288629321 4289874785 4289743190 4291256419 4291783782 4292246122 4292839299 4293234299 4293234304 4293237632 4293631354 4293302910 4293172358 4293631612 4293567366 4293566594 4293565818 4293563261 4293298040 4292965727 4291453015 4289873488 4287113286 4285076544 4286129222 4290080670 4289553555 4286657869 4288572059 4284026682 4282912337 4286000729 4288307848 4285344078 4286199391 4284948550 4285672544 4285015144 4285541971 4286001502 4285212242 4284158792 4284029771 4284555102 4283040336 4284957305 4290092732 4288315056 4287784078 4284947798 4285608043 4286333811 4284818540 4286990697 4288047773 4287591081 4285939069 4287325065 4288712623 4287058071 4288247216 4288444078 4289501103 4291072935 4288704682 4289628602 4288768149 4290804871 4284820047 4283175759 4283369796 4283966031 4284029007 4284292936 4284425037 4284685898 4284096073 4285799750 4287047497 4286394445 4286851143 4284025667 4284290373 4285276745 4286264909 4284554054 4284292425 4284488003 4285734982 4285866824 4284683837 4284160062 4285339710 4284289342 4284487742 4285471810 4285341517 4286260295 4285734210 4285405766 4286131787 4286129479 4286195528 4285209411 4285472841 4287049290 4286656330 4287902537 4286324552 4285996103 4286258752 4285535552 4286914632 4285930053 4287046214 4287307846 4286651972 4287046212 4287179592 4288821835 4289019210 4289024085 4290139754 4290863218 4291124314 4291784043 4291980407 4292508273 4292115333 4292706678 4292245873 4292968578 4292710799 4293037707 4293431183 4292969351 4292379499 4292574836 4292902279 4292314244 4292704119 4291852397 4290996843 4291977806 4288689993 4283371316 4284487239 4284750654 4284424268 4284752718 4284096072 4284295761 4284949069 4284884046 4284620620 4286000975 4285079111 4285078083 4285735502 4284554567 4284618301 4285275977 4285670986 4286655049 4289221737 4288039013 4287513173 4287578713 4287576910 4287179849 4287643480 4287513423 4287575883 4287244873 4287248973 4285864771 4285408340 4291469467 4292447622 4292316544 4291725687 4290541678 4290405995 4289292658 4290473066 4291000698 4290936952 4290477176 4291068283 4290873209 4291001976 4290742147 4290284423 4291201669 4291070597 4291136133 4290938754 4291069826 4290807680 4290218873 4290938241 4291526774 4290021768 4290478461 4290936184 4289888127 4290082422 4290082934 4290082936 4290148215 4289228672 4289292915 4288700775 4288965501 4293111947 4294036122 4294038707 4294170788 4293972901 4294037923 4294037666 4294036896 4294037923 4294036896 4294037666 4294038437 4294037409 4294037666 4294036896 4294036382 4294036640 4294036897 4293904539 4293838233 4293509250 4293244567 4293638276 4293566582 4292249457 4290859589 4286850633 4285270075 4283633477 4283831869 4283633216 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284292419 4284355148 4285274165 4284358476 4284486200 4283961656 4284159308 4283962186 4284485181 4286127686 4287049804 4288694606 4288103247 4288693320 4291255127 4292046177 4292638572 4292970355 4292970870 4293302658 4293697145 4293238150 4292909707 4293696889 4293173115 4293238393 4293567622 4293566592 4293628798 4292970607 4292245350 4291451220 4289282892 4285666878 4285999711 4291071656 4293844411 4288759650 4289290373 4291399061 4283173701 4283306567 4284949084 4287053154 4285870944 4285012030 4286000733 4285408592 4284357956 4286526825 4284094538 4284423255 4284226373 4284030796 4284355930 4283500883 4284493670 4289174971 4288776111 4289566131 4286728593 4287061123 4286663038 4284684888 4285150572 4289165483 4288250539 4286860935 4285281381 4287391652 4286467725 4287789992 4289169333 4289765553 4289034919 4289296805 4289959847 4290949567 4290290102 4288442273 4283767871 4283572302 4283767375 4284162629 4284227665 4284554307 4284227143 4284818254 4284948294 4287445327 4286853451 4286656333 4284095298 4283699761 4285274940 4287050834 4284486458 4285473351 4284095044 4284618044 4285342793 4284357189 4285339709 4285078341 4284160318 4285929533 4284621387 4285273396 4285408592 4286195528 4285800514 4286194504 4285670987 4286195528 4285801027 4285405244 4285604934 4286785607 4288233043 4287771465 4286652999 4286782280 4285996871 4287050571 4287967322 4287249237 4287771219 4288364389 4289220698 4290071142 4289679472 4289613403 4289942383 4291124076 4291059297 4291386481 4291846513 4292174960 4292110211 4292574082 4292900996 4292511113 4292967824 4292968341 4293105291 4292710286 4292576913 4293230987 4292836250 4292707448 4292375168 4290537844 4290796906 4291259994 4290728028 4286655300 4284096334 4284356928 4284294480 4284687181 4284033875 4284100180 4284488525 4284951121 4284949582 4284225858 4285608787 4285605446 4285211985 4284947520 4285078852 4285011514 4284750148 4286719559 4286654538 4288829535 4288103772 4287511381 4287578199 4287643743 4286592084 4287116884 4287575119 4287642702 4286062661 4288034644 4285738065 4285800018 4292453259 4292319100 4292972929 4291526264 4289489783 4289290072 4289485915 4289289832 4290013014 4289883771 4290080107 4290275445 4290477176 4290805113 4290410872 4290673525 4290871420 4291199611 4290542456 4291461495 4290219145 4290610562 4291135363 4290478975 4290479232 4290938508 4289955702 4290019708 4290279554 4290082678 4289558663 4290410871 4288441973 4289556848 4288636776 4289159286 4290541178 4292852356 4294167968 4293973158 4294170790 4293973158 4294038438 4294036896 4294037153 4294036896 4294037923 4294037153 4294036127 4294037153 4294036382 4294036640 4294036640 4294034831 4293771908 4293772180 4293246871 4293503362 4292713583 4292376922 4288958293 4286653763 4284027453 4284223802 4283828543 4283830585 4284550969 4284683070 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284552260 4284945461 4284227148 4284815420 4284027711 4284157247 4284486200 4283764285 4284813631 4285274940 4287836746 4287970897 4288035406 4288755786 4290464600 4291519841 4292704621 4292575597 4292972158 4292972406 4293236870 4293632383 4293629561 4293565815 4293632128 4293172359 4293565305 4293566850 4293365362 4293428330 4292507249 4291188049 4288228942 4287903326 4291472069 4294304451 4287181363 4286256230 4288566626 4289100447 4283370819 4283565640 4283765831 4286729071 4286068584 4284686416 4285343055 4284951383 4285146708 4286133089 4284489024 4284489028 4283766862 4283962426 4283504206 4283500113 4284229476 4288317874 4288441764 4289436078 4288310688 4285542757 4286071408 4285212775 4284553325 4286532466 4288645808 4286727550 4284820587 4287658162 4288380348 4285279078 4288448933 4289827251 4289235624 4287124374 4284227648 4288761706 4289370540 4289831609 4288177316 4284951129 4283107134 4283240010 4284028219 4284030286 4284621901 4284027200 4285603143 4287967823 4286788430 4286263377 4284222517 4283502406 4285211209 4286785094 4284161354 4284160579 4284619588 4284422980 4285209670 4285209404 4284486728 4284620358 4285733700 4284355652 4285078851 4284947270 4285406784 4285933387 4285211723 4285406789 4286194760 4285276229 4286326602 4285470276 4285142336 4286983240 4287638604 4287443788 4288163913 4287706187 4289611335 4290860903 4290466657 4290992485 4291127150 4291980153 4292307830 4291848554 4291853442 4291918979 4291522672 4290930545 4291457392 4291723132 4291523964 4292378759 4292443252 4292580223 4292709768 4292514431 4292513145 4292644984 4292841597 4292907651 4292515206 4292451223 4292845974 4292908938 4292516001 4292714641 4292126380 4292912552 4290746783 4289159282 4285739872 4284753232 4283439686 4284359502 4284951635 4284882502 4283901262 4284687181 4284556366 4284686925 4286064201 4285145159 4285802062 4284488003 4284489801 4285209927 4284880184 4286065742 4286326861 4288959072 4287907925 4287575884 4287581784 4287577173 4287180885 4287052878 4288168792 4288163414 4286063688 4286723402 4286392155 4286263895 4292716956 4292314733 4292448643 4291193459 4288632658 4289686894 4289220950 4289419871 4289551717 4289487979 4290012775 4290012514 4289947772 4290277739 4289948268 4289491578 4290671477 4290214776 4290739576 4290608248 4290805112 4291856254 4290610819 4290742148 4291002236 4290347372 4290807684 4290016373 4289953663 4290019440 4290082167 4288967538 4289688447 4288637814 4289422707 4288372070 4291334280 4293638806 4294104230 4294038694 4293973158 4294037667 4294035336 4294036384 4294036384 4294037153 4294036896 4294036384 4294036621 4294036384 4294036641 4294035850 4294037155 4293969801 4293639825 4292782727 4293042555 4292118395 4290795595 4286851656 4284943936 4283960388 4284027192 4283370816 4283830591 4285405503 4285405501 4286194505 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285078597 4285539148 4285144644 4285209926 4284552516 4284354885 4283764029 4284091977 4283960632 4285799493 4287311431 4287575375 4287508811 4287639882 4290531413 4291783785 4292245091 4293033848 4292839285 4293367430 4293238661 4293237119 4293632384 4293172614 4293563263 4293632127 4293566336 4293566849 4293431160 4292969327 4292175698 4290269291 4289285478 4292195525 4294892979 4286591030 4287455371 4285536835 4289100922 4288237412 4283898699 4284427091 4283433789 4286990445 4286661993 4285344340 4285999197 4285801806 4286397291 4284226116 4284357700 4286594423 4283962947 4283766370 4284292164 4284025939 4286334599 4289233576 4287851944 4288112789 4288714168 4287320967 4285871712 4285675115 4284488273 4284685649 4286597746 4285479805 4287453863 4289110208 4288316315 4285873287 4286532748 4288582837 4289437619 4288973229 4286594946 4283896123 4285801318 4290621347 4291475388 4290024640 4284688218 4282977355 4283241042 4283963467 4283964749 4284685636 4285537351 4287378764 4287249742 4286850374 4283372102 4283631938 4286131786 4286786637 4284420418 4284619588 4284683836 4285405756 4284358732 4285603139 4284291132 4284882763 4285274172 4284486724 4284686152 4284813877 4285408330 4284816708 4286326089 4285405243 4286196041 4285800003 4285076023 4285667648 4285076280 4286129222 4287115081 4288099659 4287641681 4289414227 4290467175 4290072160 4291322483 4291519838 4291585135 4291715937 4292175972 4292110954 4292310123 4292439138 4292505187 4291914603 4291852656 4292114300 4292176483 4292442232 4292375926 4292575113 4292509813 4292578939 4292575352 4292574596 4292576139 4292511101 4292316295 4292970624 4292641918 4292643723 4293169539 4293172881 4292783003 4293506473 4293247396 4293051570 4292395189 4290026664 4287060093 4284690004 4283111751 4284425037 4283965008 4284294221 4284490316 4284291911 4285538891 4285144644 4284685382 4284094523 4284225868 4285540171 4284225603 4286131017 4286783558 4287976288 4288171632 4286985556 4287646818 4287642452 4286526540 4287771469 4287447631 4288100682 4287116364 4287966795 4286260287 4286066766 4292649629 4292379244 4292448386 4289751913 4289546072 4290141786 4289485153 4289613409 4289614429 4289353300 4290076269 4289485925 4289553488 4289488758 4289550686 4289620849 4288899699 4290144377 4289622382 4289621870 4289688441 4290476664 4290936697 4290607990 4290673525 4290742156 4289950837 4290674042 4289953662 4289755526 4290082166 4289229936 4289162351 4289359729 4288569712 4288898417 4292385146 4293970330 4294038694 4294037923 4294038438 4294036382 4294036641 4294037412 4294035593 4294037154 4294037923 4294036382 4294036640 4294036640 4294036108 4293904544 4293838231 4293639566 4292850311 4292909187 4292645764 4290144596 4286788174 4285403707 4283502402 4284028226 4283699004 4284552764 4285009719 4286128963 4286985550 4286851401 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285472845 4285277001 4285539149 4285212746 4285013315 4284486973 4284553797 4283961662 4284023858 4285931077 4286390344 4287182156 4287050828 4287311691 4289089104 4292111972 4292309089 4292511350 4293234301 4293301894 4293694846 4293238662 4293695353 4293238406 4293632382 4293172357 4293566851 4293566330 4293495934 4292706152 4292572023 4290927719 4293116110 4293840033 4287246651 4285935703 4286652990 4284289869 4288505226 4284951122 4283240263 4283502149 4282978642 4286397279 4287450227 4286132559 4284488278 4285935442 4285739111 4284752971 4284881236 4286861953 4284292166 4285212240 4284423256 4284160062 4285608041 4288706472 4288839332 4287648920 4288840348 4289237176 4286136953 4284425043 4283171392 4284424032 4286733712 4288115375 4287855274 4289438900 4286073223 4286465164 4286404493 4287915404 4289565359 4287646079 4288773002 4287845010 4284157747 4288176258 4291336355 4290881443 4289894595 4284292693 4283439949 4283768393 4284161347 4285014603 4286128709 4286787148 4287969874 4284948294 4284093516 4284357447 4286526031 4286132554 4284160840 4284553538 4285145164 4284292424 4284555339 4285669452 4284357187 4284747580 4284488774 4284684349 4284618300 4284816714 4284292940 4286063179 4285801026 4285209411 4285799241 4286260809 4285275714 4284617527 4285078592 4285405763 4287181388 4287902798 4288691532 4290792021 4291187544 4291453794 4291584360 4291716713 4292109413 4291124833 4291520352 4291847520 4291584871 4291980647 4292308841 4291127406 4291914601 4291651944 4292572537 4292442232 4292379516 4292573797 4292575368 4292640647 4292378745 4292444537 4291919997 4292704869 4292444027 4292378230 4292577161 4292513659 4292384402 4292781454 4293110153 4292982177 4293573542 4293705126 4293640611 4294099366 4293841850 4291408052 4287522696 4284756833 4283442507 4284358732 4284489803 4284422979 4285209669 4285080395 4284553536 4284159053 4284357184 4284685391 4285143619 4286067032 4286656587 4287974224 4288893296 4287049799 4287051851 4287843944 4287246411 4287115603 4287512153 4288166989 4287115339 4286721107 4285607013 4287576667 4292978581 4292052586 4291921531 4290274655 4289421423 4289289580 4290800500 4289355884 4289615453 4289550696 4289483619 4289616986 4289617011 4289614937 4289617785 4289421412 4289419868 4288896867 4289159542 4289750642 4289555056 4289556336 4289425273 4290082425 4289820026 4289885046 4290017144 4290083192 4289951095 4290279798 4289624711 4290082167 4289162623 4288769141 4288701057 4288832622 4292911499 4294101640 4294037668 4294038953 4294036107 4293838750 4294036110 4294035851 4294036643 4294036382 4294036382 4294036639 4294036639 4294036640 4294100624 4293837700 4293574030 4292982936 4292849561 4292450436 4291131754 4287973204 4285799748 4284421701 4283894078 4284223294 4284552253 4285866563 4286392396 4287837516 4287706702 4287180875 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4286326854 4285867847 4286064969 4285408589 4285144649 4285733436 4284685896 4284290365 4283897418 4285535548 4285802057 4287376967 4287243847 4287443273 4289479503 4291123542 4292308844 4292114532 4293297520 4292972920 4293302918 4293301630 4292910205 4293105022 4293171334 4293630591 4293565817 4293564033 4293234553 4293099909 4292048263 4293183435 4292845682 4286587450 4285995330 4287645290 4284422752 4285741155 4291533978 4282844220 4283371857 4283372106 4283304762 4285936222 4288107891 4285933401 4284949586 4285475667 4285082711 4284816716 4284815957 4286926963 4287120229 4284882779 4284423739 4283831150 4285671509 4285481078 4288378529 4288906672 4286596721 4288509865 4289302198 4285411455 4284360041 4285478004 4287123344 4288379822 4289242036 4287985562 4284950383 4286206853 4286399618 4286072707 4287524513 4288906153 4286398569 4286531442 4286331517 4286268003 4289566888 4289030289 4289634718 4290026951 4283240007 4283699780 4283963469 4284949063 4286066786 4286853450 4287905102 4285341771 4284094777 4284027724 4285278026 4286722913 4285211979 4284489543 4284752717 4284421705 4284421691 4284554566 4285867598 4284752458 4284618301 4285209927 4285604940 4285538380 4284945719 4285014087 4285670216 4285935439 4285209151 4285866828 4284487742 4285932876 4285141815 4285602627 4287838288 4288493133 4288494414 4289810791 4291190366 4290928735 4291847268 4291914339 4291452515 4291649380 4291191141 4291978877 4291325038 4291387754 4291717489 4292243064 4291455610 4292636791 4292112999 4292440952 4292376185 4292379260 4292444539 4292050028 4292507256 4292507513 4292115056 4292112536 4292115561 4292245895 4292577139 4292841603 4293172881 4292715661 4293045149 4293049245 4292983728 4293310881 4293247649 4293378466 4293641140 4294102186 4293774524 4292197557 4288706954 4284955239 4283702343 4283835471 4284815938 4284163665 4285146962 4284029758 4284097354 4284357438 4285014860 4285605961 4287842401 4288237136 4288239212 4287050590 4287120728 4287774817 4286065225 4286592333 4288364111 4287510350 4287179847 4287379808 4286262873 4287709023 4292850334 4292445038 4292117365 4289616998 4289946726 4290998905 4290408028 4290408034 4289288546 4290013547 4290074983 4289485659 4289549661 4289616488 4289419611 4289484646 4289023585 4289093227 4288893024 4288239963 4289815397 4288762196 4289815415 4289092971 4289552990 4288505977 4289750907 4289621870 4290081148 4289098097 4289818221 4288638072 4289359983 4288704377 4288568682 4288832625 4292649600 4293904281 4294037154 4294038695 4294036643 4293838216 4294034830 4294036901 4294035850 4294036640 4294036639 4294036639 4294036639 4294036896 4293640083 4293180054 4293374864 4292981380 4293171840 4292117876 4288367438 4285995074 4284221241 4284288313 4284421688 4285472068 4286063688 4286852173 4287640395 4288166737 4287509581 4287050574 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288894820 4287580250 4286657606 4286392648 4285997127 4285799747 4284815683 4284553274 4285143101 4285669188 4287048264 4286982472 4285668680 4286783559 4288231502 4290925905 4291913815 4292640368 4292903549 4293300600 4293238143 4293235846 4293695102 4293170311 4293630329 4293565312 4293632126 4293630844 4293299071 4292773780 4293842602 4292908156 4288296529 4286978883 4286260046 4286722916 4285078078 4292057758 4288896872 4283500359 4283305279 4283372370 4283237959 4284357703 4287186547 4286592859 4283564854 4285146457 4284815691 4284621382 4284683882 4286861424 4288502164 4285868378 4285934703 4285343301 4284687192 4283435347 4285216103 4289170869 4288309669 4285018465 4288446632 4287986354 4289104056 4289233849 4287988406 4289634992 4288780219 4284752477 4286793348 4285675633 4287392931 4286794639 4286531702 4288183714 4287586217 4285014865 4287852710 4289296287 4290683828 4289161876 4285209412 4290099889 4288443050 4283241284 4283765069 4284948554 4286127173 4286851398 4288034124 4284355652 4283830864 4283831100 4285804368 4287247946 4284027720 4284751174 4284883016 4284619587 4284619588 4284880444 4285277002 4285143356 4285077562 4284554567 4284619845 4285012546 4285080142 4284682548 4285999180 4285407043 4285473358 4286194247 4285539143 4285538117 4284946494 4285798723 4286787401 4287904337 4289675340 4290990938 4291122778 4291387747 4291256412 4291518308 4291583844 4291388001 4291190625 4291583841 4291518566 4292372857 4292110437 4291654765 4292637047 4292636769 4292439927 4292572261 4292573544 4292376440 4292573288 4292702565 4291919747 4292178534 4292180076 4292115307 4292114543 4292444026 4292511347 4292844175 4292777865 4293108618 4293045662 4292654497 4293246634 4293115293 4293443248 4293641642 4292984215 4293575349 4293575589 4294166692 4294101682 4292394928 4289430944 4285477212 4283438404 4284027448 4284225597 4283567932 4283502916 4283303999 4284618813 4286194247 4287185499 4286919252 4289026917 4286523975 4287249230 4287117398 4286787658 4287180619 4288102224 4287575375 4286719557 4286987351 4284947264 4288436586 4293176984 4292116836 4291130991 4290275436 4289949797 4290607983 4290538610 4291129196 4290803823 4290341229 4290014046 4290012784 4290078050 4289486182 4289616226 4289681517 4288761687 4288959318 4289745503 4289220441 4287646551 4288499560 4289221460 4288567403 4289684067 4289421678 4288436325 4288568163 4288306531 4289880942 4288701547 4288700005 4288766071 4288764767 4287846769 4289355881 4292979335 4293839004 4294036881 4294035853 4293838219 4293904011 4293839009 4294035850 4294036641 4294036639 4294036640 4294036639 4294036639 4294036897 4293837700 4293114501 4292587405 4292973699 4290799698 4287904584 4285797446 4284091961 4284550451 4285534523 4286259018 4285933128 4286851658 4287574859 4288689998 4287379789 4288100432 4287449168 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288967042 4288965510 4288763502 4287382613 4287313230 4286328395 4285999177 4285668937 4285733955 4286521417 4286453317 4285865800 4286125638 4285405250 4286918217 4289807440 4290927184 4292704623 4292904556 4293694594 4293629824 4293234814 4293238918 4293628538 4293630330 4293236868 4292975505 4293239712 4293312942 4292979083 4292967264 4290860374 4289348178 4287573583 4285736531 4288499567 4289299358 4290281846 4284881486 4283239236 4283897414 4283895357 4283371334 4284354370 4284884829 4287907954 4285147216 4286401661 4283040561 4283698246 4284488003 4286132826 4288371586 4286200672 4286069105 4285341771 4286534016 4282909499 4283630666 4287658120 4289363363 4288441755 4284949078 4284226371 4285872482 4286992768 4288049042 4289307324 4286005358 4285609068 4285745277 4287651729 4285412975 4287721632 4287324825 4287060884 4288110986 4287058312 4288245414 4290092201 4291994024 4288501100 4286200697 4285740375 4290427568 4285608293 4283829045 4285341000 4285538888 4286916937 4287446355 4284944702 4283570754 4283963463 4286721612 4287052365 4284486973 4284881725 4285078340 4284354877 4284423754 4284553277 4285538115 4285144134 4284291652 4285602366 4284292682 4284552260 4284357187 4284949324 4285277259 4286325831 4285146187 4286127944 4285406010 4285473872 4285602621 4285272644 4286458701 4287444046 4288888905 4290334811 4291126370 4291060064 4290927197 4292172392 4291584100 4291388257 4291583843 4291583843 4291125861 4291845991 4291785602 4291980132 4291979367 4291915387 4292440181 4292767609 4292375413 4292441206 4292439410 4291916925 4292768612 4291982205 4292113776 4292507514 4292639337 4292314239 4292971399 4293169796 4292318097 4293110925 4293047713 4293046942 4292983197 4293309863 4293509540 4293245854 4293181869 4293969315 4293444264 4293705643 4293838242 4294233013 4294563508 4292329400 4289233313 4284097873 4283238457 4283632688 4283305548 4283370546 4285207356 4285013058 4288033610 4286921560 4289028713 4286652224 4286660696 4287904864 4286788429 4286654792 4287577681 4287769669 4286196813 4286456387 4285604433 4289483878 4292714124 4291919992 4291788151 4289882731 4290607471 4291000440 4290277227 4290999918 4291459437 4290078316 4291128934 4290014056 4289883247 4290144613 4289486702 4289549923 4289684335 4289811813 4287973971 4288957529 4288302421 4289351009 4288302677 4288628571 4288498782 4288435296 4288040783 4288040024 4288827238 4287646035 4289223284 4289027168 4287649118 4287384160 4287448416 4288107101 4292580228 4294164601 4294036367 4294036902 4294034299 4293837198 4293838216 4294036898 4294036639 4294036640 4294035850 4294036641 4293838746 4293904796 4293839258 4293439377 4292909932 4290669154 4287047237 4284549437 4284486712 4285141816 4285799493 4286589769 4285801799 4286982471 4287048006 4288103250 4287968845 4287378253 4287969616 4288559695 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289557901 4289166215 4289228668 4289620595 4287253858 4287576659 4287378773 4285735749 4285800518 4287509834 4286389319 4286061641 4285339708 4285667908 4287112519 4289283152 4291449429 4292639582 4293099643 4292973191 4293302398 4293302918 4293236869 4293631866 4293236870 4293302403 4292913039 4293634452 4293631617 4293363829 4292311414 4291978847 4289284180 4286521162 4289092472 4289421171 4293576633 4285273145 4283697984 4283634246 4283501894 4283437642 4283828546 4284094786 4283501641 4285672011 4288372874 4287387271 4282974250 4283239493 4284093533 4285671253 4288180371 4287842937 4286461791 4285872485 4286925703 4282974265 4283106371 4284290397 4288245408 4289104043 4289034924 4286466186 4286269294 4286198386 4286797182 4288511911 4283567428 4287062938 4287061660 4286664065 4287323802 4287056254 4287789216 4288114095 4287061921 4287519633 4287980196 4288242553 4290227901 4286525293 4286464613 4286001009 4286198360 4289831097 4283962437 4285538122 4285142592 4286982986 4287640652 4284291650 4283634503 4284025141 4286852688 4287115597 4284680501 4284488517 4285078083 4284354877 4284489546 4283960640 4285341512 4285473611 4285406791 4284226633 4284421691 4284291134 4285930044 4285211465 4285405760 4285868107 4285734463 4286592590 4286062408 4285799490 4285535806 4284552247 4285341256 4287706446 4288759115 4290530393 4291186512 4291124832 4291387227 4291649631 4291191137 4291385696 4291585654 4291518049 4291584360 4291518566 4291915115 4291586925 4293094504 4292373093 4292571237 4292505189 4292574057 4292439412 4292246152 4292178280 4292112746 4292113770 4292573307 4291852411 4292576881 4292904319 4292970885 4292713118 4293108616 4293044622 4293046927 4293047715 4292982429 4293377420 4292982174 4293509531 4293704870 4292984499 4293904036 4293444520 4293640108 4293838243 4293772194 4294431160 4294431927 4292066490 4286206320 4283240767 4283370566 4283435832 4284420678 4285671243 4286853963 4287708249 4288305259 4286066257 4287379285 4286789710 4286262860 4286785350 4287707474 4287114828 4286851912 4286393170 4285800275 4289292394 4292713098 4292051307 4291000694 4291066492 4290871160 4290476663 4290871418 4291393131 4290281587 4291130987 4290933109 4290081143 4290343799 4290341493 4289949036 4290015086 4289488501 4289549924 4289748079 4289484904 4289089631 4288367709 4288628829 4288628304 4288561996 4288105575 4287449688 4287513686 4287318373 4288629598 4289550164 4289616226 4288894802 4287512150 4286393157 4288496477 4292121208 4293442184 4294102950 4294035852 4293839009 4293838218 4294036110 4294036384 4294036639 4294036896 4293838490 4294102689 4293772696 4293772436 4293374356 4292780169 4291330660 4287638608 4283760689 4284354872 4286390852 4286459723 4286327885 4287443017 4286851657 4286591822 4288231758 4287967821 4287838288 4288625744 4287838031 4287970136 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289365127 4290082941 4289625486 4289362312 4288503916 4289485937 4287186781 4287837261 4286657878 4287248465 4286328393 4285996360 4285275205 4285339197 4286589256 4289414218 4291385940 4292704879 4292772717 4293169275 4293300102 4293236089 4293629825 4293630330 4293171590 4293627518 4293632126 4293564798 4293170552 4293560696 4292574044 4291977059 4289018965 4288037739 4290146711 4290478458 4292190622 4283170875 4283964486 4283633471 4283634756 4284028991 4283962703 4284156995 4283635015 4284687959 4287387766 4287320703 4282908720 4283370566 4283305283 4284881238 4289562276 4287187326 4285739112 4287390606 4286861426 4283896145 4283632972 4283436350 4285346401 4287587474 4287786381 4289760701 4287582353 4286599558 4289042876 4287191951 4285477752 4284488532 4288314278 4287258533 4287782009 4288177578 4285345634 4289044153 4288178599 4287787174 4288972963 4289618308 4289226356 4290029503 4285407305 4283829050 4288833941 4288775311 4288701319 4283829558 4285341259 4287048521 4286590029 4284880456 4283830599 4283368509 4286922320 4286526028 4284227404 4284685380 4285278031 4284749371 4284816967 4284026683 4285278031 4285013059 4285476429 4284817992 4284752976 4284553538 4284358733 4285406791 4284620616 4285407305 4285474388 4287180872 4285803082 4285603912 4285538375 4285077053 4286128968 4287051084 4289086820 4289414743 4290728539 4290530387 4291057499 4290929248 4291910245 4291518564 4291715426 4292242021 4291782504 4291059830 4291191913 4292833892 4292110969 4292638311 4292374135 4292574058 4292439414 4292048233 4292508282 4292111206 4292506744 4292509309 4292113256 4292444540 4292707200 4292642931 4293170300 4292778123 4293108362 4292717971 4293111201 4292653971 4293440924 4292981665 4293047184 4292982944 4293311395 4293049746 4293573544 4293838502 4293640351 4293838259 4293772450 4293838771 4294102454 4294562488 4293185464 4288710304 4283833165 4283041854 4284092725 4285998918 4285928004 4287249738 4288435814 4286193730 4287443787 4286263886 4286393161 4286719814 4287705932 4287179334 4286853965 4286587462 4285077826 4290081918 4293041037 4291854451 4290669938 4290871674 4291265146 4290742403 4291133302 4290739578 4291396722 4290608249 4290345592 4290411640 4290474612 4290672758 4289949559 4290603625 4290080620 4290079330 4289490037 4290142044 4289420655 4289880419 4288432731 4288368737 4287908451 4287318856 4287512652 4287512406 4287251785 4289092705 4290078827 4289357398 4289878373 4287316813 4286591052 4286853457 4292316788 4293971103 4294036108 4294035855 4294036112 4293838217 4294036641 4294037923 4294036639 4293838489 4294036897 4293904798 4293770368 4293242758 4293040995 4291456861 4287312714 4284486973 4284682034 4286063690 4286787657 4287838031 4287182414 4286589771 4287183184 4287641174 4287312975 4287905360 4288561232 4287182669 4288627536 4287314511 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289888390 4288838547 4289694092 4289690251 4289165703 4289358971 4289353840 4287187797 4287577943 4287643727 4286657358 4287046728 4284943925 4285466937 4286720840 4288823889 4291449684 4292310890 4292774259 4293561467 4293236613 4293235073 4293629050 4293170043 4293695609 4293173127 4293565056 4293565569 4293562494 4293560938 4292574833 4291059033 4290079868 4290674834 4290341251 4291463554 4288169816 4283240261 4283763525 4283766858 4284223804 4283567678 4284091205 4282911049 4287122311 4289029790 4288831900 4286661738 4283369024 4282581562 4284024917 4287520914 4289629617 4285736269 4285938535 4287845494 4284553814 4284228427 4283436089 4285343848 4287716486 4286527852 4284486720 4285876087 4287784601 4288714163 4286399595 4285080168 4285544536 4285939087 4284291684 4288052642 4288114604 4287652244 4286990206 4288115106 4289438902 4288177313 4289036451 4288109945 4288170600 4288641907 4290157772 4283302708 4283503693 4288631425 4290355874 4285211734 4284685127 4287245899 4285798719 4283963976 4283897150 4283962939 4287115852 4287050573 4285404479 4284948298 4284686924 4284424267 4285013061 4284096070 4284226370 4285538890 4285604939 4285151062 4284814652 4284751171 4284881214 4284949324 4285603140 4285079623 4286194246 4285673548 4288165967 4285538890 4285472579 4284160323 4285472583 4287838288 4287055180 4289676631 4291256672 4291123292 4291516258 4290992989 4291125345 4291716452 4291583586 4291650678 4290927962 4291191658 4292110953 4292440185 4292570724 4292573802 4292375674 4292572006 4292375673 4292636772 4292374392 4292504164 4292441207 4292378233 4292441467 4292575337 4292706942 4292644237 4292777619 4292778122 4293041802 4293110414 4292652436 4293507745 4293375112 4292980386 4293046170 4292853404 4293310119 4293311653 4293245345 4293510314 4293705901 4293838232 4293772467 4293904808 4293838515 4294036651 4294300089 4294235325 4290423473 4284885076 4283044428 4285668421 4284947524 4286067285 4288437358 4285735494 4286395471 4287052626 4286325830 4287379536 4287708238 4286719814 4286329165 4285471046 4285471563 4291725707 4292120441 4292179044 4290409335 4291790718 4291527024 4291199353 4291134077 4290545009 4291133305 4290870903 4290477176 4290934387 4290345092 4290606195 4290476420 4290409845 4290999427 4289425518 4289883772 4289422448 4289555569 4289619049 4289159790 4289484381 4289091940 4288501611 4288039777 4288103513 4288566116 4290336094 4290539351 4291455328 4290073169 4287972436 4286916434 4288233043 4292909954 4293902725 4294037156 4294036641 4294035853 4294035853 4294037925 4294037666 4294036384 4294036641 4294035852 4294035848 4292980125 4292446561 4290728783 4285994562 4284089911 4284681271 4286522954 4287246924 4287641682 4287574603 4287575374 4287640909 4287445081 4287904846 4288563537 4288626770 4287775567 4287969360 4287772237 4288559181 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289691021 4289164673 4289495443 4289627543 4289367955 4289887642 4289491817 4289356669 4287844708 4288235598 4287641168 4286917451 4285403451 4284682041 4286848585 4289085006 4291909967 4292114288 4292969342 4293300870 4293234309 4293630585 4293170817 4293695104 4293172098 4293630580 4293565819 4293566076 4293628023 4292839029 4292965227 4290991705 4291987631 4293312429 4287048784 4290277250 4285344068 4283175246 4283832391 4283831880 4283767117 4283435837 4283632706 4283238203 4283239228 4288106610 4288770960 4289694397 4289035448 4288437400 4289234599 4289430433 4286722649 4286131297 4285870443 4285280347 4286204018 4283236427 4284424051 4289165725 4286861436 4285078847 4284751473 4287129233 4288643239 4285936735 4285611127 4284424256 4285478783 4286137968 4286072187 4285478501 4287720865 4288640168 4288637601 4288648381 4289101480 4288644532 4288051874 4289364910 4284880957 4283959121 4287525511 4288180135 4282516537 4284951644 4289297546 4288641950 4283765311 4286260294 4285474134 4284360527 4283897421 4283767628 4287248728 4286525259 4284686410 4285736272 4284555852 4285536327 4284292424 4283897156 4284948317 4285014604 4285605451 4285014090 4285474896 4284423755 4284947528 4284160840 4286326599 4285408845 4285999178 4286325832 4287773266 4286391882 4284618306 4285671504 4285470786 4287642457 4289151067 4289483357 4291252825 4290992220 4291909976 4291124057 4292304232 4292109926 4291256161 4290994786 4290798439 4292043882 4292504678 4292571238 4292574058 4292376957 4292572006 4292572006 4292377469 4292174694 4292637028 4292045927 4292441207 4292572776 4292575596 4292706441 4292644729 4292841342 4292775810 4292778634 4293105296 4293045647 4293110157 4292653462 4293044895 4292980620 4292983970 4293373851 4293309334 4293309578 4293245850 4293573788 4293312165 4293838248 4293838234 4293772197 4294102959 4293838502 4294036661 4294102208 4294563260 4291278767 4284953180 4284092214 4284091460 4285146693 4288105816 4285341254 4286065226 4286524489 4285932103 4286194757 4287839058 4286653766 4287639623 4284879943 4285471306 4291401622 4292969328 4290999660 4290935153 4291529853 4291265405 4291133817 4291068540 4291462270 4291199601 4291002491 4290805111 4291068283 4290542453 4290608247 4290608759 4290669426 4290017912 4291063156 4290081385 4290146680 4290079597 4289554278 4289617780 4289750375 4288437596 4289224304 4288567651 4287839831 4288893778 4289813856 4292046175 4291130713 4289746770 4288563544 4287048778 4289811799 4293176193 4293838747 4294035850 4294037154 4294037153 4294037154 4294036896 4294037668 4294037134 4294037391 4294102690 4293576613 4292976230 4290074457 4286061634 4283897415 4284486460 4285930824 4287711058 4288100432 4288036173 4287443275 4287509066 4287377482 4288430159 4288823375 4289022298 4288234318 4288431695 4287838288 4288557130 4287708752 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289228163 4288969874 4289300620 4289630603 4290154147 4289500043 4290085524 4289032071 4289880680 4287779174 4288166989 4286785862 4285797954 4284419123 4285865539 4288954954 4291257699 4292770156 4292773752 4293106305 4293631103 4293566592 4293237376 4293237633 4293630580 4293171585 4293566852 4293566075 4293629047 4292904821 4292439908 4292116108 4293974726 4292713865 4287313492 4287513177 4287248489 4285212757 4283763785 4283699010 4284419906 4283895101 4283896383 4283961676 4283766079 4285410911 4284814925 4284226885 4286594648 4287850629 4287845509 4285737039 4285672290 4286401414 4284489046 4285146976 4285280621 4286794116 4289101984 4288046469 4284481593 4283763027 4285739362 4288582331 4285538893 4284161090 4285739887 4284489318 4284422501 4286400632 4287059852 4285742453 4287058826 4287589278 4288837539 4288774306 4288511416 4288511403 4289495470 4289044408 4286859133 4282384435 4285939048 4291151301 4286203780 4283368253 4286986328 4291740100 4284945990 4285668934 4284884045 4283634502 4283766087 4283634765 4286133833 4286852172 4285078855 4285471552 4284424010 4285080394 4285014861 4283636802 4284948295 4285537599 4285541455 4285212239 4284555341 4285407044 4284489547 4284422208 4286458189 4285472326 4286523466 4286721611 4288232782 4288035142 4285209926 4285599545 4284880969 4287840335 4287904601 4289482845 4291253843 4290992221 4291191390 4291781989 4291518820 4291714664 4290992732 4290796892 4292834169 4292111718 4292440441 4292373348 4292831609 4292375929 4292572261 4292375419 4292572263 4292636772 4292374390 4292441465 4292570210 4292574316 4292511090 4292838782 4292971400 4292710270 4293104002 4292711068 4292712585 4293108360 4292716177 4293108635 4292652433 4293438858 4292983446 4292980880 4292982416 4292982182 4293311640 4293574060 4293573776 4293640354 4293838247 4293970603 4293706415 4294102712 4294036662 4294036404 4294037935 4294694330 4292263609 4285806695 4283500084 4285144648 4287644242 4285012544 4285538120 4286130506 4285537610 4286920268 4287180875 4286852173 4286457415 4284483396 4285405759 4292252053 4292512885 4291132273 4290933353 4291528576 4291265403 4291528575 4290870905 4291462268 4291199610 4290411127 4291067769 4291068025 4290739330 4290348160 4290607991 4290345591 4290674040 4290279544 4290148728 4289882742 4289622125 4289491323 4289557113 4289554798 4289815164 4289161592 4289357163 4288371311 4289289057 4290603601 4290997595 4291915104 4290402902 4288758350 4288427342 4292181360 4293179271 4294168481 4294037925 4294036897 4294037923 4294036896 4294037666 4294037666 4294036641 4293706391 4293838748 4293375343 4292446069 4288627791 4284288835 4284090427 4285670219 4287643474 4289347403 4287841359 4287903565 4287969871 4287967318 4287839567 4288629077 4288366413 4289941084 4288498004 4288625490 4287905358 4287116368 4289086801 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4288703369 4289887884 4289693580 4289432222 4289566884 4289629847 4289565324 4289888402 4289426300 4289488234 4287186521 4286787405 4285539146 4284155443 4286588486 4288953422 4291122006 4292376426 4292774004 4293365880 4293238406 4293631871 4293042298 4293237377 4293565819 4293566337 4293566847 4293565314 4293235067 4293230696 4292701285 4293172121 4294631628 4290734712 4288042368 4288101219 4283962181 4285408333 4284752715 4284029771 4285274958 4283766852 4284553294 4284093770 4285539665 4286596198 4283766084 4283238218 4285277274 4285937500 4285539414 4285999965 4284621385 4283962684 4285539418 4285938540 4286664310 4287057009 4286397534 4284882511 4283239236 4283565130 4288376988 4289107131 4283238204 4284689264 4285342801 4286071416 4285212254 4284950106 4286797972 4286994311 4285742212 4286203256 4287585956 4288972455 4288903587 4288509854 4288849599 4288777130 4290024358 4282714202 4282908727 4290743690 4292001752 4284683063 4287188369 4289693065 4287126151 4285860661 4284159042 4283698760 4283700295 4283831360 4286329697 4286656585 4285078599 4285341256 4284226375 4284489289 4284752460 4284095300 4284554826 4284750918 4285475920 4286391621 4284553795 4284291911 4284752460 4284292425 4286329166 4285999689 4286455878 4287115351 4288954187 4290137172 4285670216 4284683319 4284746559 4287443532 4287115847 4290665567 4291123292 4291513941 4291778141 4291848812 4291450460 4290401112 4291189085 4292371304 4292440438 4292441721 4292636771 4292438885 4292176504 4292636257 4292375676 4292574058 4292570725 4292310395 4292769147 4292309619 4292769915 4292313212 4292904833 4292839284 4292708227 4293169023 4292972158 4293496704 4293107077 4292713883 4292780173 4293438873 4293043100 4292979342 4293439113 4292981409 4292981138 4292981907 4293310110 4293638294 4293114534 4293771938 4293441959 4293838246 4293904798 4293838516 4294036906 4294036674 4294036403 4294037701 4294629308 4292263855 4285015632 4284881475 4287182672 4285669186 4285867334 4285539144 4285999945 4287380306 4287312204 4286788172 4286654278 4283897159 4286065231 4293237912 4292510056 4290803837 4290346105 4291396732 4291134334 4291725698 4290936185 4290282627 4291593597 4290608240 4291070855 4290345078 4290873722 4290935926 4290476919 4290805636 4290410871 4290214518 4291198340 4290542710 4290080118 4290211701 4289820024 4289753978 4289229167 4288965491 4289162355 4289616749 4289356376 4290472034 4291913313 4290997853 4290271826 4289220176 4289940057 4291990383 4294230394 4294036897 4294036897 4294037646 4294036897 4294037666 4294036896 4294037924 4294035853 4294035854 4293375357 4293175178 4290671194 4286390347 4283893820 4285602121 4287181130 4289086799 4287708001 4287776343 4288493902 4287773529 4288361546 4288498004 4289088595 4289547090 4289742681 4288824138 4287708238 4288495714 4288364108 4289022303 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4289427337 4288178037 4289491844 4289433493 4289630089 4289630618 4289630618 4289367444 4289754752 4289821830 4289354852 4287642967 4286062408 4284287794 4286326346 4288755786 4291779157 4292114289 4293167218 4293299586 4293238405 4293566850 4293631872 4293171584 4293565563 4293565562 4293566851 4293565301 4293300597 4292773492 4292964728 4293174931 4294304208 4288564329 4291134608 4290876830 4282581038 4283633982 4284024374 4284685380 4285277774 4285933901 4285014857 4285605972 4285869919 4286199892 4285409116 4283107398 4286331993 4286924143 4286063940 4284226629 4285212502 4285605201 4285082454 4284817994 4284029256 4283960900 4283899213 4284687947 4283700553 4284356697 4287587466 4287526041 4285804644 4283239232 4284558193 4285744505 4285940585 4285478526 4284953954 4287850661 4286205549 4286398071 4285942137 4289229986 4288646581 4288903581 4288775848 4287323008 4288512931 4287979671 4285015923 4288303980 4292849053 4289299373 4286465650 4286264906 4291144120 4284158289 4284160838 4283832397 4284557391 4283965007 4287051855 4285936472 4285276745 4285409100 4285277517 4284884304 4284949582 4284294735 4284949839 4284885586 4285932615 4286199128 4284752718 4284884047 4284885842 4285080396 4287183189 4286462287 4285800005 4286986841 4289874265 4289743195 4287182411 4283898953 4284092233 4286328908 4287839053 4290471536 4291451743 4291452516 4291516256 4290600799 4290006873 4290402918 4292244606 4292306788 4292373348 4292571257 4292374646 4292374392 4292638054 4292311935 4292572006 4292505190 4292571238 4292570980 4292504931 4292575086 4292508523 4292509805 4292969594 4292772990 4293169536 4292317054 4293170313 4292318862 4292711565 4293563262 4292712846 4292976519 4293045903 4292977034 4292977036 4293047699 4293373323 4292979859 4293310625 4293245324 4293638296 4293508255 4293838748 4293640097 4293904555 4294102702 4293838514 4294036660 4294036416 4294037686 4294038459 4294366909 4291276459 4284618056 4285932099 4285864512 4284946494 4285471293 4285997129 4286852169 4286260038 4287443788 4286658897 4283696958 4286656084 4292977814 4291981924 4291132787 4290935404 4291396989 4291462783 4291528310 4290742132 4290873203 4290542459 4290870648 4291134068 4291396466 4290804855 4291068027 4290870903 4290870902 4290608247 4290214276 4290410869 4290280324 4290279798 4289688696 4290211446 4290211701 4289556601 4289753464 4289096050 4289096041 4289552226 4289947735 4291062876 4291587155 4290995545 4290205782 4291123534 4293240450 4293839004 4294036639 4294037666 4294038439 4294036896 4294037666 4294037666 4294037924 4294101903 4293310847 4293243529 4292119646 4290140501 4286718022 4284617530 4286851401 4288758620 4288822095 4288298830 4289086546 4288498002 4288297037 4288494932 4289811038 4289484121 4290206822 4288891733 4289153377 4287773518 4287772237 4288430673 4289021266 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287057767 4288305015 4288705422 4289821321 4289432736 4289631381 4289567650 4289433496 4290024605 4290087054 4289490804 4287380041 4285931336 4285335097 4286456386 4288955216 4291125090 4292376169 4292708217 4293760635 4292976762 4293566077 4293565305 4293632387 4293371000 4293565050 4293502601 4293565819 4293366648 4293757045 4292310119 4292443248 4293643960 4287902569 4288561999 4290216567 4282843707 4283632957 4283505487 4284028214 4284291651 4284555081 4284028475 4284619074 4285479516 4285735759 4286459986 4284228428 4284552520 4284098124 4284025928 4284224343 4286725480 4286597497 4285147988 4284620617 4284157766 4283307083 4283960895 4286397285 4284424782 4283436872 4283898197 4286203240 4287982235 4284095586 4283964228 4285739100 4285080414 4285873263 4285869945 4285941102 4288507569 4286663555 4286790254 4288314270 4289496754 4288838567 4288644258 4287584147 4287917462 4289628578 4287057789 4287913871 4287582561 4289698223 4284950634 4283302732 4291348404 4286197347 4283635781 4284226117 4283503688 4283369799 4287184204 4286588230 4285802052 4285409869 4284291138 4284946750 4284620874 4283700813 4284881222 4285211980 4285343052 4286918225 4284031053 4285539143 4284685382 4284486971 4286063943 4286522951 4285670215 4287903560 4290663261 4291121743 4288560209 4285468991 4284352822 4287048522 4287968599 4290536296 4291584096 4291580767 4291121750 4289943394 4291584865 4292108646 4292438373 4292109946 4292637286 4292571238 4292570980 4292638313 4292505189 4292963944 4292508523 4292964204 4292308855 4292375671 4292768637 4292507496 4292706942 4292509548 4292837755 4292774533 4293038462 4292970888 4292710270 4293102973 4293104519 4292318348 4293108116 4293435010 4292648591 4293434497 4293045904 4292649874 4293371786 4293371273 4293309836 4293244060 4293246094 4293574048 4293508009 4293640353 4293970604 4293706402 4293904564 4294036661 4294036659 4294037186 4294036670 4294038469 4294892990 4290482589 4283894069 4285469757 4284352569 4285402940 4286192451 4287575630 4285800008 4287047751 4286195783 4283957318 4288167763 4292910224 4291655012 4290999654 4291265661 4290936957 4291725690 4290936957 4291133822 4290936186 4291199604 4290608507 4290739320 4290805112 4290674043 4290610801 4290870648 4291068282 4290542455 4290608246 4290411128 4290539891 4290083204 4290277493 4289360235 4289885561 4289556343 4289163391 4289687150 4289621873 4290013797 4290274656 4291524191 4291653982 4291387981 4289943896 4291853153 4293374100 4294166412 4294037924 4294037666 4294037409 4294037666 4294037409 4294038437 4294037153 4293904798 4293246104 4293107570 4291785823 4288497491 4285536837 4286327122 4287511888 4289284180 4288235086 4288296784 4288234831 4288168781 4288888668 4288957777 4290073181 4290663516 4289482587 4289087841 4288365903 4288300622 4288626005 4289349972 4288367197 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285671505 4286200415 4288306799 4289361285 4289495441 4289564310 4289961901 4290615704 4290485149 4290283909 4289688943 4288894568 4285799237 4284287800 4286325834 4289214538 4291451996 4292705635 4293100924 4293235584 4293632386 4293566850 4293566850 4293172871 4293565820 4293567367 4293764728 4293564801 4293366647 4293494383 4292768362 4292646028 4291394691 4288897147 4285934425 4284618293 4283041869 4284224067 4284160838 4283698247 4284027719 4284554824 4283961157 4284422468 4286594929 4283896890 4285343567 4285801033 4283766340 4284354122 4283175236 4284355404 4287519366 4287517825 4285276237 4285674585 4284357705 4283371334 4283305036 4286859635 4286530413 4282843716 4283436105 4285477740 4287783572 4287452790 4283240019 4285212256 4285415022 4285871732 4284885338 4285741184 4286732164 4287849631 4285413736 4288902565 4289171371 4288638871 4288641186 4289235637 4288310692 4289437113 4287050857 4288771484 4285468493 4289956236 4290419389 4282515502 4292126879 4288574087 4282908727 4283239749 4283701572 4283632702 4287314766 4285932871 4285798722 4285867854 4285536835 4284552764 4284880966 4283634750 4285472325 4284029767 4286326342 4286198605 4284814908 4284488260 4284159031 4284614975 4286195788 4286459722 4286783561 4288365651 4290402392 4290861151 4289808979 4285730367 4284747583 4285604424 4287969358 4289878116 4291649113 4290330447 4290402150 4291455078 4292309612 4292240482 4291976296 4292703334 4292373096 4292505956 4292767868 4292045671 4292375932 4292570980 4292374393 4292505445 4292572519 4292311419 4292573545 4292505959 4292705405 4292706429 4292641387 4293165175 4293036421 4292906361 4292710528 4293037695 4293104520 4292776583 4292713358 4293108107 4292711818 4293042839 4293040776 4293045648 4293371786 4292979087 4292979088 4293770650 4293244321 4293639827 4293508256 4293706135 4293838247 4293970603 4293838759 4294036917 4293838266 4294037172 4294037698 4294037440 4294104005 4294304198 4287915126 4285142078 4284092217 4284944704 4285733444 4286524232 4285601859 4286064969 4285141826 4283893318 4289022555 4293175700 4291652442 4291133296 4291134077 4291528559 4291528303 4291331190 4291199089 4291004798 4290742132 4290739064 4291462773 4291133560 4290739319 4291396475 4290805111 4290674042 4290542454 4290739844 4291067767 4290279288 4289820023 4290608247 4290279045 4290148215 4289687928 4289819512 4289555565 4289556861 4289817457 4291717731 4291984205 4291523929 4291651172 4291254606 4292248165 4293838469 4294036897 4294038437 4294037409 4294037666 4294037666 4294037666 4294036896 4294036641 4293970059 4293439352 4292052324 4291451223 4287179862 4286063684 4287707223 4288627278 4289153107 4288232024 4288758349 4288888145 4288824924 4289022559 4289613660 4290007130 4289418847 4289809497 4289153109 4288103500 4288754526 4289021257 4288302186 4289810266 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284288583 4284950343 4288042088 4288310166 4289231752 4289500303 4290486694 4290419104 4291207066 4289892508 4289428101 4288701797 4286984266 4283892280 4286061124 4288495690 4291320927 4292639084 4293035387 4293234566 4293633412 4293566079 4293566076 4293566849 4293566851 4293370485 4293566595 4293567364 4293563262 4293231208 4293097585 4292909956 4291538342 4289814638 4286590801 4285540176 4283700037 4283568448 4283896636 4284158532 4283829817 4284620614 4283503179 4286860394 4285343310 4283373648 4284883784 4284292431 4284817994 4283502149 4284222297 4284688720 4288045445 4287516046 4283433774 4287057521 4285343326 4283699527 4283433797 4285016924 4288309398 4284161099 4282976328 4285082729 4285940593 4285938544 4287583879 4284095303 4285411438 4286071664 4286726269 4284953955 4284885356 4287262118 4286135414 4288312485 4287583867 4287913878 4287521430 4289236408 4288902568 4290293172 4289168305 4290995832 4283630391 4283766331 4292925888 4286130804 4290676371 4291472294 4282646585 4283567159 4283698751 4283502149 4286591808 4285735499 4285144642 4286261835 4284684610 4285669965 4284292677 4284357700 4284292425 4285079114 4285801800 4285866056 4284753233 4285080394 4284685639 4284551730 4285735491 4286591054 4285932873 4289477970 4291386712 4291190105 4290267466 4286325572 4284679733 4286261318 4287444558 4289745775 4290528849 4290663513 4291977576 4292438114 4292505192 4292041833 4291847012 4292439656 4292373350 4292766589 4292505700 4292572266 4292572521 4292570727 4292505445 4292964202 4292439653 4293096570 4292506215 4292509550 4292506984 4292510062 4292706172 4292575851 4292771449 4293103482 4293035906 4293103487 4292645253 4293496963 4293105542 4292646796 4293174151 4292712333 4293045389 4293042570 4293371014 4293047700 4292980115 4292979601 4293309836 4293180318 4293573779 4293706148 4293640353 4293574315 4293904808 4293838781 4294036916 4294036415 4294036926 4294038468 4294037955 4294301627 4293053389 4286458178 4283698743 4284813619 4286387525 4285996615 4285795645 4286391363 4285209156 4284416066 4289948262 4292580745 4291979096 4290806647 4291198060 4291331189 4290739580 4291331188 4291594105 4290676597 4291133049 4291134069 4291462516 4290476923 4291200117 4290805111 4290608506 4291133818 4290870903 4290608247 4290148472 4290674040 4290343285 4290411384 4289951351 4289622136 4289753720 4289490552 4289951356 4289423972 4289949277 4291786584 4291850576 4291850337 4291524184 4291388764 4292972917 4293837449 4294038181 4294038695 4294037409 4294037666 4294037666 4294036896 4294038697 4294035851 4293707147 4292848273 4291719764 4288230731 4286918475 4287049546 4287970638 4288760660 4288298337 4288232779 4289219940 4288758351 4289021781 4289613659 4290010208 4290536555 4289874521 4288103004 4288824399 4288823137 4288104012 4289747310 4288892500 4288367462 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283434814 4284422204 4286463596 4287715946 4289230994 4290157479 4289829280 4290290094 4290749089 4290023564 4290149498 4289097324 4286853205 4284155698 4285797694 4288428876 4291517275 4292640367 4293037425 4293695616 4293173127 4293566849 4293567366 4293567366 4293565822 4293566596 4293567362 4293565816 4293563256 4293559657 4292246127 4293685334 4293441687 4288893818 4287184992 4286464871 4283172410 4283436352 4284160839 4284091462 4284291655 4284094019 4284356917 4287584386 4283896645 4284292675 4283700300 4284952660 4284424780 4284620614 4283961689 4285539666 4289098149 4287057781 4283500347 4285610600 4285670215 4283566133 4283763780 4283239232 4287848053 4286004097 4283435324 4283898956 4286930059 4285276241 4286203255 4287254410 4284553825 4286797962 4286992490 4286003833 4284554848 4285676130 4286925707 4288313507 4286462321 4288178827 4288246181 4287521941 4288840874 4290095029 4289832376 4288300405 4282779455 4282318924 4286796130 4288570000 4288114299 4292986571 4282318900 4283370562 4283303986 4283501628 4287048009 4285671758 4285733186 4286720584 4285405508 4284947267 4284815688 4283764280 4285076543 4284292682 4286331739 4285739342 4284357705 4285014089 4285082198 4284747058 4286259268 4285865032 4286979910 4290137166 4291124313 4291778642 4290073428 4287242313 4284548150 4284946752 4287050057 4288891230 4291256672 4291844696 4292108127 4292505449 4292306792 4292176740 4291980395 4292434538 4292637800 4292373350 4292505447 4292574061 4292504934 4292508525 4292965485 4292441193 4292572266 4292506727 4292506472 4292702585 4292705658 4292509804 4292837514 4292968055 4292970880 4292774275 4292971144 4292710528 4293299064 4293038468 4292646286 4293499520 4292712332 4293041543 4293435792 4292583311 4293438363 4292586387 4293832085 4293309085 4293243038 4293703313 4293574049 4293312422 4293705889 4293838245 4293772195 4293904562 4293838512 4294037429 4294036928 4294037697 4294037954 4294040010 4294303412 4291338413 4283498548 4284549440 4284552505 4286594913 4284613427 4285868616 4284943170 4284221501 4291458675 4291791482 4291323746 4290672248 4291134074 4291462785 4291528567 4291133820 4291133810 4291265139 4290935149 4290414198 4291068287 4291594101 4290606956 4290805369 4291264887 4290411127 4290936696 4290345336 4291002232 4290608248 4290542456 4290016376 4290082168 4290213752 4289622392 4289951097 4289622125 4290012787 4290538090 4291521121 4291653476 4292180564 4291326803 4291588442 4293437559 4293838215 4294037924 4294038695 4294037409 4294037409 4294037666 4294036899 4294037132 4294037160 4293837957 4292581225 4290073428 4287114315 4287508295 4287903321 4288560986 4288561744 4287707724 4288563539 4289152852 4288956245 4289611095 4290009183 4290534239 4290268506 4287317580 4288821839 4288757839 4287382859 4290004825 4288891731 4289940334 4288958559 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283631925 4284354873 4285077824 4286924651 4288441989 4289632408 4290487473 4290160031 4291339954 4290550426 4289171098 4289886065 4286789459 4284154675 4284746039 4288623686 4291387231 4292706158 4292903292 4293237120 4293632127 4293566081 4293172602 4293370227 4293567367 4293370485 4293567111 4293565563 4293563768 4293233775 4292838000 4291848035 4289743449 4291736011 4287647574 4286461267 4282974778 4283831367 4284359237 4283699017 4283963460 4284225095 4285742188 4285804369 4284289600 4283634760 4284226121 4284360272 4284159556 4284357694 4284354116 4285408862 4288772766 4286992769 4283632712 4285083992 4286394717 4283961924 4284156996 4283893314 4284357456 4288107129 4286264419 4283041592 4286337416 4285209176 4285214550 4287715730 4286531707 4286399337 4287322266 4287586446 4286733711 4284491630 4286135403 4287786916 4286068335 4288773300 4289035179 4287254411 4288512181 4290487478 4289829030 4288109703 4284621907 4283040831 4284290641 4289300674 4289295754 4293845459 4283630394 4283306315 4283371339 4283370550 4286590539 4285999434 4285996871 4286591822 4284814649 4284619070 4285010498 4284683574 4284358218 4284880444 4285475148 4287509836 4284095044 4285342542 4284883017 4284353848 4285604938 4285865032 4288492878 4290532446 4291189342 4291124570 4290201930 4286521416 4284023865 4285011260 4287511125 4289679463 4291515730 4291909210 4292108127 4292307305 4292109155 4292307049 4292241255 4292831339 4292175714 4292308323 4292898923 4292505446 4292965997 4292505190 4292439654 4292899949 4292506472 4292309880 4292509547 4292900715 4292638074 4292510062 4292835949 4292641645 4292772715 4292773248 4292972409 4292969597 4292712075 4292776067 4293103746 4293038471 4292712843 4293041298 4293372295 4293435011 4292979599 4293109387 4292980880 4292983444 4293375372 4292852130 4293639571 4293507998 4293838502 4293838257 4293904808 4293904562 4293838768 4294036673 4294037172 4294036927 4294038211 4294038725 4294104264 4294303161 4286988897 4283567671 4284876349 4285602109 4284811574 4286585930 4283762482 4284483134 4292377713 4291987831 4290536799 4291199088 4291528579 4291462765 4291265399 4291331190 4291002998 4291199356 4291265396 4290542444 4291528310 4290345336 4290476921 4291264888 4290411128 4290608248 4290542712 4290082680 4291068024 4290410872 4290082680 4290607992 4290214008 4289819513 4289951096 4289490809 4290080378 4290014052 4289092181 4291389799 4291789924 4292052322 4292779131 4292780157 4293376137 4293904009 4294038695 4294038180 4294037409 4294038437 4294037413 4294037903 4294036646 4294101628 4293571975 4291985504 4289020750 4287179592 4287838030 4288822607 4289021521 4287576151 4288431196 4289744221 4288892771 4289679708 4290007644 4290009440 4289611089 4287906637 4288363353 4288756812 4288757582 4289155172 4289810271 4289087581 4288432215 4288566128 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283370294 4283500339 4284224839 4286394713 4288838289 4289631382 4290356391 4290879910 4290748574 4290157735 4290219656 4289556864 4286987348 4283433778 4284155956 4287899466 4291060825 4292704366 4293036146 4293301121 4293566336 4293370742 4293632904 4293566080 4293565305 4293566596 4293764472 4293501316 4293565053 4293626483 4293099098 4292109407 4290072406 4293110924 4285341256 4284749115 4283372620 4284160580 4283633225 4283698245 4285015373 4284359501 4286262360 4284357960 4283765823 4284094534 4284424776 4284226883 4284025157 4284027461 4284423750 4285539912 4288970144 4286860422 4283236922 4285147991 4286858862 4285141573 4283501632 4283435836 4283305032 4284290112 4287976324 4286858882 4286332279 4285937776 4283631956 4285674850 4286728829 4285742979 4287060108 4287325342 4287653764 4287060124 4285081948 4286530684 4285676675 4288113293 4289429673 4288909487 4288638873 4289306038 4287455874 4284287031 4285675367 4283303996 4285998425 4291142328 4290482862 4293385423 4284026690 4283240779 4283371331 4283108162 4287312974 4286521928 4285866055 4287052111 4284815427 4285143876 4284226367 4283833936 4284620874 4284490318 4286328652 4285671754 4284290371 4284554051 4284683580 4284683576 4286324042 4284814906 4288757577 4290135625 4290267476 4291385426 4290069579 4288227660 4283960888 4285469755 4288823388 4289284179 4291518302 4291450962 4291912547 4292174699 4292042328 4292109156 4292439400 4292439656 4292043107 4293091423 4292899435 4292307560 4292308841 4292506729 4292901744 4292899692 4292508268 4292899432 4292900494 4292444779 4292904062 4292444530 4292901486 4292640636 4292969851 4292771704 4292971654 4293102452 4293103486 4292710789 4293104520 4292711564 4293041287 4293040773 4293041031 4292649628 4293111182 4292715410 4293046928 4293439130 4292981152 4293769880 4293180058 4293573790 4293706157 4293640104 4293772462 4293904573 4293838768 4294036660 4294036414 4294036926 4294038211 4294037954 4294037955 4294499521 4291600805 4283891761 4284419129 4285600574 4285074744 4284811319 4283566138 4285534789 4292314997 4292186502 4291128939 4291328868 4291463023 4291462788 4291265388 4291331181 4291132269 4291396983 4291134060 4290871167 4291462507 4290608252 4290936184 4290216818 4291001976 4290542456 4291002489 4290474614 4290146933 4290674296 4290542456 4290343285 4290477433 4289491308 4289556347 4289621616 4289424742 4289880418 4290341748 4291721065 4292120180 4293501313 4293241969 4293770375 4293969036 4294036897 4294037409 4294038180 4294038180 4294037411 4294037646 4294037157 4293838216 4293838990 4293237359 4291061334 4288099916 4288362574 4288757072 4288890194 4288103759 4288756302 4288890450 4289676888 4289612633 4289416796 4290534239 4290072659 4289611094 4288758351 4287641167 4288822352 4288037710 4289679197 4288957268 4289155692 4288565347 4288630626 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283369792 4283567170 4284421702 4286065754 4287718272 4289763224 4290421927 4290160562 4290684321 4291796634 4290089872 4289757307 4285603897 4283631934 4284221235 4287903309 4291713368 4292639838 4293101427 4293037185 4293567877 4293632391 4293173862 4293632390 4293172857 4293567110 4293501573 4293500544 4293565559 4293562485 4293493098 4292175717 4289152870 4287712344 4291006623 4283368507 4283108688 4284490570 4284488771 4283699768 4283962953 4285607762 4284423496 4284816453 4284159548 4284227143 4284028228 4283636305 4284292423 4283503952 4283567174 4286331242 4289631157 4286201454 4283630399 4284684874 4286924901 4284160576 4283566399 4283635015 4284884564 4283765846 4284884560 4286793834 4287256197 4286530428 4283962688 4286399606 4284425823 4287123596 4286335086 4287456670 4287189641 4286992263 4286070392 4286008192 4285936752 4286599820 4290091186 4289239736 4288906677 4289894319 4289697721 4284222525 4283633982 4286795647 4284612691 4289893035 4291408055 4292202951 4283236395 4283305026 4283370553 4283500343 4286657358 4285733437 4286064198 4288170586 4284159296 4284880452 4284356668 4284814146 4284618822 4285142085 4285671754 4285210695 4284554052 4284356169 4285082448 4285602365 4285996872 4286654541 4289152340 4290401104 4291514454 4290002505 4290201934 4288363079 4284878654 4285405258 4287905359 4290006361 4291583068 4291779425 4292566623 4292307550 4291976799 4292304228 4292439912 4292175209 4292637288 4292440681 4292440168 4292897377 4292965998 4292506986 4292505190 4292506987 4292570214 4292508012 4292443754 4292770941 4292443243 4292898666 4292444782 4292706427 4292574843 4292969594 4292773743 4292774779 4292905865 4292971640 4293102973 4292711822 4293500035 4292976275 4293041286 4293108116 4293041033 4293045133 4293044366 4292982422 4293045136 4292982675 4293311398 4293378202 4293705889 4293838256 4293904806 4293838769 4294036918 4294037174 4294037184 4294036926 4294037440 4294038211 4294038725 4294038725 4294697424 4286196543 4284089150 4284942648 4283959606 4285139769 4282713908 4286584124 4292514436 4292578421 4290734441 4291330419 4291462779 4291462766 4291265398 4291265407 4291396982 4291396725 4290607995 4291462507 4291264894 4290610802 4290870393 4290936184 4290673529 4290608249 4290214510 4290475626 4290669939 4290671989 4290017401 4290082680 4290277494 4289490811 4289621359 4289490021 4290141799 4290273375 4291588717 4292710779 4293961079 4293505936 4293705095 4293966725 4293838474 4294037154 4294038180 4294038695 4294037409 4294037667 4294036897 4294036641 4294168468 4293701749 4292253024 4289873994 4288036176 4288102224 4289478739 4289219410 4288692047 4288693329 4289742681 4289481813 4290071636 4289944153 4290072924 4288826456 4288497247 4288233038 4288233039 4288889937 4288890195 4289744735 4289087839 4289022052 4288566897 4288630373 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283369785 4283830089 4283897924 4285147986 4287912573 4289499542 4290617506 4291340200 4290618538 4290550169 4290221972 4289162609 4285802576 4283171897 4284942135 4287903052 4290665046 4292771698 4292904834 4293695099 4293566080 4293371257 4293632648 4293370486 4293567111 4293764473 4293501318 4293764730 4293499767 4293627764 4293034091 4292440164 4290078599 4290011769 4290411390 4282845248 4284294732 4284422222 4283831613 4283700557 4285214804 4284949583 4284030020 4284884047 4284161606 4284422976 4284163151 4284358727 4284618820 4284096587 4283894099 4287980949 4290089394 4286265948 4283106879 4283631417 4286990949 4285541462 4283236928 4285276246 4284686154 4283896391 4284951117 4284223318 4284160068 4285279317 4283567930 4286662784 4285080656 4287189630 4286792583 4287256458 4286728053 4285811313 4285675377 4286137981 4286005368 4286928769 4289496746 4289040821 4288903066 4288970400 4290094506 4286267258 4282910270 4284882003 4283696715 4289956505 4291935940 4291274407 4282318920 4283435067 4283307607 4283700030 4288298323 4286064712 4285669448 4288893023 4284030027 4285472584 4284489801 4284687697 4285339195 4284750915 4286524493 4285472843 4284354864 4284420677 4284422981 4285272892 4285929029 4288035151 4290267978 4290922318 4289019977 4290069582 4291058264 4288558154 4284941111 4285142588 4288629072 4289217365 4291973980 4292108383 4292307556 4292307301 4292109412 4292109411 4292632428 4292571992 4292505962 4292831842 4292898923 4292505960 4292307554 4292505704 4292505704 4292965470 4292508270 4292508012 4292964972 4292441961 4292902257 4292900715 4292705147 4292706428 4292838763 4293166970 4292575872 4292774532 4293100405 4292971144 4292515207 4293169025 4292711565 4293105028 4292715418 4292713367 4293042567 4293047971 4293044364 4293044877 4292979873 4293048467 4293309590 4293245604 4293706145 4293838255 4293772216 4294102710 4293838512 4294037430 4294036413 4294037954 4294037697 4294037440 4294037954 4294038725 4294565313 4290875543 4283629611 4284680505 4283763510 4284549942 4283106868 4287244103 4292644206 4292578680 4290540913 4291134068 4291462767 4291462777 4291659900 4291528567 4290739570 4291331191 4291594095 4291199102 4290479474 4291067508 4290676338 4290870649 4290739820 4290608250 4290476141 4290542714 4290083193 4290737526 4289886572 4290145655 4290017389 4289557103 4289556081 4290079856 4289750873 4291390304 4292384111 4293766027 4293637505 4293640322 4293639811 4293772701 4294036108 4294037667 4294038695 4294037153 4294038182 4294038160 4294037928 4294036110 4293706118 4292978296 4291586916 4288559688 4288625489 4289544781 4288170061 4288231756 4288758866 4289808473 4289547354 4290071642 4289812319 4291124319 4290006362 4289676624 4288233559 4288233039 4289021009 4288170076 4289939800 4289615200 4288431438 4288563545 4288631152 4288436062 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283370294 4283697210 4283961919 4285475419 4287913342 4290348951 4289829281 4290749856 4291274666 4290224802 4289499279 4289228403 4285934152 4283302964 4283303987 4288621388 4291518300 4292311381 4293035894 4293630069 4293567879 4293173117 4293566595 4293370486 4293566597 4293304696 4293764987 4293501575 4293565314 4293627764 4292836717 4292305762 4293372569 4289621369 4286266460 4283175752 4284949836 4283829062 4283501894 4285017168 4285343575 4284423239 4284094011 4284882755 4283960134 4284221515 4284489028 4284620614 4284027717 4283633992 4284619094 4288709799 4289038250 4285936213 4283368515 4283436606 4285542218 4286197335 4283566137 4285542732 4285671508 4283830092 4285086054 4284095565 4283565629 4284292191 4284687198 4285280858 4285937018 4284561262 4287584924 4286862461 4287589025 4286992522 4285678458 4285871992 4284885884 4287389606 4289038757 4289561258 4287058574 4289897398 4288575132 4288045969 4283436868 4283108679 4283957817 4288709013 4292069067 4286664543 4283369526 4283303740 4283239238 4284421435 4288234323 4285341244 4286458189 4287446099 4284746542 4285540430 4284422724 4284945206 4284161868 4285339710 4285935181 4284886870 4284355909 4284355134 4284944177 4286260555 4285208640 4288626258 4289281869 4289676367 4290987600 4291127140 4291779164 4288625996 4285533245 4285405506 4288432732 4289809495 4291515740 4292240997 4292109162 4291976541 4292501089 4292241507 4292508010 4292897388 4292832097 4293225318 4292440168 4292505960 4292699491 4292897890 4292700779 4292440168 4292570983 4292505191 4292506217 4292574573 4292509036 4292310653 4292508779 4292509805 4292705917 4292837755 4292577135 4293165703 4292904830 4292906367 4293104023 4292776838 4292777356 4292712844 4293106308 4293107346 4293045132 4293042569 4292652436 4293045920 4293440155 4292654488 4293375645 4293245859 4293771937 4293640105 4293772461 4293904562 4293838768 4294036671 4294036413 4294037183 4294036926 4294037440 4294038211 4294038725 4294170044 4293974461 4285530161 4284158523 4283500854 4284746551 4282975027 4288494933 4291986022 4292051058 4291132282 4291265910 4291725436 4291265398 4291330923 4291002494 4291396982 4291331181 4291133557 4291396972 4291133306 4291002483 4290674044 4290870903 4290542714 4290476921 4289948790 4290080887 4290540908 4290410873 4290016889 4289885305 4289687930 4289555823 4289488228 4290144365 4290272604 4291723653 4293701246 4293838470 4293905054 4293905055 4293770375 4293902728 4294036899 4294038437 4294038694 4294037923 4294037923 4294038701 4294036878 4294102676 4293637753 4292578404 4290401099 4288559949 4289348173 4288561744 4289215824 4289150288 4289545809 4289613147 4289415770 4289877077 4291058784 4289812824 4289415511 4288889675 4287055182 4288887631 4288298833 4289218389 4288826702 4289088085 4288564071 4288695142 4288633696 4288698227 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283370294 4283500345 4284749380 4287518321 4289565334 4290024609 4290290094 4290683301 4291076511 4289435287 4289426279 4285999440 4283565619 4285269050 4287967053 4290991437 4292310895 4293429097 4293235850 4293565306 4293765502 4293566338 4293567882 4293369971 4293370232 4293502605 4293763958 4293499771 4293562477 4293361241 4292633699 4292977040 4289357160 4285545320 4283239484 4285539664 4283569224 4285013329 4285934423 4284489544 4284160315 4284159566 4284486214 4284226619 4283696971 4285081679 4283434043 4283631687 4283172436 4286140813 4289690020 4288705938 4286263640 4283570251 4283306828 4284686150 4285082712 4283498560 4286137451 4285210185 4283767884 4284685894 4284754529 4284027202 4284097610 4284158534 4283832394 4286399092 4285280090 4286792558 4286796943 4288245667 4286793592 4285413486 4285676399 4284226381 4287518860 4290158517 4287787935 4288179879 4289436849 4287722129 4289237174 4288639134 4285541985 4283894085 4290812864 4289698481 4285078869 4288712386 4283105334 4283173695 4284554310 4287577171 4286129221 4286393930 4287113802 4284029253 4285733948 4285078077 4285143871 4285076287 4285079111 4285602629 4284948553 4285147732 4284422466 4285472069 4285998408 4287243079 4287509318 4291185999 4291121494 4291321692 4291844191 4291649110 4288822348 4284154682 4286128702 4289087308 4290464601 4291253584 4292240735 4292307305 4292307305 4292633190 4292175715 4292963179 4292242535 4292897643 4292440424 4292505960 4292701029 4292897890 4292307817 4292506216 4292962924 4292505704 4292898153 4292509550 4292312448 4292965996 4292509293 4292965741 4292510063 4292511092 4292445553 4292837497 4292577157 4292970861 4292905609 4292906620 4292711560 4293103489 4293105799 4292778123 4292780431 4293042834 4292975763 4293502855 4292980129 4292982670 4293046945 4293311897 4293245088 4293377955 4293444275 4293970599 4293706412 4294036917 4294036672 4294036402 4294037184 4294036155 4294038725 4294036669 4294038725 4294038726 4294434243 4289096313 4283301934 4283304759 4283632439 4282908722 4289746533 4292510306 4291787379 4291459954 4291461480 4291134330 4291330933 4290808181 4291200130 4291592562 4291002743 4291331181 4291265140 4290280817 4291198577 4290279545 4290936697 4290738541 4290409322 4290280570 4290541164 4290214267 4289688440 4289687930 4289491564 4289753721 4289753979 4289753968 4289224809 4291389802 4293109359 4293706902 4294103202 4294037935 4294036639 4293838215 4293839009 4294035593 4294037411 4294038694 4294038694 4294037925 4294037391 4294036884 4293837452 4293238641 4291982691 4288825934 4289018961 4289282637 4288692816 4288692816 4288104524 4289938769 4289546327 4290532701 4290338659 4290204757 4290600032 4289478500 4287513165 4288428888 4288757838 4288431955 4289746528 4288955997 4289221728 4288435307 4287841875 4288762737 4288038739 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283370295 4283566131 4284945223 4286794362 4289956748 4290024866 4290290077 4291209908 4291404191 4290155923 4289035136 4287049288 4282647604 4284549431 4286915657 4291124578 4292703837 4293364859 4293238130 4293370745 4293435769 4292976766 4293369970 4293632648 4293305466 4293897588 4293500292 4293564786 4293561710 4293360986 4292570457 4292184438 4287383664 4283499070 4283372872 4285144904 4284685131 4284884559 4284555333 4284093516 4283763773 4284354364 4284356675 4284158537 4284882504 4283635272 4283696962 4282974786 4284292435 4289632700 4288638352 4288377738 4285804881 4283369542 4283895357 4283568452 4284884045 4284356159 4286460254 4284160835 4285277515 4284286523 4284424268 4283503430 4285540694 4283635017 4284094041 4286067558 4284623446 4285084551 4285875054 4289233569 4287587734 4284224566 4284554089 4284423528 4287323537 4288912304 4288773549 4289695145 4289438903 4286263149 4286398568 4289960885 4286071933 4289034425 4290295992 4288902323 4289300134 4292205783 4284354361 4283172677 4284881979 4287705675 4285210431 4286654792 4285932360 4285932099 4284750916 4285670215 4285668412 4284291909 4285076795 4285537861 4284356931 4284423755 4285146954 4285209154 4285799239 4287836747 4290465637 4291516241 4291255643 4291584103 4291781720 4291189075 4288627273 4285202490 4286851661 4288167503 4289875546 4291712854 4292240999 4292109155 4292307049 4292637544 4292373346 4292440681 4292962914 4292440424 4292897635 4292832354 4292699500 4292440682 4292505961 4292962915 4292440410 4292505433 4292901745 4292506216 4292507754 4292509294 4292572779 4292509038 4292901486 4292903019 4292640636 4292968585 4292578163 4292970111 4293038463 4293037951 4293298309 4292646024 4293103233 4292778379 4292778381 4293041031 4293108104 4292652437 4293047441 4293045409 4292981146 4293376661 4293309862 4293573798 4294036649 4293772463 4293904560 4294036929 4294036659 4294036403 4294037184 4294037183 4294036926 4294037697 4294038211 4294038725 4294302401 4292978589 4282908718 4283304246 4283304247 4283367985 4290601576 4291983199 4292249717 4291064425 4291661707 4291528301 4291462776 4291462015 4291002731 4291068534 4290870908 4291594105 4291067769 4291198576 4291001198 4290280558 4290999414 4290478711 4290608250 4290476921 4290605687 4289755501 4290737272 4289621868 4290079864 4289753978 4289555823 4289489266 4289881192 4291521621 4293639322 4294168480 4294038192 4294038693 4294037666 4294036643 4294035850 4294037155 4294038180 4294038694 4294037923 4294038695 4294037928 4293904268 4293897848 4292774727 4290863962 4289477962 4289480776 4289019473 4288625744 4289216336 4289084752 4289348945 4290597211 4289810003 4290860380 4290991965 4289481300 4288301394 4288887374 4288232279 4289087058 4289154136 4288760917 4290009203 4288433242 4288630630 4288697956 4288697964 4287449704 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283435830 4283172922 4284420418 4286791782 4289230991 4290091424 4290225835 4291144098 4291140506 4290090371 4289624967 4286789958 4283958068 4284024372 4287570503 4290927968 4292704077 4293166981 4293629569 4293567623 4293370487 4293632130 4293567111 4293371256 4293566854 4293305468 4293763957 4293564531 4293562229 4293165933 4292437607 4291590512 4287844449 4283240778 4284684615 4284949586 4285475930 4285341771 4284088905 4284422207 4284157760 4284554059 4284288835 4283963974 4284421699 4283762751 4283372106 4284357720 4288707755 4288636552 4286528855 4287581823 4284750925 4283503179 4283239758 4283962190 4284357440 4285672024 4286002777 4284156212 4284819024 4283369784 4283499594 4284160837 4285673826 4285081164 4283433782 4285871715 4284687709 4285016670 4284029259 4288179602 4288772771 4284882277 4285017959 4286008211 4287786140 4288905381 4289035690 4289696432 4290028469 4289630388 4286461020 4290150829 4285404755 4289107122 4289962677 4287919500 4287725696 4287785073 4283237435 4283961655 4285277510 4287245899 4284420924 4286128201 4285736005 4286261321 4285208638 4284949839 4285670985 4285143356 4285605713 4285272630 4285208638 4284750400 4285468985 4286589772 4286589002 4288953415 4291778642 4291189081 4291649894 4291584102 4291584347 4291714141 4288754253 4284941877 4286659928 4288889930 4290335592 4292041814 4292108117 4292174943 4292108899 4292439401 4292373353 4292897377 4292440424 4292898924 4292766562 4292832100 4292242531 4292897620 4292897379 4292440424 4292964204 4292505704 4292439654 4292899948 4292899692 4292899435 4292507755 4292508780 4292706693 4292509806 4292509549 4292577135 4293165704 4292774531 4292969853 4292776318 4292906124 4293104002 4292711304 4292778379 4293107857 4293106575 4292716434 4293110414 4293044366 4293045903 4292979358 4293048491 4292982939 4293639589 4293311918 4293705638 4293774522 4293706164 4293838778 4294036670 4294037183 4294036412 4294037954 4294037697 4294037440 4294038725 4294106047 4294236098 4284750146 4283106868 4283304246 4283826227 4291193946 4291849060 4291526254 4291134324 4291661182 4290871157 4291856764 4290545269 4291462518 4291067513 4291330675 4291066736 4291134582 4290410873 4291199610 4291132013 4290217076 4291132269 4290804334 4289949547 4289425530 4290935150 4290212717 4289688188 4289753198 4289556079 4289490022 4290078312 4289682014 4291787124 4293835905 4294038437 4294038693 4294038694 4294037667 4294037134 4294036386 4294037666 4294038694 4294038694 4294038695 4294038182 4294036624 4293838475 4293632882 4292181082 4290267213 4289414986 4290003531 4289151053 4288560209 4288493645 4289414480 4289348688 4289942367 4289811287 4290927191 4289942366 4289347410 4288825181 4288168023 4288234572 4288498270 4288828502 4289941614 4288366168 4288631140 4288698227 4288630877 4287384159 4287052893 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283370294 4283631673 4284486985 4286924896 4288706963 4290091418 4290880166 4291275947 4290160548 4290089616 4289300622 4287316563 4283500082 4284679735 4287570760 4290335827 4292770658 4293166193 4293565308 4293566081 4293173372 4293568136 4293565568 4293567111 4293567879 4293370231 4293567368 4293172339 4293694324 4293230953 4292703338 4291324511 4287775594 4284226630 4285344344 4285999707 4283898182 4284159051 4283634745 4284160317 4284357190 4284486460 4284680260 4284423490 4283963970 4283305053 4284224840 4289627815 4286794607 4283630146 4287258252 4286925160 4285018699 4283831885 4283634496 4283701311 4284490574 4286333796 4285802322 4283502395 4285343308 4284288839 4283436597 4284552776 4285213781 4284753762 4283433526 4284689252 4285412447 4284554833 4285678209 4287262398 4287980958 4287784848 4286336904 4286664837 4287589536 4289299118 4289233823 4289760175 4286329690 4288841642 4289628091 4289300908 4290091964 4292593087 4288708744 4283498539 4282515522 4282712101 4285017693 4285932350 4286720846 4286194762 4283701314 4286851912 4285144386 4285867339 4284749891 4285472320 4285210442 4284617270 4286064971 4284685643 4285012547 4284621386 4286324291 4286785355 4287377224 4289808464 4291387737 4291977566 4291518560 4291518810 4291844441 4290858574 4287507272 4284743733 4287775578 4288955473 4290267479 4291978073 4292108122 4292109414 4292698980 4292371545 4292571753 4292898923 4292505705 4292832344 4293161325 4292767321 4292963181 4292440426 4292505704 4292505704 4292507242 4292898666 4292898666 4292442733 4292508012 4292901232 4292507755 4292573035 4292508524 4292510063 4292704891 4292969595 4292576880 4292838526 4292579450 4292839299 4292775806 4292776324 4293103747 4293104511 4293042589 4292714124 4293108875 4292717458 4293110156 4292652966 4293508489 4292654485 4293377187 4293245613 4293377952 4293705909 4293970096 4294102966 4293904302 4294036927 4294036412 4294036412 4294036155 4294037697 4294037697 4294038211 4294037957 4294499510 4288172642 4282777649 4283238709 4284090440 4291459437 4291981663 4291395688 4291132268 4291661450 4291330922 4290805363 4291462252 4290870909 4290807669 4290544756 4291134327 4291000685 4290348403 4290542457 4290476922 4290807667 4290542457 4290148987 4291001198 4290214265 4289885561 4289754234 4289752940 4288966001 4289620083 4290079588 4289879142 4290338398 4292185957 4293905310 4294037923 4294038695 4294038182 4294037155 4294035855 4294035595 4294037667 4294038694 4294038694 4294037153 4294036898 4294102419 4293440131 4292252264 4292109903 4290072410 4290005332 4290071382 4289612111 4289348682 4289414225 4289480261 4289677659 4290401361 4290338139 4290335060 4289545560 4288301396 4289281102 4288757838 4289087060 4289087838 4289810287 4288828248 4288565588 4288760679 4287972703 4287974241 4287642972 4287118676 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283435830 4283238715 4284156222 4286466157 4289430165 4289500824 4290290599 4290750898 4290814111 4290614938 4289889142 4287319912 4284024630 4284614199 4287045448 4290400848 4292770415 4293363570 4293564279 4293371256 4293566851 4293631616 4293239657 4293305191 4293303946 4293501299 4293436535 4293300611 4293166961 4292838015 4292311147 4290468213 4287779457 4285736526 4285540702 4285212756 4283764556 4284094024 4283831615 4284620875 4283896121 4284292164 4284749376 4283897168 4284485201 4285475930 4286201703 4285149000 4283172679 4284027970 4289100949 4286855786 4285805923 4283898170 4284094533 4283635789 4284816714 4286399602 4285670727 4283895107 4283962690 4283896655 4284157254 4283832384 4285605724 4285478748 4282843967 4284754265 4287516535 4284291414 4283700546 4285281628 4285607773 4287523503 4288772776 4288577455 4288048289 4289297820 4289238447 4287917198 4286525284 4286599289 4288969645 4289168039 4290092726 4291273141 4289169582 4286472858 4284618846 4284357702 4287189085 4283498547 4286657611 4284947271 4285211208 4286851148 4285209154 4285802058 4285406531 4285344847 4285471811 4285012285 4285998669 4284683062 4285013062 4285403968 4286392137 4287114310 4288296527 4290399311 4291780436 4291846244 4291715165 4291713632 4291584873 4291581514 4286849608 4285466940 4287577681 4288822862 4290858071 4291912036 4292240749 4292307284 4292241771 4292633191 4292373608 4292505703 4292505447 4292834670 4292767595 4292831843 4292242274 4292897379 4292440682 4292765027 4292505961 4292505705 4292505448 4292964699 4292441197 4292897367 4292508013 4292573292 4292574318 4292508525 4292508267 4292903549 4292642416 4292840070 4292772988 4292839555 4293103743 4292776325 4292776840 4292713358 4293105028 4293041799 4293107346 4293042568 4293044621 4293047198 4293047212 4292652964 4293377431 4293245601 4293443502 4293510051 4293641909 4293837750 4293576115 4293904312 4294036669 4294037184 4294037183 4294036926 4294036926 4294037440 4294038212 4294433987 4292124061 4282581032 4283172918 4284485177 4291654775 4292310113 4291195508 4291134333 4291462516 4291397508 4290870907 4291462774 4291132527 4290805623 4291199852 4290542974 4291264112 4290542459 4290738541 4291132527 4290280045 4290608250 4290475629 4290083694 4290409078 4289885816 4290606198 4289885561 4289621881 4289557117 4290079076 4290079582 4290078835 4292644477 4294035081 4294037153 4294038182 4294036880 4294036111 4293838217 4294036641 4294037409 4294038694 4294037923 4294038953 4294037653 4293968765 4293567353 4292571980 4290667352 4290795608 4289808978 4290004808 4289546583 4289676106 4289282902 4289414226 4289809491 4290991445 4290860638 4290467166 4289676883 4288432462 4288364626 4288364626 4288365904 4289088597 4289681257 4288696163 4288695144 4287975255 4288235597 4287514455 4286461267 4287182934 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435831 4283435831 4283304245 4284222528 4286595947 4288840339 4289565081 4290944676 4290685602 4290814890 4290025107 4289364349 4288044131 4285008951 4284155956 4287046473 4290466633 4292836208 4292970350 4293630846 4293565306 4293632385 4292909450 4293369221 4292974988 4292711801 4292973450 4293305218 4293366146 4292643708 4292772717 4291849587 4290145133 4289626279 4285145944 4283765824 4284949580 4283635015 4284094789 4284423491 4284352839 4284357956 4284686411 4283832912 4284094535 4285675875 4287650948 4284289341 4284027996 4283766847 4284619610 4287450228 4286266470 4287318635 4283632458 4284489801 4283566151 4285543001 4284687184 4285279835 4283832388 4284223813 4283833672 4284026431 4284422487 4285939817 4283632951 4284683865 4285082452 4286599034 4285605978 4283962943 4283567701 4283899478 4285543274 4288311457 4288252596 4289100713 4287715982 4289170611 4288377502 4287782790 4286134112 4286135131 4286142578 4288118944 4287455364 4290292137 4292784560 4289302194 4290678722 4288371585 4286202746 4288104797 4285078077 4284684604 4284945464 4284684352 4286527308 4287316829 4285143871 4285011517 4285669961 4285865796 4285141562 4284551993 4285008692 4287377481 4287375689 4288558925 4291185227 4291191391 4291911779 4291649628 4291453024 4291649883 4290926169 4286454599 4284747323 4288102225 4289744470 4290598493 4292239701 4292042329 4292307046 4292307043 4292043356 4292373865 4292898922 4292898666 4292835952 4292833882 4292833389 4292833388 4293160542 4292897621 4292110176 4292765278 4292700250 4292505962 4292439913 4292964955 4292440939 4292966768 4292506216 4292509294 4292967280 4292510063 4292509549 4292903034 4292774004 4293165447 4292383360 4292969596 4292971897 4293037694 4293103490 4292319378 4293170066 4292319131 4293174667 4292717973 4293110157 4292655770 4293506458 4292981921 4293311393 4293050288 4293575601 4293903800 4293378221 4294168501 4293838777 4294036671 4294037172 4294036413 4294037954 4294037697 4294037697 4294037441 4294169787 4293707711 4283827765 4282909748 4285471294 4292310110 4291982941 4291265130 4291199602 4291528065 4291072891 4291001970 4290279800 4291396467 4290871926 4290870394 4291066476 4290282612 4290543216 4290542714 4290672749 4291002235 4290542456 4290608250 4290279801 4290214008 4290082938 4289621612 4289753722 4289753199 4289555302 4289293672 4290536297 4291257954 4292975479 4293971360 4294037666 4294038437 4294036644 4293838216 4293838218 4294037412 4294038180 4294038694 4294038695 4294037669 4293904011 4293572730 4292776299 4291782741 4291058779 4290600284 4290990157 4289874518 4289347148 4289610570 4289480274 4289547864 4289480020 4289875797 4290466897 4289419101 4288956491 4289346896 4288036432 4289609547 4288040276 4289218657 4288235854 4289944435 4287840338 4288107620 4287382368 4287577435 4287710315 4287050570 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435830 4283435831 4283304245 4283895099 4286134618 4288768903 4289566352 4290814383 4291275170 4290684579 4290744714 4289759636 4288042844 4283892784 4284287028 4287112264 4290268501 4292376926 4293626483 4293563516 4293567107 4293567366 4293304183 4292909195 4293435526 4292450691 4292978063 4293304200 4292908911 4293429876 4292837485 4291653225 4291590026 4290211982 4285275987 4284951637 4283437638 4284092997 4284027718 4284159049 4284160829 4283894839 4285210696 4284882510 4284027960 4285346909 4285014855 4283502908 4284686405 4284620103 4283504198 4287778420 4286401135 4286722648 4284750666 4283373902 4285474901 4284886618 4283962167 4284949580 4284553286 4284491086 4284554820 4284424271 4284485184 4285018972 4284752477 4284553302 4286663800 4287253378 4284422476 4283766338 4283237437 4283765080 4284755809 4288247469 4289500086 4288439695 4288315568 4288640922 4288903861 4286792549 4287649158 4282581038 4283170870 4285082183 4286066510 4283566405 4284289332 4287251792 4287908170 4287454847 4289626782 4289758131 4289425057 4289563568 4288245145 4289161868 4287250009 4285338940 4286391114 4284814909 4284617270 4286128709 4284683577 4285077567 4285603396 4287704903 4288362318 4289152087 4291515720 4291649896 4291518559 4291845729 4292109672 4292043103 4290399819 4286522698 4285866048 4288036945 4289546590 4291450975 4292108122 4292109408 4292505187 4292373608 4292831340 4292699492 4292899179 4292439910 4292834412 4292833132 4292832600 4292833644 4292440169 4292373354 4292240990 4292308325 4292963429 4292832092 4292898925 4292505192 4292509808 4292505442 4292965229 4292505960 4292510319 4292706431 4292509546 4292642703 4292837496 4292773502 4292840307 4292971656 4292512391 4293038468 4293039747 4293105543 4293038470 4292844684 4292714384 4293175949 4292717714 4293111715 4292982156 4292982178 4293312170 4293311911 4293443243 4293115813 4293707700 4293904571 4293706420 4294036915 4294036414 4294036412 4294037183 4294036926 4294037697 4294038212 4294103995 4294303410 4286985042 4282515504 4286392390 4292045928 4291130725 4291527798 4290673785 4291265133 4291072135 4291133546 4291134080 4290610547 4290282099 4290347635 4291068276 4290542202 4291132268 4290476922 4291002235 4290214508 4291001978 4290543207 4290936947 4289950585 4290674541 4289556602 4289556346 4289555825 4289488986 4290799719 4290079840 4291915101 4293108608 4293971103 4294038694 4294038440 4294035063 4293839266 4294034832 4294035594 4293972646 4294038694 4294038182 4294036367 4294167191 4293240683 4292834639 4291126117 4291122509 4291255890 4289612631 4290596948 4289742156 4289480526 4289217097 4290071119 4290005326 4289942367 4290008160 4289938250 4288626768 4288167760 4288756560 4288169295 4289286512 4288894040 4289220713 4288366687 4287974232 4288825192 4288036178 4287513696 4287579729 4287580771 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283435836 4283435830 4283369787 4283566397 4285347428 4288310400 4290157213 4291075745 4290686381 4290617768 4291272860 4289628821 4287978846 4284483900 4284484666 4286522184 4290728270 4292374360 4293233526 4293236866 4293566336 4293566076 4293566852 4293436277 4293042301 4293763975 4293436020 4293631870 4293499257 4293234797 4293294958 4292838010 4291392648 4288563313 4284685894 4284949061 4284292430 4284489287 4284092732 4285015884 4284355651 4284357700 4284621387 4284288064 4283963715 4284094794 4283765570 4285015374 4285409625 4284094790 4284029257 4286333015 4286134634 4285541462 4284554824 4284160586 4285608541 4284620358 4283698509 4284690257 4285473869 4284225614 4284419907 4283699523 4283567684 4285278036 4284884062 4283895362 4287782023 4286135913 4282647094 4285807752 4282908725 4284293970 4285806720 4286997130 4288837282 4285480559 4289763008 4286071679 4287784578 4289363366 4287718018 4286329448 4283040570 4284947772 4287059581 4283565117 4283502902 4287378763 4282384442 4282778419 4285999172 4285805125 4284552766 4289884777 4288636790 4287778402 4287781509 4286457416 4285145924 4285013062 4285408586 4284883022 4284551480 4285340740 4286327627 4287443017 4288689998 4290201418 4291975272 4291584351 4291518302 4292110446 4291190880 4291914081 4290264140 4285996103 4286588746 4289218141 4289151060 4291714646 4292637036 4292500577 4292241257 4292637544 4292109671 4292571752 4292505447 4292898666 4292900205 4292439910 4292768108 4293157733 4292833627 4292571498 4292373860 4292765533 4292109924 4292963172 4292505689 4292505448 4292965228 4292508013 4292509551 4292899435 4292508781 4292901486 4292904060 4292640632 4292640378 4292839038 4292970366 4292772988 4292970109 4293103486 4292775811 4292778119 4293104007 4292384145 4293174153 4292717715 4293110157 4292717200 4293047972 4292982188 4293442721 4292982692 4293246129 4293969592 4293838262 4293772212 4293904826 4293838777 4294036669 4294036412 4294037183 4294037183 4294036926 4294037697 4294037442 4294564802 4290541435 4281860138 4288101201 4291850596 4291788388 4291527540 4290542460 4290873455 4291593591 4291134584 4291330419 4291134060 4291198841 4290151027 4291263600 4290348403 4290542460 4290608999 4289951855 4291199604 4290542457 4290411629 4290214265 4290345850 4290146666 4290411386 4289687149 4289557104 4289754737 4289426560 4290276959 4291914845 4292782990 4293838213 4294037410 4294038439 4294036113 4293706119 4294034832 4293970849 4294236839 4293973158 4294037413 4294103443 4293641095 4293301099 4292047191 4290990925 4290597983 4290600796 4291055442 4289217876 4289612117 4289150796 4289546068 4289480527 4290529870 4290531159 4289611342 4288890960 4288756816 4288231760 4288821064 4289219677 4288826710 4289022814 4289355373 4287709009 4287907671 4288105560 4287380051 4287579231 4287514718 4287580000 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283369781 4283369781 4283369785 4283830604 4285080140 4287847553 4289696652 4290355624 4290684064 4291470752 4290486683 4289694848 4287912033 4285077822 4284155443 4287113288 4290401104 4292899950 4293034859 4293236355 4293566589 4293566852 4293566595 4293566596 4293436794 4293370231 4293567882 4293566849 4293237875 4293495938 4292968538 4291916389 4290542997 4288694897 4284553540 4284094029 4284421701 4285410139 4284091960 4283961926 4284027975 4284224059 4284292430 4284226635 4284226379 4284029762 4284883789 4285476956 4284227400 4283437636 4285407318 4285872995 4285542742 4284686924 4283831879 4285081167 4284226635 4284356172 4284292428 4285475664 4285674587 4284026681 4284092989 4283370816 4283699519 4286067035 4283238473 4283962434 4287455365 4286070897 4283302461 4283899978 4286796440 4285738092 4286007421 4286664327 4288509863 4287324312 4287981208 4288316322 4286991763 4288706979 4288773536 4288509341 4284350533 4284158521 4288375935 4283105336 4285669192 4284685641 4282977349 4285339964 4286264399 4285340223 4283899211 4285672012 4283899198 4285865287 4287579976 4289362291 4285472583 4285733958 4284487229 4285339967 4284683577 4285406787 4287834953 4288428622 4288626253 4290857813 4291715155 4291124570 4291781222 4291584867 4291913572 4292110696 4288429389 4284747320 4287641178 4289087571 4289810003 4292308330 4292108643 4292307549 4292241001 4292373352 4292571751 4292700522 4292441706 4292898666 4292439910 4292833386 4293160558 4292376170 4292898671 4292505945 4292765287 4292699750 4292308073 4292505960 4292572780 4292570983 4292506987 4292504934 4292506474 4292899436 4292509038 4292508780 4292311674 4292771964 4292445295 4292905862 4292577155 4292839812 4292644472 4292776325 4292842376 4292776583 4293105543 4292844171 4292778638 4293106825 4293110414 4292718230 4293047443 4293114011 4292588703 4293442732 4293310888 4292984493 4293509806 4293970619 4293772212 4293904313 4294036926 4294036669 4294036412 4294036412 4294037183 4294036926 4294037699 4294301618 4292390832 4281860131 4289019985 4291781719 4291788388 4291263614 4291134067 4291005307 4291659126 4291265665 4290151025 4291002237 4290871163 4291593845 4290739578 4290017134 4290411372 4290542460 4290804077 4290476921 4290607992 4290608249 4290674041 4290541420 4290214267 4289556601 4289951099 4289491310 4289556336 4290341728 4291126364 4291390553 4293237112 4293772678 4293904542 4294038698 4293838219 4293902203 4293838476 4294036383 4293973159 4294038696 4294037904 4293838733 4293964666 4292053094 4291714122 4291058009 4290533464 4291318606 4289680224 4290596690 4289414226 4288693581 4289149257 4289612118 4289480533 4289677391 4288956746 4288295758 4288232016 4288167246 4289022546 4288955724 4289419104 4290008188 4287645781 4288561758 4288039767 4287974243 4288036699 4287447902 4288302691 4287450206 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283960640 4283501890 4283304255 4284025154 4284883529 4287979395 4290023317 4289893013 4290815666 4290815394 4290026390 4289957775 4287847019 4284748348 4284288818 4287048521 4290334798 4292111976 4293100653 4293694327 4293565819 4293370229 4293436024 4293370488 4293567111 4293436023 4293370488 4293370744 4293172856 4293694324 4292967274 4292050303 4291135382 4289811308 4285013062 4284815686 4283963464 4285211721 4284353350 4284488005 4283895099 4283766092 4285015373 4283763772 4283897157 4284819030 4286133592 4285411420 4283828541 4284490848 4283898429 4285672037 4285212502 4285540424 4285475419 4284819534 4283305279 4283833160 4284028227 4284227144 4286861175 4283959367 4283698502 4283897917 4284883031 4285146695 4283301954 4285675631 4286333031 4285215345 4286402954 4283568724 4286663804 4286860676 4285676136 4287583613 4285939559 4288376733 4287259544 4287060102 4286138234 4287588001 4289036707 4290025136 4286730368 4283499048 4288113563 4283238439 4285602879 4283567941 4283568440 4286065229 4285865535 4285736785 4284093499 4286393931 4285472325 4285931331 4284353847 4287050314 4286259783 4284489030 4284815934 4284024884 4285206070 4286456905 4287510351 4288757073 4289283661 4291250509 4291257184 4291977322 4291649886 4292046181 4291913567 4291321175 4288492619 4285011527 4288035148 4289746032 4290728532 4292371557 4292505443 4292108387 4292571752 4292571239 4292700525 4292899178 4292898666 4292441449 4292834669 4293095021 4292769885 4292506731 4292441706 4292766567 4291979359 4292571754 4292963165 4292897379 4292505704 4292505706 4292897881 4292834673 4292900445 4292442477 4292507243 4292508782 4292574060 4292509805 4292707460 4292642159 4292838785 4292970867 4292643466 4292775806 4292841603 4292776583 4293105799 4292776327 4292778379 4293106311 4292718229 4293044366 4293506443 4292655264 4293504673 4292982949 4293509293 4293443243 4293575600 4293838006 4293641906 4293839799 4293904313 4294036669 4294036412 4294037183 4294037954 4294036926 4294036927 4294169788 4293711032 4284678203 4288628304 4291585639 4291789674 4291397237 4290674558 4291790208 4290088060 4291199355 4291067516 4291134058 4291134069 4290542459 4291789938 4290608498 4291133565 4291068273 4290476921 4290739835 4290348145 4290607992 4290279800 4289819770 4290082925 4289622895 4289491309 4289754235 4290869369 4290472039 4291589476 4291257952 4292577142 4293307504 4293839246 4293966457 4293969299 4293902717 4293838220 4294037924 4294038694 4294038695 4294037157 4293903504 4293373030 4293033060 4290795345 4291124056 4291188312 4290728541 4289874772 4290005595 4289743182 4288495696 4289216589 4289677384 4289548118 4288625488 4288427596 4287179848 4288822350 4289154145 4288957524 4289942127 4289088099 4288432474 4288759898 4287186258 4288891509 4287253074 4288235875 4287380814 4288038501 4288237421 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283238466 4283697202 4283501881 4283894592 4284816454 4287519845 4289498013 4290025370 4290946721 4290160035 4290549916 4289826444 4288440434 4284881728 4285405502 4287045448 4290335055 4292309339 4293100910 4293300350 4293238151 4293436279 4293173375 4293369972 4293632131 4293173898 4293369971 4293566082 4293631352 4293298027 4292769896 4292709514 4292115849 4290080640 4284617535 4285738067 4284352828 4284884558 4283635785 4283960629 4283893322 4284358477 4284554823 4283437640 4286530159 4288106359 4285343303 4284752460 4284094788 4283764555 4284161348 4285739095 4284884045 4284754257 4285342795 4284554825 4284425036 4284751432 4283573074 4283962951 4285214285 4284489806 4283698243 4284091466 4284688198 4285016170 4282712634 4287717001 4285214310 4284489814 4287060097 4285739875 4282843948 4286604949 4287715747 4285744521 4286400149 4286934683 4288447151 4287982762 4285807719 4284487762 4286399344 4288770970 4290222273 4286196567 4286926965 4284225599 4285142088 4282975036 4284096330 4286391367 4285211465 4284355132 4284749373 4285801541 4286263116 4285405251 4284686924 4285141557 4285278797 4284488259 4284159302 4284880954 4285403963 4286785351 4287968590 4289083726 4290398798 4291120985 4291256412 4291582300 4291519842 4291650661 4291715431 4290597458 4286455622 4285012293 4288167515 4289611866 4290992731 4292110178 4292306793 4292241256 4292964458 4292441450 4292900204 4292439910 4292505447 4292899948 4292767337 4293097074 4292834413 4292833130 4292833388 4292633699 4292964716 4292505961 4292307555 4292505960 4292898925 4292898138 4292832862 4292898652 4292441196 4292897896 4292902513 4292902000 4292508525 4292509807 4292902505 4292446587 4292970093 4292772993 4292774771 4293169280 4292710789 4293170056 4292711304 4292776327 4292778123 4293108103 4292718486 4293502599 4292259995 4293112736 4292983465 4293049507 4293115047 4293443500 4293442987 4293313963 4293838006 4293641650 4293576113 4294036670 4294036412 4294037183 4294036155 4294037183 4294037183 4294037699 4294237629 4288368753 4289283409 4291391581 4292050781 4290871936 4291131505 4290939758 4291330430 4290216577 4290413939 4291134088 4291199603 4290216576 4290476923 4291265150 4290216560 4291133308 4290871412 4290936184 4290542199 4290542200 4290545266 4290016888 4290214010 4290344557 4289556603 4290278253 4289884268 4290804067 4291914602 4291260255 4292047188 4292905067 4293437035 4293244023 4293242996 4293832822 4293904268 4294037668 4293973159 4294037410 4294037395 4293903229 4293502841 4292309834 4291123039 4290597718 4290726992 4290859342 4289940053 4289807947 4288626000 4289215823 4288759380 4289808732 4289545038 4288298065 4287308869 4288032842 4288301136 4289810020 4289875557 4288366682 4288564562 4288628046 4287251294 4287383124 4288694102 4287906911 4288105045 4288303997 4287450976 4287514717 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284028211 4284027722 4283698243 4283565885 4284421445 4286729324 4289300117 4289501337 4290290611 4290814616 4291076000 4289759881 4288373619 4286395465 4285141307 4287048776 4290070350 4292506988 4292968813 4293301364 4293436021 4293566597 4293566851 4293566852 4293238909 4293436022 4293567111 4293567623 4293562488 4293104241 4292834665 4292378494 4292974207 4290598266 4284290363 4287909753 4283897405 4284553288 4283370820 4283437641 4283633478 4284619081 4285474640 4286991742 4287053663 4284555071 4284027467 4284223802 4283306571 4284226897 4285213783 4285671251 4285280090 4284554567 4284028998 4283897416 4285934166 4284556622 4284557135 4283110481 4284817996 4286728831 4283042118 4285672537 4283765822 4284885865 4285215581 4285544803 4285211727 4285080422 4286267494 4288047015 4282318926 4283106356 4288053932 4289378768 4287457686 4288974266 4287259269 4287456400 4287124868 4285346930 4284490849 4287853490 4287980695 4288314796 4287851179 4286332775 4289505747 4283236393 4284160068 4286457416 4284882765 4284751428 4285407044 4285865545 4285998406 4284226112 4285471296 4284750658 4285078852 4284750149 4284485433 4285206070 4286127684 4287707472 4287707217 4289215813 4291318107 4291579991 4291385692 4291584096 4291518304 4291977053 4291125336 4290071897 4285274947 4286786124 4288498000 4289350501 4291585379 4292239965 4292439401 4292373351 4292833386 4292832873 4292834413 4292898669 4292441194 4292835951 4292767596 4293093704 4292440170 4292831842 4293160285 4292832858 4292440426 4292700249 4292571753 4292373097 4292506201 4292242285 4292963156 4292439914 4292965228 4292442732 4292507499 4292508525 4292510319 4292706430 4292706173 4292510834 4292837499 4292773503 4292970367 4292774019 4292971641 4292776325 4292971902 4293106562 4292778124 4292779919 4293107591 4293044107 4292784537 4293111436 4293048732 4292652449 4293181352 4293310889 4293050029 4293773493 4293838005 4293904570 4293904313 4294036669 4294036412 4294037183 4294037183 4294037183 4294036412 4294036928 4294432946 4291332237 4289807955 4292441700 4291592563 4290605924 4289424485 4290673533 4290477681 4291000685 4291329905 4290674291 4290216562 4291070591 4291725166 4290807418 4290282624 4290282096 4291133307 4290282096 4290936711 4291068029 4289885302 4290410873 4290411128 4289622649 4290279545 4290411642 4290475385 4291260268 4291196772 4291719266 4291786074 4291721308 4291919713 4292972398 4292318050 4293439363 4293904267 4293972646 4294236582 4293972649 4294036863 4294033539 4293237349 4291455828 4291056471 4290727753 4290267995 4290464335 4289544789 4289348944 4288625484 4288693330 4289874267 4288693067 4288365646 4287902796 4287508295 4287118937 4289283668 4289748321 4288826711 4288563548 4288695913 4287841364 4288035421 4288037718 4288040549 4288105827 4287972444 4287383632 4287648359 4287116628 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284026682 4283436096 4283501881 4283238207 4283962423 4286990959 4288772231 4289632160 4290552220 4290816686 4291271570 4289694860 4288705663 4286722373 4285932361 4286325575 4290399308 4292309598 4292969069 4293300617 4293631356 4293370744 4293370229 4293697153 4292911486 4293042301 4293632132 4293371000 4293564267 4293298810 4292837485 4292112745 4292976527 4289944179 4285405770 4288238699 4284226119 4284553543 4283501646 4283569743 4284620367 4286465382 4287515759 4284948295 4284163405 4283701319 4283898952 4284029253 4283698759 4284094530 4285805418 4284883537 4286132831 4284423239 4284424780 4285081167 4285607510 4286198369 4285017169 4284357451 4283044423 4285739863 4285213783 4284292427 4283762763 4285017171 4288046238 4284420930 4283635272 4284620612 4284815953 4287260283 4285478517 4283436367 4283108677 4285415518 4286201473 4287918481 4287197617 4287983002 4285411936 4284617282 4284291940 4286599550 4288377521 4290027439 4289229745 4289110718 4288705668 4282712125 4284554308 4285603143 4284748086 4283437375 4286063684 4285143102 4284881477 4285143098 4284553279 4285143615 4284355129 4284750400 4284747572 4285535548 4286325577 4288031814 4289021002 4290070361 4291188821 4290927447 4291649883 4291323235 4291583840 4291584347 4291386207 4288558663 4284419647 4287706447 4288890188 4290796638 4292109666 4292241514 4292439144 4292571495 4292833130 4292900206 4292442202 4292898412 4292835165 4292770159 4292768619 4293160815 4292440167 4292898923 4292374633 4292505448 4292505705 4292765031 4292175208 4292373859 4293223775 4292898394 4292242021 4292572522 4292508268 4292899435 4292900718 4292510577 4292899949 4292640364 4292509550 4292511092 4292837755 4293362553 4292380534 4292839813 4293102196 4292841344 4292775551 4292776585 4292777607 4292647807 4292777870 4292784021 4293175436 4292260252 4293505176 4293442478 4292982692 4293575085 4293115825 4293573036 4293642420 4293904569 4293838776 4294036669 4294036669 4294036412 4294037183 4294036412 4294037183 4294036926 4294104005 4293642939 4290725447 4292247910 4291656797 4290015087 4288959841 4289096043 4288964458 4290080370 4290082161 4290606702 4290936188 4290674284 4291199863 4290742132 4291594115 4290870908 4290085244 4290807677 4290544500 4290153065 4290739336 4290282603 4290151026 4290213497 4290083437 4291064427 4291396202 4291197796 4291526514 4292181346 4292180067 4291261278 4291912788 4291194451 4292838256 4293243762 4294101903 4294171305 4293972904 4294038420 4294100628 4293506682 4292971117 4291846993 4291056205 4290793303 4289875799 4289544264 4288759638 4289150543 4288101203 4289677137 4289348431 4289479758 4288428110 4287375941 4287247953 4289347667 4288761689 4289876839 4289153119 4288431181 4288430941 4287380811 4287513953 4287315795 4288037979 4288171621 4287972184 4288370802 4287052875 4286853709 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283829312 4283501875 4283697210 4283700035 4283632963 4286332250 4289036429 4289565853 4290683806 4289763491 4290025107 4289825932 4289230198 4286659157 4285338175 4287572295 4290069329 4292571211 4292773490 4293495934 4293565557 4293566082 4293435765 4292976251 4293501816 4293632132 4293370487 4293566853 4293565558 4293627775 4292969326 4291716195 4292973702 4289949804 4285930313 4287516269 4285014089 4284224322 4284289850 4283898190 4284489808 4284816452 4284357444 4283966029 4284619843 4284226380 4284026692 4284554828 4284224585 4284096592 4285146451 4285411669 4285739619 4284751688 4284097350 4285279065 4285080660 4284555077 4285278039 4285343052 4285079624 4285805147 4284421186 4283699520 4282975304 4285610853 4287059840 4284421444 4283434568 4283897172 4285150554 4287787178 4286987624 4285348210 4283700047 4284029764 4283700803 4283699541 4286073717 4288714415 4287061907 4283699537 4284488016 4285674097 4285217642 4288574374 4291147964 4289899696 4284290368 4284222774 4285143102 4286194244 4283962958 4284485169 4286391114 4285278035 4284881471 4284227404 4285405759 4284353600 4284027962 4284814905 4285468477 4285339197 4286787403 4287966793 4288692299 4291448660 4290991195 4291515482 4291584347 4291781989 4291583840 4291715677 4291187792 4286454857 4284816717 4288038735 4289283170 4292043357 4292174688 4292963677 4292109667 4292571496 4292898922 4292439910 4292898411 4292441706 4292832618 4293161582 4292771953 4292834155 4292833129 4292767596 4293161567 4292769136 4292900191 4292441692 4292571498 4292373092 4292439654 4292835185 4292897121 4292506987 4292506473 4292899692 4292507755 4292507242 4292510320 4292901488 4292903277 4292509295 4292445554 4292641921 4292707954 4292446068 4292839301 4292382591 4293168768 4292775812 4293171079 4292778895 4292845452 4292781714 4293110670 4293109899 4292653733 4293047710 4293048743 4292982692 4292983977 4293247656 4293705393 4293970361 4294036926 4294036669 4294036669 4294036412 4294037183 4294037183 4294037183 4294037183 4294037184 4294236092 4291257708 4292313189 4290735962 4288039755 4287907151 4289157726 4288827218 4289159264 4289093479 4289031288 4289424227 4290540154 4290080631 4291068026 4290870125 4291199870 4291528310 4290479235 4290610548 4290478722 4290217074 4290476411 4290476923 4290673785 4290476915 4291265662 4291592304 4291921787 4291789409 4291985266 4291787356 4291394912 4291323747 4291395178 4292182632 4293638545 4294038438 4294170790 4293973160 4294037909 4294101399 4293438048 4292967507 4291321431 4291120465 4290270551 4290071125 4289480531 4289348428 4288558413 4289545550 4289809506 4288824652 4287771211 4287378767 4287311947 4288693066 4288169038 4290006886 4288235610 4288893026 4288301913 4287971933 4287445588 4287316832 4288825433 4287253078 4287514185 4287515499 4287578975 4287382093 4285801030 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283829567 4283698494 4283697467 4283436858 4283567173 4286991469 4289233822 4289630604 4289895076 4290289316 4290616990 4289564815 4288639356 4286726230 4285800262 4286915655 4290332748 4292307556 4292969327 4293299313 4293171581 4293632128 4293566851 4293632389 4293369973 4293566596 4293370488 4293566077 4293564797 4293627769 4292903005 4291913832 4292575089 4289685386 4285998666 4286987355 4285278806 4284096324 4283896651 4283699768 4284159547 4284423240 4284488773 4284358470 4283766351 4284291130 4283833159 4284818520 4283503173 4286003293 4284619849 4286196575 4284227142 4284424287 4284949845 4286992751 4285606742 4283765826 4284292429 4284225855 4285147470 4284552767 4283636291 4283566413 4283697976 4286796409 4284423239 4284620616 4283898953 4283896146 4286925444 4288443555 4288445096 4284687699 4286529396 4284422989 4284620877 4283108685 4283698750 4286997895 4289565621 4283764283 4284357977 4287125381 4286924924 4285213266 4288579485 4287650942 4283039792 4284684864 4285668926 4285209664 4283434802 4284945981 4285735496 4284357187 4284355128 4284550976 4284878388 4284026683 4284551483 4285340992 4285273405 4285537604 4287770439 4287576147 4290070601 4291121232 4291579996 4291451219 4291385179 4291584102 4291256414 4291649621 4289018193 4284488262 4285933125 4288887632 4290269522 4291913830 4292306782 4292571755 4292637288 4292374635 4292440167 4292898666 4292833129 4292832873 4292834413 4292769384 4292833899 4292377195 4293160559 4292768347 4293096801 4293095774 4292767597 4293226607 4292831837 4292505946 4292505707 4292831826 4292899182 4292505192 4292508269 4292901231 4292442219 4292965998 4292510064 4292510063 4292508013 4292707183 4292968058 4292837755 4292838251 4292840070 4292971898 4292841345 4292776311 4292843899 4292383629 4293172357 4292712331 4293108618 4292715922 4293044619 4293505960 4292653990 4293048986 4293376940 4293181618 4293247142 4293903798 4293378999 4293904312 4294036669 4294036669 4294036412 4294036412 4294037183 4294036926 4294037183 4294036927 4294171071 4292845724 4292242507 4288628558 4288759114 4286918734 4287975756 4287969616 4287842379 4287712073 4288958546 4290011242 4289030499 4289685866 4289425520 4289948793 4290608506 4290082681 4291002492 4290477164 4290345336 4290542203 4290284923 4290476667 4290345580 4291329390 4291066477 4291922814 4291724389 4292707956 4292113746 4292245846 4291521884 4291458390 4292113511 4292053350 4293904520 4294037668 4294171046 4293973162 4294036607 4293837456 4293040224 4292046947 4290991440 4290728272 4290135117 4289610308 4288757838 4288755277 4288693072 4288890448 4289152076 4288560975 4287440969 4287442760 4288559950 4288563305 4288959333 4288892760 4289086544 4288431960 4288693856 4287312980 4287974231 4288628310 4287843942 4288959082 4287449430 4287647843 4287183437 4286326601 4286062664 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283829563 4283501877 4283501877 4283696967 4283962946 4287052645 4288312195 4289565842 4290290599 4291341740 4290815395 4290222743 4288770932 4286591312 4285801286 4287048010 4290132549 4292178025 4292575326 4293759105 4293697659 4293171585 4293631616 4293370229 4293435508 4293632903 4293370486 4293567367 4293565302 4293561980 4293428059 4292306522 4291125600 4289290875 4285935182 4287515254 4286195275 4283695687 4283569219 4284029255 4284554826 4284885585 4284226112 4284621903 4284227140 4284094533 4283634503 4284357194 4285147737 4285278283 4284754776 4285344590 4284162122 4283636812 4284952913 4285938020 4285608013 4283831364 4284028224 4283763023 4284752456 4284359500 4283829822 4284156226 4284224836 4286270585 4283894068 4284751698 4285740641 4284027468 4285409118 4287787937 4287915674 4288773547 4283962681 4285804373 4284161367 4282910271 4284357703 4285149280 4285348180 4284950372 4283960896 4287193751 4288376470 4287121288 4288178814 4286530661 4283760693 4285798718 4285997894 4284550712 4283899461 4284684607 4285075761 4284947522 4285013316 4285075764 4283631670 4284483638 4284813621 4285535806 4286066508 4286195271 4287967818 4289412423 4290860891 4291122012 4290992462 4291449946 4291388767 4291453790 4291387229 4291123538 4287637318 4284028487 4287247438 4288627280 4291913314 4292636266 4292439396 4292240989 4292175209 4292571495 4292898922 4292441450 4292899948 4292834412 4292375401 4293163122 4292834155 4292770416 4293161309 4292767596 4292767083 4292770674 4292832087 4292374634 4292897635 4292505707 4292505960 4292897391 4292440154 4292571994 4292504936 4292506729 4292966512 4292443759 4292901743 4292706688 4292510063 4292509551 4292904305 4292642676 4292445042 4292641152 4292644474 4292841345 4292775552 4293103748 4292777357 4292776844 4293105286 4293040262 4293108877 4292783251 4292718485 4293111711 4293047723 4292981916 4292983468 4293509557 4293510585 4293707441 4293904313 4294102461 4294036412 4294038211 4294036412 4294037183 4294037954 4294036926 4294037697 4294104263 4293641136 4289548890 4287771727 4286919758 4286586440 4287904074 4286458440 4287706962 4287575121 4287382863 4287184973 4288562508 4288499542 4289286246 4289095783 4289816156 4289096044 4289555306 4290082428 4289885562 4290017145 4290214507 4290739320 4290348929 4291396736 4291988329 4292119163 4291990388 4291720278 4291524702 4290867033 4291652191 4291916126 4291722332 4293438085 4294166673 4294038438 4293972902 4294038187 4294101634 4293769069 4292643679 4291912538 4290662736 4290529348 4289215563 4287641424 4287900743 4287641166 4289086033 4289088077 4289019982 4287377225 4287048006 4287444046 4287707725 4289222242 4290005345 4288300127 4288432217 4288040293 4287842646 4287970644 4287775839 4289484652 4288697956 4288103519 4287515734 4287183702 4286855248 4286063944 4285143874 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283697462 4283567421 4283369781 4283238713 4284353860 4285408575 4288048269 4290683030 4291341236 4290620074 4290751141 4289829529 4290478462 4286989655 4285865797 4285865542 4290331733 4292240972 4292901998 4293167219 4292908923 4293302896 4293239947 4293435507 4293239182 4293041785 4293567111 4293698938 4293499512 4293563502 4293494637 4292637805 4291322977 4289091962 4286526818 4286791516 4286921566 4283043142 4283633471 4284226112 4286000731 4284159554 4284418374 4283570496 4284290123 4283832397 4284292172 4285803338 4285673826 4283635784 4285411161 4285540693 4283308625 4284358213 4285803112 4284818759 4286657634 4284227659 4284554565 4284225088 4284026421 4283959622 4284620873 4283501895 4284554832 4284226120 4283831877 4284429691 4285280606 4288311989 4287320724 4286729873 4288577691 4289306294 4285084273 4283894597 4285414499 4286397822 4283699003 4285146188 4284554566 4284093262 4284750407 4288247727 4285277519 4287452790 4288968356 4284880451 4284091960 4284685379 4285930047 4283369786 4284618040 4285407049 4284159558 4284290373 4284027704 4284289595 4284353596 4284551990 4285075769 4285340743 4286917706 4287639881 4288164943 4289940298 4291647315 4290991445 4291319900 4291842653 4291647062 4290928218 4291780183 4289609545 4284022846 4285998665 4287969359 4289808728 4292307290 4292306788 4292241253 4292373604 4292439145 4292571751 4292897130 4292899174 4292377196 4292834156 4293163365 4292771442 4292375402 4293226092 4292375916 4292834157 4292769886 4292834414 4292834671 4292898908 4292832101 4292832859 4292897380 4292506204 4292897381 4292505705 4292965999 4292505193 4292507998 4292505946 4292509041 4292442458 4292901747 4292510064 4292509551 4292706670 4292643961 4292839279 4292839559 4292774516 4292971643 4293038469 4293104252 4292778119 4292776588 4292780430 4293107847 4292717973 4293114002 4292717456 4293047980 4293046950 4292982948 4293247658 4293640878 4293708222 4293970104 4293576634 4294036669 4294036412 4294036412 4294037183 4294036926 4294037697 4294037441 4294038971 4294039499 4290071632 4286654022 4288297038 4287049290 4287709789 4286654024 4286588485 4287114312 4287705163 4287575376 4287511120 4288036172 4287384142 4287315789 4288040019 4287908176 4289223012 4288700777 4288701799 4289357685 4289686653 4290083194 4290148216 4291330930 4291528563 4292121479 4292120688 4292052859 4291393120 4290732113 4290865500 4291651669 4292119149 4293834902 4294036364 4293973161 4294236587 4294038659 4293969026 4293500010 4292901203 4291190357 4289938761 4288954194 4288296783 4287375176 4287314002 4288951885 4288956491 4289676619 4287773010 4286980933 4287509839 4288625742 4288563280 4289222007 4288365644 4287709779 4288628825 4287843170 4287971923 4287907422 4288039254 4287844707 4288829027 4287319135 4287711585 4286724170 4286526032 4285207867 4286194506 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283369781 4283369782 4283435836 4283369786 4283438142 4285210715 4288704902 4290157462 4290748318 4290620332 4291209637 4290550930 4289693588 4287781980 4285666372 4286654026 4289805383 4291913812 4292967540 4292971379 4293367667 4293303944 4293237622 4293632389 4293436279 4293237621 4293566592 4293698939 4293500285 4293562734 4293492842 4292704349 4290796129 4289027706 4286985042 4286662236 4287250282 4283500610 4283503427 4285014607 4285340220 4284093516 4283963973 4284355916 4283898186 4283831885 4284029760 4286200166 4284292170 4283767370 4286198367 4284226635 4283899725 4284030286 4285739596 4285539925 4285475916 4284883790 4284489289 4284094010 4283702613 4284029252 4284686408 4284751946 4284489030 4283239756 4285082704 4286338442 4282318915 4285940840 4287916697 4286071665 4288573361 4287522444 4289834434 4285413754 4284488280 4285279834 4285410138 4285805419 4287053948 4285804894 4287189885 4289571757 4283761477 4285145668 4286003532 4284881474 4284550968 4285929790 4284288058 4283698490 4285210691 4284552511 4283895609 4284553791 4284684359 4284092989 4284287802 4284418100 4285999695 4285536576 4287771981 4287836236 4288758346 4291449941 4291056729 4291453016 4290993745 4290925396 4291386718 4291191389 4290662477 4286257731 4283762748 4286853716 4288496985 4290732129 4292242531 4292505189 4292042837 4292964443 4292175459 4292175208 4292505959 4292441450 4293225836 4292768876 4292768622 4292835439 4292833626 4292833132 4292439640 4292836210 4293094237 4292766808 4292898667 4292373863 4292832101 4292832859 4292506221 4292109392 4292964444 4292307562 4292440155 4292964190 4292508014 4292966770 4292441962 4292900977 4292835935 4292901483 4292509808 4292444015 4292903036 4292839042 4292971124 4292839558 4292774516 4292776326 4292777601 4292776072 4293172105 4292711052 4293106310 4293108620 4293112207 4292784293 4293047452 4292982185 4293179562 4293311665 4292984236 4293576120 4293970105 4293576635 4294102205 4294036669 4294036412 4293710274 4294036155 4294036926 4294038468 4294037442 4294499778 4290475124 4286719558 4287511889 4288101197 4287447119 4287574604 4287641425 4287051086 4286461006 4287181902 4286591306 4287116623 4287181646 4287181134 4287772496 4287116368 4287053646 4287578957 4287579980 4287449175 4288043094 4289027430 4289883762 4290871166 4291331694 4292252288 4292118888 4291788386 4291395947 4291856997 4292183134 4291656799 4292315509 4294099833 4294037928 4294236584 4293973142 4294102422 4293571191 4292839009 4291716176 4290267460 4289217360 4288426569 4287441737 4287443273 4287968846 4288235344 4288955982 4288821070 4287377995 4287572040 4287774029 4289284960 4289220450 4289352555 4287710282 4288432227 4287974233 4288628311 4287250262 4288105048 4288500587 4288764785 4287974764 4288302435 4287053910 4286919766 4285999689 4285798720 4285799491 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4283567178 4283699508 4283304246 4283304245 4283499582 4284620356 4288771470 4290286733 4290684594 4291143585 4291341480 4290485663 4289041283 4288833137 4286258754 4285932874 4289346119 4292239965 4292116585 4293102457 4292974719 4293302138 4293304442 4293237639 4293042558 4293631617 4293502343 4293698681 4293501058 4293561465 4293560172 4292769632 4288952133 4289755531 4287575405 4287909992 4286200927 4283367999 4283371070 4285145929 4284222787 4283832902 4284357180 4283503427 4283634759 4284225599 4286266215 4285736787 4283635020 4284095295 4286135653 4284554322 4283768655 4284292422 4285018458 4285540179 4285935969 4284620874 4285804379 4285209675 4283501876 4284485454 4284225092 4284227659 4284817996 4284686153 4284490310 4284162114 4283237954 4283239748 4286994327 4285675119 4287521681 4288176534 4288251040 4289695926 4288114081 4283631672 4285413233 4287387263 4288309396 4288507271 4285273144 4285796661 4283636025 4284290118 4284224572 4285144134 4285803081 4284424783 4284486451 4284486457 4285210691 4284223289 4284420667 4284093755 4284680506 4284289594 4284421701 4284813619 4285798723 4285735496 4288166222 4288100174 4290201677 4291188570 4291059282 4290994266 4291579745 4291387742 4291058521 4291122249 4288295500 4283695165 4284682555 4288298834 4289285972 4292110946 4292896598 4292569443 4292439141 4292308074 4292830818 4292506216 4293028461 4292439910 4292834669 4292834670 4292766550 4292836209 4292767339 4292767598 4293159771 4292768877 4293096554 4293160815 4292310636 4293619040 4292767322 4292831846 4292898394 4292373607 4292109663 4292571754 4292962645 4292439899 4292573809 4292439382 4293228917 4292833643 4292441964 4292510321 4292509808 4292902765 4292641391 4292641133 4292969084 4292579451 4292840054 4292776064 4292971646 4293172355 4292318853 4293565057 4292712332 4292780175 4292783508 4292782735 4293111455 4292982951 4293181095 4293050289 4293706928 4293182129 4293641658 4293970105 4293708221 4294036669 4294036669 4294101691 4294037183 4294036926 4294037697 4294037441 4294302658 4292124310 4286455869 4287510096 4288102226 4288168785 4288104539 4287972175 4288033869 4288100432 4287576652 4287115854 4287179077 4286787401 4286260550 4285735494 4286461005 4286392393 4286458441 4285869901 4286525004 4286326858 4287186510 4287449425 4289620570 4291128422 4291063123 4291854693 4291987821 4292846706 4292646758 4292117358 4292314475 4292714868 4294036109 4294038439 4293973160 4294038680 4293901694 4293368179 4292375893 4290860371 4289346377 4287967306 4286521927 4286585415 4288163654 4287770955 4289085265 4287771211 4287969358 4287443281 4287246923 4289218653 4288960612 4288564309 4287706954 4287906902 4288761190 4287972957 4287250260 4288627788 4287908441 4289548390 4287844971 4288234849 4287449941 4287841113 4286395469 4285275973 4285471293 4285275461 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284943934 4283566907 4283632437 4283829812 4283829056 4285013570 4288311171 4289502111 4291338661 4291079605 4291276448 4291009436 4289566359 4289098611 4285471557 4286653766 4288953674 4291650907 4292967533 4293234552 4293300610 4293697402 4292909954 4293501300 4293436281 4293369971 4293567624 4293567624 4293565306 4293566329 4293429614 4291845728 4286588493 4289950091 4287513952 4286856030 4286528096 4283238462 4285015631 4284489285 4284026692 4284028483 4284091719 4284025924 4284095049 4286860150 4284881986 4284884301 4283567174 4283700298 4286266981 4284358729 4284093762 4284096592 4286459495 4285276228 4285936983 4285278297 4285277514 4284884560 4284489029 4283567674 4285606224 4284290367 4284622672 4285015631 4283896908 4283699011 4283505744 4284555084 4283303733 4287191967 4286729103 4288114074 4287985589 4288180896 4289436597 4287057547 4289493676 4287581572 4287055206 4287913863 4286402690 4284553274 4283634499 4284027186 4284552505 4285144391 4285801032 4284157239 4283896636 4284422475 4284618044 4284353344 4284090170 4284223285 4284353596 4284288058 4284549952 4285010745 4286587466 4287244614 4288363602 4289347144 4290857289 4291059289 4291382863 4291517023 4291320404 4291059028 4291320652 4290065740 4283957300 4283829815 4286917709 4289086811 4290928222 4292501597 4292765536 4292505948 4292571483 4292765027 4292308073 4292505703 4292833385 4292900461 4292439910 4292833130 4293161072 4292767338 4293161565 4292768877 4292770672 4292833899 4292377454 4292832603 4292833886 4292700771 4292833390 4292834911 4292505452 4292505947 4293290069 4292505963 4292113258 4292964206 4292506972 4292570731 4292508765 4292508522 4292966255 4292506986 4292509808 4292903021 4292444016 4292443759 4292642673 4292838529 4292775037 4293166979 4292776581 4292775811 4292843150 4292710535 4293108107 4292779148 4293176462 4292783764 4292719783 4293111196 4292982438 4293574827 4293245874 4292984235 4294101692 4293641648 4293839807 4293904055 4293708221 4293710531 4294101691 4294037183 4294037697 4294037441 4294104251 4293970363 4287308618 4287969103 4288694098 4287909459 4288760408 4287971921 4287972177 4288628816 4287903833 4287511631 4287640910 4286655563 4286853194 4285867336 4285602624 4285667906 4285408071 4285207095 4284683063 4284816452 4285211212 4286458188 4287511887 4288762453 4289614678 4292116838 4292654214 4293311627 4292981100 4291855973 4292316023 4293701487 4293905057 4294038437 4294038700 4294036115 4294098285 4292842095 4291715654 4290004296 4287770186 4286063943 4286257736 4286718535 4287510351 4288690254 4287312203 4287574089 4287443019 4287970639 4288497488 4289091182 4289221214 4288498021 4287907935 4288035404 4287380309 4287447124 4288039010 4287904597 4287973719 4287844976 4288895335 4287384415 4287712599 4286789720 4285932358 4285800003 4285471550 4285536318 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4284619327 4284945207 4285274690 4285472836 4285209415 4285212241 4289292920 4289501334 4290684842 4291276455 4291145640 4291208354 4290026906 4288770165 4286129991 4286522953 4289348431 4292110430 4292116328 4293102458 4292973943 4293237378 4293502072 4292910461 4293303931 4293238154 4293371002 4293372028 4293566083 4293564530 4293626479 4290926678 4286852176 4289756545 4286394976 4285604943 4285341520 4283108935 4284949836 4283634761 4283830844 4284489023 4283239741 4284225613 4285541970 4285998414 4283635278 4285343831 4284359238 4283898954 4285542753 4284160585 4283174730 4284753484 4286002262 4284555340 4285343053 4284687179 4285474912 4284224067 4285213011 4285278542 4284096069 4283240008 4284222795 4284884041 4284753998 4284095046 4284490314 4283897410 4283500105 4283569743 4286402954 4288045479 4288513951 4288974261 4286860684 4289628841 4287387519 4287253633 4286792317 4284817484 4287912834 4286136184 4283697209 4283960644 4284945720 4285277001 4284485176 4284683837 4284226886 4285145930 4284292172 4283503675 4285078848 4284025660 4283699508 4284681283 4284418867 4285469755 4286326088 4286984268 4288756817 4290005065 4291120725 4291581026 4290926165 4291516501 4291319645 4291124812 4291446605 4285471043 4283828287 4285076035 4288036431 4290598245 4291846759 4292176994 4292373349 4292571243 4292505962 4292897635 4292505960 4292505703 4292898924 4292439910 4292964459 4292440168 4292766807 4292834670 4292441194 4292834412 4292832360 4292837490 4292832361 4292836210 4292768862 4293095537 4292833884 4292833133 4292440410 4292700777 4292244072 4292307547 4292964446 4292439898 4292963420 4292505450 4292572267 4292571753 4292507757 4292575858 4292576886 4292509553 4292904306 4292970353 4292969341 4292576881 4292969323 4292383362 4292578425 4293103231 4293169026 4292712583 4293106053 4292387990 4292779662 4292783507 4293175176 4292719269 4293046949 4292983727 4293115033 4293706933 4293509805 4293510328 4293642427 4293774013 4294102461 4294101948 4293709503 4294037183 4294037697 4294037698 4294037687 4294302146 4289092702 4287181385 4288039505 4288760158 4288564832 4288629844 4288631384 4288629087 4288562761 4287904335 4287970896 4287575888 4287770696 4286851913 4285933386 4286194249 4285143360 4285076792 4283699016 4284552242 4284025651 4284422719 4285668682 4287444300 4290275178 4293112202 4294034316 4293376901 4293242227 4292515942 4292382826 4293768839 4294101902 4294037671 4294038660 4294100356 4293308275 4292575049 4289940305 4287572044 4287836743 4285667656 4286849096 4287179847 4287574603 4287445073 4287640652 4287048777 4287510860 4287906893 4289021295 4289748573 4288829021 4288037978 4288102987 4287448152 4287575381 4287579222 4288101460 4287186517 4289351780 4288501085 4287975280 4287515999 4287183705 4286396237 4285602368 4286261066 4285470013 4285470782 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4285207611 4286459727 4287050573 4286393418 4285866051 4286853980 4288044396 4290286991 4291209388 4291277988 4291669939 4291277226 4290421148 4289096560 4285934150 4286522694 4289348431 4291452763 4293033588 4293101163 4292580743 4293696891 4293435765 4293501817 4293107323 4293042302 4293633903 4293566855 4293371256 4293693049 4293299570 4290005340 4287772755 4291069844 4287773277 4285473614 4285080650 4283500867 4285212244 4283370556 4284225862 4284029258 4285802838 4285146186 4284158272 4284029514 4283899718 4285606223 4284025660 4283832397 4284095048 4286001242 4283763776 4285411417 4285607511 4285343832 4284686924 4285211466 4284752715 4284949071 4284359244 4284883019 4283763003 4284224839 4283238459 4283437895 4286526809 4284683339 4283962434 4285345370 4284095047 4283832395 4283631932 4285808759 4287915673 4288979637 4288054960 4287722657 4288576426 4285279838 4287387804 4289163413 4289759134 4286789212 4283173942 4283961154 4285340734 4284750146 4283828282 4284552251 4284550451 4284091706 4284159027 4284025666 4284025658 4283764276 4284746563 4284486458 4285207865 4286391114 4287771209 4288362831 4289217609 4290858582 4291449425 4291317840 4291582038 4291318868 4291125332 4291449935 4286584899 4283500354 4284550967 4287116361 4290137943 4291912030 4292504145 4291912547 4292637276 4292571483 4292307812 4292897635 4292505704 4292897388 4292832600 4292898924 4292439912 4292440167 4293160814 4292834668 4292441194 4292835695 4292768619 4292769903 4293161053 4292768620 4292769136 4293159771 4292375130 4292768111 4293224286 4292832860 4292831845 4292897629 4292505449 4292508785 4292505434 4292964190 4292505192 4292508528 4292963419 4292506458 4292575859 4292573019 4292444275 4293034348 4292379763 4292904577 4292773745 4292970367 4292970110 4292972415 4292318346 4293104007 4293042572 4292779917 4293172617 4292717971 4292784021 4293113247 4293047722 4293048740 4292983469 4293313194 4293182130 4293576119 4293641656 4294168254 4293510327 4294036669 4294037440 4294036412 4294036926 4294037697 4294037443 4294433717 4291135888 4287048785 4287973197 4288694367 4289092444 4288957273 4288630870 4288499039 4288433751 4287974237 4288430924 4287971159 4287510095 4287837261 4286331729 4285997127 4285340739 4284357445 4284945470 4283568456 4283829048 4283306565 4283696704 4286855254 4293105272 4293641109 4294165890 4293708161 4292848225 4292639838 4292975222 4294034556 4294038422 4294038444 4294037637 4294099331 4292582238 4291649353 4288099919 4287177798 4285668424 4286455880 4287309639 4287640652 4287575374 4287641423 4287112262 4287047747 4287904864 4289155177 4289090901 4288501097 4288759656 4287447635 4286985814 4287642188 4287644513 4287050316 4287449175 4288693353 4288502624 4288631668 4288827493 4287514719 4287249228 4285801032 4286197323 4284945726 4285538888 4285799491 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287773262 4288298575 4287576911 4287771983 4287184470 4287055710 4288307317 4289496976 4291404190 4291669670 4291999918 4291210401 4290355099 4289493624 4287053142 4286457414 4289413973 4291779923 4292246119 4293037179 4293366905 4293436791 4293303690 4293043063 4293236864 4293632132 4293568882 4293765762 4293237369 4292976499 4292969579 4290137188 4289282913 4290150788 4289088631 4284753231 4284224316 4284224329 4284686922 4284226893 4284489031 4286333546 4285147469 4284421445 4283964479 4284027206 4283965511 4284817997 4284490321 4284030281 4284226379 4285475674 4284423236 4285738840 4284685899 4285082455 4285475411 4284819283 4285345884 4285277255 4283898430 4283962949 4283899210 4283897417 4284487235 4284026435 4283567928 4285409882 4284225856 4286727527 4285080403 4283962947 4283765571 4282779459 4286135137 4288706998 4288510884 4288317884 4288578228 4287058321 4287390352 4286921575 4288237147 4289295522 4283303737 4284291398 4285210437 4284224831 4284422205 4283963449 4284027200 4284025152 4284420668 4284484660 4283632706 4284226882 4284617274 4284352569 4285602628 4287903565 4287312460 4288757582 4290464335 4291188823 4290991702 4290990671 4290994525 4291450958 4291517522 4287637830 4284682040 4283763002 4285930818 4288954966 4291582806 4292570216 4291714646 4292505195 4292373349 4292373348 4292308067 4292897380 4292507243 4292505447 4292898924 4292439912 4293228126 4292767595 4292767849 4292767595 4293225306 4292704623 4293161838 4292835694 4292376940 4292835696 4292833369 4292770417 4292834674 4293224777 4292374893 4292439898 4292898909 4292440171 4292505705 4292898651 4292505452 4292442204 4292964206 4292505176 4292506732 4292574832 4292572779 4292509041 4292573275 4292444274 4293231722 4292380290 4292643446 4292773248 4292970366 4292578427 4292841846 4293038729 4293106822 4293106566 4292648590 4293569946 4292715406 4293044634 4293048744 4292981927 4293443250 4292982955 4293510827 4293575864 4293707449 4293641656 4293839550 4294102461 4293838262 4293709503 4294037954 4294036155 4294037698 4294170047 4293377452 4287245123 4287381072 4287843912 4288562525 4289420128 4289679454 4289419872 4289025382 4288563794 4288694879 4288105819 4287511383 4287053902 4286724440 4287049800 4286062152 4285407300 4284812594 4284224562 4283372365 4283239232 4283369788 4288755017 4293043572 4294100882 4294036099 4294298247 4292644965 4292050776 4293176966 4293970577 4294035858 4294037912 4294166404 4293702017 4292309831 4287048009 4286718023 4285800008 4285929541 4286391112 4286656586 4287771980 4287116364 4287180361 4286524486 4287446624 4288496971 4288893528 4290076285 4287975254 4287445587 4287052383 4287773791 4287052119 4287051085 4287642190 4287380817 4288436328 4289223797 4288765812 4288040802 4286989909 4287314013 4286395212 4285933898 4286261321 4284814907 4286195017 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4287579990 4287514457 4287578710 4287578709 4287580514 4287450207 4288768125 4289562511 4290748833 4291145641 4291801762 4291210658 4290290078 4289955449 4287580509 4286459467 4288824660 4291977046 4292247659 4293298292 4292973946 4293697409 4292912002 4293501560 4293632387 4293173373 4293371519 4293831797 4293566080 4293696377 4293164651 4290140000 4288760931 4290212486 4286793830 4286657110 4283369796 4284092739 4284028475 4285408845 4284686924 4284620618 4284357445 4284160060 4284227143 4284355651 4284554569 4284226114 4284552775 4283965512 4284488772 4284489032 4284885325 4285542241 4284224066 4285279833 4285936992 4285608033 4285211722 4285278296 4283765565 4284292172 4283962687 4283503170 4284556622 4284818248 4283173189 4285079625 4285871457 4285279829 4285013831 4284686409 4284027989 4284357704 4285148262 4285674327 4287456415 4289103009 4289963954 4288709294 4286529665 4286596471 4288249004 4288178312 4283699519 4284686924 4284420413 4284158778 4284158778 4284224320 4284226111 4284028986 4284092981 4283698236 4283894069 4284550709 4284681787 4285534780 4287049289 4287575116 4287835721 4289413963 4290858069 4291123536 4291517275 4291515739 4291059027 4291123024 4287307588 4283236408 4284749115 4286261842 4288757582 4291189334 4291847267 4291911767 4292372832 4292439146 4292439125 4292373604 4292963181 4292440154 4292899950 4292506986 4292898666 4292505703 4292439912 4293161069 4292767849 4292833386 4292374375 4293163378 4292375400 4292834156 4292834155 4293096302 4292768621 4292835696 4292832859 4292440171 4292898660 4292901745 4292439913 4292898138 4292831843 4292833389 4292505433 4292899953 4292505433 4292571242 4292570727 4292573292 4292507499 4292902001 4292508527 4292509808 4292641136 4292838252 4292970370 4292772714 4292772991 4292841601 4292971386 4293105283 4292384658 4293038215 4293435009 4292646540 4293110669 4293047198 4293047197 4293048230 4292983468 4293181357 4293050550 4293641655 4293314228 4293707193 4293839549 4293773757 4294036669 4294037183 4294036412 4294037183 4294037699 4294103984 4293974213 4288693587 4287312205 4288103773 4288565333 4289683305 4288237660 4289681249 4288892495 4289025118 4288628306 4288104531 4287511886 4287579726 4287773536 4286788172 4286461519 4286129479 4285474381 4284226629 4284288312 4283961151 4283500607 4289150034 4292843875 4293772168 4293903743 4293640063 4293171561 4292582000 4293505924 4293902717 4294035842 4294099075 4293636469 4291524183 4288886858 4285928775 4285930568 4285602882 4286522696 4286851655 4287772237 4287111753 4286654791 4287179590 4287575129 4288628557 4289220973 4289157994 4288564315 4287381332 4287051606 4287182414 4287116364 4287116364 4287641687 4287513172 4288039278 4289420908 4289291635 4288564842 4288107629 4287643475 4286658645 4286921560 4286457414 4286063431 4285277259 4286129735 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 4278190081 )
		offset: 0 @ 0! !

!TestDeviceImplementor methodsFor: 'private' stamp: 'dgd 8/9/2004 21:12'!
scaledLenna
	| lenna result warpBlt |
	lenna := self lenna.
	self extent = lenna extent
		ifTrue: [^ lenna].
	""
	result := Form extent: self extent depth: 32.
	warpBlt := WarpBlt current toForm: result.
	warpBlt sourceForm: lenna.
	warpBlt cellSize: 2;
		 combinationRule: Form over.
	warpBlt
		copyQuad: lenna boundingBox innerCorners
		toRect: (0 @ 0 extent: self extent).
	""
	^ result ! !

!TestDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:34'!
close
	"private - close the receiver"
	opened := false! !

!TestDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:34'!
isOpened
	"answer whatever the receiver is opened"
	^ opened! !

!TestDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 7/28/2004 17:34'!
open
	"open the device represented by the receiver"
	opened := true! !

!TestDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 21:18'!
applyParameters: aCollection 
	"apply the (possible changed) collection of parameters"

	aCollection
		do: [:parameter | 
			parameter name == #extent
				ifTrue: [self extent: parameter value].
			parameter name == #type
				ifTrue: [type := parameter value].
			parameter name == #isShowingTime
				ifTrue: [isShowingTime := parameter value]]! !

!TestDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 20:16'!
parameters
	"answer a collection of parameters to configure the receiver"
	| extentParameter showTimeParameter typeParameter |
	extentParameter := ParameterDescription
				extentParameterNamed: #extent
				label: 'Frame extent' translated
				value: extent
				help: 'the frame extent in pixels' translated.
	typeParameter := ParameterDescription
				optionParameterNamed: #type
				label: 'Type' translated
				value: type
				options: {{'Lenna'. #lenna}. {'Color Bars'. #colorBars}}
				help: 'the type of the test image' translated.
	showTimeParameter := ParameterDescription
				booleanParameterNamed: #isShowingTime
				label: 'show time' translated
				value: isShowingTime
				help: 'the test image includes the time' translated.
	^ {extentParameter. typeParameter. showTimeParameter}! !

!TestDeviceImplementor methodsFor: 'capturing' stamp: 'dgd 8/9/2004 21:14'!
nextWithBrightness: brightnessFloat contrast: contrastFloat 
	"answer the next frame from the device represented by the  
	receiver"

	| result |
	result := type == #lenna 
				ifTrue: [self scaledLenna]
				ifFalse: [self colorBars].
	""
	isShowingTime 
		ifTrue: 
			[""

			result getCanvas 
				drawString: Time now print24
				at: 5 @ 2
				font: Preferences windowTitleFont
				color: Color white].
	""
	^result! !

!TestDeviceImplementor methodsFor: 'initialization' stamp: 'dgd 11/3/2006 15:02'!
initialize
	"initialize the receiver"

	super initialize.

	type := #lenna.
	"type := #colorBars."
	isShowingTime := true.
	opened := true.
	extent := 320 @ 240.
! !


!V4LDeviceImplementor methodsFor: 'printing' stamp: 'dgd 8/10/2004 20:53'!
printOn: aStream 
	"append to aStream a sequence of characters that identifies  
	the receiver"

	super printOn: aStream.
	""
	aStream
		nextPutAll: ', deviceHandle=';
		nextPutAll: deviceHandle asString;
		nextPutAll: ', deviceID:';
		nextPutAll: self deviceID asString! !

!V4LDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 8/6/2004 18:52'!
close
	"close the receiver"
	| dh |
	dh :=  deviceHandle.
	""
	deviceHandle := nil.
	buffer := nil.
	""
	self deviceClose: dh! !

!V4LDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 8/6/2004 18:52'!
isOpened
	"answer whatever the receiver is opened"
	^  deviceHandle notNil! !

!V4LDeviceImplementor methodsFor: 'opening / closing' stamp: 'dgd 8/10/2004 20:53'!
open
	"open the device represented by the receiver"

	| w h |
	deviceHandle := self 
				deviceCreate: deviceID
				with: desiredExtent x
				height: desiredExtent y
				palette: desiredPalette.
	""
	w := self deviceGetWidth: deviceHandle.
	h := self deviceGetHeight: deviceHandle.
	""
	buffer := Form extent: w @ h depth: 32! !

!V4LDeviceImplementor methodsFor: 'primitives' stamp: 'dgd 7/28/2004 18:16'!
deviceClose: deviceInteger 
	<primitive: 'primitiveDeviceClose' module:'V4LPlugin'>
	^ self error: 'can''t open device  ''' , deviceInteger asString , ''''! !

!V4LDeviceImplementor methodsFor: 'primitives' stamp: 'dgd 8/5/2004 22:50'!
deviceCreate: deviceIDInteger with: widthInteger height: heightInteger palette: paletteInteger 
	<primitive: 'primitiveDeviceCreate' module:'V4LPlugin'>
	^ self error: 'can''t create device id ''' , deviceIDInteger asString , ''''! !

!V4LDeviceImplementor methodsFor: 'primitives' stamp: 'dgd 7/28/2004 18:17'!
deviceGetHeight: deviceInteger 
	<primitive: 'primitiveDeviceGetHeight' module:'V4LPlugin'>
	^ self error: 'primitive failed for device  ''' , deviceInteger asString , ''''! !

!V4LDeviceImplementor methodsFor: 'primitives' stamp: 'dgd 7/28/2004 18:17'!
deviceGetWidth: deviceInteger 
	<primitive: 'primitiveDeviceGetWidth' module:'V4LPlugin'>
	^ self error: 'primitive failed for device  ''' , deviceInteger asString , ''''! !

!V4LDeviceImplementor methodsFor: 'primitives' stamp: 'dgd 7/28/2004 18:16'!
deviceNextFrame: deviceInteger into: bits brightness: brightnessFloat contrast: contrastFloat 
	<primitive: 'primitiveDeviceNextFrameIntoBrightnessAndContrast' module:'V4LPlugin'>
	^ self error: 'can''t capture frame in device  ''' , deviceInteger asString , ''''! !

!V4LDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 8/5/2004 22:49'!
deviceID
"answer the receiver's deviceID"
	^ deviceID! !

!V4LDeviceImplementor methodsFor: 'accessing' stamp: 'dgd 8/5/2004 22:49'!
extent
	"answer the receiver's extent"
	^ buffer isNil
		ifTrue: [320 @ 240]
		ifFalse: [buffer extent]! !

!V4LDeviceImplementor methodsFor: 'capturing' stamp: 'dgd 8/6/2004 18:52'!
nextWithBrightness: brightnessFloat contrast: contrastFloat 
	"answer the next frame from the device represented by the  
	receiver"
	buffer unhibernate.
	self
		deviceNextFrame:  deviceHandle
		into: buffer bits
		brightness: brightnessFloat
		contrast: contrastFloat.
	" 
	self deviceNextFrame: self deviceHandle into: buffer bits.  
	"
	^ buffer deepCopy! !

!V4LDeviceImplementor methodsFor: 'initialization' stamp: 'dgd 8/5/2004 22:19'!
initializeDescription: aDescription 
	"initialiaze the receiver's description"
	super initializeDescription: aDescription.
	""
	self
		initializeDevice: aDescription id
		extent: self class defaultExtent
		palette: self class defaultPalette
		open: true! !

!V4LDeviceImplementor methodsFor: 'initialization' stamp: 'dgd 8/10/2004 20:53'!
initializeDevice: deviceIDInteger extent: aPoint palette: paletteInteger open: aBoolean 
	"initialize the receiver"

	deviceID := deviceIDInteger asInteger.
	desiredExtent := aPoint asIntegerPoint.
	desiredPalette := paletteInteger asInteger.
	""
	deviceHandle := nil.
	buffer := nil.
	""
	aBoolean ifTrue: [self open]! !

!V4LDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 21:26'!
applyParameters: aCollection 
	"apply the (possible changed) collection of parameters"
	aCollection
		do: [:parameter | 
			parameter name == #extent
				ifTrue: [
					desiredExtent := parameter value.
					].
			parameter name == #palette
				ifTrue: [desiredPalette := parameter value]]! !

!V4LDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 21:21'!
palettes
	| palettes |
	palettes := OrderedCollection new.
	palettes add: {'DEFAULT - The palette the camera most like' translated. 0}.
	"palettes add: {'GREY - Linear greyscale' translated. 1}."
	"palettes add: {'HI240 - High 240 cube (BT848)' translated. 2}."
	"palettes add: {'RGB565 - 565 16 bit RGB' translated. 3}."
	palettes add: {'RGB24 - 24bit RGB' translated. 4}.
	palettes add: {'RGB32 - 32bit RGB' translated. 5}.
	"palettes add: {'RGB555 - 555 15bit RGB' translated. 6}."
	"palettes add: {'YUV422 - YUV422 capture' translated. 7}."
	"palettes add: {'YUYV' translated. 8}."
	"palettes add: {'UYVY' translated. 9}."
	palettes add: {'YUV420' translated. 10}.
	"palettes add: {'YUV411 - YUV411 capture' translated. 11}."
	"palettes add: {'RAW - RAW capture (BT848)' translated. 12}."
	"palettes add: {'YUV422P - YUV 4:2:2 Planar' translated. 13}."
	"palettes add: {'YUV411P - YUV 4:1:1 Planar' translated. 14}."
	palettes add: {'YUV420P - YUV 4:2:0 Planar' translated. 15}.
	"palettes add: {'YUV410P - YUV 4:1:0 Planar' translated. 16}."
	^ palettes! !

!V4LDeviceImplementor methodsFor: 'configuration' stamp: 'dgd 8/10/2004 21:07'!
parameters
	"answer a collection of parameters to configure the receiver"

	| extentParameter paletteParameter |
	extentParameter := ParameterDescription
				extentParameterNamed: #extent
				label: 'Frame extent' translated
				value: desiredExtent
				help: 'the frame extent in pixels' translated.
	paletteParameter := ParameterDescription
				optionParameterNamed: #palette
				label: 'Palette' translated
				value: desiredPalette
				options: self palettes
				help: 'the palette of the test image' translated.
	^ {extentParameter. paletteParameter}! !


!VideoDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 17:17'!
new
	"answer a new instance of the receiver"
	^ super new initialize! !

!VideoDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 20:21'!
newFromDescription: aDescription 
	"answer a new instance of the receiver represented by the  
	given description"
	^ self new initializeDescription: aDescription! !

!VideoDeviceImplementor class methodsFor: 'testing' stamp: 'dgd 7/28/2004 17:16'!
workOnCurrentEnvironment
	"Answer whatever ther receiver can work on the current  
	environment. 
	 
	Usually the platform name is used to decide"
	^ self subclassResponsibility! !

!VideoDeviceImplementor class methodsFor: 'enumerating' stamp: 'dgd 8/5/2004 19:26'!
descriptions
	"answer a collection of VideoDeviceDescription of available 
	video devices"

	^self subclassResponsibility! !

!VideoDeviceImplementor class methodsFor: 'private' stamp: 'dgd 7/28/2004 18:42'!
descriptionForId: anInteger name: aString 
	"private - answer a description for the given id and name"
	^ VideoDeviceImplementorDescription
		type: self
		id: anInteger
		name: aString ! !


!TestDeviceImplementor class methodsFor: 'enumerating' stamp: 'dgd 8/5/2004 19:26'!
descriptions
	"answer a collection of VideoDeviceDescription of available  
	video devices"

	^{ 
		self descriptionForId: 10 name: 'Test Video Device'}! !

!TestDeviceImplementor class methodsFor: 'testing' stamp: 'dgd 7/28/2004 17:34'!
workOnCurrentEnvironment
	"Answer whatever ther receiver can work on the current  
	environment.  
	 
	Usually the platform name is used to decide"
	"the test video device always works"
	^ true! !


!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 18:11'!
defaulfDevice
	"answer the default device for instances of the receiver"
	^ 0! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 18:11'!
defaultExtent
	"answer the default extent for instances of the receiver"
	^ 320 @ 240! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 18:11'!
defaultPalette
	"answer the default extent for instances of the receiver"
	^ 0! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 7/28/2004 18:11'!
device: idInteger 
	"answer an instance of the receiver"
	" 
	LinuxCamera device: '/dev/video'  
	"
	^ self device: idInteger extent: self defaultExtent! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:19'!
device: idInteger extent: aPoint 
	"answer an instance of the receiver"
	^ self
		device: idInteger
		extent: aPoint
		palette: self defaultPalette! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:20'!
device: idInteger extent: aPoint palette: paletteInteger 
	"answer an instance of the receiver"
	^ self
		device: idInteger
		extent: aPoint
		palette: paletteInteger
		open: true! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:21'!
device: idInteger extent: aPoint palette: paletteInteger open: aBoolean 
	"answer an instance of the receiver"
	"VIDEO_PALETTE_RGB24 = 4. --> depth=24"
	"VIDEO_PALETTE_YUV420 = 10. --> depth=12"
	^ super new
		initializeDevice: idInteger
		extent: aPoint
		palette: paletteInteger
		open: aBoolean! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:19'!
extent: aPoint 
	"answer an instance of the receiver"
	^ self
		extent: aPoint
		palette: self defaultPalette! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:20'!
extent: aPoint palette: paletteInteger 
	"answer an instance of the receiver"
	^ self
		device: self defaulfDevice
		extent: aPoint
		palette: paletteInteger! !

!V4LDeviceImplementor class methodsFor: 'instance creation' stamp: 'dgd 8/5/2004 22:20'!
newOpen: aBoolean 
	"answer an instance of the receiver"
	^ self
		device: self defaulfDevice
		extent: self defaultExtent
		palette: self defaultPalette
		open: aBoolean! !

!V4LDeviceImplementor class methodsFor: 'enumerating' stamp: 'dgd 7/28/2004 18:10'!
descriptionForDeviceID: deviceID 
	"answer the description for the device with the given ID"
	| buffer deviceName |
	buffer := ByteArray new: 32.
	self deviceDescribe: deviceID in: buffer.
	""
	deviceName := buffer asString
				reject: [:each | each asciiValue = 0].
	""
	^ deviceName! !

!V4LDeviceImplementor class methodsFor: 'enumerating' stamp: 'dgd 8/5/2004 19:30'!
descriptions
	"answer a collection of VideoDeviceDescription of available  
	video devices"
	" 
	V4LDeviceImplementor descriptions.  
	 
	Time millisecondsToRun:[  
	V4LDeviceImplementor descriptions  
	]  
	"
	| result |
	result := Set new.
	0
		to: 9
		do: [:deviceID | 
			| deviceName | 
			deviceName := self descriptionForDeviceID: deviceID.
			deviceName isEmpty
				ifFalse: [result
						add: (self descriptionForId: deviceID name: deviceName)]].
	^ result! !

!V4LDeviceImplementor class methodsFor: 'enumerating' stamp: 'dgd 8/20/2006 12:33'!
workOnCurrentEnvironment
	"Answer whatever ther receiver can work on the current  
	environment.  
	 
	Usually the platform name is used to decide"
		
	((Smalltalk respondsTo: #osVersion) and: [Smalltalk osVersion = 'linux-gnu'])
		ifTrue:[^ true].
	
	Smalltalk
		at:#SmalltalkImage
		ifPresent:[:klass |
			^ klass current osVersion = 'linux-gnu'
		].
	
	^ false.
! !

!V4LDeviceImplementor class methodsFor: 'primitives' stamp: 'dgd 11/3/2006 11:50'!
deviceDescribe: deviceIDInteger in: deviceName 
	<primitive: 'primitiveDeviceDescribe' module:'V4LPlugin'>
	^ self error: 'can''t describe device id ''' , deviceIDInteger asString , ''''! !


!VideoDeviceImplementorDescription methodsFor: 'comparing' stamp: 'dgd 7/26/2004 19:37'!
hash
	"Answer a SmallInteger whose value is related to the receiver's identity."
	^ (self type hash bitXor: self id hash)
		bitXor: self name hash! !

!VideoDeviceImplementorDescription methodsFor: 'comparing' stamp: 'dgd 7/26/2004 19:35'!
= aVideoDeviceDescription 
	"answer whatever the receiver is equivalent to  
	aVideoDeviceDescription"
	^ self class = aVideoDeviceDescription class
		and: [self type = aVideoDeviceDescription type]
		and: [self id = aVideoDeviceDescription id]
		and: [self name = aVideoDeviceDescription name] ! !

!VideoDeviceImplementorDescription methodsFor: 'accessing' stamp: 'dgd 7/26/2004 19:15'!
id
	"answer the receiver's id"
	^ id! !

!VideoDeviceImplementorDescription methodsFor: 'accessing' stamp: 'dgd 7/26/2004 19:15'!
name
	"answer the receiver's name"
	^ name! !

!VideoDeviceImplementorDescription methodsFor: 'accessing' stamp: 'dgd 7/26/2004 19:16'!
type
	"answer the receiver's type"
	^ type! !

!VideoDeviceImplementorDescription methodsFor: 'printing' stamp: 'dgd 7/26/2004 19:15'!
printOn: aStream 
	"Append to aStream a sequence of characters that identifies 
	the receiver."
	super printOn: aStream.
	""
	aStream nextPutAll: ' name:';
		 nextPutAll: self name asString;
		 nextPutAll: ', id:';
		 nextPutAll: self id asString;
		 nextPutAll: ', type:';
		 nextPutAll: self type asString! !

!VideoDeviceImplementorDescription methodsFor: 'initialization' stamp: 'dgd 7/26/2004 19:08'!
initializeType: aClass id: anInteger name: aString 
	"initialize the receiver"
	type := aClass.
	id := anInteger.
	name := aString ! !

!VideoDeviceImplementorDescription methodsFor: 'factory' stamp: 'dgd 7/28/2004 18:44'!
newImplementor
	"answer the implementor instance represented by the receiver"
	^ type newFromDescription: self! !


!VideoDeviceImplementorDescription class methodsFor: 'instance creation' stamp: 'dgd 7/26/2004 19:08'!
type: aClass id: anInteger name: aString
	"answer a new instance of the receiver"
	^ self new initializeType: aClass id: anInteger name: aString! !


!VideoMorph methodsFor: 'meta-actions' stamp: 'dgd 8/6/2004 19:17'!
openAPropertySheet
	VideoPropertiesMorph basicNew targetMorph: self;
		 initialize;
		 openNearTarget! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/11/2004 21:36'!
arrowDeltaFor: aGetSelector 
	"Answer a number indicating the default arrow delta to be  
	used in a numeric readout with the given get-selector. This is  
	a hook that subclasses of Morph can reimplement."
	(#(#getBrightness #getContrast ) includes: aGetSelector)
		ifTrue: [^ 0.1].
	^ super arrowDeltaFor: aGetSelector! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/11/2004 21:36'!
defaultFloatPrecisionFor: aGetSelector 
	"Answer a number indicating the default float precision to be  
	used in a numeric readout for which the receiver provides the 
	data. Individual morphs can override this. Showing fractional  
	values for readouts of getCursor was in response to an explicit 
	request from ack"
	(#(#getBrightness #getContrast  ) includes: aGetSelector)
		ifTrue: [^ 0.01].
	""
	^ super defaultFloatPrecisionFor: aGetSelector! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 8/9/2004 20:47'!
forgetConfigurationDialog
configurationDialog_nil! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 8/6/2004 19:56'!
getAutoExtent
	^ self autoExtent! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/3/2004 16:02'!
getBrightness
	^ videoSource isNil
		ifTrue: [0]
		ifFalse: [videoSource brightness]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/3/2004 16:02'!
getContrast
	^ videoSource isNil
		ifTrue: [0]
		ifFalse: [videoSource contrast]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 6/28/2004 11:35'!
getIsRunning
	^ videoSource notNil
		and: [videoSource isOpened]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/1/2004 18:34'!
getLastFrame
	videoSource isNil
		ifTrue: [^ self presenter standardPlayer costume].
	videoSource isOpened
		ifFalse: [^ self presenter standardPlayer costume].
	""
	self updateForm.
	^ SketchMorph withForm: form deepCopy! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/1/2004 13:23'!
getResolution
	^ resolution! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 6/28/2004 11:34'!
play
	videoSource isNil
		ifFalse: [videoSource openIfCorresponds]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 8/6/2004 19:57'!
setAutoExtent: aBoolean 
	self autoExtent: aBoolean! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 8/3/2004 13:35'!
setBrightness: amt 
	videoSource isNil
		ifFalse:[videoSource brightness: amt]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 8/3/2004 13:36'!
setContrast: amt 
	videoSource isNil
		ifFalse:[videoSource contrast: amt]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 7/1/2004 13:37'!
setResolution: aSymbol 
	| newResolution |
	newResolution := aSymbol asSymbol.
	resolution := (self class resolutions includes: newResolution)
				ifTrue: [newResolution]
				ifFalse: [self class resolutions first]! !

!VideoMorph methodsFor: 'e-toy support' stamp: 'dgd 6/28/2004 11:33'!
stop
	videoSource isNil
		ifFalse: [videoSource closeIfCorresponds]! !

!VideoMorph methodsFor: 'submorphs-add/remove' stamp: 'dgd 8/9/2004 19:22'!
delete
	"Remove the receiver as a submorph of its owner and make its  
	new owner be nil."

	self videoSource: nil.
	super delete.! !

!VideoMorph methodsFor: 'initialization' stamp: 'dgd 8/9/2004 11:12'!
initialize
	"initialize the receiver"
	super initialize.
	autoExtent := true.
	""
	resolution := #original.
	""
	self extent: 320 @ 240.
	self borderWidth: 0.
	self updateForm! !

!VideoMorph methodsFor: 'initialization' stamp: 'dgd 8/6/2004 19:45'!
initializeOn: aVideoSource 
	"initialize the receiver's videoSource"
	self videoSource: aVideoSource.
	self tryToAutoExtent! !

!VideoMorph methodsFor: 'accessing' stamp: 'dgd 8/6/2004 19:47'!
autoExtent
	"answer the receiver's autoExtent"
	^ autoExtent! !

!VideoMorph methodsFor: 'accessing' stamp: 'dgd 8/6/2004 19:45'!
autoExtent: aBoolean 
	"change the receiver's autoExtent"
	autoExtent := aBoolean.
self tryToAutoExtent! !

!VideoMorph methodsFor: 'accessing' stamp: 'dgd 8/6/2004 20:22'!
borderWidth: anInteger 
	super borderWidth: anInteger.
	self tryToAutoExtent ! !

!VideoMorph methodsFor: 'accessing' stamp: 'dgd 8/6/2004 20:02'!
switchAutoExtent
	^ self autoExtent: self autoExtent not! !

!VideoMorph methodsFor: 'accessing' stamp: 'dgd 8/9/2004 19:45'!
videoSource: aVideoSource 
	"change the receiver's videoSource"
	videoSource == aVideoSource
		ifTrue: [^ self].
	""
	videoSource isNil
		ifFalse: [""
			videoSource removeActionsWithReceiver: self.
			videoSource closeIfCorresponds].
	""
	videoSource := aVideoSource.
	videoSource
		when: #extent
		send: #tryToAutoExtent
		to: self ! !

!VideoMorph methodsFor: 'private' stamp: 'dgd 6/28/2004 11:52'!
freeAreaExtent
"private - answer the extent to fill (or filled) with tha image"
	^ self extent - (self borderWidth * 2)! !

!VideoMorph methodsFor: 'private' stamp: 'dgd 8/9/2004 19:23'!
scaledForm
	"private - answer the form, but scaled to fit the morph"
	| freeAreaExtent formExtent outForm warpBlt |
	freeAreaExtent := self freeAreaExtent.
	formExtent := form extent.
	(freeAreaExtent = formExtent
			or: [formExtent isZero])
		ifTrue: [^ form].
	""

	outForm := Form extent: freeAreaExtent depth: form depth.
	warpBlt := WarpBlt current toForm: outForm.
	warpBlt sourceForm: form.
	warpBlt cellSize: 2;
		 combinationRule: Form over.
	warpBlt
		copyQuad: form boundingBox innerCorners
		toRect: (0 @ 0 extent: freeAreaExtent).
	""
	^ outForm! !

!VideoMorph methodsFor: 'private' stamp: 'dgd 8/9/2004 19:24'!
tryToAutoExtent
	"private - if corresponds, try to change the receiver's extent"

	autoExtent
		ifTrue: [self extent: 0 @ 0]! !

!VideoMorph methodsFor: 'private' stamp: 'dgd 7/13/2004 20:28'!
updateForm
	"private - update the form from the videoSource"
	videoSource isNil
		ifTrue: [""
			form := Form extent: 320 @ 240 depth: 32.
			form fillColor: Color blue twiceDarker]
		ifFalse: [""
			form := videoSource next].
	""
	resolution == #'256 colors'
		ifTrue: [form := form asFormOfDepth: 8].
	resolution == #'256 grays'
		ifTrue: [form := form asGrayScale].

	resolution == #'4 grays'
		ifTrue: [form := form asFormOfDepth: 2].
	resolution == #'black and white'
		ifTrue: [form := form asFormOfDepth: 1]! !

!VideoMorph methodsFor: 'configuration' stamp: 'dgd 8/10/2004 18:15'!
applyParameters: aCollection 
"apply the (possible changed) collection of parameters"
	videoSource isNil
		ifTrue: [^ self].
	videoSource applyParameters: aCollection! !

!VideoMorph methodsFor: 'configuration' stamp: 'dgd 8/9/2004 20:51'!
bringUpConfigurationDialog
	configurationDialog comeToFront.
	configurationDialog topLeft: self topLeft + 5.
	configurationDialog flash.
! !

!VideoMorph methodsFor: 'configuration' stamp: 'dgd 8/9/2004 20:50'!
configureVideoDevice
	"creates a dialog to configure the receiver's videoSource"
	videoSource isNil
		ifTrue: [^ self].
	""
	configurationDialog isNil
		ifTrue: [self createConfigurationDialog]
		ifFalse: [self bringUpConfigurationDialog] ! !

!VideoMorph methodsFor: 'configuration' stamp: 'dgd 8/10/2004 14:59'!
createConfigurationDialog
	| parameters |
	parameters := videoSource parameters.
	parameters isEmpty
		ifTrue: [^ self inform: 'the video device has not parameters to configure' translated].
	""
	configurationDialog := VideoMorphConfiguration target: self parameters: parameters.
	self addMorphBack: configurationDialog.
	configurationDialog topLeft: self topLeft + 5! !

!VideoMorph methodsFor: 'stepping and presenter' stamp: 'dgd 7/11/2004 22:12'!
step
	"Do some periodic activity"
	videoSource isNil
		ifTrue: [^ self].
	
	""
	self updateForm.
	self changed! !

!VideoMorph methodsFor: 'stepping and presenter' stamp: 'dgd 8/1/2004 20:22'!
stepTime
	"Answer the desired time between steps in milliseconds"
	^ 100! !

!VideoMorph methodsFor: 'menus' stamp: 'dgd 8/9/2004 20:41'!
addCustomMenuItems: aMenu hand: aHandMorph 
	super addCustomMenuItems: aMenu hand: aHandMorph.
	aMenu add: 'configure video device' translated action: #configureVideoDevice! !

!VideoMorph methodsFor: 'halos and balloon help' stamp: 'dgd 8/6/2004 20:06'!
okayToResizeEasily
^ self autoExtent not! !

!VideoMorph methodsFor: 'halos and balloon help' stamp: 'dgd 8/6/2004 20:09'!
wantsHaloHandleWithSelector: aSelector inHalo: aHaloMorph 
	aSelector == #addDupHandle:
		ifTrue: [^ false].
	^ super wantsHaloHandleWithSelector: aSelector inHalo: aHaloMorph ! !

!VideoMorph methodsFor: 'drawing' stamp: 'dgd 7/3/2004 16:13'!
drawOn: aCanvas 
	"draw the receiver on aCanvas"
	super drawOn: aCanvas.
""
	aCanvas paintImage: self scaledForm at: bounds origin + self borderWidth! !

!VideoMorph methodsFor: 'geometry' stamp: 'dgd 8/6/2004 19:43'!
extent: aPoint 
	| newExtent |
	newExtent := autoExtent
				ifTrue: [videoSource isNil
						ifTrue: [320 @ 240]
						ifFalse: [videoSource extent + (self borderWidth * 2)]]
				ifFalse: [aPoint].
	""
	super extent: newExtent ! !


!VideoMorph class methodsFor: 'parts bin' stamp: 'dgd 7/28/2004 21:02'!
descriptionForPartsBin
	^ self
		partName: 'Video Device'
		categories: #('Multimedia' )
		documentation: 'A player for video devices like cameras, video capturers, etc.'

! !

!VideoMorph class methodsFor: 'parts bin' stamp: 'dgd 7/28/2004 21:02'!
newStandAlone
	^ self
		on: (VideoDevice default)! !

!VideoMorph class methodsFor: 'misc' stamp: 'dgd 7/13/2004 20:28'!
resolutions
	"answer a collection of valid resolutions"
	^ #(#original #'256 colors' #'256 grays' #'4 grays' #'black and white' )! !

!VideoMorph class methodsFor: 'instance creation' stamp: 'dgd 6/4/2003 20:49'!
on: aVideoSource 
	"answer an instance of the receiver on aVideoSource"
	^ super new initializeOn: aVideoSource! !

!VideoMorph class methodsFor: 'scripting' stamp: 'dgd 8/20/2006 11:11'!
additionsToViewerCategories
	"Answer a list of (<categoryName> <list of category specs>) pairs that characterize the phrases this kind of morph wishes to add to various Viewer categories."

	^ #(
	(graphics
		(
			(slot graphic 	'The picture currently being worn' Graphic	 readOnly Player getGraphic unused unused)
		)
	)

	(video
		(
			(command play 'Start playing the movie/sound')
			(command stop 'Stop playing the movie/sound')

			(slot isRunning 'Whether the movie/sound is being played' Boolean readOnly	Player getIsRunning unused unused)

			(slot autoExtent 'Whether the morph is in auto-extent mode' Boolean readWrite	Player getAutoExtent Player setAutoExtent:)

			(slot lastFrame 'A morph with the last frame' Player readOnly	Player getLastFrame unused unused)

			(slot resolution 'Video resolution' ImageResolution readWrite Player getResolution Player setResolution:)

			(slot brightness 'Video brightness' Number readWrite	Player getBrightness Player setBrightness:)
			(slot contrast 'Video contrast' Number readWrite	Player getContrast Player setContrast:)

			(command configureVideoDevice 'Open a dialog to configure the video device')
		)
	)
)
! !

!VideoMorph class methodsFor: 'class initialization' stamp: 'dgd 11/3/2006 15:18'!
initialize
	"
	VideoMorph initialize.
	"

	| morph |

	morph := self on: (VideoDevice implementation: TestDeviceImplementor new).
	morph updateForm.

	PartsBin
		cacheThumbnail: (Thumbnail new makeThumbnailFromForm: morph imageForm)
		forSymbol: 'Video Device'.
! !


!VideoMorphConfiguration methodsFor: 'building' stamp: 'dgd 8/10/2004 20:13'!
build
	self
		addMorphBack: (StringMorph contents: 'Video Device Configuration' translated font: Preferences windowTitleFont).
	""
	self addMorphBack: self spacer.
	parameters
		do: [:each | self addMorphBack: each  asMorph].
	self addMorphBack: self spacer.
	""
	self addMorphBack: self buttonsRow! !

!VideoMorphConfiguration methodsFor: 'building' stamp: 'dgd 8/10/2004 14:12'!
buttonsRow
	"private - create a row with accept/cancel buttons"
	| acept cancel |
	acept := self
				buttonNamed: 'Accept' translated
				action: #doAccept
				color: Color green darker
				help: 'keep changes made and close panel' translated.
	cancel := self
				buttonNamed: 'Cancel' translated
				action: #doCancel
				color: Color red darker
				help: 'cancel changes made and close panel' translated.
	^ (self inARow: {acept. cancel})
		! !

!VideoMorphConfiguration methodsFor: 'building' stamp: 'dgd 8/10/2004 21:18'!
doAccept
| changes |
changes := parameters
				select: [:each | each hasChanged].
changes isEmpty ifFalse:[
	target applyParameters: changes].
	self delete! !

!VideoMorphConfiguration methodsFor: 'building' stamp: 'dgd 8/9/2004 17:11'!
doCancel

	self delete! !

!VideoMorphConfiguration methodsFor: 'initialization' stamp: 'dgd 8/10/2004 14:05'!
initialize
	super initialize.
	""
	self
		color: (Color lightYellow alpha: 0.9).
	self borderColor: self color muchDarker.
	self listDirection: #topToBottom.
	self borderWidth: 4.
	self layoutInset: 5.
	self cellInset: 2.
	self hResizing: #shrinkWrap.
	self vResizing: #shrinkWrap.
	self useRoundedCorners! !

!VideoMorphConfiguration methodsFor: 'initialization' stamp: 'dgd 8/9/2004 20:47'!
initializeTarget: aVideoMorph parameters: aCollection 
	"initialize the receiver's parameters"
target _ aVideoMorph.
	parameters := aCollection.
	self build! !

!VideoMorphConfiguration methodsFor: 'private' stamp: 'dgd 8/10/2004 12:33'!
buttonNamed: aString action: aSymbol color: aColor help: helpString 
	"private - answer a new button"
	| button |
	button := SimpleButtonMorph new.
	button target: self.
	button label: aString.
	button color: aColor.
	button borderColor: aColor muchDarker.
	button actionSelector: aSymbol.
helpString isEmpty ifFalse:[
	button setBalloonText: helpString].
	^ button! !

!VideoMorphConfiguration methodsFor: 'private' stamp: 'dgd 8/9/2004 20:04'!
inARow: aCollectionOfMorphs 
	"private - create a row of morphs"
	| row |
	row := AlignmentMorph newRow.
	row color: Color transparent;
		 vResizing: #shrinkWrap;
		 layoutInset: 2;
		 wrapCentering: #center;
		 cellPositioning: #leftCenter;
		 cellInset: 2.
	aCollectionOfMorphs
		do: [:each | row addMorphBack: each].
	^ row! !

!VideoMorphConfiguration methodsFor: 'private' stamp: 'dgd 8/9/2004 20:35'!
spacer
	^StringMorph contents: ' '! !

!VideoMorphConfiguration methodsFor: 'submorphs-add/remove' stamp: 'dgd 8/9/2004 20:48'!
delete
	target forgetConfigurationDialog.
super delete.! !


!VideoMorphConfiguration class methodsFor: 'instance creation' stamp: 'dgd 8/9/2004 20:46'!
target: aVideoMorph parameters: aCollection 
	"answer a new instance of the receiver"
	^ self new initializeTarget: aVideoMorph parameters: aCollection! !


!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:37'!
brightness
	"answer the receiver's brightness"
	^ myTarget getBrightness! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:41'!
brightnessTitle
	^ '  Brightness ({1}%)' translated format: {(self brightness * 100.0) rounded}! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:43'!
brightness: aNumber
	"answer the receiver's brightness"
	^ myTarget setBrightness: aNumber! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:37'!
contrast
	"answer the receiver's contrast"
	^ myTarget getContrast! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:40'!
contrastTitle
	^ '  Contrast ({1}%)' translated format: {(self contrast * 100.0) rounded}! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 20:44'!
contrast: aNumber 
	"answer the receiver's contrast"
	^ myTarget setContrast: aNumber! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/9/2004 20:40'!
doConfigureVideoDevice
	myTarget configureVideoDevice! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 21:41'!
resolution
	"answer the receiver's resolution"
	^ myTarget getResolution! !

!VideoPropertiesMorph methodsFor: 'actions' stamp: 'dgd 8/6/2004 21:41'!
resolution: aSymbol 
	"change the receiver's resolution"
	^ myTarget setResolution: aSymbol! !

!VideoPropertiesMorph methodsFor: 'building' stamp: 'dgd 8/6/2004 20:32'!
brightnessIcon
	^ Form
		extent: 22 @ 22
		depth: 16
		fromArray: #(0 0 0 0 0 65537 0 0 0 0 0 1 65536 0 0 0 65537 0 0 0 1 65536 1 65537 0 0 0 0 0 0 0 65537 65536 0 65537 0 0 65537 65537 65537 0 0 65537 0 0 0 0 65537 65537 65537 65537 65537 0 0 0 0 0 1 65537 766332664 1671258013 1324886445 65537 65536 0 0 0 0 65537 207901432 1742694367 1740530622 1673420734 1255606371 65537 0 0 0 0 65537 1392011231 1809803231 1742694334 1673420734 1604143831 65537 0 0 0 1 77229 1742695391 1809804255 1742694334 1673421758 1604148125 697106433 65536 0 0 1 85752 1742694367 1809803231 1742694334 1673420734 1604148125 1188495361 65536 0 65537 1 91037 1740531679 1742694367 1740530622 1673420734 1604148125 1467744257 65536 65537 65537 1 90013 1673422782 1740531646 1673421758 1673420701 1604148125 1467744257 65536 65537 0 1 85752 1673421758 1673421758 1673421758 1604149149 1537039261 1188429825 65536 0 0 1 76205 1606311870 1673420734 1606311837 1604148125 1537039260 629932033 65536 0 0 0 65537 1255628701 1604149149 1604149149 1537039261 1536968406 65537 0 0 0 0 65537 140724951 1537039261 1537039261 1537039260 1188431971 65537 0 0 0 0 1 65537 697124567 1467766652 1188439436 65537 65536 0 0 0 0 0 65537 65537 65537 65537 65537 0 0 0 0 65537 0 0 65537 65537 65537 0 0 65537 0 1 65537 0 0 0 0 0 0 0 65537 65536 1 65536 0 0 0 65537 0 0 0 1 65536 0 0 0 0 0 65537 0 0 0 0 0 )
		offset: 0 @ 0! !

!VideoPropertiesMorph methodsFor: 'building' stamp: 'dgd 8/7/2004 20:48'!
contrastIcon
	^ Form
		extent: 16 @ 16
		depth: 16
		fromArray: #(0 0 1 65537 65537 65536 0 0 0 1 65537 65537 65537 65537 65536 0 0 65537 77229 1324901277 835659116 348520449 65537 0 1 68708 1392011231 1742694334 837825007 837756268 69271553 65536 1 86776 1742695391 1742694367 837825007 837759471 627834881 65536 65537 766339039 1809804255 1809803231 837825007 837759471 768545990 65537 65537 1324902367 1742695391 1742694367 837825007 837759471 768550251 65537 65537 1671260094 1742694367 1742694334 837825007 837759471 768552398 65537 65537 1604150206 1740531646 1740530622 837759471 837758415 768552398 65537 65537 1324901310 1673421758 1673421758 837759471 837758415 768549227 65537 65537 699228094 1606312894 1606311870 837759471 768552399 768480454 65537 1 84695 1604149149 1604149149 768552399 768552398 560660481 65536 1 67683 1255627677 1537039261 768552399 768483691 69271553 65536 0 65537 76173 1188517756 768483691 348520449 65537 0 0 1 65537 65537 65537 65537 65536 0 0 0 1 65537 65537 65536 0 0 )
		offset: 0 @ 0! !

!VideoPropertiesMorph methodsFor: 'building' stamp: 'dgd 8/6/2004 20:19'!
paneForAutoExtentToggle


	^self inARow: {
		self
			directToggleButtonFor: myTarget 
			getter: #autoExtent setter: #switchAutoExtent
			help: 'Turn auto-extent on or off' translated.
		self lockedString: ' Auto Extent' translated.
	}

! !

!VideoPropertiesMorph methodsFor: 'building' stamp: 'dgd 8/8/2004 20:04'!
paneForVideoParameters
	| resolutionCombo brightnessSlider contrastSlider configureButton button |
	brightnessSlider := self
				buildSlider: #brightnessTitle
				selector: #brightness
				help: 'Drag in here to change the Brightness'
				icon: self brightnessIcon.
	contrastSlider := self
				buildSlider: #contrastTitle
				selector: #contrast
				help: 'Drag in here to change the Contrast'
				icon: self contrastIcon.
	resolutionCombo := self
				createComboLabel: 'resolution'
				target: self
				readSelector: #resolution
				writeSelector: #resolution:
				options: VideoMorph resolutions.
	configureButton := self
				buttonNamed: 'Configure Video Device' translated
				action: #doConfigureVideoDevice
				color: color lighter
				help: 'press here to configure the video device' translated.
	button := configureButton submorphs anyOne.
	button borderWidth: 2;
		 borderRaised;
		 extent: button extent + 6.
	""
	^ (self inAColumn: {brightnessSlider. contrastSlider. resolutionCombo. configureButton}) cellPositioning: #topLeft;
		 layoutInset: 0;
		 cellInset: 2! !

!VideoPropertiesMorph methodsFor: 'building' stamp: 'dgd 8/7/2004 21:39'!
rebuild
	self removeAllMorphs.
	self addARow: {self
			lockedString: ('Properties for {1}' translated format: {myTarget externalName})}.
	self addARow: {self inAColumn: {self paneForCornerRoundingToggle. self paneForStickinessToggle. self paneForLockedToggle. self paneForAutoExtentToggle}}.
	self addARow: {self paneForVideoParameters}.
	self addARow: {self paneForBorderColorPicker. self paneForShadowColorPicker}.
	self addARow: {self
			buttonNamed: 'Accept' translated
			action: #doAccept
			color: color lighter
			help: 'keep changes made and close panel' translated. self
			buttonNamed: 'Cancel' translated
			action: #doCancel
			color: color lighter
			help: 'cancel changes made and close panel' translated}.
	thingsToRevert := Dictionary new.
	thingsToRevert at: #hasDropShadow: put: myTarget hasDropShadow.
	thingsToRevert at: #shadowColor: put: myTarget shadowColor.
	thingsToRevert at: #borderColor: put: myTarget borderColor.
	thingsToRevert at: #borderWidth: put: myTarget borderWidth.
	thingsToRevert at: #cornerStyle: put: myTarget cornerStyle.
	thingsToRevert at: #sticky: put: myTarget isSticky.
	thingsToRevert at: #lock: put: myTarget isLocked.
	thingsToRevert at: #autoExtent: put: myTarget autoExtent.
	thingsToRevert at: #setContrast: put: myTarget getContrast.
	thingsToRevert at: #setBrightness: put: myTarget getBrightness.
	thingsToRevert at: #setResolution: put: myTarget getResolution! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/10/2004 12:34'!
buildSlider: nameStringOrSymbol selector: aSymbol help: helpString icon: aForm 
	| title slider icon titleRow col |
	title := (nameStringOrSymbol isKindOf: Symbol)
				ifTrue: [UpdatingStringMorph new useStringFormat; getSelector: nameStringOrSymbol; target: self; growable: true; minimumWidth: 24; lock]
				ifFalse: [self lockedString: nameStringOrSymbol].
	""
	slider := SimpleSliderMorph new color: self color twiceDarker darker;
				 extent: 370 @ 2;
				 target: self;
				 actionSelector: (aSymbol , ':') asSymbol;
				 minVal: -1.0;
				 maxVal: 1.0;
				 yourself.
	slider
		adjustToValue: (self perform: aSymbol).
	""
	icon := ImageMorph new image: aForm.
	titleRow := self inARow: {icon. title}.
	titleRow hResizing: #shrinkWrap;
		 cellInset: 3.
	col := self inAColumn: {titleRow. slider}.
	""
	col borderWidth: 1;
		 borderColor: color darker;
		 color: color lighter;
		 hResizing: #shrinkWrap;

		 layoutInset: 5;
		 cellInset: 5;
		 useRoundedCorners.
helpString isEmpty ifFalse:[col 		 setBalloonText: helpString.].
	""
	^ col! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/6/2004 22:15'!
createComboLabel: aString target: targetObject readSelector: readSelectorSymbol writeSelector: writeSelectorSymbol options: optionsArray 
	"private - create a combo"
	| button row |
	button := SimpleButtonMorph newWithLabel: '-'.
	self
		updateButton: button
		for: targetObject
		readSelector: readSelectorSymbol
		options: optionsArray.
	button borderWidth: 1;
		 cornerStyle: #square;
		 borderColor: #inset;
		 color: self color darker.
	button target: self;
		 actionSelector: #popUpComboTarget:readSelector:writeSelector:options:button:;
		 arguments: {targetObject. readSelectorSymbol. writeSelectorSymbol. optionsArray. button}.
	""
	row := AlignmentMorph newRow.
	row borderWidth: 1;
		 borderColor: color darker;
		 color: color lighter;
		 hResizing: #shrinkWrap;
		 layoutInset: 5;
		 cellInset: 5;
		 useRoundedCorners.
	row
		addMorphBack: (StringMorph contents: aString , ': ').
	row addMorphBack: button.
	^ row! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/10/2004 12:25'!
getLabelFor: targetObject readSelector: readSelectorSymbol options: optionsArray 
	| currentValue |
	currentValue := targetObject perform: readSelectorSymbol.
	^ (optionsArray includes: currentValue)
		ifTrue: [currentValue]
		ifFalse: [^ '<unknown option>' translated]! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/6/2004 21:29'!
performComboOption: writeSelectorSymbol argument: argumentObject readSelector: readSelectorSymbol target: targetObject button: button options: optionsArray 
	targetObject perform: writeSelectorSymbol with: argumentObject.
	""
	self
		updateButton: button
		for: targetObject
		readSelector: readSelectorSymbol
		options: optionsArray! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/6/2004 22:11'!
popUpComboTarget: targetObject readSelector: readSelectorSymbol writeSelector: writeSelectorSymbol options: optionsArray button: button 
	| menu |
	menu := MenuMorph new.
	menu color: self color twiceLighter.
	optionsArray
		do: [:option | ""
			menu
				add: option 
				target: self
				selector: #performComboOption:argument:readSelector:target:button:options:
				argumentList: {writeSelectorSymbol. option . readSelectorSymbol. targetObject. button. optionsArray}].
	menu popUpInWorld! !

!VideoPropertiesMorph methodsFor: 'widget creation' stamp: 'dgd 8/6/2004 22:14'!
updateButton: button for: targetObject readSelector: readSelectorSymbol options: optionsArray 
	| label |
	label := self
				getLabelFor: targetObject
				readSelector: readSelectorSymbol
				options: optionsArray.
	button label: '  ',label,'  '! !

!VideoPropertiesMorph methodsFor: 'initialization' stamp: 'dgd 8/6/2004 21:37'!
initialize
	"initialize the receiver"
	super initialize.
	""
	myTarget isNil
		ifTrue: [myTarget := RectangleMorph new openInWorld].
	self
		color: (Color
				r: 0.476
				g: 0.575
				b: 0.869).
	self borderColor: self color darker.
	self rebuild ! !

VideoMorph initialize!
VideoDevice initialize!
ImageResolutionType initialize!
"Postscript:"

PartsBin
	cacheThumbnail: (Thumbnail new makeThumbnailFromForm: (VideoMorph on: (VideoDevice implementation: TestDeviceImplementor new) ) updateForm imageForm)
	forSymbol: 'Video Device'.
!

