# Scikit-Optimize Code of Conduct

Scikit-Optimize is an engaged and respectful community made up of people
from all over the world. Your involvement helps us to further our
mission.

The goal of scikit-optimize is to become the go to project for black box
optimization, freely available to the reader and everyone else. As any other
open source project, it requires a community of people who maintain and
contribute to it. The quality of the project depends on the engagement and
size of the community; thus you as a user of skopt directly benefit from
creating positive environment that encourages people to contribute to the
project.

To ensure that we build the best possible environment for our community, we
introduced this code of conduct. When these guidelines are not followed, it
can be detrimental to the community, and in turn not beneficial to the users of
scikit-optimize.

We receive contributions from people all over the world. This implies
diversity of ideas and perspectives on often complex
problems. Disagreement and healthy discussion of conflicting viewpoints is
welcome: the best solutions to hard problems rarely come from a single angle.
But disagreement is not an excuse for aggression: humans tend to take
disagreement personally and easily drift into behavior that ultimately degrades
a community. This is particularly acute with online communication across
language and cultural gaps, where many cues of human behavior are unavailable.
We are outlining here a set of principles and processes to support a
healthy community in the face of these challenges.

Fundamentally, we are committed to fostering a productive, harassment-free
environment for everyone. Rather than considering this code an exhaustive list
of things that you can’t do, take it in the spirit it is intended - a guide. We
encourage you not to read this like a legal text that tries to solve every
possible event, instead use common sense for the parts where there are gaps. It
doesn't mean that application of this COC is going to depend on who you are or
who you are friends with.

Importantly: as a member of our community, *you are also a steward of these
values*.  Not all problems need to be resolved via formal processes, and often
a quick, friendly but clear word on an online forum or in person can help
resolve a misunderstanding and de-escalate things.

However, sometimes these informal processes may be inadequate: they fail to
work, there is urgency or risk to someone, nobody is intervening publicly and
you don't feel comfortable speaking in public, etc.  For these or other
reasons, structured follow-up may be necessary and here we provide the means
for that: we welcome reports by emailing
[*Tim Head*](mailto:tim@wildtreetech.com) (a maintainer of
scikit-optimize) or [*Kyle Kelly*](mailto:rgbkrk@gmail.com) or [*Abby Cabunoc Mayes*](mailto:abbycabs@gmail.com) (who are both independent of scikit-optimize).

This code applies equally to founders, developers, mentors and new community
members, in all spaces managed by scikit-optimize. This
includes the mailing lists, our GitHub organizations, our chat rooms, in-person
events, and any other forums created by the project team. In addition,
violations of this code outside these spaces may affect a person's ability to
participate within them.


1. **Be friendly and patient**.

2. **Be welcoming**. We strive to be a community that welcomes and supports
   people of all backgrounds and identities. This includes, but is not limited
   to, members of any race, ethnicity, culture, national origin, color,
   immigration status, social and economic class, educational level, sex, sexual
   orientation, gender identity and expression, age, physical appearance, family
   status, political belief, technological or professional choices, academic
   discipline, religion, mental ability, and physical ability.

3. **Be considerate**. Your work will be used by other people, and you in turn
   will depend on the work of others. Any decision you take will affect users
   and colleagues, and you should take those consequences into account when
   making decisions. Remember that we're a world-wide community. You may be
   communicating with someone with a different primary language or cultural
   background. For example some miscommunications might happen simply because
   of these cultural or language differences, not because there is an actual
   difference of opinion.

4. **Be respectful**. Not all of us will agree all the time, but disagreement is
   no excuse for poor behavior or poor manners. We might all experience some
   frustration now and then, but we cannot allow that frustration to turn into a
   personal attack. It’s important to remember that a community where people
   feel uncomfortable or threatened is not a productive one.

5. **Be careful in the words that you choose**. Be kind to others. Do not insult
   or put down other community members. Harassment and other exclusionary
   behavior are not acceptable. This includes, but is not limited to:
   * Violent threats or violent language directed against another person
   * Discriminatory jokes and language
   * Posting sexually explicit or violent material
   * Posting (or threatening to post) other people's personally identifying
     information ("doxing")
   * Personal insults, especially those using racist or sexist terms
   * Unwelcome sexual attention
   * Advocating for, or encouraging, any of the above behavior
   * Repeated harassment of others. In general, if someone asks you to stop,
     then stop

6. **Moderate your expectations**. Please respect that community members choose
   how they spend their time in the project. A thoughtful question about your
   expectations is preferable to demands for another person's time.

7. **When we disagree, try to understand why**. Disagreements, both social and
   technical, happen all the time and scikit-optimize is no exception.  Try to
   understand where others are coming from, as seeing a question from their
   viewpoint may help find a new path forward.  And don’t forget that it is
   human to err: blaming each other doesn’t get us anywhere, while we can learn
   from mistakes to find better solutions.

8. **A simple apology can go a long way**. It can often de-escalate a situation,
   and telling someone that you are sorry is an act of empathy that doesn’t
   automatically imply an admission of guilt.


This code of conduct is based on [the Jupyter team COC](https://github.com/jupyter/governance/blob/4345f740ed98c7aa578a9482fa36cf5de663ab54/conduct/code_of_conduct.md) as well as [http://todogroup.org/opencodeofconduct/](http://todogroup.org/opencodeofconduct/).
