/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.painters;

import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import java.awt.Graphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ATracePainter
implements ITracePainter<ATracePainter> {
    private boolean m_isEnded = false;
    private ITracePoint2D m_previousPoint = new TracePoint2D(0.0, 0.0);
    private int m_previousX;
    private int m_previousY;

    @Override
    public int compareTo(ATracePainter o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public void discontinue(Graphics g2d) {
        this.endPaintIteration(g2d);
        this.startPaintIteration(g2d);
    }

    @Override
    public void endPaintIteration(Graphics g2d) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ATracePainter other = (ATracePainter)obj;
        if (this.m_isEnded != other.m_isEnded) {
            return false;
        }
        if (this.m_previousPoint == null ? other.m_previousPoint != null : !this.m_previousPoint.equals(other.m_previousPoint)) {
            return false;
        }
        if (this.m_previousX != other.m_previousX) {
            return false;
        }
        return this.m_previousY == other.m_previousY;
    }

    protected ITracePoint2D getPreviousPoint() {
        return this.m_previousPoint;
    }

    public int getPreviousX() {
        int result = this.m_previousX;
        if (this.m_isEnded) {
            this.m_previousX = Integer.MIN_VALUE;
            if (this.m_previousY == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    public int getPreviousY() {
        int result = this.m_previousY;
        if (this.m_isEnded) {
            this.m_previousY = Integer.MIN_VALUE;
            if (this.m_previousX == Integer.MIN_VALUE) {
                this.m_isEnded = false;
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_isEnded ? 1231 : 1237);
        result = 31 * result + (this.m_previousPoint == null ? 0 : this.m_previousPoint.hashCode());
        result = 31 * result + this.m_previousX;
        result = 31 * result + this.m_previousY;
        return result;
    }

    @Override
    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        this.m_previousX = nextX;
        this.m_previousY = nextY;
        this.m_previousPoint = original;
    }

    @Override
    public void startPaintIteration(Graphics g2d) {
    }
}

