/* ----- decode/953x6343, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_953x6343_checksums[] = {
  "462d131e93122cf927e38d3798781c6d147030231c5697eb39bca774d4635e28",
  "7e950e4dd0d52156a6fe31883848e1937cdbe8905ef250b63749d08e599c115d",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_953x6343_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_953x6343_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_953x6343_ITEMBYTES

static void *storage_decode_953x6343_x;
static unsigned char *test_decode_953x6343_x;
static void *storage_decode_953x6343_s;
static unsigned char *test_decode_953x6343_s;
static void *storage_decode_953x6343_x2;
static unsigned char *test_decode_953x6343_x2;
static void *storage_decode_953x6343_s2;
static unsigned char *test_decode_953x6343_s2;

#define precomputed_decode_953x6343_NUM 4

static const int16_t precomputed_decode_953x6343_x[precomputed_decode_953x6343_NUM][crypto_decode_ITEMS] = {
  {-1680,-819,1712,-94,-1253,-2126,-1877,-1614,2253,-2101,-135,-303,-2775,2319,-2581,1897,1305,1312,-575,2497,1158,1089,-666,1106,-937,-2720,1842,2842,-1315,2744,1428,1211,467,1310,2625,1270,-692,303,2265,-147,-2261,-665,412,819,2438,-557,2199,1361,-3129,1167,-213,-1740,225,-2474,1687,-1635,-1120,-1935,-1451,-1506,-351,-1098,-517,1011,-2500,649,-2384,-572,1622,273,-226,-469,-3028,-2969,-2621,1106,-2772,-1197,2754,-1567,157,-2569,246,-2368,1123,762,1517,600,-2312,-1662,-2653,2505,-848,2448,3134,1615,1547,-2618,-385,3058,872,-2202,427,3000,-3046,1462,3086,1212,-911,2859,-538,3162,-2694,1615,1855,2457,886,-2271,-874,-1388,544,1950,-930,-239,2050,1200,-1041,1836,-2956,-2270,-1349,-2158,1550,-1171,-2880,-1520,-1861,-936,-2310,698,-2268,-1153,-1339,2667,2429,1628,1739,1568,-63,703,-580,3103,198,-2355,-1754,241,2802,2426,2866,-2979,-126,-268,1147,2545,1487,3157,1412,-2779,1058,1267,-1792,-2608,219,-2445,-1228,2790,-1831,-2492,-2888,635,1974,123,-1615,144,1030,-582,662,-1186,1226,1439,406,-1265,2696,341,1514,3152,2347,635,1149,-1054,-1590,-1963,-1901,-332,-921,1347,-2469,944,-1849,-1016,-2305,-514,2435,-1738,1087,2682,-566,-738,-2259,2840,1621,1462,1229,-2431,2095,3068,2070,307,2212,-1903,1917,-2943,-2372,-1021,2754,3112,-666,-755,-1617,-2423,-1222,-574,-1383,-687,397,137,364,938,1311,696,-430,275,2673,-2475,2913,-555,498,-1473,-2715,-2968,-2672,-2791,-2997,3058,-1007,-2671,-705,-140,1153,-2013,2549,-2903,-3052,-2530,-2918,-1298,795,349,1262,1936,1701,1221,2692,-1329,-2888,-2391,-371,-2371,2330,-813,2941,944,292,1529,532,1606,2183,-863,2917,895,2335,-373,590,2006,351,-2445,-692,-1392,-3073,-1563,2067,-316,-1595,2568,234,2076,1528,-362,-970,2095,-908,264,-2299,-1039,563,1926,-1192,-1859,634,-405,535,-2865,2913,2102,1263,-3145,28,656,-38,-1227,-1293,51,983,-1959,-425,-2297,1265,1724,2332,-580,2926,3033,837,2624,-567,2220,1871,-470,1659,2150,2182,1232,2992,-1973,1888,-168,-1383,-2237,-1217,-2036,-703,1869,1364,-28,97,-70,2458,-1121,1090,873,2787,2401,2880,2481,-2762,-2367,2038,-2122,2922,-337,-1881,1274,-3093,2124,1349,1303,-622,264,1582,-1130,-511,1888,-1188,-23,-2041,-562,-2731,-2698,-561,-2123,464,-2171,2195,1609,2859,387,-2830,-1701,2372,139,356,-968,-2540,-1211,-71,-2827,-21,-1164,-642,3064,-1115,-98,2849,1728,2608,-2750,2838,-1912,-282,394,-2556,-2058,-525,-1634,521,-2935,2856,870,-971,1567,919,-2605,-2734,752,3144,1534,-3163,-2265,525,1387,115,870,513,-660,-2866,1279,-23,-636,1878,1881,-3164,1623,-1920,3019,808,-2692,892,2024,2279,2871,-1555,-2656,-67,1758,-595,1506,1402,-213,1424,2725,1532,1710,-3152,-743,-2227,2332,-820,-3030,2028,572,1375,1926,-1500,3126,-868,19,-1020,-373,1062,-2205,-2310,428,1227,-1743,-1427,-1400,424,1557,653,-591,1658,2332,2901,-396,-2678,-487,-3164,-2942,1098,-1755,2553,2810,-3090,1922,-1848,-2042,-1881,-339,654,1813,-1443,1617,-1501,-620,-784,839,1580,2038,3012,812,283,-483,-2973,595,-887,-243,-990,-1102,-293,2179,3026,-2704,-573,1866,-1187,-1785,-1533,-303,-670,526,286,-228,-1738,1860,960,2225,1632,354,-2797,769,1752,3094,-565,2589,966,695,2716,3037,-34,2786,453,-3043,1836,-998,-1038,-1761,-786,-1799,1356,497,938,-2379,-1490,-1800,2397,-1248,1973,-2897,2347,2150,1903,2202,-1872,-827,-2489,-2782,144,3100,2583,-3075,1062,-1761,2461,1829,1610,2266,-307,-2681,1207,854,1575,-2255,740,524,-2986,1786,1026,2739,-463,1544,-799,-2535,-3041,-1941,-3044,-2188,1023,428,-1882,-2802,-2903,2490,-1055,-1870,1971,1806,2672,2818,-2437,1913,988,1318,-3024,-2319,-1663,2746,-2812,-1438,2660,-1043,2367,1956,-2257,1622,-1563,1357,-3162,-268,439,1612,2813,746,940,-2211,-418,-1868,-1390,2678,-2478,-621,-70,1851,2962,-2713,566,-1770,-726,-3129,2845,956,-660,835,1994,-123,-2571,-2784,1643,2704,-2301,-1356,661,764,-237,-280,1433,-1130,-814,1866,912,-201,-2519,-2600,-683,3131,56,-1987,-1874,-911,-1302,1573,-169,-848,270,-460,-2941,-2686,-2172,2581,-2994,-1856,1594,-2733,1490,-1034,2539,2237,-2837,2371,1390,2453,-883,-2286,-1973,1856,2680,736,2424,121,3049,1932,2298,1056,-1923,-1254,-2059,-2241,-1181,-2265,-701,545,1458,-2304,1234,2149,2691,1139,1788,629,2231,1665,375,2019,439,-1791,3040,267,152,-1694,1675,2798,-1660,-2831,2979,3170,-1719,2777,-2112,-3056,1272,2307,-425,-1782,569,-278,2947,-2528,1535,-2123,3019,-3137,-1330,-453,2056,-1174,1524,-2594,-211,-2735,-3033,-814,-2773,-875,-912,2251,2395,2592,830,1474,-30,-1816,-791,826,-2351,-1861,2835,-2088,-667,3008,-256,-1495,-743,-1974,1424,-3101,-743,2562,-498,-363,2615,3073,-224,-1868,-172,2789,2804,2732,2985,-1644,2026,-2046,1595,2917,-1033,-3057,-2339,-625,-2489,1309,-2332,1067,2173,880,2659,-327,-2614,-1815,2673,-1242,2225,952,2982,-745,1588,652,1052,-1333,-790,3140,1965,305,-1072,2236,-2204,-140,-2955,-693,-414,1975,203,-2934,1748,-2395,-2176,-2934,-697,2495,-2293,-3008,824,-2628,1478,-1947,782,-2517,-2268,2883,287,1592,1026,-2659,-1634,-1661,3123,1010,-1072,-2523,1216,-123,-2865,-986,856,-3080,2628,1917,3113,-3041,-215,-1490,-2023,2324,-2877,1367,-2323,2200,-319,1395,-1272,-2384,-3052,872,2216,-1055,-2541},
  {-2437,-448,2988,95,911,1780,-42,2252,2731,797,851,2100,350,2210,-248,-643,-1448,2319,-2503,330,-1609,-757,-548,1193,-237,-1408,1451,-2530,512,2322,2537,331,2166,2369,-1903,-682,565,-384,1354,-1425,2439,-2895,-1432,-1735,-276,-718,34,1866,830,2729,-2338,-1450,-300,420,1322,-645,-2805,1859,-2989,3166,420,-101,2373,903,2442,-3148,1728,942,-2295,132,944,2431,-2827,-2238,1742,1801,-41,-16,-540,-963,895,553,3101,-800,-753,2726,-2774,-2947,-1621,286,1341,-1903,-1092,-1016,-648,-2279,1945,1623,-593,981,-2682,1776,-806,-1888,-3025,2369,907,-2179,-2794,-303,-671,-289,-464,-1607,-461,-1669,-1206,1844,1215,-1435,1221,2882,650,-978,-2663,-2344,249,-1304,-373,311,2917,-1349,966,-111,2981,1589,1001,-2554,-257,-2150,-1063,515,-2325,2662,3047,1991,330,-1945,-758,1984,1120,-2992,2168,2769,1137,-982,-2000,1116,-1574,-349,1993,2131,2867,-1612,-2592,2671,-1490,717,-2959,-1107,-2245,-470,-2332,2069,2628,-1722,2042,3080,-1561,-1638,-1557,3168,-1685,-2979,-513,1427,-2823,1494,-2462,644,254,2883,1046,-2301,-2672,842,620,-2019,1354,-416,-2592,-22,1562,-2093,1343,-642,-2009,-1221,-3129,-2044,-2877,-1691,-3062,-2402,-2659,300,-948,-34,2182,2409,2047,-3100,-550,188,-2719,2929,2579,-23,314,2258,1788,-1481,-2591,3066,-633,-2758,728,-2496,-1258,87,2417,-3134,2605,1765,1218,3141,2422,2083,763,1439,814,-1440,-2379,-332,-2197,-2105,-1921,-1002,3114,1877,-1011,-421,1190,2627,-1320,2101,-2842,-2559,2029,-760,2441,-2999,-108,-1132,-795,-202,1583,-2688,-1232,-2285,-1459,231,2852,843,2752,-696,2206,-2994,-1858,409,2867,1631,2099,2850,585,2136,1121,223,2453,-1290,195,889,-1833,684,-384,-2041,1995,603,-293,1217,416,-152,278,2717,-1971,2786,-542,-2824,3033,-1074,-1936,-2260,1883,-1066,-1205,-1135,1532,-2524,-650,1101,834,2821,2786,2130,484,-189,1719,2647,-2570,-2871,-2991,-1665,-30,-1648,1633,-2045,1790,694,-1487,574,93,235,-489,-2347,2483,-2297,413,-2489,-2805,2074,2275,-2159,-279,-571,-1528,112,831,-436,-179,2555,961,-1206,1968,972,-2471,198,2585,317,-727,1266,-2123,1943,-907,3014,-1682,-2642,-55,-1253,-2041,-2343,691,1523,2902,1760,845,-1607,1482,-1082,-2702,235,-1157,-2932,-252,1405,366,-1461,2427,-2645,2711,1862,-1074,846,-576,2067,2246,-265,-2707,-594,-790,443,1819,1199,1070,-1681,3004,1181,-2432,502,880,-862,-2020,1697,3081,-331,22,-542,-2232,1931,-2351,762,-2663,2648,-2370,-2702,565,143,-1772,676,2430,202,-534,686,-1248,2847,3086,1867,-1668,-746,9,3014,2246,-650,2884,-1132,1054,2144,1755,-2016,1284,91,483,380,9,1349,-350,1468,-2133,-2938,-1976,-213,-2792,-3072,2550,-1999,2080,-1369,1007,2552,1240,-1249,1641,-3043,2270,-1328,1376,-1105,-29,2791,-943,-1231,-846,863,306,-2204,-1967,-1193,466,-270,-1117,-909,2087,-2363,932,874,-167,-329,-2988,143,-1379,-854,1511,-635,-1118,3142,-2604,-491,-2744,-179,-615,-484,1218,1187,-18,-3046,3030,2282,-39,-2797,-2612,2377,-3150,1604,-3078,-2365,1446,-2941,-1321,-1149,2823,1861,2998,2635,110,2930,-864,-444,-2929,1089,2500,2060,-1728,1836,-971,-644,613,-1591,3080,881,612,-375,-537,1979,-2485,3149,-2393,-3171,-513,505,-1378,-1239,1685,-2656,-938,-1913,993,-1754,720,1609,1535,1722,-1689,-2773,645,-117,-3099,237,63,2661,3135,1981,-2525,2042,2868,-1406,-2251,3095,-2190,1219,-1667,2449,-3042,1363,-217,-893,869,-3044,-2671,-1423,9,-1140,2217,-147,-628,-516,1536,-1530,2945,-2167,-2448,-1059,3096,-2530,2659,-2062,-1664,1403,2680,-1748,-625,2380,2988,-21,773,-336,-251,1840,1468,-1466,-2722,-560,-1747,1251,2391,-175,1608,1813,211,1133,2195,-459,-829,3117,-404,3134,1751,-862,2921,2105,-3008,-1462,-1804,-2840,2635,3144,1505,-796,532,-538,-687,-5,-201,-2203,-2561,-1798,500,-2738,-224,1378,940,-3111,-1164,1401,2299,413,-2923,1995,2359,2129,1655,-2510,-1126,858,-2600,1610,-1836,-262,-1628,-2648,-1242,-766,1697,335,332,2240,-3038,-1831,589,-1139,-265,428,-402,1419,-2647,472,-888,-512,243,-1375,-3072,1720,-649,-2323,-2281,-2465,-22,-42,-1224,-1803,815,-1811,-389,-1122,2648,2715,-1369,-1543,-736,-1289,914,94,-2582,-1997,1588,258,-1263,2998,-872,-2491,-1043,2034,1639,-1019,-926,905,-2222,297,1352,2604,-1724,736,178,2982,-240,1555,819,2537,3078,-2980,-39,-1982,-118,72,-1425,-220,2033,2160,1255,-607,-1704,-2983,2671,-587,-910,-3105,1039,1314,-2833,-2416,47,1954,3168,-1107,-1445,2480,750,-3081,-659,871,2333,843,-119,-2112,-2313,-318,2503,-1071,814,496,2368,-2000,1370,-1881,-2582,2813,-2402,1567,1115,-3,-2247,146,-991,-881,-1293,753,-2589,-1839,-953,254,1877,270,-2820,1946,982,2811,467,806,212,-2584,787,1568,1742,-1203,-1925,1386,-1551,-1234,2779,1546,1957,2105,-716,244,1939,-2212,-267,1964,-2703,2430,2506,-1597,2742,3158,-424,2828,1741,-1880,-1214,2957,2898,457,-1258,-669,-435,-46,-1022,-633,-246,-1675,-3012,-370,76,2108,-2196,-2216,-2351,-2956,-1885,-2522,-983,2436,-886,-775,2365,2473,-2962,-7,2428,-634,-675,-2841,-1126,-133,-1311,2093,-2811,-3002,1803,-426,1516,-2663,1364,-2728,1068,1403,995,436,-2227,-1566,-2307,-1371,-2339,2605,-1656,845,2957,-1472,-978,102,-2401,1011,-175,952,-544,2254,1304,1221,-1660,2464,-2312,-603,582,-1961,1094},
  {-2380,-2698,259,276,-2744,2591,767,179,2862,1111,61,1156,-1898,0,-525,-1662,-2872,1941,3145,2794,-2460,2715,-2915,2902,-802,-522,-2828,-2970,-2237,-377,1599,-2591,-1535,2437,-454,-107,-1341,-2093,640,1191,-97,-2653,67,416,-2284,-2869,537,-991,2459,1540,410,-2833,346,2784,-923,-534,1683,-1970,-1386,2893,70,2863,2573,-1030,-3081,-668,-2172,-260,-2430,1936,-397,-828,-2408,2960,-3082,-2109,-2964,2959,2151,1727,1577,-493,-2626,-1128,-1247,1654,2428,-427,1939,3171,1865,-1970,-2017,3135,-639,495,1617,-1361,858,857,-1166,771,-2095,1436,-2662,-165,2009,423,-2637,856,433,-876,-2475,590,-588,-780,2137,-1410,1378,-2306,2162,-89,2300,-2435,1812,-2644,2981,1032,-183,166,1655,2082,-1733,-786,1949,465,-1577,322,-1082,-1693,-1670,-2724,870,1057,-2047,-2788,2505,2542,2650,-1111,2878,670,-1015,225,1541,-1989,2398,1249,-1799,-1650,3131,-40,-1448,918,2345,500,-1171,-352,1412,-811,2349,-1456,783,-64,-67,2994,136,1245,-717,2567,-739,-1062,-1684,-2271,-2368,-2882,975,1083,-2456,3119,-75,2155,2051,887,-1970,1758,233,1398,1120,1900,-1484,1491,2677,2622,-2802,3058,2631,-727,-2204,-654,-1143,2823,1984,-664,-2646,-523,-2292,1105,1512,-734,729,-382,-1303,-146,-2566,541,720,-1338,2149,2095,-2376,511,2641,-994,-1657,1834,2807,2618,-2928,-3165,1979,645,-33,-2965,2742,5,-1844,-337,-1183,2512,-2399,1036,957,2082,-2386,1584,-277,791,-2137,-267,-1145,1218,907,1095,-966,-2618,-2142,1544,1800,-2801,-2572,2953,1053,2823,599,-338,-1223,2223,-1301,-1096,-2178,2506,1642,-1965,-3110,-2356,-2665,586,-841,1277,-672,2084,2553,-607,427,2509,-2005,-1843,1203,-952,125,2503,-2177,-965,814,-2368,-2402,2085,1292,-2697,460,420,1625,1364,803,-2487,-375,-1036,-1032,-2183,-2366,2642,-1733,2521,2906,-2582,967,-95,334,-2348,2061,1972,-253,93,501,-1601,-1996,1949,2172,2163,-387,753,713,966,-2042,-784,-824,2989,-1104,-1834,-2632,-3157,-1828,-1770,2840,1461,-2071,2027,151,-288,9,2646,-2339,1032,-1936,-2237,-38,-719,1247,-1863,2279,359,849,1688,2730,1882,-2889,1332,-2088,500,-2434,-2353,484,-2448,-2824,-2835,-1662,-2122,-489,-756,610,1563,-1579,2523,3049,1104,-172,-1373,-522,-164,-1744,1792,-2233,-1566,1313,2124,234,-1508,2573,-3012,2839,1312,1086,-3093,621,-967,-1594,460,119,2513,51,-223,1585,-663,1,2045,1844,-681,1623,724,314,694,-1156,-2132,998,2765,165,-369,593,3017,1541,-2626,-194,651,-2872,19,1833,-3118,2157,-248,-2070,174,-2813,-1183,741,1302,1191,-937,842,1464,-2115,1780,1059,-1110,2393,-2847,1737,-162,-1381,1068,1596,-703,2268,-1650,-263,53,-1388,-2561,-2678,-59,1795,1686,-240,1197,953,638,614,3043,102,-1568,1333,-1589,-1550,908,1892,1074,-828,1160,-191,-3025,1602,905,87,-107,59,-1264,-2073,1417,-594,-1095,-1685,1304,2479,-539,885,-1003,2075,-1062,2302,816,-1438,-1068,-2180,-2484,-2202,-2307,-793,-2300,111,-2971,2833,-409,781,-677,1045,-1790,2618,-970,933,2042,-710,2372,265,-1650,1879,1073,-276,1457,-2734,1752,2257,754,-747,-1498,-438,-1342,-91,2733,-2480,-2600,1419,-1506,1117,-2854,1973,2516,-2736,2488,1965,3129,-2839,-2953,-1586,1649,-2043,960,194,916,3112,554,2223,2757,1616,-2345,-910,-2714,-280,344,-1884,-1805,1435,1825,-1202,1596,-906,1961,1397,-2512,3039,2935,2294,154,3001,-1804,-41,-2318,576,2181,1489,-212,-2442,1833,-466,-2865,535,689,1100,1532,2014,-999,918,930,-2247,-2449,514,-2601,607,-731,-2774,2511,534,2246,465,2743,-2977,-228,-1298,-1520,-2971,-3105,433,-2602,-1550,-1910,936,-487,-591,-2832,-149,-1266,-2337,1082,-2323,997,1418,969,563,3140,-1863,-1887,1602,508,-1195,1975,-2167,-851,-2593,2663,2249,3001,2006,-1768,-2421,2545,713,-2789,66,1379,-2967,-3106,462,2639,2897,-2889,-2532,-1880,2839,1191,-100,847,-609,-200,920,1251,-423,1314,1126,-1682,-524,2696,438,902,-263,1711,-1843,-2557,-604,2913,-3094,1199,365,-610,170,1028,2144,2075,2031,158,1686,3120,-3155,-2684,134,2773,148,629,985,-2279,2587,2576,-2149,-1870,-2081,-572,-68,2182,39,3035,-1957,-1449,2383,-2224,-1762,-2007,-1668,2307,-664,-1774,3131,-2278,2500,-1194,1970,-291,2239,-1771,-18,-2798,-153,-2702,-992,-2155,2770,-2299,1691,2507,-2095,-711,766,-2007,-543,3010,-143,2965,-2050,3152,-2171,133,-1884,-2221,-1520,-394,-2223,-2724,-1539,386,264,947,521,1196,220,2930,1473,-3064,-37,-702,-2558,116,-2774,-1771,-1543,-1289,2688,1765,1347,2693,-2938,3046,2072,-488,-1090,-128,-1216,2552,-2627,-635,-1703,-769,-3029,225,1854,-1731,2530,-3106,-1562,1510,2028,581,-1496,-1112,2103,-2903,-134,117,97,-2595,-120,2733,991,1549,-1318,-1514,-1384,-1657,-868,893,268,12,3097,692,2110,-1383,-1293,-2907,2712,-802,1551,1884,39,418,-1602,-1196,884,-1686,-1010,-1159,1339,-1300,-3102,1517,2241,1603,2186,1526,-627,3112,-1684,2530,-2171,2747,573,2914,-1666,-659,2758,-1320,1047,2619,-722,711,-952,-1129,2707,3132,-292,-39,-403,1327,-1763,270,-2933,1283,-104,-2133,1290,-2912,3076,-1409,407,-172,3093,1335,2455,-1442,-1696,-2410,-97,-1765,-1542,359,3127,-1662,-661,2802,-59,2366,-2777,-411,2812,-167,-2564,2364,-978,1363,-1714,1529,-2572,-90,748,2968,-2864,2704,-407,228,133,-2128,984,710,2631,-1292,-1213,1187,-23},
  {-247,-1155,-2532,2748,-2211,1053,-2532,-1834,-2821,1824,-1093,973,619,-2094,-471,-2664,3048,-2043,-2706,703,2841,209,1865,2165,-1923,-473,-1920,2026,-94,2665,1099,-1947,1298,3086,1542,-1400,-2479,1204,1101,-1878,-1841,-2245,2334,-270,-1748,-1967,1740,-1073,-354,124,1062,-1714,449,2201,409,945,-463,1212,-1012,1520,2115,218,2651,390,-1825,2654,1541,1250,901,-1867,1296,1661,-2840,1770,1810,-345,2953,656,1397,-536,1566,712,430,-2353,386,-87,3055,-2391,-821,2922,-2704,3073,-328,84,2515,2065,2715,1610,702,1723,-1601,1761,3011,-1652,315,-1855,-2044,-2088,-477,1039,-580,741,-2983,-812,1381,-2712,2407,-438,2701,2462,-858,-3159,-1211,-872,469,-2486,1761,-987,-2466,457,-2578,-1738,-200,-462,276,-2851,-1082,3150,2381,-955,2607,792,3101,2192,495,887,182,1541,-1754,-1584,-2187,1534,-153,1764,-2974,780,-953,663,2866,-185,-2105,801,546,-558,-946,2665,2078,1445,-519,1919,19,2734,-2580,-1587,-2393,1991,-1409,-1274,-1864,-1550,-2102,408,-1018,1438,3125,924,-859,1778,2143,-418,-854,-2367,1199,1776,-2818,2403,998,-648,932,-2286,-1228,-1323,-2049,-3036,-1538,-3025,2805,2500,2103,-2231,3084,276,1422,-2729,1819,-691,2780,-477,297,-1553,585,-1564,-1540,340,-400,215,2164,-2387,-782,-1207,-2341,2444,-2521,1572,2196,-2098,1498,2431,1871,-1555,-2851,-1101,1816,-2087,-490,2284,-2268,-3008,-2608,14,2088,-2268,-824,39,1041,-481,1062,2022,2626,2141,2603,2672,-1399,2198,-2749,569,943,-451,1851,-1743,-3026,1826,-1886,476,-1086,-2071,-890,2642,2764,2767,742,-925,200,1751,-980,279,1755,-608,2064,-1696,1540,-3147,895,2169,2350,-1047,3004,-1900,-636,103,2931,-42,871,944,30,-2834,-2616,2504,532,2852,430,1294,-901,-2069,1118,-896,-2875,545,-915,2269,1527,-928,1587,1075,-646,2179,-3140,1173,2839,2435,3167,-2410,-3074,287,669,2763,1896,640,-1996,-2834,-1890,-1562,2181,2764,636,1006,-2980,1267,2800,-1137,321,-1245,417,-1671,-2571,-1768,221,3066,-455,-1005,210,2027,-251,3102,-3103,-1229,-1493,-850,2624,-828,-868,-440,-2277,-2633,2031,-2137,-2290,941,-1637,6,-430,-2043,385,-1694,1877,1040,2153,230,-2328,229,1563,2864,1764,200,1109,960,1679,-3153,-2771,-1756,2066,-2037,1993,-1664,-857,2584,-1642,2728,-1957,-2401,-2573,-3110,-2213,1131,523,-1496,3142,-2021,2061,-2578,-210,-1930,2993,-2261,-1967,1384,1897,2506,-2448,2977,-781,-864,-1672,-1366,-2766,2183,706,360,1711,-1926,-2192,407,-3002,1563,142,1475,-1323,1012,72,-223,1951,-351,1966,1045,-350,505,1482,-288,-2602,-415,-2690,-1252,-1749,-108,-1605,-2888,194,-1680,-143,1662,1512,689,-245,-2945,-2413,1460,1987,-144,244,-1655,3038,-702,-2228,-470,-802,-1589,1776,681,986,-2265,996,2594,1692,2294,893,-2805,-292,-2903,945,-860,-3059,1105,-1024,764,-1886,-843,1766,-330,-688,1020,2632,2566,2925,-2174,-1322,-1057,1073,-647,1225,-2635,2657,1189,-2481,-2413,-2685,-741,1746,1931,-1066,1261,-2211,-285,3144,2803,307,1277,-1535,-2464,2834,-671,-1487,-2200,24,-1718,521,625,1556,93,177,1915,1791,1764,-2872,210,142,-202,344,-318,-1281,423,-1744,-2886,528,-1426,-975,2671,470,1305,213,705,-652,2127,-295,-2059,1580,-420,-2814,2523,-3053,2309,-1974,-585,-482,-1034,-2521,-1681,-2524,-1603,1558,464,1236,-2347,508,1102,1779,2944,-2851,-756,-2661,2538,1489,66,-94,2752,-267,-691,1104,-828,2456,2377,1661,-544,-817,1012,-1101,-2732,-27,1911,-516,496,759,1962,2301,198,2557,631,-2082,-816,1930,415,1254,2091,3143,790,2771,-1070,664,-2056,2325,202,2283,1545,-449,670,-2279,2009,-2038,-957,1599,2958,1508,-1100,1054,-2127,1445,-2032,2510,2465,406,24,1103,1662,2625,-2779,-732,-3168,-838,2327,-1958,-2626,2284,-1874,270,2519,-1044,-921,3062,1564,103,2895,-456,-1310,-1672,2008,-218,-238,-146,693,2308,2063,-905,-1922,2416,2854,1686,1336,-2687,-1108,292,-1148,1249,-874,2291,-726,692,1738,-1030,1689,2281,-2356,2483,-1712,-976,338,-2407,-1644,-678,320,1216,1763,-788,-519,-8,-2698,302,-1556,419,-635,2165,-2996,-2593,-1266,-1071,1244,639,-1636,-1930,-2244,-1528,-292,2099,-2818,-2260,-1456,-1024,2793,1272,796,1899,-461,1241,-1011,-2733,-100,-1325,2282,1246,-1032,-528,629,-538,1967,-2228,1414,61,880,-3145,-404,2330,-1823,2956,-1059,1321,2196,194,-223,1308,-2694,2701,2963,185,-2768,1692,818,-2002,-2744,-419,-2098,-2928,2497,-1286,-120,2821,-1794,3034,1780,906,820,-994,-28,-2900,-2158,316,-2865,-1987,-1849,745,2926,1251,-1304,-1013,-1275,1448,-412,510,2155,-2936,-2521,692,-1861,879,-945,-1887,-2909,1873,-1337,652,3037,-1207,997,-2038,3012,-1358,2675,-710,-2113,-227,1605,1484,2925,1623,851,-84,2897,-2854,-986,2789,-1788,-1341,-2372,2243,-1920,1288,-2948,245,-1555,2494,-373,2214,-2759,-2371,-230,-2963,1790,-1912,2284,2694,-2269,2171,-330,468,848,1041,-2117,-2185,1407,2650,2527,-2022,1597,1771,644,372,2385,2326,1741,-2050,2986,2891,-1465,3088,885,457,-2420,1934,2582,1789,-2083,-2821,-2918,2391,-1057,980,-3146,1902,2217,-1619,-229,-2764,-1976,-2024,844,1395,2483,656,-1115,-234,-610,790,2263,-1147,-1171,-1093,-2545,910,1779,1108,-615,-2311,2335,362,1657,-2855,-1201,-2508,-1484,2070,675,2144,-1432,-640,219,-3013,-1054,1577,-1101,-2029,1147,-267,-2653,1879,-82,672},
} ;

static const unsigned char precomputed_decode_953x6343_s[precomputed_decode_953x6343_NUM][crypto_decode_STRBYTES] = {
  {35,170,246,226,209,43,97,183,242,164,72,161,42,93,226,133,81,246,32,160,101,96,124,254,79,175,192,13,61,133,73,48,125,193,211,234,45,70,236,195,148,143,153,59,227,21,230,183,72,220,239,139,19,131,250,188,207,168,255,44,115,174,56,205,19,188,100,143,229,103,227,143,149,141,217,246,9,16,1,86,246,80,142,197,17,186,173,13,94,16,58,94,248,224,255,80,77,152,245,236,10,217,11,83,236,105,138,79,54,168,52,253,59,58,134,202,117,43,250,154,74,179,237,207,42,34,123,164,58,53,145,18,33,165,136,204,123,86,232,122,53,84,74,17,89,144,3,191,146,255,45,71,121,7,213,65,32,206,213,172,134,4,42,76,58,137,159,2,95,154,8,131,152,81,86,249,13,189,173,95,171,228,249,222,244,164,0,46,187,64,151,135,243,0,114,13,32,116,131,246,53,241,215,203,212,80,131,73,87,152,201,44,213,199,109,142,116,133,45,204,39,124,108,176,107,238,19,180,179,206,28,37,105,26,50,51,217,223,134,107,96,98,232,113,100,57,234,191,127,87,111,145,220,115,76,73,67,102,149,167,87,201,193,226,32,109,195,101,14,37,172,6,190,10,244,72,190,191,54,91,32,41,197,94,111,127,208,120,119,78,165,94,11,243,214,103,6,119,118,160,132,228,0,31,28,82,148,56,90,162,199,103,85,123,6,228,234,241,23,182,4,127,180,92,181,96,155,3,255,196,88,172,179,114,136,149,100,115,101,51,240,223,94,94,32,162,109,214,152,219,117,142,93,240,213,208,77,127,29,19,142,59,85,11,32,186,6,109,235,225,116,215,232,68,79,47,139,127,57,120,162,98,47,33,149,210,200,155,203,98,85,60,87,124,126,23,34,128,32,157,249,174,211,182,129,136,103,201,218,120,139,215,170,184,88,117,7,72,169,114,68,70,15,182,132,87,111,76,158,128,207,116,185,63,214,213,38,242,132,22,150,187,29,205,224,229,202,52,166,155,244,215,58,179,18,122,78,176,146,53,21,42,77,22,95,180,221,102,221,10,157,254,165,32,228,107,44,222,0,222,165,222,167,27,179,181,63,93,43,185,150,124,119,255,105,161,202,174,232,89,225,99,118,125,185,200,105,215,115,143,6,89,58,71,125,111,83,169,124,196,150,176,217,172,81,200,10,42,101,29,167,247,84,239,202,74,122,30,57,113,172,112,135,237,121,38,190,59,80,152,254,54,64,128,252,108,216,72,8,218,58,75,161,141,38,45,210,155,156,219,58,229,106,244,175,82,230,62,50,88,74,113,174,135,95,61,191,240,228,154,168,113,186,100,99,128,213,211,251,20,181,183,78,184,149,52,22,153,205,21,125,28,43,227,13,169,172,255,26,97,151,136,184,4,24,77,22,120,233,161,150,186,144,175,4,198,127,18,193,99,168,151,164,12,160,36,11,102,224,187,151,233,151,243,237,200,86,190,226,18,190,137,223,118,111,181,138,188,247,12,19,79,97,233,24,70,170,248,35,252,59,52,79,250,162,39,164,33,239,208,239,27,251,107,168,167,51,26,153,135,217,195,133,21,45,119,179,177,71,174,209,233,195,218,139,156,176,140,169,132,105,70,138,252,251,164,221,193,5,47,127,225,210,112,233,241,47,187,230,70,23,119,100,231,46,130,88,101,153,101,227,176,99,144,240,59,223,180,21,255,50,51,11,143,70,7,12,184,66,178,10,252,173,248,64,61,71,221,86,36,68,96,214,158,197,216,30,1,229,202,51,238,41,209,80,181,136,37,165,67,117,122,119,15,187,83,10,129,156,98,3,24,198,92,222,234,124,62,189,32,86,58,149,207,147,221,100,162,146,49,87,228,134,205,83,233,253,20,55,66,247,227,93,216,255,233,57,209,86,108,100,40,175,228,0,108,13,227,208,246,22,79,248,16,94,110,42,157,169,49,229,41,138,89,65,64,83,202,17,34,223,229,96,22,65,245,30,219,28,130,76,91,232,95,26,215,251,26,105,253,111,46,30,244,24,110,35,202,180,157,161,137,211,91,145,245,255,11,101,158,203,43,169,194,235,191,123,18,177,123,120,222,199,137,154,173,67,190,253,219,188,56,109,218,126,248,48,51,68,79,231,225,57,41,197,79,9,42,15,44,159,168,190,129,159,59,157,192,115,75,161,129,232,234,80,153,17,59,176,31,143,223,177,127,99,27,220,225,76,80,203,73,111,136,49,198,225,190,122,14,44,184,160,73,54,14,105,10,59,62,16,153,155,110,36,17,54,0,238,204,92,40,149,249,120,218,117,172,206,147,45,221,96,135,153,202,90,213,202,10,198,55,226,254,119,184,144,13,139,102,134,202,9,234,165,222,14,35,109,177,202,239,99,224,78,197,13,89,76,99,171,166,63,184,74,226,73,147,200,5,172,255,220,199,213,90,30,211,84,25,46,198,55,228,141,226,35,76,134,8,2,246,228,22,51,160,244,96,200,149,63,236,167,7,21,35,75,94,198,110,83,44,35,2,154,246,254,13,117,23,149,65,221,78,11,90,198,62,155,254,130,172,79,4,121,40,231,244,70,1,127,55,22,124,205,171,2,166,19,79,238,226,215,36,144,194,155,175,124,202,69,180,86,189,178,95,182,15,30,56,85,83,138,200,3,180,52,129,1,207,49,241,4,175,131,249,239,11,14,82,36,125,60,56,182,178,233,12,189,4,76,168,114,200,39,77,55,30,29,32,185,191,210,124,212,100,208,225,178,71,161,204,157,14,183,239,96,76,250,169,71,160,70,27,220,204,199,106,165,106,103,106,154,11,112,121,177,20,235,128,40,79,77,255,218,187,250,96,70,5,160,34,228,184,49,172,17,65,226,11,255,202,160,148,107,78,50,163,231,156,18,250,204,85,255,154,203,31,124,184,111,165,43,129,50,204,178,88,34,2,35,33,4,125,135,247,82,154,88,5,51,189,139,199,4,182,213,107,3,52,177,46,222,237,195,92,206,176,119,177,26,184,142,153,50,180,244,202,69,154,108,10,51,192,222,131,87,62,134,76,187,191,153,86,112,123,44,84,110,237,36,163,213,6,194,90,103,172,27,193,207,26,201,213,5,164,244,96,119,145,126,119,177,153,181,219,24,244,202,198,209,155,44,74,210,82,181,47,120,175,113,114,183,8,42,137,18,126,82,153,213,65,143,246,134,84,215,236,133,219,167,49,239,162,212,71,101,63,179,180,130,118,212,30,203,159,95,126,198,184,130,99,204,176,219,226,139,208,184,251,215,163,45,230,91,212,243,93,158,116,178,196,95,63,41,102,189,116,180,5,154,153,162,62,208,227,105,244,35,17,153,47,4,50,176,201,42,80,141,84,190,169,162,42,250},
  {147,143,221,50,147,64,194,235,142,35,23,57,164,220,139,184,89,98,23,220,156,170,147,106,235,173,85,28,86,180,142,8,85,71,195,235,13,205,235,14,118,204,15,3,34,118,0,144,245,25,16,149,168,154,31,141,120,215,189,86,121,48,142,100,206,79,90,40,253,178,193,66,155,78,37,76,191,104,167,190,182,126,149,147,113,201,173,175,85,157,76,203,76,155,63,95,146,18,154,229,110,207,146,54,14,51,14,19,229,150,18,250,87,106,40,106,14,106,154,22,107,234,164,79,217,12,169,192,164,13,26,112,213,58,48,204,235,199,13,221,134,201,141,145,240,180,179,182,162,248,232,99,71,254,111,238,12,241,231,39,166,61,119,251,129,111,225,84,68,197,57,111,143,44,6,85,138,23,245,101,227,141,14,155,156,16,171,131,86,64,107,255,195,68,110,105,79,142,66,183,30,202,119,104,137,215,92,192,59,20,158,63,52,110,41,244,54,167,125,38,147,243,86,37,144,103,138,197,208,129,21,165,143,170,245,2,240,99,15,92,151,170,136,211,189,251,3,154,236,62,38,153,249,201,116,48,241,242,149,172,34,50,19,60,99,73,5,61,125,110,160,187,248,100,55,101,7,210,77,200,54,75,201,151,16,163,152,54,5,132,100,220,249,212,9,180,18,143,39,36,42,1,227,33,73,105,224,89,58,190,208,64,121,238,83,147,2,160,83,14,252,48,13,208,90,22,80,177,169,130,125,1,248,39,81,172,176,45,141,11,98,195,42,116,14,14,208,39,187,125,98,180,2,203,124,173,38,16,153,166,242,7,100,176,112,198,171,197,194,62,159,63,156,16,155,21,220,173,159,122,110,251,183,168,8,57,30,175,14,40,240,95,206,88,116,111,12,66,119,169,167,41,135,240,19,143,192,254,89,55,200,210,221,1,31,88,7,109,159,210,124,8,207,70,31,79,18,130,182,138,155,44,20,248,28,128,173,209,127,172,89,53,180,103,182,206,232,91,220,139,132,88,145,125,179,180,238,186,75,172,216,20,168,112,22,124,19,221,25,201,159,190,4,134,30,9,45,145,13,80,112,150,101,133,73,125,15,249,73,23,76,118,230,117,193,7,204,22,192,204,227,120,70,165,74,118,72,213,96,246,162,72,98,144,242,28,213,192,27,72,162,133,100,11,127,101,123,151,181,26,207,220,124,37,20,223,246,62,227,250,230,39,231,2,211,84,4,187,2,31,91,9,100,139,212,248,110,80,112,96,204,161,241,156,252,250,55,70,59,172,156,125,126,179,10,3,230,211,213,4,77,235,159,202,195,53,231,178,237,165,44,139,234,164,120,217,26,130,130,189,209,142,154,235,110,122,95,232,140,246,251,212,84,134,129,90,192,48,53,159,188,195,200,1,2,230,88,68,147,108,194,34,217,108,117,185,4,209,251,76,177,248,45,115,173,10,126,23,102,183,250,2,166,14,243,116,230,158,30,145,22,161,246,71,29,142,16,189,30,105,164,14,155,75,117,240,54,229,198,118,18,188,173,229,238,246,166,83,179,222,219,137,94,247,186,0,134,13,173,12,232,251,182,190,130,146,148,164,12,205,98,104,228,195,41,178,64,186,3,97,211,74,233,153,224,99,114,225,96,98,10,29,72,88,156,228,3,111,194,176,165,91,45,198,142,152,121,48,252,17,231,162,26,244,227,26,147,217,99,206,162,91,57,137,137,171,212,2,188,42,20,148,45,117,170,132,226,148,127,32,218,236,195,164,89,12,102,58,223,55,122,47,35,108,213,38,55,20,117,20,51,221,131,247,71,197,214,63,194,149,33,139,29,37,150,86,22,250,232,107,131,236,237,45,15,150,94,175,15,14,162,172,162,209,178,237,17,135,143,30,10,67,75,10,181,249,132,221,75,187,1,141,57,19,11,128,249,161,76,185,56,144,111,229,1,11,187,27,183,109,232,166,4,170,189,6,53,35,233,59,99,48,227,127,75,173,85,214,246,25,72,252,44,114,85,210,133,213,29,183,113,239,244,88,85,60,254,161,70,250,143,17,52,131,199,92,61,193,51,61,20,242,33,196,39,44,83,91,152,58,48,13,187,183,165,136,208,208,220,197,177,24,90,27,147,39,60,106,147,143,63,43,239,167,180,64,191,13,94,37,184,99,124,247,95,147,36,37,150,51,0,15,166,152,234,20,150,70,88,217,93,213,193,8,113,112,71,28,247,184,80,100,197,5,197,195,85,145,111,135,236,107,160,220,103,196,87,132,110,255,75,195,17,202,72,28,65,144,128,73,31,12,225,181,58,172,204,39,219,0,185,3,58,121,181,193,193,35,113,128,199,68,100,109,222,117,63,50,233,52,7,224,51,145,127,241,7,7,23,137,70,85,33,120,228,80,46,114,60,229,155,10,15,4,130,98,195,148,79,238,25,128,103,41,194,6,180,226,200,211,24,56,28,200,122,99,229,103,157,253,61,160,180,78,163,164,193,138,68,128,135,127,92,163,132,46,4,108,19,101,161,234,245,121,33,146,129,153,5,250,113,108,252,239,133,152,182,124,33,66,41,171,204,9,140,185,228,199,212,174,242,233,83,210,40,246,104,46,182,79,123,249,161,208,126,59,252,242,229,112,18,43,70,85,67,84,50,115,208,67,93,143,70,31,104,220,52,189,207,150,96,83,225,4,87,221,90,242,143,130,90,52,46,195,240,174,247,181,198,140,241,131,82,183,160,253,186,91,99,149,60,138,85,246,125,140,42,53,169,142,60,36,104,23,137,84,24,162,188,65,156,135,225,63,179,171,145,52,131,100,126,253,162,155,47,240,226,193,216,120,247,45,99,176,194,212,249,255,62,44,223,72,239,213,133,155,212,176,102,186,44,154,79,197,207,111,129,191,235,117,135,29,61,50,147,53,11,101,209,122,175,248,178,205,30,89,71,182,245,49,132,191,169,62,73,13,169,233,165,141,43,132,104,25,176,245,187,242,93,158,29,252,70,46,173,209,99,242,219,160,203,197,22,188,237,193,20,206,25,111,170,123,94,141,44,179,35,39,102,218,186,75,88,127,152,147,203,164,17,208,52,242,112,98,31,52,145,47,140,226,38,210,245,68,132,14,68,94,5,122,134,211,240,133,63,232,97,210,132,255,214,247,167,12,53,77,44,36,87,168,154,177,159,126,53,175,17,63,77,105,62,78,243,207,19,44,23,209,161,131,37,103,121,23,248,179,169,171,30,175,173,113,161,23,8,241,26,106,66,158,82,215,169,90,13,114,184,82,201,66,171,210,200,245,62,180,180,126,194,103,182,9,83,112,219,181,222,35,240,65,202,56,30,56,146,111,51,117,151,60,49,127,64,44,83,255,119,121,110,37,138,193,136,5,229},
  {198,202,231,172,185,176,124,75,39,136,49,216,238,237,89,23,243,198,135,109,57,178,207,201,112,108,150,117,140,111,126,53,188,205,101,152,32,93,169,61,172,46,251,56,57,62,24,13,15,12,187,196,210,106,163,66,141,80,201,240,39,15,187,78,11,66,192,194,202,76,39,208,224,104,227,201,237,77,56,36,70,68,62,190,51,6,231,170,224,229,67,81,112,90,162,219,178,65,225,234,31,144,109,233,175,242,2,238,115,196,21,46,79,6,184,116,163,133,44,202,155,96,127,81,32,21,53,227,171,5,61,126,149,219,108,254,125,25,19,21,86,73,101,70,29,22,35,7,17,120,104,217,72,184,58,121,157,225,179,59,123,34,74,201,45,99,37,223,111,124,181,18,167,198,115,188,171,117,252,101,235,40,107,33,202,251,4,203,73,204,58,136,220,214,56,20,251,68,172,222,145,62,255,197,132,227,126,162,90,160,82,43,240,184,117,76,91,223,174,240,63,255,195,206,221,71,18,120,70,194,73,97,251,202,133,112,101,99,157,149,118,106,100,252,241,123,45,80,105,17,77,49,131,123,86,59,36,131,114,21,173,211,20,244,124,142,50,93,9,227,203,186,230,51,241,64,154,24,75,220,220,120,71,204,198,225,117,162,186,138,180,166,120,63,94,205,222,140,3,214,134,55,180,134,198,199,185,184,229,241,160,157,253,255,58,67,141,174,95,168,216,161,66,238,152,25,70,199,114,181,81,218,166,244,198,2,151,144,57,87,44,213,11,119,238,11,155,61,98,111,253,92,78,158,35,104,238,28,15,22,59,14,109,206,221,106,73,94,6,170,80,189,209,88,248,38,123,213,220,81,191,46,76,8,139,134,84,141,195,199,183,62,106,32,113,219,97,17,210,19,136,95,77,91,141,141,6,2,9,122,79,252,67,157,20,96,178,116,70,47,50,96,40,208,4,227,45,19,123,14,12,34,136,151,153,150,38,63,232,248,15,210,163,246,229,192,191,52,253,252,132,196,194,106,87,252,160,73,170,170,193,52,161,138,152,113,51,78,39,78,27,241,150,75,132,21,37,17,5,53,245,42,227,206,3,185,51,125,222,50,90,47,30,209,154,239,212,55,34,45,25,147,130,154,3,159,190,18,213,247,107,36,10,212,32,229,233,51,166,248,134,145,232,129,105,163,91,86,74,104,122,106,34,114,251,185,140,29,83,156,110,134,195,67,198,214,219,248,146,124,71,248,247,245,112,16,120,121,144,70,53,56,43,191,217,128,176,184,84,213,194,26,253,136,157,215,38,158,38,160,42,213,201,4,20,68,168,63,225,58,154,157,74,105,45,190,29,218,184,18,4,230,189,102,77,155,251,14,93,118,173,84,111,168,6,167,136,64,165,76,220,251,218,228,123,57,122,55,107,242,88,89,106,115,123,216,182,210,22,100,99,32,144,18,111,214,153,217,165,108,77,165,72,107,33,196,103,224,56,75,126,38,238,23,92,143,72,169,240,114,214,222,58,62,30,8,143,109,83,75,143,98,234,98,12,246,64,70,93,239,127,151,101,13,31,33,64,46,4,227,56,68,90,142,122,114,99,227,75,245,151,236,30,117,181,210,25,72,62,245,161,34,113,89,223,214,160,101,227,81,81,239,147,144,62,37,188,180,84,175,215,189,85,174,41,56,190,63,201,134,246,110,213,210,106,149,68,38,93,112,75,94,13,125,192,160,120,28,53,184,7,71,156,237,134,255,64,204,129,247,34,205,45,71,99,75,133,158,21,185,210,139,81,109,129,3,134,37,213,129,82,45,219,211,254,159,168,185,24,194,150,141,96,240,120,117,234,128,106,176,1,115,204,96,8,21,231,56,24,79,238,4,197,71,132,204,91,121,82,229,76,103,225,143,31,96,184,31,93,251,133,34,142,148,130,96,235,83,109,106,98,45,50,202,117,196,7,40,117,188,46,36,28,176,253,37,114,205,58,204,195,0,145,38,6,62,76,117,55,195,1,172,143,34,227,45,78,99,87,16,56,23,221,130,194,34,21,162,59,81,46,55,1,110,82,173,244,32,99,174,157,37,225,36,79,244,2,35,131,214,248,184,11,221,53,235,86,53,108,59,24,160,253,4,173,255,26,177,75,243,80,211,219,69,42,94,212,27,146,94,14,140,116,47,136,218,240,194,232,250,245,45,129,105,157,110,173,203,100,249,118,188,116,247,171,192,76,33,123,153,180,61,145,195,8,164,205,118,221,146,150,246,227,98,11,242,63,101,237,213,170,48,3,95,80,68,117,208,229,3,112,186,93,240,22,182,196,3,181,111,2,168,86,143,85,203,135,219,95,231,7,33,247,200,92,172,37,51,94,101,181,160,162,38,149,229,131,137,254,125,24,83,58,50,204,224,88,41,17,110,227,41,250,230,145,230,55,122,160,78,68,50,23,203,117,239,165,170,180,222,39,37,149,24,191,204,251,29,164,246,109,185,217,182,246,187,115,10,63,237,100,3,211,195,122,243,202,208,152,31,231,28,244,160,222,152,122,154,131,16,152,130,73,179,250,95,124,251,220,112,224,18,218,249,180,195,129,46,236,186,68,8,196,173,39,199,152,239,103,35,40,235,204,65,99,87,43,185,224,217,6,15,31,211,245,28,97,135,213,218,189,102,222,121,76,154,214,78,206,115,105,139,107,245,188,186,115,239,1,169,22,171,209,22,50,56,141,237,40,244,1,165,197,110,17,120,86,178,64,11,65,227,64,209,52,254,169,194,2,132,241,213,151,24,18,7,72,253,125,26,249,140,45,69,60,66,19,82,246,62,23,71,42,120,146,40,255,155,63,175,234,114,162,53,240,151,135,224,160,250,49,154,22,15,106,54,67,125,84,180,114,72,156,143,176,5,149,67,67,66,91,207,161,231,12,66,133,217,199,146,200,114,209,45,97,108,198,232,245,201,181,150,124,121,247,175,61,15,179,239,102,204,37,223,39,93,41,210,135,189,87,147,0,111,105,38,234,249,36,134,191,69,66,90,124,154,9,56,194,37,46,116,72,249,60,98,109,100,4,17,4,112,147,206,54,44,13,137,176,209,138,67,188,82,184,105,255,232,236,104,0,119,39,145,120,84,127,232,125,64,213,153,97,64,28,254,220,3,83,8,36,87,242,126,198,130,153,151,60,87,178,63,53,113,237,120,156,50,65,33,205,221,155,247,121,212,86,6,59,137,67,208,1,217,201,56,104,160,175,162,76,100,118,134,73,148,180,218,159,21,84,3,133,79,29,221,141,88,92,168,33,59,178,95,91,52,172,57,12,30,133,183,64,69,211,58,40,141,110,87,83,102,193,204,147,68,221,77,70,142,211,96,237,209,167,58,152,250,88,30,230,75,240,145,220},
  {140,42,152,227,64,215,206,105,51,116,110,29,1,76,169,28,35,69,63,245,232,58,148,135,38,38,190,4,153,228,38,136,76,169,22,123,149,115,203,53,4,165,148,220,123,141,13,34,90,244,32,21,8,254,136,109,173,65,244,14,17,23,221,190,73,205,11,247,144,69,147,189,38,58,59,152,209,126,37,26,238,228,239,57,57,139,166,150,137,193,143,87,92,21,98,220,121,211,115,187,254,95,239,28,154,108,68,214,36,131,23,171,125,82,149,126,69,154,183,73,93,50,197,138,179,90,252,116,245,38,64,180,110,61,55,6,192,209,72,144,47,167,101,41,200,208,241,27,46,159,63,101,251,175,14,104,0,29,187,24,198,115,184,245,69,225,185,216,10,175,173,146,159,81,176,159,129,161,46,233,74,106,48,31,209,111,27,8,201,136,9,218,151,222,75,126,134,65,250,183,31,228,83,21,223,39,169,247,78,15,240,183,135,217,78,27,105,213,74,167,221,151,160,215,233,194,71,246,9,32,7,120,123,17,14,239,235,68,226,123,90,90,31,254,226,2,60,202,10,70,124,122,113,184,130,107,72,173,229,55,147,156,123,172,234,252,114,82,170,73,244,164,254,255,57,127,156,167,13,207,51,113,65,111,101,242,147,35,8,215,15,101,230,230,165,168,32,28,237,234,37,240,143,86,120,170,152,69,104,0,232,52,128,177,54,65,196,169,144,141,239,41,48,7,167,216,231,112,68,173,81,192,111,176,194,99,64,238,142,162,192,191,113,130,214,85,153,138,113,244,206,118,8,60,245,204,139,181,86,174,215,37,175,47,222,245,197,170,244,219,236,91,180,21,24,40,225,255,157,131,141,55,7,2,29,165,139,64,67,22,195,45,180,87,237,227,240,208,129,245,247,213,161,239,167,10,134,247,76,139,193,233,224,99,123,44,155,102,103,121,64,40,118,43,129,225,199,136,239,13,171,82,246,184,123,51,242,207,221,146,41,81,155,48,123,184,217,226,71,96,30,4,89,33,137,212,66,27,149,192,154,189,143,122,27,106,42,92,187,208,215,170,28,235,215,58,43,13,203,199,132,15,74,111,3,39,167,229,131,192,170,9,46,3,98,124,147,251,133,188,92,220,60,227,173,86,184,11,140,171,74,90,211,150,135,162,152,90,212,241,252,19,236,95,216,50,55,225,105,253,42,87,133,76,54,143,249,115,209,14,97,1,246,173,56,117,183,251,166,78,147,183,94,61,224,104,126,47,40,225,30,155,234,242,210,117,157,69,52,50,53,208,164,171,8,85,151,27,78,100,227,78,176,223,200,56,103,197,30,228,191,209,246,159,203,236,137,190,217,143,119,94,58,80,40,19,4,214,175,14,245,84,211,228,87,133,190,234,228,244,117,221,63,40,214,17,230,242,123,39,171,91,185,119,105,112,184,249,115,139,66,135,105,204,32,94,119,77,249,70,40,132,13,28,109,79,77,147,150,73,153,213,92,7,220,83,243,42,100,196,134,157,135,196,85,205,18,97,40,40,62,41,184,71,124,235,121,7,5,170,193,235,82,57,118,74,141,173,24,218,211,98,241,185,18,47,65,106,213,246,59,76,70,168,253,205,114,235,141,156,211,182,10,212,250,92,94,129,225,4,25,99,45,88,27,160,114,189,100,172,253,62,180,0,119,68,20,5,104,94,76,32,239,60,17,206,254,23,59,212,71,84,206,199,165,33,3,207,89,141,175,129,141,133,193,96,74,60,42,199,97,14,210,39,126,88,215,228,239,150,10,83,207,93,222,72,78,86,178,59,130,12,125,171,70,248,195,42,147,196,70,138,188,26,131,138,49,234,105,217,48,130,174,96,90,149,175,232,164,111,190,114,111,215,11,112,24,76,223,20,52,89,251,88,188,123,89,242,63,92,155,41,196,166,136,117,35,229,77,245,75,169,55,41,84,253,19,100,77,13,92,10,198,19,136,26,11,148,221,126,223,80,195,204,201,127,124,238,212,53,91,169,245,189,0,228,32,97,9,126,8,177,166,123,37,144,2,197,132,170,132,157,240,76,43,13,64,234,143,255,152,154,188,158,203,39,155,115,106,235,209,86,154,172,248,73,35,82,144,100,21,37,65,230,166,107,8,241,2,46,241,12,171,254,169,238,113,223,111,56,127,117,233,86,108,155,140,88,85,144,164,12,241,12,245,215,68,111,239,51,108,46,117,84,91,96,167,73,56,227,17,153,232,232,110,107,223,14,102,184,160,210,224,102,9,202,44,173,41,24,213,70,56,10,222,206,194,255,51,252,156,230,129,29,90,178,99,194,222,103,18,251,155,93,52,2,48,79,130,224,91,161,209,251,18,12,223,103,173,249,64,49,51,73,72,44,37,136,118,45,18,37,214,185,227,10,19,169,123,113,149,81,237,209,171,3,243,5,115,183,168,70,188,89,214,150,176,38,241,250,161,86,11,187,119,103,83,14,186,217,23,217,135,252,77,80,247,212,226,41,97,79,154,57,1,57,63,247,248,2,156,172,82,31,202,255,121,230,31,124,229,95,238,58,97,163,29,70,65,76,35,9,115,234,202,149,116,243,51,174,95,162,240,147,158,61,114,205,193,215,217,226,103,209,131,61,152,92,185,17,232,213,103,237,213,208,249,152,49,11,109,37,169,73,38,176,100,144,238,84,18,248,215,148,137,198,15,252,98,181,51,232,82,133,134,142,215,97,202,204,204,200,229,247,218,193,158,100,12,112,160,65,48,126,225,202,178,241,178,126,139,147,111,68,123,138,106,120,79,132,117,18,156,255,188,149,164,197,217,209,238,16,103,200,164,143,103,148,45,178,163,203,40,168,183,253,73,161,103,118,190,234,67,39,75,180,120,138,59,154,184,29,169,17,34,105,86,235,124,215,12,139,106,122,126,0,24,222,248,185,157,161,254,142,203,98,41,254,117,237,116,166,187,117,173,174,49,44,132,154,14,117,204,2,221,4,117,153,233,228,117,227,56,122,199,179,51,250,253,159,112,2,30,117,31,80,253,189,112,237,146,11,130,211,84,135,149,4,36,54,88,38,45,95,90,50,169,104,184,190,190,255,140,73,98,222,89,51,65,85,100,205,136,91,6,93,11,197,60,214,161,104,226,65,232,225,117,73,53,111,47,68,17,162,147,11,5,192,199,202,18,2,143,48,58,89,65,10,83,89,128,64,25,43,44,62,193,117,23,203,201,144,219,195,213,86,103,250,137,173,71,165,114,125,215,186,223,193,61,91,169,229,123,136,36,79,24,191,37,40,25,28,195,112,164,181,182,3,210,0,127,54,7,222,150,51,34,131,17,210,143,91,181,237,144,191,51,143,227,147,166,28,62,232,69,250,29,86,235,251,237,211,242,156,78},
} ;

static void test_decode_953x6343_impl(long long impl)
{
  unsigned char *x = test_decode_953x6343_x;
  unsigned char *s = test_decode_953x6343_s;
  unsigned char *x2 = test_decode_953x6343_x2;
  unsigned char *s2 = test_decode_953x6343_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_953x6343_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_953x6343(impl);
    printf("decode_953x6343 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_953x6343_implementation(impl),ntruprime_dispatch_decode_953x6343_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_953x6343;
    printf("decode_953x6343 selected implementation %s compiler %s\n",ntruprime_decode_953x6343_implementation(),ntruprime_decode_953x6343_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_953x6343_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_953x6343_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_953x6343_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_953x6343_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_953x6343_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_953x6343_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_953x6343(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"953x6343")) return;
  storage_decode_953x6343_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_953x6343_x = aligned(storage_decode_953x6343_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_953x6343_s = callocplus(crypto_decode_STRBYTES);
  test_decode_953x6343_s = aligned(storage_decode_953x6343_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_953x6343_x2 = callocplus(maxalloc);
  test_decode_953x6343_x2 = aligned(storage_decode_953x6343_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_953x6343_s2 = callocplus(maxalloc);
  test_decode_953x6343_s2 = aligned(storage_decode_953x6343_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_953x6343 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_953x6343();++impl)
      forked(test_decode_953x6343_impl,impl);
    ++test_decode_953x6343_x;
    ++test_decode_953x6343_s;
    ++test_decode_953x6343_x2;
    ++test_decode_953x6343_s2;
  }
  free(storage_decode_953x6343_s2);
  free(storage_decode_953x6343_x2);
  free(storage_decode_953x6343_s);
  free(storage_decode_953x6343_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

