/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.CaliperRc;
import com.google.caliper.util.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class CaliperConfigLoader {
    public static CaliperConfig loadOrCreate(File rcFile) {
        ImmutableMap<String, String> overrides;
        ImmutableMap<String, String> defaults;
        try {
            defaults = Util.loadProperties(Util.resourceSupplier(CaliperRc.class, "global.caliperrc"));
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (rcFile.exists()) {
            try {
                ImmutableMap<String, String> overrides2 = Util.loadProperties((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)rcFile));
                return new CaliperConfig(CaliperConfigLoader.mergeProperties(overrides2, defaults));
            }
            catch (IOException keepGoing) {
                // empty catch block
            }
        }
        InputSupplier<InputStream> supplier = Util.resourceSupplier(CaliperRc.class, "default.caliperrc");
        CaliperConfigLoader.tryCopyIfNeeded(supplier, rcFile);
        try {
            overrides = Util.loadProperties(supplier);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new CaliperConfig(CaliperConfigLoader.mergeProperties(overrides, defaults));
    }

    private static ImmutableMap<String, String> mergeProperties(Map<String, String> overrides, Map<String, String> defaults) {
        HashMap map = Maps.newHashMap(defaults);
        map.putAll(overrides);
        Iterables.removeIf(map.values(), (Predicate)Predicates.equalTo((Object)""));
        return ImmutableMap.copyOf((Map)map);
    }

    private static void tryCopyIfNeeded(InputSupplier<? extends InputStream> supplier, File rcFile) {
        if (!rcFile.exists()) {
            try {
                Files.copy(supplier, (File)rcFile);
            }
            catch (IOException e) {
                rcFile.delete();
            }
        }
    }
}

