/* $Id$ 
 *
 * Proc: Generate a process with initial subroutine.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PROC_HPP_INCLUDED
#define __PROC_HPP_INCLUDED

namespace intermediate {

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Reference.hpp"

//! create a process with given subprogram.
/** Proc can be used to create a process. Basically it defines a Call which gets
 *  delayed and executed as own process.
 *  Proc must be embedded with begintrans/setparam/endtrans opcodes.
 *  The following endtrans opcode must not erase the stack (as this would
 *  otherwise corrupt the process's stack).
 *
 *  Read Operands: target (pointer referencing the target code container)
 *  Write Operands: None in current process context.
 *
 *  Operation:
 *  	Register target as a ready process in the scheduler, giving
 *  	the current transfer stack frame (as created by begintrans)
 *  	as parameter.
 */
class Proc : public OpCode {
public:
	//! c'tor
	/** @param target subprogram that defines the process
	 */
	Proc(Reference *destination) : dst(destination) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! target (name) of the subprogram that should defines the process.
	Reference *dst;
};

}; /* namespace intermediate */

#endif /* __PROC_HPP_INCLUDED */
