package dns

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.14.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// RecordType enumerates the values for record type.
type RecordType string

const (
	// A specifies the a state for record type.
	A RecordType = "A"
	// AAAA specifies the aaaa state for record type.
	AAAA RecordType = "AAAA"
	// CNAME specifies the cname state for record type.
	CNAME RecordType = "CNAME"
	// MX specifies the mx state for record type.
	MX RecordType = "MX"
	// NS specifies the ns state for record type.
	NS RecordType = "NS"
	// PTR specifies the ptr state for record type.
	PTR RecordType = "PTR"
	// SOA specifies the soa state for record type.
	SOA RecordType = "SOA"
	// SRV specifies the srv state for record type.
	SRV RecordType = "SRV"
	// TXT specifies the txt state for record type.
	TXT RecordType = "TXT"
)

// AaaaRecord is an AAAA record.
type AaaaRecord struct {
	Ipv6Address *string `json:"ipv6Address,omitempty"`
}

// ARecord is an A record.
type ARecord struct {
	Ipv4Address *string `json:"ipv4Address,omitempty"`
}

// CnameRecord is a CNAME record.
type CnameRecord struct {
	Cname *string `json:"cname,omitempty"`
}

// MxRecord is an MX record.
type MxRecord struct {
	Preference *int32  `json:"preference,omitempty"`
	Exchange   *string `json:"exchange,omitempty"`
}

// NsRecord is an NS record.
type NsRecord struct {
	Nsdname *string `json:"nsdname,omitempty"`
}

// PtrRecord is a PTR record.
type PtrRecord struct {
	Ptrdname *string `json:"ptrdname,omitempty"`
}

// RecordSet is describes a DNS RecordSet (a set of DNS records with the same
// name and type).
type RecordSet struct {
	autorest.Response `json:"-"`
	ID                *string              `json:"id,omitempty"`
	Name              *string              `json:"name,omitempty"`
	Type              *string              `json:"type,omitempty"`
	Location          *string              `json:"location,omitempty"`
	Tags              *map[string]*string  `json:"tags,omitempty"`
	Etag              *string              `json:"etag,omitempty"`
	Properties        *RecordSetProperties `json:"properties,omitempty"`
}

// RecordSetListResult is the response to a RecordSet List operation.
type RecordSetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecordSet `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// RecordSetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecordSetListResult) RecordSetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecordSetProperties is represents the properties of the records in the
// RecordSet.
type RecordSetProperties struct {
	TTL         *int64        `json:"TTL,omitempty"`
	ARecords    *[]ARecord    `json:"ARecords,omitempty"`
	AAAARecords *[]AaaaRecord `json:"AAAARecords,omitempty"`
	MXRecords   *[]MxRecord   `json:"MXRecords,omitempty"`
	NSRecords   *[]NsRecord   `json:"NSRecords,omitempty"`
	PTRRecords  *[]PtrRecord  `json:"PTRRecords,omitempty"`
	SRVRecords  *[]SrvRecord  `json:"SRVRecords,omitempty"`
	TXTRecords  *[]TxtRecord  `json:"TXTRecords,omitempty"`
	CNAMERecord *CnameRecord  `json:"CNAMERecord,omitempty"`
	SOARecord   *SoaRecord    `json:"SOARecord,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SoaRecord is an SOA record.
type SoaRecord struct {
	Host         *string `json:"host,omitempty"`
	Email        *string `json:"email,omitempty"`
	SerialNumber *int64  `json:"serialNumber,omitempty"`
	RefreshTime  *int64  `json:"refreshTime,omitempty"`
	RetryTime    *int64  `json:"retryTime,omitempty"`
	ExpireTime   *int64  `json:"expireTime,omitempty"`
	MinimumTTL   *int64  `json:"minimumTTL,omitempty"`
}

// SrvRecord is an SRV record.
type SrvRecord struct {
	Priority *int32  `json:"priority,omitempty"`
	Weight   *int32  `json:"weight,omitempty"`
	Port     *int32  `json:"port,omitempty"`
	Target   *string `json:"target,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// TxtRecord is a TXT record.
type TxtRecord struct {
	Value *[]string `json:"value,omitempty"`
}

// Zone is describes a DNS zone.
type Zone struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	Properties        *ZoneProperties     `json:"properties,omitempty"`
}

// ZoneListResult is the response to a Zone List or ListAll operation.
type ZoneListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Zone `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ZoneListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ZoneListResult) ZoneListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ZoneProperties is represents the properties of the zone.
type ZoneProperties struct {
	MaxNumberOfRecordSets *int64 `json:"maxNumberOfRecordSets,omitempty"`
	NumberOfRecordSets    *int64 `json:"numberOfRecordSets,omitempty"`
}
