# 2020-08-17 Triage Log

See the [README](README.md) for details on how this log was gathered.

This week was quite noisy, with many small regressions and improvements.
Overall, instruction counts have increased somewhat, while max RSS remains the
same. There were several updates to core data structures (`HashMap`,
`IndexMap`), which contributed to some of the noise. 

Triage done by @ecstaticmorse.
Revision range: [8b84156c6ee2b4e707dc32f5a516e3143ab924d3..67e7b9b8cf776222825dbbd4cb1e39b7765ef27c](https://perf.rust-lang.org/?start=8b84156c6ee2b4e707dc32f5a516e3143ab924d3&end=67e7b9b8cf776222825dbbd4cb1e39b7765ef27c&absolute=false&stat=instructions%3Au)

4 Regressions, 3 Improvements, 4 Mixed, 0 of them in rollups.

#### 4 Regressions

[#73851](https://github.com/rust-lang/rust/pull/73851) Remove most specialization use in serialization
* [Very small regressions across the board](https://perf.rust-lang.org/compare.html?start=95879ad96104afa584e7aec7806cec1d0bd84116&end=668a34e0f438d4a950b9440239656d6755ad963c&stat=instructions:u)

[#75048](https://github.com/rust-lang/rust/pull/75048) Prevent `__rust_begin_short_backtrace` frames from being tail-call optimised away
* [Regressions in several benchmarks](https://perf.rust-lang.org/compare.html?start=c2d1b0d9800d922b0451921d2ce17e6ae665d5b4&end=f3a9de9b08659e20ce7c282ed77bc43ddd149107&stat=instructions:u)
* Mostly for crates with very little codegen

[#75306](https://github.com/rust-lang/rust/pull/75134) Hash parent ExpnData
* [Very small regressions across the board](https://perf.rust-lang.org/compare.html?start=8bc801b05019cd3e0ef19e6c4c028d55baa645d2&end=543f03d24118d3af784aa98c507c00e30c796a0e&stat=instructions:u)
* Necessary for correctness

[#73656](https://github.com/rust-lang/rust/pull/73656) move Deaggregate pass to post\_borrowck\_cleanup 
* [Very small regressions across the board](https://perf.rust-lang.org/compare.html?start=4b9ac5161781ca6a376daab3d3b2f2623d8f3789&end=cbe7c5ce705896d4e22bf6096590bc1f17993b78&stat=instructions:u)

#### 3 Improvements

[#74512](https://github.com/rust-lang/rust/pull/74512) Put panic code path from `copy_from_slice` into cold function
* [Small improvements across the board, albeit mostly for incremental builds](https://perf.rust-lang.org/compare.html?start=576d27c5a6c80cd39ef57d7398831d8e177573cc&end=847ba835ce411d47364a93ddf0b4a5c0f27928a9&stat=instructions:u)

[#74877](https://github.com/rust-lang/rust/pull/74877) Implement the `min_const_generics` feature gate
* [A small improvement on `wf-projection-stress`](https://perf.rust-lang.org/compare.html?start=f3a9de9b08659e20ce7c282ed77bc43ddd149107&end=f9c2177ddc605f9c75ca1a3e6ddb33835b8a178d&stat=instructions:u)

[#75121](https://github.com/rust-lang/rust/pull/75121)  Avoid `unwrap_or_else` in str indexing
* [A small improvement on `encoding-opt`](https://perf.rust-lang.org/compare.html?start=63e34422bbaf4ae4ed5ae7309183185aa2aa13a4&end=98922795f68e86b0bca5aea8cfc66499d58eba1a&stat=instructions:u)



#### 4 Mixed

[#70052](https://github.com/rust-lang/rust/pull/70052)  Update hashbrown to 0.8.1
* [Mixed results across the board](https://perf.rust-lang.org/compare.html?start=d4c940f0821754a98491b2d23fbb5323c14a2bf5&end=8b26609481c956a666f9189738f1ba611078e1ab&stat=instructions:u)

[#75278](https://github.com/rust-lang/rust/pull/75278)  Upgrade indexmap and use it more
* [Very small regressions for most builds, notably docs](https://perf.rust-lang.org/compare.html?start=39e593ab14c53fda63c3f2756716c5ad3cbb6465&end=18f3be7704a4ec7976fcd1272c728974243d29bd&stat=instructions:u)
* Offset by larger wins on a few benchmarks: `encoding`, `keccak`, `inflate`.
* Author cites improved CPU cycle counts.

[#75306](https://github.com/rust-lang/rust/pull/75306) Update hashbrown to 0.8.2 
* [Mixed results across the board](https://perf.rust-lang.org/compare.html?start=dcf107728c4e545b9fee6b0e6a929837429275cf&end=aced185592b6f99a21190965a7fecfcd72d954dc&stat=instructions:u)
* Mostly improvements, but `incr-patched: println` has taken a rather large hit.

[#75382](https://github.com/rust-lang/rust/pull/75382) First iteration of simplify match branches
* [Very small improvements across the board](https://perf.rust-lang.org/compare.html?start=b6396b75e782954acb085447fb836c4e0ff5281d&end=5e3f1b148db5bfa27fee52464ae1f5d34c49d77b&stat=instructions:u)
* However, a few moderate regressions on synthetic benchmarks

Nags requiring follow up

- [#73656](https://github.com/rust-lang/rust/pull/73656)
- [#73851](https://github.com/rust-lang/rust/pull/73851)
- [#75048](https://github.com/rust-lang/rust/pull/75048)
