## RabbitMQ 3.7.15

RabbitMQ `3.7.15` is a maintenance release. It focuses on bug fixes and minor usability improvements.
This release [**requires Erlang/OTP 20.3**](https://www.rabbitmq.com/which-erlang.html) or later.
It is also the first release to support Erlang 22.

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `20.3.x` and `21.x`.

### Compatibility Notes

#### Minimum Required Erlang Version

This release requires Erlang/OTP 20.3 or later.

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * `rabbitmq.conf` validation errors on startup unintentionally lacked a lot of relevant details.

   Contributed by Grigory Starinkin.

   GitHub issue: [rabbitmq/rabbitmq-server#1985](https://github.com/rabbitmq/rabbitmq-server/issues/1985)

 * Message store compaction could enter a race condition with queue operations.

   GitHub issue: [rabbitmq/rabbitmq-server#2000](https://github.com/rabbitmq/rabbitmq-server/issues/2000)

 * Internal schema data store consistency checks used an on-disk location which could be unintentionally
   preserved between deployments and make subsequent deployments fail. Now an entirely in-memory set of tables
   is used for schema consistency checks.

   GitHub issue: [rabbitmq/rabbitmq-server#1960](https://github.com/rabbitmq/rabbitmq-server/pull/1960)

 * When [publisher confirms](https://www.rabbitmq.com/confirms.html) had to send both positive and negative acknowledgements around the same time,
   it could be done in a way that would violate expectations of most client libraries.

   GitHub issue: [rabbitmq/rabbitmq-server#1719](https://github.com/rabbitmq/rabbitmq-server/pull/1719)

 * Policy validation could allow invalid values in certain cases.

   GitHub issue: [rabbitmq/rabbitmq-server#1999](https://github.com/rabbitmq/rabbitmq-server/pull/1999)

 * `amq.rabbitmq.log` exchage was lazily initialised and could be temporarily unavailable after node start.

   GitHub issue: [rabbitmq/rabbitmq-server#1973](https://github.com/rabbitmq/rabbitmq-server/issues/1973)

 * Clearing a policy with `overflow` behaviour or removing the key from it did not
   roll back the overflow behaviour to `drop-head` (the default).

   GitHub issue: [rabbitmq/rabbitmq-server#1980](https://github.com/rabbitmq/rabbitmq-server/issues/1980)

 * Missing `getconf` command (used to fetch platform's memory page size) is now handled more gracefully
   with a default value.

   GitHub issue: [rabbitmq/rabbitmq-common#318](https://github.com/rabbitmq/rabbitmq-common/issues/318)


#### Enhancements

 * Initial Erlang 22 compatibility.

   GitHub issues: [rabbitmq/rabbitmq-common#315](https://github.com/rabbitmq/rabbitmq-common/issues/315),
                  [rabbitmq/rabbitmq-common#313](https://github.com/rabbitmq/rabbitmq-common/pull/313),
                  [rabbitmq/rabbitmq-common#323](https://github.com/rabbitmq/rabbitmq-common/pull/323)

 * Connection tracking is now more efficient, reducing node load
   and internal event backlog in case of [high connection churn](https://www.rabbitmq.com/networking.html#dealing-with-high-connection-churn).

   GitHub issues: [rabbitmq/rabbitmq-server#1971](https://github.com/rabbitmq/rabbitmq-server/pull/1971),
                  [rabbitmq/rabbitmq-server#1975](https://github.com/rabbitmq/rabbitmq-server/pull/1975)


### Management Plugin

#### Bug Fixes

 * Enabled kernel sendfile for HTTP API documentation pages could lead to leaked file descriptors
   when those pages are accessed repeatedly (e.g. a tab is always open for weeks and weeks).
   The plugin now disables sendfile for those static files by default. It can be manually enabled
   via configuration as needed.

   GitHub issue: [rabbitmq/rabbitmq-management#698](https://github.com/rabbitmq/rabbitmq-management/pull/698)

 * Listing permissions could result in a 500 response.

   GitHub issue: [rabbitmq/rabbitmq-management#688](https://github.com/rabbitmq/rabbitmq-management/pull/688)

 * When CORS headers were enabled, binding endpoints were inaccessible due to an exception.

   GitHub issue: [rabbitmq/rabbitmq-management#687](https://github.com/rabbitmq/rabbitmq-management/pull/687)

 * An option to display message rates for the last 8 and 24 hours was hidden in the UI even when data
   for those time intervals was available.

   GitHub issue: [rabbitmq/rabbitmq-management#693](https://github.com/rabbitmq/rabbitmq-management/pull/693)

 * Information unit suffix incorrectly suggested that values were powers of 10 (gigabyte) instead of
   power of 2 (gibibyte).

   GitHub issue: [rabbitmq/rabbitmq-management#694](https://github.com/rabbitmq/rabbitmq-management/pull/694)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Default host specified in `amqp1_0.default_vhost` (`rabbitmq_amqp1_0.default_vhost` in classic config format)
   now takes precedence over `default_vhost` (`rabbit.default_vhost`) in the core broker.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0#86](https://github.com/rabbitmq/rabbitmq-amqp1.0/pull/86)


### Shovel Plugin

#### Bug Fixes

 * Connections to source and destination nodes are now correctly closed if topology operations
   fail on either end (e.g. due to insufficient permissions).

   Contributed by Grigory Starinkin.

   GitHub issue: [rabbitmq/rabbitmq-shovel#54](https://github.com/rabbitmq/rabbitmq-shovel/pull/54)

 * Improved handling of cases where AMQP 1.0 endpoint connection was refused access to a virtual host.

   GitHub issue: [rabbitmq/rabbitmq-shovel#57](https://github.com/rabbitmq/rabbitmq-shovel/pull/57)

#### Enhancements

 * The plugin now provides a new CLI command and HTTP API endpoint for restarting
   a dynamic Shovel.

   GitHub issue: [rabbitmq/rabbitmq-shovel#48](https://github.com/rabbitmq/rabbitmq-shovel/issues/48)


### Federation Plugin

#### Enhancements

 * Queue federation now uses a more informative consumer tag value.

   GitHub issue: [rabbitmq/rabbitmq-federation#66](https://github.com/rabbitmq/rabbitmq-federation/issues/66)


## CLI Tools

### Bug Fixes

 * Streamling `list_*` commands could hang when encountering an error from one of the cluster nodes.

   GitHub issue: [rabbitmq/rabbitmq-cli#336](https://github.com/rabbitmq/rabbitmq-cli/issues/336)

 * `rabbitmqctl delete_queue -u` failed argument validation due to a typo.

   GitHub issue: [rabbitmq/rabbitmq-cli#339](https://github.com/rabbitmq/rabbitmq-cli/issues/339)

 * `rabbitmq-diagnostics cipher_suites` now provides a way to display all available (not just enabled)
   cipher suites.

   GitHub issue: [rabbitmq/rabbitmq-cli#342](https://github.com/rabbitmq/rabbitmq-cli/issues/342)

### Enhancements

 * When an unsupported node name is used, CLI tools will now produce more specific error messages.

   GitHub issue: [rabbitmq/rabbitmq-cli#345](https://github.com/rabbitmq/rabbitmq-cli/issues/345)

 * `rabbitmq-diagnostics erlang_version` now supports `--offline`.

   GitHub issue: [rabbitmq/rabbitmq-cli#315](https://github.com/rabbitmq/rabbitmq-cli/issues/315)


### Web STOMP Plugin

#### Enhancements

 * Default STOMP plugin log is now used for `CONNECT` frames without credentials.

   Contributed by Nick Goossens.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#110](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/110)


### Erlang AMQP 0-9-1 Client

#### Bug Fixes

 * Direct connections (via Erlang distribution) from outside of a RabbitMQ should no longer fail due to
   a dependency on a module that was previously a part of core RabbitMQ broker.

   GitHub issue: [rabbitmq/rabbitmq-erlang-client#91](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/91)


### Auth Backend Cache Plugin

#### Bug Fixes

 * Virtual host endpoint requests were not cached.

   GitHub issues: [rabbitmq/rabbitmq-auth-backend-cache#20](https://github.com/rabbitmq/rabbitmq-auth-backend-cache/issues/20),
                  [rabbitmq/rabbitmq-auth-backend-cache#24](https://github.com/rabbitmq/rabbitmq-auth-backend-cache/issues/24)


### Top Plugin

#### Bug Fixes

 * Calculation worker process could fail due to an exception.

   GitHub issue: [rabbitmq/rabbitmq-top#34](https://github.com/rabbitmq/rabbitmq-top/issues/34)


### JMS Topic Exchange Plugin

#### Bug Fixes

 * `LIKE` operator could be incorrectly evaluated.

   GitHub issue: [rabbitmq/rabbitmq-jms-topic-exchange#18](https://github.com/rabbitmq/rabbitmq-jms-topic-exchange/issues/18)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.15.tar.xz`.
