// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/instance.proto

package admin // import "google.golang.org/genproto/googleapis/bigtable/admin/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible states of an instance.
type Instance_State int32

const (
	// The state of the instance could not be determined.
	Instance_STATE_NOT_KNOWN Instance_State = 0
	// The instance has been successfully created and can serve requests
	// to its tables.
	Instance_READY Instance_State = 1
	// The instance is currently being created, and may be destroyed
	// if the creation process encounters an error.
	Instance_CREATING Instance_State = 2
)

var Instance_State_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "READY",
	2: "CREATING",
}
var Instance_State_value = map[string]int32{
	"STATE_NOT_KNOWN": 0,
	"READY":           1,
	"CREATING":        2,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{0, 0}
}

// The type of the instance.
type Instance_Type int32

const (
	// The type of the instance is unspecified. If set when creating an
	// instance, a `PRODUCTION` instance will be created. If set when updating
	// an instance, the type will be left unchanged.
	Instance_TYPE_UNSPECIFIED Instance_Type = 0
	// An instance meant for production use. `serve_nodes` must be set
	// on the cluster.
	Instance_PRODUCTION Instance_Type = 1
	// The instance is meant for development and testing purposes only; it has
	// no performance or uptime guarantees and is not covered by SLA.
	// After a development instance is created, it can be upgraded by
	// updating the instance to type `PRODUCTION`. An instance created
	// as a production instance cannot be changed to a development instance.
	// When creating a development instance, `serve_nodes` on the cluster must
	// not be set.
	Instance_DEVELOPMENT Instance_Type = 2
)

var Instance_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "PRODUCTION",
	2: "DEVELOPMENT",
}
var Instance_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"PRODUCTION":       1,
	"DEVELOPMENT":      2,
}

func (x Instance_Type) String() string {
	return proto.EnumName(Instance_Type_name, int32(x))
}
func (Instance_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{0, 1}
}

// Possible states of a cluster.
type Cluster_State int32

const (
	// The state of the cluster could not be determined.
	Cluster_STATE_NOT_KNOWN Cluster_State = 0
	// The cluster has been successfully created and is ready to serve requests.
	Cluster_READY Cluster_State = 1
	// The cluster is currently being created, and may be destroyed
	// if the creation process encounters an error.
	// A cluster may not be able to serve requests while being created.
	Cluster_CREATING Cluster_State = 2
	// The cluster is currently being resized, and may revert to its previous
	// node count if the process encounters an error.
	// A cluster is still capable of serving requests while being resized,
	// but may exhibit performance as if its number of allocated nodes is
	// between the starting and requested states.
	Cluster_RESIZING Cluster_State = 3
	// The cluster has no backing nodes. The data (tables) still
	// exist, but no operations can be performed on the cluster.
	Cluster_DISABLED Cluster_State = 4
)

var Cluster_State_name = map[int32]string{
	0: "STATE_NOT_KNOWN",
	1: "READY",
	2: "CREATING",
	3: "RESIZING",
	4: "DISABLED",
}
var Cluster_State_value = map[string]int32{
	"STATE_NOT_KNOWN": 0,
	"READY":           1,
	"CREATING":        2,
	"RESIZING":        3,
	"DISABLED":        4,
}

func (x Cluster_State) String() string {
	return proto.EnumName(Cluster_State_name, int32(x))
}
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{1, 0}
}

// A collection of Bigtable [Tables][google.bigtable.admin.v2.Table] and
// the resources that serve them.
// All tables in an instance are served from a single
// [Cluster][google.bigtable.admin.v2.Cluster].
type Instance struct {
	// (`OutputOnly`)
	// The unique name of the instance. Values are of the form
	// `projects/<project>/instances/[a-z][a-z0-9\\-]+[a-z0-9]`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The descriptive name for this instance as it appears in UIs.
	// Can be changed at any time, but should be kept globally unique
	// to avoid confusion.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// (`OutputOnly`)
	// The current state of the instance.
	State Instance_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.bigtable.admin.v2.Instance_State" json:"state,omitempty"`
	// The type of the instance. Defaults to `PRODUCTION`.
	Type Instance_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.bigtable.admin.v2.Instance_Type" json:"type,omitempty"`
	// Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. They can be used to filter resources and aggregate
	// metrics.
	//
	// * Label keys must be between 1 and 63 characters long and must conform to
	//   the regular expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`.
	// * Label values must be between 0 and 63 characters long and must conform to
	//   the regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`.
	// * No more than 64 labels can be associated with a given resource.
	// * Keys and values must both be under 128 bytes.
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{0}
}
func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (dst *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(dst, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_NOT_KNOWN
}

func (m *Instance) GetType() Instance_Type {
	if m != nil {
		return m.Type
	}
	return Instance_TYPE_UNSPECIFIED
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A resizable group of nodes in a particular cloud location, capable
// of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
// [Instance][google.bigtable.admin.v2.Instance].
type Cluster struct {
	// (`OutputOnly`)
	// The unique name of the cluster. Values are of the form
	// `projects/<project>/instances/<instance>/clusters/[a-z][-a-z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (`CreationOnly`)
	// The location where this cluster's nodes and storage reside. For best
	// performance, clients should be located as close as possible to this
	// cluster. Currently only zones are supported, so values should be of the
	// form `projects/<project>/locations/<zone>`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// (`OutputOnly`)
	// The current state of the cluster.
	State Cluster_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.bigtable.admin.v2.Cluster_State" json:"state,omitempty"`
	// The number of nodes allocated to this cluster. More nodes enable higher
	// throughput and more consistent performance.
	ServeNodes int32 `protobuf:"varint,4,opt,name=serve_nodes,json=serveNodes,proto3" json:"serve_nodes,omitempty"`
	// (`CreationOnly`)
	// The type of storage used by this cluster to serve its
	// parent instance's tables, unless explicitly overridden.
	DefaultStorageType   StorageType `protobuf:"varint,5,opt,name=default_storage_type,json=defaultStorageType,proto3,enum=google.bigtable.admin.v2.StorageType" json:"default_storage_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *Cluster) Reset()         { *m = Cluster{} }
func (m *Cluster) String() string { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()    {}
func (*Cluster) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{1}
}
func (m *Cluster) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Cluster.Unmarshal(m, b)
}
func (m *Cluster) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Cluster.Marshal(b, m, deterministic)
}
func (dst *Cluster) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Cluster.Merge(dst, src)
}
func (m *Cluster) XXX_Size() int {
	return xxx_messageInfo_Cluster.Size(m)
}
func (m *Cluster) XXX_DiscardUnknown() {
	xxx_messageInfo_Cluster.DiscardUnknown(m)
}

var xxx_messageInfo_Cluster proto.InternalMessageInfo

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Cluster) GetState() Cluster_State {
	if m != nil {
		return m.State
	}
	return Cluster_STATE_NOT_KNOWN
}

func (m *Cluster) GetServeNodes() int32 {
	if m != nil {
		return m.ServeNodes
	}
	return 0
}

func (m *Cluster) GetDefaultStorageType() StorageType {
	if m != nil {
		return m.DefaultStorageType
	}
	return StorageType_STORAGE_TYPE_UNSPECIFIED
}

// A configuration object describing how Cloud Bigtable should treat traffic
// from a particular end user application.
type AppProfile struct {
	// (`OutputOnly`)
	// The unique name of the app profile. Values are of the form
	// `projects/<project>/instances/<instance>/appProfiles/[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Strongly validated etag for optimistic concurrency control. Preserve the
	// value returned from `GetAppProfile` when calling `UpdateAppProfile` to
	// fail the request if there has been a modification in the mean time. The
	// `update_mask` of the request need not include `etag` for this protection
	// to apply.
	// See [Wikipedia](https://en.wikipedia.org/wiki/HTTP_ETag) and
	// [RFC 7232](https://tools.ietf.org/html/rfc7232#section-2.3) for more
	// details.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional long form description of the use case for this AppProfile.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The routing policy for all read/write requests which use this app profile.
	// A value must be explicitly set.
	//
	// Types that are valid to be assigned to RoutingPolicy:
	//	*AppProfile_MultiClusterRoutingUseAny_
	//	*AppProfile_SingleClusterRouting_
	RoutingPolicy        isAppProfile_RoutingPolicy `protobuf_oneof:"routing_policy"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AppProfile) Reset()         { *m = AppProfile{} }
func (m *AppProfile) String() string { return proto.CompactTextString(m) }
func (*AppProfile) ProtoMessage()    {}
func (*AppProfile) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{2}
}
func (m *AppProfile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppProfile.Unmarshal(m, b)
}
func (m *AppProfile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppProfile.Marshal(b, m, deterministic)
}
func (dst *AppProfile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppProfile.Merge(dst, src)
}
func (m *AppProfile) XXX_Size() int {
	return xxx_messageInfo_AppProfile.Size(m)
}
func (m *AppProfile) XXX_DiscardUnknown() {
	xxx_messageInfo_AppProfile.DiscardUnknown(m)
}

var xxx_messageInfo_AppProfile proto.InternalMessageInfo

func (m *AppProfile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AppProfile) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *AppProfile) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type isAppProfile_RoutingPolicy interface {
	isAppProfile_RoutingPolicy()
}

type AppProfile_MultiClusterRoutingUseAny_ struct {
	MultiClusterRoutingUseAny *AppProfile_MultiClusterRoutingUseAny `protobuf:"bytes,5,opt,name=multi_cluster_routing_use_any,json=multiClusterRoutingUseAny,proto3,oneof"`
}

type AppProfile_SingleClusterRouting_ struct {
	SingleClusterRouting *AppProfile_SingleClusterRouting `protobuf:"bytes,6,opt,name=single_cluster_routing,json=singleClusterRouting,proto3,oneof"`
}

func (*AppProfile_MultiClusterRoutingUseAny_) isAppProfile_RoutingPolicy() {}

func (*AppProfile_SingleClusterRouting_) isAppProfile_RoutingPolicy() {}

func (m *AppProfile) GetRoutingPolicy() isAppProfile_RoutingPolicy {
	if m != nil {
		return m.RoutingPolicy
	}
	return nil
}

func (m *AppProfile) GetMultiClusterRoutingUseAny() *AppProfile_MultiClusterRoutingUseAny {
	if x, ok := m.GetRoutingPolicy().(*AppProfile_MultiClusterRoutingUseAny_); ok {
		return x.MultiClusterRoutingUseAny
	}
	return nil
}

func (m *AppProfile) GetSingleClusterRouting() *AppProfile_SingleClusterRouting {
	if x, ok := m.GetRoutingPolicy().(*AppProfile_SingleClusterRouting_); ok {
		return x.SingleClusterRouting
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AppProfile) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AppProfile_OneofMarshaler, _AppProfile_OneofUnmarshaler, _AppProfile_OneofSizer, []interface{}{
		(*AppProfile_MultiClusterRoutingUseAny_)(nil),
		(*AppProfile_SingleClusterRouting_)(nil),
	}
}

func _AppProfile_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AppProfile)
	// routing_policy
	switch x := m.RoutingPolicy.(type) {
	case *AppProfile_MultiClusterRoutingUseAny_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MultiClusterRoutingUseAny); err != nil {
			return err
		}
	case *AppProfile_SingleClusterRouting_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SingleClusterRouting); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AppProfile.RoutingPolicy has unexpected type %T", x)
	}
	return nil
}

func _AppProfile_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AppProfile)
	switch tag {
	case 5: // routing_policy.multi_cluster_routing_use_any
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AppProfile_MultiClusterRoutingUseAny)
		err := b.DecodeMessage(msg)
		m.RoutingPolicy = &AppProfile_MultiClusterRoutingUseAny_{msg}
		return true, err
	case 6: // routing_policy.single_cluster_routing
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AppProfile_SingleClusterRouting)
		err := b.DecodeMessage(msg)
		m.RoutingPolicy = &AppProfile_SingleClusterRouting_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AppProfile_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AppProfile)
	// routing_policy
	switch x := m.RoutingPolicy.(type) {
	case *AppProfile_MultiClusterRoutingUseAny_:
		s := proto.Size(x.MultiClusterRoutingUseAny)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AppProfile_SingleClusterRouting_:
		s := proto.Size(x.SingleClusterRouting)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Read/write requests may be routed to any cluster in the instance, and will
// fail over to another cluster in the event of transient errors or delays.
// Choosing this option sacrifices read-your-writes consistency to improve
// availability.
type AppProfile_MultiClusterRoutingUseAny struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppProfile_MultiClusterRoutingUseAny) Reset()         { *m = AppProfile_MultiClusterRoutingUseAny{} }
func (m *AppProfile_MultiClusterRoutingUseAny) String() string { return proto.CompactTextString(m) }
func (*AppProfile_MultiClusterRoutingUseAny) ProtoMessage()    {}
func (*AppProfile_MultiClusterRoutingUseAny) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{2, 0}
}
func (m *AppProfile_MultiClusterRoutingUseAny) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny.Unmarshal(m, b)
}
func (m *AppProfile_MultiClusterRoutingUseAny) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny.Marshal(b, m, deterministic)
}
func (dst *AppProfile_MultiClusterRoutingUseAny) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny.Merge(dst, src)
}
func (m *AppProfile_MultiClusterRoutingUseAny) XXX_Size() int {
	return xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny.Size(m)
}
func (m *AppProfile_MultiClusterRoutingUseAny) XXX_DiscardUnknown() {
	xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny.DiscardUnknown(m)
}

var xxx_messageInfo_AppProfile_MultiClusterRoutingUseAny proto.InternalMessageInfo

// Unconditionally routes all read/write requests to a specific cluster.
// This option preserves read-your-writes consistency, but does not improve
// availability.
type AppProfile_SingleClusterRouting struct {
	// The cluster to which read/write requests should be routed.
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are
	// allowed by this app profile. It is unsafe to send these requests to
	// the same table/row/column in multiple clusters.
	AllowTransactionalWrites bool     `protobuf:"varint,2,opt,name=allow_transactional_writes,json=allowTransactionalWrites,proto3" json:"allow_transactional_writes,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *AppProfile_SingleClusterRouting) Reset()         { *m = AppProfile_SingleClusterRouting{} }
func (m *AppProfile_SingleClusterRouting) String() string { return proto.CompactTextString(m) }
func (*AppProfile_SingleClusterRouting) ProtoMessage()    {}
func (*AppProfile_SingleClusterRouting) Descriptor() ([]byte, []int) {
	return fileDescriptor_instance_f4854c7156f8ce96, []int{2, 1}
}
func (m *AppProfile_SingleClusterRouting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppProfile_SingleClusterRouting.Unmarshal(m, b)
}
func (m *AppProfile_SingleClusterRouting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppProfile_SingleClusterRouting.Marshal(b, m, deterministic)
}
func (dst *AppProfile_SingleClusterRouting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppProfile_SingleClusterRouting.Merge(dst, src)
}
func (m *AppProfile_SingleClusterRouting) XXX_Size() int {
	return xxx_messageInfo_AppProfile_SingleClusterRouting.Size(m)
}
func (m *AppProfile_SingleClusterRouting) XXX_DiscardUnknown() {
	xxx_messageInfo_AppProfile_SingleClusterRouting.DiscardUnknown(m)
}

var xxx_messageInfo_AppProfile_SingleClusterRouting proto.InternalMessageInfo

func (m *AppProfile_SingleClusterRouting) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *AppProfile_SingleClusterRouting) GetAllowTransactionalWrites() bool {
	if m != nil {
		return m.AllowTransactionalWrites
	}
	return false
}

func init() {
	proto.RegisterType((*Instance)(nil), "google.bigtable.admin.v2.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.bigtable.admin.v2.Instance.LabelsEntry")
	proto.RegisterType((*Cluster)(nil), "google.bigtable.admin.v2.Cluster")
	proto.RegisterType((*AppProfile)(nil), "google.bigtable.admin.v2.AppProfile")
	proto.RegisterType((*AppProfile_MultiClusterRoutingUseAny)(nil), "google.bigtable.admin.v2.AppProfile.MultiClusterRoutingUseAny")
	proto.RegisterType((*AppProfile_SingleClusterRouting)(nil), "google.bigtable.admin.v2.AppProfile.SingleClusterRouting")
	proto.RegisterEnum("google.bigtable.admin.v2.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Instance_Type", Instance_Type_name, Instance_Type_value)
	proto.RegisterEnum("google.bigtable.admin.v2.Cluster_State", Cluster_State_name, Cluster_State_value)
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/instance.proto", fileDescriptor_instance_f4854c7156f8ce96)
}

var fileDescriptor_instance_f4854c7156f8ce96 = []byte{
	// 765 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xdd, 0x8e, 0xdb, 0x44,
	0x14, 0x8e, 0xf3, 0xb3, 0x64, 0x4f, 0xca, 0xd6, 0x1a, 0x22, 0x94, 0x86, 0x16, 0x42, 0xa4, 0xaa,
	0xb9, 0x72, 0xa4, 0x20, 0x24, 0x4a, 0xd9, 0x4a, 0xf9, 0x71, 0x5b, 0x8b, 0xad, 0x13, 0x1c, 0xef,
	0xae, 0xba, 0x8a, 0x64, 0x4d, 0xec, 0x59, 0xcb, 0x62, 0x32, 0x63, 0x3c, 0x93, 0xac, 0x7c, 0xcb,
	0xe3, 0x70, 0xc5, 0x1d, 0x4f, 0xc0, 0x0d, 0x8f, 0xc3, 0x13, 0x20, 0x8f, 0x6d, 0x76, 0x17, 0x12,
	0xb4, 0xe2, 0x6e, 0xce, 0x39, 0xdf, 0x77, 0xbe, 0x33, 0xdf, 0xb1, 0x07, 0x5e, 0x84, 0x9c, 0x87,
	0x94, 0x0c, 0xd7, 0x51, 0x28, 0xf1, 0x9a, 0x92, 0x21, 0x0e, 0x36, 0x11, 0x1b, 0xee, 0x46, 0xc3,
	0x88, 0x09, 0x89, 0x99, 0x4f, 0x8c, 0x38, 0xe1, 0x92, 0xa3, 0x4e, 0x0e, 0x34, 0x4a, 0xa0, 0xa1,
	0x80, 0xc6, 0x6e, 0xd4, 0x7d, 0x5a, 0xb4, 0xc0, 0x71, 0x34, 0xc4, 0x8c, 0x71, 0x89, 0x65, 0xc4,
	0x99, 0xc8, 0x79, 0xdd, 0xe7, 0x07, 0x05, 0x7c, 0xbe, 0xd9, 0x70, 0x96, 0xc3, 0xfa, 0xbf, 0xd5,
	0xa0, 0x69, 0x15, 0x8a, 0x08, 0x41, 0x9d, 0xe1, 0x0d, 0xe9, 0x68, 0x3d, 0x6d, 0x70, 0xec, 0xa8,
	0x33, 0xfa, 0x12, 0x1e, 0x05, 0x91, 0x88, 0x29, 0x4e, 0x3d, 0x55, 0xab, 0xaa, 0x5a, 0xab, 0xc8,
	0xd9, 0x19, 0xe4, 0x35, 0x34, 0x84, 0xc4, 0x92, 0x74, 0x6a, 0x3d, 0x6d, 0x70, 0x32, 0x1a, 0x18,
	0x87, 0x46, 0x36, 0x4a, 0x25, 0x63, 0x99, 0xe1, 0x9d, 0x9c, 0x86, 0x5e, 0x41, 0x5d, 0xa6, 0x31,
	0xe9, 0xd4, 0x15, 0xfd, 0xc5, 0x03, 0xe8, 0x6e, 0x1a, 0x13, 0x47, 0x91, 0xd0, 0x1b, 0x38, 0xa2,
	0x78, 0x4d, 0xa8, 0xe8, 0x34, 0x7a, 0xb5, 0x41, 0x6b, 0x64, 0x3c, 0x80, 0x7e, 0xa6, 0x08, 0x26,
	0x93, 0x49, 0xea, 0x14, 0xec, 0xee, 0x4b, 0x68, 0xdd, 0x49, 0x23, 0x1d, 0x6a, 0x3f, 0x92, 0xb4,
	0x70, 0x22, 0x3b, 0xa2, 0x36, 0x34, 0x76, 0x98, 0x6e, 0x4b, 0x07, 0xf2, 0xe0, 0xdb, 0xea, 0x37,
	0x5a, 0xff, 0x6b, 0x68, 0xa8, 0xfb, 0xa0, 0x4f, 0xe0, 0xf1, 0xd2, 0x1d, 0xbb, 0xa6, 0x67, 0xcf,
	0x5d, 0xef, 0x7b, 0x7b, 0x7e, 0x69, 0xeb, 0x15, 0x74, 0x0c, 0x0d, 0xc7, 0x1c, 0xcf, 0x3e, 0xe8,
	0x1a, 0x7a, 0x04, 0xcd, 0xa9, 0x63, 0x8e, 0x5d, 0xcb, 0x7e, 0xab, 0x57, 0xfb, 0xa7, 0x50, 0xcf,
	0xee, 0x81, 0xda, 0xa0, 0xbb, 0x1f, 0x16, 0xa6, 0x77, 0x6e, 0x2f, 0x17, 0xe6, 0xd4, 0x7a, 0x63,
	0x99, 0x33, 0xbd, 0x82, 0x4e, 0x00, 0x16, 0xce, 0x7c, 0x76, 0x3e, 0x75, 0xad, 0xb9, 0xad, 0x6b,
	0xe8, 0x31, 0xb4, 0x66, 0xe6, 0x85, 0x79, 0x36, 0x5f, 0xbc, 0x37, 0x6d, 0x57, 0xaf, 0xf6, 0x7f,
	0xaf, 0xc2, 0x47, 0x53, 0xba, 0x15, 0x92, 0x24, 0x7b, 0x17, 0xd7, 0x85, 0x26, 0xe5, 0xbe, 0xfa,
	0x26, 0x8a, 0x91, 0xff, 0x8e, 0xd1, 0xe9, 0xfd, 0x8d, 0xfd, 0x87, 0xe5, 0x85, 0xc2, 0xfd, 0x85,
	0x7d, 0x01, 0x2d, 0x41, 0x92, 0x1d, 0xf1, 0x18, 0x0f, 0x88, 0x50, 0x7b, 0x6b, 0x38, 0xa0, 0x52,
	0x76, 0x96, 0x41, 0x97, 0xd0, 0x0e, 0xc8, 0x35, 0xde, 0x52, 0xe9, 0x09, 0xc9, 0x13, 0x1c, 0x12,
	0x4f, 0x6d, 0xb8, 0xa1, 0xe4, 0x9e, 0x1f, 0x96, 0x5b, 0xe6, 0x68, 0xb5, 0x5f, 0x54, 0xb4, 0xb8,
	0x93, 0xeb, 0xff, 0xf0, 0xbf, 0xac, 0xce, 0x22, 0xc7, 0x5c, 0x5a, 0x57, 0x59, 0x54, 0xcb, 0xa2,
	0x99, 0xb5, 0x1c, 0x4f, 0xce, 0xcc, 0x99, 0x5e, 0xef, 0xff, 0x59, 0x03, 0x18, 0xc7, 0xf1, 0x22,
	0xe1, 0xd7, 0x11, 0xdd, 0xff, 0x0f, 0x20, 0xa8, 0x13, 0x89, 0xc3, 0xc2, 0x46, 0x75, 0x46, 0x3d,
	0x68, 0x05, 0x44, 0xf8, 0x49, 0x14, 0x2b, 0x87, 0x6b, 0xc5, 0x6f, 0x71, 0x9b, 0x42, 0x3f, 0x6b,
	0xf0, 0x6c, 0xb3, 0xa5, 0x32, 0xf2, 0xfc, 0xdc, 0x44, 0x2f, 0xe1, 0x5b, 0x19, 0xb1, 0xd0, 0xdb,
	0x0a, 0xe2, 0x61, 0x96, 0x2a, 0x3b, 0x5a, 0xa3, 0xd7, 0x87, 0xed, 0xb8, 0x9d, 0xcb, 0x78, 0x9f,
	0x75, 0x2a, 0xb6, 0xe1, 0xe4, 0x7d, 0xce, 0x05, 0x19, 0xb3, 0xf4, 0x5d, 0xc5, 0x79, 0xb2, 0x39,
	0x54, 0x44, 0x3f, 0xc1, 0xa7, 0x22, 0x62, 0x21, 0x25, 0xff, 0x1c, 0xa2, 0x73, 0xa4, 0xc4, 0x5f,
	0x3e, 0x48, 0x7c, 0xa9, 0x5a, 0xdc, 0x17, 0x78, 0x57, 0x71, 0xda, 0x62, 0x4f, 0xbe, 0xfb, 0x19,
	0x3c, 0x39, 0x38, 0x6c, 0x57, 0x40, 0x7b, 0x5f, 0x33, 0xf4, 0x0c, 0xa0, 0x1c, 0x30, 0x0a, 0x0a,
	0xf3, 0x8f, 0x8b, 0x8c, 0x15, 0xa0, 0xef, 0xa0, 0x8b, 0x29, 0xe5, 0x37, 0x9e, 0x4c, 0x30, 0x13,
	0xd8, 0xcf, 0x0c, 0xc6, 0xd4, 0xbb, 0x49, 0x22, 0x49, 0x84, 0xda, 0x4b, 0xd3, 0xe9, 0x28, 0x84,
	0x7b, 0x17, 0x70, 0xa9, 0xea, 0x13, 0x1d, 0x4e, 0x4a, 0xeb, 0x63, 0x4e, 0x23, 0x3f, 0x9d, 0xfc,
	0xaa, 0xc1, 0x53, 0x9f, 0x6f, 0x0e, 0x5e, 0x7e, 0xf2, 0x71, 0xf9, 0x58, 0x2c, 0xb2, 0x67, 0x72,
	0xa1, 0x5d, 0x9d, 0x16, 0xd0, 0x90, 0x53, 0xcc, 0x42, 0x83, 0x27, 0xe1, 0x30, 0x24, 0x4c, 0x3d,
	0xa2, 0xc3, 0xbc, 0x84, 0xe3, 0x48, 0xfc, 0xfb, 0xb9, 0x7d, 0xa5, 0x0e, 0xbf, 0x54, 0x3f, 0x7f,
	0x9b, 0xf3, 0xa7, 0x94, 0x6f, 0x03, 0x63, 0x52, 0x0a, 0x8e, 0x95, 0xe0, 0xc5, 0xe8, 0x8f, 0x12,
	0xb0, 0x52, 0x80, 0x55, 0x09, 0x58, 0x29, 0xc0, 0xea, 0x62, 0xb4, 0x3e, 0x52, 0x5a, 0x5f, 0xfd,
	0x15, 0x00, 0x00, 0xff, 0xff, 0xd9, 0x04, 0x3d, 0xfc, 0x3a, 0x06, 0x00, 0x00,
}
