/*

Copyright (c) 2018, John Smith

Permission to use, copy, modify, and/or distribute this software for
any purpose with or without fee is hereby granted, provided that the
above copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR
BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/


#include "PresetsModel.h"

PresetsModel::PresetsModel(QObject *parent)
    : QAbstractListModel(parent)
{

}


int PresetsModel::rowCount(const QModelIndex &parent) const {
    if (parent.isValid())
        return 0;

    return (int)size();
}


QVariant PresetsModel::data(const QModelIndex &index, int role) const {
    if (role == Qt::DisplayRole) {
        return QVariant(QString::fromStdString(std::next(cbegin(), index.row())->second.name));
    }

    return QVariant();
}


QVariant PresetsModel::headerData(int section, Qt::Orientation orientation, int role) const {
    if (role == Qt::DisplayRole) {
        if (orientation == Qt::Horizontal) {
            if (section == 0) {
                return QVariant("Name");
            }
        } else if (orientation == Qt::Vertical) {
            return QVariant(section + 1);
        }
    }

    return QVariant();
}


void PresetsModel::insert(const value_type &preset) {
    PresetMap::const_iterator it = lower_bound(preset.first);

    if (it != cend() && it->first == preset.first)
        return;

    int new_row = 0;
    if (size())
        new_row = (int)std::distance(cbegin(), it);

    beginInsertRows(QModelIndex(), new_row, new_row);

    PresetMap::insert(it, preset);

    endInsertRows();
}


void PresetsModel::erase(const std::string &preset_name) {
    PresetMap::const_iterator it = find(preset_name);

    if (it == cend())
        return;

    int row = (int)std::distance(cbegin(), it);

    beginRemoveRows(QModelIndex(), row, row);

    PresetMap::erase(it);

    endRemoveRows();
}

void PresetsModel::clear() {
    if (!size()) return;

    beginRemoveRows(QModelIndex(), 0, size() - 1);
    PresetMap::clear();
    endRemoveRows();
}
