/*
 *  Copyright (C) 2015-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#pragma once

#include "addons/IAddon.h"
#include "settings/lib/ISettingCallback.h"

#include <functional>
#include <string>

namespace ADDON
{

const int AUTO_UPDATES_ON = 0;
const int AUTO_UPDATES_NOTIFY = 1;
const int AUTO_UPDATES_NEVER = 2;

enum class AddonRepoUpdateMode
{
  OFFICIAL_ONLY = 0,
  ANY_REPOSITORY = 1
};

class CAddonSystemSettings : public ISettingCallback
{
public:
  static CAddonSystemSettings& GetInstance();
  void OnSettingAction(const std::shared_ptr<const CSetting>& setting) override;
  void OnSettingChanged(const std::shared_ptr<const CSetting>& setting) override;

  bool GetActive(const TYPE& type, AddonPtr& addon);
  bool SetActive(const TYPE& type, const std::string& addonID);
  bool IsActive(const IAddon& addon);

  /*!
   * Gets Kodi addon auto update mode
   *
   * @return the autoupdate mode value
  */
  int GetAddonAutoUpdateMode() const;


  /*!
   * Gets Kodi preferred addon repository update mode
   *
   * @return the preferred mode value
   */
  AddonRepoUpdateMode GetAddonRepoUpdateMode() const;

  /*!
   * Attempt to unset addon as active. Returns true if addon is no longer active,
   * false if it could not be unset (e.g. if the addon is the default)
   */
  bool UnsetActive(const AddonInfoPtr& addon);

private:
  CAddonSystemSettings();
  CAddonSystemSettings(const CAddonSystemSettings&) = delete;
  CAddonSystemSettings& operator=(const CAddonSystemSettings&) = delete;
  ~CAddonSystemSettings() override = default;

  const std::map<ADDON::TYPE, std::string> m_activeSettings;
};
};
